/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.model.standard.helpers.PasswordHelper;
import com.gridnine.xtrip.common.util.RandomUtil;
import java.util.regex.Pattern;

public class PasswordPolicyHelper {
    public static final int MIN_LENGTH = 8;
    private static final Pattern PATTERN_INVALID_CHARACTERS = Pattern.compile("[\\|]");

    public static boolean checkPassword(String password) {
        return password.length() >= 8 && PasswordHelper.PATTERN_LOWER.matcher(password).find() && PasswordHelper.PATTERN_UPPER.matcher(password).find() && PasswordHelper.PATTERN_NUM.matcher(password).find() && PasswordHelper.PATTERN_SPECIAL.matcher(password).find();
    }

    public static boolean hasInvalidCharacters(String password) {
        return PATTERN_INVALID_CHARACTERS.matcher(password).find();
    }

    public static boolean checkPassword(char[] password) {
        return PasswordPolicyHelper.checkPassword(new String(password));
    }

    public static String passwordGenerator() {
        String pwd;
        while (!PasswordPolicyHelper.checkPassword(pwd = RandomUtil.getRandomString((RandomUtil.Chars)RandomUtil.Chars.LATIN_ALPHA_UPPER_LOWER_NUM_SPEC, (int)8, (int)20))) {
        }
        return pwd;
    }
}

