/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableName;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;

public class PersonalLocalizableNameFormatter {
    public static final String SIMPLE = "L f m";
    public static final String FULL = "L F M";
    private final String pattern;

    public PersonalLocalizableNameFormatter() {
        this(SIMPLE);
    }

    public PersonalLocalizableNameFormatter(String pattern) {
        this.pattern = pattern;
    }

    public String format(PersonalLocalizableName name, Locale locale, boolean strict) {
        return this.format(name, locale, strict, true);
    }

    public String format(PersonalLocalizableName name, Locale locale, boolean strict, boolean removeSeparators) {
        return this.format(name, l10nString -> L10nStringHelper.getValue((L10nString)l10nString, (Locale)locale, (boolean)strict));
    }

    public String formatAnyLocale(PersonalLocalizableName name) {
        return this.format(name, l10nString -> {
            Set entries = l10nString.getValues().entrySet();
            return entries.isEmpty() ? null : (String)entries.iterator().next().getValue();
        });
    }

    private String format(PersonalLocalizableName name, Function<L10nString, String> l10nResolver) {
        StringBuilder formattedName = new StringBuilder();
        int lastFieldIndex = -1;
        boolean fieldAppended = false;
        for (int i = 0; i < this.pattern.length(); ++i) {
            String field = this.pattern.substring(i, i + 1);
            boolean fieldFound = false;
            String token = null;
            if (field.equals("F") || field.equals("f")) {
                token = l10nResolver.apply(name.getFirstName());
                if (!TextUtil.isBlank((String)token)) {
                    token = token.trim();
                    if (field.equals("f")) {
                        token = token.substring(0, 1) + ".";
                    }
                }
                fieldFound = true;
            } else if (field.equals("L") || field.equals("l")) {
                token = l10nResolver.apply(name.getLastName());
                if (!TextUtil.isBlank((String)token)) {
                    token = token.trim();
                    if (field.equals("l")) {
                        token = token.substring(0, 1) + ".";
                    }
                }
                fieldFound = true;
            } else if (field.equals("M") || field.equals("m")) {
                token = l10nResolver.apply(name.getMiddleName());
                if (!TextUtil.isBlank((String)token)) {
                    token = token.trim();
                    if (field.equals("m")) {
                        token = token.substring(0, 1) + ".";
                    }
                }
                fieldFound = true;
            } else if (field.equals("S") || field.equals("s")) {
                token = l10nResolver.apply(name.getSecondName());
                if (!TextUtil.isBlank((String)token)) {
                    token = token.trim();
                    if (field.equals("s")) {
                        token = token.substring(0, 1) + ".";
                    }
                }
                fieldFound = true;
            }
            if (fieldFound) {
                if (lastFieldIndex == -1 || token != null && fieldAppended) {
                    formattedName.append(this.pattern.substring(lastFieldIndex + 1, i));
                }
                if (token != null) {
                    formattedName.append(token);
                    fieldAppended = true;
                }
                lastFieldIndex = i;
                continue;
            }
            if (i != this.pattern.length() - 1) continue;
            formattedName.append(this.pattern.substring(lastFieldIndex + 1));
        }
        return formattedName.toString();
    }
}

