/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.util.PersonalName;
import com.gridnine.xtrip.common.util.TextUtil;

public class PersonalNameFormat {
    public static final String SIMPLE = "L f s m";
    public static final String FULL = "L F S M";
    private final String pattern;

    public PersonalNameFormat() {
        this(SIMPLE);
    }

    public PersonalNameFormat(String pattern) {
        this.pattern = pattern;
    }

    public String format(PersonalName name) {
        return this.format(name, true);
    }

    public String format(PersonalName name, boolean removeSeparators) {
        StringBuilder formattedName = new StringBuilder();
        int lastFieldIndex = -1;
        boolean fieldAppended = false;
        for (int i = 0; i < this.pattern.length(); ++i) {
            String field = this.pattern.substring(i, i + 1);
            boolean fieldFound = false;
            String token = null;
            if (field.equals("F") || field.equals("f")) {
                token = name.getFirstName();
                if (!TextUtil.isBlank((String)token)) {
                    token = token.trim();
                    if (field.equals("f")) {
                        token = token.substring(0, 1) + ".";
                    }
                }
                fieldFound = true;
            } else if (field.equals("L") || field.equals("l")) {
                token = name.getLastName();
                if (!TextUtil.isBlank((String)token)) {
                    token = token.trim();
                    if (field.equals("l")) {
                        token = token.substring(0, 1) + ".";
                    }
                }
                fieldFound = true;
            } else if (field.equals("M") || field.equals("m")) {
                token = name.getMiddleName();
                if (!TextUtil.isBlank((String)token)) {
                    token = token.trim();
                    if (field.equals("m")) {
                        token = token.substring(0, 1) + ".";
                    }
                }
                fieldFound = true;
            } else if (field.equals("S") || field.equals("s")) {
                token = name.getSecondName();
                if (!TextUtil.isBlank((String)token)) {
                    token = token.trim();
                    if (field.equals("s")) {
                        token = token.substring(0, 1) + ".";
                    }
                }
                fieldFound = true;
            }
            if (fieldFound) {
                if (lastFieldIndex == -1 || token != null && fieldAppended) {
                    formattedName.append(this.pattern.substring(lastFieldIndex + 1, i));
                }
                if (token != null) {
                    formattedName.append(token);
                    fieldAppended = true;
                }
                lastFieldIndex = i;
                continue;
            }
            if (i != this.pattern.length() - 1) continue;
            formattedName.append(this.pattern.substring(lastFieldIndex + 1));
        }
        return formattedName.toString();
    }
}

