/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.TimeService;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ManagerType;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.BaseRulesContainer;
import com.gridnine.xtrip.common.model.profile.ContractIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.PCCIndex;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.SalesPointIndex;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.model.system.Metadata;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class ProfileDao {
    public static Person getEmployee(EntityReference<Organization> organization, ManagerType position, Date date) {
        List<Person> employees = ProfileDao.getEmployees(organization, position, date);
        return employees.isEmpty() ? null : employees.get(0);
    }

    public static List<Person> getEmployees(EntityReference<Organization> organization, ManagerType position, Date date) {
        return ProfileDao.getEmployees(organization, new ManagerType[]{position}, date);
    }

    public static Person getEmployee(EntityReference<Organization> organization, ManagerType[] positions, Date date) throws Exception {
        List<Person> employees = ProfileDao.getEmployees(organization, positions, date);
        return employees.isEmpty() ? null : employees.get(0);
    }

    public static List<Person> getEmployees(EntityReference<Organization> organization, ManagerType[] positions, Date date) {
        ArrayList<Person> employees = new ArrayList<Person>();
        List<EntityContainer<Person>> employeeContainers = ProfileDao.getEmployeeContainers(organization, positions, date);
        for (EntityContainer<Person> employeeContiner : employeeContainers) {
            employees.add((Person)employeeContiner.getEntity());
        }
        return employees;
    }

    public static EntityReference<Person> getEmployeeReference(EntityReference<Organization> organization, ManagerType position, Date date) throws Exception {
        List<EntityReference<Person>> employees = ProfileDao.getEmployeeReferences(organization, position, date);
        return employees.isEmpty() ? null : employees.get(0);
    }

    public static List<EntityReference<Person>> getEmployeeReferences(EntityReference<Organization> organization, ManagerType position, Date date) throws Exception {
        return ProfileDao.getEmployeeReferences(organization, new ManagerType[]{position}, date);
    }

    public static EntityReference<Person> getEmployeeReference(EntityReference<Organization> organization, ManagerType[] positions, Date date) throws Exception {
        List<EntityReference<Person>> employees = ProfileDao.getEmployeeReferences(organization, positions, date);
        return employees.isEmpty() ? null : employees.get(0);
    }

    public static List<EntityReference<Person>> getEmployeeReferences(EntityReference<Organization> organization, ManagerType[] positions, Date date) throws Exception {
        ArrayList<EntityReference<Person>> employees = new ArrayList<EntityReference<Person>>();
        List<EntityContainer<Person>> employeeContainers = ProfileDao.getEmployeeContainers(organization, positions, date);
        for (EntityContainer<Person> employeeContiner : employeeContainers) {
            employees.add((EntityReference<Person>)employeeContiner.toReference());
        }
        return employees;
    }

    public static EntityContainer<Person> getEmployeeContainer(EntityReference<Organization> organization, ManagerType position, Date date) throws Exception {
        List<EntityContainer<Person>> employeeContainers = ProfileDao.getEmployeeContainers(organization, position, date);
        return employeeContainers.isEmpty() ? null : employeeContainers.get(0);
    }

    public static List<EntityContainer<Person>> getEmployeeContainers(EntityReference<Organization> organization, ManagerType position, Date date) throws Exception {
        return ProfileDao.getEmployeeContainers(organization, new ManagerType[]{position}, date);
    }

    public static EntityContainer<Person> getEmployeeContainer(EntityReference<Organization> organization, ManagerType[] positions, Date date) throws Exception {
        List<EntityContainer<Person>> employeeContainers = ProfileDao.getEmployeeContainers(organization, positions, date);
        return employeeContainers.isEmpty() ? null : employeeContainers.get(0);
    }

    public static List<EntityContainer<Person>> getEmployeeContainers(EntityReference<Organization> organization, ManagerType[] positions, Date date) {
        if (organization == null) {
            return Collections.emptyList();
        }
        ArrayList<EntityContainer<Person>> employeeContainers = new ArrayList<EntityContainer<Person>>();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.contains((String)PersonIndex.Property.employmentsUids.name(), (Object)organization.getUid()));
        ArrayList<String> positionNames = new ArrayList<String>();
        if (positions != null) {
            ArrayList<SearchCriterion> criterions = new ArrayList<SearchCriterion>();
            for (ManagerType position : positions) {
                criterions.add(SearchCriterion.contains((String)PersonIndex.Property.positions.name(), (Object)position.name()));
                positionNames.add(position.name());
            }
            if (criterions.size() > 0) {
                query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()])));
            }
        }
        query.getCriteria().getOrders().put(PersonIndex.Property.code.name(), SortOrder.ASC);
        List employeeIndexes = EntityStorage.get().search(PersonIndex.class, query).getData();
        block1: for (PersonIndex employeeIndex : employeeIndexes) {
            EntityContainer employeeContainer = EntityStorage.get().resolve(employeeIndex.getSource());
            if (employeeContainer == null) continue;
            Person employee = (Person)employeeContainer.getEntity();
            List employments = employee.getEmployments();
            for (PersonEmployment employment : employments) {
                EntityReference employmentOrganization = employment.getOrganization();
                if (employmentOrganization == null || !employmentOrganization.equals(organization)) continue;
                DictionaryReference employmentPosition = employment.getPosition();
                if (positions != null && !positionNames.isEmpty() && (employmentPosition == null || !positionNames.contains(employmentPosition.getCode()))) continue;
                Date employmentOpened = employment.getOpened();
                Date employmentClosed = employment.getClosed();
                if (date != null && !MiscUtil.isBetween((Date)employmentOpened, (Date)employmentClosed, (Date)date)) continue;
                employeeContainers.add((EntityContainer<Person>)employeeContainer);
                continue block1;
            }
        }
        return employeeContainers;
    }

    public static EntityReference<Organization> findAllClientsProfile() {
        String uid = DictHelper.getPreferenceValue(PreferenceKey.ALL_CLIENTS_PROFILE_UID, null);
        if (uid == null) {
            return null;
        }
        EntityReference result = new EntityReference(uid, Organization.class, "All Clients Profile");
        EntityStorage.get().actualize(result);
        return result;
    }

    public static EntityReference<Organization> findAllAgenciesProfile() {
        String uid = DictHelper.getPreferenceValue(PreferenceKey.ALL_AGENCIES_PROFILE_UID, null);
        if (uid == null) {
            return null;
        }
        EntityReference result = new EntityReference(uid, Organization.class, "All Agencies Profile");
        EntityStorage.get().actualize(result);
        return result;
    }

    public static DictionaryReference<Airline> findAllAirlinesProfile() {
        String code = DictHelper.getPreferenceValue(PreferenceKey.ALL_AIRLINES_PROFILE_UID, null);
        if (null == code) {
            return null;
        }
        Airline airline = (Airline)DictionaryCache.get().findByCode(Airline.class, code);
        return airline != null ? airline.toReference() : new AirlineReference(code, "All Airlines Profile");
    }

    public static EntityReference<SalesPoint> findMainSalesPoint(EntityReference<Organization> agency) throws Exception {
        if (agency == null) {
            return null;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)SalesPointIndex.Property.agency.name(), agency));
        List salesPointIndexes = EntityStorage.get().search(SalesPointIndex.class, query).getData();
        for (SalesPointIndex salesPointIndex : salesPointIndexes) {
            EntityReference salesPointReference = salesPointIndex.getSource();
            EntityContainer salesPointContainer = EntityStorage.get().resolve(salesPointReference);
            if (salesPointContainer == null) continue;
            SalesPoint salesPoint = (SalesPoint)salesPointContainer.getEntity();
            for (Metadata metadata : salesPoint.getMetadata()) {
                if (metadata.getKey() == null || !metadata.getKey().getCode().equals(MetadataKey.KEY_MAIN_SALES_POINT.name()) || metadata.getValue() == null || !(metadata.getValue() instanceof Boolean) || !((Boolean)metadata.getValue()).booleanValue()) continue;
                return salesPointReference;
            }
        }
        return null;
    }

    public static EntityReference<Organization> findMainAgency(String pcc, Predicate<Organization> orgFilter) {
        ArrayList indexes;
        EntityReference result = null;
        if (TextUtil.isBlank((String)pcc)) {
            return null;
        }
        SearchQuery query = new SearchQuery();
        Date currentDate = ((TimeService)Environment.getPublished(TimeService.class)).currentDate();
        query.getCriteria().getCriterions().add(SearchCriterion.ieq((String)PCCIndex.Property.code.name(), (String)pcc));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)PCCIndex.Property.opened.name(), null), SearchCriterion.le((String)PCCIndex.Property.opened.name(), (Object)MiscUtil.setDayEndTime((Date)currentDate))}));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)PCCIndex.Property.closed.name(), null), SearchCriterion.ge((String)PCCIndex.Property.closed.name(), (Object)MiscUtil.clearTime((Date)currentDate))}));
        try {
            indexes = EntityStorage.get().search(PCCIndex.class, query).getData();
        }
        catch (Throwable e) {
            indexes = new ArrayList();
        }
        if (indexes.size() > 0) {
            if (orgFilter == null) {
                result = ((PCCIndex)indexes.get(0)).getAgency() != null ? ((PCCIndex)indexes.get(0)).getAgency() : ((PCCIndex)indexes.get(0)).getSubAgency();
            } else {
                for (PCCIndex index : indexes) {
                    EntityReference orgRef = index.getAgency() != null ? index.getAgency() : index.getSubAgency();
                    EntityContainer orgCtr = EntityStorageHelper.resolve((EntityReference)orgRef);
                    if (EntityStorageHelper.isEmpty((EntityContainer)orgCtr) || !orgFilter.test((Organization)orgCtr.getEntity())) continue;
                    result = orgRef;
                    break;
                }
            }
        }
        return result;
    }

    public static EntityReference<Organization> findMainAgency(String pcc) {
        return ProfileDao.findMainAgency(pcc, null);
    }

    public static List<ContractIndex> getSupplierContracts(EntityContainer<Organization> ctr) {
        List<ContractIndex> contractIndexList = ProfileDao.searchSupplierContracts((EntityReference<Organization>)ctr.toReference());
        if (((Organization)ctr.getEntity()).getTypes().contains(OrganizationType.CORPORATE_CLIENT) && !ProfileHelper.isRetailProfile(ctr)) {
            EntityReference<Organization> allAgenciesProfile = ProfileDao.findAllAgenciesProfile();
            EntityReference<Organization> allClientsProfile = ProfileDao.findAllClientsProfile();
            contractIndexList.addAll(ProfileDao.searchContracts((EntityReference<Organization>)ctr.toReference(), allAgenciesProfile));
            contractIndexList.addAll(ProfileDao.searchContracts(allClientsProfile, allAgenciesProfile));
        }
        return contractIndexList;
    }

    public static List<ContractIndex> searchSupplierContracts(EntityReference<Organization> customer) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.customer.name(), customer));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ContractIndex.Property.supplier.name(), null));
        query.getPreferredProperties().add(ContractIndex.Property.supplier.name());
        query.getPreferredProperties().add(ContractIndex.Property.newModel.name());
        return EntityStorage.get().search(ContractIndex.class, query).getData();
    }

    public static List<ContractIndex> searchContracts(EntityReference<Organization> customer, EntityReference<Organization> supplier) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.customer.name(), customer));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ContractIndex.Property.customer.name(), null));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.supplier.name(), supplier));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ContractIndex.Property.supplier.name(), null));
        query.getPreferredProperties().add(ContractIndex.Property.supplier.name());
        query.getPreferredProperties().add(ContractIndex.Property.newModel.name());
        return EntityStorage.get().search(ContractIndex.class, query).getData();
    }

    public static Stream<RuleSettings> getCommissionsRuleSettingsStream(EntityContainer<? extends BaseRulesContainer> ruleContainer, Date date) {
        return Stream.of(ruleContainer).filter(Objects::nonNull).map(EntityContainer::getEntity).map(BaseRulesContainer::getRuleSet).filter(Objects::nonNull).map(RuleSet::getRules).flatMap(Collection::stream).filter(Objects::nonNull).filter(rs -> rs.getTarget() != null).filter(rs -> MiscUtil.isBetween((Date)rs.getPeriodBegin(), (Date)rs.getPeriodEnd(), (Date)date)).filter(rs -> !rs.getResults().isEmpty() && rs.getResults().stream().anyMatch(res -> res.getValue() instanceof RuleResultValue));
    }

    public static void fillCommissionsRuleSettingsData(RuleSettings ruleSettings, List<String> commissionsProperties, List<String> values) {
        DecimalFormat priceFormat = LocaleManager.get().getCurrentLocaleData().getPriceFormat();
        DecimalFormat percentFormat = new DecimalFormat("#,##0.000");
        ruleSettings.getResults().stream().map(RuleResult::getValue).filter(RuleResultValue.class::isInstance).map(RuleResultValue.class::cast).forEach(rrv -> {
            commissionsProperties.add(rrv.getTarget() == null ? "" : rrv.getTarget().getCaption());
            if (rrv.getFopValues() != null) {
                values.add(L10n.get((String)"RULE_RESULT_COMPLEX_VALUE"));
            } else {
                DecimalFormat decimalFormat = rrv.getCurrencyCode() != null && !"%".equals(rrv.getCurrencyCode()) ? priceFormat : percentFormat;
                String unit = rrv.getCurrencyCode() != null ? rrv.getCurrencyCode() : "%";
                values.add(decimalFormat.format(rrv.getValue()) + " " + unit);
            }
        });
    }
}

