/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.model.dict.CommonReasonCode;
import com.gridnine.xtrip.common.model.profile.ReasonCode;
import com.gridnine.xtrip.common.model.profile.ReasonCodeComparisonType;
import com.gridnine.xtrip.common.util.LocaleUtil;
import java.util.Comparator;

public class ReasonCodeHelper {
    public static final Comparator<ReasonCode> REASON_CODE_COMPARATOR = (reasonCode1, reasonCode2) -> {
        ReasonCodeComparisonType comparisonType2;
        ReasonCodeComparisonType comparisonType1 = reasonCode1.getComparisonType();
        if (comparisonType1 == (comparisonType2 = reasonCode2.getComparisonType())) {
            return 0;
        }
        if (comparisonType1 == null) {
            return 1;
        }
        if (comparisonType2 == null) {
            return -1;
        }
        if (comparisonType1 == ReasonCodeComparisonType.AFS) {
            return -1;
        }
        return 1;
    };

    public static ReasonCode newReasonCode(CommonReasonCode crc) {
        ReasonCode result = new ReasonCode();
        result.setName(crc.getCode());
        result.setType(crc.getType());
        result.setComparisonType(crc.getComparisonType() != null ? crc.getComparisonType() : ReasonCodeComparisonType.AFS);
        result.setSabreName(crc.getSabreName());
        result.getRemarks().getValues().put(LocaleUtil.LOCALE_RU, crc.getDescription());
        return result;
    }
}

