/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public class SabreMaskHelper {
    private final Supplier<String> supplier;
    private String text;
    private final List<Char> chars = new ArrayList<Char>();

    public SabreMaskHelper(Supplier<String> maskSupplier) {
        this.supplier = maskSupplier;
    }

    public List<Char> getChars() {
        return this.chars;
    }

    public void actualizeMask() {
        String maskText = this.supplier.get();
        if (TextUtil.isBlank((String)maskText)) {
            this.text = null;
            this.chars.clear();
        } else if (!maskText.equals(this.text)) {
            this.text = maskText;
            this.chars.clear();
            boolean escape = false;
            block10: for (char ch : this.text.toCharArray()) {
                if (escape) {
                    escape = false;
                    this.chars.add(new CharFixed(ch));
                    continue;
                }
                switch (ch) {
                    case '#': {
                        this.chars.add(new CharNum());
                        continue block10;
                    }
                    case '\'': {
                        escape = true;
                        continue block10;
                    }
                    case 'U': {
                        this.chars.add(new CharUpper());
                        continue block10;
                    }
                    case 'L': {
                        this.chars.add(new CharLower());
                        continue block10;
                    }
                    case 'A': {
                        this.chars.add(new CharAlphaNum());
                        continue block10;
                    }
                    case '?': {
                        this.chars.add(new CharAlpha());
                        continue block10;
                    }
                    case '*': {
                        this.chars.add(new CharAny());
                        continue block10;
                    }
                    case 'H': {
                        this.chars.add(new CharHex());
                        continue block10;
                    }
                    default: {
                        this.chars.add(new CharFixed(ch));
                    }
                }
            }
        }
    }

    public boolean isValid(String value) {
        this.actualizeMask();
        if (this.chars.isEmpty()) {
            return true;
        }
        if (value == null) {
            return false;
        }
        if (this.chars.size() != value.length()) {
            return false;
        }
        for (int i = 0; i < this.chars.size(); ++i) {
            if (this.chars.get(i).isValid(value.charAt(i))) continue;
            return false;
        }
        return true;
    }

    static class CharHex
    extends Char {
        CharHex() {
        }

        @Override
        public char correct(char ch) {
            return this.isValid(ch) ? ch : (char)'\u2666';
        }

        @Override
        boolean isValid(char ch) {
            return this.isDigit(ch) || ch >= 'A' && ch <= 'F' || ch >= 'a' && ch <= 'f';
        }
    }

    static class CharAny
    extends Char {
        CharAny() {
        }

        @Override
        public char correct(char ch) {
            return ch;
        }

        @Override
        boolean isValid(char ch) {
            return true;
        }
    }

    static class CharAlpha
    extends Char {
        CharAlpha() {
        }

        @Override
        public char correct(char ch) {
            return this.isValid(ch) ? ch : (char)'\u2666';
        }

        @Override
        boolean isValid(char ch) {
            return this.isUpper(ch) || this.isLower(ch);
        }
    }

    static class CharAlphaNum
    extends Char {
        CharAlphaNum() {
        }

        @Override
        public char correct(char ch) {
            return this.isValid(ch) ? ch : (char)'\u2666';
        }

        @Override
        boolean isValid(char ch) {
            return this.isDigit(ch) || this.isUpper(ch) || this.isLower(ch);
        }
    }

    static class CharLower
    extends Char {
        CharLower() {
        }

        @Override
        public char correct(char ch) {
            if (this.isLower(ch)) {
                return ch;
            }
            if (this.isUpper(ch)) {
                return Character.toLowerCase(ch);
            }
            return '\u2666';
        }

        @Override
        boolean isValid(char ch) {
            return this.isLower(ch);
        }
    }

    static class CharUpper
    extends Char {
        CharUpper() {
        }

        @Override
        public char correct(char ch) {
            if (this.isUpper(ch)) {
                return ch;
            }
            if (this.isLower(ch)) {
                return Character.toUpperCase(ch);
            }
            return '\u2666';
        }

        @Override
        boolean isValid(char ch) {
            return this.isUpper(ch);
        }
    }

    static class CharNum
    extends Char {
        CharNum() {
        }

        @Override
        public char correct(char ch) {
            return this.isValid(ch) ? ch : (char)'\u2666';
        }

        @Override
        boolean isValid(char ch) {
            return this.isDigit(ch);
        }
    }

    static class CharFixed
    extends Char {
        private final char fixedChar;

        CharFixed(char ch) {
            this.fixedChar = ch;
        }

        @Override
        public char correct(char ch) {
            return this.fixedChar;
        }

        @Override
        boolean isValid(char ch) {
            return this.fixedChar == ch;
        }
    }

    public static abstract class Char {
        public static final char STUB = '\u2666';

        boolean isDigit(char ch) {
            return ch >= '0' && ch <= '9';
        }

        boolean isUpper(char ch) {
            return ch >= 'A' && ch <= 'Z';
        }

        boolean isLower(char ch) {
            return ch >= 'a' && ch <= 'z';
        }

        public abstract char correct(char var1);

        abstract boolean isValid(char var1);
    }
}

