/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleData;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.VersionInfo;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.PersonMetadata;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.standard.helpers.SystemSettingsHelper;
import com.gridnine.xtrip.common.model.system.BaseSystemSettings;
import com.gridnine.xtrip.common.model.system.BasicSystemSettingsIndex;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Metadata;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.MetadataKeyDescriptorReference;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.NamedValue;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.system.model.RegionalSettings;
import com.gridnine.xtrip.common.system.model.RegionalType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.LoggerFactory;

public final class SystemHelper {
    private static final Comparator<Locale> LOCALES_COMPARATOR = (o1, o2) -> TextUtil.compare((String)SystemHelper.toString(o1), (String)SystemHelper.toString(o2), (boolean)false, (boolean)true);

    public static Message createMessage(MessageType messageType, String key, Object ... parameters) {
        return MessagesHelper.createMessage((MessageType)messageType, (String)key, null, (Object[])parameters);
    }

    public static File getDefaultExportFolder() {
        File result = new File(Environment.getDataFolder(), "export/");
        if (!result.exists() && !result.mkdirs()) {
            LoggerFactory.getLogger(SystemHelper.class).error("unable to create export directory " + result);
            return Environment.getDataFolder();
        }
        return result;
    }

    @Deprecated
    public static Message createMessage(MessageType messageType, String key, Throwable error, Object ... parameters) {
        return MessagesHelper.createMessage((MessageType)messageType, (String)key, (Throwable)error, (Object[])parameters);
    }

    @Deprecated
    public static Message createMessage(MessageType messageType, L10nMessage message, Throwable error) {
        return MessagesHelper.createMessage((MessageType)messageType, (L10nMessage)message, (Throwable)error);
    }

    @Deprecated
    public static Message createMessageWithDetails(MessageType messageType, String key, String details, Object ... parameters) {
        return MessagesHelper.createMessageWithDetails((MessageType)messageType, (String)key, (String)details, (Object[])parameters);
    }

    public static Money getMoney(double amount, String currency) {
        Money result = new Money();
        result.setCurrency(currency);
        result.setValue(BigDecimal.valueOf(amount));
        return result;
    }

    public static Money getMoney(BigDecimal amount, String currency) {
        Money result = new Money();
        result.setCurrency(currency);
        result.setValue(amount);
        return result;
    }

    public static String toString(Locale locale) {
        if (locale == null) {
            return null;
        }
        String result = locale.getDisplayName(LocaleManager.get().getCurrentLocale());
        if (!TextUtil.isBlank((String)result)) {
            return result;
        }
        result = locale.getDisplayName();
        if (!TextUtil.isBlank((String)result)) {
            return result;
        }
        return locale.getCountry();
    }

    public static List<Locale> getAvailableLocales() {
        ArrayList<Locale> result = new ArrayList<Locale>();
        for (LocaleData data : LocaleManager.get().getSupportedLocales()) {
            result.add(data.getLocale());
        }
        Collections.sort(result, LOCALES_COMPARATOR);
        return result;
    }

    public static <T> T getMetadata(Collection<Metadata> coll, MetadataKey key) {
        if (key == null) {
            return null;
        }
        for (Metadata meta : coll) {
            if (meta.getKey() == null || !key.name().equals(meta.getKey().getCode())) continue;
            return (T)meta.getValue();
        }
        return null;
    }

    public static <T> T getPersonMetadata(Collection<PersonMetadata> coll, MetadataKey key) {
        if (key == null) {
            return null;
        }
        for (PersonMetadata meta : coll) {
            if (meta.getKey() == null || !key.name().equals(meta.getKey().getCode())) continue;
            return (T)meta.getValue();
        }
        return null;
    }

    public static String findMetadataAsString(Collection<Metadata> coll, MetadataKey key) {
        if (key == null || null == coll) {
            return null;
        }
        for (Metadata meta : coll) {
            if (meta.getKey() == null || !key.name().equals(meta.getKey().getCode())) continue;
            return meta.getValue() == null ? null : meta.getValue().toString();
        }
        return null;
    }

    public static Boolean getMetadataAsBoolean(Collection<Metadata> coll, MetadataKey key) {
        if (key == null) {
            return null;
        }
        for (Metadata meta : coll) {
            if (meta.getKey() == null || !key.name().equals(meta.getKey().getCode())) continue;
            return (Boolean)meta.getValue();
        }
        return null;
    }

    public static List<String> getMetadataAsStringsCollection(Collection<Metadata> coll, MetadataKey key) {
        if (key == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Metadata meta : coll) {
            if (meta.getKey() == null || !key.name().equals(meta.getKey().getCode()) || meta.getValue() == null) continue;
            result.add(meta.getValue().toString());
        }
        return result;
    }

    public static void addMessage(Collection<Message> messages, String message, String details, MessageType type, Object ... parameters) {
        if (messages == null) {
            return;
        }
        Message result = new Message();
        result.setType(type);
        result.setMessage(L10nResourcesManager.createL10nMessage((String)message, (Object[])parameters));
        result.setDetails(details);
        if (messages.contains(result)) {
            return;
        }
        messages.add(result);
    }

    public static void addExceptionMessage(List<Message> messages, String message, Exception exception, MessageType type, Object ... parameters) {
        SystemHelper.addMessage(messages, message, TextUtil.getExceptionStackTrace((Throwable)exception), type, parameters);
    }

    public static String findValue(Collection<NamedValue> values, String name) {
        for (NamedValue nv : values) {
            if (!nv.getName().equals(name)) continue;
            return nv.getValue();
        }
        return null;
    }

    public static void removeValue(Collection<NamedValue> values, String name) {
        SystemHelper.setValue(values, name, null);
    }

    public static void setValue(Collection<NamedValue> values, String name, String value) {
        if (value == null) {
            Iterator<NamedValue> it = values.iterator();
            while (it.hasNext()) {
                NamedValue nv = it.next();
                if (!nv.getName().equals(name)) continue;
                it.remove();
            }
            return;
        }
        boolean set = false;
        Iterator<NamedValue> it = values.iterator();
        while (it.hasNext()) {
            NamedValue nv = it.next();
            if (!nv.getName().equals(name)) continue;
            if (set) {
                it.remove();
                continue;
            }
            nv.setValue(value);
            set = true;
        }
        if (!set) {
            NamedValue nv = new NamedValue();
            nv.setName(name);
            nv.setValue(value);
            values.add(nv);
        }
    }

    public static void setMetadataValue(Collection<Metadata> values, MetadataKey key, Object value) {
        if (key == null) {
            return;
        }
        Metadata metadata = null;
        Iterator<Metadata> it = values.iterator();
        while (it.hasNext()) {
            Metadata data = it.next();
            if (data.getKey() == null || !data.getKey().getCode().equals(key.name())) continue;
            if (metadata == null) {
                metadata = data;
            }
            it.remove();
        }
        if (value == null) {
            return;
        }
        if (metadata == null) {
            metadata = new Metadata();
            metadata.setKey((DictionaryReference)new MetadataKeyDescriptorReference(key.name()));
        }
        values.add(metadata);
        metadata.setValue(value);
    }

    public static <E extends BaseSystemSettings> EntityReference<E> createSystemSettingsRererence(Class<E> cls) {
        String uid = cls.getName();
        EntityType et = MetaRegistryHelper.getEntityType((String)cls.getName());
        String caption = et == null ? MiscUtil.getSimpleClassName(cls) : et.getDisplayName();
        return new EntityReference(uid, cls, caption);
    }

    private SystemHelper() {
    }

    public static boolean isModifiedByThirdPartyProcess(VersionInfo existingVersionInfo, VersionInfo editedVersionInfo) {
        if (existingVersionInfo.getVersionNumber() > editedVersionInfo.getVersionNumber()) {
            return true;
        }
        if (!TextUtil.isSame((String)existingVersionInfo.getCreatedBy(), (String)editedVersionInfo.getCreatedBy())) {
            return true;
        }
        return existingVersionInfo.getModified() != null && editedVersionInfo.getModified() != null && existingVersionInfo.getModified().after(editedVersionInfo.getModified());
    }

    @Deprecated
    public static boolean isCheckThirdPartyChange() {
        return SystemSettingsHelper.isCheckThirdPartyChange();
    }

    public static boolean isRussianInstallation() {
        Country country = (Country)DictionaryCache.get().resolveReference((DictionaryReference)DictHelper.getRuRef());
        return country != null && country.isDomestic();
    }

    public static boolean isKazakhInstallation() {
        Country country = (Country)DictionaryCache.get().resolveReference((DictionaryReference)DictHelper.getKzRef());
        return country != null && country.isDomestic();
    }

    public static boolean containsInRegionalSettings(RegionalType regionalType) {
        return SystemHelper.searchSystemSettings(RegionalSettings.class).stream().anyMatch(e -> e.getProfilePropertiesTypes().contains(regionalType));
    }

    public static <T extends BaseSystemSettings> List<T> searchSystemSettings(Class<T> cls) {
        if (cls == null) {
            return Collections.emptyList();
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"entityType", (Object)cls.getName()));
        return EntityStorage.get().search(BasicSystemSettingsIndex.class, query).getData().stream().map(EntityIndex::getSource).map(ProfileHelper::resolveReference).filter(Objects::nonNull).filter(cls::isInstance).map(cls::cast).collect(Collectors.toList());
    }

    public static String getIndexSettingsUid(IndexType type) {
        return String.format("IndexSettigns_%s", type.getId());
    }

    public static IndexType getIndexType(String indexSettingsUid) {
        return (IndexType)MetaRegistry.get().getIndexes().get(indexSettingsUid.substring("IndexSettigns_".length()));
    }
}

