/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableName;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.helpers.PersonHelper;
import com.gridnine.xtrip.common.model.helpers.PersonName;
import com.gridnine.xtrip.common.model.helpers.PersonalLocalizableNameFormatter;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class TravellerHelper {
    private static Passport passport(Person profile, Traveller traveller) {
        if (profile.getPassports() == null || profile.getPassports().isEmpty()) {
            return null;
        }
        Passport result = null;
        PersonName travellerName = ProfileHelper.personName(traveller);
        for (Passport x : profile.getPassports()) {
            PersonName passportName = ProfileHelper.personName(x);
            if (!travellerName.equals(passportName)) continue;
            result = x;
            break;
        }
        result = result == null ? (Passport)profile.getPassports().get(0) : result;
        return result;
    }

    public static void enrichWithPersonData(Traveller traveller, EntityContainer<Person> profileContainer) {
        traveller.setPassenger(profileContainer.toReference());
        Person profile = (Person)profileContainer.getEntity();
        Passport passport = TravellerHelper.passport(profile, traveller);
        if (passport != null) {
            traveller.setPassport(passport);
            traveller.setBirthday(passport.getBirthday());
        }
        traveller.setGender(profile.getGender());
        traveller.getCommunications().clear();
        traveller.getCommunications().addAll(profile.getCommunications());
    }

    public static boolean isSamePerson(Traveller traveller, EntityContainer<Person> personContainer) {
        boolean result = traveller != null && personContainer != null ? (traveller.getPassenger() != null ? Objects.equals(traveller.getPassenger(), personContainer.toReference()) : PersonHelper.hasPermutableNames((Person)personContainer.getEntity(), TravellerHelper.refineNames(traveller))) : false;
        return result;
    }

    public static boolean equals(Traveller traveller1, Traveller traveller2) {
        return TravellerHelper.equals(traveller1, traveller2, false);
    }

    public static boolean equalsWithoutMiddleName(Traveller traveller1, Traveller traveller2) {
        return TravellerHelper.equals(traveller1, traveller2, true);
    }

    private static boolean equals(Traveller traveller1, Traveller traveller2, boolean ignoreMiddleName) {
        if (traveller1 == null && traveller2 == null) {
            return true;
        }
        if (traveller1 == null || traveller2 == null) {
            return false;
        }
        if (TextUtil.nonBlank((String)traveller1.getName()) && TextUtil.nonBlank((String)traveller2.getName()) && !TextUtil.isSame((String)traveller1.getName(), (String)traveller2.getName(), (boolean)true)) {
            if (ignoreMiddleName) {
                if (!TravellerHelper.equalWithoutLastWord(traveller1.getName(), traveller2.getName())) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (traveller1.getBirthday() != null && traveller2.getBirthday() != null && !MiscUtil.isSameDay((Date)traveller1.getBirthday(), (Date)traveller2.getBirthday())) {
            return false;
        }
        if (traveller1.getGender() != null && traveller2.getGender() != null && traveller1.getGender() != traveller2.getGender()) {
            return false;
        }
        return TravellerHelper.equals(traveller1.getPassport(), traveller2.getPassport(), ignoreMiddleName);
    }

    public static boolean equals(Passport passport1, Passport passport2) {
        return TravellerHelper.equals(passport1, passport2, false);
    }

    private static boolean equals(Passport passport1, Passport passport2, boolean ignoreMiddleName) {
        if (passport1 == null && passport2 == null) {
            return true;
        }
        if (passport1 == null || passport2 == null) {
            return false;
        }
        if (passport1.getType() != null && passport2.getType() != null && passport1.getType() != passport2.getType()) {
            return false;
        }
        if (TextUtil.nonBlank((String)passport1.getNumber()) && TextUtil.nonBlank((String)passport2.getNumber()) && !TextUtil.isSame((String)passport1.getNumber(), (String)passport2.getNumber(), (boolean)true)) {
            return false;
        }
        if (TextUtil.nonBlank((String)passport1.getLastName()) && TextUtil.nonBlank((String)passport2.getLastName()) && !TextUtil.isSame((String)passport1.getLastName(), (String)passport2.getLastName(), (boolean)true)) {
            return false;
        }
        if (TextUtil.nonBlank((String)passport1.getFirstName()) && TextUtil.nonBlank((String)passport2.getFirstName()) && !TextUtil.isSame((String)passport1.getFirstName(), (String)passport2.getFirstName(), (boolean)true)) {
            if (ignoreMiddleName && TextUtil.isBlank((String)passport1.getMiddleName()) && TextUtil.isBlank((String)passport2.getMiddleName())) {
                if (!TravellerHelper.equalWithoutLastWord(passport1.getFirstName(), passport2.getFirstName())) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (TextUtil.nonBlank((String)passport1.getMiddleName()) && TextUtil.nonBlank((String)passport2.getMiddleName()) && !TextUtil.isSame((String)passport1.getMiddleName(), (String)passport2.getMiddleName(), (boolean)true)) {
            return false;
        }
        if (passport1.getGender() != null && passport2.getGender() != null && passport1.getGender() != passport2.getGender()) {
            return false;
        }
        if (passport1.getBirthday() != null && passport2.getBirthday() != null && !MiscUtil.isSameDay((Date)passport1.getBirthday(), (Date)passport2.getBirthday())) {
            return false;
        }
        return passport1.getCitizenship() == null || passport2.getCitizenship() == null || MiscUtil.equals((Object)passport1.getCitizenship(), (Object)passport2.getCitizenship());
    }

    public static List<String> refineNames(Traveller traveller) {
        return PersonHelper.refineNames(traveller.getPassport().getFirstName(), traveller.getPassport().getLastName());
    }

    public static String getCyrillicName(Traveller traveller) {
        EntityContainer passengerCtr;
        String cyrillicName = traveller.getCyrillicName();
        if (TextUtil.isBlank((String)cyrillicName) && EntityStorageHelper.nonEmpty((EntityContainer)(passengerCtr = EntityStorage.get().resolve(traveller.getPassenger())))) {
            return new PersonalLocalizableNameFormatter("L F S M").format((PersonalLocalizableName)passengerCtr.getEntity(), LocaleHelper.RU_LOCALE, true);
        }
        if (TextUtil.isBlank((String)cyrillicName)) {
            cyrillicName = TravellerHelper.getCyrillicName(TravellerHelper.parseNameInGds(traveller.getNameInGds()));
        }
        if (TextUtil.isBlank((String)cyrillicName)) {
            cyrillicName = TravellerHelper.getCyrillicName(traveller.getName());
        }
        return cyrillicName;
    }

    private static String getCyrillicName(String name) {
        return TextUtil.isCyrillic((String)name, (boolean)true) ? name : TextUtil.translit((String)name, (boolean)false);
    }

    private static String parseNameInGds(String nameInGds) {
        if (nameInGds == null) {
            return null;
        }
        String name = nameInGds.split(" ")[0];
        return String.join((CharSequence)" ", name.split("/"));
    }

    private static boolean equalWithoutLastWord(String string1, String string2) {
        int wordsCount2;
        int wordsCount1 = TravellerHelper.getWordsCount(string1);
        if (wordsCount1 == (wordsCount2 = TravellerHelper.getWordsCount(string2))) {
            return TextUtil.isSame((String)string1, (String)string2);
        }
        if (wordsCount1 - wordsCount2 == 1) {
            return TextUtil.isSame((String)TravellerHelper.removeLastWord(string1), (String)string2);
        }
        if (wordsCount1 - wordsCount2 == -1) {
            return TextUtil.isSame((String)string1, (String)TravellerHelper.removeLastWord(string2));
        }
        return false;
    }

    private static int getWordsCount(String string) {
        return TravellerHelper.getWords(string).size();
    }

    private static String removeLastWord(String string) {
        List<String> words = TravellerHelper.getWords(string);
        if (words.size() < 2) {
            return string;
        }
        return String.join((CharSequence)" ", words.subList(0, words.size() - 1));
    }

    private static List<String> getWords(String string) {
        return Arrays.stream(string.split(" ")).filter(TextUtil::nonBlank).map(String::trim).collect(Collectors.toList());
    }

    public static void updateCyrillicNameTravellers(List<Traveller> travellers) {
        travellers.forEach(tr -> tr.setCyrillicName(TravellerHelper.getCyrillicName(tr)));
    }
}

