/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers;

import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;

public class XtripPriceStructure {
    private BigDecimal productPrice = BigDecimal.ZERO;
    private BigDecimal supplierFees = BigDecimal.ZERO;
    private BigDecimal techFees = BigDecimal.ZERO;
    private BigDecimal agencyFees = BigDecimal.ZERO;
    private BigDecimal agencyFeesIncome = BigDecimal.ZERO;
    private BigDecimal paymentFees = BigDecimal.ZERO;
    private BigDecimal discount = BigDecimal.ZERO;
    private final XtripPriceDetalization priceDetalization = new XtripPriceDetalization();

    public BigDecimal getProductPrice() {
        return this.productPrice;
    }

    public void setProductPrice(BigDecimal productPrice) {
        this.productPrice = MiscUtil.guarded((BigDecimal)productPrice);
    }

    public BigDecimal getSupplierFees() {
        return this.supplierFees;
    }

    public void setSupplierFees(BigDecimal supplierFees) {
        this.supplierFees = MiscUtil.guarded((BigDecimal)supplierFees);
    }

    public BigDecimal getTechFees() {
        return this.techFees;
    }

    public void setTechFees(BigDecimal techFees) {
        this.techFees = MiscUtil.guarded((BigDecimal)techFees);
    }

    public BigDecimal getAgencyFees() {
        return this.agencyFees;
    }

    public void setAgencyFees(BigDecimal agencyFees) {
        this.agencyFees = MiscUtil.guarded((BigDecimal)agencyFees);
    }

    public BigDecimal getAgencyFeesIncome() {
        return this.agencyFeesIncome;
    }

    public void setAgencyFeesIncome(BigDecimal agencyFeesIncome) {
        this.agencyFeesIncome = MiscUtil.guarded((BigDecimal)agencyFeesIncome);
    }

    public BigDecimal getPaymentFees() {
        return this.paymentFees;
    }

    public void setPaymentFees(BigDecimal paymentFees) {
        this.paymentFees = MiscUtil.guarded((BigDecimal)paymentFees);
    }

    public BigDecimal getDiscount() {
        return this.discount;
    }

    public void setDiscount(BigDecimal discount) {
        this.discount = MiscUtil.guarded((BigDecimal)discount);
    }

    public BigDecimal getTotalFees() {
        return MiscUtil.sum((BigDecimal[])new BigDecimal[]{this.supplierFees, this.techFees, this.agencyFees, this.paymentFees});
    }

    public BigDecimal getTotal() {
        return MiscUtil.sum((BigDecimal[])new BigDecimal[]{this.productPrice, this.getTotalFees(), this.discount.negate()});
    }

    public XtripPriceDetalization getPriceDetalization() {
        return this.priceDetalization;
    }

    public XtripPriceStructure clone() {
        XtripPriceStructure clone = new XtripPriceStructure();
        clone.setProductPrice(this.productPrice);
        clone.setSupplierFees(this.supplierFees);
        clone.setTechFees(this.techFees);
        clone.setAgencyFees(this.agencyFees);
        clone.setAgencyFeesIncome(this.agencyFeesIncome);
        clone.setPaymentFees(this.paymentFees);
        clone.setDiscount(this.discount);
        clone.getPriceDetalization().setFare(this.priceDetalization.fare);
        clone.getPriceDetalization().setTaxes(this.priceDetalization.taxes);
        return clone;
    }

    public void negate() {
        this.productPrice = this.productPrice.negate();
        this.supplierFees = this.supplierFees.negate();
        this.techFees = this.techFees.negate();
        this.agencyFees = this.agencyFees.negate();
        this.agencyFeesIncome = this.agencyFeesIncome.negate();
        this.paymentFees = this.paymentFees.negate();
        this.discount = this.discount.negate();
        this.priceDetalization.fare = this.priceDetalization.fare.negate();
        this.priceDetalization.taxes = this.priceDetalization.taxes.negate();
    }

    public void add(XtripPriceStructure add) {
        if (add == null) {
            return;
        }
        this.productPrice = MiscUtil.sum((BigDecimal[])new BigDecimal[]{this.productPrice, add.getProductPrice()});
        this.supplierFees = MiscUtil.sum((BigDecimal[])new BigDecimal[]{this.supplierFees, add.getSupplierFees()});
        this.techFees = MiscUtil.sum((BigDecimal[])new BigDecimal[]{this.techFees, add.getTechFees()});
        this.agencyFees = MiscUtil.sum((BigDecimal[])new BigDecimal[]{this.agencyFees, add.getAgencyFees()});
        this.agencyFeesIncome = MiscUtil.sum((BigDecimal[])new BigDecimal[]{this.agencyFeesIncome, add.getAgencyFees()});
        this.paymentFees = MiscUtil.sum((BigDecimal[])new BigDecimal[]{this.paymentFees, add.getPaymentFees()});
        this.discount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{this.discount, add.getPaymentFees()});
        this.priceDetalization.fare = MiscUtil.sum((BigDecimal[])new BigDecimal[]{this.priceDetalization.fare, add.getPriceDetalization().getFare()});
        this.priceDetalization.taxes = MiscUtil.sum((BigDecimal[])new BigDecimal[]{this.priceDetalization.taxes, add.getPriceDetalization().getTaxes()});
    }

    public void multiple(BigDecimal multiplicand) {
        if (multiplicand == null || MiscUtil.equals((Object)multiplicand, (Object)1)) {
            return;
        }
        this.productPrice = MiscUtil.mul((BigDecimal)this.productPrice, (BigDecimal)multiplicand);
        this.supplierFees = MiscUtil.mul((BigDecimal)this.supplierFees, (BigDecimal)multiplicand);
        this.techFees = MiscUtil.mul((BigDecimal)this.techFees, (BigDecimal)multiplicand);
        this.agencyFees = MiscUtil.mul((BigDecimal)this.agencyFees, (BigDecimal)multiplicand);
        this.agencyFeesIncome = MiscUtil.mul((BigDecimal)this.agencyFeesIncome, (BigDecimal)multiplicand);
        this.paymentFees = MiscUtil.mul((BigDecimal)this.paymentFees, (BigDecimal)multiplicand);
        this.discount = MiscUtil.mul((BigDecimal)this.discount, (BigDecimal)multiplicand);
        this.priceDetalization.fare = MiscUtil.mul((BigDecimal)this.priceDetalization.fare, (BigDecimal)multiplicand);
        this.priceDetalization.taxes = MiscUtil.mul((BigDecimal)this.priceDetalization.taxes, (BigDecimal)multiplicand);
    }

    public class XtripPriceDetalization {
        private BigDecimal fare = BigDecimal.ZERO;
        private BigDecimal taxes = BigDecimal.ZERO;

        public BigDecimal getFare() {
            return this.fare;
        }

        public void setFare(BigDecimal fare) {
            this.fare = fare;
        }

        public BigDecimal getTaxes() {
            return this.taxes;
        }

        public void setTaxes(BigDecimal taxes) {
            this.taxes = taxes;
        }
    }
}

