/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers.util;

import com.gridnine.xtrip.common.model.helpers.util.LogLevel;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;

public class LogOutputStream
extends OutputStream {
    private static final int DEFAULT_BUFFER_LENGTH = 2048;
    private boolean hasBeenClosed = false;
    private final byte[] buf;
    private int count = 0;
    private final int curBufLength = 2048;
    private final Logger log;
    private final LogLevel level;

    public LogOutputStream(Logger log, LogLevel level) {
        this.log = log;
        this.level = level;
        this.buf = new byte[2048];
    }

    @Override
    public void write(int b) throws IOException {
        if (this.hasBeenClosed) {
            throw new IOException("the stream has been closed.");
        }
        if (b == 0) {
            return;
        }
        if (this.count == 2048) {
            this.flush();
        }
        this.buf[this.count++] = (byte)b;
    }

    @Override
    public void flush() {
        if (this.count == 0) {
            return;
        }
        byte[] bytes = new byte[this.count];
        System.arraycopy(this.buf, 0, bytes, 0, this.count);
        String str = new String(bytes);
        switch (this.level) {
            case DEBUG: {
                this.log.debug(str);
                break;
            }
            case INFO: {
                this.log.info(str);
                break;
            }
            case WARN: {
                this.log.warn(str);
                break;
            }
            case ERROR: {
                this.log.error(str);
                break;
            }
            case TRACE: {
                this.log.trace(str);
                break;
            }
        }
        this.count = 0;
    }

    @Override
    public void close() {
        this.flush();
        this.hasBeenClosed = true;
    }
}

