/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers.util;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.TravellerCostCodes;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.util.G9Logger;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.model.profile.CreditLimitInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogUtil {
    private static final Logger BALANCE_LOG = LoggerFactory.getLogger((String)"balanceLog");
    private static final String NULL = "null";
    private static final String COMMA = ", ";
    private static final String COLON = ": ";
    protected static final String QUOTATION = "\"";
    private static final String CLASS = "class";
    private static final String ENTITY = "{\"class\": \"" + EntityContainer.class.getSimpleName() + "\", \"type\": %s, \"uid\": %s}";
    private static final String REF = "{\"class\": \"" + EntityReference.class.getSimpleName() + "\", \"type\": %s, \"uid\": %s, \"caption\": %s}";
    private static final String DICT = "{\"class\": \"" + DictionaryReference.class.getSimpleName() + "\", \"type\": %s, \"code\": %s}";

    public static G9Logger newBalanceLog() {
        return LogUtil.newBalanceLog(null);
    }

    public static G9Logger newBalanceLog(String prefix) {
        return new G9Logger(BALANCE_LOG, new LogUtil(), prefix);
    }

    public static String getStackTrace(String message) {
        StringBuilder sb = new StringBuilder();
        sb.append(message);
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        for (int i = 2; i < stackTrace.length; ++i) {
            sb.append("\n\tat ").append(stackTrace[i].toString());
        }
        return sb.toString();
    }

    public String info(Object ... objects) {
        StringBuilder sb = new StringBuilder("[");
        boolean notFirst = false;
        for (Object obj : objects) {
            if (notFirst) {
                sb.append(COMMA);
            } else {
                notFirst = true;
            }
            sb.append(this.info(obj));
        }
        sb.append("]");
        return sb.toString();
    }

    public String info(Collection<Object> objects) {
        StringBuilder sb = new StringBuilder("[");
        boolean notFirst = false;
        for (Object obj : objects) {
            if (notFirst) {
                sb.append(COMMA);
            } else {
                notFirst = true;
            }
            sb.append(this.info(obj));
        }
        sb.append("]");
        return sb.toString();
    }

    public String info(Map<?, ?> map) {
        StringBuilder sb = new StringBuilder("[");
        boolean notFirst = false;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (notFirst) {
                sb.append(COMMA);
            } else {
                notFirst = true;
            }
            sb.append(QUOTATION).append("(").append(this.info(entry.getKey())).append(") -> (").append(this.info(entry.getValue())).append(")").append(QUOTATION);
        }
        sb.append("]");
        return sb.toString();
    }

    public String info(BookingFile obj) {
        HashMap<String, Object> map = null;
        if (obj != null) {
            map = new HashMap<String, Object>();
            map.put("uid", obj.getUid());
            map.put("number", obj.getNumber());
            map.put("agency", obj.getAgency());
            map.put("customerProfile", obj.getCustomerProfile());
            map.put("workflowStatus", obj.getWorkflowStatus());
            map.put("customer", obj.getCustomer());
            map.put("travellers", obj.getTravellers());
        }
        return this.inf(obj, BookingFile.class, map);
    }

    public String info(Customer obj) {
        HashMap<String, Object> map = null;
        if (obj != null) {
            map = new HashMap<String, Object>();
            map.put("name", obj.getName());
            map.put("companyName", obj.getCompanyName());
            map.put("profile", obj.getProfile());
        }
        return this.inf(obj, BookingFile.class, map);
    }

    public String info(Organization obj) {
        HashMap<String, Object> map = null;
        if (obj != null) {
            map = new HashMap<String, Object>();
            map.put("code", obj.getCode());
            map.put("clientID", obj.getClientID());
            map.put("shortName", obj.getShortName().toString());
            map.put("fullName", obj.getFullName().toString());
        }
        return this.inf(obj, Organization.class, map);
    }

    public String info(StatisticalData obj) {
        HashMap<String, Object> map = null;
        if (obj != null) {
            map = new HashMap<String, Object>();
            map.put("travellerCostCodes", obj.getTravellerCostCodes());
        }
        return this.inf(obj, StatisticalData.class, map);
    }

    public String info(CostCode obj) {
        HashMap<String, Object> map = null;
        if (obj != null) {
            map = new HashMap<String, Object>();
            map.put("props", obj.getCostCodeProperties());
            map.put("value", String.format("%s/%s/%s", obj.getValue(), obj.getLocalValue(), obj.getEnglishValue()));
        }
        return this.inf(obj, CostCode.class, map);
    }

    public String info(CostCodeProperties obj) {
        HashMap<String, Object> map = null;
        if (obj != null) {
            map = new HashMap<String, Object>();
            map.put("name", obj.getName());
            map.put("type", obj.getType());
            map.put("displayType", obj.getDisplayType());
            map.put("sabreValue", obj.getSabreValue());
            map.put("passengerUdid", obj.isPassengerUdid());
        }
        return this.inf(obj, CostCodeProperties.class, map);
    }

    public String info(TravellerCostCodes obj) {
        HashMap<String, Object> map = null;
        if (obj != null) {
            map = new HashMap<String, Object>();
            map.put("traveller", obj.getTraveller());
            map.put("costCodes", obj.getCostCodes());
        }
        return this.inf(obj, TravellerCostCodes.class, map);
    }

    public String info(Traveller obj) {
        HashMap<String, Object> map = null;
        if (obj != null) {
            map = new HashMap<String, Object>();
            map.put("uid", obj.getUid());
            map.put("name", String.format("%s/%s", obj.getName(), obj.getCyrillicName()));
        }
        return this.inf(obj, Traveller.class, map);
    }

    public String info(BaseEntity obj, Collection<String> fieldNames) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String key : fieldNames) {
            try {
                Object value = obj.getValue(key);
                map.put(key, value);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return this.inf(obj.getClass(), BaseEntity.class, map);
    }

    public String inf(Object obj, Class defaultClass, Map<String, Object> fields) {
        Class<?> cls;
        String data = null;
        Class<?> clazz = cls = obj != null ? obj.getClass() : defaultClass;
        if (fields != null) {
            ArrayList<String> fieldNames = new ArrayList<String>(fields.keySet());
            Collections.sort(fieldNames);
            StringBuilder sb = new StringBuilder("{");
            sb.append(QUOTATION).append(CLASS).append(QUOTATION).append(COLON).append(QUOTATION).append(cls.getName()).append(QUOTATION);
            for (String key : fieldNames) {
                sb.append(COMMA);
                Object value = fields.get(key);
                sb.append(QUOTATION).append(key).append(QUOTATION).append(COLON).append(this.info(value));
            }
            sb.append("}");
            data = sb.toString();
        }
        return data != null ? data : this.nullValue(cls);
    }

    public String info(Object obj) {
        String s = this.info_(obj);
        if (s == null) {
            StringBuilder sb = new StringBuilder("{");
            sb.append(QUOTATION).append(CLASS).append(QUOTATION).append(COLON).append(QUOTATION).append(obj.getClass().getName()).append(QUOTATION).append("}");
            s = QUOTATION + obj.toString() + QUOTATION;
        }
        return s;
    }

    public String info_(Object obj) {
        String s = null;
        if (obj == null) {
            s = NULL;
        } else if (obj instanceof EntityContainer) {
            s = this.info((EntityContainer)obj);
        } else if (obj instanceof EntityReference) {
            s = this.info((EntityReference)obj);
        } else if (obj instanceof DictionaryReference) {
            s = this.info((DictionaryReference)obj);
        } else if (obj instanceof BookingFile) {
            s = this.info((BookingFile)obj);
        } else if (obj instanceof Customer) {
            s = this.info((Customer)obj);
        } else if (obj instanceof Organization) {
            s = this.info((Organization)obj);
        } else if (obj instanceof CreditLimitInfo) {
            s = this.info((CreditLimitInfo)obj);
        } else if (obj instanceof StatisticalData) {
            s = this.info((StatisticalData)obj);
        } else if (obj instanceof CostCode) {
            s = this.info((CostCode)obj);
        } else if (obj instanceof CostCodeProperties) {
            s = this.info((CostCodeProperties)obj);
        } else if (obj instanceof TravellerCostCodes) {
            s = this.info((TravellerCostCodes)obj);
        } else if (obj instanceof Traveller) {
            s = this.info((Traveller)obj);
        } else if (obj instanceof Number) {
            s = this.info((Number)obj);
        } else if (obj instanceof String) {
            s = this.info((String)obj);
        } else if (obj instanceof Boolean) {
            s = this.info((Boolean)obj);
        } else if (obj instanceof Collection) {
            s = this.info((Collection)obj);
        } else if (obj instanceof Map) {
            s = this.info((Map)obj);
        }
        return s;
    }

    public String info(EntityContainer<?> ctr) {
        Class type = ctr != null ? ctr.getEntityType() : null;
        String result = type != null ? String.format(ENTITY, this.info(type.getName()), this.info(ctr.getUid())) : this.nullValue(EntityContainer.class);
        return result;
    }

    public String info(EntityReference<?> ref) {
        Class type = ref != null ? ref.getType() : null;
        String result = type != null ? String.format(REF, this.info(type.getName()), this.info(ref.getUid()), this.info(ref.getCaption())) : this.nullValue(EntityReference.class);
        return result;
    }

    public String info(DictionaryReference<?> ref) {
        Class type = ref != null ? ref.getType() : null;
        String result = type != null ? String.format(DICT, this.info(type.getName()), this.info(ref.getCode())) : this.nullValue(DictionaryReference.class);
        return result;
    }

    public String info(CreditLimitInfo x) {
        return x != null ? this.info((BaseEntity)x, new HashSet<String>(Arrays.asList("unlimited", "creditType", "limitType", "creditLimit", "limitAmount", "temporalLimitAmount", "terminalCreditLimit"))) : this.nullValue(CreditLimitInfo.class);
    }

    protected String nullValue(Class cls) {
        return "null of " + cls.getName();
    }

    public String info(Number obj) {
        return obj != null ? obj.toString() : NULL;
    }

    public String info(Boolean obj) {
        return obj != null ? String.valueOf(obj) : NULL;
    }

    public String info(String obj) {
        return obj != null ? QUOTATION + obj + QUOTATION : NULL;
    }
}

