/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.meta;

import com.gridnine.xtrip.common.meta.PropertiesRenamer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.RecordLocatorInfo;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.ReservationGdsNameInfo;
import com.gridnine.xtrip.common.model.booking.ReservationSystemInfo;
import com.gridnine.xtrip.common.model.booking.ReservationType;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.util.EnumUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class ReservationGdsNameInfoRenamer
implements PropertiesRenamer {
    private static final Logger log = LoggerFactory.getLogger(ReservationGdsNameInfoRenamer.class);
    private static final Map<String, String> hotelSubProvider2GdsMap = new HashMap<String, String>();

    public void renameProperties(Element elm) throws Exception {
        if (XmlUtil.getElement((Element)elm, (String)"gdsNameInfo") != null) {
            return;
        }
        ReservationGdsNameInfo gdsNameInfo = ReservationGdsNameInfoRenamer.getGdsNameInfo(elm);
        XHelper.writeObject((Element)elm, (String)"gdsNameInfo", (Object)gdsNameInfo);
    }

    public static ReservationGdsNameInfo getGdsNameInfo(Element elm) {
        GdsName gdsName = (GdsName)XHelper.readEnum((Element)elm, (String)"gdsName", GdsName.class);
        String recordLocator = XHelper.readString((Element)elm, (String)"recordLocator");
        String bookingAgentDutyCode = XHelper.readString((Element)elm, (String)"bookingAgentDutyCode");
        String bookingPcc = XHelper.readString((Element)elm, (String)"bookingPcc");
        ReservationGdsNameInfo gdsNameInfo = new ReservationGdsNameInfo();
        gdsNameInfo.setValue("onlineGdsAccount", XHelper.readObject((Element)elm, (String)"gdsAccount"));
        gdsNameInfo.setRulesGdsName(gdsName);
        gdsNameInfo.setStatisticsGdsName(gdsName);
        if (gdsName != null || recordLocator != null || bookingAgentDutyCode != null || bookingPcc != null) {
            ReservationSystemInfo info = new ReservationSystemInfo();
            info.setGdsName(gdsName);
            if (recordLocator != null) {
                RecordLocatorInfo recordLocatorInfo = new RecordLocatorInfo();
                recordLocatorInfo.setType(RecordLocatorType.DEFAULT);
                recordLocatorInfo.setRecordLocator(recordLocator);
                recordLocatorInfo.setDisplay(true);
                recordLocatorInfo.setExport1C(true);
                try {
                    recordLocatorInfo.setValue("exportSofi", (Object)true);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                try {
                    recordLocatorInfo.setValue("pentaho", (Object)true);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                info.getRecordLocators().add(recordLocatorInfo);
            }
            info.setBookingAgentDutyCode(bookingAgentDutyCode);
            info.setBookingPcc(bookingPcc);
            gdsNameInfo.getSystemInfos().add(info);
        }
        ReservationGdsNameInfoRenamer.updateForPkfare(gdsNameInfo, elm);
        ReservationGdsNameInfoRenamer.updateForMixvel(gdsNameInfo, elm);
        ReservationGdsNameInfoRenamer.updateForSirena(gdsNameInfo, elm);
        ReservationGdsNameInfoRenamer.updateForS7NDC(gdsNameInfo, elm);
        ReservationGdsNameInfoRenamer.updateForTANDC(gdsNameInfo, elm);
        ReservationGdsNameInfoRenamer.updateForFlyArystan(gdsNameInfo, elm);
        ReservationGdsNameInfoRenamer.updateForRailKz(gdsNameInfo, elm);
        ReservationGdsNameInfoRenamer.updateForIWay(gdsNameInfo, elm);
        ReservationGdsNameInfoRenamer.updateForAeroexpress(gdsNameInfo, elm);
        ReservationGdsNameInfoRenamer.updateForCorteos(gdsNameInfo, elm);
        ReservationGdsNameInfoRenamer.updateForHotelAggregator(gdsNameInfo, elm);
        ReservationGdsNameInfoRenamer.updateForVipHotelAggregator(gdsNameInfo, elm);
        return gdsNameInfo;
    }

    private static void updateForMixvel(ReservationGdsNameInfo gdsNameInfo, Element elm) {
        if ("com.gridnine.xtrip.common.model.gds.mixvel.MixvelGdsAccount".equals(Optional.ofNullable(gdsNameInfo.getValue("onlineGdsAccount")).map(EntityReference.class::cast).map(EntityReference::getType).map(Class::getName).orElse(null))) {
            String orderId;
            gdsNameInfo.setStatisticsGdsName(GdsName.SIRENA);
            String mixOrderId = XHelper.readString((Element)elm, (String)"mixOrderId");
            if (mixOrderId != null) {
                if (!gdsNameInfo.getSystemInfos().isEmpty()) {
                    ReservationSystemInfo sirenaInfo = (ReservationSystemInfo)gdsNameInfo.getSystemInfos().get(0);
                    sirenaInfo.setGdsName(GdsName.SIRENA);
                    if (!sirenaInfo.getRecordLocators().isEmpty()) {
                        ((RecordLocatorInfo)sirenaInfo.getRecordLocators().get(0)).setType(RecordLocatorType.valueOf((String)"SIRENA_LATIN"));
                    }
                }
                ReservationSystemInfo mixvelInfo = new ReservationSystemInfo();
                mixvelInfo.setGdsName(GdsName.valueOf((String)"MIXVEL"));
                RecordLocatorInfo recordLocatorInfo = new RecordLocatorInfo();
                recordLocatorInfo.setType(RecordLocatorType.valueOf((String)"MIXVEL_MIX_ORDER_ID"));
                recordLocatorInfo.setRecordLocator(mixOrderId);
                recordLocatorInfo.setDisplay(false);
                mixvelInfo.getRecordLocators().add(recordLocatorInfo);
                gdsNameInfo.getSystemInfos().add(mixvelInfo);
            }
            if ((orderId = XHelper.readString((Element)elm, (String)"orderId")) != null) {
                ReservationSystemInfo mixvelInfo = gdsNameInfo.getSystemInfos().stream().filter(si -> "MIXVEL".equals(si.getGdsName().name())).findAny().get();
                RecordLocatorInfo recordLocatorInfo = new RecordLocatorInfo();
                recordLocatorInfo.setType(RecordLocatorType.valueOf((String)"MIXVEL_ORDER_ID"));
                recordLocatorInfo.setRecordLocator(orderId);
                recordLocatorInfo.setDisplay(false);
                mixvelInfo.getRecordLocators().add(recordLocatorInfo);
            }
        }
    }

    private static void updateForPkfare(ReservationGdsNameInfo gdsNameInfo, Element elm) {
        ReservationSystemInfo systemInfo;
        if ("com.gridnine.xtrip.common.gds.pkfare.model.PkfareGdsAccount".equals(Optional.ofNullable(gdsNameInfo.getValue("onlineGdsAccount")).map(EntityReference.class::cast).map(EntityReference::getType).map(Class::getName).orElse(null)) && !gdsNameInfo.getSystemInfos().isEmpty() && !(systemInfo = (ReservationSystemInfo)gdsNameInfo.getSystemInfos().get(0)).getRecordLocators().isEmpty()) {
            ((RecordLocatorInfo)systemInfo.getRecordLocators().get(0)).setType(RecordLocatorType.valueOf((String)"PKFARE_ORDER_NUM"));
        }
    }

    private static void updateForSirena(ReservationGdsNameInfo gdsNameInfo, Element elm) {
        ReservationSystemInfo sirenaInfo;
        if (gdsNameInfo.getSystemInfos().size() == 1 && ((ReservationSystemInfo)gdsNameInfo.getSystemInfos().get(0)).getGdsName() == GdsName.SIRENA && !(sirenaInfo = (ReservationSystemInfo)gdsNameInfo.getSystemInfos().get(0)).getRecordLocators().isEmpty()) {
            RecordLocatorInfo rli;
            boolean isRecordLocatorCyr = TextUtil.containsCyrillicLetter((String)(rli = (RecordLocatorInfo)sirenaInfo.getRecordLocators().get(0)).getRecordLocator());
            rli.setType(RecordLocatorType.valueOf((String)(isRecordLocatorCyr ? "SIRENA_CYRILLIC" : "SIRENA_LATIN")));
            String recordLocator2 = XHelper.readString((Element)elm, (String)"recordLocatorLatin");
            if (recordLocator2 != null && !recordLocator2.equals(rli.getRecordLocator())) {
                RecordLocatorInfo rli2 = new RecordLocatorInfo();
                boolean isRecordLocator2Cyr = TextUtil.containsCyrillicLetter((String)recordLocator2);
                rli2.setType(RecordLocatorType.valueOf((String)(isRecordLocator2Cyr ? "SIRENA_CYRILLIC" : "SIRENA_LATIN")));
                rli2.setRecordLocator(recordLocator2);
                if (isRecordLocatorCyr && !isRecordLocator2Cyr) {
                    rli2.setDisplay(true);
                    rli.setDisplay(false);
                    rli2.setExport1C(true);
                    rli.setExport1C(false);
                    try {
                        rli2.setValue("exportSofi", (Object)true);
                        rli.setValue("exportSofi", (Object)false);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    try {
                        rli2.setValue("pentaho", (Object)true);
                        rli.setValue("pentaho", (Object)false);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                sirenaInfo.getRecordLocators().add(rli2);
            }
        }
    }

    private static void updateForS7NDC(ReservationGdsNameInfo gdsNameInfo, Element elm) {
        int idx;
        RecordLocatorInfo rli;
        String recordLocator;
        if (gdsNameInfo.getSystemInfos().size() == 1 && "S7NDC".equals(EnumUtil.nameOf((Enum)((ReservationSystemInfo)gdsNameInfo.getSystemInfos().get(0)).getGdsName())) && !((ReservationSystemInfo)gdsNameInfo.getSystemInfos().get(0)).getRecordLocators().isEmpty() && (recordLocator = (rli = (RecordLocatorInfo)((ReservationSystemInfo)gdsNameInfo.getSystemInfos().get(0)).getRecordLocators().get(0)).getRecordLocator()) != null && (idx = recordLocator.indexOf(47)) > 0) {
            rli.setRecordLocator(recordLocator.substring(0, idx));
        }
    }

    private static void updateForTANDC(ReservationGdsNameInfo gdsNameInfo, Element elm) {
        if (gdsNameInfo.getSystemInfos().size() == 1 && "TA_NDC".equals(EnumUtil.nameOf((Enum)((ReservationSystemInfo)gdsNameInfo.getSystemInfos().get(0)).getGdsName()))) {
            String orderId = XHelper.readString((Element)elm, (String)"taNdcOrderId");
            ReservationSystemInfo systemInfo = (ReservationSystemInfo)gdsNameInfo.getSystemInfos().get(0);
            if (!systemInfo.getRecordLocators().isEmpty()) {
                RecordLocatorInfo rli = (RecordLocatorInfo)systemInfo.getRecordLocators().get(0);
                int idx = rli.getRecordLocator().indexOf(47);
                String taOriginalBookingId = rli.getRecordLocator().substring(0, idx);
                String owner = rli.getRecordLocator().substring(idx + 1);
                if (taOriginalBookingId.equals(orderId)) {
                    systemInfo.getRecordLocators().remove(rli);
                } else {
                    rli.setRecordLocator(taOriginalBookingId);
                    rli.setType(RecordLocatorType.valueOf((String)"TA_NDC_ORIGINAL_BOOKING_ID"));
                }
                RecordLocatorInfo rliOrderId = new RecordLocatorInfo();
                rliOrderId.setType(RecordLocatorType.valueOf((String)"TA_NDC_ORDER_ID"));
                rliOrderId.setRecordLocator(orderId);
                ((ReservationSystemInfo)gdsNameInfo.getSystemInfos().get(0)).getRecordLocators().add(rliOrderId);
                RecordLocatorInfo rliOwner = new RecordLocatorInfo();
                rliOwner.setType(RecordLocatorType.valueOf((String)"TA_NDC_OWNER"));
                rliOwner.setRecordLocator(owner);
                ((ReservationSystemInfo)gdsNameInfo.getSystemInfos().get(0)).getRecordLocators().add(rliOwner);
                ReservationSystemInfo rsi = new ReservationSystemInfo();
                RecordLocatorInfo rliSource = new RecordLocatorInfo();
                switch (owner) {
                    case "MXV": {
                        rsi.setGdsName(GdsName.SIRENA);
                        rliSource.setType(RecordLocatorType.valueOf((String)"SIRENA_LATIN"));
                        break;
                    }
                    case "1S": {
                        rsi.setGdsName(GdsName.SABRE);
                        rliSource.setType(RecordLocatorType.DEFAULT);
                        break;
                    }
                    case "1A": {
                        rsi.setGdsName(GdsName.AMADEUS);
                        rliSource.setType(RecordLocatorType.DEFAULT);
                        break;
                    }
                    case "1G": {
                        rsi.setGdsName(GdsName.GALILEO);
                        rliSource.setType(RecordLocatorType.DEFAULT);
                    }
                }
                if (rsi.getGdsName() != null) {
                    rliSource.setRecordLocator(taOriginalBookingId);
                    rsi.getRecordLocators().add(rliSource);
                    gdsNameInfo.getSystemInfos().add(rsi);
                }
            }
        }
    }

    private static void updateForFlyArystan(ReservationGdsNameInfo gdsNameInfo, Element elm) {
        int idx;
        RecordLocatorInfo rliId;
        String recordLocator;
        if (gdsNameInfo.getSystemInfos().size() == 1 && "FLY_ARYSTAN".equals(EnumUtil.nameOf((Enum)((ReservationSystemInfo)gdsNameInfo.getSystemInfos().get(0)).getGdsName())) && !((ReservationSystemInfo)gdsNameInfo.getSystemInfos().get(0)).getRecordLocators().isEmpty() && (recordLocator = (rliId = (RecordLocatorInfo)((ReservationSystemInfo)gdsNameInfo.getSystemInfos().get(0)).getRecordLocators().get(0)).getRecordLocator()) != null && (idx = recordLocator.indexOf(47)) > 0) {
            String idPart = recordLocator.substring(0, idx);
            String referenceIdPart = recordLocator.substring(idx + 1);
            rliId.setRecordLocator(idPart);
            rliId.setType(RecordLocatorType.valueOf((String)"FLY_ARYSTAN_ID"));
            RecordLocatorInfo rliReferenceId = new RecordLocatorInfo();
            rliReferenceId.setType(RecordLocatorType.valueOf((String)"FLY_ARYSTAN_REFERENCE_ID"));
            rliReferenceId.setRecordLocator(referenceIdPart);
            ((ReservationSystemInfo)gdsNameInfo.getSystemInfos().get(0)).getRecordLocators().add(rliReferenceId);
        }
    }

    private static void updateForRailKz(ReservationGdsNameInfo gdsNameInfo, Element elm) {
        String orderExpressId;
        if (gdsNameInfo.getSystemInfos().size() == 1 && "RAIL_KZ".equals(EnumUtil.nameOf((Enum)((ReservationSystemInfo)gdsNameInfo.getSystemInfos().get(0)).getGdsName())) && TextUtil.nonBlank((String)(orderExpressId = XHelper.readString((Element)elm, (String)"orderExpressId")))) {
            ReservationSystemInfo rsi = new ReservationSystemInfo();
            rsi.setGdsName(GdsName.EXPRESS);
            RecordLocatorInfo rli = new RecordLocatorInfo();
            rli.setType(RecordLocatorType.DEFAULT);
            rli.setRecordLocator(orderExpressId);
            rli.setDisplay(false);
            rsi.getRecordLocators().add(rli);
            gdsNameInfo.getSystemInfos().add(rsi);
        }
    }

    private static void updateForIWay(ReservationGdsNameInfo gdsNameInfo, Element elm) {
        if ("true".equals(System.getProperty("reservation-gds-name-info.vip-iway"))) {
            return;
        }
        if (gdsNameInfo.getSystemInfos().size() == 1 && "IWAY".equals(EnumUtil.nameOf((Enum)((ReservationSystemInfo)gdsNameInfo.getSystemInfos().get(0)).getGdsName()))) {
            Integer iwayTransaction;
            ReservationSystemInfo iwayInfo = (ReservationSystemInfo)gdsNameInfo.getSystemInfos().get(0);
            if (!iwayInfo.getRecordLocators().isEmpty()) {
                ((RecordLocatorInfo)iwayInfo.getRecordLocators().get(0)).setType(RecordLocatorType.valueOf((String)"IWAY_ORDER_ID"));
            }
            if ((iwayTransaction = XHelper.readInt((Element)elm, (String)"iwayTransaction")) != null) {
                RecordLocatorInfo rli = new RecordLocatorInfo();
                rli.setType(RecordLocatorType.valueOf((String)"IWAY_TRANSACTION"));
                rli.setRecordLocator(String.valueOf(iwayTransaction));
                rli.setDisplay(false);
                iwayInfo.getRecordLocators().add(rli);
            }
        }
    }

    private static void updateForAeroexpress(ReservationGdsNameInfo gdsNameInfo, Element elm) {
        if (gdsNameInfo.getSystemInfos().size() == 1 && "AEROEXPRESS_10".equals(EnumUtil.nameOf((Enum)((ReservationSystemInfo)gdsNameInfo.getSystemInfos().get(0)).getGdsName())) && gdsNameInfo.getOnlineGdsAccount() == null) {
            String defaultAeroexpressUid = "com.gridnine.xtrip.common.aeroexpress.AeroexpressGdsAccount-default-uid";
            try {
                gdsNameInfo.setValue("onlineGdsAccount", (Object)new EntityReference(defaultAeroexpressUid, Class.forName("com.gridnine.xtrip.common.aeroexpress.AeroexpressGdsAccount"), "\u0410\u044d\u0440\u043e\u044d\u043a\u0441\u043f\u0440\u0435\u0441\u0441"));
            }
            catch (Exception e) {
                log.error("updateForAeroexpress failed", (Throwable)e);
            }
        }
    }

    private static void updateForCorteos(ReservationGdsNameInfo gdsNameInfo, Element elm) {
        try {
            Element[] products = XmlUtil.getElements((Element)elm, (String)"products/item");
            if (products.length == 0 || !HotelProduct.class.getName().equals(products[0].getAttribute("class"))) {
                return;
            }
            if (gdsNameInfo.getSystemInfos().size() == 1 && XHelper.readEnum((Element)elm, (String)"type", ReservationType.class) == ReservationType.valueOf((String)"CORTEOS")) {
                ReservationSystemInfo rsi = new ReservationSystemInfo();
                gdsNameInfo.getSystemInfos().add(rsi);
                rsi.setGdsName(GdsName.valueOf((String)"HOTEL_AGGREGATOR"));
                RecordLocatorInfo rli = new RecordLocatorInfo();
                rsi.getRecordLocators().add(rli);
                rli.setRecordLocator(XHelper.readString((Element)elm, (String)"recordLocator"));
                rli.setType(RecordLocatorType.valueOf((String)"HOTEL_AGGREGATOR_PNR"));
            }
        }
        catch (Exception e) {
            log.error("updateForCorteos failed", (Throwable)e);
        }
    }

    private static void updateForHotelAggregator(ReservationGdsNameInfo gdsNameInfo, Element elm) {
        if ("true".equals(System.getProperty("reservation-gds-name-info.vip-hotels.enabled"))) {
            return;
        }
        if (gdsNameInfo.getSystemInfos().size() == 1 && "HOTEL_AGGREGATOR".equals(EnumUtil.nameOf((Enum)((ReservationSystemInfo)gdsNameInfo.getSystemInfos().get(0)).getGdsName()))) {
            String recordLocatorProvider;
            ReservationSystemInfo haInfo = (ReservationSystemInfo)gdsNameInfo.getSystemInfos().get(0);
            if (!haInfo.getRecordLocators().isEmpty()) {
                ((RecordLocatorInfo)haInfo.getRecordLocators().get(0)).setType(RecordLocatorType.valueOf((String)"HOTEL_AGGREGATOR_PNR"));
            }
            if (TextUtil.nonBlank((String)(recordLocatorProvider = XHelper.readString((Element)elm, (String)"recordLocatorProvider")))) {
                RecordLocatorInfo recordLocatorInfo = new RecordLocatorInfo();
                recordLocatorInfo.setType(RecordLocatorType.valueOf((String)"HOTEL_AGGREGATOR_RESERVATION_NUMBER"));
                recordLocatorInfo.setRecordLocator(recordLocatorProvider);
                recordLocatorInfo.setDisplay(false);
                haInfo.getRecordLocators().add(recordLocatorInfo);
            }
            try {
                GdsName providerGdsName;
                String recordLocator;
                Element[] products = XmlUtil.getElements((Element)elm, (String)"products/item");
                if (products.length == 0) {
                    return;
                }
                Element item = products[0];
                if (HotelProduct.class.getName().equals(item.getAttribute("class")) && TextUtil.nonBlank((String)(recordLocator = XHelper.readString((Element)elm, (String)"recordLocator"))) && (providerGdsName = ReservationGdsNameInfoRenamer.hotelProviderToGdsName((HotelProvider)XHelper.readEnum((Element)item, (String)"provider", HotelProvider.class))) != null) {
                    if (providerGdsName == GdsName.OSTROVOK) {
                        ReservationSystemInfo providerInfo = new ReservationSystemInfo();
                        providerInfo.setGdsName(providerGdsName);
                        RecordLocatorInfo recordLocatorInfo = new RecordLocatorInfo();
                        recordLocatorInfo.setType(RecordLocatorType.OSTROVOK_ORDER_ID);
                        recordLocatorInfo.setRecordLocator(recordLocator);
                        recordLocatorInfo.setDisplay(false);
                        providerInfo.getRecordLocators().add(recordLocatorInfo);
                        recordLocatorInfo = new RecordLocatorInfo();
                        recordLocatorInfo.setType(RecordLocatorType.OSTROVOK_PARTNER_ORDER_ID);
                        recordLocatorInfo.setRecordLocator(recordLocatorProvider);
                        recordLocatorInfo.setDisplay(false);
                        providerInfo.getRecordLocators().add(recordLocatorInfo);
                        gdsNameInfo.getSystemInfos().add(providerInfo);
                    } else {
                        ReservationSystemInfo providerInfo = new ReservationSystemInfo();
                        providerInfo.setGdsName(providerGdsName);
                        RecordLocatorInfo recordLocatorInfo = new RecordLocatorInfo();
                        recordLocatorInfo.setType(RecordLocatorType.DEFAULT);
                        recordLocatorInfo.setRecordLocator(recordLocator);
                        recordLocatorInfo.setDisplay(false);
                        providerInfo.getRecordLocators().add(recordLocatorInfo);
                        gdsNameInfo.getSystemInfos().add(providerInfo);
                    }
                }
            }
            catch (Exception e) {
                log.error("updateForHotelAggregator failed", (Throwable)e);
            }
        }
    }

    private static void updateForVipHotelAggregator(ReservationGdsNameInfo gdsNameInfo, Element elm) {
        if (!"true".equals(System.getProperty("reservation-gds-name-info.vip-hotels.enabled"))) {
            return;
        }
        if (gdsNameInfo.getSystemInfos().size() == 1 && "HOTEL_AGGREGATOR".equals(EnumUtil.nameOf((Enum)((ReservationSystemInfo)gdsNameInfo.getSystemInfos().get(0)).getGdsName()))) {
            String recordLocatorProvider;
            ReservationSystemInfo haInfo = (ReservationSystemInfo)gdsNameInfo.getSystemInfos().get(0);
            if (!haInfo.getRecordLocators().isEmpty()) {
                ((RecordLocatorInfo)haInfo.getRecordLocators().get(0)).setType(RecordLocatorType.valueOf((String)"HOTEL_AGGREGATOR_PNR"));
            }
            if (TextUtil.nonBlank((String)(recordLocatorProvider = XHelper.readString((Element)elm, (String)"recordLocatorProvider")))) {
                RecordLocatorInfo recordLocatorInfo = new RecordLocatorInfo();
                recordLocatorInfo.setType(RecordLocatorType.valueOf((String)"HOTEL_AGGREGATOR_RESERVATION_NUMBER"));
                recordLocatorInfo.setRecordLocator(recordLocatorProvider);
                recordLocatorInfo.setDisplay(false);
                haInfo.getRecordLocators().add(recordLocatorInfo);
            }
            try {
                Element[] products = XmlUtil.getElements((Element)elm, (String)"products/item");
                if (products.length == 0) {
                    return;
                }
                Element item = products[0];
                if (HotelProduct.class.getName().equals(item.getAttribute("class"))) {
                    GdsName subProviderGdsName;
                    RecordLocatorInfo recordLocatorInfo;
                    GdsName providerGdsName;
                    String usedPcc;
                    if (gdsNameInfo.getOnlineGdsAccount() == null && TextUtil.nonBlank((String)(usedPcc = XHelper.readString((Element)item, (String)"usedPcc")))) {
                        String accountUid = "com.gridnine.xtrip.common.hotels.model.HotelAggregatorGdsAccount-" + usedPcc + "-uid";
                        String caption = "\u041e\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u0430\u0433\u0440\u0435\u0433\u0430\u0442\u043e\u0440 " + usedPcc;
                        gdsNameInfo.setValue("onlineGdsAccount", (Object)new EntityReference(accountUid, Class.forName("com.gridnine.xtrip.common.hotels.model.HotelAggregatorGdsAccount"), caption));
                    }
                    String recordLocator = XHelper.readString((Element)elm, (String)"recordLocator");
                    String recordLocatorSubProvider = XHelper.readString((Element)elm, (String)"recordLocatorSubProvider");
                    if (TextUtil.nonBlank((String)recordLocator) && (providerGdsName = ReservationGdsNameInfoRenamer.hotelProviderToGdsName((HotelProvider)XHelper.readEnum((Element)item, (String)"provider", HotelProvider.class))) != null) {
                        ReservationSystemInfo providerInfo;
                        if (providerGdsName == GdsName.OSTROVOK) {
                            providerInfo = new ReservationSystemInfo();
                            providerInfo.setGdsName(providerGdsName);
                            recordLocatorInfo = new RecordLocatorInfo();
                            recordLocatorInfo.setType(RecordLocatorType.OSTROVOK_ORDER_ID);
                            recordLocatorInfo.setRecordLocator(recordLocator);
                            recordLocatorInfo.setDisplay(false);
                            providerInfo.getRecordLocators().add(recordLocatorInfo);
                            recordLocatorInfo = new RecordLocatorInfo();
                            recordLocatorInfo.setType(RecordLocatorType.OSTROVOK_PARTNER_ORDER_ID);
                            recordLocatorInfo.setRecordLocator(recordLocatorProvider);
                            recordLocatorInfo.setDisplay(false);
                            providerInfo.getRecordLocators().add(recordLocatorInfo);
                            gdsNameInfo.getSystemInfos().add(providerInfo);
                        } else if (providerGdsName == GdsName.HOTELSTAR) {
                            GdsName subProviderGdsName2;
                            providerInfo = new ReservationSystemInfo();
                            providerInfo.setGdsName(providerGdsName);
                            recordLocatorInfo = new RecordLocatorInfo();
                            recordLocatorInfo.setType(RecordLocatorType.HOTELSTAR_ORDER_ID);
                            recordLocatorInfo.setRecordLocator(recordLocator);
                            recordLocatorInfo.setDisplay(false);
                            providerInfo.getRecordLocators().add(recordLocatorInfo);
                            if (TextUtil.nonBlank((String)recordLocatorSubProvider) && (subProviderGdsName2 = ReservationGdsNameInfoRenamer.hotelSubProviderToGdsName(item)) == GdsName.HOTELSTAR) {
                                RecordLocatorInfo recordLocatorInfo2 = new RecordLocatorInfo();
                                recordLocatorInfo2.setType(RecordLocatorType.HOTELSTAR_PROVIDER_ORDER_ID);
                                recordLocatorInfo2.setRecordLocator(recordLocatorSubProvider);
                                recordLocatorInfo2.setDisplay(false);
                                providerInfo.getRecordLocators().add(recordLocatorInfo2);
                            }
                            gdsNameInfo.getSystemInfos().add(providerInfo);
                        } else {
                            providerInfo = new ReservationSystemInfo();
                            providerInfo.setGdsName(providerGdsName);
                            recordLocatorInfo = new RecordLocatorInfo();
                            recordLocatorInfo.setType(RecordLocatorType.DEFAULT);
                            recordLocatorInfo.setRecordLocator(recordLocator);
                            recordLocatorInfo.setDisplay(false);
                            providerInfo.getRecordLocators().add(recordLocatorInfo);
                            gdsNameInfo.getSystemInfos().add(providerInfo);
                        }
                    }
                    if (TextUtil.nonBlank((String)recordLocatorSubProvider) && (subProviderGdsName = ReservationGdsNameInfoRenamer.hotelSubProviderToGdsName(item)) != null && subProviderGdsName != GdsName.HOTELSTAR) {
                        ReservationSystemInfo subProviderInfo = new ReservationSystemInfo();
                        subProviderInfo.setGdsName(subProviderGdsName);
                        recordLocatorInfo = new RecordLocatorInfo();
                        recordLocatorInfo.setType(RecordLocatorType.DEFAULT);
                        recordLocatorInfo.setRecordLocator(recordLocatorSubProvider);
                        recordLocatorInfo.setDisplay(false);
                        subProviderInfo.getRecordLocators().add(recordLocatorInfo);
                        gdsNameInfo.getSystemInfos().add(subProviderInfo);
                    }
                }
            }
            catch (Exception e) {
                log.error("updateForVipHotelAggregator failed", (Throwable)e);
            }
        }
    }

    private static GdsName hotelProviderToGdsName(HotelProvider provider) {
        if (provider == null) {
            return null;
        }
        if ("INTERNAL".equals(provider.name())) {
            return GdsName.IBE;
        }
        return (GdsName)EnumUtil.fromNameSafe(GdsName.class, (String)provider.name(), (Logger)log);
    }

    private static GdsName hotelSubProviderToGdsName(Element item) {
        String subProviderCode = XHelper.readString((Element)item, (String)"subProvider");
        return ReservationGdsNameInfoRenamer.hotelSubProviderToGdsName(subProviderCode);
    }

    private static GdsName hotelSubProviderToGdsName(String subProviderCode) {
        if (TextUtil.isBlank((String)subProviderCode)) {
            return null;
        }
        String gds = hotelSubProvider2GdsMap.get(subProviderCode);
        return (GdsName)EnumUtil.fromNameSafe(GdsName.class, (String)gds, (Logger)log);
    }

    static {
        hotelSubProvider2GdsMap.put("HOTELSTAR_academ", "ACADEMSERVICE");
        hotelSubProvider2GdsMap.put("HOTELSTAR_amadeus", "AMADEUS");
        hotelSubProvider2GdsMap.put("HOTELSTAR_bronevik", "BRONEVIK");
        hotelSubProvider2GdsMap.put("HOTELSTAR_hotelbook", "HOTELBOOK");
        hotelSubProvider2GdsMap.put("HOTELSTAR_ostrovok", "OSTROVOK");
        hotelSubProvider2GdsMap.put("HOTELSTAR_sabre", "SABRE");
        hotelSubProvider2GdsMap.put("HOTELSTAR_russhotels", "SUSANIN");
        hotelSubProvider2GdsMap.put("HOTELSTAR_expedia", "EXPEDIA");
        hotelSubProvider2GdsMap.put("HOTELSTAR_happy_travel", "HAPPY_TRAVEL");
        hotelSubProvider2GdsMap.put("HOTELSTAR_dome", "DOME");
        hotelSubProvider2GdsMap.put("HOTELSTAR_go-global", "GO_GLOBAL");
        hotelSubProvider2GdsMap.put("HOTELSTAR_panda", "PANDA");
        hotelSubProvider2GdsMap.put("HOTELSTAR_priceline", "PRICELINE");
        hotelSubProvider2GdsMap.put("HOTELSTAR_hotelstar", "HOTELSTAR");
        hotelSubProvider2GdsMap.put("HOTELSTAR_1", "OSTROVOK");
        hotelSubProvider2GdsMap.put("HOTELSTAR_2", "HOTELSTAR");
        hotelSubProvider2GdsMap.put("HOTELSTAR_3", "ACADEMSERVICE");
        hotelSubProvider2GdsMap.put("HOTELSTAR_4", "BRONEVIK");
        hotelSubProvider2GdsMap.put("HOTELSTAR_5", "SABRE");
        hotelSubProvider2GdsMap.put("HOTELSTAR_8", "HOTELBOOK");
        hotelSubProvider2GdsMap.put("HOTELSTAR_10", "PANDA");
        hotelSubProvider2GdsMap.put("HOTELSTAR_16", "GO_GLOBAL");
        hotelSubProvider2GdsMap.put("HOTELSTAR_18", "EXPEDIA");
        hotelSubProvider2GdsMap.put("HOTELSTAR_23", "PRICELINE");
        hotelSubProvider2GdsMap.put("HOTELSTAR_24", "HAPPY_TRAVEL");
    }
}

