/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.personal.data.helper;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.PersonalDataPersonEmail;
import com.gridnine.xtrip.common.model.PersonalDataPersonName;
import com.gridnine.xtrip.common.model.PersonalDataPersonPassport;
import com.gridnine.xtrip.common.model.PersonalDataPersonPhone;
import com.gridnine.xtrip.common.model.PersonalDataPersonSearchData;
import com.gridnine.xtrip.common.model.PersonalDataSearchResultItem;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PersonalDataHelper {
    private static EnumSet<CommunicationType> phoneTypes = EnumSet.of(CommunicationType.HOME_PHONE, new CommunicationType[]{CommunicationType.WORK_PHONE, CommunicationType.MOBILE, CommunicationType.FAX, CommunicationType.AGENCY, CommunicationType.CELL, CommunicationType.HOTEL});
    private static EnumSet<CommunicationType> emailTypes = EnumSet.of(CommunicationType.EMAIL);

    public static PersonalDataPersonSearchData getPersonSearchData(EntityReference<Person> personReference, Person person) {
        ArrayList<PersonalDataPersonName> personNames = new ArrayList<PersonalDataPersonName>();
        ArrayList<PersonalDataPersonPassport> personPassports = new ArrayList<PersonalDataPersonPassport>();
        ArrayList<PersonalDataPersonPhone> personPhones = new ArrayList<PersonalDataPersonPhone>();
        ArrayList<PersonalDataPersonEmail> personEmails = new ArrayList<PersonalDataPersonEmail>();
        Set locales = Stream.concat(person.getLastName().getValues().keySet().stream(), Stream.concat(person.getFirstName().getValues().keySet().stream(), person.getMiddleName().getValues().keySet().stream())).collect(Collectors.toSet());
        for (Locale locale : locales) {
            String lastName = (String)person.getLastName().getValues().get(locale);
            String firstName = (String)person.getFirstName().getValues().get(locale);
            String middleName = (String)person.getMiddleName().getValues().get(locale);
            lastName = !TextUtil.isBlank((String)lastName) ? lastName.trim() : null;
            firstName = !TextUtil.isBlank((String)firstName) ? firstName.trim() : null;
            String string = middleName = !TextUtil.isBlank((String)middleName) ? middleName.trim() : null;
            if (lastName == null || firstName == null) continue;
            PersonalDataPersonName personName = new PersonalDataPersonName();
            personName.setLastName(lastName);
            personName.setFirstName(firstName);
            if (middleName != null) {
                personName.setMiddleName(middleName);
            }
            personNames.add(personName);
        }
        for (Object passport : person.getPassports()) {
            PersonalDataPersonPassport personPassport = new PersonalDataPersonPassport();
            String number = passport.getNumber();
            number = !TextUtil.isBlank((String)number) ? number.trim() : null;
            if (number == null) continue;
            personPassport.setNumber(number);
            personPassports.add(personPassport);
        }
        List phones = person.getCommunications().stream().filter(item -> phoneTypes.contains(item.getType())).collect(Collectors.toList());
        for (Object phone : phones) {
            PersonalDataPersonPhone personPhone = new PersonalDataPersonPhone();
            String number = ProfileHelper.buildFullPhoneNumber((Communication)phone);
            number = !TextUtil.isBlank((String)number) ? number.trim() : null;
            if (number == null) continue;
            personPhone.setNumber(number);
            personPhones.add(personPhone);
        }
        List emails = person.getCommunications().stream().filter(item -> emailTypes.contains(item.getType())).collect(Collectors.toList());
        for (Communication email : emails) {
            PersonalDataPersonEmail personEmail = new PersonalDataPersonEmail();
            String address = email.getSense();
            address = !TextUtil.isBlank((String)address) ? address.trim() : null;
            if (address == null) continue;
            personEmail.setAddress(address);
            personEmails.add(personEmail);
        }
        PersonalDataPersonSearchData searchData = new PersonalDataPersonSearchData();
        searchData.setPerson(personReference);
        searchData.getNames().clear();
        searchData.getNames().addAll(personNames);
        searchData.getPassports().clear();
        searchData.getPassports().addAll(personPassports);
        searchData.getPhones().clear();
        searchData.getPhones().addAll(personPhones);
        searchData.getEmails().clear();
        searchData.getEmails().addAll(personEmails);
        return searchData;
    }

    public static List<PersonalDataSearchResultItem> getPersonSearchResultItems(PersonalDataPersonSearchData searchData, Person person) {
        ArrayList<PersonalDataSearchResultItem> resultItems = new ArrayList<PersonalDataSearchResultItem>();
        resultItems.clear();
        ArrayList<PersonalDataPersonName> expectedNames = new ArrayList<PersonalDataPersonName>();
        expectedNames.clear();
        expectedNames.addAll(searchData.getNames());
        if (expectedNames.size() > 0) {
            ArrayList<PersonalDataPersonName> actualNames = new ArrayList<PersonalDataPersonName>();
            actualNames.clear();
            Set locales = Stream.concat(person.getLastName().getValues().keySet().stream(), Stream.concat(person.getFirstName().getValues().keySet().stream(), person.getMiddleName().getValues().keySet().stream())).collect(Collectors.toSet());
            for (Locale locale : locales) {
                PersonalDataPersonName actualName = new PersonalDataPersonName();
                actualName.setLastName((String)person.getLastName().getValues().get(locale));
                actualName.setFirstName((String)person.getFirstName().getValues().get(locale));
                actualName.setMiddleName((String)person.getMiddleName().getValues().get(locale));
                actualNames.add(actualName);
            }
            resultItems.addAll(PersonalDataHelper.getNameSearchResultItems(expectedNames, actualNames));
        }
        ArrayList<PersonalDataPersonPassport> expectedPassports = new ArrayList<PersonalDataPersonPassport>();
        expectedPassports.clear();
        expectedPassports.addAll(searchData.getPassports());
        if (expectedPassports.size() > 0) {
            ArrayList<PersonalDataPersonPassport> actualPassports = new ArrayList<PersonalDataPersonPassport>();
            actualPassports.clear();
            for (Passport passport : person.getPassports()) {
                PersonalDataPersonPassport actualPassport = new PersonalDataPersonPassport();
                actualPassport.setNumber(passport.getNumber());
                actualPassports.add(actualPassport);
            }
            resultItems.addAll(PersonalDataHelper.getPassportSearchResultItems(expectedPassports, actualPassports));
        }
        ArrayList<PersonalDataPersonPhone> expectedPhones = new ArrayList<PersonalDataPersonPhone>();
        expectedPhones.clear();
        expectedPhones.addAll(searchData.getPhones());
        if (expectedPhones.size() > 0) {
            ArrayList<PersonalDataPersonPhone> actualPhones = new ArrayList<PersonalDataPersonPhone>();
            actualPhones.clear();
            List phones = person.getCommunications().stream().filter(item -> phoneTypes.contains(item.getType())).collect(Collectors.toList());
            for (Communication phone : phones) {
                PersonalDataPersonPhone actualPhone = new PersonalDataPersonPhone();
                actualPhone.setNumber(ProfileHelper.buildFullPhoneNumber(phone));
                actualPhones.add(actualPhone);
            }
            resultItems.addAll(PersonalDataHelper.getPhoneSearchResultItems(expectedPhones, actualPhones));
        }
        ArrayList<PersonalDataPersonEmail> expectedEmails = new ArrayList<PersonalDataPersonEmail>();
        expectedEmails.clear();
        expectedEmails.addAll(searchData.getEmails());
        if (expectedEmails.size() > 0) {
            ArrayList<PersonalDataPersonEmail> actualEmails = new ArrayList<PersonalDataPersonEmail>();
            actualEmails.clear();
            List emails = person.getCommunications().stream().filter(item -> emailTypes.contains(item.getType())).collect(Collectors.toList());
            for (Communication email : emails) {
                PersonalDataPersonEmail actualEmail = new PersonalDataPersonEmail();
                actualEmail.setAddress(email.getSense());
                actualEmails.add(actualEmail);
            }
            resultItems.addAll(PersonalDataHelper.getEmailSearchResultItems(expectedEmails, actualEmails));
        }
        return resultItems;
    }

    public static List<PersonalDataSearchResultItem> getTravellerSearchResultItems(PersonalDataPersonSearchData searchData, Traveller traveller) {
        ArrayList<PersonalDataSearchResultItem> resultItems = new ArrayList<PersonalDataSearchResultItem>();
        resultItems.clear();
        ArrayList<PersonalDataPersonName> expectedNames = new ArrayList<PersonalDataPersonName>();
        expectedNames.clear();
        expectedNames.addAll(searchData.getNames());
        if (expectedNames.size() > 0) {
            ArrayList<String> actualFullNames = new ArrayList<String>();
            actualFullNames.clear();
            actualFullNames.addAll(Stream.of(traveller.getName(), traveller.getCyrillicName(), traveller.getNameInGds()).filter(item -> !TextUtil.isBlank((String)item)).collect(Collectors.toList()));
            resultItems.addAll(PersonalDataHelper.getFullNameSearchResultItems(expectedNames, actualFullNames));
        }
        ArrayList<PersonalDataPersonPassport> expectedPassports = new ArrayList<PersonalDataPersonPassport>();
        expectedPassports.clear();
        expectedPassports.addAll(searchData.getPassports());
        if (expectedPassports.size() > 0) {
            ArrayList<PersonalDataPersonPassport> actualPassports = new ArrayList<PersonalDataPersonPassport>();
            actualPassports.clear();
            Passport passport = traveller.getPassport();
            if (passport != null) {
                PersonalDataPersonPassport actualPassport = new PersonalDataPersonPassport();
                actualPassport.setNumber(passport.getNumber());
                actualPassports.add(actualPassport);
            }
            resultItems.addAll(PersonalDataHelper.getPassportSearchResultItems(expectedPassports, actualPassports));
        }
        ArrayList<PersonalDataPersonPhone> expectedPhones = new ArrayList<PersonalDataPersonPhone>();
        expectedPhones.clear();
        expectedPhones.addAll(searchData.getPhones());
        if (expectedPhones.size() > 0) {
            ArrayList<PersonalDataPersonPhone> actualPhones = new ArrayList<PersonalDataPersonPhone>();
            actualPhones.clear();
            List phones = traveller.getCommunications().stream().filter(item -> phoneTypes.contains(item.getType())).collect(Collectors.toList());
            for (Communication phone : phones) {
                PersonalDataPersonPhone actualPhone = new PersonalDataPersonPhone();
                actualPhone.setNumber(ProfileHelper.buildFullPhoneNumber(phone));
                actualPhones.add(actualPhone);
            }
            resultItems.addAll(PersonalDataHelper.getPhoneSearchResultItems(expectedPhones, actualPhones));
        }
        ArrayList<PersonalDataPersonEmail> expectedEmails = new ArrayList<PersonalDataPersonEmail>();
        expectedEmails.clear();
        expectedEmails.addAll(searchData.getEmails());
        if (expectedEmails.size() > 0) {
            ArrayList<PersonalDataPersonEmail> actualEmails = new ArrayList<PersonalDataPersonEmail>();
            actualEmails.clear();
            List emails = traveller.getCommunications().stream().filter(item -> emailTypes.contains(item.getType())).collect(Collectors.toList());
            for (Communication email : emails) {
                PersonalDataPersonEmail actualEmail = new PersonalDataPersonEmail();
                actualEmail.setAddress(email.getSense());
                actualEmails.add(actualEmail);
            }
            resultItems.addAll(PersonalDataHelper.getEmailSearchResultItems(expectedEmails, actualEmails));
        }
        return resultItems;
    }

    public static List<PersonalDataSearchResultItem> getCustomerSearchResultItems(PersonalDataPersonSearchData searchData, Customer customer) {
        ArrayList<PersonalDataSearchResultItem> resultItems = new ArrayList<PersonalDataSearchResultItem>();
        resultItems.clear();
        ArrayList<PersonalDataPersonName> expectedNames = new ArrayList<PersonalDataPersonName>();
        expectedNames.clear();
        expectedNames.addAll(searchData.getNames());
        if (expectedNames.size() > 0) {
            ArrayList<String> actualFullNames = new ArrayList<String>();
            actualFullNames.clear();
            actualFullNames.addAll(Stream.of(customer.getName()).filter(item -> !TextUtil.isBlank((String)item)).collect(Collectors.toList()));
            resultItems.addAll(PersonalDataHelper.getFullNameSearchResultItems(expectedNames, actualFullNames));
        }
        ArrayList<PersonalDataPersonPassport> expectedPassports = new ArrayList<PersonalDataPersonPassport>();
        expectedPassports.clear();
        expectedPassports.addAll(searchData.getPassports());
        if (expectedPassports.size() > 0) {
            ArrayList<PersonalDataPersonPassport> actualPassports = new ArrayList<PersonalDataPersonPassport>();
            actualPassports.clear();
            Passport passport = customer.getPassport();
            if (passport != null) {
                PersonalDataPersonPassport actualPassport = new PersonalDataPersonPassport();
                actualPassport.setNumber(passport.getNumber());
                actualPassports.add(actualPassport);
            }
            resultItems.addAll(PersonalDataHelper.getPassportSearchResultItems(expectedPassports, actualPassports));
        }
        ArrayList<PersonalDataPersonPhone> expectedPhones = new ArrayList<PersonalDataPersonPhone>();
        expectedPhones.clear();
        expectedPhones.addAll(searchData.getPhones());
        if (expectedPhones.size() > 0) {
            ArrayList<PersonalDataPersonPhone> actualPhones = new ArrayList<PersonalDataPersonPhone>();
            actualPhones.clear();
            List phones = customer.getCommunications().stream().filter(item -> phoneTypes.contains(item.getType())).collect(Collectors.toList());
            for (Communication phone : phones) {
                PersonalDataPersonPhone actualPhone = new PersonalDataPersonPhone();
                actualPhone.setNumber(ProfileHelper.buildFullPhoneNumber(phone));
                actualPhones.add(actualPhone);
            }
            resultItems.addAll(PersonalDataHelper.getPhoneSearchResultItems(expectedPhones, actualPhones));
        }
        ArrayList<PersonalDataPersonEmail> expectedEmails = new ArrayList<PersonalDataPersonEmail>();
        expectedEmails.clear();
        expectedEmails.addAll(searchData.getEmails());
        if (expectedEmails.size() > 0) {
            ArrayList<PersonalDataPersonEmail> actualEmails = new ArrayList<PersonalDataPersonEmail>();
            actualEmails.clear();
            List emails = customer.getCommunications().stream().filter(item -> emailTypes.contains(item.getType())).collect(Collectors.toList());
            for (Communication email : emails) {
                PersonalDataPersonEmail actualEmail = new PersonalDataPersonEmail();
                actualEmail.setAddress(email.getSense());
                actualEmails.add(actualEmail);
            }
            resultItems.addAll(PersonalDataHelper.getEmailSearchResultItems(expectedEmails, actualEmails));
        }
        return resultItems;
    }

    private static List<PersonalDataSearchResultItem> getNameSearchResultItems(List<PersonalDataPersonName> expectedNames, List<PersonalDataPersonName> actualNames) {
        ArrayList<PersonalDataSearchResultItem> resultItems = new ArrayList<PersonalDataSearchResultItem>();
        for (PersonalDataPersonName expectedName : expectedNames) {
            PersonalDataPersonName actualName = (PersonalDataPersonName)CollectionUtil.find(actualNames, (Object)expectedName, (CollectionUtil.Equator)new CollectionUtil.Equator<PersonalDataPersonName, PersonalDataPersonName>(){

                public boolean equal(PersonalDataPersonName o1, PersonalDataPersonName o2) {
                    String lastName1 = Optional.ofNullable(o1.getLastName()).filter(item -> !TextUtil.isBlank((String)item)).map(item -> item.trim().toLowerCase()).orElse(null);
                    String firstName1 = Optional.ofNullable(o1.getFirstName()).filter(item -> !TextUtil.isBlank((String)item)).map(item -> item.trim().toLowerCase()).orElse(null);
                    String lastName2 = Optional.ofNullable(o2.getLastName()).filter(item -> !TextUtil.isBlank((String)item)).map(item -> item.trim().toLowerCase()).orElse(null);
                    String firstName2 = Optional.ofNullable(o2.getFirstName()).filter(item -> !TextUtil.isBlank((String)item)).map(item -> item.trim().toLowerCase()).orElse(null);
                    return !(lastName1 == null || lastName2 != null && !lastName1.contains(lastName2) && !lastName2.contains(lastName1) || firstName2 != null && !firstName1.contains(firstName2) && !firstName2.contains(firstName1));
                }
            });
            PersonalDataSearchResultItem resultItem = new PersonalDataSearchResultItem();
            String expectedLastName = Optional.ofNullable(expectedName.getLastName()).filter(item -> !TextUtil.isBlank((String)item)).map(item -> item.trim()).orElse(null);
            String expectedFirstName = Optional.ofNullable(expectedName.getFirstName()).filter(item -> !TextUtil.isBlank((String)item)).map(item -> item.trim()).orElse(null);
            String expectedMiddleName = Optional.ofNullable(expectedName.getMiddleName()).filter(item -> !TextUtil.isBlank((String)item)).map(item -> item.trim()).orElse(null);
            resultItem.setExpected(Stream.of(expectedLastName, expectedFirstName, expectedMiddleName).filter(item -> item != null).collect(Collectors.joining(" ")));
            if (actualName != null) {
                actualNames.remove(actualName);
                String actualLastName = Optional.ofNullable(actualName.getLastName()).filter(item -> !TextUtil.isBlank((String)item)).map(item -> item.trim()).orElse(null);
                String actualFirstName = Optional.ofNullable(actualName.getFirstName()).filter(item -> !TextUtil.isBlank((String)item)).map(item -> item.trim()).orElse(null);
                String actualMiddleName = Optional.ofNullable(actualName.getMiddleName()).filter(item -> !TextUtil.isBlank((String)item)).map(item -> item.trim()).orElse(null);
                resultItem.setActual(Stream.of(actualLastName, actualFirstName, actualMiddleName).filter(item -> item != null).collect(Collectors.joining(" ")));
            }
            resultItems.add(resultItem);
        }
        return resultItems;
    }

    private static List<PersonalDataSearchResultItem> getFullNameSearchResultItems(List<PersonalDataPersonName> expectedNames, List<String> actualFullNames) {
        ArrayList<PersonalDataSearchResultItem> resultItems = new ArrayList<PersonalDataSearchResultItem>();
        for (PersonalDataPersonName expectedName : expectedNames) {
            String actualFullName = (String)CollectionUtil.find(actualFullNames, (Object)expectedName, (CollectionUtil.Equator)new CollectionUtil.Equator<String, PersonalDataPersonName>(){

                public boolean equal(String o1, PersonalDataPersonName o2) {
                    String fullName = Optional.ofNullable(o1).filter(item -> !TextUtil.isBlank((String)item)).map(item -> item.trim().toLowerCase()).orElse(null);
                    String lastName = Optional.ofNullable(o2.getLastName()).filter(item -> !TextUtil.isBlank((String)item)).map(item -> item.trim().toLowerCase()).orElse(null);
                    String firstName = Optional.ofNullable(o2.getFirstName()).filter(item -> !TextUtil.isBlank((String)item)).map(item -> item.trim().toLowerCase()).orElse(null);
                    return !(fullName == null || lastName != null && !fullName.contains(lastName) || firstName != null && !fullName.contains(firstName));
                }
            });
            PersonalDataSearchResultItem resultItem = new PersonalDataSearchResultItem();
            String expectedLastName = Optional.ofNullable(expectedName.getLastName()).filter(item -> !TextUtil.isBlank((String)item)).map(item -> item.trim()).orElse(null);
            String expectedFirstName = Optional.ofNullable(expectedName.getFirstName()).filter(item -> !TextUtil.isBlank((String)item)).map(item -> item.trim()).orElse(null);
            String expectedMiddleName = Optional.ofNullable(expectedName.getMiddleName()).filter(item -> !TextUtil.isBlank((String)item)).map(item -> item.trim()).orElse(null);
            resultItem.setExpected(Stream.of(expectedLastName, expectedFirstName, expectedMiddleName).filter(item -> item != null).collect(Collectors.joining(" ")));
            if (actualFullName != null) {
                actualFullNames.remove(actualFullName);
                resultItem.setActual((String)Optional.ofNullable(actualFullName).filter(item -> !TextUtil.isBlank((String)item)).map(item -> item.trim()).orElse(null));
            }
            resultItems.add(resultItem);
        }
        return resultItems;
    }

    private static List<PersonalDataSearchResultItem> getPassportSearchResultItems(List<PersonalDataPersonPassport> expectedPassports, List<PersonalDataPersonPassport> actualPassports) {
        ArrayList<PersonalDataSearchResultItem> resultItems = new ArrayList<PersonalDataSearchResultItem>();
        for (PersonalDataPersonPassport expectedPassport : expectedPassports) {
            PersonalDataPersonPassport actualPassport = (PersonalDataPersonPassport)CollectionUtil.find(actualPassports, (Object)expectedPassport, (CollectionUtil.Equator)new CollectionUtil.Equator<PersonalDataPersonPassport, PersonalDataPersonPassport>(){

                public boolean equal(PersonalDataPersonPassport o1, PersonalDataPersonPassport o2) {
                    String number1 = Optional.ofNullable(o1.getNumber()).filter(item -> !TextUtil.isBlank((String)item)).map(item -> item.trim().toLowerCase()).orElse(null);
                    String number2 = Optional.ofNullable(o2.getNumber()).filter(item -> !TextUtil.isBlank((String)item)).map(item -> item.trim().toLowerCase()).orElse(null);
                    return number1 != null && number2 != null && (number1.contains(number2) || number2.contains(number1));
                }
            });
            PersonalDataSearchResultItem resultItem = new PersonalDataSearchResultItem();
            String expectedNumber = Optional.ofNullable(expectedPassport.getNumber()).filter(item -> !TextUtil.isBlank((String)item)).map(item -> item.trim()).orElse(null);
            resultItem.setExpected(expectedNumber);
            if (actualPassport != null) {
                actualPassports.remove(actualPassport);
                String actualNumber = Optional.ofNullable(actualPassport.getNumber()).filter(item -> !TextUtil.isBlank((String)item)).map(item -> item.trim()).orElse(null);
                resultItem.setActual(actualNumber);
            }
            resultItems.add(resultItem);
        }
        return resultItems;
    }

    private static List<PersonalDataSearchResultItem> getPhoneSearchResultItems(List<PersonalDataPersonPhone> expectedPhones, List<PersonalDataPersonPhone> actualPhones) {
        ArrayList<PersonalDataSearchResultItem> resultItems = new ArrayList<PersonalDataSearchResultItem>();
        for (PersonalDataPersonPhone expectedPhone : expectedPhones) {
            PersonalDataPersonPhone actualPhone = (PersonalDataPersonPhone)CollectionUtil.find(actualPhones, (Object)expectedPhone, (CollectionUtil.Equator)new CollectionUtil.Equator<PersonalDataPersonPhone, PersonalDataPersonPhone>(){

                public boolean equal(PersonalDataPersonPhone o1, PersonalDataPersonPhone o2) {
                    String number1 = Optional.ofNullable(o1.getNumber()).filter(item -> !TextUtil.isBlank((String)item)).map(item -> item.replaceAll("\\D", "").trim().toLowerCase()).orElse(null);
                    String number2 = Optional.ofNullable(o2.getNumber()).filter(item -> !TextUtil.isBlank((String)item)).map(item -> item.replaceAll("\\D", "").trim().toLowerCase()).orElse(null);
                    return number1 != null && number2 != null && (number1.contains(number2) || number2.contains(number1));
                }
            });
            PersonalDataSearchResultItem resultItem = new PersonalDataSearchResultItem();
            String expectedNumber = Optional.ofNullable(expectedPhone.getNumber()).filter(item -> !TextUtil.isBlank((String)item)).map(item -> item.trim()).orElse(null);
            resultItem.setExpected(expectedNumber);
            if (actualPhone != null) {
                actualPhones.remove(actualPhone);
                String actualNumber = Optional.ofNullable(actualPhone.getNumber()).filter(item -> !TextUtil.isBlank((String)item)).map(item -> item.trim()).orElse(null);
                resultItem.setActual(actualNumber);
            }
            resultItems.add(resultItem);
        }
        return resultItems;
    }

    private static List<PersonalDataSearchResultItem> getEmailSearchResultItems(List<PersonalDataPersonEmail> expectedEmails, List<PersonalDataPersonEmail> actualEmails) {
        ArrayList<PersonalDataSearchResultItem> resultItems = new ArrayList<PersonalDataSearchResultItem>();
        for (PersonalDataPersonEmail expectedEmail : expectedEmails) {
            PersonalDataPersonEmail actualEmail = (PersonalDataPersonEmail)CollectionUtil.find(actualEmails, (Object)expectedEmail, (CollectionUtil.Equator)new CollectionUtil.Equator<PersonalDataPersonEmail, PersonalDataPersonEmail>(){

                public boolean equal(PersonalDataPersonEmail o1, PersonalDataPersonEmail o2) {
                    String email1 = Optional.ofNullable(o1.getAddress()).filter(item -> !TextUtil.isBlank((String)item)).map(item -> item.trim().toLowerCase()).orElse(null);
                    String email2 = Optional.ofNullable(o2.getAddress()).filter(item -> !TextUtil.isBlank((String)item)).map(item -> item.trim().toLowerCase()).orElse(null);
                    return email1 != null && email2 != null && (email1.contains(email2) || email2.contains(email1));
                }
            });
            PersonalDataSearchResultItem resultItem = new PersonalDataSearchResultItem();
            String expectedAddress = Optional.ofNullable(expectedEmail.getAddress()).filter(item -> !TextUtil.isBlank((String)item)).map(item -> item.trim()).orElse(null);
            resultItem.setExpected(expectedAddress);
            if (actualEmail != null) {
                actualEmails.remove(actualEmail);
                String actualAddress = Optional.ofNullable(actualEmail.getAddress()).filter(item -> !TextUtil.isBlank((String)item)).map(item -> item.trim()).orElse(null);
                resultItem.setActual(actualAddress);
            }
            resultItems.add(resultItem);
        }
        return resultItems;
    }
}

