/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.redapp.sws;

import com.gridnine.xtrip.common.model.redapp.sws.RemarkType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

public class Remark
implements Comparable<Remark>,
Cloneable {
    private String text;
    private String code;
    private RemarkType type;
    private String rph;
    private String segmentNumber;
    private List<PersonName> personsList = new ArrayList<PersonName>();

    public Remark() {
    }

    public Remark(String text) {
        this.text = text;
    }

    public Remark(String text, String code, RemarkType type) {
        this.text = text;
        this.code = code;
        this.type = type;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public RemarkType getType() {
        return this.type;
    }

    public void setType(RemarkType type) {
        this.type = type;
    }

    public String getRph() {
        return this.rph;
    }

    public void setRph(String rph) {
        this.rph = rph;
    }

    public List<PersonName> getPersonsList() {
        return this.personsList;
    }

    public static Predicate<Remark> distinctByZeroNumber(List<Remark> zeroList) {
        return t -> zeroList.stream().noneMatch(k -> k.getText().contains(t.getText().substring(0, t.getText().length() - 3)));
    }

    @Override
    public int compareTo(Remark o) {
        int result = this.text.substring(this.text.lastIndexOf("-") + 1).compareTo(o.text.substring(o.text.lastIndexOf("-") + 1));
        if (result != 0) {
            return result;
        }
        return this.text.compareTo(o.text);
    }

    public Remark clone() {
        Remark remark = new Remark();
        Optional.ofNullable(this.getText()).map(String::new).ifPresent(remark::setText);
        Optional.ofNullable(this.getRph()).map(String::new).ifPresent(remark::setRph);
        Optional.ofNullable(this.getCode()).map(String::new).ifPresent(remark::setCode);
        Optional.ofNullable(this.getSegmentNumber()).map(String::new).ifPresent(remark::setSegmentNumber);
        Optional.ofNullable(this.getType()).map(Enum::name).map(RemarkType::valueOf).ifPresent(remark::setType);
        return remark;
    }

    public String getSegmentNumber() {
        return this.segmentNumber;
    }

    public void setSegmentNumber(String segmentNumber) {
        this.segmentNumber = segmentNumber;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.rph == null ? 0 : this.rph.hashCode());
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Remark other = (Remark)obj;
        if (this.rph == null ? other.rph != null : !this.rph.equals(other.rph)) {
            return false;
        }
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }

    public static class PersonName {
        private String name;
        private String nameNumber;

        public PersonName() {
        }

        public PersonName(String name, String nameNumber) {
            this.name = name;
            this.nameNumber = nameNumber;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getNameNumber() {
            return this.nameNumber;
        }

        public void setNameNumber(String nameNumber) {
            this.nameNumber = nameNumber;
        }
    }
}

