/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.redapp.sws;

import com.gridnine.xtrip.common.model.redapp.sws.AirSegment;
import com.gridnine.xtrip.common.model.redapp.sws.Itinerary;
import com.gridnine.xtrip.common.model.redapp.sws.PassengerType;
import com.gridnine.xtrip.common.model.redapp.sws.Segment;
import com.gridnine.xtrip.common.model.redapp.sws.Traveller;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class SWSModelHelper {
    public static final String AIR_PASSIVE_SEGMENT_CODE = "YK";
    public static final String OPEN_AIR_PASSIVE_SEGMENT_CODE = "DS";
    public static final String DOCS = "DOCS";
    public static final String CTCM = "CTCM";
    public static final String CTCE = "CTCE";
    public static final String CHLD = "CHLD";
    public static final String INFT = "INFT";
    public static final String INST = "INST";
    public static final String unknownAirlineCode = "YY";
    public static final String unknownArrivalGeolocationCode = "AVH";
    public static final String unknownDepartureGeolocationCode = "DVH";

    public static long independentPasengersCount(Itinerary itinerary) {
        return SWSModelHelper.hasPassengers(itinerary) ? itinerary.getPassengers().stream().map(Traveller::getPassengerType).filter(t -> !PassengerType.INFANT.equals(t)).count() : 0L;
    }

    public static boolean hasPassengers(Itinerary itinerary) {
        return itinerary != null && !itinerary.getPassengers().isEmpty();
    }

    public static boolean isAdultTraveller(Traveller traveller) {
        return !SWSModelHelper.isInfantType(traveller.getPassengerType());
    }

    public static boolean isInfantType(PassengerType type) {
        return PassengerType.INFANT.equals(type) || PassengerType.INFANT_WITH_SEAT.equals(type);
    }

    public static String buildFullName(Traveller traveller) {
        String firstMiddleName;
        StringBuilder builder = new StringBuilder();
        if (!TextUtil.isBlank((String)traveller.getLastName())) {
            builder.append(traveller.getLastName());
        }
        if (!TextUtil.isBlank((String)(firstMiddleName = SWSModelHelper.getFirstAndMiddleName(traveller)))) {
            builder.append(" ").append(firstMiddleName);
        }
        return builder.toString();
    }

    public static List<String> buildFullNameString(Traveller traveller) {
        StringBuilder builder = new StringBuilder(SWSModelHelper.buildFullName(traveller));
        List<String> result = new ArrayList<String>();
        if (traveller.getGender() != null) {
            builder.append(" ");
            result = traveller.getGender().getPrefixes().stream().map(builder::append).map(StringBuilder::toString).collect(Collectors.toList());
        } else {
            result.add(builder.toString());
        }
        return result;
    }

    public static Traveller findTraveler(Itinerary itinerary, String fullName) {
        return itinerary.getPassengers().stream().filter(t -> {
            String swsName = SWSModelHelper.buildFullName(t);
            return swsName.equalsIgnoreCase(fullName);
        }).findAny().orElse(null);
    }

    public static Traveller lookUpTraveler(Itinerary itinerary, String fullName) {
        return itinerary.getPassengers().stream().filter(t -> {
            String swsName = SWSModelHelper.buildFullName(t);
            return swsName.replaceAll(" ", "").contains(fullName.replaceAll(" ", ""));
        }).findAny().orElse(null);
    }

    public static Segment findSegmentByRph(Itinerary itinerary, int rph) {
        return itinerary.getAllSegments().stream().filter(s -> rph == s.getRph()).findAny().orElse(null);
    }

    public static String getFirstAndMiddleName(Traveller traveller) {
        StringBuilder builder = new StringBuilder();
        if (!TextUtil.isBlank((String)traveller.getFirstName())) {
            builder.append(traveller.getFirstName());
        }
        if (!TextUtil.isBlank((String)traveller.getMiddleName())) {
            builder.append(" ").append(traveller.getMiddleName());
        }
        return builder.toString();
    }

    public static boolean isPassiveAirSegment(AirSegment segment) {
        return OPEN_AIR_PASSIVE_SEGMENT_CODE.equalsIgnoreCase(segment.getStatus()) && "OPEN".equalsIgnoreCase(segment.getFlightNumber()) || unknownAirlineCode.equalsIgnoreCase(segment.getMarketingAirline()) && AIR_PASSIVE_SEGMENT_CODE.equalsIgnoreCase(segment.getStatus());
    }
}

