/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.redapp.vat.command;

import com.gridnine.xtrip.common.model.redapp.sws.Endorsement;
import com.gridnine.xtrip.common.model.redapp.sws.EndorsementType;
import com.gridnine.xtrip.common.model.redapp.sws.PriceQuote;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.List;
import java.util.stream.Collectors;

public class RewriteEndorsementCommand {
    private static final String DELIMITER = String.valueOf('\u0081');
    private static final String W = "W";
    private static final String I = "I";
    private static final String ED = "ED/";
    private static final String EO = "EO/";
    private static final String EO2 = "EO2/";
    private final List<Endorsement> endorsements;
    private final String pqNumber;

    private RewriteEndorsementCommand(List<Endorsement> endorsements, String pqNumber) {
        this.endorsements = endorsements;
        this.pqNumber = pqNumber;
    }

    public List<Endorsement> getEndorsements() {
        return this.endorsements;
    }

    public static RewriteEndorsementCommand of(PriceQuote priceQuote) {
        List<Endorsement> endorsements = priceQuote.getEndorsements().stream().filter(e -> e.getType() == EndorsementType.ENDORSEMENT_OVERRIDE_ED || e.getType() == EndorsementType.ENDORSEMENT_OVERRIDE || e.getType() == EndorsementType.ENDORSEMENT_OVERRIDE_1 || e.getType() == EndorsementType.ENDORSEMENT_OVERRIDE_2).collect(Collectors.toList());
        String pqNumber = String.valueOf(priceQuote.getRph());
        return new RewriteEndorsementCommand(endorsements, pqNumber);
    }

    public String toSabreCommand(String vatEndorsement) {
        StringBuilder builder = new StringBuilder(W + DELIMITER + I + this.pqNumber + DELIMITER);
        String existingEndorsement = "";
        if (this.endorsements.isEmpty()) {
            builder.append(ED);
        } else {
            Endorsement endorsement = this.endorsements.get(0);
            if (endorsement.getType() == EndorsementType.ENDORSEMENT_OVERRIDE_ED) {
                builder.append(ED);
                existingEndorsement = endorsement.getText();
            } else if (endorsement.getType() == EndorsementType.ENDORSEMENT_OVERRIDE) {
                builder.append(EO);
                existingEndorsement = endorsement.getText();
            } else if (endorsement.getType() == EndorsementType.ENDORSEMENT_OVERRIDE_1 || endorsement.getType() == EndorsementType.ENDORSEMENT_OVERRIDE_2) {
                builder.append(EO2);
                existingEndorsement = this.endorsements.stream().filter(e -> e.getType() == EndorsementType.ENDORSEMENT_OVERRIDE_2).findFirst().map(Endorsement::getText).orElse("");
            }
        }
        if (TextUtil.nonBlank((String)existingEndorsement)) {
            builder.append(existingEndorsement);
            builder.append("/");
        }
        builder.append(vatEndorsement);
        return builder.toString();
    }
}

