/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.redapp.vat.handlers;

import com.gridnine.xtrip.common.model.redapp.VatDetalization;
import com.gridnine.xtrip.common.model.redapp.vat.handlers.VatDetalizationHandler;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public abstract class AbstractVatDetalizationHandler
implements VatDetalizationHandler {
    protected final List<VatDetalization> vatDetails = new ArrayList<VatDetalization>();

    @Override
    public boolean isVatPositive() {
        return this.vatDetails.stream().map(VatDetalization::getVatAmount).reduce(BigDecimal::add).filter(vat -> vat.signum() != -1).isPresent();
    }

    protected String formatRate(BigDecimal rate) {
        return Optional.ofNullable(rate).map(BigDecimal::stripTrailingZeros).map(BigDecimal::toPlainString).orElse(null);
    }

    void acceptVatDetalization(List<VatDetalization> details) {
        this.vatDetails.clear();
        this.vatDetails.addAll(details);
    }

    protected abstract boolean hasVatEntry(String var1);

    protected abstract boolean hasOnlyVatEndorsement(String var1);
}

