/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.redapp.vat.parsers.remark;

import com.gridnine.xtrip.common.model.redapp.sws.Remark;
import com.gridnine.xtrip.common.model.redapp.sws.RemarkType;
import com.gridnine.xtrip.common.model.redapp.sws.remark.RemarkController;
import com.gridnine.xtrip.common.model.redapp.vat.parsers.remark.VatRateRemark;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VatRateRemarkParser
implements RemarkController<VatRateRemark> {
    private static final Pattern PATTERN = Pattern.compile("X\\*INCL VAT A\\/C (?<ticketVat>[0-9.-]*)\\/(?<ticketVatRate>[0-9.-]*)P\\/-(?<travelerNumber>[0-9]{1,2}\\.[0-9]{1,2})?");

    @Override
    public boolean match(Remark remark) {
        return remark.getType() == RemarkType.Invoice && PATTERN.matcher(remark.getText()).matches();
    }

    @Override
    public VatRateRemark parse(Remark remark) {
        Matcher matcher = PATTERN.matcher(remark.getText());
        if (matcher.matches()) {
            return new VatRateRemark(remark.getRph(), matcher.group("ticketVat"), matcher.group("ticketVatRate"), matcher.group("travelerNumber"));
        }
        throw new IllegalStateException(String.format("Cannot parse remark [ %s ]", remark.getText()));
    }

    @Override
    public Remark compose(VatRateRemark consoleRemark) {
        StringBuilder sb = new StringBuilder("X*INCL VAT A/C ");
        if (consoleRemark.getTicketVatAmount() != null) {
            sb.append(consoleRemark.getTicketVatAmount());
        }
        sb.append("/");
        if (consoleRemark.getTicketVatRate() != null) {
            sb.append(consoleRemark.getTicketVatRate()).append("P");
        }
        sb.append("/-");
        if (consoleRemark.getTravelerNameNumber() != null) {
            sb.append(consoleRemark.getTravelerNameNumber());
        }
        Remark result = new Remark();
        result.setType(RemarkType.Invoice);
        result.setText(sb.toString());
        return result;
    }

    @Override
    public Class<VatRateRemark> getRemarkClass() {
        return VatRateRemark.class;
    }
}

