/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.restriction.resource;

import com.gridnine.xtrip.common.meta.IndexProperty;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionIndexResourceOwnershipProperty;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionIndexResourcePropertyProperty;
import com.gridnine.xtrip.common.restriction.resource.RestrictionQueryable;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceProperty;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourcePropertyCategory;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelRestrictionIndexResourcePropertyProperties {
    private static final Logger log = LoggerFactory.getLogger(ModelRestrictionIndexResourcePropertyProperties.class);
    protected static final List<RestrictionResourceProperty> properties = new ArrayList<RestrictionResourceProperty>();

    public static List<RestrictionResourceProperty> getProperties() {
        return properties;
    }

    static {
        for (IndexType index : MetaRegistry.get().getIndexes().values()) {
            properties.add(new ModelRestrictionIndexResourceOwnershipProperty(index));
            properties.add(new SystemIndexProperty(index.getId(), "entityType", String.class, StandardRestrictionResourcePropertyCategory.STRING.name()));
            for (IndexProperty property : index.getProperties().values()) {
                if (!property.isViewable()) continue;
                properties.add(new ModelRestrictionIndexResourcePropertyProperty(index, property));
            }
        }
    }

    public static class SystemIndexProperty
    implements RestrictionResourceProperty,
    RestrictionQueryable {
        private final String indexId;
        private final String columnName;
        private final Class<?> type;
        private final String categoryId;

        public SystemIndexProperty(String indexId, String columnName, Class<?> type, String categoryId) {
            this.indexId = indexId;
            this.columnName = columnName;
            this.type = type;
            this.categoryId = categoryId;
        }

        public String getId() {
            return this.indexId + "." + this.columnName;
        }

        public String getName() {
            return "*" + this.columnName;
        }

        public String getDescriprion() {
            return this.getName();
        }

        public Class<?> getType() {
            return this.type;
        }

        public boolean isCollection() {
            return false;
        }

        public boolean isTimeIncluded() {
            return false;
        }

        public String getResourceId() {
            return this.indexId;
        }

        public String getCategoryId() {
            return this.categoryId;
        }

        public String getColumn() {
            return this.columnName;
        }

        public boolean isSystem() {
            return true;
        }
    }
}

