/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.CountryReference;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.common.model.dict.GeoRegion;
import com.gridnine.xtrip.common.model.dict.GeoRegionReference;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.test.TestBase;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class TransatlanticFlightRestrictionTest
extends TestBase {
    public void setUp() throws Exception {
        super.setUp();
        Environment.publish(DictionaryCache.class, (Object)new DictionaryCache(null){
            private final Map<String, GeoLocation> geoLocationsMap;
            private final Map<String, Set<GeoLocation>> geoLocationsIataCodes;
            private final Map<String, Country> countriesMap;
            private final Map<String, Set<Country>> countriesIataCodes;
            private final Map<String, GeoRegion> regionsMap;
            private final Map<String, Set<GeoRegion>> regionsIataCodes;
            {
                this.geoLocationsMap = new HashMap<String, GeoLocation>();
                this.geoLocationsIataCodes = new HashMap<String, Set<GeoLocation>>();
                this.countriesMap = new HashMap<String, Country>();
                this.countriesIataCodes = new HashMap<String, Set<Country>>();
                this.regionsMap = new HashMap<String, GeoRegion>();
                this.regionsIataCodes = new HashMap<String, Set<GeoRegion>>();
                this.register(this.createRegions(), this.regionsMap, this.regionsIataCodes);
                this.register(this.createCountries(), this.countriesMap, this.countriesIataCodes);
                this.register(this.createLocations(), this.geoLocationsMap, this.geoLocationsIataCodes);
            }

            protected void scheduleTimer() {
            }

            private Collection<GeoLocation> createLocations() {
                HashSet<GeoLocation> result = new HashSet<GeoLocation>();
                result.add(this.createCity("MOW", "RU"));
                result.add(this.createCity("NYC", "US"));
                result.add(this.createCity("TYO", "JP"));
                return result;
            }

            private GeoLocation createCity(String cityCode, String countryCode) {
                GeoLocation loc = new GeoLocation();
                loc.setCode(cityCode);
                loc.getCodeVariants().put(CodeSystem.IATA.name(), cityCode);
                loc.getTranslations().put(Locale.ENGLISH, cityCode);
                loc.setCountry((DictionaryReference)new CountryReference(countryCode));
                return loc;
            }

            private Set<Country> createCountries() {
                HashSet<Country> result = new HashSet<Country>();
                result.add(this.createCountry("US", "NOAM"));
                result.add(this.createCountry("RU", "CIS", "EURO"));
                result.add(this.createCountry("JP", "ASIA"));
                return result;
            }

            private Country createCountry(String countryCode, String ... regionCodes) {
                Country country = new Country();
                country.setCode(countryCode);
                country.getCodeVariants().put(CodeSystem.IATA.name(), countryCode);
                country.getTranslations().put(Locale.ENGLISH, countryCode);
                for (String code : regionCodes) {
                    country.getRegions().add(new GeoRegionReference(code));
                }
                return country;
            }

            private <T extends BaseDictionary> void register(Collection<T> items, Map<String, T> allItems, Map<String, Set<T>> iataCodes) {
                for (BaseDictionary item : items) {
                    allItems.put(item.getCode(), item);
                    for (String code : item.getCodeVariants().values()) {
                        Set<T> set = iataCodes.get(code);
                        if (set == null) {
                            set = new HashSet<T>();
                            iataCodes.put(code, set);
                        }
                        set.add(item);
                    }
                }
            }

            private Set<GeoRegion> createRegions() {
                HashSet<GeoRegion> result = new HashSet<GeoRegion>();
                result.add(this.createRegion("NOAM"));
                result.add(this.createRegion("SOAM"));
                result.add(this.createRegion("CIS"));
                result.add(this.createRegion("EURO"));
                result.add(this.createRegion("ASIA"));
                return result;
            }

            private GeoRegion createRegion(String code) {
                GeoRegion region = new GeoRegion();
                region.setCode(code);
                region.getCodeVariants().put(CodeSystem.IATA.name(), code);
                region.getTranslations().put(Locale.ENGLISH, code);
                return region;
            }

            public <D extends BaseDictionary> Map<String, D> getAll(Class<D> cls) {
                if (GeoLocation.class.equals(cls)) {
                    return this.geoLocationsMap;
                }
                if (Country.class.equals(cls)) {
                    return this.countriesMap;
                }
                if (GeoRegion.class.equals(cls)) {
                    return this.regionsMap;
                }
                throw new IllegalArgumentException("unsupported dict class " + cls);
            }

            public <D extends BaseDictionary> Set<D> lookup(Class<D> cls, String code, String ... codeSystems) {
                if (GeoLocation.class.equals(cls)) {
                    return this.geoLocationsIataCodes.get(code);
                }
                if (Country.class.equals(cls)) {
                    return this.countriesIataCodes.get(code);
                }
                if (GeoRegion.class.equals(cls)) {
                    return this.regionsIataCodes.get(code);
                }
                throw new IllegalArgumentException("unsupported dict class " + cls);
            }

            public <D extends BaseDictionary> D resolveReference(DictionaryReference<D> ref) {
                if (ref == null) {
                    return null;
                }
                Class cls = ref.getType();
                if (GeoLocation.class.equals((Object)cls)) {
                    return (D)((BaseDictionary)this.geoLocationsMap.get(ref.getCode()));
                }
                if (Country.class.equals((Object)cls)) {
                    return (D)((BaseDictionary)this.countriesMap.get(ref.getCode()));
                }
                if (GeoRegion.class.equals((Object)cls)) {
                    return (D)((BaseDictionary)this.regionsMap.get(ref.getCode()));
                }
                throw new IllegalArgumentException("unsupported dict class " + cls);
            }
        });
    }

    @Test
    public void testHelper() throws Exception {
        Assert.assertTrue((boolean)RulesHelper.isTransatlanticFlight((DictionaryReference<GeoLocation>)new GeoLocationReference("MOW"), (DictionaryReference<GeoLocation>)new GeoLocationReference("NYC"), this.getDate(10, 15), this.getDate(12, 20), this.getDuration(10, 5)));
        Assert.assertTrue((boolean)RulesHelper.isTransatlanticFlight((DictionaryReference<GeoLocation>)new GeoLocationReference("NYC"), (DictionaryReference<GeoLocation>)new GeoLocationReference("MOW"), this.getDate(14, 20), this.getDate(7, 45), this.getDuration(9, 25)));
        Assert.assertFalse((boolean)RulesHelper.isTransatlanticFlight((DictionaryReference<GeoLocation>)new GeoLocationReference("TYO"), (DictionaryReference<GeoLocation>)new GeoLocationReference("NYC"), this.getDate(14, 55), this.getDate(9, 0), this.getDuration(10, 5)));
        Assert.assertFalse((boolean)RulesHelper.isTransatlanticFlight((DictionaryReference<GeoLocation>)new GeoLocationReference("NYC"), (DictionaryReference<GeoLocation>)new GeoLocationReference("TYO"), this.getDate(10, 55), this.getDate(15, 5), this.getDuration(12, 10)));
    }

    private Integer getDuration(int houres, int minutes) {
        return houres * 60 + minutes;
    }

    private Date getDate(int hour, int min) {
        Calendar cal = Calendar.getInstance();
        cal.set(11, hour);
        cal.set(12, min);
        return cal.getTime();
    }
}

