/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.finance;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.booking.ProductDateData;
import com.gridnine.xtrip.common.model.booking.ProductDateType;
import com.gridnine.xtrip.common.model.booking.ProductPeriodType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ShipmentCategory;
import com.gridnine.xtrip.common.model.finance.FinanceDocumentData;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.rules.finance.BillingItemActionSet;
import com.gridnine.xtrip.common.model.rules.finance.BillingItemsCreationActionSet;
import com.gridnine.xtrip.common.model.rules.finance.InvoicePrepaymentActionSet;
import com.gridnine.xtrip.common.model.rules.finance.ShipmentActionSet;
import com.gridnine.xtrip.common.model.rules.finance.ShipmentsDateActionSet;
import com.gridnine.xtrip.common.model.rules.finance.ShipmentsDatePropertySet;
import com.gridnine.xtrip.common.model.rules.finance.Targets;
import com.gridnine.xtrip.common.model.rules.l10n.Messages;
import com.gridnine.xtrip.common.model.rules.standard.ValueTypes;
import com.gridnine.xtrip.common.model.system.DateCorrection;
import com.gridnine.xtrip.common.model.system.DateCorrectionUnit;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.time.DayOfWeek;
import java.util.Date;

public enum Actions implements RuleAction
{
    SHIPMENTS_DATE{

        public String getDisplayName() {
            return L10n.get((String)Messages.FinanceActions_shipmentsDate);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.SHIPMENTS_DATE.getId()};
        }

        public String getRendererId() {
            return ValueTypes.PRODUCT_DATE_DATA.name();
        }

        public void buildInfo(StringBuilder buf, Object value) {
            if (value != null) {
                buf.append(this.getDisplayName()).append(": ");
                ProductDateData data = (ProductDateData)value;
                buf.append(data.getProductDateType());
                if (data.getProductPeriodData() != null && data.getProductPeriodData().getProductPeriodType() != null) {
                    buf.append(" (");
                    if (ProductPeriodType.EVERY_N_DAYS_OF_MONTH == data.getProductPeriodData().getProductPeriodType()) {
                        buf.append(L10nResourcesManager.getStr((String)Messages.RuleAction_EVERY_N_DAYS_OF_MONTH, (Object[])new Object[]{data.getIntervalValue()}));
                    } else {
                        buf.append(data.getProductPeriodData().getProductPeriodType());
                        if (data.getStartWeekDay() != null) {
                            buf.append(" / ");
                            buf.append(data.getStartWeekDay());
                        }
                    }
                    if (data.getProductPeriodData().isUseAsShipmentPeriod()) {
                        buf.append(" / ");
                        buf.append(L10n.get((String)Messages.RuleAction_USE_AS_SHIPMENT_PERIOD));
                    }
                    buf.append(")");
                }
                if (data.getDateCorrection() != null && data.getDateCorrection().getValue() != 0) {
                    buf.append(" ");
                    buf.append(String.format("%+d", data.getDateCorrection().getValue()));
                    buf.append(" ");
                    buf.append(data.getDateCorrection().getUnit());
                }
            }
        }

        public boolean hasValue() {
            return true;
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            ShipmentsDateActionSet actionSet = (ShipmentsDateActionSet)proxy.getActionSet();
            ShipmentsDatePropertySet propertySet = (ShipmentsDatePropertySet)proxy.getPropertySet();
            ProductDateData data = (ProductDateData)value;
            if (data != null) {
                DateCorrection correction;
                Date date = null;
                Date periodBegin = null;
                Date periodEnd = null;
                if (data.getProductDateType() == ProductDateType.ISSUE_DATE) {
                    date = propertySet.getIssueDate();
                } else if (data.getProductDateType() == ProductDateType.START_DATE) {
                    date = propertySet.getStartDate();
                } else if (data.getProductDateType() == ProductDateType.END_DATE) {
                    date = propertySet.getEndDate();
                } else if (data.getProductDateType() == ProductDateType.BOOKING_FILE_CREATE_DATE) {
                    date = propertySet.getBookingFileCreateDate();
                }
                if (date != null && data.getProductPeriodData() != null) {
                    date = MiscUtil.endOf((Date)date, (MiscUtil.PeriodType)FinanceDocumentsHelper.toPeriodType(data.getProductPeriodData().getProductPeriodType()), (DayOfWeek)FinanceDocumentsHelper.toDayOfWeek(data.getStartWeekDay()), (Integer)data.getIntervalValue());
                    if (data.getProductPeriodData().isUseAsShipmentPeriod()) {
                        periodBegin = MiscUtil.startOf((Date)date, (MiscUtil.PeriodType)FinanceDocumentsHelper.toPeriodType(data.getProductPeriodData().getProductPeriodType()), (DayOfWeek)FinanceDocumentsHelper.toDayOfWeek(data.getStartWeekDay()), (Integer)data.getIntervalValue());
                        periodEnd = date;
                    }
                }
                if (date != null && (correction = data.getDateCorrection()) != null) {
                    if (correction.getUnit() == DateCorrectionUnit.DAY) {
                        date = MiscUtil.addToDate((Date)date, (int)correction.getValue(), (int)5);
                        if (periodBegin != null) {
                            periodBegin = MiscUtil.addToDate(periodBegin, (int)correction.getValue(), (int)5);
                        }
                    } else if (correction.getUnit() == DateCorrectionUnit.HOUR) {
                        date = MiscUtil.addToDate((Date)date, (int)correction.getValue(), (int)11);
                        if (periodBegin != null) {
                            periodBegin = MiscUtil.addToDate((Date)periodBegin, (int)correction.getValue(), (int)11);
                        }
                    }
                    if (periodEnd != null) {
                        periodEnd = date;
                    }
                }
                actionSet.setShipmentsDate(date);
                actionSet.setShipmentPeriodBegin(periodBegin);
                actionSet.setShipmentPeriodEnd(periodEnd);
                proxy.getAppliedRuleCategories().add("rule_category_shipments_date");
            }
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "rule_category_shipments_date";
        }
    }
    ,
    MERGE_BILLING_ITEMS{

        public String getDisplayName() {
            return L10n.get((String)Messages.FinanceActions_mergeBillingItemsWithDifferentVat);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.BILLING_ITEMS_CREATION.getId()};
        }

        public String getRendererId() {
            return ValueTypes.YES_NO.name();
        }

        public void buildInfo(StringBuilder buf, Object value) {
            if (value != null) {
                buf.append(this.getDisplayName()).append(": ");
                buf.append((Boolean)value != false ? Messages.YES : Messages.NO);
            }
        }

        public boolean hasValue() {
            return true;
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            BillingItemsCreationActionSet actionSet = (BillingItemsCreationActionSet)proxy.getActionSet();
            Boolean mergeBillingItemsWithDifferentVat = (Boolean)value;
            actionSet.setMergeBillingItemsWithDifferentVat(mergeBillingItemsWithDifferentVat != null && mergeBillingItemsWithDifferentVat != false);
            proxy.getAppliedRuleCategories().add("rule_category_billing_item_merge_vat");
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "rule_category_billing_item_merge_vat";
        }
    }
    ,
    MERGE_REFUND_BILLING_ITEMS{

        public String getDisplayName() {
            return L10n.get((String)Messages.FinanceActions_mergeRefundBillingItems);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.BILLING_ITEMS_CREATION.getId()};
        }

        public String getRendererId() {
            return ValueTypes.YES_NO.name();
        }

        public void buildInfo(StringBuilder buf, Object value) {
            if (value != null) {
                buf.append(this.getDisplayName()).append(": ");
                buf.append((Boolean)value != false ? Messages.YES : Messages.NO);
            }
        }

        public boolean hasValue() {
            return true;
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            BillingItemsCreationActionSet actionSet = (BillingItemsCreationActionSet)proxy.getActionSet();
            Boolean mergeRefundBillingItems = (Boolean)value;
            actionSet.setMergeRefundBillingItems(mergeRefundBillingItems != null && mergeRefundBillingItems != false);
            proxy.getAppliedRuleCategories().add("rule_category_billing_item_merge_refund");
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "rule_category_billing_item_merge_refund";
        }
    }
    ,
    SEPARATE_HIDDEN_FOP_COMPONENTS{

        public String getDisplayName() {
            return L10n.get((String)Messages.FinanceActions_separateHiddenFopComponents);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.BILLING_ITEMS_CREATION.getId()};
        }

        public String getRendererId() {
            return ValueTypes.YES_NO.name();
        }

        public void buildInfo(StringBuilder buf, Object value) {
            if (value != null) {
                buf.append(this.getDisplayName()).append(": ");
                buf.append((Boolean)value != false ? Messages.YES : Messages.NO);
            }
        }

        public boolean hasValue() {
            return true;
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            BillingItemsCreationActionSet actionSet = (BillingItemsCreationActionSet)proxy.getActionSet();
            Boolean separateHiddenFopComponents = (Boolean)value;
            actionSet.setSeparateHiddenFopComponents(separateHiddenFopComponents != null && separateHiddenFopComponents != false);
            proxy.getAppliedRuleCategories().add("rule_category_billing_item_separate_hidden_fop_components");
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "rule_category_billing_item_separate_hidden_fop_components";
        }
    }
    ,
    BILLING_ITEM_NAME_PATTERN{

        public String getDisplayName() {
            return L10n.get((String)Messages.FinanceActions_billingItemNamePattern);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.BILLING_ITEM.getId()};
        }

        public String getRendererId() {
            return ValueTypes.STRING.name();
        }

        public void buildInfo(StringBuilder buf, Object value) {
            if (value != null) {
                buf.append(this.getDisplayName()).append(": ");
                buf.append(value);
            }
        }

        public boolean hasValue() {
            return true;
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            BillingItemActionSet actionSet = (BillingItemActionSet)proxy.getActionSet();
            String pattern = (String)value;
            if (pattern != null) {
                actionSet.setPattern(pattern);
                proxy.getAppliedRuleCategories().add("rule_category_billing_item_name_pattern");
            }
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "rule_category_billing_item_name_pattern";
        }
    }
    ,
    TRAVELLER_PAYER{

        public String getDisplayName() {
            return L10n.get((String)Messages.FinanceActions_travellerPayer);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.BILLING_ITEM.getId()};
        }

        public String getRendererId() {
            return ValueTypes.YES_NO.name();
        }

        public void buildInfo(StringBuilder buf, Object value) {
            if (value != null) {
                buf.append(this.getDisplayName()).append(": ");
                buf.append((Boolean)value != false ? Messages.YES : Messages.NO);
            }
        }

        public boolean hasValue() {
            return true;
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            BillingItemActionSet actionSet = (BillingItemActionSet)proxy.getActionSet();
            Boolean useTravellerAsPayer = (Boolean)value;
            actionSet.setUseTravellerAsPayer(useTravellerAsPayer != null && useTravellerAsPayer != false);
            proxy.getAppliedRuleCategories().add("rule_category_billing_item_traveller_payer");
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "rule_category_billing_item_traveller_payer";
        }
    }
    ,
    SHIPMENT_CATEGORY{

        public String getDisplayName() {
            return L10n.get((String)Messages.FinanceActions_shipmentCategory);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.BILLING_ITEM.getId()};
        }

        public String getRendererId() {
            return ValueTypes.SHIPMENT_CATEGORY.name();
        }

        public void buildInfo(StringBuilder buf, Object value) {
            if (value != null) {
                buf.append(this.getDisplayName()).append(": ");
                buf.append(value);
            }
        }

        public boolean hasValue() {
            return true;
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            BillingItemActionSet actionSet = (BillingItemActionSet)proxy.getActionSet();
            DictionaryReference category = (DictionaryReference)value;
            if (category != null) {
                if (!actionSet.getCategories().contains(category)) {
                    actionSet.getCategories().add((DictionaryReference<ShipmentCategory>)category);
                }
                proxy.getAppliedRuleCategories().add(category.getCode());
            }
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return ((DictionaryReference)value).getCode();
        }
    }
    ,
    FINANCE_DOCUMENT_DATA{

        public String getDisplayName() {
            return L10n.get((String)Messages.FinanceActions_financeDocumentData);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.SHIPMENT.getId()};
        }

        public String getRendererId() {
            return ValueTypes.FINANCE_DOCUMENT_DATA.name();
        }

        public void buildInfo(StringBuilder buf, Object value) {
            if (value != null) {
                buf.append(this.getDisplayName()).append(": ");
                FinanceDocumentData data = (FinanceDocumentData)value;
                buf.append(data.getType().toString());
                if (data.getTemplate() != null && TextUtil.nonBlank((String)data.getTemplate().getCaption())) {
                    buf.append(" (").append(L10n.get((String)Messages.RuleAction_TEMPLATE)).append(": ");
                    buf.append(data.getTemplate().getCaption());
                    buf.append(")");
                }
            }
        }

        public boolean hasValue() {
            return true;
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            ShipmentActionSet actionSet = (ShipmentActionSet)proxy.getActionSet();
            FinanceDocumentData data = (FinanceDocumentData)value;
            if (data != null) {
                if (!actionSet.getDatas().contains(data)) {
                    actionSet.getDatas().add(data);
                }
                proxy.getAppliedRuleCategories().add("rule_category_finance_document_data" + String.format("_%s", data.getType().name().toLowerCase()));
            }
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "rule_category_finance_document_data" + String.format("_%s", ((FinanceDocumentData)value).getType().name().toLowerCase());
        }
    }
    ,
    INVOICE_PREPAYMENT_DATA{

        public String getDisplayName() {
            return L10n.get((String)Messages.FinanceActions_invoicePrepaymentData);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.INVOICE_PREPAYMENT.getId()};
        }

        public String getRendererId() {
            return ValueTypes.INVOICE_PREPAYMENT_DATA.name();
        }

        public void buildInfo(StringBuilder buf, Object value) {
            if (value != null) {
                buf.append(this.getDisplayName()).append(": ");
                FinanceDocumentData data = (FinanceDocumentData)value;
                buf.append(data.getType().toString());
                if (data.getTemplate() != null && TextUtil.nonBlank((String)data.getTemplate().getCaption())) {
                    buf.append(" (").append(L10n.get((String)Messages.RuleAction_TEMPLATE)).append(": ");
                    buf.append(data.getTemplate().getCaption());
                    buf.append(")");
                }
            }
        }

        public boolean hasValue() {
            return true;
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            InvoicePrepaymentActionSet actionSet = (InvoicePrepaymentActionSet)proxy.getActionSet();
            FinanceDocumentData data = (FinanceDocumentData)value;
            if (data != null) {
                actionSet.setData(data);
                proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(actionSet, value));
            }
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "rule_category_invoice_prepayment_data";
        }
    };


    public String getId() {
        return this.name();
    }

    abstract String[] getTargetIds();
}

