/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.fiscal;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.rules.fiscal.FiscalReceiptItemPropertySet;
import com.gridnine.xtrip.common.model.rules.fiscal.FiscalTargets;
import com.gridnine.xtrip.common.model.rules.l10n.Messages;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.ValueTypes;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public enum FiscalProperties implements RuleProperty
{
    FISCAL_RECEIPT_ITEM_PRODUCT_TYPE{

        public String getDisplayName() {
            return L10n.get((String)Messages.FiscalProperties_fiscalReceiptItemProductType);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{FiscalTargets.FISCAL_RECEIPT_ITEM.getId()};
        }

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getRendererId() {
            return ValueTypes.EXTENDED_PRODUCT_TYPE.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.FiscalProperties_fiscalReceiptItemProductTypeInfo, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            FiscalReceiptItemPropertySet ps = (FiscalReceiptItemPropertySet)propertySet;
            MiscUtil.Pair productType = Optional.ofNullable(ps.getProductType()).map(item -> new MiscUtil.Pair((Object)item.getProductType(), (Object)item.getProductDescription())).orElse(null);
            List productTypes = Optional.ofNullable((List)value).map(items -> items.stream().map(item -> new MiscUtil.Pair((Object)item.getProductType(), (Object)item.getProductDescription())).collect(Collectors.toList())).orElse(Collections.emptyList());
            if (Conditions.EQUALS.equals(condition)) {
                return productTypes.stream().anyMatch(item -> MiscUtil.equals((Object)item, (Object)productType));
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return productTypes.stream().noneMatch(item -> MiscUtil.equals((Object)item, (Object)productType));
            }
            return true;
        }
    }
    ,
    FISCAL_RECEIPT_ITEM_PRODUCT_STATUS{

        public String getDisplayName() {
            return L10n.get((String)Messages.FiscalProperties_fiscalReceiptItemProductStatus);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{FiscalTargets.FISCAL_RECEIPT_ITEM.getId()};
        }

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getRendererId() {
            return ValueTypes.PRODUCT_STATUS.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.FiscalProperties_fiscalReceiptItemProductStatusInfo, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            FiscalReceiptItemPropertySet ps = (FiscalReceiptItemPropertySet)propertySet;
            List productStatuses = (List)value;
            if (Conditions.EQUALS.equals(condition)) {
                return productStatuses.contains(ps.getProductStatus());
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return !productStatuses.contains(ps.getProductStatus());
            }
            return true;
        }
    }
    ,
    FISCAL_RECEIPT_ITEM_PRODUCT_SUPPLIER{

        public String getDisplayName() {
            return L10n.get((String)Messages.FiscalProperties_fiscalReceiptItemProductSupplier);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{FiscalTargets.FISCAL_RECEIPT_ITEM.getId()};
        }

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getRendererId() {
            return ValueTypes.SUPPLIERS.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.FiscalProperties_fiscalReceiptItemProductSupplierInfo, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            FiscalReceiptItemPropertySet ps = (FiscalReceiptItemPropertySet)propertySet;
            List productSuppliers = (List)value;
            if (Conditions.EQUALS.equals(condition)) {
                return productSuppliers.contains(ps.getProductSupplier());
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return !productSuppliers.contains(ps.getProductSupplier());
            }
            return true;
        }
    }
    ,
    FISCAL_RECEIPT_ITEM_POSITION_TYPE{

        public String getDisplayName() {
            return L10n.get((String)Messages.FiscalProperties_fiscalReceiptItemPositionType);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{FiscalTargets.FISCAL_RECEIPT_ITEM.getId()};
        }

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getRendererId() {
            return ValueTypes.FISCAL_RECEIPT_ITEM_POSITION_TYPE.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.FiscalProperties_fiscalReceiptItemPositionTypeInfo, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            FiscalReceiptItemPropertySet ps = (FiscalReceiptItemPropertySet)propertySet;
            List dataType = (List)value;
            if (Conditions.EQUALS.equals(condition)) {
                return dataType.contains(ps.getReceiptDataType());
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return !dataType.contains(ps.getReceiptDataType());
            }
            return true;
        }
    }
    ,
    FISCAL_RECEIPT_ITEM_PRODUCT_IS_ISSUED_IN_EXCHANGE{

        public String getDisplayName() {
            return L10n.get((String)Messages.FiscalProperties_fiscalReceiptItemProductIsIssuedInExchange);
        }

        public String getRendererId() {
            return ValueTypes.YES_NO.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(Boolean.TRUE.equals(value) ? L10n.get((String)Messages.FiscalProperties_fiscalReceiptItemProductIsIssuedInExchange_info1) : L10n.get((String)Messages.FiscalProperties_fiscalReceiptItemProductIsIssuedInExchange_info2));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            FiscalReceiptItemPropertySet ps = (FiscalReceiptItemPropertySet)propertySet;
            return Boolean.valueOf(ps.isIssuedInExchange()).equals(value);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{FiscalTargets.FISCAL_RECEIPT_ITEM.getId()};
        }

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId()};
        }
    };


    public String getId() {
        return this.name();
    }

    abstract String[] getTargetIds();

    abstract String[] getConditionIds();
}

