/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.migration;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.RoundingMode;
import com.gridnine.xtrip.common.model.booking.commission.RoundingValue;
import com.gridnine.xtrip.common.model.rules.migration.RulesMigrationActionSet;
import com.gridnine.xtrip.common.model.rules.migration.RulesMigrationActionType;
import com.gridnine.xtrip.common.model.rules.migration.RulesMigrationPropertySet;
import com.gridnine.xtrip.common.model.rules.standard.CachedRulesCategoriesProvider;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.ValueTypes;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;

public enum RulesMigrationActions implements RuleAction
{
    IGNORE_ACTION{

        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)"RulesMigrationActions_IgnoreAction", (Object[])new Object[0]);
        }

        public String getRendererId() {
            return ValueTypes.NULL.name();
        }

        public boolean hasValue() {
            return false;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(L10nResourcesManager.getStr((String)"RulesMigrationActions_IgnoreAction", (Object[])new Object[0]));
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "COMMISSION_RULE_CATEGORY";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            RulesMigrationActionSet as = (RulesMigrationActionSet)proxy.getActionSet();
            as.setIgnoreAction(true);
        }
    }
    ,
    ADDITIONAl_FEE{

        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)"RulesMigrationActions_AdditionalFee", (Object[])new Object[0]);
        }

        public String getRendererId() {
            return ValueTypes.SIMPLE_FEE.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            RulesHelper.buildCommissionInfo(buf, (RuleResultValue)value);
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            RuleResultValue rrv = (RuleResultValue)value;
            if (rrv != null) {
                RulesMigrationActionSet as = (RulesMigrationActionSet)proxy.getActionSet();
                as.getAdditionalFees().add(rrv);
                proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, rrv));
            }
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            RuleResultValue rrv = (RuleResultValue)value;
            if (rrv == null) {
                return "null";
            }
            RulesMigrationActionSet as = (RulesMigrationActionSet)actionSet;
            return RulesHelper.getRuleCategoryValue((CachedRulesCategoriesProvider)as, rrv.getTarget());
        }
    }
    ,
    PERCENT_COMMISSION{

        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)"RulesMigrationActions_PercentCommission", (Object[])new Object[0]);
        }

        public String getRendererId() {
            return ValueTypes.NUMBER.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(L10nResourcesManager.getStr((String)"RulesMigrationActions_PercentCommission_Info", (Object[])new Object[]{value}));
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            RulesMigrationActionSet as = (RulesMigrationActionSet)proxy.getActionSet();
            as.setActionType(RulesMigrationActionType.PERCENT_COMMISSION);
            as.setActionValue(this.getValueSafe(value));
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "COMMISSION_RULE_CATEGORY";
        }
    }
    ,
    FIXED_COMMISSION{

        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)"RulesMigrationActions_FixedCommission", (Object[])new Object[0]);
        }

        public String getRendererId() {
            return ValueTypes.PRICE.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            Object[] values = (Object[])value;
            buf.append(L10nResourcesManager.getStr((String)"RulesMigrationActions_FixedCommission_Info", (Object[])new Object[]{values == null ? "" : String.format("%s %s", values[0], values[1])}));
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            RulesMigrationActionSet as = (RulesMigrationActionSet)proxy.getActionSet();
            as.setActionType(RulesMigrationActionType.FIXED_COMMISSION);
            Object[] values = (Object[])value;
            if (values != null) {
                as.setActionValue(this.getValueSafe(values[0]));
                as.setActionCurrencyCode((String)values[1]);
                proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
            }
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "COMMISSION_RULE_CATEGORY";
        }
    }
    ,
    PORTION_OF_SOURCE_COMMISSION{

        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)"RulesMigrationActions_PortionOfSourceCommission", (Object[])new Object[0]);
        }

        public String getRendererId() {
            return ValueTypes.NUMBER.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(L10nResourcesManager.getStr((String)"RulesMigrationActions_PortionOfSourceCommission_Info", (Object[])new Object[]{value}));
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            RulesMigrationActionSet as = (RulesMigrationActionSet)proxy.getActionSet();
            as.setActionType(RulesMigrationActionType.PORTION_OF_SOURCE_COMMISSION);
            as.setActionValue(this.getValueSafe(value));
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "COMMISSION_RULE_CATEGORY";
        }
    }
    ,
    SOURCE_COMMISSION_MINUS_PERCENT{

        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)"RulesMigrationActions_SourceCommissionMinusPercent", (Object[])new Object[0]);
        }

        public String getRendererId() {
            return ValueTypes.NUMBER.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(L10nResourcesManager.getStr((String)"RulesMigrationActions_SourceCommissionMinusPercent_Info", (Object[])new Object[]{value}));
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            RulesMigrationPropertySet ps = (RulesMigrationPropertySet)proxy.getPropertySet();
            if (ps.isPercentCommission()) {
                RulesMigrationActionSet as = (RulesMigrationActionSet)proxy.getActionSet();
                as.setActionType(RulesMigrationActionType.SOURCE_COMMISSION_MINUS_PERCENT);
                as.setActionValue(this.getValueSafe(value));
                proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
            }
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "COMMISSION_RULE_CATEGORY";
        }
    }
    ,
    SOURCE_COMMISSION_MINUS_FIXED{

        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)"RulesMigrationActions_SourceCommissionMinusFixed", (Object[])new Object[0]);
        }

        public String getRendererId() {
            return ValueTypes.NUMBER.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(L10nResourcesManager.getStr((String)"RulesMigrationActions_SourceCommissionMinusFixed_Info", (Object[])new Object[]{value}));
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            RulesMigrationPropertySet ps = (RulesMigrationPropertySet)proxy.getPropertySet();
            if (!ps.isPercentCommission()) {
                RulesMigrationActionSet as = (RulesMigrationActionSet)proxy.getActionSet();
                as.setActionType(RulesMigrationActionType.SOURCE_COMMISSION_MINUS_FIXED);
                as.setActionValue(this.getValueSafe(value));
                proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
            }
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "COMMISSION_RULE_CATEGORY";
        }
    }
    ,
    ROUNDING_MODE{

        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)"RulesMigrationActions_RoundingMode", (Object[])new Object[0]);
        }

        public String getRendererId() {
            return ValueTypes.ROUNDING_MODE.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(L10nResourcesManager.getStr((String)"RulesMigrationActions_RoundingMode_Info", (Object[])new Object[]{value}));
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            RulesMigrationActionSet as = (RulesMigrationActionSet)proxy.getActionSet();
            as.setRoundingMode((RoundingMode)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return this.name();
        }
    }
    ,
    ROUNDING_VALUE{

        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)"RulesMigrationActions_RoundingValue", (Object[])new Object[0]);
        }

        public String getRendererId() {
            return ValueTypes.ROUNDING_VALUE.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(L10nResourcesManager.getStr((String)"RulesMigrationActions_RoundingValue_Info", (Object[])new Object[]{value}));
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            RulesMigrationActionSet as = (RulesMigrationActionSet)proxy.getActionSet();
            as.setRoundingValue((RoundingValue)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return this.name();
        }
    }
    ,
    COMMISSION_PROPERTIES{

        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)"RulesMigrationActions_CommissionProperties", (Object[])new Object[0]);
        }

        public String getRendererId() {
            return ValueTypes.COMMISSION_PROPERTIES.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(L10nResourcesManager.getStr((String)"RulesMigrationActions_CommissionProperties_Info", (Object[])new Object[]{value}));
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            RulesMigrationActionSet as = (RulesMigrationActionSet)proxy.getActionSet();
            as.setCommissionProperties((EntityReference<? extends BaseCommissionProperties>)((EntityReference)value));
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return this.name();
        }
    }
    ,
    SUBTRACT_REVERSE_PERCENT{

        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)"RulesMigrationActions_SubtractReversePercent", (Object[])new Object[0]);
        }

        public String getRendererId() {
            return ValueTypes.NUMBER.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(L10nResourcesManager.getStr((String)"RulesMigrationActions_SubtractReversePercent_Info", (Object[])new Object[]{value}));
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            RulesMigrationActionSet as = (RulesMigrationActionSet)proxy.getActionSet();
            as.setReversePercent(this.getValueSafe(value));
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return this.name();
        }
    };


    double getValueSafe(Object value) {
        if (value instanceof Double) {
            return (Double)value;
        }
        return 0.0;
    }

    public String getId() {
        return this.name();
    }
}

