/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.migration;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.commission.RoundingMode;
import com.gridnine.xtrip.common.model.booking.commission.RoundingValue;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.BaseRulesContainer;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Contract2ModelContract;
import com.gridnine.xtrip.common.model.profile.ModelContract;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.rules.RulesMigrationSettings;
import com.gridnine.xtrip.common.model.rules.RulesMigrationSourceContractData;
import com.gridnine.xtrip.common.model.rules.migration.RulesMigrationActionSet;
import com.gridnine.xtrip.common.model.rules.migration.RulesMigrationPropertySet;
import com.gridnine.xtrip.common.model.rules.migration.RulesMigrationTargets;
import com.gridnine.xtrip.common.model.rules.standard.Actions;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.GeneralProductActions;
import com.gridnine.xtrip.common.model.rules.standard.ProductTicketInfoProperties;
import com.gridnine.xtrip.common.model.rules.standard.Properties;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RulesMigrationHelper {
    public static final String COMMISSION_RULE_CATEGORY = "COMMISSION_RULE_CATEGORY";

    public static void updateRules(List<RulesMigrationSourceContractData> contractItems, BaseRulesContainer targetContract, RulesMigrationSettings migrationSettings, List<Message> messages) throws Exception {
        Contract contract;
        if (Contract.class.equals(targetContract.getClass()) && (contract = (Contract)targetContract).isNewModel()) {
            throw Xeption.forEndUser((String)"{0} \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u043c \u043d\u043e\u0432\u043e\u0433\u043e \u0442\u0438\u043f\u0430, \u0432\u043c\u0435\u0441\u0442\u043e \u043d\u0435\u0433\u043e \u0432 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430\u0445 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u0441\u0441\u044b\u043b\u043a\u0430 \u043d\u0430 \u0413\u0440\u0443\u043f\u043f\u0443 \u043f\u0440\u0430\u0432\u0438\u043b", (Object[])new Object[0]);
        }
        if (targetContract.getRuleSet() == null) {
            targetContract.setRuleSet(new RuleSet());
        }
        targetContract.getRuleSet().getRules().clear();
        targetContract.getRuleSet().getRules().addAll(migrationSettings.getCustomTopRules().getRules());
        targetContract.getRuleSet().getRules().addAll(RulesMigrationHelper.getTransformedRules(contractItems, migrationSettings, messages));
        targetContract.getRuleSet().getRules().addAll(migrationSettings.getCustomBottomRules().getRules());
        targetContract.getRuleSet().setModified(new Date());
    }

    private static List<RuleSettings> getTransformedRules(List<RulesMigrationSourceContractData> contracts, RulesMigrationSettings migrationSettings, List<Message> messages) throws Exception {
        ArrayList rules = new ArrayList();
        HashMap<RuleSettings, String> blankOwners = new HashMap<RuleSettings, String>();
        HashMap<Object, EntityReference> suppliers = new HashMap<Object, EntityReference>();
        HashMap<RuleSettings, Object> rs2contractMap = new HashMap<RuleSettings, Object>();
        for (RulesMigrationSourceContractData contractData : contracts) {
            if (contractData.getSourceContract() != null) {
                EntityContainer sourceContractCtr = EntityStorage.get().resolve(contractData.getSourceContract());
                if (sourceContractCtr == null) {
                    throw Xeption.forEndUser((String)("\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c " + contractData.getSourceContract()), (Object[])new Object[0]);
                }
                Contract contract = (Contract)sourceContractCtr.getEntity();
                ArrayList allRules = new ArrayList();
                if (contract.isNewModel()) {
                    for (Contract2ModelContract c2mc : contract.getModelContracts()) {
                        EntityReference rulesContainerRef = c2mc.getModelContract();
                        if (!contractData.getModelContracts().isEmpty() && !contractData.getModelContracts().contains(rulesContainerRef)) continue;
                        EntityContainer modelContractCtr = EntityStorage.get().resolve(rulesContainerRef);
                        if (modelContractCtr == null) {
                            throw Xeption.forEndUser((String)("\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c " + rulesContainerRef), (Object[])new Object[0]);
                        }
                        if (((ModelContract)modelContractCtr.getEntity()).getRuleSet() == null) continue;
                        allRules.addAll(((ModelContract)modelContractCtr.getEntity()).getRuleSet().getRules());
                        for (RuleSettings rs : ((ModelContract)modelContractCtr.getEntity()).getRuleSet().getRules()) {
                            rs2contractMap.put(rs, modelContractCtr.getEntity());
                        }
                    }
                } else if (contract.getRuleSet() != null) {
                    allRules.addAll(contract.getRuleSet().getRules());
                    for (RuleSettings rs : contract.getRuleSet().getRules()) {
                        rs2contractMap.put(rs, contract);
                    }
                }
                rules.addAll(allRules);
                if (contract.getVendor() == null) continue;
                for (Object rule : allRules) {
                    blankOwners.put((RuleSettings)rule, contract.getVendor().getUid());
                    suppliers.put(rule, contract.getSupplier());
                }
                continue;
            }
            EntityReference blankOwner = contractData.getBlankOwner();
            for (EntityReference rulesContainerRef : contractData.getModelContracts()) {
                Object rule;
                EntityContainer modelContractCtr = EntityStorage.get().resolve(rulesContainerRef);
                if (modelContractCtr == null) {
                    throw Xeption.forEndUser((String)("\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c " + rulesContainerRef), (Object[])new Object[0]);
                }
                if (((ModelContract)modelContractCtr.getEntity()).getRuleSet() == null) continue;
                rules.addAll(((ModelContract)modelContractCtr.getEntity()).getRuleSet().getRules());
                rule = ((ModelContract)modelContractCtr.getEntity()).getRuleSet().getRules().iterator();
                while (rule.hasNext()) {
                    RuleSettings rs = (RuleSettings)rule.next();
                    rs2contractMap.put(rs, modelContractCtr.getEntity());
                    if (blankOwner == null) continue;
                    blankOwners.put(rs, blankOwner.getUid());
                }
            }
        }
        int count = rules.size();
        ArrayList<RuleSettings> result = new ArrayList<RuleSettings>();
        for (RuleSettings item : rules) {
            ArrayList<RuleResult> ruleResults = new ArrayList<RuleResult>();
            for (RuleResult ruleResult : item.getResults()) {
                List<RuleProxy<RulesMigrationPropertySet, RulesMigrationActionSet>> proxies;
                if (!RulesMigrationHelper.isAppropriate(ruleResult) || (proxies = RulesMigrationHelper.createProxyList(item, ruleResult, (String)blankOwners.get(item), (EntityReference<Organization>)((EntityReference)suppliers.get(item)))).isEmpty()) continue;
                RuleEngine.applyRules(proxies, (RuleSet)migrationSettings.getMigrationRules());
                ruleResults.addAll(RulesMigrationHelper.extractResults(ruleResult, proxies));
            }
            if (ruleResults.isEmpty()) {
                BaseRulesContainer contract = (BaseRulesContainer)rs2contractMap.get(item);
                int idx = contract.getRuleSet().getRules().indexOf(item);
                messages.add(SystemHelper.createMessage(MessageType.WARNING, Messages.RulesMigrationHelper_ruleWasIgnored, Integer.toString(idx + 1), item.getName(), contract.toString()));
                continue;
            }
            RuleSettings rs = new RuleSettings();
            XCloneModelHelper.copy((BaseEntity)item, (BaseEntity)rs, (boolean)true);
            String blankOwnerUid = (String)blankOwners.get(item);
            EntityContainer vendorCtr = EntityStorage.get().load(Organization.class, blankOwnerUid);
            if (vendorCtr != null && ((Organization)vendorCtr.getEntity()).getAirline() != null) {
                List<String> blankOwnersList = RulesHelper.toStringCollection(((Organization)vendorCtr.getEntity()).getAirline().getCode());
                if (rs.getTarget() == Targets.PRODUCT_COMMISSION && !RulesMigrationHelper.containsBlankOwnerRestiction(rs.getRestrictions(), blankOwnersList)) {
                    RuleRestriction restr = new RuleRestriction();
                    restr.setProperty((RuleProperty)Properties.BLANK_OWNERS);
                    restr.setCondition((RuleCondition)Conditions.INCLUDE);
                    restr.setValue(blankOwnersList);
                    rs.getRestrictions().add(restr);
                }
            }
            rs.getResults().clear();
            rs.getResults().addAll(ruleResults);
            result.add(rs);
        }
        return result;
    }

    private static boolean containsBlankOwnerRestiction(List<RuleRestriction> restrictions, List<String> blankOwnersList) {
        for (RuleRestriction restr : restrictions) {
            if (!Properties.BLANK_OWNERS.equals(restr.getProperty()) || !Conditions.INCLUDE.equals(restr.getCondition()) || !CollectionUtil.equals(RulesHelper.toStringCollection(restr.getValue()), blankOwnersList, (boolean)true)) continue;
            return true;
        }
        return false;
    }

    private static List<RuleResult> extractResults(RuleResult originalResult, List<RuleProxy<RulesMigrationPropertySet, RulesMigrationActionSet>> proxies) {
        RuleResult res;
        if (proxies.isEmpty()) {
            return Collections.emptyList();
        }
        if (originalResult.getAction() != Actions.FOP_COMMISSION && originalResult.getAction() != Actions.FOP_FEE) {
            RuleProxy<RulesMigrationPropertySet, RulesMigrationActionSet> proxy = proxies.get(0);
            RulesExtractionResult extractionResult = RulesMigrationHelper.extractRules(proxy, originalResult, false);
            ArrayList<RuleResult> result = new ArrayList<RuleResult>();
            if (extractionResult.commission != null) {
                result.add(extractionResult.commission);
            }
            result.addAll(extractionResult.additionalFees);
            return result;
        }
        HashMap commissions = new HashMap();
        HashMap fees = new HashMap();
        for (RuleProxy<RulesMigrationPropertySet, RulesMigrationActionSet> proxy : proxies) {
            RulesExtractionResult extractionResult = RulesMigrationHelper.extractRules(proxy, originalResult, true);
            if (extractionResult.commission != null) {
                RulesMigrationHelper.updateCommission(commissions, (RulesMigrationPropertySet)proxy.getPropertySet(), (RuleResultValue)extractionResult.commission.getValue());
            }
            for (RuleResult item : extractionResult.additionalFees) {
                RulesMigrationHelper.updateCommission(fees, (RulesMigrationPropertySet)proxy.getPropertySet(), (RuleResultValue)item.getValue());
            }
        }
        ArrayList result = new ArrayList();
        for (Map.Entry item : commissions.entrySet()) {
            res = RulesMigrationHelper.createResult((EntityReference)item.getKey(), (Object[])item.getValue(), true);
            if (res == null) continue;
            result.add(res);
        }
        for (Map.Entry item : fees.entrySet()) {
            res = RulesMigrationHelper.createResult((EntityReference)item.getKey(), (Object[])item.getValue(), true);
            if (res == null) continue;
            result.add(res);
        }
        return result;
    }

    private static RuleResult createResult(EntityReference<?> key, Object[] value, boolean commission) {
        RuleResultValue val;
        EntityContainer commCtr;
        boolean appropriateCurrency;
        Double[][] amounts = (Double[][])value[0];
        String[][] currencies = (String[][])value[1];
        boolean hasNotNull = false;
        boolean hasNull = false;
        boolean equals = true;
        Double lastAmount = null;
        String lastCurrencyCode = null;
        boolean hasPercent = false;
        boolean hasValue = false;
        for (int n = 0; n < RulesHelper.paymentTypes.length; ++n) {
            for (int m = 0; m < RulesHelper.targetTypes.length; ++m) {
                Double amount = amounts[n][m];
                String currency = currencies[n][m];
                if (currency == null) {
                    currency = "%";
                }
                if ("%".equals(currency)) {
                    hasPercent = true;
                } else {
                    hasValue = true;
                }
                if (amount == null) {
                    hasNull = true;
                    continue;
                }
                hasNotNull = true;
                if (lastAmount == null) {
                    lastAmount = amount;
                    lastCurrencyCode = currency;
                    continue;
                }
                if (lastAmount.equals(amount) && currency.equals(lastCurrencyCode)) continue;
                equals = false;
            }
        }
        if (!hasNotNull) {
            return null;
        }
        boolean bl = appropriateCurrency = hasPercent != hasValue;
        if (appropriateCurrency && (commCtr = EntityStorage.get().resolve(key)) != null) {
            BaseEntity ett = commCtr.getEntity();
            if (ett instanceof FeeProperties) {
                FeeProperties feeProperties = (FeeProperties)ett;
                boolean bl2 = appropriateCurrency = feeProperties.isRate() == hasPercent;
            }
            if (ett instanceof CommissionProperties) {
                CommissionProperties commProp = (CommissionProperties)ett;
                appropriateCurrency = commProp.isRate() == hasPercent;
            }
            appropriateCurrency = false;
        }
        if (!equals || hasNull || !appropriateCurrency) {
            RuleResult result = new RuleResult();
            result.setAction((RuleAction)(commission ? Actions.FOP_COMMISSION : Actions.FOP_FEE));
            val = new RuleResultValue();
            val.setFopValues(value);
            val.setTarget(key);
            result.setValue((Object)val);
            return result;
        }
        RuleResult result = new RuleResult();
        result.setAction((RuleAction)(commission ? Actions.SIMPLE_COMMISSION : Actions.SIMPLE_FEE));
        val = new RuleResultValue();
        val.setCurrencyCode(lastCurrencyCode);
        val.setTarget(key);
        val.setValue(lastAmount == null ? 0.0 : lastAmount);
        result.setValue((Object)val);
        return result;
    }

    private static void updateCommission(Map<EntityReference<?>, Object[]> commissions, RulesMigrationPropertySet propertySet, RuleResultValue ruleResultValue) {
        Object[] result = commissions.get(ruleResultValue.getTarget());
        if (result == null) {
            result = new Object[]{new Double[RulesHelper.paymentTypes.length][RulesHelper.targetTypes.length], new String[RulesHelper.paymentTypes.length][RulesHelper.targetTypes.length], new RuleResultValue.FOPCommissionType[RulesHelper.paymentTypes.length][RulesHelper.targetTypes.length]};
            commissions.put(ruleResultValue.getTarget(), result);
        }
        Double[][] amounts = (Double[][])result[0];
        String[][] currencies = (String[][])result[1];
        RuleResultValue.FOPCommissionType[][] types = (RuleResultValue.FOPCommissionType[][])result[2];
        amounts[propertySet.getFopTypeIndex()][propertySet.getTargetTypeIndex()] = ruleResultValue.getValue();
        currencies[propertySet.getFopTypeIndex()][propertySet.getTargetTypeIndex()] = ruleResultValue.getCurrencyCode();
        types[propertySet.getFopTypeIndex()][propertySet.getTargetTypeIndex()] = ruleResultValue.isForceSegmentCalculation() ? RuleResultValue.FOPCommissionType.PER_SEGMENT : RuleResultValue.FOPCommissionType.PER_TICKET;
    }

    private static RulesExtractionResult extractRules(RuleProxy<RulesMigrationPropertySet, RulesMigrationActionSet> proxy, RuleResult originalResult, boolean useFopValues) {
        EntityReference<? extends BaseCommissionProperties> prop;
        RoundingValue rv;
        RuleResultValue originalResultValue = (RuleResultValue)originalResult.getValue();
        ArrayList<RuleResult> fees = new ArrayList<RuleResult>();
        RulesMigrationActionSet as = (RulesMigrationActionSet)proxy.getActionSet();
        for (RuleResultValue rrv : as.getAdditionalFees()) {
            if (useFopValues) {
                EntityContainer feeCtr = EntityStorage.get().resolve(rrv.getTarget());
                if (feeCtr == null || !FeeProperties.class.equals((Object)feeCtr.getEntityType())) continue;
                FeeProperties feeProp = (FeeProperties)feeCtr.getEntity();
                if (!feeProp.getProductTypes().isEmpty()) {
                    ProductType productType;
                    int type = ((RulesMigrationPropertySet)proxy.getPropertySet()).getTargetTypeIndex();
                    switch (type) {
                        case 0: {
                            productType = ProductType.AIR_TICKET;
                            break;
                        }
                        case 1: {
                            productType = ProductType.MCO_PENALTY;
                            break;
                        }
                        default: {
                            productType = ProductType.MCO_EXCESS_LUGGAGE;
                        }
                    }
                    if (!feeProp.getProductTypes().contains(productType)) continue;
                }
            }
            RuleResult additionaFee = new RuleResult();
            if (originalResult.getAction() == GeneralProductActions.GENERAL_COMMISSION || originalResult.getAction() == GeneralProductActions.GENERAL_FEE) {
                additionaFee.setAction((RuleAction)GeneralProductActions.GENERAL_FEE);
            } else {
                additionaFee.setAction((RuleAction)Actions.SIMPLE_FEE);
            }
            additionaFee.setAction(originalResult.getAction());
            additionaFee.setValue((Object)rrv);
            fees.add(additionaFee);
        }
        if (as.isIgnoreAction() || as.getActionType() == null) {
            return new RulesExtractionResult(null, fees);
        }
        double actionValue = as.getActionValue();
        String currencyCode = originalResultValue.getCurrencyCode();
        double originalAmount = originalResultValue.getValue();
        boolean forceSegmentCalculation = originalResultValue.isForceSegmentCalculation();
        if (useFopValues) {
            currencyCode = ((String[][])originalResultValue.getFopValues()[1])[((RulesMigrationPropertySet)proxy.getPropertySet()).getFopTypeIndex()][((RulesMigrationPropertySet)proxy.getPropertySet()).getTargetTypeIndex()];
            originalAmount = ((Double[][])originalResultValue.getFopValues()[0])[((RulesMigrationPropertySet)proxy.getPropertySet()).getFopTypeIndex()][((RulesMigrationPropertySet)proxy.getPropertySet()).getTargetTypeIndex()];
            if (originalResultValue.getFopValues().length == 3) {
                boolean bl = forceSegmentCalculation = ((RuleResultValue.FOPCommissionType[][])originalResultValue.getFopValues()[2])[((RulesMigrationPropertySet)proxy.getPropertySet()).getFopTypeIndex()][((RulesMigrationPropertySet)proxy.getPropertySet()).getTargetTypeIndex()] == RuleResultValue.FOPCommissionType.PER_SEGMENT;
            }
        }
        if (currencyCode == null) {
            currencyCode = "%";
        }
        EntityReference<? extends BaseCommissionProperties> originalTarget = originalResultValue.getTarget();
        RoundingMode rm = as.getRoundingMode();
        if (rm == null) {
            rm = RoundingMode.MATH;
        }
        if ((rv = as.getRoundingValue()) == null) {
            rv = RoundingValue.V_0_0_1;
        }
        if ((prop = as.getCommissionDescription()) == null) {
            prop = originalTarget;
        }
        BigDecimal value = null;
        switch (as.getActionType()) {
            case FIXED_COMMISSION: {
                currencyCode = as.getActionCurrencyCode();
                if (currencyCode == null) {
                    currencyCode = DictHelper.getPreferenceValue(PreferenceKey.EQUIVE_CURRENCY, "RUB");
                }
                value = BigDecimal.valueOf(actionValue);
                break;
            }
            case PERCENT_COMMISSION: {
                value = BigDecimal.valueOf(actionValue);
                break;
            }
            case SOURCE_COMMISSION_MINUS_FIXED: 
            case SOURCE_COMMISSION_MINUS_PERCENT: {
                value = BigDecimal.valueOf(originalAmount - actionValue);
                if (value.compareTo(BigDecimal.ZERO) >= 0) break;
                value = BigDecimal.ZERO;
                break;
            }
            case PORTION_OF_SOURCE_COMMISSION: {
                value = BigDecimal.valueOf(originalAmount).multiply(BigDecimal.valueOf(actionValue)).divide(BigDecimal.valueOf(100L));
            }
        }
        if (value != null && as.getReversePercent() != 0.0) {
            value = BigDecimal.valueOf(1L).divide(BigDecimal.valueOf(1.0 + as.getReversePercent() / 100.0), 5, java.math.RoundingMode.HALF_UP).multiply(value).abs();
        }
        value = RulesHelper.roundDouble(value, rm, rv);
        RuleResult commissionResult = new RuleResult();
        commissionResult.setAction(originalResult.getAction());
        RuleResultValue commissionResultValue = new RuleResultValue();
        commissionResultValue.setCurrencyCode(currencyCode);
        commissionResultValue.setValue(value.doubleValue());
        commissionResult.setValue((Object)commissionResultValue);
        commissionResultValue.setTarget(prop);
        commissionResultValue.setForceSegmentCalculation(forceSegmentCalculation);
        return new RulesExtractionResult(commissionResult, fees);
    }

    private static List<RuleProxy<RulesMigrationPropertySet, RulesMigrationActionSet>> createProxyList(RuleSettings item, RuleResult ruleResult, String contractBlankOwnerUid, EntityReference<Organization> contractSupplier) {
        ArrayList<RuleProxy<RulesMigrationPropertySet, RulesMigrationActionSet>> result = new ArrayList<RuleProxy<RulesMigrationPropertySet, RulesMigrationActionSet>>();
        RuleAction action = ruleResult.getAction();
        if (action == Actions.FOP_COMMISSION || action == Actions.FOP_FEE) {
            RuleResultValue rrv = (RuleResultValue)ruleResult.getValue();
            if (rrv == null || rrv.getFopValues() == null) {
                return result;
            }
            Double[][] amounts = (Double[][])rrv.getFopValues()[0];
            String[][] currencies = (String[][])rrv.getFopValues()[1];
            for (int n = 0; n < RulesHelper.paymentTypes.length; ++n) {
                for (int m = 0; m < RulesHelper.targetTypes.length; ++m) {
                    Double amount = amounts[n][m];
                    String currency = currencies[n][m];
                    if (amount == null || currency == null) continue;
                    result.add(RulesMigrationHelper.createProxy(item, rrv, m, n, amount, currency, true, contractBlankOwnerUid, contractSupplier));
                }
            }
            return result;
        }
        RuleResultValue rrv = (RuleResultValue)ruleResult.getValue();
        if (rrv != null) {
            result.add(RulesMigrationHelper.createProxy(item, rrv, 0, 0, rrv.getValue(), rrv.getCurrencyCode(), false, contractBlankOwnerUid, contractSupplier));
        }
        return result;
    }

    private static RuleProxy<RulesMigrationPropertySet, RulesMigrationActionSet> createProxy(RuleSettings item, RuleResultValue rrv, int targetTypeIndex, int fopTypeIndex, double amount, String currencyCode, boolean fopBasedValue, String contractBlankOwner, EntityReference<Organization> contractSupplier) {
        RuleRestriction supplierRestriction;
        RuleRestriction validatingCarrierRestriction;
        String[] paymentTypes;
        RulesMigrationPropertySet ps = new RulesMigrationPropertySet();
        Object blankOwner = null;
        ps.setContractBlankOwner(contractBlankOwner);
        ps.setContractSupplier(contractSupplier);
        ps.setPercentCommission(currencyCode == null || "%".equals(currencyCode));
        ps.setRuleName(item.getName());
        ps.setFopTypeIndex(fopTypeIndex);
        ps.setTargetTypeIndex(targetTypeIndex);
        ps.setCommissionProperties(rrv.getTarget());
        ps.setCommissionValue(amount);
        ps.setCurrencyCode(currencyCode);
        for (String paymentType : paymentTypes = RulesHelper.paymentTypes[fopTypeIndex]) {
            if (TextUtil.isBlank((String)paymentType)) continue;
            ps.getPaymentTypes().add(paymentType);
        }
        RuleRestriction blankOwnerRestriction = RulesMigrationHelper.findRestriction(Properties.BLANK_OWNERS, item);
        if (blankOwnerRestriction != null) {
            ps.setBlankOwnerCondition(blankOwnerRestriction.getCondition());
            ps.getBlankOwnerRestrictionCodes().addAll(RulesHelper.toStringCollection(blankOwnerRestriction.getValue()));
        }
        if ((validatingCarrierRestriction = RulesMigrationHelper.findRestriction(Properties.CARRIER_NUMBER, item)) != null) {
            ps.setValidatingCarrierNumberCondition(validatingCarrierRestriction.getCondition());
            ps.getValidatingCarrierNumberRestrictionCodes().addAll(RulesHelper.toStringCollection(validatingCarrierRestriction.getValue()));
        }
        if ((supplierRestriction = RulesMigrationHelper.findRestriction(ProductTicketInfoProperties.SUPPLIERS, item)) != null) {
            ps.setSupplierCondition(supplierRestriction.getCondition());
            ps.getSupplierRestrictions().addAll((List)supplierRestriction.getValue());
        }
        if (fopBasedValue) {
            switch (targetTypeIndex) {
                case 0: {
                    ps.setProductType(ProductType.AIR_TICKET);
                    break;
                }
                case 1: {
                    ps.setProductType(ProductType.MCO_PENALTY);
                    break;
                }
                case 2: {
                    ps.setProductType(ProductType.EXCESS_BAGAGE);
                    break;
                }
                default: {
                    ps.setProductType(ProductType.AIR_TICKET);
                    break;
                }
            }
        } else if (Targets.PRODUCT_COMMISSION == item.getTarget()) {
            for (RuleRestriction restr : item.getRestrictions()) {
                if (restr.getProperty() == Properties.PRODUCT_CATEGORY && Conditions.EQUALS == restr.getCondition()) {
                    if (ProductCategory.EXCESS_BAGAGE == restr.getValue()) {
                        ps.setProductType(ProductType.EXCESS_BAGAGE);
                        break;
                    }
                    if (ProductCategory.AIR == restr.getValue()) {
                        ps.setProductType(ProductType.AIR_TICKET);
                        break;
                    }
                }
                if (restr.getProperty() != Properties.MCO_CATEGORY || Conditions.EQUALS != restr.getCondition() || MCOCategory.PENALTY != restr.getValue()) continue;
                ps.setProductType(ProductType.MCO_PENALTY);
                break;
            }
        }
        RulesMigrationActionSet as = new RulesMigrationActionSet();
        RuleProxy result = new RuleProxy();
        result.setActionSet((Object)as);
        result.setContractType(ContractType.VENDOR.name());
        result.setPropertySet((Object)ps);
        result.setProxyDate(new Date());
        result.setProxyType(RulesMigrationTargets.RULES_ACTION.name());
        return result;
    }

    private static RuleRestriction findRestriction(RuleProperty prop, RuleSettings rs) {
        for (RuleRestriction item : rs.getRestrictions()) {
            if (item.getProperty() != prop) continue;
            return item;
        }
        return null;
    }

    private static boolean isAppropriate(RuleResult ruleResult) {
        RuleAction action = ruleResult.getAction();
        if (action == null) {
            return false;
        }
        if (ruleResult.getValue() == null || !(ruleResult.getValue() instanceof RuleResultValue)) {
            return false;
        }
        return action == Actions.SIMPLE_COMMISSION || action == Actions.FOP_COMMISSION || action == Actions.SIMPLE_FEE || action == Actions.FOP_FEE || action == GeneralProductActions.GENERAL_COMMISSION || action == GeneralProductActions.GENERAL_FEE;
    }

    static final class RulesExtractionResult {
        final RuleResult commission;
        final List<RuleResult> additionalFees;

        RulesExtractionResult(RuleResult comm, List<RuleResult> fees) {
            this.commission = comm;
            this.additionalFees = fees;
        }
    }
}

