/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.standard;

import com.gridnine.xtrip.common.model.rules.standard.Actions;
import com.gridnine.xtrip.common.model.rules.standard.CommonProductProperties;
import com.gridnine.xtrip.common.model.rules.standard.ContractsFilteringCategories;
import com.gridnine.xtrip.common.model.rules.standard.GeneralProductActions;
import com.gridnine.xtrip.common.model.rules.standard.HotelProperties;
import com.gridnine.xtrip.common.model.rules.standard.RuleEnvironmentHelper;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.rules.RulesEnvironment;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;

public class HotelRuleEnvironment
implements RulesEnvironment.Hook {
    public void environmentInitialized(RulesEnvironment env) {
        ContractsFilteringCategories[] filteringCategories = ContractsFilteringCategories.values();
        env.registerProperties((RuleProperty[])HotelProperties.values());
        for (HotelProperties property : HotelProperties.values()) {
            for (String targetId : property.getTargetIds()) {
                env.registerTarget2propertyAssociation(targetId, property.getId());
            }
            RuleEnvironmentHelper.registerPropertiesToContracts(env, property);
        }
        String targetId = Targets.HOTELS_COMMISSION.getId();
        for (CommonProductProperties commonProductProperties : new CommonProductProperties[]{CommonProductProperties.TICKET_TYPE, CommonProductProperties.PRODUCT_STATUS}) {
            env.registerTarget2propertyAssociation(targetId, commonProductProperties.getId());
        }
        RuleEnvironmentHelper.registerTargetToContracts(env, targetId);
        for (CommonProductProperties commonProductProperties : new RuleAction[]{Actions.SIMPLE_FEE, Actions.PAYMENT_FEE, GeneralProductActions.GENERAL_COMMISSION}) {
            env.registerTarget2actionAssociation(targetId, commonProductProperties.getId());
            for (ContractsFilteringCategories rfc : filteringCategories) {
                env.registerFilteringCategory2actionAssociation(rfc.getId(), commonProductProperties.getId());
            }
        }
    }
}

