/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.standard;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.DiscountProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public final class ProxyHelper {
    private static final Logger log = LoggerFactory.getLogger(ProxyHelper.class);
    private static final String NEGATIVE_PREFIX = "!";

    public static boolean includesOnly(Collection<String> coll, String[] data) {
        if (data == null) {
            return false;
        }
        return ProxyHelper.includesOnly(coll, Arrays.asList(data));
    }

    public static boolean includesOnly(Collection<String> coll, List<String> data) {
        ArrayList<String> items = new ArrayList<String>();
        for (String item : coll) {
            if (TextUtil.isBlank((String)item)) continue;
            items.add(item.trim());
        }
        ArrayList<String[]> res = new ArrayList<String[]>();
        for (String item : items) {
            res.add(new String[]{item});
        }
        return ProxyHelper.containsOnly(res, data);
    }

    public static boolean containsOnly(List<String[]> visitedCities, String[] data) {
        return ProxyHelper.containsOnly(visitedCities, data, true);
    }

    public static boolean containsOnly(List<String[]> visitedCities, List<String> data) {
        return ProxyHelper.containsOnly(visitedCities, data, true);
    }

    public static boolean confinedTo(List<String[]> visitedCities, String[] data) {
        return ProxyHelper.containsOnly(visitedCities, data, false);
    }

    public static boolean confinedTo(List<String[]> visitedCities, List<String> data) {
        return ProxyHelper.containsOnly(visitedCities, data, false);
    }

    private static boolean containsOnly(List<String[]> visitedCities, String[] data, boolean strict) {
        if (data == null) {
            return visitedCities.isEmpty();
        }
        return ProxyHelper.containsOnly(visitedCities, Arrays.asList(data), strict);
    }

    private static boolean containsOnly(List<String[]> visitedCities, List<String> data, boolean strict) {
        if (data.isEmpty()) {
            return visitedCities.isEmpty();
        }
        block0: for (String pattern : data) {
            if (TextUtil.isBlank((String)pattern)) continue;
            String[] locations = pattern.split("-");
            for (String[] codes : visitedCities) {
                boolean found = false;
                for (String location : locations) {
                    if (codes == null || codes.length == 0 || !ProxyHelper.collectionContains(codes, location)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                continue block0;
            }
            if (!strict) {
                return true;
            }
            for (String location : locations) {
                boolean found = false;
                for (String[] codes : visitedCities) {
                    if (codes == null || codes.length == 0 || !ProxyHelper.collectionContains(codes, location)) continue;
                    found = true;
                    break;
                }
                if (!found) continue block0;
            }
            return true;
        }
        return false;
    }

    public static boolean collectionContains(List<String[]> visitedCities, String[] data, boolean include) {
        if (data == null) {
            return visitedCities.isEmpty();
        }
        return ProxyHelper.collectionContains(visitedCities, Arrays.asList(data), include);
    }

    public static boolean collectionContains(List<String[]> visitedCities, Collection<String> data, boolean include) {
        if (data.isEmpty()) {
            return visitedCities.isEmpty();
        }
        for (String location : data) {
            if (TextUtil.isBlank((String)location)) continue;
            boolean negative = location.startsWith(NEGATIVE_PREFIX);
            if (negative) {
                location = location.substring(1);
            }
            boolean found = false;
            block1: for (String[] locs : visitedCities) {
                if (locs == null || locs.length == 0) continue;
                for (String loc : locs) {
                    if (!location.equals(loc)) continue;
                    if (negative) continue block1;
                    found = true;
                    break block1;
                }
                if (!negative) continue;
                found = true;
                break;
            }
            if (include && found) {
                return true;
            }
            if (include || !found) continue;
            return false;
        }
        return !include;
    }

    public static String getRuleCategory(String className, String uid) {
        try {
            EntityContainer ctr = EntityStorage.get().resolve(new EntityReference(uid, XHelper.getClass((String)className), null));
            if (ctr != null) {
                BaseCommissionProperties prop = (BaseCommissionProperties)ctr.getEntity();
                if (prop instanceof CommissionProperties) {
                    CommissionProperties cp = (CommissionProperties)prop;
                    return String.format("%s|%s|%s|%s|%s", className, cp.getCategory() != null ? cp.getCategory().getCode() : "null", Boolean.toString(cp.isMinimum()), Boolean.toString(cp.isBonus()), Boolean.toString(cp.isBspCommission()));
                }
                if (prop instanceof DiscountProperties) {
                    DiscountProperties dp = (DiscountProperties)prop;
                    return String.format("%s|%s|%s", className, dp.getCategory() != null ? dp.getCategory().getCode() : "null", dp.getType());
                }
                if (prop instanceof PaymentFeeProperties) {
                    PaymentFeeProperties dp = (PaymentFeeProperties)prop;
                    return String.format("%s|%s|%s", className, dp.getPaymentType() != null ? dp.getPaymentType().name() : "null", dp.getType() != null ? dp.getType().name() : "null");
                }
                FeeProperties fp = (FeeProperties)prop;
                return String.format("%s|%s|%s", className, fp.getCategory() != null ? fp.getCategory().getCode() : "null", fp.getType());
            }
        }
        catch (Exception e) {
            log.error("unable to generate rule category", (Throwable)e);
        }
        log.warn(String.format("unable to generate rule category: className = %s, uid = %s", className, uid));
        return "";
    }

    private static boolean collectionContains(String[] codes, String location) {
        if (TextUtil.isBlank((String)location) || codes == null || codes.length == 0) {
            return false;
        }
        return ProxyHelper.collectionContains(Arrays.asList(codes), location);
    }

    private static boolean collectionContains(Collection<String> codes, String location) {
        if (TextUtil.isBlank((String)location) || codes == null || codes.isEmpty()) {
            return false;
        }
        for (String pattern : location.trim().split("&")) {
            if (TextUtil.isBlank((String)pattern)) continue;
            boolean negative = pattern.contains(NEGATIVE_PREFIX);
            if (negative) {
                pattern = pattern.substring(NEGATIVE_PREFIX.length());
            }
            boolean found = false;
            for (String code : codes) {
                if (!pattern.equalsIgnoreCase(code)) continue;
                found = true;
                break;
            }
            if (negative && found) {
                return false;
            }
            if (negative || found) continue;
            return false;
        }
        return true;
    }

    public static boolean collectionIncludes(Collection<String> codes, String[] locations) {
        if (locations == null) {
            return false;
        }
        return ProxyHelper.collectionIncludes(codes, Arrays.asList(locations));
    }

    public static boolean collectionIncludes(Collection<String> codes, List<String> locations) {
        if (locations.isEmpty() || codes == null || codes.isEmpty()) {
            return false;
        }
        for (String loc : locations) {
            if (TextUtil.isBlank((String)loc) || !ProxyHelper.collectionContains(codes, loc)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsSegment(List<List<String[]>> flightSegments, String[] data) {
        if (data == null) {
            return false;
        }
        return ProxyHelper.containsSegment(flightSegments, Arrays.asList(data));
    }

    public static boolean containsSegment(List<List<String[]>> flightSegments, List<String> data) {
        for (List<String[]> segment : flightSegments) {
            if (!ProxyHelper.containsOnly(segment, data)) continue;
            return true;
        }
        return false;
    }

    private ProxyHelper() {
    }

    public static String getActionSetVar(RuleTarget target) {
        return "((" + target.getActionSetClassName() + ") proxy.getActionSet())";
    }

    static void buildTchCommissionScript(StringBuilder buf, Object value, String methodName, String ruleCategory) {
        Object[] values = (Object[])value;
        Double[][] doubleValues = (Double[][])values[0];
        String[][] codes = (String[][])values[1];
        buf.append("\t\t\tboolean applied = false;\r\n");
        final HashMap<Integer, String[]> ptMap = new HashMap<Integer, String[]>();
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        for (int n = 0; n < RulesHelper.paymentTypes.length; ++n) {
            Integer number = n;
            ptMap.put(number, RulesHelper.paymentTypes[n]);
            numbers.add(number);
        }
        Collections.sort(numbers, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                String[] arr1 = (String[])ptMap.get(o1);
                int l1 = 0;
                for (String element : arr1) {
                    if (element == null) continue;
                    ++l1;
                }
                String[] arr2 = (String[])ptMap.get(o2);
                int l2 = 0;
                for (String element : arr2) {
                    if (element == null) continue;
                    ++l2;
                }
                if (l2 != l1) {
                    return l2 > l1 ? 1 : -1;
                }
                return o1.compareTo(o2);
            }
        });
        for (int m = 0; m < RulesHelper.targetTypes.length; ++m) {
            for (Integer number : numbers) {
                String code;
                Double doubleValue = doubleValues[number][m];
                if (doubleValue == null || (code = codes[number][m]) == null) continue;
                buf.append("\t\t\tapplied = applied || ").append(methodName).append("(").append(doubleValue).append(", \"").append(code).append("\", \"").append(RulesHelper.targetTypes[m]).append("\", ");
                boolean first = true;
                buf.append("new String[]{");
                for (String fop : RulesHelper.paymentTypes[number]) {
                    if (fop == null) continue;
                    if (!first) {
                        buf.append(", ");
                    }
                    buf.append('\"').append(fop).append('\"');
                    first = false;
                }
                buf.append("});\r\n");
            }
        }
        buf.append("\t\t\tif(applied){\r\n");
        buf.append("\t\t\t\tproxy.getAppliedRuleCategories().add(").append(ruleCategory).append(");\r\n");
        buf.append("\t\t\t}\r\n");
    }

    public static String ptCommissionValue2Str(Object value) {
        int n;
        if (value == null) {
            return null;
        }
        Object[] values = (Object[])value;
        Double[] doubleValues = (Double[])values[0];
        String[] codes = (String[])values[1];
        StringBuilder buf = new StringBuilder();
        for (n = 0; n < PaymentType.values().length; ++n) {
            Double doubleValue = doubleValues[n];
            buf.append(doubleValue == null ? "null" : doubleValue.toString()).append(";");
        }
        buf.append(";");
        for (n = 0; n < PaymentType.values().length; ++n) {
            String valueStr = codes[n];
            buf.append(valueStr == null ? "null" : valueStr).append(";");
        }
        buf.append(";");
        if (PaymentType.values().length == 0) {
            buf.append(";");
        }
        return buf.toString();
    }

    static void buildCommissionScript(StringBuilder sb, String actionSet, RuleResultValue res, String category) {
        if (res == null || res.getTarget() == null) {
            log.warn("rule result value is null or target is undefined");
            return;
        }
        sb.append(String.format("\t\t\tif(%s.accept(%s, \"%s\", \"%s\")){\r\n", actionSet, category, res.getTarget().getType().getName(), res.getTarget().getUid()));
        if (res.getFopValues() != null) {
            Double[][] doubleValues = (Double[][])res.getFopValues()[0];
            String[][] codes = (String[][])res.getFopValues()[1];
            sb.append("\t\t\t\tboolean applied = false;\r\n");
            final HashMap<Integer, String[]> ptMap = new HashMap<Integer, String[]>();
            ArrayList<Integer> numbers = new ArrayList<Integer>();
            for (int n = 0; n < RulesHelper.paymentTypes.length; ++n) {
                Integer number = n;
                ptMap.put(number, RulesHelper.paymentTypes[n]);
                numbers.add(number);
            }
            Collections.sort(numbers, new Comparator<Integer>(){

                @Override
                public int compare(Integer o1, Integer o2) {
                    String[] arr1 = (String[])ptMap.get(o1);
                    int l1 = 0;
                    for (String element : arr1) {
                        if (element == null) continue;
                        ++l1;
                    }
                    String[] arr2 = (String[])ptMap.get(o2);
                    int l2 = 0;
                    for (String element : arr2) {
                        if (element == null) continue;
                        ++l2;
                    }
                    if (l2 != l1) {
                        return l2 > l1 ? 1 : -1;
                    }
                    return o1.compareTo(o2);
                }
            });
            for (int m = 0; m < RulesHelper.targetTypes.length; ++m) {
                for (Integer number : numbers) {
                    String code;
                    Double doubleValue = doubleValues[number][m];
                    if (doubleValue == null || (code = codes[number][m]) == null) continue;
                    sb.append(String.format("\t\t\t\tapplied = applied || %s.setCommission(%s, \"%s\", \"%s\",", actionSet, category, res.getTarget().getType().getName(), res.getTarget().getUid()));
                    sb.append(doubleValue).append(", \"").append(code).append("\", \"").append(RulesHelper.targetTypes[m]).append("\", ");
                    boolean first = true;
                    sb.append("new String[]{");
                    for (String fop : RulesHelper.paymentTypes[number]) {
                        if (fop == null) continue;
                        if (!first) {
                            sb.append(", ");
                        }
                        sb.append('\"').append(fop).append('\"');
                        first = false;
                    }
                    sb.append("});\r\n");
                }
            }
            sb.append("\t\t\t\tif(applied){\r\n");
            sb.append("\t\t\t\t\tproxy.getAppliedRuleCategories().add(").append(category).append(");\r\n");
            sb.append("\t\t\t\t}\r\n");
        } else {
            sb.append(String.format("\t\t\t\t%s.setCommission(%s, \"%s\", \"%s\", %s, \"%s\");\r\n", actionSet, category, res.getTarget().getType().getName(), res.getTarget().getUid(), Double.toString(res.getValue()), res.getCurrencyCode()));
            sb.append("\t\t\t\tproxy.getAppliedRuleCategories().add(").append(category).append(");\r\n");
        }
        sb.append("\t\t\t}\r\n");
    }
}

