/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.standard;

import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.AppliedRule;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.CurrencyRate;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.DiscountProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.Operation;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.RoundingMode;
import com.gridnine.xtrip.common.model.booking.commission.RoundingValue;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.GeoRegion;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.MulticurrencyHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileDao;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.BaseRulesContainer;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.ContractRelationDescription;
import com.gridnine.xtrip.common.model.profile.EmployeeCategory;
import com.gridnine.xtrip.common.model.profile.ExchangeRateCondition;
import com.gridnine.xtrip.common.model.profile.ExchangeRateData;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.rules.l10n.Messages;
import com.gridnine.xtrip.common.model.rules.standard.AirTicketPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.BasicCommissionActionsProvider;
import com.gridnine.xtrip.common.model.rules.standard.CachedRulesCategoriesProvider;
import com.gridnine.xtrip.common.model.rules.standard.CommissionActionsProvider;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.Constants;
import com.gridnine.xtrip.common.model.rules.standard.PtRuleResultValue;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.model.rules.standard.SabreRemarkResult;
import com.gridnine.xtrip.common.model.rules.standard.ServiceClassCommissionsRuleResultValue;
import com.gridnine.xtrip.common.model.rules.standard.TransatlaticRouteHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.RateMoney;
import com.gridnine.xtrip.common.model.system.ServiceClassCommissionType;
import com.gridnine.xtrip.common.model.validation.StandartValidationMessageType;
import com.gridnine.xtrip.common.model.validation.ValidationMessageHelper;
import com.gridnine.xtrip.common.model.validation.ValidationMessageType;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.RulesEnvironment;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.Base64;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.DateInterval;
import com.gridnine.xtrip.common.util.FormattedNumberUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.common.xml.XUtil;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.RandomAccess;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RulesHelper {
    private static final Logger log = LoggerFactory.getLogger(RulesHelper.class);
    private static final String NEGATIVE_PREFIX = "!";
    public static final String[][] paymentTypes = new String[][]{{PaymentType.CASH.name(), null}, {PaymentType.CREDIT_CARD.name(), null}, {PaymentType.CASH.name(), PaymentType.CREDIT_CARD.name()}, {PaymentType.INVOICE.name(), null}, {PaymentType.INTERLINE.name(), null}, {PaymentType.CASH.name(), PaymentType.INTERLINE.name()}, {PaymentType.CREDIT.name(), null}, {PaymentType.CASH.name(), PaymentType.CREDIT.name()}, {PaymentType.MTD.name(), null}, {PaymentType.CASH.name(), PaymentType.MTD.name()}, {PaymentType.PTA.name(), null}, {null, null}};
    public static final String[] targetTypes = new String[]{ProductCategory.AIR.name(), MCOCategory.PENALTY.name(), ProductCategory.EXCESS_BAGAGE.name()};
    private static final List<Integer> numbers = new ArrayList<Integer>();

    public static Object[] ptCommissionStr2Value(String str) {
        if (TextUtil.isBlank((String)str)) {
            return null;
        }
        int length = PaymentType.values().length;
        Double[] values = new Double[length];
        int i = 0;
        int curIndex = 0;
        while (!str.substring(curIndex).startsWith(";;")) {
            if (curIndex != 0) {
                ++curIndex;
            }
            String valueStr = str.substring(curIndex, str.indexOf(";", curIndex));
            curIndex = str.indexOf(";", curIndex);
            values[i] = "null".equals(valueStr = valueStr.trim()) ? null : Double.valueOf(valueStr);
            ++i;
        }
        String codesStr = str.substring(str.indexOf(";;") + 2).trim();
        String[] codes = new String[length];
        i = 0;
        curIndex = 0;
        while (!codesStr.substring(curIndex).startsWith(";;")) {
            if (curIndex != 0) {
                ++curIndex;
            }
            String valueStr = codesStr.substring(curIndex, codesStr.indexOf(";", curIndex));
            curIndex = codesStr.indexOf(";", curIndex);
            codes[i] = "null".equals(valueStr = valueStr.trim()) ? null : valueStr;
            ++i;
        }
        return new Object[]{values, codes};
    }

    public static String getTchCommissionInfo(Object value) {
        StringBuilder buf = new StringBuilder();
        Object[] values = (Object[])value;
        Double[][] doubleValues = (Double[][])values[0];
        String[][] codes = (String[][])values[1];
        RuleResultValue.FOPCommissionType[][] types = values.length == 3 ? (RuleResultValue.FOPCommissionType[][])values[2] : (RuleResultValue.FOPCommissionType[][])null;
        LinkedHashSet<String> airTicketCommission = new LinkedHashSet<String>();
        LinkedHashSet<String> penaltyCommission = new LinkedHashSet<String>();
        LinkedHashSet<String> baggageCommission = new LinkedHashSet<String>();
        for (int m = 0; m < 3; ++m) {
            for (int n = 0; n < paymentTypes.length; ++n) {
                String code;
                Double doubleValue = doubleValues[n][m];
                if (doubleValue == null || (code = codes[n][m]) == null) continue;
                String commission = String.valueOf(doubleValue) + ' ' + code;
                if (types != null && types[n][m] != null && types[n][m] == RuleResultValue.FOPCommissionType.PER_SEGMENT) {
                    commission = commission + "(" + L10n.get((String)Messages.SEG) + ")";
                }
                if (m == 0) {
                    airTicketCommission.add(commission);
                    continue;
                }
                if (m == 1) {
                    penaltyCommission.add(commission);
                    continue;
                }
                baggageCommission.add(commission);
            }
        }
        RulesHelper.addCommission(buf, airTicketCommission, L10n.get((String)Messages.AIRTICKET_COMMISSION));
        RulesHelper.addCommission(buf, penaltyCommission, L10n.get((String)Messages.PENALTY_COMMISSION));
        RulesHelper.addCommission(buf, baggageCommission, L10n.get((String)Messages.BAGGAGE_COMMISSION));
        return buf.toString();
    }

    public static String getPtCommissionInfo(Object value) {
        StringBuilder buf = new StringBuilder();
        Object[] values = (Object[])value;
        Double[] doubleValues = (Double[])values[0];
        String[] codes = (String[])values[1];
        for (int n = 0; n < PaymentType.values().length; ++n) {
            String code;
            Double doubleValue = doubleValues[n];
            if (doubleValue == null || (code = codes[n]) == null) continue;
            if (buf.length() != 0) {
                buf.append(' ');
            }
            buf.append(String.valueOf(doubleValue) + ' ' + code);
        }
        return buf.toString();
    }

    public static boolean isRate(RuleResultValue res) {
        return res != null && TextUtil.isSame((String)res.getCurrencyCode(), (String)"%");
    }

    public static void buildCommissionInfo(StringBuilder sb, RuleResultValue res) {
        if (res == null) {
            return;
        }
        EntityContainer ctr = null;
        try {
            ctr = EntityStorage.get().resolve(res.getTarget());
        }
        catch (Exception e) {
            log.error("unable to load commission properties " + res.getTarget(), (Throwable)e);
        }
        BaseCommissionProperties prop = ctr != null ? (BaseCommissionProperties)ctr.getEntity() : null;
        sb.append(prop != null && !TextUtil.isBlank((String)prop.getDisplayName()) ? prop.getDisplayName() : "???").append(' ');
        if (res.getFopValues() != null) {
            sb.append(RulesHelper.getTchCommissionInfo(res.getFopValues()));
        } else {
            sb.append((res.getCurrencyCode() != null && !RulesHelper.isRate(res) ? LocaleManager.get().getCurrentLocaleData().getPriceFormat() : new DecimalFormat("#,##0.000")).format(res.getValue())).append(' ');
            sb.append(res.getCurrencyCode() != null ? res.getCurrencyCode() : "%");
        }
    }

    static void buildCommissionInfo(StringBuilder info, ServiceClassCommissionsRuleResultValue ruleResultValue) {
        EntityContainer commissionPropertiesContainer = null;
        try {
            commissionPropertiesContainer = EntityStorage.get().resolve(ruleResultValue.getTarget());
        }
        catch (Exception e) {
            log.error("unable to load commission properties " + ruleResultValue.getTarget(), (Throwable)e);
        }
        BaseCommissionProperties commissionProperties = commissionPropertiesContainer != null ? (BaseCommissionProperties)commissionPropertiesContainer.getEntity() : null;
        info.append(commissionProperties != null && !TextUtil.isBlank((String)commissionProperties.getDisplayName()) ? commissionProperties.getDisplayName() : "???");
        info.append(" ");
        if (ruleResultValue.getCommissionType() == ServiceClassCommissionType.MINIMUM) {
            info.append(L10n.get((String)Messages.MIN_FEM_ACCUSATIVE));
        } else if (ruleResultValue.getCommissionType() == ServiceClassCommissionType.MAXIMUM) {
            info.append(L10n.get((String)Messages.MAX_FEM_ACCUSATIVE));
        } else if (ruleResultValue.getCommissionType() == ServiceClassCommissionType.AVERAGE) {
            info.append(L10n.get((String)Messages.AVR_FEM_ACCUSATIVE));
        } else {
            info.append("?");
        }
        info.append(" " + L10n.get((String)Messages.OF) + " ");
        StringBuilder values = new StringBuilder();
        for (ServiceClassCommissionsRuleResultValue.ServiceClassCommissionValue value : ruleResultValue.getValues()) {
            if (values.length() > 0) {
                values.append(", ");
            }
            values.append(value.getValue() != null ? LocaleManager.get().getCurrentLocaleData().getPriceFormat().format(value.getValue()) : "?");
            if (!TextUtil.isSame((String)ruleResultValue.getCurrencyCode(), (String)"%")) {
                values.append(" ");
            }
            values.append(!TextUtil.isBlank((String)ruleResultValue.getCurrencyCode()) ? ruleResultValue.getCurrencyCode() : "?");
            String serviceClassCodesString = !TextUtil.isBlank((String)value.getServiceClassCodes()) ? value.getServiceClassCodes() : "?";
            String[] serviceClassCodes = serviceClassCodesString.split("\\s*[,;]\\s*");
            serviceClassCodesString = TextUtil.join((String)", ", Arrays.asList(serviceClassCodes), (boolean)true);
            values.append(" (" + serviceClassCodesString + ")");
        }
        info.append(values.length() > 0 ? values : "?");
    }

    public static void buildRemarkInfo(StringBuilder sb, SabreRemarkResult res) {
        String cur;
        sb.append(L10n.get((String)Messages.ADD_SABRE_REMARK) + ":");
        String line = res.getTemplate();
        String value = res.getValue() != null ? String.valueOf(res.getValue()) : "";
        String string = cur = res.getCurrencyCode() != null ? res.getCurrencyCode() : "";
        if (!TextUtil.isBlank((String)line)) {
            sb.append(RulesHelper.buildContractRemarkByTemplate(line, value, cur, false, true));
        }
    }

    public static String buildContractRemarkByTemplate(String template, String val1, String val2, boolean needDots, boolean needFixedLength) {
        boolean hasMarks;
        int num = 1;
        StringBuilder sb = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        boolean bl = hasMarks = template.indexOf("$") != -1;
        while (template.indexOf("$") != -1) {
            int pos = template.indexOf("$");
            sb.append(template, 0, pos);
            template = template.substring(pos + 1, template.length());
            int spacePos = template.indexOf(" ");
            template = spacePos > 0 ? template.substring(spacePos, template.length()).trim() : "";
            if (num == 1) {
                if (val1.equals("%")) {
                    val1 = "PCN";
                }
                sb2.append(val1);
                ++num;
                continue;
            }
            if (num != 2) continue;
            if (val2.equals("%")) {
                val2 = "PCN";
            }
            sb2.append(" " + val2);
            ++num;
        }
        if (!hasMarks) {
            sb.append(template);
        } else {
            sb2.append(template);
        }
        if (needDots) {
            while (sb.length() + sb2.length() < 54) {
                sb.append(".");
            }
        }
        if (needFixedLength && sb.length() + sb2.length() > 54) {
            sb.delete(54 - sb2.length() - 1, sb.length());
            if (needDots) {
                sb.append(".");
            } else {
                sb.append(" ");
            }
        }
        sb.append((CharSequence)sb2);
        return sb.toString();
    }

    static void buildPtCommissionInfo(StringBuilder sb, PtRuleResultValue res) {
        sb.append(L10n.get((String)Messages.SET_FOP_COMMISSIONS) + " ");
        if (res.getPtValues() != null) {
            sb.append(RulesHelper.getPtCommissionInfo(res.getPtValues()));
        }
    }

    public static String getRuleCategory(RuleResultValue res) {
        if (res == null || res.getTarget() == null) {
            log.warn("rule result value is null or target is undefined");
            return "\"\"";
        }
        EntityContainer ctr = EntityStorage.get().resolve(res.getTarget());
        if (ctr == null) {
            log.warn("unable to load commission properties {}", res.getTarget());
            return "\"\"";
        }
        return String.format("%s.ProxyHelper.getRuleCategory(\"%s\", \"%s\")", Constants.COMMON_PACKAGE_NAME, ctr.getEntityType().getName(), ctr.getUid());
    }

    static String getDefaultCommissionCategory() {
        return "\"old_style_commission\"";
    }

    public static RuleResultValue string2Value(String str) {
        if (TextUtil.isBlank((String)str)) {
            return null;
        }
        RuleResultValue res = new RuleResultValue();
        try {
            XUtil.fromString((String)new String(Base64.decode((String)str), "utf-8"), (XSerializable)res);
            return res;
        }
        catch (Exception e) {
            log.warn("unable to decode rule result value from string", (Throwable)e);
            return null;
        }
    }

    static PtRuleResultValue string2PtValue(String str) {
        if (TextUtil.isBlank((String)str)) {
            return null;
        }
        PtRuleResultValue res = new PtRuleResultValue();
        try {
            XUtil.fromString((String)new String(Base64.decode((String)str), "utf-8"), (XSerializable)res);
            return res;
        }
        catch (Exception e) {
            log.warn("unable to decode rule result value from string", (Throwable)e);
            return null;
        }
    }

    public static String value2String(RuleResultValue value) {
        if (value == null) {
            return null;
        }
        try {
            return Base64.encode((byte[])XSUtil.toString((XSSerializable)value).getBytes("utf-8"));
        }
        catch (Exception e) {
            log.warn("unable to encode rule result value", (Throwable)e);
            return null;
        }
    }

    static String value2String(ServiceClassCommissionsRuleResultValue value) {
        if (value == null) {
            return null;
        }
        try {
            return Base64.encode((byte[])XSUtil.toString((XSSerializable)value).getBytes("utf-8"));
        }
        catch (Exception e) {
            log.warn("unable to encode rule result value", (Throwable)e);
            return null;
        }
    }

    public static String ptValue2String(PtRuleResultValue value) {
        if (value == null) {
            return null;
        }
        try {
            return Base64.encode((byte[])XSUtil.toString((XSSerializable)value).getBytes("utf-8"));
        }
        catch (Exception e) {
            log.warn("unable to encode rule result value", (Throwable)e);
            return null;
        }
    }

    public static <E extends Enum<E>> String values2str(List<E> data) {
        if (data == null || data.isEmpty()) {
            return null;
        }
        StringBuilder res = new StringBuilder();
        for (Enum item : data) {
            if (item == null) continue;
            if (res.length() != 0) {
                res.append(',');
            }
            res.append(item.name());
        }
        return res.length() > 0 ? res.toString() : null;
    }

    static <E extends Enum<E>> String[] values2array(List<E> data) {
        if (data == null || data.isEmpty()) {
            return new String[0];
        }
        String[] res = new String[data.size()];
        for (int n = 0; n < data.size(); ++n) {
            Enum item = (Enum)data.get(n);
            if (item == null) continue;
            res[n] = item.name();
        }
        return res;
    }

    public static <E extends Enum<E>> List<E> str2values(String data, Class<E> cls) {
        if (TextUtil.isBlank((String)data)) {
            return Collections.emptyList();
        }
        ArrayList<Enum> result = new ArrayList<Enum>();
        for (String str : data.split(",")) {
            Enum item;
            if (TextUtil.isBlank((String)str) || (item = CollectionUtil.findEnumConstant(cls, (String)str.trim())) == null) continue;
            result.add(item);
        }
        return result;
    }

    public static <E extends Enum<E>> String values2text(List<E> data) {
        if (data == null || data.isEmpty()) {
            return null;
        }
        StringBuilder res = new StringBuilder();
        for (Enum item : data) {
            if (item == null) continue;
            if (res.length() != 0) {
                res.append(", ");
            }
            res.append(item.toString());
        }
        return res.length() > 0 ? res.toString() : L10n.get((String)Messages.Properties_notSelected);
    }

    private static void addCommission(StringBuilder buf, Collection<String> commissions, String code) {
        if (buf.length() != 0) {
            buf.append(' ');
        }
        buf.append(code).append(':');
        boolean first = true;
        for (String commission : commissions) {
            if (!first) {
                buf.append(',');
            }
            first = false;
            buf.append(commission);
        }
    }

    public static String[] getValues(String str) {
        if (TextUtil.isBlank((String)str)) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer(str, ",;", false);
        ArrayList<String> lst = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (TextUtil.isBlank((String)token)) continue;
            lst.add(token.trim());
        }
        return lst.toArray(new String[lst.size()]);
    }

    public static String buildRegularExpression(String prefix, String[] values, String suffix) {
        StringBuilder sb = new StringBuilder("^");
        for (int n = 0; n < values.length; ++n) {
            String value = values[n];
            if (n != 0) {
                sb.append("|");
            }
            if (!TextUtil.isBlank((String)prefix)) {
                sb.append(prefix);
            }
            sb.append(value);
            if (TextUtil.isBlank((String)suffix)) continue;
            sb.append(suffix);
        }
        sb.append("$");
        return sb.toString();
    }

    public static DateFormat getDateFormat() {
        return new SimpleDateFormat("yyyyMMdd");
    }

    public static <E extends Enum<?>> String getEnumName(E value) {
        if (value == null) {
            return null;
        }
        return value.name();
    }

    public static <D extends BaseDictionary> String getDictCode(DictionaryReference<D> value) {
        if (value == null) {
            return null;
        }
        return value.getCode();
    }

    public static String getString(String value) {
        return TextUtil.isBlank((String)value) ? null : value.trim();
    }

    public static double getDoubleValue(BigDecimal value) {
        if (value == null) {
            return 0.0;
        }
        return value.doubleValue();
    }

    public static boolean matchesStringRestriction(Collection<String> collection, Object value, boolean includes) {
        List<String> values = RulesHelper.toStringCollection(value);
        if (!(values instanceof RandomAccess)) {
            IncidentsLog.reportStackTrace((String)"List and not RandomAccess");
        }
        for (int i = 0; i < values.size(); ++i) {
            String item = values.get(i);
            if (!collection.contains(item)) continue;
            return includes;
        }
        return !includes;
    }

    public static boolean matchesStringRangeRestriction(Collection<String> candidates, Object value, boolean includes) {
        List<String> values = RulesHelper.toStringCollection(value);
        for (String item : values) {
            if (!candidates.contains(item)) continue;
            return includes;
        }
        List<MiscUtil.Pair<String, String>> ranges = RulesHelper.toRangeCollection(value);
        for (MiscUtil.Pair<String, String> range : ranges) {
            for (String candidate : candidates) {
                if (!TextUtil.isContainsDigits((String)candidate) || !FormattedNumberUtil.isInRange((String)candidate, (String)((String)range.getFirst()), (String)((String)range.getSecond()))) continue;
                return includes;
            }
        }
        return !includes;
    }

    public static <E extends Enum<E>> boolean matchesEnumRestriction(String property, List<E> values, boolean equals) {
        if (!(values instanceof RandomAccess)) {
            IncidentsLog.reportStackTrace((String)"List and not RandomAccess");
        }
        for (int i = 0; i < values.size(); ++i) {
            Enum item = (Enum)values.get(i);
            if (!item.name().equals(property)) continue;
            return equals;
        }
        return !equals;
    }

    public static <E extends Enum<E>> boolean matchesEnumRestriction(E property, List<E> values, boolean equals) {
        if (!(values instanceof RandomAccess)) {
            IncidentsLog.reportStackTrace((String)"List and not RandomAccess");
        }
        for (int i = 0; i < values.size(); ++i) {
            Enum item = (Enum)values.get(i);
            if (item != property) continue;
            return equals;
        }
        return !equals;
    }

    public static <E extends Enum<E>> boolean matchesEnumRestriction(Collection<String> coll, List<E> values, boolean includes) {
        if (!(values instanceof RandomAccess)) {
            IncidentsLog.reportStackTrace((String)"List and not RandomAccess");
        }
        for (int i = 0; i < values.size(); ++i) {
            Enum item = (Enum)values.get(i);
            if (!coll.contains(item.name())) continue;
            return includes;
        }
        return !includes;
    }

    public static <E extends Enum<E>> boolean matchesEnumsRestriction(Collection<E> coll, List<E> values, boolean includes) {
        if (!(values instanceof RandomAccess)) {
            IncidentsLog.reportStackTrace((String)"List and not RandomAccess");
        }
        for (int i = 0; i < values.size(); ++i) {
            Enum item = (Enum)values.get(i);
            if (!coll.contains(item)) continue;
            return includes;
        }
        return !includes;
    }

    public static <D extends BaseDictionary> boolean matchesDictRestriction(String property, Collection<DictionaryReference<D>> values, boolean equals) {
        for (DictionaryReference<D> item : values) {
            if (!item.getCode().equals(property)) continue;
            return equals;
        }
        return !equals;
    }

    public static <D extends BaseDictionary> boolean matchesDictRestriction(Collection<String> coll, List<DictionaryReference<D>> values, boolean includes) {
        for (DictionaryReference<D> item : values) {
            if (!coll.contains(item.getCode())) continue;
            return includes;
        }
        return !includes;
    }

    public static <D extends BaseDictionary> boolean matchesContainsOnlyDictRestriction(Collection<String> coll, List<DictionaryReference<D>> values, boolean containsOnly) {
        for (String item : coll) {
            if (!values.stream().noneMatch(it -> MiscUtil.equals((Object)item, (Object)it.getCode()))) continue;
            return !containsOnly;
        }
        return containsOnly;
    }

    public static <E extends BaseEntity> boolean matchesEntityRestriction(Collection<? extends EntityReference<E>> coll, Collection<? extends EntityReference<E>> values, boolean includes) {
        if (coll == null) {
            return !includes;
        }
        for (EntityReference<E> item : values) {
            if (!coll.contains(item)) continue;
            return includes;
        }
        return !includes;
    }

    public static <E extends BaseEntity> boolean matchesEntityRestriction(Collection<? extends EntityReference<E>> coll, EntityReference<E> value, boolean includes) {
        if (coll == null || null == value) {
            return !includes;
        }
        if (coll.contains(value)) {
            return includes;
        }
        return !includes;
    }

    public static boolean matchesStringRestriction(String property, Object value, boolean equals) {
        List<String> values = RulesHelper.toStringCollection(value);
        if (!(values instanceof RandomAccess)) {
            IncidentsLog.reportStackTrace((String)"List and not RandomAccess");
        }
        for (int i = 0; i < values.size(); ++i) {
            String item = values.get(i);
            if (!item.equals(property)) continue;
            return equals;
        }
        return !equals;
    }

    public static boolean matchesEntityRestriction(String property, List<Object> values, boolean equals) {
        if (!(values instanceof RandomAccess)) {
            IncidentsLog.reportStackTrace((String)"List and not RandomAccess");
        }
        for (int i = 0; i < values.size(); ++i) {
            Object item = values.get(i);
            if (!(item instanceof EntityReference ? ((EntityReference)item).getUid().equals(property) : item.equals(property))) continue;
            return equals;
        }
        return !equals;
    }

    public static boolean matchesStringStartsWithRestriction(Collection<String> expectedValues, Object value, boolean equals) {
        for (String expected : expectedValues) {
            for (String item : RulesHelper.toStringCollection(value)) {
                if (expected == null || !expected.startsWith(item)) continue;
                return equals;
            }
        }
        return !equals;
    }

    public static boolean matchesStringStartsWithRestriction(String property, Object value, boolean equals) {
        for (String item : RulesHelper.toStringCollection(value)) {
            if (property == null || !property.startsWith(item)) continue;
            return equals;
        }
        return !equals;
    }

    public static boolean matchesStringEndsWithRestriction(Collection<String> expectedValues, Object value, boolean equals) {
        for (String expected : expectedValues) {
            for (String item : RulesHelper.toStringCollection(value)) {
                if (expected == null || !expected.endsWith(item)) continue;
                return equals;
            }
        }
        return !equals;
    }

    public static boolean matchesStringEndsWithRestriction(String property, Object value, boolean equals) {
        for (String item : RulesHelper.toStringCollection(value)) {
            if (property == null || !property.endsWith(item)) continue;
            return equals;
        }
        return !equals;
    }

    public static boolean matchesStringContainsRestriction(Collection<String> expectedValues, Object value, boolean equals) {
        for (String expected : expectedValues) {
            for (String item : RulesHelper.toStringCollection(value)) {
                if (expected == null || !expected.contains(item)) continue;
                return equals;
            }
        }
        return !equals;
    }

    public static boolean matchesStringContainsRestriction(String property, Object value, boolean equals) {
        for (String item : RulesHelper.toStringCollection(value)) {
            if (property == null || !property.contains(item)) continue;
            return equals;
        }
        return !equals;
    }

    public static boolean matchesTimeIntervalRestriction(Date propDate, Object value, RuleCondition condition) {
        DateInterval dateInterval = (DateInterval)value;
        if (dateInterval == null || dateInterval.getBeginDate() == null && dateInterval.getEndDate() == null) {
            return true;
        }
        if (propDate != null) {
            if (Conditions.PERIOD_WITHIN.equals(condition)) {
                int time = MiscUtil.getTime((Date)propDate);
                int beginTime = MiscUtil.getTime((Date)dateInterval.getBeginDate());
                int endTime = MiscUtil.getTime((Date)dateInterval.getEndDate());
                if (dateInterval.getBeginDate() == null) {
                    return time <= endTime;
                }
                if (dateInterval.getEndDate() == null) {
                    return time >= beginTime;
                }
                if (beginTime > endTime) {
                    return time >= beginTime || time <= endTime;
                }
                return time >= beginTime && time <= endTime;
            }
            if (Conditions.PERIOD_BEYOND.equals(condition)) {
                int time = MiscUtil.getTime((Date)propDate);
                int beginTime = MiscUtil.getTime((Date)dateInterval.getBeginDate());
                int endTime = MiscUtil.getTime((Date)dateInterval.getEndDate());
                if (dateInterval.getBeginDate() == null) {
                    return time > endTime;
                }
                if (dateInterval.getEndDate() == null) {
                    return time < beginTime;
                }
                if (beginTime > endTime) {
                    return time < beginTime && time > endTime;
                }
                return time < beginTime || time > endTime;
            }
        }
        return true;
    }

    public static List<String> toStringCollection(Object obj) {
        if (obj == null) {
            return Collections.emptyList();
        }
        if (obj instanceof Iterable) {
            return (List)obj;
        }
        String str = (String)obj;
        if (TextUtil.isBlank((String)str)) {
            return Collections.emptyList();
        }
        StringTokenizer st = new StringTokenizer(str, ",;", false);
        ArrayList<String> lst = new ArrayList<String>(st.countTokens());
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (TextUtil.isBlank((String)token)) continue;
            lst.add(token.trim());
        }
        return lst;
    }

    public static boolean matchesPattern(String str, String p) {
        String str1;
        String p1;
        if (p.indexOf(63) == 0) {
            if (p.indexOf(63) == p.length() - 1) {
                p1 = p.substring(1, p.length() - 1);
                str1 = str.substring(1, str.length() - 1);
            } else {
                p1 = p.substring(1);
                str1 = str.substring(1);
            }
        } else if (p.indexOf(63) == p.length() - 1) {
            p1 = p.substring(0, p.length() - 1);
            str1 = str.substring(0, str.length() - 1);
        } else {
            p1 = p;
            str1 = str;
        }
        if (p1.indexOf(63) < 0) {
            if (RulesHelper.isEqualsPattern(p1)) {
                return str1.equals(p1);
            }
            if (RulesHelper.isIncludePattern(p1)) {
                return str1.contains(p1.substring(1, p1.length() - 1));
            }
            if (RulesHelper.isBeginsWithPattern(p1)) {
                return str1.startsWith(p1.substring(0, p1.length() - 1));
            }
            if (RulesHelper.isEndsWithPattern(p1)) {
                return str1.endsWith(p1.substring(1));
            }
        }
        return str.matches(RulesHelper.toRegexPattern(p));
    }

    public static boolean isEqualsPattern(String s) {
        return s.indexOf(42) < 0;
    }

    public static boolean isIncludePattern(String s) {
        return s.indexOf(42) == 0 && s.indexOf(42, 1) == s.length() - 1;
    }

    public static boolean isBeginsWithPattern(String s) {
        return s.indexOf(42) == s.length() - 1;
    }

    public static boolean isEndsWithPattern(String s) {
        return s.indexOf(42) == 0 && s.indexOf(42, 1) < 0;
    }

    public static String toRegexPattern(String value) {
        int j;
        int nAsterisk = 0;
        int nQuestion = 0;
        block8: for (j = 0; j < value.length(); ++j) {
            switch (value.charAt(j)) {
                case '?': {
                    ++nQuestion;
                    continue block8;
                }
                case '*': {
                    ++nAsterisk;
                }
            }
        }
        if (nAsterisk == 0) {
            if (nQuestion > 0) {
                value = value.replace('?', '.');
            }
        } else {
            char[] newValue = new char[value.length() + nAsterisk];
            int k = 0;
            block9: for (j = 0; j < value.length(); ++j) {
                char c = value.charAt(j);
                switch (value.charAt(j)) {
                    case '?': {
                        newValue[k++] = 46;
                        continue block9;
                    }
                    case '*': {
                        newValue[k++] = 46;
                        newValue[k++] = 42;
                        continue block9;
                    }
                    default: {
                        newValue[k++] = c;
                    }
                }
            }
            value = new String(newValue);
        }
        return value;
    }

    public static List<MiscUtil.Pair<String, String>> toRangeCollection(Object object) {
        if (object == null) {
            return Collections.emptyList();
        }
        ArrayList<String> entries = new ArrayList<String>();
        if (object instanceof Iterable) {
            entries.addAll((List)object);
        } else {
            entries.addAll(Arrays.asList(((String)object).trim().split("[,;]")));
        }
        ArrayList<MiscUtil.Pair<String, String>> ranges = new ArrayList<MiscUtil.Pair<String, String>>();
        for (String entry : entries) {
            String[] limits = entry.trim().split("-");
            if (limits.length != 2) continue;
            String start = limits[0].trim();
            String end = limits[1].trim();
            if (TextUtil.isBlank((String)start) || !TextUtil.isContainsDigits((String)start) || TextUtil.isBlank((String)end) || !TextUtil.isContainsDigits((String)end)) continue;
            MiscUtil.Pair pair = new MiscUtil.Pair((Object)start, (Object)end);
            ranges.add((MiscUtil.Pair<String, String>)pair);
        }
        return ranges;
    }

    public static Function<String, String> toStringFunctionReference(Class<? extends BaseEntity> baseEntityCls, Class<?> logCls) {
        return uid -> {
            try {
                return EntityStorage.get().load(baseEntityCls, uid).toReference().toString();
            }
            catch (Exception e) {
                LoggerFactory.getLogger((Class)logCls).error("unable to resolve reference", (Throwable)e);
                return null;
            }
        };
    }

    public static String toString(Collection<String> strings, Function<String, String> toStringFunction) {
        Objects.requireNonNull(toStringFunction);
        if (CollectionUtil.isEmpty(strings)) {
            return "";
        }
        return strings.stream().map(toStringFunction).map(s -> Objects.isNull(s) ? "???" : s).collect(Collectors.joining(", "));
    }

    public static String toString(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Number) {
            return LocaleManager.get().getCurrentLocaleData().getNumberFormat().format(((Number)object).doubleValue());
        }
        if (object instanceof RateMoney) {
            RateMoney rm = (RateMoney)object;
            Money money = rm.getMoney();
            if (money == null) {
                Double rate = rm.getRate();
                if (rate == null) {
                    return "";
                }
                return LocaleManager.get().getCurrentLocaleData().getNumberFormat().format(rate) + " %";
            }
            BigDecimal amount = money.getValue();
            String currency = money.getCurrency();
            String ammountStr = amount != null ? LocaleManager.get().getCurrentLocaleData().getPriceFormat().format(amount.doubleValue()) : null;
            CurrencyInfo curInfo = currency != null ? (CurrencyInfo)DictionaryCache.get().findByCode(CurrencyInfo.class, currency) : null;
            return ammountStr == null || curInfo == null ? null : ammountStr + " " + curInfo.toString();
        }
        if (object instanceof Iterable) {
            Iterable coll = (Iterable)object;
            StringBuilder sb = new StringBuilder();
            for (Object obj : coll) {
                if (obj == null) continue;
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(obj);
            }
            return sb.toString();
        }
        return object != null ? object.toString() : null;
    }

    @Deprecated
    public static String buildDateIntervalInfo(RuleCondition cond, Object value) {
        return RulesHelper.buildTimesInfo(cond, value);
    }

    public static String buildDatesInfo(RuleCondition cond, Object value) {
        DateFormat dateFormat = RulesEnvironment.getDateFormat();
        return RulesHelper.buildDateTimeIntervalInfo(dateFormat, cond, value);
    }

    public static String buildTimesInfo(RuleCondition cond, Object value) {
        DateFormat timeFormat = RulesEnvironment.getTimeFormat();
        return RulesHelper.buildDateTimeIntervalInfo(timeFormat, cond, value);
    }

    private static String buildDateTimeIntervalInfo(DateFormat dateFormat, RuleCondition cond, Object value) {
        StringBuilder sb = new StringBuilder();
        DateInterval dateInterval = (DateInterval)value;
        if (dateInterval == null || dateInterval.getBeginDate() == null && dateInterval.getEndDate() == null) {
            return sb.toString();
        }
        if (Conditions.PERIOD_WITHIN.getId().equals(cond.getId())) {
            if (dateInterval.getBeginDate() == null) {
                sb.append(L10n.replace((String)"\u0434\u043e {0}", (Object[])new Object[]{dateFormat.format(dateInterval.getEndDate())}));
            } else if (dateInterval.getEndDate() == null) {
                sb.append(L10n.replace((String)"\u043f\u043e\u0441\u043b\u0435 {0}", (Object[])new Object[]{dateFormat.format(dateInterval.getBeginDate())}));
            } else {
                sb.append(L10n.replace((String)"\u0432 \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b\u0435 \u0441 {0} \u0434\u043e {1}", (Object[])new Object[]{dateFormat.format(dateInterval.getBeginDate()), dateFormat.format(dateInterval.getEndDate())}));
            }
        } else if (Conditions.PERIOD_BEYOND.getId().equals(cond.getId())) {
            if (dateInterval.getBeginDate() == null) {
                sb.append(L10n.replace((String)"\u043f\u043e\u0441\u043b\u0435 {0}", (Object[])new Object[]{dateFormat.format(dateInterval.getEndDate())}));
            } else if (dateInterval.getEndDate() == null) {
                sb.append(L10n.replace((String)"\u0434\u043e {0}", (Object[])new Object[]{dateFormat.format(dateInterval.getBeginDate())}));
            } else {
                sb.append(L10n.replace((String)"\u0432\u043d\u0435 \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b\u0430 \u0441 {0} \u043f\u043e {1}", (Object[])new Object[]{dateFormat.format(dateInterval.getBeginDate()), dateFormat.format(dateInterval.getEndDate())}));
            }
        }
        return sb.toString();
    }

    public static String getRuleCategoryValue(CachedRulesCategoriesProvider action, RuleResultValue value) {
        if (value == null) {
            return "";
        }
        return RulesHelper.getRuleCategoryValue(action, value.getTarget());
    }

    public static String getRuleCategoryValue(CachedRulesCategoriesProvider action, ServiceClassCommissionsRuleResultValue value) {
        if (value == null) {
            return "";
        }
        return RulesHelper.getRuleCategoryValue(action, value.getTarget());
    }

    public static String getRuleCategoryValue(CachedRulesCategoriesProvider action, EntityReference<? extends BaseCommissionProperties> target) {
        if (target == null) {
            return "";
        }
        Map<EntityReference<? extends BaseCommissionProperties>, String> cached = action.getCachedCategories();
        if (cached.containsKey(target)) {
            return cached.get(target);
        }
        try {
            EntityContainer ctr = EntityStorage.get().resolve(target);
            if (ctr != null) {
                BaseCommissionProperties prop = (BaseCommissionProperties)ctr.getEntity();
                String className = target.getType().getName();
                if (prop instanceof CommissionProperties) {
                    CommissionProperties cp = (CommissionProperties)prop;
                    String res = TextUtil.concatWithDelimeter((String)"|", (String[])new String[]{className, cp.getCategory() != null ? cp.getCategory().getCode() : "null", Boolean.toString(cp.isMinimum()), Boolean.toString(cp.isBonus()), Boolean.toString(cp.isBspCommission())});
                    cached.put(target, res);
                    return res;
                }
                if (prop instanceof DiscountProperties) {
                    DiscountProperties dp = (DiscountProperties)prop;
                    String res = TextUtil.concatWithDelimeter((String)"|", (String[])new String[]{className, dp.getCategory() != null ? dp.getCategory().getCode() : "null", Objects.toString(dp.getType())});
                    cached.put(target, res);
                    return res;
                }
                if (prop instanceof PaymentFeeProperties) {
                    PaymentFeeProperties dp = (PaymentFeeProperties)prop;
                    String res = TextUtil.concatWithDelimeter((String)"|", (String[])new String[]{className, dp.getPaymentType() != null ? dp.getPaymentType().name() : "null", dp.getType() != null ? dp.getType().name() : "null"});
                    cached.put(target, res);
                    return res;
                }
                FeeProperties fp = (FeeProperties)prop;
                String res = TextUtil.concatWithDelimeter((String)"|", (String[])new String[]{className, fp.getCategory() != null ? fp.getCategory().getCode() : "null", Objects.toString(fp.getType())});
                cached.put(target, res);
                return res;
            }
        }
        catch (Exception e) {
            log.error("unable to generate rule category", (Throwable)e);
        }
        log.warn("unable to generate rule category for : {}", target);
        return "";
    }

    public static String getRuleCategoryValueForActionSet(EntityReference<? extends BaseCommissionProperties> target) {
        if (target == null) {
            return "";
        }
        EntityContainer ctr = EntityStorage.get().resolve(target);
        if (ctr == null) {
            return "";
        }
        BaseCommissionProperties prop = (BaseCommissionProperties)ctr.getEntity();
        String className = target.getType().getName();
        if (prop instanceof CommissionProperties) {
            CommissionProperties cp = (CommissionProperties)prop;
            String res = String.join((CharSequence)"|", className, cp.getCategory() != null ? cp.getCategory().getCode() : "null", Boolean.toString(cp.isBonus()), Boolean.toString(cp.isBspCommission()));
            return res;
        }
        if (prop instanceof DiscountProperties) {
            DiscountProperties dp = (DiscountProperties)prop;
            String res = String.join((CharSequence)"|", className, dp.getCategory() != null ? dp.getCategory().getCode() : "null");
            return res;
        }
        if (prop instanceof PaymentFeeProperties) {
            PaymentFeeProperties dp = (PaymentFeeProperties)prop;
            String res = String.join((CharSequence)"|", className, dp.getPaymentType() != null ? dp.getPaymentType().name() : "null", dp.getType() == null ? "" : dp.getType().name());
            return res;
        }
        FeeProperties fp = (FeeProperties)prop;
        String res = String.join((CharSequence)"|", className, fp.getCategory() != null ? fp.getCategory().getCode() : "null");
        return res;
    }

    public static void apply(RuleProxy<?, ?> proxy, RuleResultValue value) throws Exception {
        BasicCommissionActionsProvider action = (BasicCommissionActionsProvider)proxy.getActionSet();
        if (value == null || value.getTarget() == null) {
            log.warn("rule result value is null or target is undefined");
            return;
        }
        String category = RulesHelper.getRuleCategoryValue((CachedRulesCategoriesProvider)action, value);
        if (!action.accept(category, value.getTarget())) {
            return;
        }
        if (value.getFopValues() != null) {
            Double[][] doubleValues = (Double[][])value.getFopValues()[0];
            String[][] codes = (String[][])value.getFopValues()[1];
            RuleResultValue.FOPCommissionType[][] types = value.getFopValues().length == 3 ? value.getFopValues()[2] : (RuleResultValue.FOPCommissionType[][])null;
            for (int m = 0; m < targetTypes.length; ++m) {
                for (Integer number : numbers) {
                    boolean forceSegmentCalculation;
                    String code;
                    Double doubleValue = doubleValues[number][m];
                    if (doubleValue == null || (code = codes[number][m]) == null) continue;
                    boolean bl = forceSegmentCalculation = types != null && types[number][m] == RuleResultValue.FOPCommissionType.PER_SEGMENT;
                    if (!((CommissionActionsProvider)action).setCommission(category, value.getTarget(), doubleValue, code, targetTypes[m], forceSegmentCalculation, paymentTypes[number])) continue;
                    proxy.getAppliedRuleCategories().add(category);
                    return;
                }
            }
            return;
        }
        action.setCommission(category, value);
        proxy.getAppliedRuleCategories().add(category);
    }

    static void apply(RuleProxy<?, ?> proxy, ServiceClassCommissionsRuleResultValue ruleResultValue) {
        if (ruleResultValue == null || ruleResultValue.getTarget() == null || ruleResultValue.getCommissionType() == null) {
            log.warn("rule result value is null or either target is undefined or type is undefined");
            return;
        }
        BasicCommissionActionsProvider action = (BasicCommissionActionsProvider)proxy.getActionSet();
        String category = RulesHelper.getRuleCategoryValue((CachedRulesCategoriesProvider)action, ruleResultValue);
        AirTicketPropertiesProvider propertySet = (AirTicketPropertiesProvider)proxy.getPropertySet();
        HashSet<String> classCodes = new HashSet<String>();
        ArrayList<BigDecimal> values = new ArrayList<BigDecimal>();
        block5: for (ServiceClassCommissionsRuleResultValue.ServiceClassCommissionValue commissionValue : ruleResultValue.getValues()) {
            String[] serviceClassCodes;
            if (TextUtil.isBlank((String)commissionValue.getServiceClassCodes()) || commissionValue.getValue() == null) continue;
            for (String serviceClassCode : serviceClassCodes = commissionValue.getServiceClassCodes().split("\\s*[,;]\\s*")) {
                if (classCodes.contains(serviceClassCode) || !propertySet.getBookingClasses().contains(serviceClassCode)) continue;
                classCodes.addAll(Arrays.asList(serviceClassCodes));
                values.add(commissionValue.getValue());
                continue block5;
            }
        }
        BigDecimal value = null;
        switch (ruleResultValue.getCommissionType()) {
            case MINIMUM: {
                value = MiscUtil.minimum((BigDecimal[])values.toArray(new BigDecimal[values.size()]));
                break;
            }
            case MAXIMUM: {
                value = MiscUtil.maximum((BigDecimal[])values.toArray(new BigDecimal[values.size()]));
                break;
            }
            case AVERAGE: {
                value = MiscUtil.average((int)2, (BigDecimal[])values.toArray(new BigDecimal[values.size()]));
                break;
            }
        }
        RuleResultValue rrv = new RuleResultValue();
        rrv.setTarget(ruleResultValue.getTarget());
        rrv.setCurrencyCode(ruleResultValue.getCurrencyCode());
        rrv.setValue(value != null ? value.doubleValue() : 0.0);
        action.setCommission(category, rrv);
        proxy.getAppliedRuleCategories().add(category);
    }

    public static Set<String> collectGeoCodes(DictionaryReference<GeoLocation> locRef, boolean includeAirport, boolean includeCountry, boolean ignoreCountryRegionsCodes) {
        if (locRef == null) {
            return Collections.emptySet();
        }
        GeoLocation loc = (GeoLocation)DictionaryCache.get().resolveReference(locRef);
        if (loc == null) {
            return Collections.singleton(locRef.getCode());
        }
        HashSet<String> codes = new HashSet<String>();
        HashSet<GeoLocation> seen = new HashSet<GeoLocation>();
        RulesHelper.collectGeoCodesInternal(codes, loc, includeAirport, seen);
        for (GeoLocation location : seen) {
            for (int i = 0; i < location.getRegions().size(); ++i) {
                DictionaryReference regRef = (DictionaryReference)location.getRegions().get(0);
                GeoRegion geoRegion = (GeoRegion)DictionaryCache.get().findByCode(GeoRegion.class, regRef.getCode());
                if (geoRegion == null) continue;
                codes.addAll(geoRegion.getCodeVariants().values().stream().filter(val -> !TextUtil.isBlank((String)val)).collect(Collectors.toSet()));
            }
        }
        Country country = (Country)DictionaryCache.get().resolveReference(loc.getCountry());
        if (includeCountry && country != null) {
            if (ignoreCountryRegionsCodes) {
                codes.addAll(country.getCodeVariants().values().stream().filter(TextUtil::nonBlank).collect(Collectors.toSet()));
            } else {
                codes.addAll(RulesHelper.collectCountryCodes(country));
            }
        }
        return codes;
    }

    public static Set<String> collectGeoCodes(DictionaryReference<GeoLocation> locRef, boolean includeAirport, boolean includeCountry) {
        return RulesHelper.collectGeoCodes(locRef, includeAirport, includeCountry, false);
    }

    private static void collectGeoCodesInternal(Set<String> codes, GeoLocation loc, boolean includeAirport, Set<GeoLocation> seen) {
        GeoLocation parent;
        if (seen.contains(loc)) {
            return;
        }
        seen.add(loc);
        if (loc.getType() != LocationType.AIRPORT || includeAirport) {
            codes.addAll(loc.getCodeVariants().values());
        }
        if (loc.getParent() != null && (parent = (GeoLocation)DictionaryCache.get().resolveReference(loc.getParent())) != null) {
            RulesHelper.collectGeoCodesInternal(codes, parent, includeAirport, seen);
        }
    }

    public static Set<String> collectGeoCodes(Set<String> codes, boolean includeCountry, boolean ignoreCountryRegionsCodes) {
        if (codes.isEmpty()) {
            return Collections.emptySet();
        }
        Set locations = codes.stream().filter(code -> !TextUtil.isBlank((String)code)).map(code -> DictHelper.getDictionaryItemsByCode(GeoLocation.class, code)).flatMap(s -> s.stream()).collect(Collectors.toSet());
        if (locations.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        DictionaryCache dictCache = DictionaryCache.get();
        for (Object loc : locations) {
            result.addAll(loc.getCodeVariants().values());
            for (int i = 0; i < loc.getRegions().size(); ++i) {
                DictionaryReference regRef = (DictionaryReference)loc.getRegions().get(i);
                GeoRegion geoRegion = (GeoRegion)DictionaryCache.get().findByCode(GeoRegion.class, regRef.getCode());
                if (geoRegion == null) continue;
                result.addAll(geoRegion.getCodeVariants().values().stream().filter(v -> !TextUtil.isBlank((String)v)).collect(Collectors.toSet()));
            }
            Country country = (Country)dictCache.resolveReference(loc.getCountry());
            if (!includeCountry || country == null) continue;
            if (ignoreCountryRegionsCodes) {
                result.addAll(country.getCodeVariants().values().stream().filter(TextUtil::nonBlank).collect(Collectors.toSet()));
                continue;
            }
            result.addAll(RulesHelper.collectCountryCodes(country));
        }
        if (codes.containsAll(result)) {
            return new HashSet<String>(codes);
        }
        HashSet parents = new HashSet();
        for (GeoLocation loc : locations) {
            GeoLocation parent = (GeoLocation)dictCache.resolveReference(loc.getParent());
            if (parent == null) continue;
            result.addAll(parent.getCodeVariants().values());
        }
        if (result.containsAll(parents)) {
            return result;
        }
        HashSet<String> diffCodes = new HashSet<String>(parents);
        diffCodes.removeAll(result);
        result.addAll(RulesHelper.collectGeoCodes(diffCodes, false));
        return result;
    }

    public static Set<String> collectGeoCodes(Set<String> codes, boolean includeCountry) {
        return RulesHelper.collectGeoCodes(codes, includeCountry, false);
    }

    public static Set<String> collectCountryCodes(Country country) {
        HashSet<String> result = new HashSet<String>();
        if (country == null) {
            return result;
        }
        DictionaryCache dictCache = DictionaryCache.get();
        for (Map.Entry entry : country.getCodeVariants().entrySet()) {
            if (TextUtil.isBlank((String)((String)entry.getValue()))) continue;
            result.add((String)entry.getValue());
        }
        for (DictionaryReference regRef : country.getRegions()) {
            GeoRegion geoRegion = (GeoRegion)dictCache.findByCode(GeoRegion.class, regRef.getCode());
            if (geoRegion == null) continue;
            for (Map.Entry entry : geoRegion.getCodeVariants().entrySet()) {
                if (TextUtil.isBlank((String)((String)entry.getValue()))) continue;
                result.add((String)entry.getValue());
            }
        }
        return result;
    }

    public static <D extends BaseDictionary> Set<String> codes(Collection<? extends DictionaryReference<D>> refs) {
        HashSet<String> result = new HashSet<String>();
        for (DictionaryReference<D> ref : refs) {
            result.add(ref.getCode());
        }
        return result;
    }

    public static BigDecimal roundDouble(BigDecimal val, RoundingMode roundingMode, RoundingValue roundingValue) {
        return MulticurrencyHelper.roundDouble(val, roundingMode, roundingValue);
    }

    public static boolean collectionContains(List<String[]> visitedCities, List<String> data, boolean include) {
        if (data.isEmpty()) {
            return visitedCities.isEmpty();
        }
        for (int i = 0; i < data.size(); ++i) {
            String location = data.get(i);
            if (TextUtil.isBlank((String)location)) continue;
            boolean negative = location.startsWith(NEGATIVE_PREFIX);
            if (negative) {
                location = location.substring(1);
            }
            boolean found = false;
            block1: for (int j = 0; j < visitedCities.size(); ++j) {
                String[] locs = visitedCities.get(j);
                if (locs == null || locs.length == 0) continue;
                for (String loc : locs) {
                    if (!location.equals(loc)) continue;
                    if (negative) continue block1;
                    found = true;
                    break block1;
                }
                if (!negative) continue;
                found = true;
                break;
            }
            if (include && found) {
                return true;
            }
            if (include || !found) continue;
            return false;
        }
        return !include;
    }

    public static boolean confinedTo(List<String[]> visitedCities, List<String> data) {
        return RulesHelper.containsOnly(visitedCities, data, false);
    }

    public static boolean containsOnly(Set<String> values, List<String> acceptableValuePatterns) {
        if (acceptableValuePatterns.isEmpty()) {
            return values.isEmpty();
        }
        if (values.isEmpty()) {
            return false;
        }
        ArrayList<String[]> acceptableValueLists = new ArrayList<String[]>(acceptableValuePatterns.size());
        if (!(acceptableValuePatterns instanceof RandomAccess)) {
            IncidentsLog.reportStackTrace((String)"List and not RandomAccess");
        }
        for (int i = 0; i < acceptableValuePatterns.size(); ++i) {
            String acceptableValuePattern = acceptableValuePatterns.get(i);
            acceptableValueLists.add(acceptableValuePattern.split("-"));
        }
        boolean allValuesConformToPatterns = true;
        Iterator<String> iterator = values.iterator();
        while (iterator.hasNext() && allValuesConformToPatterns) {
            if (RulesHelper.matchingConfinementPatternFound(iterator.next(), acceptableValueLists)) continue;
            allValuesConformToPatterns = false;
        }
        return allValuesConformToPatterns;
    }

    public static List<String> getCorrectedValues(List<String> values) {
        for (String item : values) {
            if (item == null || !item.contains("-")) continue;
            return values;
        }
        StringBuilder sb = new StringBuilder();
        for (String item : values) {
            if (TextUtil.isBlank((String)item)) continue;
            if (sb.length() > 0) {
                sb.append("-");
            }
            sb.append(item);
        }
        return Collections.singletonList(sb.toString());
    }

    private static boolean matchingConfinementPatternFound(String value, List<String[]> acceptableValueLists) {
        boolean matchingPatternFound = false;
        for (int i = 0; i < acceptableValueLists.size() && !matchingPatternFound; ++i) {
            if (!ArrayUtils.contains((Object[])acceptableValueLists.get(i), (Object)value)) continue;
            matchingPatternFound = true;
        }
        return matchingPatternFound;
    }

    public static boolean collectionIncludes(Collection<String> codes, List<String> locations) {
        if (locations.isEmpty() || codes == null || codes.isEmpty()) {
            return false;
        }
        for (String loc : locations) {
            if (TextUtil.isBlank((String)loc) || !RulesHelper.collectionContains(codes, loc)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsSegment(List<List<String[]>> flightSegments, List<String> data) {
        for (List<String[]> segment : flightSegments) {
            if (!RulesHelper.containsOnly(segment, data)) continue;
            return true;
        }
        return false;
    }

    public static boolean includesOnly(Collection<String> coll, List<String> data) {
        ArrayList<String> items = new ArrayList<String>();
        for (String item : coll) {
            if (TextUtil.isBlank((String)item)) continue;
            items.add(item.trim());
        }
        ArrayList<String[]> res = new ArrayList<String[]>();
        for (String item : items) {
            res.add(new String[]{item});
        }
        return RulesHelper.containsOnly(res, data);
    }

    public static boolean containsOnly(List<String[]> visitedCities, List<String> data) {
        return RulesHelper.containsOnly(visitedCities, data, true);
    }

    public static boolean containsOnly(List<String[]> visitedCities, List<String> data, boolean strict) {
        if (data.isEmpty()) {
            return visitedCities.isEmpty();
        }
        if (visitedCities.isEmpty()) {
            return false;
        }
        if (!(data instanceof RandomAccess)) {
            IncidentsLog.reportStackTrace((String)"List and not RandomAccess");
        }
        block0: for (int i = 0; i < data.size(); ++i) {
            int j;
            String pattern = data.get(i);
            if (TextUtil.isBlank((String)pattern)) continue;
            if (!(visitedCities instanceof RandomAccess)) {
                IncidentsLog.reportStackTrace((String)"List and not RandomAccess");
            }
            for (j = 0; j < visitedCities.size(); ++j) {
                String[] codes = visitedCities.get(j);
                boolean found = false;
                StringTokenizer st = new StringTokenizer(pattern, "-");
                while (st.hasMoreTokens()) {
                    String location = st.nextToken();
                    if (codes == null || codes.length == 0 || !RulesHelper.collectionContains(codes, location)) continue;
                    found = true;
                    break;
                }
                if (!found) continue block0;
            }
            if (!strict) {
                return true;
            }
            StringTokenizer st = new StringTokenizer(pattern, "-");
            while (st.hasMoreTokens()) {
                String location = st.nextToken();
                boolean found = false;
                for (j = 0; j < visitedCities.size(); ++j) {
                    String[] codes = visitedCities.get(j);
                    if (codes == null || codes.length == 0 || !RulesHelper.collectionContains(codes, location)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                continue block0;
            }
            return true;
        }
        return false;
    }

    private static boolean collectionContains(String[] codes, String location) {
        if (TextUtil.isBlank((String)location) || codes == null || codes.length == 0) {
            return false;
        }
        if (location.indexOf(38) < 0) {
            return RulesHelper.internalCollectionContains(codes, location);
        }
        StringTokenizer st = new StringTokenizer(location.trim(), "&");
        while (st.hasMoreTokens()) {
            String pattern = st.nextToken();
            if (TextUtil.isBlank((String)pattern) || RulesHelper.internalCollectionContains(codes, pattern)) continue;
            return false;
        }
        return true;
    }

    private static boolean collectionContains(Collection<String> codes, String location) {
        if (TextUtil.isBlank((String)location) || codes == null || codes.isEmpty()) {
            return false;
        }
        if (location.indexOf(38) < 0) {
            return RulesHelper.internalCollectionContains(codes, location);
        }
        StringTokenizer st = new StringTokenizer(location.trim(), "&");
        while (st.hasMoreTokens()) {
            String pattern = st.nextToken();
            if (TextUtil.isBlank((String)pattern) || RulesHelper.internalCollectionContains(codes, pattern)) continue;
            return false;
        }
        return true;
    }

    private static boolean internalCollectionContains(String[] codes, String pattern) {
        boolean negative = pattern.contains(NEGATIVE_PREFIX);
        if (negative) {
            pattern = pattern.substring(NEGATIVE_PREFIX.length());
        }
        boolean found = false;
        for (String code : codes) {
            if (!pattern.equalsIgnoreCase(code)) continue;
            found = true;
            break;
        }
        if (negative && found) {
            return false;
        }
        return negative || found;
    }

    private static boolean internalCollectionContains(Collection<String> codes, String pattern) {
        boolean negative = pattern.contains(NEGATIVE_PREFIX);
        if (negative) {
            pattern = pattern.substring(NEGATIVE_PREFIX.length());
        }
        boolean found = false;
        if (codes instanceof List) {
            if (!(codes instanceof RandomAccess)) {
                IncidentsLog.reportStackTrace((String)"List and not RandomAccess");
            }
            List codesList = (List)codes;
            for (int i = 0; i < codesList.size(); ++i) {
                String code = (String)codesList.get(i);
                if (!pattern.equalsIgnoreCase(code)) continue;
                found = true;
                break;
            }
        } else {
            for (String code : codes) {
                if (!pattern.equalsIgnoreCase(code)) continue;
                found = true;
                break;
            }
        }
        if (negative && found) {
            return false;
        }
        return negative || found;
    }

    public static List<String[]> to2DList(Collection<String> coll) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        for (String item : coll) {
            if (TextUtil.isBlank((String)item)) continue;
            result.add(new String[]{item.trim()});
        }
        return result;
    }

    static Object[] tchCommissionStr2Value(String str) {
        int m;
        int n;
        int strIndex;
        if (TextUtil.isBlank((String)str)) {
            return null;
        }
        Double[][] values = new Double[paymentTypes.length][targetTypes.length];
        int i = 0;
        int curIndex = 0;
        int doubleCommaIndex = str.indexOf(";;");
        while (curIndex < doubleCommaIndex) {
            if (curIndex != 0) {
                ++curIndex;
            }
            strIndex = str.indexOf(";", curIndex);
            String valueStr = str.substring(curIndex, strIndex);
            curIndex = strIndex;
            n = i / targetTypes.length;
            m = i % targetTypes.length;
            if (valueStr.indexOf(32) != -1) {
                valueStr = valueStr.trim();
            }
            values[n][m] = "null".equals(valueStr) ? null : Double.valueOf(valueStr);
            ++i;
        }
        curIndex = doubleCommaIndex + 2;
        int newDoubleCommaIndex = str.indexOf(";;", curIndex);
        String[][] codes = new String[paymentTypes.length][targetTypes.length];
        i = 0;
        int newStartIndex = curIndex;
        while (curIndex < newDoubleCommaIndex) {
            if (curIndex != newStartIndex) {
                ++curIndex;
            }
            strIndex = str.indexOf(";", curIndex);
            String valueStr = str.substring(curIndex, strIndex);
            curIndex = strIndex;
            n = i / targetTypes.length;
            m = i % targetTypes.length;
            if (valueStr.indexOf(32) != -1) {
                valueStr = valueStr.trim();
            }
            codes[n][m] = "null".equals(valueStr) ? null : valueStr;
            ++i;
        }
        return new Object[]{values, codes};
    }

    static String tchCommissionValue2Str(Object value) {
        int m;
        int n;
        if (value == null) {
            return null;
        }
        Object[] values = (Object[])value;
        Double[][] doubleValues = (Double[][])values[0];
        String[][] codes = (String[][])values[1];
        Object types = values.length == 3 ? values[2] : (RuleResultValue.FOPCommissionType[][])null;
        StringBuilder buf = new StringBuilder();
        for (n = 0; n < paymentTypes.length; ++n) {
            for (m = 0; m < targetTypes.length; ++m) {
                Double doubleValue = doubleValues[n][m];
                buf.append(doubleValue == null ? "null" : doubleValue.toString()).append(";");
            }
        }
        buf.append(";");
        for (n = 0; n < paymentTypes.length; ++n) {
            for (m = 0; m < targetTypes.length; ++m) {
                String valueStr = codes[n][m];
                buf.append(valueStr == null ? "null" : valueStr).append(";");
            }
        }
        buf.append(";");
        if (paymentTypes.length == 0 || targetTypes.length == 0) {
            buf.append(";");
        }
        return buf.toString();
    }

    public static boolean isTransatlanticFlight(Product prod) {
        return TransatlaticRouteHelper.isTransatlanticFlight(prod);
    }

    public static boolean isTransatlanticFlight(DictionaryReference<GeoLocation> depLoc, DictionaryReference<GeoLocation> arrLoc, Date startDate, Date endDate, Integer durationOfFlightInMinutes) {
        return TransatlaticRouteHelper.isTransatlanticSegment(depLoc, arrLoc, startDate, endDate, durationOfFlightInMinutes);
    }

    public static BigDecimal convert(BigDecimal equivalentAmount, ExchangeRateData data) {
        return MulticurrencyHelper.convert(equivalentAmount, data);
    }

    public static ExchangeRateData getExchangeRateData(List<EntityContainer<Contract>> contractContainers, EntityReference<Organization> org, Date operationDate, EntityReference<Organization> supplier, String originalCurrency, boolean air) {
        return RulesHelper.getExchangeRateData(contractContainers, org, operationDate, supplier, originalCurrency, air, null, null);
    }

    public static ExchangeRateData getExchangeRateData(List<EntityContainer<Contract>> contractContainers, EntityReference<Organization> org, Date operationDate, EntityReference<Organization> supplier, String originalCurrency, boolean air, EntityReference<ContractRelationDescription> description, List<ValidationMessage> messages) {
        Contract contract;
        String paymentCurrency;
        if (contractContainers.size() != 1 || !((Contract)contractContainers.get(0).getEntity()).isNewModel()) {
            String currencyCode;
            ExchangeRateData exchangeRateData = RulesHelper.getOldExchangeRateData(contractContainers, org, operationDate, supplier, originalCurrency, air);
            if (exchangeRateData != null && exchangeRateData.getCurrencyRateData() == null && messages != null && !MiscUtil.equals((Object)originalCurrency, (Object)(currencyCode = (String)Optional.ofNullable(exchangeRateData.getCurrency()).map(DictionaryReference::getCode).orElse(null)))) {
                messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_CURRENCY_RATE_NOT_FOUND, originalCurrency, currencyCode, exchangeRateData.getRateType() != null ? exchangeRateData.getRateType() : MulticurrencyHelper.getCurrencyRateType(exchangeRateData.getCurrency().getCode(), air), description));
            }
            return exchangeRateData;
        }
        EntityContainer<Contract> contractCtr = contractContainers.get(0);
        if (contractCtr != null && (paymentCurrency = (contract = (Contract)contractCtr.getEntity()).getPaymentCurrency()) != null) {
            ExchangeRateData exchangeRateData;
            if (paymentCurrency.equals(originalCurrency) && paymentCurrency.equals(DictHelper.getLocalCurrency())) {
                return null;
            }
            ExchangeRateCondition exchangeRateCondition = null;
            for (ExchangeRateCondition rateCondition : contract.getExchangeRateConditions()) {
                if (rateCondition.getStartDate() != null && rateCondition.getStartDate().after(operationDate) || rateCondition.getEndDate() != null && rateCondition.getEndDate().before(operationDate)) continue;
                exchangeRateCondition = rateCondition;
                break;
            }
            if ((exchangeRateData = MulticurrencyHelper.buildExchangeRateData(originalCurrency, paymentCurrency, exchangeRateCondition, operationDate, supplier, air)).getCurrencyRateData() == null && !MiscUtil.equals((Object)originalCurrency, (Object)paymentCurrency) && messages != null) {
                messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_CURRENCY_RATE_NOT_FOUND, originalCurrency, paymentCurrency, exchangeRateData.getRateType() != null ? exchangeRateData.getRateType() : MulticurrencyHelper.getCurrencyRateType(paymentCurrency, air), description));
            }
            return exchangeRateData;
        }
        String paymentCurrency2 = DictHelper.getLocalCurrency();
        if (paymentCurrency2.equals(originalCurrency)) {
            return null;
        }
        ExchangeRateData exchangeRateData = MulticurrencyHelper.buildExchangeRateData(originalCurrency, paymentCurrency2, null, operationDate, supplier, air);
        if (exchangeRateData.getCurrencyRateData() == null && messages != null) {
            messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.RH_CURRENCY_RATE_NOT_FOUND, originalCurrency, paymentCurrency2, MulticurrencyHelper.getCurrencyRateType(paymentCurrency2, air), description));
        }
        return exchangeRateData;
    }

    private static ExchangeRateData getOldExchangeRateData(List<EntityContainer<Contract>> contractContainers, EntityReference<Organization> org, Date operationDate, EntityReference<Organization> supplier, String originalCurrency, boolean air) {
        EntityReference<Organization> allClientsProfile = ProfileDao.findAllClientsProfile();
        EntityReference<Organization> allAgenciesProfile = ProfileDao.findAllAgenciesProfile();
        for (EntityContainer<Contract> ctr : contractContainers) {
            for (ContractCustomerInfo item : ((Contract)ctr.getEntity()).getCustomers()) {
                EntityReference customer;
                String paymentCurrency = item.getPaymentCurrency();
                if (item.getCustomer() == null || null == paymentCurrency || !(customer = item.getCustomer()).equals(org) && !customer.equals(allAgenciesProfile) && !customer.equals(allClientsProfile) || item.getStartDate() != null && item.getStartDate().after(operationDate) || item.getEndDate() != null && item.getEndDate().before(operationDate)) continue;
                if (paymentCurrency.equals(originalCurrency) && paymentCurrency.equals(DictHelper.getLocalCurrency())) {
                    return null;
                }
                ExchangeRateCondition exchangeRateCondition = null;
                for (ExchangeRateCondition rateCondition : item.getExchangeRateConditions()) {
                    if (rateCondition.getStartDate() != null && rateCondition.getStartDate().after(operationDate) || rateCondition.getEndDate() != null && rateCondition.getEndDate().before(operationDate)) continue;
                    exchangeRateCondition = rateCondition;
                    break;
                }
                return MulticurrencyHelper.buildExchangeRateData(originalCurrency, paymentCurrency, exchangeRateCondition, operationDate, supplier, air);
            }
        }
        String paymentCurrency = DictHelper.getLocalCurrency();
        if (paymentCurrency.equals(originalCurrency)) {
            return null;
        }
        return MulticurrencyHelper.buildExchangeRateData(originalCurrency, paymentCurrency, null, operationDate, supplier, air);
    }

    private static CurrencyRate findPredefinedCurrencyRate(String currencyCode, String baseCurrencyCode, List<CurrencyRate> predefinedCurrencyRates) {
        if (predefinedCurrencyRates == null) {
            return null;
        }
        for (CurrencyRate rate : predefinedCurrencyRates) {
            String dictBaseCurCode;
            String dictCurCode;
            if (rate == null || (dictCurCode = rate.getCurrency()) == null || !dictCurCode.equalsIgnoreCase(currencyCode) || (dictBaseCurCode = rate.getBaseCurrency()) == null || !dictBaseCurCode.equalsIgnoreCase(baseCurrencyCode)) continue;
            return rate;
        }
        return null;
    }

    public static boolean isFeeForRefund(EntityReference<BaseCommissionProperties> propRef) {
        EntityContainer propCtr = EntityStorage.get().resolve(propRef);
        if (propCtr == null) {
            return false;
        }
        BaseCommissionProperties prop = (BaseCommissionProperties)propCtr.getEntity();
        if (prop instanceof CommissionProperties) {
            CommissionProperties cprop = (CommissionProperties)prop;
            return cprop.getOperation() == Operation.EXCHANGE || cprop.getOperation() == Operation.REFUND;
        }
        if (prop instanceof FeeProperties) {
            FeeProperties cprop = (FeeProperties)prop;
            return cprop.getOperation() == Operation.EXCHANGE || cprop.getOperation() == Operation.REFUND;
        }
        if (prop instanceof DiscountProperties) {
            DiscountProperties cprop = (DiscountProperties)prop;
            return cprop.getOperation() == Operation.EXCHANGE || cprop.getOperation() == Operation.REFUND;
        }
        return false;
    }

    public static List<String> getPassengerTypeCategoryCodes(DictionaryReference<PassengerType> ptRef) {
        PassengerType pt;
        ArrayList<String> result = new ArrayList<String>();
        if (ptRef != null && (pt = (PassengerType)DictionaryCache.get().resolveReference(ptRef)) != null) {
            for (DictionaryReference ptc : pt.getCategories()) {
                if (ptc == null) continue;
                result.add(ptc.getCode());
            }
        }
        return result;
    }

    public static Boolean str2boolean(String str) {
        if (TextUtil.isBlank((String)str)) {
            return null;
        }
        return "true".equalsIgnoreCase(str) ? Boolean.TRUE : Boolean.FALSE;
    }

    public static String boolean2str(Object value) {
        if (value == null) {
            return null;
        }
        return (Boolean)value != false ? "true" : "false";
    }

    public static <T extends BaseProduct, P, A> void applyContainerRules(EntityContainer<? extends BaseRulesContainer> container, List<RuleProxy<P, A>> proxyList, T product) throws Exception {
        long start = System.currentTimeMillis();
        RuleEngine.applyRules(proxyList, (RuleSet)ProfileHelper.getRuleSet(container));
        MiscUtil.logTiming((long)start, () -> String.format("container %s applied to the product %s", container.toReference(), GeneralProductHelper.getHandler(product).generateShortProductName(product)));
    }

    public static <T extends BaseProduct, P, A> List<EntityContainer<? extends BaseRulesContainer>> applyRules(EntityContainer<Contract> contract, List<RuleProxy<P, A>> proxyList, T product) throws Exception {
        return RulesHelper.applyRules(contract, proxyList, product, null, null);
    }

    public static <T extends BaseProduct, P, A> List<EntityContainer<? extends BaseRulesContainer>> applyRules(EntityContainer<Contract> contract, List<RuleProxy<P, A>> proxyList, T product, RuleAction action, String ruleCategory) throws Exception {
        Date date = (Date)MiscUtil.guarded((Object)GeneralProductHelper.getHandler(product).findIssueDate(product), Date::new);
        Set<String> targets = proxyList.stream().map(RuleProxy::getProxyType).collect(Collectors.toSet());
        if (targets.contains(null)) {
            IncidentsLog.reportStackTrace((String)"proxy with type == null");
            targets = Collections.emptySet();
        }
        List<EntityContainer<? extends BaseRulesContainer>> result = ProfileHelper.getRuleContainers(contract, date, targets);
        long start = System.currentTimeMillis();
        for (EntityContainer<? extends BaseRulesContainer> container : result) {
            RuleEngine.applyRules(proxyList, (RuleSet)ProfileHelper.getRuleSet(container));
        }
        if (action != null && ruleCategory != null && !proxyList.isEmpty() && proxyList.get(0).getAppliedRuleCategories().contains(ruleCategory)) {
            product.getReservation().getBookingFile().getAppliedRules().removeIf(ar -> RulesHelper.ruleApplied(ar, product.getUid(), action));
            product.getReservation().getBookingFile().getAppliedRules().addAll(RulesHelper.calcAppliedRulesToBooking(proxyList.get(0), proxyList.get(0).getAppliedRules(), ProfileHelper.getRuleContainers(contract, new Date()), product, contract).stream().filter(ar -> RulesHelper.ruleApplied(ar, product.getUid(), action)).collect(Collectors.toList()));
        }
        MiscUtil.logTiming((long)start, () -> String.format("contract %s applied to the product %s", contract.toReference(), GeneralProductHelper.getHandler(product).generateShortProductName(product)));
        return result;
    }

    private static boolean ruleApplied(AppliedRule ar, String productUid, RuleAction action) {
        if (!ar.getProductUid().equals(productUid)) {
            return false;
        }
        if (ar.getRulesContainer() != null) {
            return RulesHelper.contractApplied((EntityReference<? extends BaseRulesContainer>)ar.getRulesContainer(), action, ar.getRuleUid());
        }
        if (ar.getContract() != null) {
            return RulesHelper.contractApplied((EntityReference<? extends BaseRulesContainer>)ar.getContract(), action, ar.getRuleUid());
        }
        return false;
    }

    private static boolean contractApplied(EntityReference<? extends BaseRulesContainer> reference, RuleAction action, String ruleUid) {
        EntityContainer container = EntityStorage.get().resolve(reference);
        RuleSettings settings = container != null && ((BaseRulesContainer)container.getEntity()).getRuleSet() != null ? (RuleSettings)CollectionUtil.find((Iterable)((BaseRulesContainer)container.getEntity()).getRuleSet().getRules(), (String)ruleUid) : null;
        return settings != null && settings.getResults().stream().anyMatch(r -> action == r.getAction());
    }

    public static <T extends BaseProduct> List<AppliedRule> calcAppliedRulesToBooking(RuleProxy<?, ?> proxy, Set<String> appliedRulesLocal, List<EntityContainer<? extends BaseRulesContainer>> rules, T product, EntityContainer<Contract> contractCtr) {
        ArrayList<AppliedRule> result = new ArrayList<AppliedRule>();
        proxy.getTracer().traceLogic(() -> "some rules applied: contract = ".concat(Objects.toString(contractCtr.toReference())));
        for (String ruleUid : appliedRulesLocal) {
            RuleSettings rule = null;
            EntityContainer<? extends BaseRulesContainer> rulesContainer = null;
            for (EntityContainer<? extends BaseRulesContainer> container : rules) {
                RuleSet ruleSet = ProfileHelper.getRuleSet(container);
                if (null == ruleSet || (rule = (RuleSettings)CollectionUtil.find((Iterable)ruleSet.getRules(), (String)ruleUid)) == null) continue;
                EntityContainer<? extends BaseRulesContainer> fRulesContainer = rulesContainer = container;
                RuleSettings fRule = rule;
                proxy.getTracer().traceLogic(() -> String.format("ruleset %s rule \u2116 %s was applied", ((BaseRulesContainer)fRulesContainer.getEntity()).toString(), ruleSet.getRules().indexOf(fRule) + 1));
                break;
            }
            if (rule == null) {
                log.error("unable to find rule with uid {} in contract {}", (Object)ruleUid, contractCtr);
                proxy.getTracer().traceWarn(String.format("unable to find rule: contract=%s, uid=%s", contractCtr.toReference(), ruleUid), null);
                continue;
            }
            AppliedRule ruleInfo = new AppliedRule();
            ruleInfo.setCalculationDate(new Date());
            ruleInfo.setContract(contractCtr.toReference());
            ruleInfo.setRulesContainer(rulesContainer.toReference());
            ruleInfo.setProductUid(product.getUid());
            ruleInfo.setRuleUid(rule.getUid());
            ruleInfo.setRuleName(rule.getName());
            ruleInfo.setRuleDescription(rule.getRestrictionsInfo());
            result.add(ruleInfo);
        }
        return result;
    }

    public static List<String[]> fillVisitedGeolocations(List<Set<String>> lvg) {
        return lvg.stream().map(ss -> ss.toArray(new String[ss.size()])).collect(Collectors.toList());
    }

    public static boolean containsEmployeeCategory(Collection<EmployeeCategory> categories, Collection<String> values) {
        return categories.stream().flatMap(cat -> cat.getName().getValues().values().stream()).anyMatch(cat -> values.stream().anyMatch(value -> TextUtil.isSame((String)cat, (String)value, (boolean)true)));
    }

    public static void addSubagencyCodes(Set<String> subagencyCodes, EntityReference<Organization> agencyRef) {
        String code = RulesHelper.getOrganizationCode(agencyRef);
        if (TextUtil.nonBlank((String)code)) {
            subagencyCodes.add(code);
        }
    }

    public static String getOrganizationCode(EntityReference<Organization> orgRef) {
        EntityContainer orgCtr = EntityStorage.get().resolve(orgRef);
        return orgCtr == null ? null : ((Organization)orgCtr.getEntity()).getCode();
    }

    public static String getAgencyCode(Reservation res) {
        if (res.getBookingFile() == null) {
            return null;
        }
        EntityReference agency = res.getBookingFile().getAgency();
        return RulesHelper.getAgencyCode((EntityReference<Organization>)agency);
    }

    public static String getAgencyCode(EntityReference<Organization> agency) {
        EntityContainer siteCtr = EntityStorage.get().resolve(agency);
        return siteCtr == null ? null : ((Organization)siteCtr.getEntity()).getCode();
    }

    static {
        final HashMap<Integer, String[]> ptMap = new HashMap<Integer, String[]>();
        for (int n = 0; n < paymentTypes.length; ++n) {
            Integer number = n;
            ptMap.put(number, paymentTypes[n]);
            numbers.add(number);
        }
        Collections.sort(numbers, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                String[] arr1 = (String[])ptMap.get(o1);
                int l1 = 0;
                for (String element : arr1) {
                    if (element == null) continue;
                    ++l1;
                }
                String[] arr2 = (String[])ptMap.get(o2);
                int l2 = 0;
                for (String element : arr2) {
                    if (element == null) continue;
                    ++l2;
                }
                if (l2 != l1) {
                    return l2 > l1 ? 1 : -1;
                }
                return o1.compareTo(o2);
            }
        });
    }
}

