/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.standard;

import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.RulePropertyConditions;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.TaxiProductPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.ValueTypes;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import java.math.BigDecimal;
import java.util.List;

public enum TaxiProductProperties implements RuleProperty,
RulePropertyConditions
{
    TAXI_STANDARD_CAR_CLASS{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return "\u041a\u043b\u0430\u0441\u0441 \u043e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u044f";
        }

        public String getRendererId() {
            return "CAR_CLASS";
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(String.format("\u041a\u043b\u0430\u0441\u0441 \u043e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u044f %s %s", cond.getDisplayName(), RulesHelper.toString(value)));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            TaxiProductPropertiesProvider ps = (TaxiProductPropertiesProvider)propertySet;
            if (ps.getCarClass() == null) {
                return false;
            }
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesDictRestriction(ps.getCarClass().getCode(), (List)value, true);
            }
            return RulesHelper.matchesDictRestriction(ps.getCarClass().getCode(), (List)value, false);
        }
    }
    ,
    TAXI_TOTAL_SUM{

        public String getDisplayName() {
            return "\u041f\u043e\u043b\u043d\u0430\u044f \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c";
        }

        public String getRendererId() {
            return ValueTypes.NUMBER.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(this.getDisplayName() + " " + cond.getDisplayName() + " " + value);
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            double fare;
            TaxiProductPropertiesProvider ps = (TaxiProductPropertiesProvider)propertySet;
            BigDecimal total = ps.getEquivalentSum();
            double dv = value == null ? 0.0 : ((Number)value).doubleValue();
            double d = fare = total == null ? 0.0 : total.doubleValue();
            if (Conditions.EQUALS.equals(condition)) {
                return Math.abs(fare - dv) < 0.01;
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return Math.abs(fare - dv) >= 0.01;
            }
            if (Conditions.GREATER_THAN.equals(condition)) {
                return fare - dv >= 0.01;
            }
            if (Conditions.GREATER_THAN_OR_EQUALS.equals(condition)) {
                return Math.abs(fare - dv) < 0.01 || fare - dv >= 0.01;
            }
            if (Conditions.LESS_THAN.equals(condition)) {
                return dv - fare >= 0.01;
            }
            if (Conditions.LESS_THAN_OR_EQUALS.equals(condition)) {
                return Math.abs(fare - dv) < 0.01 || dv - fare >= 0.01;
            }
            return false;
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.GREATER_THAN.getId(), Conditions.GREATER_THAN_OR_EQUALS.getId(), Conditions.LESS_THAN.getId(), Conditions.LESS_THAN_OR_EQUALS.getId()};
        }
    };


    public String getId() {
        return this.name();
    }

    @Override
    public abstract String[] getConditionIds();
}

