/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.standard;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.model.rules.l10n.Messages;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.Pair;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;

public class TchRouteRestrictions
implements Serializable,
XSerializable,
XSSerializable,
XCloneable {
    private static final long serialVersionUID = 1090973400301504346L;
    private boolean appliedToSegment = false;
    private ClassOfBookingRestriction classOfBookingRestriction = ClassOfBookingRestriction.ALL;
    private String classOfBookingValue;
    private Date departureDatesFromValue;
    private DepartureDatesRestriction departureDatesRestriction = DepartureDatesRestriction.ALL;
    private Date departureDatesToValue;
    private DepartureDaysRestriction departureDaysRestriction = DepartureDaysRestriction.ALL;
    private String departureDaysValue;
    private FlightNumbersRestriction flightNumbersRestriction = FlightNumbersRestriction.ALL;
    private String flightNumbersValue;
    private InterlineRestriction interlineRestriction = InterlineRestriction.ALL;
    private String interlineValue;
    private RouteRestriction routeRestriction = RouteRestriction.ALL;
    private String routeValue;
    private TariffCodeRestriction tariffCodeRestriction = TariffCodeRestriction.ALL;
    private String tariffCodeValue;

    public static boolean matchesTchRouteRules(List<String[]> interline, List<String[]> cities, List<Boolean> surface, List<String> flightNumbers, List<Date> departureDates, List<String> bookingClasses, List<String> fareBasises, TchRouteRestrictions restrictions) {
        if (restrictions.isAppliedToSegment()) {
            for (int n = 0; n < interline.size(); ++n) {
                if (surface.get(n) == Boolean.TRUE) continue;
                ArrayList<String[]> interlineValues = new ArrayList<String[]>(1);
                interlineValues.add(interline.get(n));
                ArrayList<String[]> cityCodes = new ArrayList<String[]>(2);
                cityCodes.add(cities.get(n));
                cityCodes.add(cities.get(n + 1));
                ArrayList<Boolean> surfaceValues = new ArrayList<Boolean>(1);
                surfaceValues.add(Boolean.FALSE);
                ArrayList<String> flightNumbersValues = new ArrayList<String>(1);
                flightNumbersValues.add(flightNumbers.get(n));
                Date departureDate = departureDates.get(n);
                ArrayList<String> serviceClassesValues = new ArrayList<String>(1);
                serviceClassesValues.add(bookingClasses.get(n));
                ArrayList<String> fareBasisesValues = new ArrayList<String>(1);
                fareBasisesValues.add(fareBasises.get(n));
                if (!TchRouteRestrictions.matchesTchRouteRulesInternal(interline, cityCodes, surfaceValues, flightNumbersValues, Collections.singletonList(departureDate), serviceClassesValues, fareBasisesValues, restrictions, true)) continue;
                return true;
            }
            return false;
        }
        return TchRouteRestrictions.matchesTchRouteRulesInternal(interline, cities, surface, flightNumbers, departureDates.isEmpty() ? null : departureDates, bookingClasses, fareBasises, restrictions, false);
    }

    private static boolean matchesTchRouteRulesInternal(List<String[]> interlineValues, List<String[]> cityCodes, List<Boolean> surfaceValues, List<String> flightNumbersValues, List<Date> departureDates, List<String> bookingClassesValues, List<String> fareBasisesValues, TchRouteRestrictions restrictions, boolean appliedToSegment) {
        String flightNumbersPattern;
        String[] restrValues;
        if (restrictions.getInterlineRestriction() != InterlineRestriction.ALL) {
            restrValues = TchRouteRestrictions.prepareRestrictionValues(restrictions.getInterlineValue(), appliedToSegment);
            ArrayList<String> values = new ArrayList<String>();
            boolean ownSegmentExists = false;
            for (String[] stringArray : interlineValues) {
                if (stringArray == null) {
                    ownSegmentExists = true;
                    continue;
                }
                String[] stringArray2 = stringArray;
                int n = stringArray2.length;
                for (int i = 0; i < n; ++i) {
                    String str = stringArray2[i];
                    if (TextUtil.isBlank((String)str)) continue;
                    values.add(str.trim());
                }
            }
            boolean found = false;
            for (String str : restrValues) {
                if (TextUtil.isBlank((String)str)) continue;
                str = str.toLowerCase();
                for (String str2 : values) {
                    if (TextUtil.isBlank((String)str2) || !(str2 = str2.toLowerCase()).equals(str.trim())) continue;
                    found = true;
                    break;
                }
                if (found) break;
            }
            switch (restrictions.getInterlineRestriction()) {
                case NONE: {
                    if (values.isEmpty()) break;
                    return false;
                }
                case INCLUDING: {
                    if (values.isEmpty() || found) break;
                    return false;
                }
                case EXCLUDING: {
                    if (values.isEmpty() || !found) break;
                    return false;
                }
                case OWN_AND_ONLY: {
                    if (!(restrValues.length == 0 ? !ownSegmentExists || values.isEmpty() : !ownSegmentExists || !found)) break;
                    return false;
                }
                case NOT_OWN_AND_ONLY: {
                    if (!(restrValues.length == 0 ? ownSegmentExists || values.isEmpty() : ownSegmentExists || !found)) break;
                    return false;
                }
                case ONLY: {
                    if (found) break;
                    return false;
                }
            }
        }
        if (restrictions.getDepartureDatesRestriction() != DepartureDatesRestriction.ALL) {
            Date to;
            Date from = restrictions.getDepartureDatesFromValue();
            if (from != null) {
                from = MiscUtil.clearTime((Date)from);
            }
            if ((to = restrictions.getDepartureDatesToValue()) != null) {
                to = MiscUtil.setDayEndTime((Date)to);
            }
            if (restrictions.getDepartureDatesRestriction() == DepartureDatesRestriction.EXCEPT || restrictions.getDepartureDatesRestriction() == DepartureDatesRestriction.ONLY) {
                boolean matched;
                Date departureDate = departureDates == null || departureDates.isEmpty() ? null : departureDates.get(0);
                boolean bl = matched = !(departureDate == null || from != null && !from.before(departureDate) || to != null && !to.after(departureDate));
                if (matched && restrictions.getDepartureDatesRestriction() == DepartureDatesRestriction.EXCEPT) {
                    return false;
                }
                if (!matched && restrictions.getDepartureDatesRestriction() == DepartureDatesRestriction.ONLY) {
                    return false;
                }
            } else if (restrictions.getDepartureDatesRestriction() == DepartureDatesRestriction.CONSIST_OF) {
                boolean hasMatched = false;
                boolean hasUnmatched = false;
                for (Date departureDate : departureDates) {
                    boolean matched;
                    boolean bl = matched = !(departureDate == null || from != null && from.after(departureDate) || to != null && to.before(departureDate));
                    if (matched) {
                        hasMatched = true;
                        continue;
                    }
                    hasUnmatched = true;
                }
                if (!hasMatched || hasUnmatched) {
                    return false;
                }
            }
        }
        if (restrictions.getDepartureDaysRestriction() != DepartureDaysRestriction.ALL) {
            Date firstDepartureDate;
            restrValues = TchRouteRestrictions.prepareRestrictionValues(restrictions.getDepartureDaysValue(), appliedToSegment);
            Integer[] days = new Integer[restrValues.length];
            for (int n = 0; n < restrValues.length; ++n) {
                days[n] = Integer.valueOf(restrValues[n]);
            }
            boolean found = false;
            Date date = firstDepartureDate = departureDates.isEmpty() ? null : departureDates.get(0);
            if (firstDepartureDate != null) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(firstDepartureDate);
                int day = TchRouteRestrictions.getDayOfWeek(calendar.get(7));
                for (Integer day2 : days) {
                    if (day != day2) continue;
                    found = true;
                    break;
                }
            }
            switch (restrictions.getDepartureDaysRestriction()) {
                case EXCEPT: {
                    if (!found) break;
                    return false;
                }
                case ONLY: {
                    if (found) break;
                    return false;
                }
            }
        }
        if (restrictions.getClassOfBookingRestriction() != ClassOfBookingRestriction.ALL) {
            restrValues = TchRouteRestrictions.prepareRestrictionValues(restrictions.getClassOfBookingValue(), appliedToSegment);
            boolean differs = bookingClassesValues.isEmpty();
            boolean atLeastOne = false;
            for (int n = 0; n < bookingClassesValues.size(); ++n) {
                if (Boolean.TRUE.equals(surfaceValues.get(n))) continue;
                String string = bookingClassesValues.get(n);
                if (TextUtil.isBlank((String)string)) {
                    differs = true;
                    break;
                }
                boolean found = false;
                String string2 = string.toLowerCase();
                for (String pattern : restrValues) {
                    if (!string2.equals((pattern = pattern.toLowerCase()).trim())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    differs = true;
                    continue;
                }
                atLeastOne = true;
            }
            switch (restrictions.getClassOfBookingRestriction()) {
                case EXCEPT: {
                    if (!atLeastOne) break;
                    return false;
                }
                case ONLY: {
                    if (!differs) break;
                    return false;
                }
            }
        }
        if (restrictions.getTariffCodeRestriction() != TariffCodeRestriction.ALL) {
            boolean bl;
            restrValues = TchRouteRestrictions.prepareRestrictionValues(restrictions.getTariffCodeValue(), appliedToSegment);
            boolean hasEquals = false;
            boolean hasNotEquals = false;
            boolean hasBegins = false;
            boolean bl2 = false;
            boolean hasMatches = false;
            boolean hasNotMatches = false;
            for (String fb : fareBasisesValues) {
                if (TextUtil.isBlank((String)fb)) {
                    hasNotEquals = true;
                    bl = true;
                    hasNotMatches = true;
                    continue;
                }
                fb = fb.trim().toLowerCase();
                boolean matchesInt = false;
                int equalsInt = 0;
                int beginsInt = 0;
                for (String pattern : restrValues) {
                    if (TextUtil.isBlank((String)pattern)) continue;
                    if (fb.equals(pattern = pattern.trim().toLowerCase())) {
                        equalsInt = 1;
                    }
                    if (fb.startsWith(pattern)) {
                        beginsInt = 1;
                    }
                    if (!fb.matches(pattern.replaceAll("%", ".*"))) continue;
                    matchesInt = true;
                }
                if (equalsInt != 0) {
                    hasEquals = true;
                } else {
                    hasNotEquals = true;
                }
                if (beginsInt != 0) {
                    hasBegins = true;
                } else {
                    bl = true;
                }
                if (matchesInt) {
                    hasMatches = true;
                    continue;
                }
                hasNotMatches = true;
            }
            switch (restrictions.getTariffCodeRestriction()) {
                case EXCEPT: {
                    if (!hasEquals && hasNotEquals) break;
                    return false;
                }
                case ONLY: {
                    if (!hasNotEquals && hasEquals) break;
                    return false;
                }
                case INCLUDE: {
                    if (!hasNotMatches && hasMatches) break;
                    return false;
                }
                case NOT_INCLUDE: {
                    if (!hasMatches && hasNotMatches) break;
                    return false;
                }
                case STARTS: {
                    if (!bl && hasBegins) break;
                    return false;
                }
                case NOT_STARTS: {
                    if (!hasBegins && bl) break;
                    return false;
                }
            }
        }
        if ((flightNumbersPattern = restrictions.getFlightNumbersValue()) != null && flightNumbersPattern.contains(";")) {
            flightNumbersPattern = flightNumbersPattern.replace(",", "/");
        }
        if (restrictions.getFlightNumbersRestriction() != FlightNumbersRestriction.ALL && !TchRouteRestrictions.matchesFlightNoCondition(restrictions.getFlightNumbersRestriction(), TchRouteRestrictions.prepareRestrictionValues(flightNumbersPattern, appliedToSegment), flightNumbersValues, surfaceValues)) {
            return false;
        }
        if (restrictions.getRouteRestriction() != RouteRestriction.ALL) {
            int upperLimit = cityCodes.size() - 1;
            ArrayList<Pair> actualSegments = new ArrayList<Pair>(upperLimit > 0 ? upperLimit : 0);
            for (int n = 0; n < upperLimit; ++n) {
                Boolean bl = surfaceValues.get(n);
                if (Boolean.TRUE.equals(bl)) continue;
                String[] startCodes = cityCodes.get(n);
                String[] endCodes = cityCodes.get(n + 1);
                actualSegments.add(new Pair((Object)startCodes, (Object)endCodes));
            }
            String routeRestrStr = restrictions.getRouteValue();
            if (!TextUtil.isBlank((String)routeRestrStr) && routeRestrStr.contains(";")) {
                routeRestrStr = routeRestrStr.replace(",", "/");
            }
            String[] stringArray = TchRouteRestrictions.prepareRestrictionValues(routeRestrStr, appliedToSegment);
            if (restrictions.getRouteRestriction() == RouteRestriction.CONSIST_OF) {
                if (appliedToSegment) {
                    return false;
                }
                upperLimit = cityCodes.size() - 1;
                for (int n = 0; n < upperLimit; ++n) {
                    if (Boolean.TRUE.equals(surfaceValues.get(n))) continue;
                    boolean found = false;
                    String[] departureLocationCodes = cityCodes.get(n);
                    String[] arrivalLocationCodes = cityCodes.get(n + 1);
                    for (String routeValue : stringArray) {
                        String[] restrValues2 = routeValue.split("-");
                        if (restrValues2.length != 2) continue;
                        String departureCode = restrValues2[0];
                        String arrivalCode = restrValues2[1];
                        if (!TchRouteRestrictions.contains(departureLocationCodes, departureCode) || !TchRouteRestrictions.contains(arrivalLocationCodes, arrivalCode)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    return false;
                }
                return true;
            }
            boolean found = false;
            boolean start = false;
            boolean end = false;
            String[] flightValues = TchRouteRestrictions.prepareRestrictionValues(flightNumbersPattern, appliedToSegment);
            block46: for (int k = 0; k < stringArray.length; ++k) {
                int n;
                String route = stringArray[k];
                String[] values = route.split("-");
                if (values.length == 1 && cityCodes.size() > 0) {
                    String city;
                    for (String dep : cityCodes.get(0)) {
                        if (TextUtil.isBlank((String)dep) || !(dep = dep.trim().toLowerCase()).equals(city = values[0].trim().toLowerCase()) || flightValues.length != 0 && flightValues.length == stringArray.length && !TchRouteRestrictions.matchesFlightNoCondition(restrictions.getFlightNumbersRestriction(), new String[]{flightValues[k]}, flightNumbersValues, surfaceValues)) continue;
                        start = true;
                        break;
                    }
                    for (String arr : cityCodes.get(cityCodes.size() - 1)) {
                        if (TextUtil.isBlank((String)arr) || !(arr = arr.trim().toLowerCase()).equals(city = values[0].trim().toLowerCase()) || flightValues.length != 0 && flightValues.length == stringArray.length && !TchRouteRestrictions.matchesFlightNoCondition(restrictions.getFlightNumbersRestriction(), new String[]{flightValues[k]}, flightNumbersValues, surfaceValues)) continue;
                        end = true;
                        continue block46;
                    }
                    continue;
                }
                boolean differs = false;
                ArrayList<Pair> restrictionSegments = new ArrayList<Pair>(values.length > 0 ? values.length - 1 : 0);
                for (n = 0; n < values.length - 1; ++n) {
                    String startCity = TchRouteRestrictions.prepareCityRestrictionValue(values[n], false);
                    String endCity = TchRouteRestrictions.prepareCityRestrictionValue(values[n + 1], true);
                    restrictionSegments.add(new Pair((Object)startCity, (Object)endCity));
                }
                upperLimit = restrictionSegments.size();
                if (upperLimit != actualSegments.size()) {
                    differs = true;
                } else {
                    for (n = 0; n < upperLimit; ++n) {
                        Pair restrictionValues = (Pair)restrictionSegments.get(n);
                        Pair actualValues = (Pair)actualSegments.get(n);
                        if (TchRouteRestrictions.contains((String[])actualValues.getFirst(), (String)restrictionValues.getFirst()) && TchRouteRestrictions.contains((String[])actualValues.getLast(), (String)restrictionValues.getLast())) continue;
                        differs = true;
                    }
                }
                if (differs || flightValues.length != 0 && flightValues.length == stringArray.length && !TchRouteRestrictions.matchesFlightNoCondition(restrictions.getFlightNumbersRestriction(), new String[]{flightValues[k]}, flightNumbersValues, surfaceValues)) continue;
                found = true;
            }
            switch (restrictions.getRouteRestriction()) {
                case EXCEPT: {
                    if (!found) break;
                    return false;
                }
                case ONLY: {
                    if (found) break;
                    return false;
                }
                case START: {
                    if (start) break;
                    return false;
                }
                case NOT_START_FROM: {
                    if (!start) break;
                    return false;
                }
                case END_AT: {
                    if (end) break;
                    return false;
                }
                case NOT_END_AT: {
                    if (!end) break;
                    return false;
                }
            }
        }
        return true;
    }

    private static String prepareCityRestrictionValue(String value, boolean extractFirstCity) {
        if (value.indexOf("/") == -1) {
            return value;
        }
        String[] res = value.split("/");
        return extractFirstCity ? res[0] : res[1];
    }

    private static boolean contains(String[] codes, String value) {
        if (codes == null || TextUtil.isBlank((String)value)) {
            return false;
        }
        for (String code : codes) {
            if (!value.equals(code)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchesFlightNoCondition(FlightNumbersRestriction restriction, String[] patterns, List<String> flightNumbersValues, List<Boolean> surfaceValues) {
        if (restriction == FlightNumbersRestriction.ALL) {
            return true;
        }
        if (restriction == FlightNumbersRestriction.IN_RANGE) {
            return RulesHelper.matchesStringRangeRestriction(flightNumbersValues, Arrays.asList(patterns), true);
        }
        if (restriction == FlightNumbersRestriction.CONSIST_OF) {
            block4: for (String pattern : patterns) {
                String[] flightNumbers = pattern.split("/");
                for (String actual : flightNumbersValues) {
                    boolean found = false;
                    for (String expected : flightNumbers) {
                        if (!expected.equals(actual)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    continue block4;
                }
                return true;
            }
            return false;
        }
        boolean found = false;
        for (String pattern : patterns) {
            if (TextUtil.isBlank((String)pattern)) continue;
            String[] flightNumbers = pattern.split("/");
            int index = 0;
            boolean differs = false;
            for (int n = 0; n < flightNumbersValues.size(); ++n) {
                if (index >= flightNumbers.length) {
                    differs = true;
                    break;
                }
                if (Boolean.TRUE.equals(surfaceValues.get(n))) continue;
                String actual = flightNumbersValues.get(n);
                if (TextUtil.isBlank((String)actual)) {
                    differs = true;
                    break;
                }
                actual = actual.trim();
                String expected = flightNumbers[index];
                if (TextUtil.isBlank((String)expected)) {
                    differs = true;
                    break;
                }
                if (!(expected = expected.trim()).equals(actual)) {
                    differs = true;
                    break;
                }
                ++index;
            }
            if (differs || index != flightNumbers.length) continue;
            found = true;
            break;
        }
        switch (restriction) {
            case EXCEPT: {
                if (!found) break;
                return false;
            }
            case ONLY: {
                if (found) break;
                return false;
            }
        }
        return true;
    }

    public static int getDayOfWeek(int i) {
        switch (i) {
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 5;
            }
            case 7: {
                return 6;
            }
        }
        return 7;
    }

    private static String[] prepareRestrictionValues(String value, boolean appliedToSegment) {
        if (TextUtil.isBlank((String)value)) {
            return new String[0];
        }
        StringTokenizer tokenizer = new StringTokenizer(value, appliedToSegment ? ",;/" : ",;");
        ArrayList<String> tokens = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            String nextToken = tokenizer.nextToken();
            if (TextUtil.isBlank((String)nextToken)) continue;
            tokens.add(nextToken.trim());
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    public TchRouteRestrictions() {
    }

    public TchRouteRestrictions(boolean appliedToSegmentValue, ClassOfBookingRestriction classOfBookingRestrictionValue, String classOfBookingValueValue, DepartureDatesRestriction departureDatesRestrictionValue, Date departureDatesFromValueValue, Date departureDatesToValueValue, DepartureDaysRestriction departureDaysRestrictionValue, String departureDaysValueValue, FlightNumbersRestriction flightNumbersRestrictionValue, String flightNumbersValueValue, InterlineRestriction interlineRestrictionValue, String interlineValueValue, RouteRestriction routeTypeValue, String routeValueValue, TariffCodeRestriction tariffCodeRestrictionValue, String tariffCodeValueValue) {
        this.appliedToSegment = appliedToSegmentValue;
        this.classOfBookingRestriction = classOfBookingRestrictionValue;
        this.classOfBookingValue = classOfBookingValueValue;
        this.departureDatesRestriction = departureDatesRestrictionValue;
        this.departureDatesFromValue = departureDatesFromValueValue;
        this.departureDatesToValue = departureDatesToValueValue;
        this.departureDaysRestriction = departureDaysRestrictionValue;
        this.departureDaysValue = departureDaysValueValue;
        this.flightNumbersRestriction = flightNumbersRestrictionValue;
        this.flightNumbersValue = flightNumbersValueValue;
        this.interlineRestriction = interlineRestrictionValue;
        this.interlineValue = interlineValueValue;
        this.routeRestriction = routeTypeValue;
        this.routeValue = routeValueValue;
        this.tariffCodeRestriction = tariffCodeRestrictionValue;
        this.tariffCodeValue = tariffCodeValueValue;
    }

    public void copyTo(TchRouteRestrictions dest) {
        if (dest == null) {
            return;
        }
        dest.appliedToSegment = this.appliedToSegment;
        dest.classOfBookingRestriction = this.classOfBookingRestriction;
        dest.classOfBookingValue = this.classOfBookingValue;
        dest.departureDatesRestriction = this.departureDatesRestriction;
        dest.departureDatesFromValue = this.departureDatesFromValue;
        dest.departureDatesToValue = this.departureDatesToValue;
        dest.departureDaysRestriction = this.departureDaysRestriction;
        dest.departureDaysValue = this.departureDaysValue;
        dest.flightNumbersRestriction = this.flightNumbersRestriction;
        dest.flightNumbersValue = this.flightNumbersValue;
        dest.interlineRestriction = this.interlineRestriction;
        dest.interlineValue = this.interlineValue;
        dest.routeRestriction = this.routeRestriction;
        dest.routeValue = this.routeValue;
        dest.tariffCodeRestriction = this.tariffCodeRestriction;
        dest.tariffCodeValue = this.tariffCodeValue;
    }

    public ClassOfBookingRestriction getClassOfBookingRestriction() {
        return this.classOfBookingRestriction;
    }

    public String getClassOfBookingValue() {
        return this.classOfBookingValue;
    }

    public Date getDepartureDatesFromValue() {
        return this.departureDatesFromValue;
    }

    public DepartureDatesRestriction getDepartureDatesRestriction() {
        return this.departureDatesRestriction;
    }

    public Date getDepartureDatesToValue() {
        return this.departureDatesToValue;
    }

    public DepartureDaysRestriction getDepartureDaysRestriction() {
        return this.departureDaysRestriction;
    }

    public String getDepartureDaysValue() {
        return this.departureDaysValue;
    }

    public FlightNumbersRestriction getFlightNumbersRestriction() {
        return this.flightNumbersRestriction;
    }

    public String getFlightNumbersValue() {
        return this.flightNumbersValue;
    }

    public InterlineRestriction getInterlineRestriction() {
        return this.interlineRestriction;
    }

    public String getInterlineValue() {
        return this.interlineValue;
    }

    public RouteRestriction getRouteRestriction() {
        return this.routeRestriction;
    }

    public String getRouteValue() {
        return this.routeValue;
    }

    public TariffCodeRestriction getTariffCodeRestriction() {
        return this.tariffCodeRestriction;
    }

    public String getTariffCodeValue() {
        return this.tariffCodeValue;
    }

    public boolean isAppliedToSegment() {
        return this.appliedToSegment;
    }

    public void setAppliedToSegment(boolean value) {
        this.appliedToSegment = value;
    }

    public void setClassOfBookingRestriction(ClassOfBookingRestriction value) {
        this.classOfBookingRestriction = value;
    }

    public void setClassOfBookingValue(String value) {
        this.classOfBookingValue = value;
    }

    public void setDepartureDatesFromValue(Date value) {
        this.departureDatesFromValue = value;
    }

    public void setDepartureDatesRestriction(DepartureDatesRestriction value) {
        this.departureDatesRestriction = value;
    }

    public void setDepartureDatesToValue(Date value) {
        this.departureDatesToValue = value;
    }

    public void setDepartureDaysRestriction(DepartureDaysRestriction value) {
        this.departureDaysRestriction = value;
    }

    public void setDepartureDaysValue(String value) {
        this.departureDaysValue = value;
    }

    public void setFlightNumbersRestriction(FlightNumbersRestriction value) {
        this.flightNumbersRestriction = value;
    }

    public void setFlightNumbersValue(String value) {
        this.flightNumbersValue = value;
    }

    public void setInterlineRestriction(InterlineRestriction value) {
        this.interlineRestriction = value;
    }

    public void setInterlineValue(String value) {
        this.interlineValue = value;
    }

    public void setRouteRestriction(RouteRestriction value) {
        this.routeRestriction = value;
    }

    public void setRouteValue(String value) {
        this.routeValue = value;
    }

    public void setTariffCodeRestriction(TariffCodeRestriction value) {
        this.tariffCodeRestriction = value;
    }

    public void setTariffCodeValue(String value) {
        this.tariffCodeValue = value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TchRouteRestrictions)) {
            return false;
        }
        TchRouteRestrictions other = (TchRouteRestrictions)obj;
        if (this.appliedToSegment != other.appliedToSegment) {
            return false;
        }
        if (!MiscUtil.equals((Object)((Object)this.classOfBookingRestriction), (Object)((Object)other.classOfBookingRestriction))) {
            return false;
        }
        if (!MiscUtil.equals((Object)this.classOfBookingValue, (Object)other.classOfBookingValue)) {
            return false;
        }
        if (!MiscUtil.equals((Object)((Object)this.departureDatesRestriction), (Object)((Object)other.departureDatesRestriction))) {
            return false;
        }
        if (!MiscUtil.equals((Object)this.departureDatesFromValue, (Object)other.departureDatesFromValue)) {
            return false;
        }
        if (!MiscUtil.equals((Object)this.departureDatesToValue, (Object)other.departureDatesToValue)) {
            return false;
        }
        if (!MiscUtil.equals((Object)((Object)this.departureDaysRestriction), (Object)((Object)other.departureDaysRestriction))) {
            return false;
        }
        if (!MiscUtil.equals((Object)this.departureDaysValue, (Object)other.departureDaysValue)) {
            return false;
        }
        if (!MiscUtil.equals((Object)((Object)this.flightNumbersRestriction), (Object)((Object)other.flightNumbersRestriction))) {
            return false;
        }
        if (!MiscUtil.equals((Object)this.flightNumbersValue, (Object)other.flightNumbersValue)) {
            return false;
        }
        if (!MiscUtil.equals((Object)((Object)this.interlineRestriction), (Object)((Object)other.interlineRestriction))) {
            return false;
        }
        if (!MiscUtil.equals((Object)this.interlineValue, (Object)other.interlineValue)) {
            return false;
        }
        if (!MiscUtil.equals((Object)((Object)this.routeRestriction), (Object)((Object)other.routeRestriction))) {
            return false;
        }
        if (!MiscUtil.equals((Object)this.routeValue, (Object)other.routeValue)) {
            return false;
        }
        if (!MiscUtil.equals((Object)((Object)this.tariffCodeRestriction), (Object)((Object)other.tariffCodeRestriction))) {
            return false;
        }
        return MiscUtil.equals((Object)this.tariffCodeValue, (Object)other.tariffCodeValue);
    }

    public int hashCode() {
        return MiscUtil.hash((Object[])new Object[]{this.appliedToSegment, this.classOfBookingRestriction, this.classOfBookingValue, this.departureDatesRestriction, this.departureDatesFromValue, this.departureDatesToValue, this.departureDaysRestriction, this.departureDaysValue, this.flightNumbersRestriction, this.flightNumbersValue, this.interlineRestriction, this.interlineValue, this.routeRestriction, this.routeValue, this.tariffCodeRestriction, this.tariffCodeValue});
    }

    public void fromXML(Element elm) throws Exception {
        this.appliedToSegment = XHelper.readBoolean((Element)elm, (String)"appliedToSegment", (boolean)false);
        this.classOfBookingRestriction = (ClassOfBookingRestriction)XHelper.readEnum((Element)elm, (String)"classOfBookingRestriction", ClassOfBookingRestriction.class);
        this.classOfBookingValue = XHelper.readString((Element)elm, (String)"classOfBookingValue");
        this.departureDatesRestriction = (DepartureDatesRestriction)XHelper.readEnum((Element)elm, (String)"departureDatesRestriction", DepartureDatesRestriction.class);
        this.departureDatesFromValue = XHelper.readDate((Element)elm, (String)"departureDatesFromValue");
        this.departureDatesToValue = XHelper.readDate((Element)elm, (String)"departureDatesToValue");
        this.departureDaysRestriction = (DepartureDaysRestriction)XHelper.readEnum((Element)elm, (String)"departureDaysRestriction", DepartureDaysRestriction.class);
        this.departureDaysValue = XHelper.readString((Element)elm, (String)"departureDaysValue");
        this.flightNumbersRestriction = (FlightNumbersRestriction)XHelper.readEnum((Element)elm, (String)"flightNumbersRestriction", FlightNumbersRestriction.class);
        this.flightNumbersValue = XHelper.readString((Element)elm, (String)"flightNumbersValue");
        this.interlineRestriction = (InterlineRestriction)XHelper.readEnum((Element)elm, (String)"interlineRestriction", InterlineRestriction.class);
        this.interlineValue = XHelper.readString((Element)elm, (String)"interlineValue");
        this.routeRestriction = (RouteRestriction)XHelper.readEnum((Element)elm, (String)"routeRestriction", RouteRestriction.class);
        this.routeValue = XHelper.readString((Element)elm, (String)"routeValue");
        this.tariffCodeRestriction = (TariffCodeRestriction)XHelper.readEnum((Element)elm, (String)"tariffCodeRestriction", TariffCodeRestriction.class);
        this.tariffCodeValue = XHelper.readString((Element)elm, (String)"tariffCodeValue");
    }

    public void fromXML(XMLStreamReader reader) throws Exception {
        block36: while (reader.nextTag() != 2) {
            String tag;
            switch (tag = reader.getName().getLocalPart()) {
                case "appliedToSegment": {
                    this.appliedToSegment = XSHelper.readBoolean((XMLStreamReader)reader, (boolean)false);
                    continue block36;
                }
                case "classOfBookingRestriction": {
                    this.classOfBookingRestriction = (ClassOfBookingRestriction)XSHelper.readEnum((XMLStreamReader)reader, ClassOfBookingRestriction.class);
                    continue block36;
                }
                case "classOfBookingValue": {
                    this.classOfBookingValue = XSHelper.readString((XMLStreamReader)reader);
                    continue block36;
                }
                case "departureDatesRestriction": {
                    this.departureDatesRestriction = (DepartureDatesRestriction)XSHelper.readEnum((XMLStreamReader)reader, DepartureDatesRestriction.class);
                    continue block36;
                }
                case "departureDatesFromValue": {
                    this.departureDatesFromValue = XSHelper.readDate((XMLStreamReader)reader);
                    continue block36;
                }
                case "departureDatesToValue": {
                    this.departureDatesToValue = XSHelper.readDate((XMLStreamReader)reader);
                    continue block36;
                }
                case "departureDaysRestriction": {
                    this.departureDaysRestriction = (DepartureDaysRestriction)XSHelper.readEnum((XMLStreamReader)reader, DepartureDaysRestriction.class);
                    continue block36;
                }
                case "departureDaysValue": {
                    this.departureDaysValue = XSHelper.readString((XMLStreamReader)reader);
                    continue block36;
                }
                case "flightNumbersRestriction": {
                    this.flightNumbersRestriction = (FlightNumbersRestriction)XSHelper.readEnum((XMLStreamReader)reader, FlightNumbersRestriction.class);
                    continue block36;
                }
                case "flightNumbersValue": {
                    this.flightNumbersValue = XSHelper.readString((XMLStreamReader)reader);
                    continue block36;
                }
                case "interlineRestriction": {
                    this.interlineRestriction = (InterlineRestriction)XSHelper.readEnum((XMLStreamReader)reader, InterlineRestriction.class);
                    continue block36;
                }
                case "interlineValue": {
                    this.interlineValue = XSHelper.readString((XMLStreamReader)reader);
                    continue block36;
                }
                case "routeRestriction": {
                    this.routeRestriction = (RouteRestriction)XSHelper.readEnum((XMLStreamReader)reader, RouteRestriction.class);
                    continue block36;
                }
                case "routeValue": {
                    this.routeValue = XSHelper.readString((XMLStreamReader)reader);
                    continue block36;
                }
                case "tariffCodeRestriction": {
                    this.tariffCodeRestriction = (TariffCodeRestriction)XSHelper.readEnum((XMLStreamReader)reader, TariffCodeRestriction.class);
                    continue block36;
                }
                case "tariffCodeValue": {
                    this.tariffCodeValue = XSHelper.readString((XMLStreamReader)reader);
                    continue block36;
                }
            }
            XSHelper.skipElement((XMLStreamReader)reader);
        }
    }

    public void toXML(Element elm) throws Exception {
        XHelper.writeBoolean((Element)elm, (String)"appliedToSegment", (boolean)this.appliedToSegment);
        XHelper.writeEnum((Element)elm, (String)"classOfBookingRestriction", (Enum)this.classOfBookingRestriction);
        XHelper.writeEnum((Element)elm, (String)"departureDatesRestriction", (Enum)this.departureDatesRestriction);
        XHelper.writeEnum((Element)elm, (String)"departureDaysRestriction", (Enum)this.departureDaysRestriction);
        XHelper.writeEnum((Element)elm, (String)"flightNumbersRestriction", (Enum)this.flightNumbersRestriction);
        XHelper.writeEnum((Element)elm, (String)"interlineRestriction", (Enum)this.interlineRestriction);
        XHelper.writeEnum((Element)elm, (String)"routeRestriction", (Enum)this.routeRestriction);
        XHelper.writeEnum((Element)elm, (String)"tariffCodeRestriction", (Enum)this.tariffCodeRestriction);
        XHelper.writeString((Element)elm, (String)"classOfBookingValue", (String)this.classOfBookingValue, (boolean)true);
        XHelper.writeDate((Element)elm, (String)"departureDatesFromValue", (Date)this.departureDatesFromValue);
        XHelper.writeDate((Element)elm, (String)"departureDatesToValue", (Date)this.departureDatesToValue);
        XHelper.writeString((Element)elm, (String)"departureDaysValue", (String)this.departureDaysValue, (boolean)true);
        XHelper.writeString((Element)elm, (String)"flightNumbersValue", (String)this.flightNumbersValue, (boolean)true);
        XHelper.writeString((Element)elm, (String)"interlineValue", (String)this.interlineValue, (boolean)true);
        XHelper.writeString((Element)elm, (String)"routeValue", (String)this.routeValue, (boolean)true);
        XHelper.writeString((Element)elm, (String)"tariffCodeValue", (String)this.tariffCodeValue, (boolean)true);
    }

    public void toXML(XMLStreamWriter writer) throws Exception {
        XSHelper.writeBoolean((XMLStreamWriter)writer, (String)"appliedToSegment", (boolean)this.appliedToSegment);
        XSHelper.writeEnum((XMLStreamWriter)writer, (String)"classOfBookingRestriction", (Enum)this.classOfBookingRestriction);
        XSHelper.writeEnum((XMLStreamWriter)writer, (String)"departureDatesRestriction", (Enum)this.departureDatesRestriction);
        XSHelper.writeEnum((XMLStreamWriter)writer, (String)"departureDaysRestriction", (Enum)this.departureDaysRestriction);
        XSHelper.writeEnum((XMLStreamWriter)writer, (String)"flightNumbersRestriction", (Enum)this.flightNumbersRestriction);
        XSHelper.writeEnum((XMLStreamWriter)writer, (String)"interlineRestriction", (Enum)this.interlineRestriction);
        XSHelper.writeEnum((XMLStreamWriter)writer, (String)"routeRestriction", (Enum)this.routeRestriction);
        XSHelper.writeEnum((XMLStreamWriter)writer, (String)"tariffCodeRestriction", (Enum)this.tariffCodeRestriction);
        XSHelper.writeString((XMLStreamWriter)writer, (String)"classOfBookingValue", (String)this.classOfBookingValue, (boolean)true);
        XSHelper.writeDate((XMLStreamWriter)writer, (String)"departureDatesFromValue", (Date)this.departureDatesFromValue);
        XSHelper.writeDate((XMLStreamWriter)writer, (String)"departureDatesToValue", (Date)this.departureDatesToValue);
        XSHelper.writeString((XMLStreamWriter)writer, (String)"departureDaysValue", (String)this.departureDaysValue, (boolean)true);
        XSHelper.writeString((XMLStreamWriter)writer, (String)"flightNumbersValue", (String)this.flightNumbersValue, (boolean)true);
        XSHelper.writeString((XMLStreamWriter)writer, (String)"interlineValue", (String)this.interlineValue, (boolean)true);
        XSHelper.writeString((XMLStreamWriter)writer, (String)"routeValue", (String)this.routeValue, (boolean)true);
        XSHelper.writeString((XMLStreamWriter)writer, (String)"tariffCodeValue", (String)this.tariffCodeValue, (boolean)true);
    }

    public Object clone(boolean newUids, Map<String, String> uids) throws Exception {
        TchRouteRestrictions clone = new TchRouteRestrictions();
        clone.appliedToSegment = this.appliedToSegment;
        clone.classOfBookingRestriction = this.classOfBookingRestriction;
        clone.classOfBookingValue = this.classOfBookingValue;
        clone.departureDatesRestriction = this.departureDatesRestriction;
        clone.departureDatesFromValue = XCloneHelper.cloneDate((Date)this.departureDatesFromValue);
        clone.departureDatesToValue = XCloneHelper.cloneDate((Date)this.departureDatesToValue);
        clone.departureDaysRestriction = this.departureDaysRestriction;
        clone.departureDaysValue = this.departureDaysValue;
        clone.flightNumbersRestriction = this.flightNumbersRestriction;
        clone.flightNumbersValue = this.flightNumbersValue;
        clone.interlineRestriction = this.interlineRestriction;
        clone.interlineValue = this.interlineValue;
        clone.routeRestriction = this.routeRestriction;
        clone.routeValue = this.routeValue;
        clone.tariffCodeRestriction = this.tariffCodeRestriction;
        clone.tariffCodeValue = this.tariffCodeValue;
        return clone;
    }

    public static enum TariffCodeRestriction {
        ALL{

            public String toString() {
                return L10n.get((String)Messages.TchRouteRestrictions_TariffCodeRestriction_all);
            }
        }
        ,
        EXCEPT{

            public String toString() {
                return L10n.get((String)Messages.TchRouteRestrictions_TariffCodeRestriction_exceptCodes);
            }
        }
        ,
        INCLUDE{

            public String toString() {
                return L10n.get((String)Messages.TchRouteRestrictions_TariffCodeRestriction_includeCodes);
            }
        }
        ,
        NOT_INCLUDE{

            public String toString() {
                return L10n.get((String)Messages.TchRouteRestrictions_TariffCodeRestriction_notIncludeCodes);
            }
        }
        ,
        NOT_STARTS{

            public String toString() {
                return L10n.get((String)Messages.TchRouteRestrictions_TariffCodeRestriction_notStartsWithCodes);
            }
        }
        ,
        ONLY{

            public String toString() {
                return L10n.get((String)Messages.TchRouteRestrictions_TariffCodeRestriction_onlyCodes);
            }
        }
        ,
        STARTS{

            public String toString() {
                return L10n.get((String)Messages.TchRouteRestrictions_TariffCodeRestriction_startsWithCodes);
            }
        };

    }

    public static enum RouteRestriction {
        ALL{

            public String toString() {
                return L10n.get((String)Messages.TchRouteRestrictions_RouteRestriction_all);
            }
        }
        ,
        EXCEPT{

            public String toString() {
                return L10n.get((String)Messages.TchRouteRestrictions_RouteRestriction_except);
            }
        }
        ,
        ONLY{

            public String toString() {
                return L10n.get((String)Messages.TchRouteRestrictions_RouteRestriction_only);
            }
        }
        ,
        START{

            public String toString() {
                return L10n.get((String)Messages.TchRouteRestrictions_RouteRestriction_startFrom);
            }
        }
        ,
        CONSIST_OF{

            public String toString() {
                return L10n.get((String)Messages.TchRouteRestrictions_RouteRestriction_consistOf);
            }
        }
        ,
        NOT_START_FROM{

            public String toString() {
                return L10n.get((String)Messages.TchRouteRestrictions_RouteRestriction_notStartFrom);
            }
        }
        ,
        END_AT{

            public String toString() {
                return L10n.get((String)Messages.TchRouteRestrictions_RouteRestriction_endAt);
            }
        }
        ,
        NOT_END_AT{

            public String toString() {
                return L10n.get((String)Messages.TchRouteRestrictions_RouteRestriction_notEndAt);
            }
        };

    }

    public static enum InterlineRestriction {
        ALL{

            public String toString() {
                return L10n.get((String)Messages.TchRouteRestrictions_InterlineRestriction_all);
            }
        }
        ,
        INCLUDING{

            public String toString() {
                return L10n.get((String)Messages.TchRouteRestrictions_InterlineRestriction_including);
            }
        }
        ,
        EXCLUDING{

            public String toString() {
                return L10n.get((String)Messages.TchRouteRestrictions_InterlineRestriction_EXCLUDING);
            }
        }
        ,
        NONE{

            public String toString() {
                return L10n.get((String)Messages.TchRouteRestrictions_InterlineRestriction_none);
            }
        }
        ,
        ONLY{

            public String toString() {
                return L10n.get((String)Messages.TchRouteRestrictions_InterlineRestriction_onlyWith);
            }
        }
        ,
        OWN_AND_ONLY{

            public String toString() {
                return L10n.get((String)Messages.TchRouteRestrictions_InterlineRestriction_OWN_AND_ONLY);
            }
        }
        ,
        NOT_OWN_AND_ONLY{

            public String toString() {
                return L10n.get((String)Messages.TchRouteRestrictions_InterlineRestriction_NOT_OWN_AND_ONLY);
            }
        };

    }

    public static enum FlightNumbersRestriction {
        ALL{

            public String toString() {
                return L10n.get((String)Messages.TchRouteRestrictions_FlightNumbersRestriction_all);
            }
        }
        ,
        EXCEPT{

            public String toString() {
                return L10n.get((String)Messages.TchRouteRestrictions_FlightNumbersRestriction_except);
            }
        }
        ,
        ONLY{

            public String toString() {
                return L10n.get((String)Messages.TchRouteRestrictions_FlightNumbersRestriction_only);
            }
        }
        ,
        CONSIST_OF{

            public String toString() {
                return L10n.get((String)Messages.TchRouteRestrictions_FlightNumbersRestriction_consistOf);
            }
        }
        ,
        IN_RANGE{

            public String toString() {
                return L10n.get((String)Messages.TchRouteRestrictions_FlightNumbersRestriction_inRange);
            }
        };

    }

    public static enum DepartureDaysRestriction {
        ALL{

            public String toString() {
                return L10n.get((String)Messages.TchRouteRestrictions_DepartureDaysRestriction_all);
            }
        }
        ,
        EXCEPT{

            public String toString() {
                return L10n.get((String)Messages.TchRouteRestrictions_DepartureDaysRestriction_except);
            }
        }
        ,
        ONLY{

            public String toString() {
                return L10n.get((String)Messages.TchRouteRestrictions_DepartureDaysRestriction_only);
            }
        };

    }

    public static enum DepartureDatesRestriction {
        ALL{

            public String toString() {
                return L10n.get((String)Messages.TchRouteRestrictions_DepartureDatesRestriction_all);
            }
        }
        ,
        EXCEPT{

            public String toString() {
                return L10n.get((String)Messages.TchRouteRestrictions_DepartureDatesRestriction_except);
            }
        }
        ,
        ONLY{

            public String toString() {
                return L10n.get((String)Messages.TchRouteRestrictions_DepartureDatesRestriction_only);
            }
        }
        ,
        CONSIST_OF{

            public String toString() {
                return L10n.get((String)Messages.TchRouteRestrictions_DepartureDatesRestriction_consist_of);
            }
        };

    }

    public static enum ClassOfBookingRestriction {
        ALL{

            public String toString() {
                return L10n.get((String)Messages.TchRouteRestrictions_ClassOfBookingRestriction_all);
            }
        }
        ,
        EXCEPT{

            public String toString() {
                return L10n.get((String)Messages.TchRouteRestrictions_ClassOfBookingRestriction_exceptSubclasses);
            }
        }
        ,
        ONLY{

            public String toString() {
                return L10n.get((String)Messages.TchRouteRestrictions_ClassOfBookingRestriction_subclasses);
            }
        };

    }
}

