/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.standard;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.CurrencyRate;
import com.gridnine.xtrip.common.model.booking.CurrencyRateType;
import com.gridnine.xtrip.common.model.booking.ReservationType;
import com.gridnine.xtrip.common.model.booking.commission.CalculationType;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.PassengerStatus;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.rules.l10n.Messages;
import com.gridnine.xtrip.common.model.rules.standard.Actions;
import com.gridnine.xtrip.common.model.rules.standard.Properties;
import com.gridnine.xtrip.common.model.rules.standard.RuleAttributes;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.rules.standard.TchRouteRestrictions;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.model.TchXmlCommissionsImportSettings;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.RulesEnvironment;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class TchXmlCommissionsImportHelper {
    public static final EntityReference<TchXmlCommissionsImportSettings> settingsRef = new EntityReference("tch_xml_commissions_import_settings", TchXmlCommissionsImportSettings.class, "Tch Xml Commissions Import Settings");
    public static final Date DATE_2025_02_05 = Date.from(LocalDate.of(2025, 2, 5).atStartOfDay(ZoneId.systemDefault()).toInstant());
    private static final SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    static final Logger log = LoggerFactory.getLogger(TchXmlCommissionsImportHelper.class);
    static final SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");

    public static void addStandardCommisionRule(RuleSet result, EntityReference<CommissionProperties> tchCommission) {
        RuleSettings rs = new RuleSettings();
        rs.setUid("standardTCHCommission");
        RuleRestriction rr = new RuleRestriction();
        rr.setProperty((RuleProperty)Properties.BLANK_OWNERS);
        rr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.INCLUDE);
        rr.setValue((Object)"\u04281");
        rs.getRestrictions().add(rr);
        rr = new RuleRestriction();
        rr.setProperty((RuleProperty)Properties.TCH_SERVICE_TYPE);
        rr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.TCH_SERVICE_TYPE_AIR_TICKETS);
        rs.getRestrictions().add(rr);
        rs.setTarget((RuleTarget)Targets.PRODUCT_COMMISSION);
        rs.setName(L10n.get((String)Messages.COMMISSION_DEFAULT));
        RuleResult res = new RuleResult();
        res.setAction((RuleAction)Actions.FOP_COMMISSION);
        RuleResultValue value = new RuleResultValue();
        value.setFopValues(new Object[]{new Double[][]{{5.0, 5.0, 5.0}, {5.0, 5.0, 5.0}, {5.0, 5.0, 5.0}, {5.0, 5.0, 5.0}, {5.0, 5.0, 5.0}, {5.0, 5.0, 5.0}, {5.0, 5.0, 5.0}, {5.0, 5.0, 5.0}, {5.0, 5.0, 5.0}, {5.0, 5.0, 5.0}, {5.0, 5.0, 5.0}, {5.0, 5.0, 5.0}}, new String[][]{{"%", "%", "%"}, {"%", "%", "%"}, {"%", "%", "%"}, {"%", "%", "%"}, {"%", "%", "%"}, {"%", "%", "%"}, {"%", "%", "%"}, {"%", "%", "%"}, {"%", "%", "%"}, {"%", "%", "%"}, {"%", "%", "%"}, {"%", "%", "%"}}, new RuleResultValue.FOPCommissionType[][]{{RuleResultValue.FOPCommissionType.PER_TICKET, RuleResultValue.FOPCommissionType.PER_TICKET, RuleResultValue.FOPCommissionType.PER_TICKET}, {RuleResultValue.FOPCommissionType.PER_TICKET, RuleResultValue.FOPCommissionType.PER_TICKET, RuleResultValue.FOPCommissionType.PER_TICKET}, {RuleResultValue.FOPCommissionType.PER_TICKET, RuleResultValue.FOPCommissionType.PER_TICKET, RuleResultValue.FOPCommissionType.PER_TICKET}, {RuleResultValue.FOPCommissionType.PER_TICKET, RuleResultValue.FOPCommissionType.PER_TICKET, RuleResultValue.FOPCommissionType.PER_TICKET}, {RuleResultValue.FOPCommissionType.PER_TICKET, RuleResultValue.FOPCommissionType.PER_TICKET, RuleResultValue.FOPCommissionType.PER_TICKET}, {RuleResultValue.FOPCommissionType.PER_TICKET, RuleResultValue.FOPCommissionType.PER_TICKET, RuleResultValue.FOPCommissionType.PER_TICKET}, {RuleResultValue.FOPCommissionType.PER_TICKET, RuleResultValue.FOPCommissionType.PER_TICKET, RuleResultValue.FOPCommissionType.PER_TICKET}, {RuleResultValue.FOPCommissionType.PER_TICKET, RuleResultValue.FOPCommissionType.PER_TICKET, RuleResultValue.FOPCommissionType.PER_TICKET}, {RuleResultValue.FOPCommissionType.PER_TICKET, RuleResultValue.FOPCommissionType.PER_TICKET, RuleResultValue.FOPCommissionType.PER_TICKET}, {RuleResultValue.FOPCommissionType.PER_TICKET, RuleResultValue.FOPCommissionType.PER_TICKET, RuleResultValue.FOPCommissionType.PER_TICKET}, {RuleResultValue.FOPCommissionType.PER_TICKET, RuleResultValue.FOPCommissionType.PER_TICKET, RuleResultValue.FOPCommissionType.PER_TICKET}, {RuleResultValue.FOPCommissionType.PER_TICKET, RuleResultValue.FOPCommissionType.PER_TICKET, RuleResultValue.FOPCommissionType.PER_TICKET}}});
        value.setTarget(tchCommission);
        res.setValue((Object)value);
        rs.getResults().add(res);
        result.getRules().add(rs);
        rs = new RuleSettings();
        rs.setUid("mcoPTATCHCommission");
        rs.setTarget((RuleTarget)Targets.PRODUCT_COMMISSION);
        rs.setName(L10n.get((String)Messages.MCOPTA_COMMISSION));
        rr = new RuleRestriction();
        rr.setProperty((RuleProperty)Properties.BLANK_OWNERS);
        rr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.INCLUDE);
        rr.setValue((Object)"\u04281");
        rs.getRestrictions().add(rr);
        rr = new RuleRestriction();
        rr.setProperty((RuleProperty)Properties.MCO_CATEGORY);
        rr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.EQUALS);
        rr.setValue(Arrays.asList(MCOCategory.PTA));
        rs.getRestrictions().add(rr);
        res = new RuleResult();
        res.setAction((RuleAction)Actions.SIMPLE_COMMISSION);
        value = new RuleResultValue();
        value.setCurrencyCode("RUB");
        value.setValue(0.0);
        value.setTarget(tchCommission);
        res.setValue((Object)value);
        rs.getResults().add(res);
        result.getRules().add(0, rs);
        rs = new RuleSettings();
        rs.setUid("infantCommission");
        rs.setTarget((RuleTarget)Targets.PRODUCT_COMMISSION);
        rs.setName(L10n.get((String)Messages.TCH_INFANT_COMMISSION));
        rr = new RuleRestriction();
        rr.setProperty((RuleProperty)Properties.BLANK_OWNERS);
        rr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.INCLUDE);
        rr.setValue((Object)"\u04281");
        rs.getRestrictions().add(rr);
        rr = new RuleRestriction();
        rr.setProperty((RuleProperty)Properties.FARE);
        rr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.EQUALS);
        rr.setValue((Object)0.0);
        rs.getRestrictions().add(rr);
        res = new RuleResult();
        res.setAction((RuleAction)Actions.SIMPLE_COMMISSION);
        value = new RuleResultValue();
        value.setCurrencyCode("RUB");
        value.setValue(0.0);
        value.setTarget(tchCommission);
        res.setValue((Object)value);
        rs.getResults().add(res);
        result.getRules().add(1, rs);
        rs = new RuleSettings();
        rs.setUid("equalExchangeCommission");
        rs.setTarget((RuleTarget)Targets.PRODUCT_COMMISSION);
        rs.setName(L10n.get((String)Messages.TCH_EQUAL_EXCHANGE_COMMISSION));
        rr = new RuleRestriction();
        rr.setProperty((RuleProperty)Properties.BLANK_OWNERS);
        rr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.INCLUDE);
        rr.setValue((Object)"\u04281");
        rs.getRestrictions().add(rr);
        rr = new RuleRestriction();
        rr.setProperty((RuleProperty)Properties.IS_ISSUED_IN_EXCHANGE);
        rr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.EQUALS);
        rr.setValue((Object)Boolean.TRUE);
        rs.getRestrictions().add(rr);
        rr = new RuleRestriction();
        rr.setProperty((RuleProperty)Properties.FARE_DIFFERENCE);
        rr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.LESS_THAN_OR_EQUALS);
        rr.setValue((Object)0.0);
        rs.getRestrictions().add(rr);
        rr = new RuleRestriction();
        rr.setProperty((RuleProperty)Properties.PRODUCT_CATEGORY);
        rr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.EQUALS);
        rr.setValue((Object)ProductCategory.AIR);
        rs.getRestrictions().add(rr);
        res = new RuleResult();
        res.setAction((RuleAction)Actions.SIMPLE_COMMISSION);
        value = new RuleResultValue();
        value.setCurrencyCode("RUB");
        value.setValue(0.0);
        value.setTarget(tchCommission);
        res.setValue((Object)value);
        rs.getResults().add(res);
        result.getRules().add(2, rs);
    }

    public static RuleSet parseRules(Document rules, List<Message> messages) throws Exception {
        TchXmlCommissionsImportSettings tchCommissionsSettings = TchXmlCommissionsImportHelper.updateAndReturnTchCommissionsSettings();
        if (tchCommissionsSettings == null || tchCommissionsSettings.getCommission() == null || tchCommissionsSettings.getSegmentCommission() == null) {
            messages.add(SystemHelper.createMessage(MessageType.ERROR, L10n.get((String)Messages.MSG_TchError), new Object[0]));
            return null;
        }
        Element[] rows = XmlUtil.getElements((Element)rules.getDocumentElement(), (String)"condition");
        RuleSet result = TchXmlCommissionsImportHelper.analizeRulesData(rows, (EntityReference<CommissionProperties>)tchCommissionsSettings.getCommission(), (EntityReference<CommissionProperties>)tchCommissionsSettings.getSegmentCommission(), messages);
        TchXmlCommissionsImportHelper.addStandardCommisionRule(result, (EntityReference<CommissionProperties>)tchCommissionsSettings.getCommission());
        return result;
    }

    public static boolean mergeRules(RuleSet newRules, RuleSet oldRules, Date notificationDate, List<Message> messages) {
        LinkedList<RuleSettings> result = new LinkedList<RuleSettings>(oldRules.getRules());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(notificationDate);
        calendar.add(5, -1);
        Date dueDate = MiscUtil.setDayEndTime((Date)calendar.getTime());
        ArrayList toAdd = new ArrayList(newRules.getRules());
        int closed = 0;
        for (RuleSettings rs : oldRules.getRules()) {
            RuleSettings rule = (RuleSettings)CollectionUtil.find((Iterable)newRules.getRules(), (String)rs.getUid());
            if (rule != null) {
                if (!(rule.getPeriodEnd() == null || rs.getPeriodEnd() != null && MiscUtil.setDayEndTime((Date)rs.getPeriodEnd()).equals(MiscUtil.setDayEndTime((Date)rule.getPeriodEnd())))) {
                    Date endTime = MiscUtil.setDayEndTime((Date)rule.getPeriodEnd());
                    rs.setPeriodEnd(endTime);
                    log.debug(String.format("end date of the rule \"%s\" were changed to %s", rs.getName(), LocaleManager.get().getCurrentLocaleData().getDateFormat().format(endTime)));
                    messages.add(SystemHelper.createMessage(MessageType.MESSAGE, L10n.get((String)Messages.MSG_TchRuleDateChange), rs.getName(), LocaleManager.get().getCurrentLocaleData().getDateFormat().format(endTime)));
                    ++closed;
                }
                if (!TextUtil.isSame((String)rule.getName(), (String)rs.getName())) {
                    rs.setName(rule.getName());
                    messages.add(SystemHelper.createMessage(MessageType.MESSAGE, L10n.get((String)Messages.MSG_TchRuleNameChange), rs.getName(), rule.getName()));
                }
                if (!CollectionUtil.equals((Collection)rs.getRestrictions(), (Collection)rule.getRestrictions(), (boolean)true)) {
                    rs.getRestrictions().clear();
                    rs.getRestrictions().addAll(rule.getRestrictions());
                    messages.add(SystemHelper.createMessage(MessageType.MESSAGE, L10n.get((String)Messages.MSG_TchRuleConditionsChange), rs.getName()));
                }
                if (!CollectionUtil.equals((Collection)rs.getResults(), (Collection)rule.getResults(), (boolean)true)) {
                    rs.getResults().clear();
                    rs.getResults().addAll(rule.getResults());
                    messages.add(SystemHelper.createMessage(MessageType.MESSAGE, L10n.get((String)Messages.MSG_TchRuleValuesChange), rs.getName()));
                }
                toAdd.remove(rule);
                continue;
            }
            if (rs.getPeriodEnd() != null && !rs.getPeriodEnd().after(dueDate)) continue;
            rs.setPeriodEnd(dueDate);
            log.debug(String.format("end date of the rule \"%s\" were changed to %s", rs.getName(), LocaleManager.get().getCurrentLocaleData().getDateFormat().format(dueDate)));
            messages.add(SystemHelper.createMessage(MessageType.MESSAGE, L10n.get((String)Messages.MSG_TchRuleClosed), rs.getName(), LocaleManager.get().getCurrentLocaleData().getDateFormat().format(dueDate)));
            ++closed;
        }
        result.addAll(toAdd);
        RuleSettings mcoRule = (RuleSettings)newRules.getRules().get(0);
        RuleSettings infantRule = (RuleSettings)newRules.getRules().get(1);
        RuleSettings equalExchangeRule = (RuleSettings)newRules.getRules().get(2);
        RuleSettings defaultRule = (RuleSettings)newRules.getRules().get(newRules.getRules().size() - 1);
        TchXmlCommissionsImportHelper.removeRules(result, mcoRule);
        TchXmlCommissionsImportHelper.removeRules(result, infantRule);
        TchXmlCommissionsImportHelper.removeRules(result, equalExchangeRule);
        TchXmlCommissionsImportHelper.removeRules(result, defaultRule);
        result.sort(new Comparator<RuleSettings>(){

            @Override
            public int compare(RuleSettings o1, RuleSettings o2) {
                int res = TextUtil.compare((String)this.getCarrierNumber(o1.getName()), (String)this.getCarrierNumber(o2.getName()), (boolean)false, (boolean)true);
                if (res != 0) {
                    return res;
                }
                res = MiscUtil.compare((Date)o1.getRevisionDate(), (Date)o2.getRevisionDate(), (boolean)false);
                if (res != 0) {
                    return -res;
                }
                res = this.getPriority(o2) - this.getPriority(o1);
                if (res != 0) {
                    return -res;
                }
                return this.getNotificationNumber(o2.getName()) - this.getNotificationNumber(o1.getName());
            }

            private int getPriority(RuleSettings rs) {
                String priorityStr = (String)rs.getAttributes().get("priority");
                int priority = 100;
                if (!TextUtil.isBlank((String)priorityStr)) {
                    try {
                        priority = Integer.parseInt(priorityStr);
                    }
                    catch (Exception e) {
                        log.error("unable to parse priority of rule " + rs.getName(), (Throwable)e);
                    }
                }
                return priority;
            }

            private int getNotificationNumber(String name) {
                if (name == null) {
                    return 0;
                }
                int idx = name.lastIndexOf(32);
                if (idx == -1) {
                    return 0;
                }
                try {
                    return Math.abs(Integer.parseInt(name.substring(idx + 1)));
                }
                catch (Exception e) {
                    return 0;
                }
            }

            private String getCarrierNumber(String name) {
                if (name == null) {
                    return null;
                }
                int idx = name.indexOf(32);
                return idx != -1 ? name.substring(0, idx) : name;
            }
        });
        result.addFirst(equalExchangeRule);
        result.addFirst(infantRule);
        result.addFirst(mcoRule);
        result.addLast(defaultRule);
        oldRules.getRules().clear();
        oldRules.getRules().addAll(result);
        messages.add(SystemHelper.createMessage(MessageType.MESSAGE, L10n.get((String)Messages.MSG_TchImportFinished), Integer.toString(closed), Integer.toString(toAdd.size()), Integer.toString(result.size())));
        return true;
    }

    private static void removeRules(List<RuleSettings> result, RuleSettings mcoRule) {
        if (mcoRule == null) {
            return;
        }
        result.removeIf(ruleSettings -> ruleSettings.getUid().equals(mcoRule.getUid()));
    }

    private static void addCommission(Element condElm, RuleSettings rs, int ptIndex, int i, String amnt, String ccode, EntityReference<CommissionProperties> tchCommission, EntityReference<CommissionProperties> tchSegmentCommission) throws Exception {
        RuleResultValue rrval;
        String curCode;
        String amntStr = XHelper.readString((Element)condElm, (String)amnt);
        if (TextUtil.isBlank((String)amntStr)) {
            return;
        }
        String curStr = XHelper.readString((Element)condElm, (String)ccode);
        if (TextUtil.isBlank((String)curStr)) {
            throw new Exception("commission currency is undefined");
        }
        RuleResultValue.FOPCommissionType type = RuleResultValue.FOPCommissionType.PER_TICKET;
        switch (Integer.parseInt(curStr)) {
            case 0: {
                curCode = "%";
                break;
            }
            case 1: {
                curCode = "RUB";
                type = RuleResultValue.FOPCommissionType.PER_SEGMENT;
                break;
            }
            case 2: {
                curCode = "USD";
                type = RuleResultValue.FOPCommissionType.PER_SEGMENT;
                break;
            }
            case 5: {
                curCode = "EUR";
                type = RuleResultValue.FOPCommissionType.PER_SEGMENT;
                break;
            }
            case 1001: 
            case 2001: {
                curCode = "RUB";
                break;
            }
            case 1002: 
            case 2002: {
                curCode = "USD";
                break;
            }
            case 1005: 
            case 2005: {
                curCode = "EUR";
                break;
            }
            case 1009: 
            case 2009: {
                curCode = "KZT";
                break;
            }
            default: {
                throw new Exception("unknown currency code " + curStr);
            }
        }
        double amntVal = new Double(amntStr);
        if ("USD".equals(curCode) || "EUR".equals(curCode) || "KZT".equals(curCode)) {
            CurrencyRate crate = BookingHelper.findCurrencyRate(curCode, rs.getPeriodBegin(), CurrencyRateType.CBR, null, null);
            if (crate == null) {
                throw new Exception(String.format("Central Bank currency rate for \"%s\" on \"%s\" is undefined", curCode, new SimpleDateFormat("yyyy-MM-dd").format(rs.getPeriodBegin())));
            }
            amntVal = BigDecimal.valueOf(amntVal).multiply(BigDecimal.valueOf(crate.getRate())).divide(BigDecimal.ONE, 2, RoundingMode.HALF_UP).doubleValue();
            curCode = "RUB";
        } else if ("%".equals(curCode)) {
            amntVal = BigDecimal.valueOf(amntVal * 100.0).divide(BigDecimal.ONE, 2, RoundingMode.HALF_UP).doubleValue();
        }
        RuleResult result = null;
        for (RuleResult item : rs.getResults()) {
            if (!(item.getValue() instanceof RuleResultValue)) continue;
            RuleResultValue value = (RuleResultValue)item.getValue();
            if (type == RuleResultValue.FOPCommissionType.PER_SEGMENT && tchSegmentCommission.equals(value.getTarget())) {
                result = item;
                break;
            }
            if (type != RuleResultValue.FOPCommissionType.PER_TICKET || !tchCommission.equals(value.getTarget())) continue;
            result = item;
            break;
        }
        if (result == null) {
            result = new RuleResult();
            result.setAction((RuleAction)Actions.FOP_COMMISSION);
            rrval = new RuleResultValue();
            rrval.setTarget(type == RuleResultValue.FOPCommissionType.PER_TICKET ? tchCommission : tchSegmentCommission);
            rrval.setFopValues(new Object[]{new Double[12][3], new String[12][3]});
            result.setValue((Object)rrval);
            rs.getResults().add(result);
        }
        rrval = (RuleResultValue)result.getValue();
        ((Double[][])rrval.getFopValues()[0])[ptIndex][i] = amntVal;
        ((String[][])rrval.getFopValues()[1])[ptIndex][i] = curCode;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static RuleSet analizeRulesData(Element[] rows, EntityReference<CommissionProperties> tchCommission, EntityReference<CommissionProperties> tchSegmentCommission, List<Message> messages) throws Exception {
        RuleSet result = new RuleSet();
        result.setModified(new Date());
        Element[] elementArray = rows;
        int n = elementArray.length;
        int n2 = 0;
        while (true) {
            block47: {
                int n3;
                int n4;
                Element[] elementArray2;
                boolean hasBaggage;
                boolean hasPenalty;
                boolean hasFare;
                Date dn;
                RuleSettings rs;
                Element rowElm;
                block48: {
                    if (n2 >= n) {
                        return result;
                    }
                    rowElm = elementArray[n2];
                    rs = new RuleSettings();
                    String uid = XHelper.readString((Element)rowElm, (String)"condition_id");
                    if (TextUtil.isBlank((String)uid)) {
                        throw new Exception("tag condition_id is empty");
                    }
                    rs.setUid(uid);
                    rs.setTarget((RuleTarget)Targets.PRODUCT_COMMISSION);
                    Date df = TchXmlCommissionsImportHelper.getDate(rowElm, "date_from");
                    Date dt = TchXmlCommissionsImportHelper.getDate(rowElm, "date_to");
                    Date da = TchXmlCommissionsImportHelper.getDate(rowElm, "act_date");
                    if (df == null || da != null && df.before(da)) {
                        df = da;
                    }
                    if (df != null) {
                        rs.setPeriodBegin(MiscUtil.clearTime((Date)df));
                    }
                    if (dt != null) {
                        rs.setPeriodEnd(MiscUtil.setDayEndTime((Date)dt));
                    }
                    if (dt == null) break block48;
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(dt);
                    if (calendar.get(1) < 2009) break block47;
                }
                if ((dn = TchXmlCommissionsImportHelper.getDate(rowElm, "condition_date")) != null) {
                    rs.setRevisionDate(MiscUtil.clearTime((Date)dn));
                }
                String carrier = TchXmlCommissionsImportHelper.createCarrierRestriction(rs, rowElm);
                rs.setName(carrier + " " + XHelper.readString((Element)rowElm, (String)"condition_num"));
                String info = XHelper.readString((Element)rowElm, (String)"out_num_avs");
                if (!TextUtil.isBlank((String)info)) {
                    TchXmlCommissionsImportHelper.analizeTelex(info, rs, messages);
                }
                String priorityStr = XHelper.readString((Element)rowElm, (String)"priority");
                rs.getAttributes().put("priority", priorityStr);
                Element[] elementArray3 = XmlUtil.getElements((Element)rowElm, (String)"param_value");
                int n5 = elementArray3.length;
                int n6 = 0;
                while (true) {
                    if (n6 >= n5) {
                        if ("2".equals(XHelper.readString((Element)rowElm, (String)"condition_type"))) {
                            boolean found = false;
                            for (RuleRestriction rr : rs.getRestrictions()) {
                                if (rr.getProperty() != Properties.TCH_ROUTE) continue;
                                found = true;
                                ((TchRouteRestrictions)rr.getValue()).setAppliedToSegment(true);
                                rr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.TCH_ROUTE_SEGMENT);
                            }
                            if (!found) {
                                messages.add(SystemHelper.createMessage(MessageType.WARNING, L10n.get((String)Messages.MSG_TchRuleFailed), info, XHelper.readString((Element)rowElm, (String)"condition_id")));
                            }
                        } else {
                            for (RuleRestriction rr : rs.getRestrictions()) {
                                if (rr.getProperty() != Properties.TCH_ROUTE) continue;
                                ((TchRouteRestrictions)rr.getValue()).setAppliedToSegment(false);
                                rr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.TCH_ROUTE_ALL);
                            }
                        }
                        if (AirProductHelper.isSpecialSchemeTourCode(carrier)) {
                            HashSet<String> carriers = new HashSet<String>();
                            Iterator it = rs.getRestrictions().iterator();
                            while (it.hasNext()) {
                                List<String> items;
                                RuleRestriction restr = (RuleRestriction)it.next();
                                if (restr.getProperty() != Properties.AIRLINES || (items = RulesHelper.toStringCollection(restr.getValue())).size() <= 1) continue;
                                carriers.addAll(items);
                                it.remove();
                            }
                            StringBuilder sb = new StringBuilder();
                            for (String carrierCode : carriers) {
                                RuleRestriction restr = new RuleRestriction();
                                restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.INCLUDE);
                                restr.setProperty((RuleProperty)Properties.AIRLINES);
                                ArrayList<String> values = new ArrayList<String>();
                                values.add(carrierCode);
                                restr.setValue(values);
                                rs.getRestrictions().add(restr);
                                if (sb.length() > 0) {
                                    sb.append("-");
                                }
                                sb.append(carrierCode);
                            }
                            RuleRestriction carriersRestriction = TchXmlCommissionsImportHelper.findRestriction(rs, Properties.CARRIERS);
                            if (carriersRestriction == null) {
                                carriersRestriction = new RuleRestriction();
                                carriersRestriction.setProperty((RuleProperty)Properties.CARRIERS);
                                rs.getRestrictions().add(carriersRestriction);
                            }
                            carriersRestriction.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.CONTAINS_ONLY);
                            carriersRestriction.setValue((Object)sb.toString());
                        }
                        hasFare = "1".equals(XHelper.readString((Element)rowElm, (String)"use_tp"));
                        hasPenalty = "1".equals(XHelper.readString((Element)rowElm, (String)"use_cn"));
                        hasBaggage = "1".equals(XHelper.readString((Element)rowElm, (String)"use_tb"));
                        elementArray2 = XmlUtil.getElements((Element)rowElm, (String)"value_org");
                        n4 = elementArray2.length;
                        break;
                    }
                    Element condElm = elementArray3[n6];
                    Conditions[] conditionsArray = Conditions.values();
                    n3 = conditionsArray.length;
                    int n7 = 0;
                    block23: while (true) {
                        if (n7 >= n3) {
                            throw new Exception("unsupported condition type: " + XHelper.readString((Element)condElm, (String)"type_id") + " please ask developer");
                        }
                        Conditions cond = conditionsArray[n7];
                        switch (cond.update(condElm, rs)) {
                            case RULE_MUST_BE_IGNORED: {
                                messages.add(SystemHelper.createMessage(MessageType.MESSAGE, L10n.get((String)Messages.MSG_TchRuleIgnored) + " \"{0}\" (id = {1}): type ={2}, subtype = {3} ", info, XHelper.readString((Element)rowElm, (String)"condition_id"), XHelper.readString((Element)condElm, (String)"type_id"), XHelper.readString((Element)condElm, (String)"subtype_id")));
                                break block47;
                            }
                            case CONDITION_WAS_APPLIED: {
                                break block23;
                            }
                            default: {
                                ++n7;
                                continue block23;
                            }
                        }
                        break;
                    }
                    ++n6;
                }
                block24: for (n3 = 0; n3 < n4; ++n3) {
                    Element condElm = elementArray2[n3];
                    int ptIndex = -1;
                    switch (Integer.parseInt(XHelper.readString((Element)condElm, (String)"org_type"))) {
                        case 1: {
                            ptIndex = 0;
                            break;
                        }
                        case 2: {
                            ptIndex = 1;
                            break;
                        }
                        case 3: {
                            ptIndex = 2;
                            break;
                        }
                        case 4: {
                            ptIndex = 4;
                            break;
                        }
                        case 5: {
                            ptIndex = 5;
                            break;
                        }
                        case 6: {
                            ptIndex = 8;
                            break;
                        }
                        case 7: {
                            ptIndex = 9;
                            break;
                        }
                        case 8: {
                            ptIndex = 6;
                            break;
                        }
                        case 9: {
                            ptIndex = 7;
                            break;
                        }
                        case 10: {
                            ptIndex = 10;
                            break;
                        }
                        case 11: {
                            continue block24;
                        }
                    }
                    if (hasFare) {
                        TchXmlCommissionsImportHelper.addCommission(condElm, rs, ptIndex, 0, "sum_tp", "curr_code_i_tp", tchCommission, tchSegmentCommission);
                        if (ptIndex == 0) {
                            TchXmlCommissionsImportHelper.addCommission(condElm, rs, 3, 0, "sum_tp", "curr_code_i_tp", tchCommission, tchSegmentCommission);
                        }
                    }
                    if (hasPenalty) {
                        TchXmlCommissionsImportHelper.addCommission(condElm, rs, ptIndex, 1, "sum_cn", "curr_code_i_cn", tchCommission, tchSegmentCommission);
                        if (ptIndex == 0) {
                            TchXmlCommissionsImportHelper.addCommission(condElm, rs, 3, 1, "sum_cn", "curr_code_i_cn", tchCommission, tchSegmentCommission);
                        }
                    }
                    if (!hasBaggage) continue;
                    TchXmlCommissionsImportHelper.addCommission(condElm, rs, ptIndex, 2, "sum_tb", "curr_code_i_tb", tchCommission, tchSegmentCommission);
                    if (ptIndex != 0) continue;
                    TchXmlCommissionsImportHelper.addCommission(condElm, rs, 3, 2, "sum_tb", "curr_code_i_tb", tchCommission, tchSegmentCommission);
                }
                result.getRules().add(rs);
            }
            ++n2;
        }
    }

    private static void analizeTelex(String info, RuleSettings rs, List<Message> messages) {
        int index = info.indexOf("\u043e\u0442");
        if (index == -1) {
            rs.getAttributes().put(RuleAttributes.TCH_TELEX_NO.name(), info.trim());
            return;
        }
        rs.getAttributes().put(RuleAttributes.TCH_TELEX_NO.name(), info.substring(0, index).trim());
        String dateStr = info.substring(index + 2);
        if (TextUtil.isBlank((String)dateStr)) {
            return;
        }
        Pattern p = Pattern.compile("[0-9]{2}\\.[0-9]{2}\\.[0-9]{4}");
        Matcher m = p.matcher(dateStr);
        if (!m.find()) {
            return;
        }
        String grp = m.group();
        try {
            rs.getAttributes().put(RuleAttributes.TCH_TELEX_DATE.name(), RulesEnvironment.getDateFormat().format(new SimpleDateFormat("dd.MM.yyyy").parse(grp)));
        }
        catch (ParseException e) {
            log.error("unable to parse telex date from string " + info, (Throwable)e);
            messages.add(SystemHelper.createMessage(MessageType.WARNING, L10n.get((String)Messages.MSG_TchNoTelex), e, info));
        }
    }

    private static String createCarrierRestriction(RuleSettings rs, Element rowElm) throws Exception {
        String result = XHelper.readString((Element)rowElm, (String)"carrier_code");
        if (!TextUtil.isBlank((String)result)) {
            RuleRestriction res = new RuleRestriction();
            res.setProperty((RuleProperty)Properties.CARRIERS);
            res.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.CONTAINS_ONLY);
            result = result.trim();
            ArrayList<String> values = new ArrayList<String>();
            values.add(result);
            res.setValue(values);
            rs.getRestrictions().add(res);
            Airline airline = DictHelper.findAirlineByAnyCode(result);
            return airline != null && !TextUtil.isBlank((String)airline.getAirlineNumber()) ? airline.getAirlineNumber().trim() : result;
        }
        result = XHelper.readString((Element)rowElm, (String)"treaty_code");
        if (TextUtil.isBlank((String)result)) {
            throw new Exception("tag treaty_code is empty");
        }
        if (AirProductHelper.isSpecialSchemeTourCode(result)) {
            RuleRestriction res = new RuleRestriction();
            res.setProperty((RuleProperty)Properties.TOUR_CODE);
            res.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.EQUALS);
            res.setValue((Object)result.trim());
            rs.getRestrictions().add(res);
            return result;
        }
        RuleRestriction res = new RuleRestriction();
        res.setProperty((RuleProperty)Properties.CARRIER_NUMBER);
        res.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.EQUALS);
        res.setValue((Object)result.trim());
        rs.getRestrictions().add(res);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Date getDate(Element elm, String string) throws Exception {
        String data = XHelper.readString((Element)elm, (String)string);
        if (TextUtil.isBlank((String)data)) {
            return null;
        }
        data = data.substring(0, data.length() - 6);
        SimpleDateFormat simpleDateFormat = df;
        synchronized (simpleDateFormat) {
            return df.parse(data);
        }
    }

    static RuleRestriction findRestriction(RuleSettings rs, Properties prop) {
        for (RuleRestriction rr : rs.getRestrictions()) {
            if (rr.getProperty() != prop) continue;
            return rr;
        }
        return null;
    }

    private TchXmlCommissionsImportHelper() {
    }

    public static TchXmlCommissionsImportSettings updateAndReturnTchCommissionsSettings() throws Exception {
        EntityContainer commissionCtr;
        String commissionUid;
        EntityContainer settingsCtr = EntityStorage.get().resolve(settingsRef);
        if (settingsCtr != null && ((TchXmlCommissionsImportSettings)settingsCtr.getEntity()).getCommission() != null && ((TchXmlCommissionsImportSettings)settingsCtr.getEntity()).getSegmentCommission() != null) {
            return (TchXmlCommissionsImportSettings)settingsCtr.getEntity();
        }
        boolean update = false;
        if (settingsCtr == null) {
            settingsCtr = new EntityContainer(settingsRef.getType(), settingsRef.getUid());
            ((TchXmlCommissionsImportSettings)settingsCtr.getEntity()).setName(L10n.get((String)Messages.TCH_COMMISSION_IMPORT_SETTINGS));
            update = true;
        }
        if (((TchXmlCommissionsImportSettings)settingsCtr.getEntity()).getCommission() == null && (commissionUid = DictHelper.getPreferenceValue(PreferenceKey.DEFAULT_COMMISSION, null)) != null && (commissionCtr = EntityStorage.get().resolve(new EntityReference(commissionUid, CommissionProperties.class, null))) != null) {
            ((TchXmlCommissionsImportSettings)settingsCtr.getEntity()).setCommission(commissionCtr.toReference());
            update = true;
        }
        if (((TchXmlCommissionsImportSettings)settingsCtr.getEntity()).getSegmentCommission() == null) {
            EntityContainer commissionCtr2;
            EntityReference segmentCommissionRef = new EntityReference("tch_segment_commission", CommissionProperties.class, "\u041a\u043e\u043c\u0438\u0441\u0441\u0438\u044f \u0422\u041a\u041f (\u0441\u0435\u0433\u043c\u0435\u043d\u0442)");
            EntityContainer segmentCommissionCtr = EntityStorage.get().resolve(segmentCommissionRef);
            if (segmentCommissionCtr == null && (commissionCtr2 = EntityStorage.get().resolve(((TchXmlCommissionsImportSettings)settingsCtr.getEntity()).getCommission())) != null) {
                segmentCommissionCtr = (EntityContainer)XCloneHelper.clone((XCloneable)commissionCtr2, (boolean)true);
                segmentCommissionCtr.setUid(segmentCommissionRef.getUid());
                ((CommissionProperties)segmentCommissionCtr.getEntity()).setCalculationType(CalculationType.SEGMENT);
                ((CommissionProperties)segmentCommissionCtr.getEntity()).setDisplayName("\u041a\u043e\u043c\u0438\u0441\u0441\u0438\u044f \u0422\u041a\u041f (\u0441\u0435\u0433\u043c\u0435\u043d\u0442)");
                EntityStorage.get().save(segmentCommissionCtr, true);
            }
            if (segmentCommissionCtr != null) {
                ((TchXmlCommissionsImportSettings)settingsCtr.getEntity()).setSegmentCommission(segmentCommissionRef);
                update = true;
            }
        }
        if (update) {
            EntityStorage.get().save(settingsCtr, false);
        }
        return (TchXmlCommissionsImportSettings)settingsCtr.getEntity();
    }

    static enum Conditions {
        AGENCY{

            @Override
            ConditionApplicationResult update(Element elm, RuleSettings rs) throws Exception {
                String value;
                if (!this.accept(elm, "20") && !this.accept(elm, "40")) {
                    return ConditionApplicationResult.CONDITION_WAS_NOT_APPLIED;
                }
                String subtype = XmlUtil.getValue((Element)elm, (String)"subtype_id");
                if ("200".equals(subtype) || "400".equals(subtype) || "1100".equals(subtype)) {
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                RuleRestriction restr = TchXmlCommissionsImportHelper.findRestriction(rs, Properties.TCH_AGENCY_CODE);
                if (restr == null) {
                    restr = new RuleRestriction();
                    restr.setProperty((RuleProperty)Properties.TCH_AGENCY_CODE);
                    rs.getRestrictions().add(restr);
                }
                if (TextUtil.isBlank((String)(value = XmlUtil.getValue((Element)elm, (String)"code_value")))) {
                    value = null;
                }
                restr.setValue((Object)value);
                if ("201".equals(subtype) || "401".equals(subtype) || "1101".equals(subtype)) {
                    restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.EQUALS);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("202".equals(subtype) || "402".equals(subtype) || "1102".equals(subtype)) {
                    restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.NOT_EQUALS);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                throw new Exception("unknown restriction on agency code: " + subtype);
            }
        }
        ,
        AGENCY_COUNTRY_CODES{

            @Override
            ConditionApplicationResult update(Element elm, RuleSettings rs) throws Exception {
                String value;
                if (!this.accept(elm, "27")) {
                    return ConditionApplicationResult.CONDITION_WAS_NOT_APPLIED;
                }
                String subtype = XmlUtil.getValue((Element)elm, (String)"subtype_id");
                if ("270".equals(subtype)) {
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                RuleRestriction restr = TchXmlCommissionsImportHelper.findRestriction(rs, Properties.AGENCY_COUNTRY_CODES);
                if (restr == null) {
                    restr = new RuleRestriction();
                    restr.setProperty((RuleProperty)Properties.AGENCY_COUNTRY_CODES);
                    rs.getRestrictions().add(restr);
                }
                if (TextUtil.isBlank((String)(value = XmlUtil.getValue((Element)elm, (String)"code_value")))) {
                    value = null;
                }
                restr.setValue((Object)value);
                if ("271".equals(subtype)) {
                    restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.INCLUDE);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("272".equals(subtype)) {
                    restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.EXCLUDE);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                throw new Exception("unknown restriction on agency country: " + subtype);
            }
        }
        ,
        AGS{

            @Override
            ConditionApplicationResult update(Element elm, RuleSettings rs) throws Exception {
                if (!this.accept(elm, "63")) {
                    return ConditionApplicationResult.CONDITION_WAS_NOT_APPLIED;
                }
                String subtype = XmlUtil.getValue((Element)elm, (String)"subtype_id");
                if ("630".equals(subtype)) {
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                String value = XmlUtil.getValue((Element)elm, (String)"code_value");
                if (!TextUtil.isBlank((String)value)) {
                    while (value.indexOf(32) != -1) {
                        value = value.replace(" ", "");
                    }
                }
                if ("631".equals(subtype)) {
                    if (TextUtil.isBlank((String)value)) {
                        return ConditionApplicationResult.RULE_MUST_BE_IGNORED;
                    }
                    RuleRestriction restr = TchXmlCommissionsImportHelper.findRestriction(rs, Properties.TAX_CODES);
                    if (restr == null) {
                        restr = new RuleRestriction();
                        restr.setProperty((RuleProperty)Properties.TAX_CODES);
                        rs.getRestrictions().add(restr);
                    }
                    restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.INCLUDE);
                    restr.setValue((Object)value.toUpperCase());
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("632".equals(subtype)) {
                    if (TextUtil.isBlank((String)value)) {
                        return ConditionApplicationResult.RULE_MUST_BE_IGNORED;
                    }
                    for (String item : value.split(",")) {
                        if (TextUtil.isBlank((String)item)) continue;
                        RuleRestriction restr = new RuleRestriction();
                        restr.setProperty((RuleProperty)Properties.TAX_CODES);
                        rs.getRestrictions().add(restr);
                        restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.INCLUDE);
                        restr.setValue((Object)item.toUpperCase());
                    }
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("633".equals(subtype)) {
                    if (TextUtil.isBlank((String)value)) {
                        return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                    }
                    RuleRestriction restr = TchXmlCommissionsImportHelper.findRestriction(rs, Properties.TAX_CODES);
                    if (restr == null) {
                        restr = new RuleRestriction();
                        restr.setProperty((RuleProperty)Properties.TAX_CODES);
                        rs.getRestrictions().add(restr);
                    }
                    restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.EXCLUDE);
                    restr.setValue((Object)value.toUpperCase());
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                throw new Exception("unknown restriction on AGS");
            }
        }
        ,
        AIRLINE_PARTICIPATION{

            @Override
            ConditionApplicationResult update(Element elm, RuleSettings rs) throws Exception {
                if (!this.accept(elm, "62")) {
                    return ConditionApplicationResult.CONDITION_WAS_NOT_APPLIED;
                }
                String subtype = XmlUtil.getValue((Element)elm, (String)"subtype_id");
                if ("620".equals(subtype)) {
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                RuleRestriction carrierRestr = TchXmlCommissionsImportHelper.findRestriction(rs, Properties.CARRIERS);
                if (carrierRestr == null) {
                    return ConditionApplicationResult.RULE_MUST_BE_IGNORED;
                }
                String carrierNumber = (String)((List)carrierRestr.getValue()).get(0);
                if ("621".equals(subtype)) {
                    if (TextUtil.isBlank((String)carrierNumber)) {
                        return ConditionApplicationResult.RULE_MUST_BE_IGNORED;
                    }
                    RuleRestriction restr = new RuleRestriction();
                    restr.setProperty((RuleProperty)Properties.AIRLINES);
                    rs.getRestrictions().add(restr);
                    restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.INCLUDE);
                    restr.setValue((Object)carrierNumber);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("622".equals(subtype)) {
                    if (TextUtil.isBlank((String)carrierNumber)) {
                        return ConditionApplicationResult.RULE_MUST_BE_IGNORED;
                    }
                    RuleRestriction restr = new RuleRestriction();
                    restr.setProperty((RuleProperty)Properties.AIRLINES);
                    rs.getRestrictions().add(restr);
                    restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.EXCLUDE);
                    restr.setValue((Object)carrierNumber);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                throw new Exception("unknown restriction on airline participation: " + subtype);
            }
        }
        ,
        M2_AGREEMENT{

            @Override
            ConditionApplicationResult update(Element elm, RuleSettings rs) throws Exception {
                if (!this.accept(elm, "71")) {
                    return ConditionApplicationResult.CONDITION_WAS_NOT_APPLIED;
                }
                String subtype = XmlUtil.getValue((Element)elm, (String)"subtype_id");
                if ("710".equals(subtype)) {
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                RuleRestriction m2Restriction = TchXmlCommissionsImportHelper.findRestriction(rs, Properties.M2_AGREEMENT);
                if (m2Restriction == null) {
                    m2Restriction = new RuleRestriction();
                    m2Restriction.setProperty((RuleProperty)Properties.M2_AGREEMENT);
                    rs.getRestrictions().add(m2Restriction);
                }
                List<String> value = RulesHelper.toStringCollection(XmlUtil.getValue((Element)elm, (String)"code_value"));
                if ("711".equals(subtype)) {
                    m2Restriction.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.NO);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("712".equals(subtype)) {
                    m2Restriction.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.INCLUDE);
                    m2Restriction.setValue(value);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("713".equals(subtype)) {
                    m2Restriction.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.EXCLUDE);
                    m2Restriction.setValue(value);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("714".equals(subtype)) {
                    m2Restriction.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.ONLY_M2);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("715".equals(subtype)) {
                    m2Restriction.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.ONLY);
                    m2Restriction.setValue(value);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("716".equals(subtype)) {
                    m2Restriction.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.EXCEPT);
                    m2Restriction.setValue(value);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                throw new Exception("unknown restriction on m2 agreement: " + subtype);
            }
        }
        ,
        CODE_SHARING_PARTICIPATION{

            @Override
            ConditionApplicationResult update(Element elm, RuleSettings rs) throws Exception {
                if (!this.accept(elm, "70")) {
                    return ConditionApplicationResult.CONDITION_WAS_NOT_APPLIED;
                }
                String subtype = XmlUtil.getValue((Element)elm, (String)"subtype_id");
                if ("700".equals(subtype)) {
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                RuleRestriction carrierRestr = TchXmlCommissionsImportHelper.findRestriction(rs, Properties.CARRIERS);
                if (carrierRestr == null) {
                    return ConditionApplicationResult.RULE_MUST_BE_IGNORED;
                }
                String carrierNumber = (String)((List)carrierRestr.getValue()).get(0);
                String value = XmlUtil.getValue((Element)elm, (String)"code_value");
                if ("701".equals(subtype)) {
                    RuleRestriction restr;
                    if (TextUtil.isBlank((String)carrierNumber)) {
                        return ConditionApplicationResult.RULE_MUST_BE_IGNORED;
                    }
                    if (!TextUtil.isBlank((String)value)) {
                        restr = new RuleRestriction();
                        restr.setProperty((RuleProperty)Properties.CODE_SHARING);
                        rs.getRestrictions().add(restr);
                        restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.INCLUDE);
                        restr.setValue((Object)value);
                    } else {
                        restr = new RuleRestriction();
                        restr.setProperty((RuleProperty)Properties.CODE_SHARING);
                        rs.getRestrictions().add(restr);
                        restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.NOT_EMPTY);
                    }
                    restr = new RuleRestriction();
                    restr.setProperty((RuleProperty)Properties.OPERATING_AIRLINES);
                    rs.getRestrictions().add(restr);
                    restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.INCLUDE);
                    restr.setValue((Object)carrierNumber);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("702".equals(subtype)) {
                    RuleRestriction restr;
                    if (TextUtil.isBlank((String)carrierNumber)) {
                        return ConditionApplicationResult.RULE_MUST_BE_IGNORED;
                    }
                    if (!TextUtil.isBlank((String)value)) {
                        restr = new RuleRestriction();
                        restr.setProperty((RuleProperty)Properties.CODE_SHARING);
                        rs.getRestrictions().add(restr);
                        restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.INCLUDE);
                        restr.setValue((Object)value);
                    } else {
                        restr = new RuleRestriction();
                        restr.setProperty((RuleProperty)Properties.CODE_SHARING);
                        rs.getRestrictions().add(restr);
                        restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.NOT_EMPTY);
                    }
                    restr = new RuleRestriction();
                    restr.setProperty((RuleProperty)Properties.OPERATING_AIRLINES);
                    rs.getRestrictions().add(restr);
                    restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.EXCLUDE);
                    restr.setValue((Object)carrierNumber);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                throw new Exception("unknown restriction on airline participation: " + subtype);
            }
        }
        ,
        BOOKING_CLASSES{

            @Override
            ConditionApplicationResult update(Element elm, RuleSettings rs) throws Exception {
                if (!this.accept(elm, "34") && !this.accept(elm, "114")) {
                    return ConditionApplicationResult.CONDITION_WAS_NOT_APPLIED;
                }
                TchRouteRestrictions rr = this.getRouteRestriction(rs);
                String subtype = XmlUtil.getValue((Element)elm, (String)"subtype_id");
                if ("340".equals(subtype) || "1140".equals(subtype)) {
                    rr.setClassOfBookingRestriction(TchRouteRestrictions.ClassOfBookingRestriction.ALL);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                String value = XmlUtil.getValue((Element)elm, (String)"code_value");
                if ("341".equals(subtype) || "1141".equals(subtype)) {
                    rr.setClassOfBookingRestriction(TchRouteRestrictions.ClassOfBookingRestriction.ONLY);
                    rr.setClassOfBookingValue(value);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("342".equals(subtype) || "1142".equals(subtype)) {
                    rr.setClassOfBookingRestriction(TchRouteRestrictions.ClassOfBookingRestriction.EXCEPT);
                    rr.setClassOfBookingValue(value);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                throw new Exception("unknown restriction on booking class " + subtype);
            }
        }
        ,
        CARRIERS{

            @Override
            ConditionApplicationResult update(Element elm, RuleSettings rs) throws Exception {
                if (!this.accept(elm, "37")) {
                    return ConditionApplicationResult.CONDITION_WAS_NOT_APPLIED;
                }
                String subtype = XmlUtil.getValue((Element)elm, (String)"subtype_id");
                if ("370".equals(subtype)) {
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                RuleRestriction restr = TchXmlCommissionsImportHelper.findRestriction(rs, Properties.AIRLINES);
                if (restr == null) {
                    restr = new RuleRestriction();
                    restr.setProperty((RuleProperty)Properties.AIRLINES);
                    rs.getRestrictions().add(restr);
                }
                if ("371".equals(subtype)) {
                    restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.INCLUDE);
                    String value = XmlUtil.getValue((Element)elm, (String)"code_value");
                    restr.setValue((Object)value);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                throw new Exception("unknown restriction on carrier: " + subtype);
            }
        }
        ,
        CODE_SHARING{

            @Override
            ConditionApplicationResult update(Element elm, RuleSettings rs) throws Exception {
                if (!this.accept(elm, "65")) {
                    return ConditionApplicationResult.CONDITION_WAS_NOT_APPLIED;
                }
                String subtype = XmlUtil.getValue((Element)elm, (String)"subtype_id");
                if ("650".equals(subtype)) {
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                RuleRestriction restr = new RuleRestriction();
                restr.setProperty((RuleProperty)Properties.CODE_SHARING);
                rs.getRestrictions().add(restr);
                if ("651".equals(subtype)) {
                    restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.NOT_SET);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                List<String> value = RulesHelper.toStringCollection(XmlUtil.getValue((Element)elm, (String)"code_value"));
                restr.setValue(value);
                if ("652".equals(subtype)) {
                    restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.NOT_SET_OR_INCLUDE);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("653".equals(subtype)) {
                    restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.INCLUDE);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("654".equals(subtype)) {
                    restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.NOT_SET_OR_EXCLUDE);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("655".equals(subtype)) {
                    restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.EXCLUDE);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("656".equals(subtype)) {
                    restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.NOT_EMPTY);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                throw new Exception("unknown restriction on code sharing: " + subtype);
            }
        }
        ,
        DEPARTURE_DATE{

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            ConditionApplicationResult update(Element elm, RuleSettings rs) throws Exception {
                if (!this.accept(elm, "33")) {
                    return ConditionApplicationResult.CONDITION_WAS_NOT_APPLIED;
                }
                TchRouteRestrictions rr = this.getRouteRestriction(rs);
                String subtype = XmlUtil.getValue((Element)elm, (String)"subtype_id");
                if ("330".equals(subtype)) {
                    rr.setDepartureDatesRestriction(TchRouteRestrictions.DepartureDatesRestriction.ALL);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                String value = XmlUtil.getValue((Element)elm, (String)"code_value");
                if ("331".equals(subtype)) {
                    rr.setDepartureDatesRestriction(TchRouteRestrictions.DepartureDatesRestriction.ONLY);
                    SimpleDateFormat simpleDateFormat = sdf;
                    synchronized (simpleDateFormat) {
                        rr.setDepartureDatesFromValue(MiscUtil.clearTime((Date)sdf.parse(value)));
                        rr.setDepartureDatesToValue(MiscUtil.setDayEndTime((Date)sdf.parse(value)));
                    }
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("332".equals(subtype)) {
                    rr.setDepartureDatesRestriction(TchRouteRestrictions.DepartureDatesRestriction.EXCEPT);
                    SimpleDateFormat simpleDateFormat = sdf;
                    synchronized (simpleDateFormat) {
                        rr.setDepartureDatesFromValue(MiscUtil.clearTime((Date)sdf.parse(value)));
                        rr.setDepartureDatesToValue(MiscUtil.setDayEndTime((Date)sdf.parse(value)));
                    }
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("333".equals(subtype)) {
                    rr.setDepartureDatesRestriction(TchRouteRestrictions.DepartureDatesRestriction.ONLY);
                    String[] values = value.split("-");
                    SimpleDateFormat simpleDateFormat = sdf;
                    synchronized (simpleDateFormat) {
                        rr.setDepartureDatesFromValue(MiscUtil.clearTime((Date)sdf.parse(values[0])));
                        rr.setDepartureDatesToValue(MiscUtil.setDayEndTime((Date)sdf.parse(values[1])));
                    }
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("334".equals(subtype)) {
                    rr.setDepartureDatesRestriction(TchRouteRestrictions.DepartureDatesRestriction.EXCEPT);
                    String[] values = value.split("-");
                    SimpleDateFormat simpleDateFormat = sdf;
                    synchronized (simpleDateFormat) {
                        rr.setDepartureDatesFromValue(MiscUtil.clearTime((Date)sdf.parse(values[0])));
                        rr.setDepartureDatesToValue(MiscUtil.setDayEndTime((Date)sdf.parse(values[1])));
                    }
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("335".equals(subtype)) {
                    String[] stringArray;
                    rr.setDepartureDatesRestriction(TchRouteRestrictions.DepartureDatesRestriction.CONSIST_OF);
                    if (value.contains("-")) {
                        stringArray = value.split("-");
                    } else {
                        String[] stringArray2 = new String[2];
                        stringArray2[0] = value;
                        stringArray = stringArray2;
                        stringArray2[1] = value;
                    }
                    String[] values = stringArray;
                    SimpleDateFormat simpleDateFormat = sdf;
                    synchronized (simpleDateFormat) {
                        rr.setDepartureDatesFromValue(MiscUtil.clearTime((Date)sdf.parse(values[0])));
                        rr.setDepartureDatesToValue(MiscUtil.setDayEndTime((Date)sdf.parse(values[1])));
                    }
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                throw new Exception("unknown restriction on departure date " + subtype);
            }
        }
        ,
        DEPARTURE_DAY{

            @Override
            ConditionApplicationResult update(Element elm, RuleSettings rs) throws Exception {
                if (!this.accept(elm, "36")) {
                    return ConditionApplicationResult.CONDITION_WAS_NOT_APPLIED;
                }
                TchRouteRestrictions rr = this.getRouteRestriction(rs);
                String subtype = XmlUtil.getValue((Element)elm, (String)"subtype_id");
                if ("360".equals(subtype)) {
                    rr.setDepartureDaysRestriction(TchRouteRestrictions.DepartureDaysRestriction.ALL);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                String value = XmlUtil.getValue((Element)elm, (String)"code_value");
                if ("361".equals(subtype)) {
                    rr.setDepartureDaysRestriction(TchRouteRestrictions.DepartureDaysRestriction.ONLY);
                    rr.setDepartureDaysValue(value);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("362".equals(subtype)) {
                    rr.setDepartureDaysRestriction(TchRouteRestrictions.DepartureDaysRestriction.EXCEPT);
                    rr.setDepartureDaysValue(value);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                throw new Exception("unknown restriction on departure day of week " + subtype);
            }
        }
        ,
        E_TICKET{

            @Override
            ConditionApplicationResult update(Element elm, RuleSettings rs) throws Exception {
                if (!this.accept(elm, "60")) {
                    return ConditionApplicationResult.CONDITION_WAS_NOT_APPLIED;
                }
                String subtype = XmlUtil.getValue((Element)elm, (String)"subtype_id");
                if ("600".equals(subtype)) {
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                RuleRestriction restr = TchXmlCommissionsImportHelper.findRestriction(rs, Properties.E_TICKET);
                if (restr == null) {
                    restr = new RuleRestriction();
                    restr.setProperty((RuleProperty)Properties.E_TICKET);
                    rs.getRestrictions().add(restr);
                }
                if ("601".equals(subtype)) {
                    restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.EQUALS);
                    restr.setValue((Object)Boolean.TRUE);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("602".equals(subtype)) {
                    restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.EQUALS);
                    restr.setValue((Object)Boolean.FALSE);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                throw new Exception("unknown restriction on ticket type: " + subtype);
            }
        }
        ,
        FLIGHTS{

            @Override
            ConditionApplicationResult update(Element elm, RuleSettings rs) throws Exception {
                if (!this.accept(elm, "32") && !this.accept(elm, "113")) {
                    return ConditionApplicationResult.CONDITION_WAS_NOT_APPLIED;
                }
                TchRouteRestrictions rr = this.getRouteRestriction(rs);
                String subtype = XmlUtil.getValue((Element)elm, (String)"subtype_id");
                String value = XmlUtil.getValue((Element)elm, (String)"code_value");
                if ("320".equals(subtype) || "1130".equals(subtype)) {
                    rr.setFlightNumbersRestriction(TchRouteRestrictions.FlightNumbersRestriction.ALL);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("321".equals(subtype) || "1131".equals(subtype)) {
                    rr.setFlightNumbersRestriction(TchRouteRestrictions.FlightNumbersRestriction.ONLY);
                    rr.setFlightNumbersValue(value);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("322".equals(subtype) || "1132".equals(subtype)) {
                    rr.setFlightNumbersRestriction(TchRouteRestrictions.FlightNumbersRestriction.EXCEPT);
                    rr.setFlightNumbersValue(value);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("323".equals(subtype)) {
                    rr.setFlightNumbersRestriction(TchRouteRestrictions.FlightNumbersRestriction.CONSIST_OF);
                    rr.setFlightNumbersValue(value);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("324".equals(subtype)) {
                    rr.setFlightNumbersRestriction(TchRouteRestrictions.FlightNumbersRestriction.IN_RANGE);
                    rr.setFlightNumbersValue(value);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                throw new Exception("unknown restriction on flight " + subtype);
            }
        }
        ,
        INTERLINE{

            @Override
            ConditionApplicationResult update(Element elm, RuleSettings rs) throws Exception {
                if (!this.accept(elm, "30")) {
                    return ConditionApplicationResult.CONDITION_WAS_NOT_APPLIED;
                }
                String subtype = XmlUtil.getValue((Element)elm, (String)"subtype_id");
                if ("305".equals(subtype)) {
                    RuleRestriction rr = TchXmlCommissionsImportHelper.findRestriction(rs, Properties.INTERLINE);
                    if (rr == null) {
                        rr = new RuleRestriction();
                        rr.setProperty((RuleProperty)Properties.INTERLINE);
                        rs.getRestrictions().add(rr);
                    }
                    rr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.INTERLINE);
                    rr.setValue(null);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                TchRouteRestrictions rr = this.getRouteRestriction(rs);
                String value = XmlUtil.getValue((Element)elm, (String)"code_value");
                if ("300".equals(subtype)) {
                    rr.setInterlineRestriction(TchRouteRestrictions.InterlineRestriction.NONE);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("301".equals(subtype)) {
                    rr.setInterlineRestriction(TchRouteRestrictions.InterlineRestriction.INCLUDING);
                    rr.setInterlineValue(value);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("302".equals(subtype)) {
                    rr.setInterlineRestriction(TchRouteRestrictions.InterlineRestriction.ONLY);
                    rr.setInterlineValue(value);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("303".equals(subtype)) {
                    rr.setInterlineRestriction(TchRouteRestrictions.InterlineRestriction.ALL);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("304".equals(subtype)) {
                    rr.setInterlineRestriction(TchRouteRestrictions.InterlineRestriction.EXCLUDING);
                    rr.setInterlineValue(value);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("306".equals(subtype)) {
                    rr.setInterlineRestriction(TchRouteRestrictions.InterlineRestriction.NOT_OWN_AND_ONLY);
                    rr.setInterlineValue(value);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                throw new Exception("unknown restriction on interline " + subtype);
            }
        }
        ,
        ORGANIZATION{

            private List<PassengerStatus> getPassengerStatuses(String value) {
                if (TextUtil.isBlank((String)value)) {
                    return Collections.emptyList();
                }
                ArrayList<PassengerStatus> result = new ArrayList<PassengerStatus>();
                for (String item : value.split(",")) {
                    if (TextUtil.isBlank((String)item)) continue;
                    if ("\u0432\u0432".equals(item = item.trim().toLowerCase(new Locale("ru"))) && !result.contains(PassengerStatus.VS_MVD)) {
                        result.add(PassengerStatus.VS_MVD);
                        continue;
                    }
                    if ("\u0432\u043d".equals(item) && !result.contains(PassengerStatus.VS_MO)) {
                        result.add(PassengerStatus.VS_MO);
                        continue;
                    }
                    if ("\u0447\u0441".equals(item) && !result.contains(PassengerStatus.MCHS)) {
                        result.add(PassengerStatus.MCHS);
                        continue;
                    }
                    if ("\u0444\u0441".equals(item) && !result.contains(PassengerStatus.FOND_STRAX)) {
                        result.add(PassengerStatus.FOND_STRAX);
                        continue;
                    }
                    if ("\u043f\u0444".equals(item) && !result.contains(PassengerStatus.PENS_FOND)) {
                        result.add(PassengerStatus.PENS_FOND);
                        continue;
                    }
                    if ("\u0433\u0434".equals(item) && !result.contains(PassengerStatus.DEP_GD)) {
                        result.add(PassengerStatus.DEP_GD);
                        continue;
                    }
                    if ("\u0434\u0435".equals(item) && !result.contains(PassengerStatus.INV_1_GROUP)) {
                        result.add(PassengerStatus.INV_1_GROUP);
                        continue;
                    }
                    if ("\u0434\u0441".equals(item) && !result.contains(PassengerStatus.SUD)) {
                        result.add(PassengerStatus.SUD);
                        continue;
                    }
                    if (!"\u0434\u0444".equals(item) || result.contains(PassengerStatus.SOV_FED)) continue;
                    result.add(PassengerStatus.SOV_FED);
                }
                return result;
            }

            @Override
            ConditionApplicationResult update(Element elm, RuleSettings rs) throws Exception {
                if (!this.accept(elm, "39")) {
                    return ConditionApplicationResult.CONDITION_WAS_NOT_APPLIED;
                }
                String subtype = XmlUtil.getValue((Element)elm, (String)"subtype_id");
                if ("390".equals(subtype)) {
                    List<PassengerStatus> statuses = this.getPassengerStatuses("\u0412\u041d,\u0412\u0412,\u0427\u0421,\u041f\u0424,\u0424\u0421");
                    RuleRestriction restr = TchXmlCommissionsImportHelper.findRestriction(rs, Properties.PASSENGER_STATUS);
                    if (restr == null) {
                        restr = new RuleRestriction();
                        restr.setProperty((RuleProperty)Properties.PASSENGER_STATUS);
                        rs.getRestrictions().add(restr);
                    }
                    restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.NOT_EQUALS);
                    restr.setValue(statuses);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("391".equals(subtype)) {
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                List<PassengerStatus> statuses = this.getPassengerStatuses(XmlUtil.getValue((Element)elm, (String)"code_value"));
                if ("392".equals(subtype)) {
                    if (statuses.isEmpty()) {
                        return ConditionApplicationResult.RULE_MUST_BE_IGNORED;
                    }
                    RuleRestriction restr = TchXmlCommissionsImportHelper.findRestriction(rs, Properties.PASSENGER_STATUS);
                    if (restr == null) {
                        restr = new RuleRestriction();
                        restr.setProperty((RuleProperty)Properties.PASSENGER_STATUS);
                        rs.getRestrictions().add(restr);
                    }
                    restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.EQUALS);
                    restr.setValue(statuses);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("393".equals(subtype)) {
                    if (statuses.isEmpty()) {
                        return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                    }
                    RuleRestriction restr = TchXmlCommissionsImportHelper.findRestriction(rs, Properties.PASSENGER_STATUS);
                    if (restr == null) {
                        restr = new RuleRestriction();
                        restr.setProperty((RuleProperty)Properties.PASSENGER_STATUS);
                        rs.getRestrictions().add(restr);
                    }
                    restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.NOT_EQUALS);
                    restr.setValue(statuses);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                throw new Exception("unknown restriction on organization code: " + subtype);
            }
        }
        ,
        REPORT_CURRENCY{

            @Override
            ConditionApplicationResult update(Element elm, RuleSettings rs) throws Exception {
                if (!this.accept(elm, "61")) {
                    return ConditionApplicationResult.CONDITION_WAS_NOT_APPLIED;
                }
                String subtype = XmlUtil.getValue((Element)elm, (String)"subtype_id");
                if ("610".equals(subtype)) {
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("611".equals(subtype)) {
                    String value = XmlUtil.getValue((Element)elm, (String)"code_value");
                    return "\u0420\u0423\u0411".equals(value) || "RUB".equals(value) ? ConditionApplicationResult.CONDITION_WAS_APPLIED : ConditionApplicationResult.RULE_MUST_BE_IGNORED;
                }
                throw new Exception("unknown restriction on report currency: " + subtype);
            }
        }
        ,
        RESERVATION{

            private List<ReservationType> getReservationTypes(String value) {
                if (TextUtil.isBlank((String)value)) {
                    return Collections.emptyList();
                }
                ArrayList<ReservationType> result = new ArrayList<ReservationType>();
                for (String item : value.split(",")) {
                    if (TextUtil.isBlank((String)item)) continue;
                    if ("clc".equals(item = item.trim().toLowerCase()) && !result.contains(ReservationType.OFFLINE)) {
                        result.add(ReservationType.OFFLINE);
                    }
                    if (!"int".equals(item) || result.contains(ReservationType.IBE)) continue;
                    result.add(ReservationType.IBE);
                }
                return result;
            }

            @Override
            ConditionApplicationResult update(Element elm, RuleSettings rs) throws Exception {
                if (!this.accept(elm, "38")) {
                    return ConditionApplicationResult.CONDITION_WAS_NOT_APPLIED;
                }
                String subtype = XmlUtil.getValue((Element)elm, (String)"subtype_id");
                if ("380".equals(subtype)) {
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                List<ReservationType> types = this.getReservationTypes(XmlUtil.getValue((Element)elm, (String)"code_value"));
                if ("381".equals(subtype)) {
                    if (types.isEmpty()) {
                        return ConditionApplicationResult.RULE_MUST_BE_IGNORED;
                    }
                    RuleRestriction restr = TchXmlCommissionsImportHelper.findRestriction(rs, Properties.RESERVATION_TYPE);
                    if (restr == null) {
                        restr = new RuleRestriction();
                        restr.setProperty((RuleProperty)Properties.RESERVATION_TYPE);
                        rs.getRestrictions().add(restr);
                    }
                    restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.EQUALS);
                    restr.setValue(types);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("382".equals(subtype)) {
                    if (types.isEmpty()) {
                        return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                    }
                    RuleRestriction restr = TchXmlCommissionsImportHelper.findRestriction(rs, Properties.RESERVATION_TYPE);
                    if (restr == null) {
                        restr = new RuleRestriction();
                        restr.setProperty((RuleProperty)Properties.RESERVATION_TYPE);
                        rs.getRestrictions().add(restr);
                    }
                    restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.NOT_EQUALS);
                    restr.setValue(types);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                throw new Exception("unknown restriction on reservation: " + subtype);
            }
        }
        ,
        ROUTES{

            @Override
            ConditionApplicationResult update(Element elm, RuleSettings rs) throws Exception {
                if (!(this.accept(elm, "31") || this.accept(elm, "55") || this.accept(elm, "112"))) {
                    return ConditionApplicationResult.CONDITION_WAS_NOT_APPLIED;
                }
                TchRouteRestrictions rr = this.getRouteRestriction(rs);
                String subtype = XmlUtil.getValue((Element)elm, (String)"subtype_id");
                String value = XmlUtil.getValue((Element)elm, (String)"code_value");
                if (!TextUtil.isBlank((String)value)) {
                    value = value.replace("\u0421\u0442\u0440:", "");
                }
                if ("310".equals(subtype) || "550".equals(subtype) || "1120".equals(subtype)) {
                    rr.setRouteRestriction(TchRouteRestrictions.RouteRestriction.ALL);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("311".equals(subtype) || "551".equals(subtype) || "1121".equals(subtype)) {
                    rr.setRouteRestriction(TchRouteRestrictions.RouteRestriction.ONLY);
                    rr.setRouteValue(value);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("312".equals(subtype) || "552".equals(subtype) || "1122".equals(subtype)) {
                    rr.setRouteRestriction(TchRouteRestrictions.RouteRestriction.EXCEPT);
                    rr.setRouteValue(value);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("313".equals(subtype) || "553".equals(subtype) || "1123".equals(subtype)) {
                    rr.setRouteRestriction(TchRouteRestrictions.RouteRestriction.START);
                    rr.setRouteValue(value);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("314".equals(subtype)) {
                    rr.setRouteRestriction(TchRouteRestrictions.RouteRestriction.START);
                    rr.setRouteValue(value);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("315".equals(subtype)) {
                    rr.setRouteRestriction(TchRouteRestrictions.RouteRestriction.NOT_START_FROM);
                    rr.setRouteValue(value);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("316".equals(subtype)) {
                    rr.setRouteRestriction(TchRouteRestrictions.RouteRestriction.CONSIST_OF);
                    rr.setRouteValue(value);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("317".equals(subtype)) {
                    rr.setRouteRestriction(TchRouteRestrictions.RouteRestriction.END_AT);
                    rr.setRouteValue(value);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("318".equals(subtype)) {
                    rr.setRouteRestriction(TchRouteRestrictions.RouteRestriction.NOT_END_AT);
                    rr.setRouteValue(value);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                throw new Exception("unknown restriction on route " + subtype);
            }
        }
        ,
        TARIFF_CODE{

            @Override
            ConditionApplicationResult update(Element elm, RuleSettings rs) throws Exception {
                if (!this.accept(elm, "35") && !this.accept(elm, "54")) {
                    return ConditionApplicationResult.CONDITION_WAS_NOT_APPLIED;
                }
                String subtype = XmlUtil.getValue((Element)elm, (String)"subtype_id");
                if ("355".equals(subtype) || "356".equals(subtype)) {
                    RuleRestriction restr = TchXmlCommissionsImportHelper.findRestriction(rs, Properties.TOUR_CODE);
                    if (restr == null) {
                        restr = new RuleRestriction();
                        restr.setProperty((RuleProperty)Properties.TOUR_CODE);
                        rs.getRestrictions().add(restr);
                    }
                    List<String> value = RulesHelper.toStringCollection(XmlUtil.getValue((Element)elm, (String)"code_value"));
                    if ("355".equals(subtype)) {
                        restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.EQUALS);
                    } else {
                        restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.NOT_EQUALS);
                    }
                    restr.setValue(value);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                TchRouteRestrictions rr = this.getRouteRestriction(rs);
                if ("350".equals(subtype) || "540".equals(subtype)) {
                    rr.setTariffCodeRestriction(TchRouteRestrictions.TariffCodeRestriction.ALL);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                String value = XmlUtil.getValue((Element)elm, (String)"code_value");
                if ("351".equals(subtype) || "541".equals(subtype)) {
                    rr.setTariffCodeRestriction(TchRouteRestrictions.TariffCodeRestriction.ONLY);
                    rr.setTariffCodeValue(value);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("352".equals(subtype) || "542".equals(subtype)) {
                    rr.setTariffCodeRestriction(TchRouteRestrictions.TariffCodeRestriction.EXCEPT);
                    rr.setTariffCodeValue(value);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("353".equals(subtype) || "543".equals(subtype)) {
                    rr.setTariffCodeRestriction(TchRouteRestrictions.TariffCodeRestriction.INCLUDE);
                    rr.setTariffCodeValue(value);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("354".equals(subtype) || "544".equals(subtype)) {
                    rr.setTariffCodeRestriction(TchRouteRestrictions.TariffCodeRestriction.NOT_INCLUDE);
                    rr.setTariffCodeValue(value);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                throw new Exception("unknown restriction on tariff code " + subtype);
            }
        }
        ,
        TRANSPORTATION_TYPE{

            @Override
            ConditionApplicationResult update(Element elm, RuleSettings rs) throws Exception {
                String value;
                if (!(this.accept(elm, "10") || this.accept(elm, "51") || this.accept(elm, "111"))) {
                    return ConditionApplicationResult.CONDITION_WAS_NOT_APPLIED;
                }
                String subtype = XmlUtil.getValue((Element)elm, (String)"subtype_id");
                if ("100".equals(subtype) || "510".equals(subtype) || "1110".equals(subtype)) {
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                RuleRestriction restr = TchXmlCommissionsImportHelper.findRestriction(rs, Properties.TRANSPORTATION_TYPE);
                if (restr == null) {
                    restr = new RuleRestriction();
                    restr.setProperty((RuleProperty)Properties.TRANSPORTATION_TYPE);
                    rs.getRestrictions().add(restr);
                }
                if (TextUtil.isBlank((String)(value = XmlUtil.getValue((Element)elm, (String)"code_value")))) {
                    value = null;
                }
                restr.setValue((Object)value);
                if ("101".equals(subtype) || "511".equals(subtype) || "1111".equals(subtype)) {
                    restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.TRANSPORTATION_OUTSIDE_CIS);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("102".equals(subtype) || "512".equals(subtype) || "1112".equals(subtype)) {
                    restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.TRANSPORTATION_INSIDE_CIS);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("103".equals(subtype) || "513".equals(subtype) || "1113".equals(subtype)) {
                    restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.TRANSPORTATION_INSIDE_COUNTRY);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("104".equals(subtype) || "514".equals(subtype) || "1114".equals(subtype)) {
                    restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.TRANSPORTATION_OUTSIDE_COUNTRY);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                throw new Exception("unknown restriction on transportation type: " + subtype);
            }
        }
        ,
        VALIDATORS{

            @Override
            ConditionApplicationResult update(Element elm, RuleSettings rs) throws Exception {
                String value;
                if (!this.accept(elm, "21") && !this.accept(elm, "41")) {
                    return ConditionApplicationResult.CONDITION_WAS_NOT_APPLIED;
                }
                String subtype = XmlUtil.getValue((Element)elm, (String)"subtype_id");
                if ("210".equals(subtype) || "410".equals(subtype)) {
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                RuleRestriction restr = TchXmlCommissionsImportHelper.findRestriction(rs, Properties.VALIDATOR);
                if (restr == null) {
                    restr = new RuleRestriction();
                    restr.setProperty((RuleProperty)Properties.VALIDATOR);
                    rs.getRestrictions().add(restr);
                }
                if (TextUtil.isBlank((String)(value = XmlUtil.getValue((Element)elm, (String)"code_value")))) {
                    value = null;
                }
                restr.setValue((Object)value);
                if ("211".equals(subtype) || "411".equals(subtype)) {
                    restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.EQUALS);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("212".equals(subtype) || "412".equals(subtype)) {
                    restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.NOT_EQUALS);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                throw new Exception("unknown restriction on sales point: " + subtype);
            }
        }
        ,
        DIRECTION{

            @Override
            ConditionApplicationResult update(Element elm, RuleSettings rs) throws Exception {
                if (!this.accept(elm, "29")) {
                    return ConditionApplicationResult.CONDITION_WAS_NOT_APPLIED;
                }
                String subtype = XmlUtil.getValue((Element)elm, (String)"subtype_id");
                if ("290".equals(subtype)) {
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("291".equals(subtype) || "292".equals(subtype)) {
                    RuleRestriction restr = new RuleRestriction();
                    restr.setProperty((RuleProperty)Properties.ROUTE);
                    restr.setCondition((RuleCondition)("291".equals(subtype) ? com.gridnine.xtrip.common.model.rules.standard.Conditions.BEGINS_WITH : com.gridnine.xtrip.common.model.rules.standard.Conditions.NOT_BEGINS_WITH));
                    String value = XmlUtil.getValue((Element)elm, (String)"code_value");
                    value = value.replace("\u0421\u0442\u0440:", "");
                    restr.setValue(RulesHelper.toStringCollection(value));
                    rs.getRestrictions().add(restr);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("293".equals(subtype) || "294".equals(subtype)) {
                    RuleRestriction restr = new RuleRestriction();
                    restr.setProperty((RuleProperty)Properties.LAST_ROUTE_POINT);
                    restr.setCondition((RuleCondition)("293".equals(subtype) ? com.gridnine.xtrip.common.model.rules.standard.Conditions.INCLUDE : com.gridnine.xtrip.common.model.rules.standard.Conditions.EXCLUDE));
                    String value = XmlUtil.getValue((Element)elm, (String)"code_value");
                    value = value.replace("\u0421\u0442\u0440:", "");
                    restr.setValue(RulesHelper.toStringCollection(value));
                    rs.getRestrictions().add(restr);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                throw new Exception("unknown restriction on direction: " + subtype);
            }
        }
        ,
        SALES_POINT_COUNTRY_CODES{

            @Override
            ConditionApplicationResult update(Element elm, RuleSettings rs) throws Exception {
                String value;
                if (!this.accept(elm, "26")) {
                    return ConditionApplicationResult.CONDITION_WAS_NOT_APPLIED;
                }
                String subtype = XmlUtil.getValue((Element)elm, (String)"subtype_id");
                if ("260".equals(subtype)) {
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                RuleRestriction restr = TchXmlCommissionsImportHelper.findRestriction(rs, Properties.SALES_POINT_COUNTRY_CODES);
                if (restr == null) {
                    restr = new RuleRestriction();
                    restr.setProperty((RuleProperty)Properties.SALES_POINT_COUNTRY_CODES);
                    rs.getRestrictions().add(restr);
                }
                if (TextUtil.isBlank((String)(value = XmlUtil.getValue((Element)elm, (String)"code_value")))) {
                    value = null;
                }
                restr.setValue((Object)value);
                if ("261".equals(subtype)) {
                    restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.INCLUDE);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("262".equals(subtype)) {
                    restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.EXCLUDE);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                throw new Exception("unknown restriction on sales point country: " + subtype);
            }
        }
        ,
        VAT{

            @Override
            ConditionApplicationResult update(Element elm, RuleSettings rs) throws Exception {
                if (!this.accept(elm, "23")) {
                    return ConditionApplicationResult.CONDITION_WAS_NOT_APPLIED;
                }
                String subtype = XmlUtil.getValue((Element)elm, (String)"subtype_id");
                if ("230".equals(subtype)) {
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                RuleRestriction restr = TchXmlCommissionsImportHelper.findRestriction(rs, Properties.VAT);
                if (restr == null) {
                    restr = new RuleRestriction();
                    restr.setProperty((RuleProperty)Properties.VAT);
                    rs.getRestrictions().add(restr);
                }
                if ("231".equals(subtype)) {
                    restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.NOT_SIMPLE_TAXED);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("232".equals(subtype)) {
                    restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.SIMPLE_TAXED);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                throw new Exception("unknown restriction on VAT: " + subtype);
            }
        }
        ,
        ADDITIONAL_SERVICE_CODE{

            @Override
            ConditionApplicationResult update(Element elm, RuleSettings rs) throws Exception {
                if (!this.accept(elm, "66")) {
                    return ConditionApplicationResult.CONDITION_WAS_NOT_APPLIED;
                }
                String subtype = XmlUtil.getValue((Element)elm, (String)"subtype_id");
                if ("660".equals(subtype)) {
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                RuleRestriction restr = TchXmlCommissionsImportHelper.findRestriction(rs, Properties.TCH_ADDITIONAL_SERVICE_CODES);
                if (restr == null) {
                    restr = new RuleRestriction();
                    restr.setProperty((RuleProperty)Properties.TCH_ADDITIONAL_SERVICE_CODES);
                    rs.getRestrictions().add(restr);
                }
                String value = XmlUtil.getValue((Element)elm, (String)"code_value");
                restr.setValue(RulesHelper.toStringCollection(value));
                if ("661".equals(subtype)) {
                    restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.INCLUDE);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("662".equals(subtype)) {
                    restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.TCH_SERVICE_TYPE_ADDITIONAL_SERVICES);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                throw new Exception("\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0435 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u043d\u0430 \u041a\u043e\u0434 \u0434\u043e\u043f.\u0443\u0441\u043b\u0443\u0433\u0438: " + subtype);
            }
        }
        ,
        SERVICE_TYPE{

            @Override
            ConditionApplicationResult update(Element elm, RuleSettings rs) throws Exception {
                String subtype;
                if (!this.accept(elm, "5")) {
                    return ConditionApplicationResult.CONDITION_WAS_NOT_APPLIED;
                }
                RuleRestriction restr = TchXmlCommissionsImportHelper.findRestriction(rs, Properties.TCH_SERVICE_TYPE);
                if (restr == null) {
                    restr = new RuleRestriction();
                    restr.setProperty((RuleProperty)Properties.TCH_SERVICE_TYPE);
                    rs.getRestrictions().add(restr);
                }
                if ("50".equals(subtype = XmlUtil.getValue((Element)elm, (String)"subtype_id"))) {
                    restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.TCH_SERVICE_TYPE_AIR_TICKETS);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("51".equals(subtype)) {
                    restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.TCH_SERVICE_TYPE_ADDITIONAL_SERVICES);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("52".equals(subtype)) {
                    return ConditionApplicationResult.RULE_MUST_BE_IGNORED;
                }
                if ("53".equals(subtype)) {
                    restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.TCH_SERVICE_TYPE_ADDITIONAL_SERVICES_AND_LUGGAGE);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                throw new Exception("\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0435 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u043d\u0430 \u0422\u0438\u043f \u0443\u0441\u043b\u0443\u0433\u0438: " + subtype);
            }
        }
        ,
        ERSP_CODE{

            @Override
            ConditionApplicationResult update(Element elm, RuleSettings rs) throws Exception {
                if (!this.accept(elm, "68")) {
                    return ConditionApplicationResult.CONDITION_WAS_NOT_APPLIED;
                }
                String subtype = XmlUtil.getValue((Element)elm, (String)"subtype_id");
                if ("680".equals(subtype)) {
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                RuleRestriction restr = TchXmlCommissionsImportHelper.findRestriction(rs, Properties.TCH_ERSP_CODE);
                if (restr == null) {
                    restr = new RuleRestriction();
                    restr.setProperty((RuleProperty)Properties.TCH_ERSP_CODE);
                    rs.getRestrictions().add(restr);
                }
                if ("681".equals(subtype)) {
                    restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.NOT_EMPTY);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("684".equals(subtype)) {
                    restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.NOT_SET);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                String value = XmlUtil.getValue((Element)elm, (String)"code_value");
                restr.setValue(RulesHelper.toStringCollection(value));
                if ("682".equals(subtype)) {
                    restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.INCLUDE);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("683".equals(subtype)) {
                    restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.EXCLUDE);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                throw new Exception("\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0435 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u043d\u0430 \u041a\u043e\u0434 \u0418\u043d\u0442\u0435\u0440\u043d\u0435\u0442 \u041f\u041f\u0440: " + subtype);
            }
        }
        ,
        SERVICE_CODE{

            @Override
            ConditionApplicationResult update(Element elm, RuleSettings rs) throws Exception {
                if (!this.accept(elm, "69")) {
                    return ConditionApplicationResult.CONDITION_WAS_NOT_APPLIED;
                }
                String subtype = XmlUtil.getValue((Element)elm, (String)"subtype_id");
                if ("690".equals(subtype)) {
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                RuleRestriction restr = TchXmlCommissionsImportHelper.findRestriction(rs, Properties.TCH_SERVICE_CODES);
                if (restr == null) {
                    restr = new RuleRestriction();
                    restr.setProperty((RuleProperty)Properties.TCH_SERVICE_CODES);
                    rs.getRestrictions().add(restr);
                }
                String value = XmlUtil.getValue((Element)elm, (String)"code_value");
                restr.setValue(RulesHelper.toStringCollection(value));
                if ("691".equals(subtype)) {
                    restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.INCLUDE);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("692".equals(subtype)) {
                    restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.EXCLUDE);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                throw new Exception("\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0435 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u043d\u0430 \u041a\u043e\u0434 \u0443\u0441\u043b\u0443\u0433\u0438: " + subtype);
            }
        }
        ,
        GDS_CODE{

            @Override
            ConditionApplicationResult update(Element elm, RuleSettings rs) throws Exception {
                RuleRestriction restr;
                if (!this.accept(elm, "64")) {
                    return ConditionApplicationResult.CONDITION_WAS_NOT_APPLIED;
                }
                String subtype = XmlUtil.getValue((Element)elm, (String)"subtype_id");
                if ("640".equals(subtype)) {
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                String value = XmlUtil.getValue((Element)elm, (String)"code_value");
                HashSet<GdsName> hSet = new HashSet<GdsName>();
                if (!TextUtil.isBlank((String)value)) {
                    for (String item : value.split(",")) {
                        if (TextUtil.isBlank((String)item)) continue;
                        if ("1S".equals(item = item.trim().toUpperCase())) {
                            hSet.add(GdsName.SABRE);
                            continue;
                        }
                        if (!"\u0413\u0420\u0421".equals(item) && !"\u0418\u041a\u0422".equals(item) && !"\u0422\u042e\u041c".equals(item) && !"\u0422\u042e\u0426".equals(item) && !"\u0425\u0411\u0420".equals(item)) continue;
                        hSet.add(GdsName.SIRENA);
                    }
                }
                ArrayList result = new ArrayList(hSet);
                if (hSet.isEmpty()) {
                    if ("641".equals(subtype)) {
                        return ConditionApplicationResult.RULE_MUST_BE_IGNORED;
                    }
                    if ("642".equals(subtype)) {
                        return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                    }
                }
                if ((restr = TchXmlCommissionsImportHelper.findRestriction(rs, Properties.GDS_NAME)) == null) {
                    restr = new RuleRestriction();
                    restr.setProperty((RuleProperty)Properties.GDS_NAME);
                    rs.getRestrictions().add(restr);
                }
                if ("641".equals(subtype)) {
                    restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.EQUALS);
                    restr.setValue(result);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                if ("642".equals(subtype)) {
                    restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.NOT_EQUALS);
                    restr.setValue(result);
                    return ConditionApplicationResult.CONDITION_WAS_APPLIED;
                }
                throw new Exception("unknown restriction on reservation system codes: " + subtype);
            }
        };


        boolean accept(Element elm, String string) {
            return string.equals(XmlUtil.getValue((Element)elm, (String)"type_id"));
        }

        TchRouteRestrictions getRouteRestriction(RuleSettings rs) {
            RuleRestriction restr = TchXmlCommissionsImportHelper.findRestriction(rs, Properties.TCH_ROUTE);
            if (restr == null) {
                restr = new RuleRestriction();
                restr.setProperty((RuleProperty)Properties.TCH_ROUTE);
                restr.setCondition((RuleCondition)com.gridnine.xtrip.common.model.rules.standard.Conditions.TCH_ROUTE_ALL);
                restr.setValue((Object)new TchRouteRestrictions());
                rs.getRestrictions().add(restr);
            }
            return (TchRouteRestrictions)restr.getValue();
        }

        abstract ConditionApplicationResult update(Element var1, RuleSettings var2) throws Exception;
    }

    static enum ConditionApplicationResult {
        CONDITION_WAS_APPLIED,
        CONDITION_WAS_NOT_APPLIED,
        RULE_MUST_BE_IGNORED;

    }
}

