/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.standard;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.RulePropertyConditions;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.TravellersPropertyProvider;
import com.gridnine.xtrip.common.model.rules.standard.ValueTypes;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import java.util.Collection;

public class TravellerProperty
implements RuleProperty,
RulePropertyConditions {
    public static final String PROPERTY_ID = "TRAVELLER_PROPERTY";
    public static final String[] CONDITIONS_IDs = new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};

    public String getId() {
        return PROPERTY_ID;
    }

    public String getDisplayName() {
        return "\u041f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a";
    }

    public String getRendererId() {
        return ValueTypes.PERSONS_REFERENCES.name();
    }

    public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
        buf.append(String.format("%s %s %s", this.getDisplayName(), cond.getDisplayName(), RulesHelper.toString(value)));
    }

    public boolean match(Object propertySet, RuleCondition condition, Object value) {
        TravellersPropertyProvider ps = (TravellersPropertyProvider)propertySet;
        Collection<EntityReference<Person>> psValues = ps.getTravellers();
        Collection values = (Collection)value;
        if (Conditions.INCLUDE.equals(condition)) {
            return RulesHelper.matchesEntityRestriction(psValues, values, true);
        }
        if (Conditions.EXCLUDE.equals(condition)) {
            return RulesHelper.matchesEntityRestriction(psValues, values, false);
        }
        return false;
    }

    @Override
    public String[] getConditionIds() {
        return CONDITIONS_IDs;
    }
}

