/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.standard;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductCustomParameterDescription;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductDescription;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.UniversalProductHelper;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.rules.l10n.Messages;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.EmployeeCategoriesProvider;
import com.gridnine.xtrip.common.model.rules.standard.ProductTicketInfoProperties;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.UniversalProductPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.ValueTypes;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.util.DateInterval;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniversalProductPropertiesFactory {
    public static List<UniversalProductRulePropertyDescriptor> createProperties(EntityContainer<UniversalProductDescription> ctr) {
        EntityReference ref = ctr.toReference();
        ArrayList<UniversalProductRulePropertyDescriptor> result = new ArrayList<UniversalProductRulePropertyDescriptor>();
        result.add(new SalesPointCountryCodesProperty((EntityReference<UniversalProductDescription>)ref, "SALES_POINT_COUNTRY_CODES"));
        result.add(new ReturnTypeProperty((EntityReference<UniversalProductDescription>)ref, "RETURN_TYPE"));
        result.add(new GdsProperty((EntityReference<UniversalProductDescription>)ref, "GDS"));
        result.add(new SalesPointProperty((EntityReference<UniversalProductDescription>)ref, "SALES_POINT"));
        result.add(new IssueDateProperty((EntityReference<UniversalProductDescription>)ref, "ISSUE_DATE"));
        result.add(new PnrProperty((EntityReference<UniversalProductDescription>)ref, "PNR"));
        result.add(new ETicketProperty((EntityReference<UniversalProductDescription>)ref, "ETICKET"));
        result.add(new FareProperty((EntityReference<UniversalProductDescription>)ref, "FARE"));
        result.add(new TotalProperty((EntityReference<UniversalProductDescription>)ref, "TOTAL"));
        result.add(new VendorPaymentTypesProperty((EntityReference<UniversalProductDescription>)ref, "VENDOR_PAYMENT_TYPES"));
        result.add(new ClientPaymentTypesProperty((EntityReference<UniversalProductDescription>)ref, "CLIENT_PAYMENT_TYPES"));
        result.add(new EmployeeCategoriesProperty((EntityReference<UniversalProductDescription>)ref, "EMPLOYEE_CATEGORIES"));
        result.add(new CreatedByClientProperty((EntityReference<UniversalProductDescription>)ref, "CREATED_BY_CLIENT"));
        result.add(new SuppliersProperty((EntityReference<UniversalProductDescription>)ref, "SUPPLIERS"));
        result.add(new HasVatProperty((EntityReference<UniversalProductDescription>)ref, "HAS_VAT"));
        Logger log = LoggerFactory.getLogger(UniversalProductPropertiesFactory.class);
        for (UniversalProductCustomParameterDescription parameter : ((UniversalProductDescription)ctr.getEntity()).getCustomParameters()) {
            if (parameter.getType() == null) {
                log.error(String.format("parameter %s of description %s has no type", parameter.getId(), ((UniversalProductDescription)ctr.getEntity()).toString()));
                continue;
            }
            switch (parameter.getType()) {
                case DATE: 
                case DATE_TIME: {
                    result.add(new DateCustomParameterProperty((EntityReference<UniversalProductDescription>)ref, parameter));
                    break;
                }
                case NUMBER: {
                    result.add(new BigDecimalCustomParameterProperty((EntityReference<UniversalProductDescription>)ref, parameter));
                    break;
                }
                case DICTIONARY: {
                    result.add(new DictionaryCustomParameterProperty((EntityReference<UniversalProductDescription>)ref, parameter));
                    break;
                }
                case STRING: {
                    result.add(new StringCustomParameterProperty((EntityReference<UniversalProductDescription>)ref, parameter));
                    break;
                }
                case BOOLEAN: {
                    result.add(new BooleanCustomParameterProperty((EntityReference<UniversalProductDescription>)ref, parameter));
                }
            }
        }
        return result;
    }

    static abstract class BaseEnumCollectionPropertyDescriptor<E extends Enum<E>>
    extends BaseUniversalProductRulePropertyDescriptor {
        BaseEnumCollectionPropertyDescriptor(EntityReference<UniversalProductDescription> descrRef, String idValue) {
            super(descrRef, idValue);
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10n.replace((String)this.getInfoMessageKey(), (Object[])new Object[]{cond.getDisplayName(), RulesHelper.values2text((List)value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            UniversalProductPropertiesProvider ps = (UniversalProductPropertiesProvider)propertySet;
            Set<String> collectionValues = this.getCollectionValues(ps);
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesEnumRestriction(collectionValues, (List)value, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesEnumRestriction(collectionValues, (List)value, false);
            }
            return true;
        }

        protected abstract String getInfoMessageKey();

        protected abstract Set<String> getCollectionValues(UniversalProductPropertiesProvider var1);
    }

    static abstract class BaseNumericPropertyDescriptor
    extends BaseUniversalProductRulePropertyDescriptor {
        BaseNumericPropertyDescriptor(EntityReference<UniversalProductDescription> descrRef, String idValue) {
            super(descrRef, idValue);
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.GREATER_THAN.getId(), Conditions.GREATER_THAN_OR_EQUALS.getId(), Conditions.LESS_THAN.getId(), Conditions.LESS_THAN_OR_EQUALS.getId()};
        }

        public String getRendererId() {
            return ValueTypes.NUMBER.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10n.replace((String)this.getInfoMessageKey(), (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            UniversalProductPropertiesProvider ps = (UniversalProductPropertiesProvider)propertySet;
            double dv = value == null ? 0.0 : (Double)value;
            double fare = this.getNumericValue(ps);
            if (Conditions.EQUALS.equals(condition)) {
                return Math.abs(fare - dv) < 0.01;
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return Math.abs(fare - dv) >= 0.01;
            }
            if (Conditions.GREATER_THAN.equals(condition)) {
                return fare - dv >= 0.01;
            }
            if (Conditions.GREATER_THAN_OR_EQUALS.equals(condition)) {
                return Math.abs(fare - dv) < 0.01 || fare - dv >= 0.01;
            }
            if (Conditions.LESS_THAN.equals(condition)) {
                return dv - fare >= 0.01;
            }
            if (Conditions.LESS_THAN_OR_EQUALS.equals(condition)) {
                return Math.abs(fare - dv) < 0.01 || dv - fare >= 0.01;
            }
            return true;
        }

        protected abstract String getInfoMessageKey();

        protected abstract double getNumericValue(UniversalProductPropertiesProvider var1);
    }

    static abstract class BaseStingCollectionProperty
    extends BaseUniversalProductRulePropertyDescriptor {
        BaseStingCollectionProperty(EntityReference<UniversalProductDescription> descrRef, String idValue) {
            super(descrRef, idValue);
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10n.replace((String)this.getInfoMessage(), (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            UniversalProductPropertiesProvider ps = (UniversalProductPropertiesProvider)propertySet;
            Set<String> values = this.getStringCollection(ps);
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesStringRestriction(values, value, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesStringRestriction(values, value, false);
            }
            return true;
        }

        protected abstract Set<String> getStringCollection(UniversalProductPropertiesProvider var1);

        protected abstract String getInfoMessage();
    }

    static abstract class BaseBooleanPropertyDescriptor
    extends BaseUniversalProductRulePropertyDescriptor {
        private static final long serialVersionUID = -1543053062965039235L;

        BaseBooleanPropertyDescriptor(EntityReference<UniversalProductDescription> descrRef, String idValue) {
            super(descrRef, idValue);
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getRendererId() {
            return ValueTypes.YES_NO.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10n.replace((String)this.getInfoMessage(), (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            UniversalProductPropertiesProvider ps = (UniversalProductPropertiesProvider)propertySet;
            boolean boolValue = value == null ? false : (Boolean)value;
            boolean propertyValue = this.getPropertyValue(ps);
            if (Conditions.EQUALS.equals(condition)) {
                return propertyValue == boolValue;
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return propertyValue != boolValue;
            }
            return true;
        }

        protected abstract boolean getPropertyValue(UniversalProductPropertiesProvider var1);

        protected abstract String getInfoMessage();
    }

    static abstract class BaseStringPropertyDescriptor
    extends BaseUniversalProductRulePropertyDescriptor {
        BaseStringPropertyDescriptor(EntityReference<UniversalProductDescription> descrRef, String idValue) {
            super(descrRef, idValue);
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.BEGINS_WITH.getId(), Conditions.ENDS_WITH.getId()};
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10n.replace((String)this.getInfoMessage(), (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            UniversalProductPropertiesProvider ps = (UniversalProductPropertiesProvider)propertySet;
            String propertyValue = this.getPropertyValue(ps);
            if (Conditions.EQUALS.equals(condition)) {
                return RulesHelper.matchesStringRestriction(propertyValue, value, true);
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return propertyValue != null && RulesHelper.matchesStringRestriction(propertyValue, value, false);
            }
            if (Conditions.BEGINS_WITH.equals(condition)) {
                return propertyValue != null && RulesHelper.matchesStringStartsWithRestriction(propertyValue, value, true);
            }
            if (Conditions.ENDS_WITH.equals(condition)) {
                return propertyValue != null && RulesHelper.matchesStringEndsWithRestriction(propertyValue, value, true);
            }
            return true;
        }

        protected abstract String getPropertyValue(UniversalProductPropertiesProvider var1);

        protected abstract String getInfoMessage();
    }

    static abstract class BaseDatePropertyDescriptor
    extends BaseUniversalProductRulePropertyDescriptor {
        BaseDatePropertyDescriptor(EntityReference<UniversalProductDescription> descrRef, String idValue) {
            super(descrRef, idValue);
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.PERIOD_WITHIN.getId(), Conditions.PERIOD_BEYOND.getId()};
        }

        public String getRendererId() {
            return ValueTypes.DATE_INTERVAL.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            DateInterval di = (DateInterval)value;
            if (di == null || di.getBeginDate() == null && di.getEndDate() == null) {
                return;
            }
            DateFormat dateFormat = RulesHelper.getDateFormat();
            if (Conditions.PERIOD_WITHIN.getId().equals(cond.getId())) {
                if (di.getBeginDate() == null) {
                    buf.append(L10n.replace((String)this.getDateBeforeMessageKey(), (Object[])new Object[]{dateFormat.format(di.getEndDate())}));
                } else if (di.getEndDate() == null) {
                    buf.append(L10n.replace((String)this.getDateAfterMessageKey(), (Object[])new Object[]{dateFormat.format(di.getBeginDate())}));
                } else {
                    buf.append(L10n.replace((String)this.getDateWithinMessageKey(), (Object[])new Object[]{dateFormat.format(di.getBeginDate()), dateFormat.format(di.getEndDate())}));
                }
                return;
            }
            if (Conditions.PERIOD_BEYOND.getId().equals(cond.getId())) {
                if (di.getBeginDate() == null) {
                    buf.append(L10n.replace((String)this.getDateAfterMessageKey(), (Object[])new Object[]{dateFormat.format(di.getEndDate())}));
                } else if (di.getEndDate() == null) {
                    buf.append(L10n.replace((String)this.getDateBeforeMessageKey(), (Object[])new Object[]{dateFormat.format(di.getBeginDate())}));
                } else {
                    buf.append(L10n.replace((String)this.getDateBeyondMessageKey(), (Object[])new Object[]{dateFormat.format(di.getBeginDate()), dateFormat.format(di.getEndDate())}));
                }
            }
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            UniversalProductPropertiesProvider ps = (UniversalProductPropertiesProvider)propertySet;
            DateInterval di = (DateInterval)value;
            if (di == null || di.getBeginDate() == null && di.getEndDate() == null) {
                return true;
            }
            Date issueDate = this.getDateValue(ps);
            if (Conditions.PERIOD_WITHIN.equals(condition)) {
                if (di.getBeginDate() == null) {
                    return issueDate != null && issueDate.getTime() <= di.getEndDate().getTime();
                }
                if (di.getEndDate() == null) {
                    return issueDate != null && issueDate.getTime() >= di.getBeginDate().getTime();
                }
                return issueDate != null && issueDate.getTime() >= di.getBeginDate().getTime() && issueDate.getTime() <= di.getEndDate().getTime();
            }
            if (Conditions.PERIOD_BEYOND.equals(condition)) {
                if (di.getBeginDate() == null) {
                    return issueDate != null && issueDate.getTime() > di.getEndDate().getTime();
                }
                if (di.getEndDate() == null) {
                    return issueDate != null && issueDate.getTime() < di.getBeginDate().getTime();
                }
                return issueDate != null && (issueDate.getTime() < di.getBeginDate().getTime() || issueDate.getTime() > di.getEndDate().getTime());
            }
            return true;
        }

        protected abstract Date getDateValue(UniversalProductPropertiesProvider var1);

        protected abstract String getDateBeyondMessageKey();

        protected abstract String getDateWithinMessageKey();

        protected abstract String getDateAfterMessageKey();

        protected abstract String getDateBeforeMessageKey();
    }

    public static interface UniversalProductRulePropertyDescriptor
    extends RuleProperty {
        public String[] getConditionIds();

        public String getTargetId();
    }

    public static abstract class BaseUniversalProductRulePropertyDescriptor
    implements UniversalProductRulePropertyDescriptor {
        protected transient Logger log = LoggerFactory.getLogger(this.getClass());
        private final EntityReference<UniversalProductDescription> ref;
        private final String id;

        BaseUniversalProductRulePropertyDescriptor(EntityReference<UniversalProductDescription> descrRef, String idValue) {
            this.ref = descrRef;
            this.id = idValue;
        }

        public String getId() {
            return String.format("%s_%s", this.ref.getUid(), this.id);
        }

        UniversalProductDescription getDescription() {
            try {
                EntityContainer ctr = EntityStorage.get().resolve(this.ref);
                if (ctr == null) {
                    this.log.error(String.format("reference %s is absent in DB", this.ref));
                    return null;
                }
                return (UniversalProductDescription)ctr.getEntity();
            }
            catch (Exception e) {
                this.log.error("unable to resolve reference " + this.ref, (Throwable)e);
                return null;
            }
        }

        @Override
        public String getTargetId() {
            return UniversalProductHelper.getRuleTargetId(this.ref);
        }
    }

    static class DictionaryCustomParameterProperty
    extends BaseUniversalProductRulePropertyDescriptor {
        private final UniversalProductCustomParameterDescription param;

        DictionaryCustomParameterProperty(EntityReference<UniversalProductDescription> descrRef, UniversalProductCustomParameterDescription parameterDescription) {
            super(descrRef, parameterDescription.getId());
            this.param = parameterDescription;
        }

        public String getDisplayName() {
            return this.param.getDisplayName();
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.name(), Conditions.NOT_EQUALS.name()};
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10n.replace((String)String.format("%s {0} {1}", this.param.getDisplayName()), (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            UniversalProductPropertiesProvider ps = (UniversalProductPropertiesProvider)propertySet;
            Object obj = ps.getCustomParameters().get(this.param.getId());
            if (obj instanceof Collection) {
                List<String> expected = RulesHelper.toStringCollection(value);
                Collection coll = (Collection)obj;
                if (Conditions.EQUALS.equals(condition)) {
                    return RulesHelper.collectionIncludes(coll, expected);
                }
                if (Conditions.NOT_EQUALS.equals(condition)) {
                    return !RulesHelper.collectionIncludes(coll, expected);
                }
                return false;
            }
            if (obj instanceof DictionaryReference) {
                DictionaryReference ref = (DictionaryReference)obj;
                if (Conditions.EQUALS.equals(condition)) {
                    return RulesHelper.matchesStringRestriction(ref.getCode(), value, true);
                }
                if (Conditions.NOT_EQUALS.equals(condition)) {
                    return ref.getCode() != null && RulesHelper.matchesStringRestriction(ref.getCode(), value, false);
                }
                return false;
            }
            return false;
        }
    }

    static class BooleanCustomParameterProperty
    extends BaseBooleanPropertyDescriptor {
        private static final long serialVersionUID = -8651641571960778349L;
        private final UniversalProductCustomParameterDescription param;

        BooleanCustomParameterProperty(EntityReference<UniversalProductDescription> descrRef, UniversalProductCustomParameterDescription parameterDescription) {
            super(descrRef, parameterDescription.getId());
            this.param = parameterDescription;
        }

        public String getDisplayName() {
            return this.param.getDisplayName();
        }

        @Override
        protected boolean getPropertyValue(UniversalProductPropertiesProvider ps) {
            Object value = ps.getCustomParameters().get(this.param.getId());
            if (value instanceof Boolean) {
                Boolean bool = (Boolean)value;
                return bool;
            }
            return false;
        }

        @Override
        protected String getInfoMessage() {
            return String.format("%s {0} {1}", this.param.getDisplayName());
        }
    }

    static class StringCustomParameterProperty
    extends BaseStringPropertyDescriptor {
        private final UniversalProductCustomParameterDescription param;

        StringCustomParameterProperty(EntityReference<UniversalProductDescription> descrRef, UniversalProductCustomParameterDescription parameterDescription) {
            super(descrRef, parameterDescription.getId());
            this.param = parameterDescription;
        }

        public String getDisplayName() {
            return this.param.getDisplayName();
        }

        @Override
        protected String getPropertyValue(UniversalProductPropertiesProvider ps) {
            Object value = ps.getCustomParameters().get(this.param.getId());
            if (value instanceof String) {
                String str = (String)value;
                return str;
            }
            return null;
        }

        @Override
        protected String getInfoMessage() {
            return String.format("%s {0} {1}", this.param.getDisplayName());
        }
    }

    static class BigDecimalCustomParameterProperty
    extends BaseNumericPropertyDescriptor {
        private final UniversalProductCustomParameterDescription param;

        BigDecimalCustomParameterProperty(EntityReference<UniversalProductDescription> descrRef, UniversalProductCustomParameterDescription parameterDescription) {
            super(descrRef, parameterDescription.getId());
            this.param = parameterDescription;
        }

        public String getDisplayName() {
            return this.param.getDisplayName();
        }

        @Override
        protected String getInfoMessageKey() {
            return String.format("%s {0} {1}", this.param.getDisplayName());
        }

        @Override
        protected double getNumericValue(UniversalProductPropertiesProvider ps) {
            Object value = ps.getCustomParameters().get(this.param.getId());
            if (value instanceof Number) {
                Number num = (Number)value;
                return num.doubleValue();
            }
            return 0.0;
        }
    }

    static class DateCustomParameterProperty
    extends BaseDatePropertyDescriptor {
        private final UniversalProductCustomParameterDescription param;

        DateCustomParameterProperty(EntityReference<UniversalProductDescription> descrRef, UniversalProductCustomParameterDescription parameterDescription) {
            super(descrRef, parameterDescription.getId());
            this.param = parameterDescription;
        }

        public String getDisplayName() {
            return this.param.getDisplayName();
        }

        @Override
        protected Date getDateValue(UniversalProductPropertiesProvider ps) {
            return (Date)ps.getCustomParameters().get(this.param.getId());
        }

        @Override
        protected String getDateBeyondMessageKey() {
            return String.format("%s \u0432\u043d\u0435 \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b\u0430 [{0} {1}]", this.param.getDisplayName());
        }

        @Override
        protected String getDateWithinMessageKey() {
            return String.format("%s \u0432\u043d\u0443\u0442\u0440\u0438 \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b\u0430 [{0} {1}]", this.param.getDisplayName());
        }

        @Override
        protected String getDateAfterMessageKey() {
            return String.format("%s \u043f\u043e\u0441\u043b\u0435 {0}", this.param.getDisplayName());
        }

        @Override
        protected String getDateBeforeMessageKey() {
            return String.format("%s \u0434\u043e {0}", this.param.getDisplayName());
        }
    }

    static class HasVatProperty
    extends BaseBooleanPropertyDescriptor {
        HasVatProperty(EntityReference<UniversalProductDescription> descrRef, String idValue) {
            super(descrRef, idValue);
        }

        @Override
        public String getRendererId() {
            return ValueTypes.SERVICE_LOCATION_TYPE.name();
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_HAS_VAT);
        }

        @Override
        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(Boolean.TRUE.equals(value) ? L10n.get((String)Messages.RuleProperty_HAS_VAT_info1) : L10n.get((String)Messages.RuleProperty_HAS_VAT_info2));
        }

        @Override
        protected boolean getPropertyValue(UniversalProductPropertiesProvider provider) {
            return provider.isHasVat();
        }

        @Override
        protected String getInfoMessage() {
            return null;
        }
    }

    static class SuppliersProperty
    extends BaseUniversalProductRulePropertyDescriptor {
        SuppliersProperty(EntityReference<UniversalProductDescription> descrRef, String idValue) {
            super(descrRef, idValue);
        }

        @Override
        public String[] getConditionIds() {
            return ProductTicketInfoProperties.SUPPLIERS.getConditionIds();
        }

        public String getDisplayName() {
            return ProductTicketInfoProperties.SUPPLIERS.getDisplayName();
        }

        public String getRendererId() {
            return ProductTicketInfoProperties.SUPPLIERS.getRendererId();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            ProductTicketInfoProperties.SUPPLIERS.buildInfo(buf, cond, value);
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            return ProductTicketInfoProperties.SUPPLIERS.match(propertySet, condition, value);
        }
    }

    static class CreatedByClientProperty
    extends BaseBooleanPropertyDescriptor {
        CreatedByClientProperty(EntityReference<UniversalProductDescription> descrRef, String idValue) {
            super(descrRef, idValue);
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_CREATED_BY_CLIENT);
        }

        @Override
        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(Boolean.TRUE.equals(value) ? L10n.get((String)Messages.RuleProperty_CREATED_BY_CLIENT_info1) : L10n.get((String)Messages.RuleProperty_CREATED_BY_CLIENT_info2));
        }

        @Override
        protected boolean getPropertyValue(UniversalProductPropertiesProvider ps) {
            return ps.isCreatedByClient();
        }

        @Override
        protected String getInfoMessage() {
            return null;
        }
    }

    static class EmployeeCategoriesProperty
    extends BaseUniversalProductRulePropertyDescriptor {
        EmployeeCategoriesProperty(EntityReference<UniversalProductDescription> descrRef, String idValue) {
            super(descrRef, idValue);
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_EMPLOYEE_CATEGORIES);
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_EMPLOYEE_CATEGORIES_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            EmployeeCategoriesProvider ps = (EmployeeCategoriesProvider)propertySet;
            if (Conditions.INCLUDE.equals(condition)) {
                return value != null && RulesHelper.containsEmployeeCategory(ps.getEmployeeCategories(), (List)value);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return value != null && !RulesHelper.containsEmployeeCategory(ps.getEmployeeCategories(), (List)value);
            }
            return true;
        }
    }

    static class ClientPaymentTypesProperty
    extends BaseEnumCollectionPropertyDescriptor<PaymentType> {
        ClientPaymentTypesProperty(EntityReference<UniversalProductDescription> descrRef, String idValue) {
            super(descrRef, idValue);
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.Properties_clientFop);
        }

        public String getRendererId() {
            return ValueTypes.PAYMENT_TYPE.name();
        }

        @Override
        protected String getInfoMessageKey() {
            return L10n.get((String)Messages.Properties_clientFop_info);
        }

        @Override
        protected Set<String> getCollectionValues(UniversalProductPropertiesProvider ps) {
            return ps.getClientPaymentTypes();
        }
    }

    static class VendorPaymentTypesProperty
    extends BaseEnumCollectionPropertyDescriptor<PaymentType> {
        VendorPaymentTypesProperty(EntityReference<UniversalProductDescription> descrRef, String idValue) {
            super(descrRef, idValue);
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.Properties_vendorFop);
        }

        public String getRendererId() {
            return ValueTypes.PAYMENT_TYPE.name();
        }

        @Override
        protected String getInfoMessageKey() {
            return L10n.get((String)Messages.Properties_vendorFop_info);
        }

        @Override
        protected Set<String> getCollectionValues(UniversalProductPropertiesProvider ps) {
            return ps.getVendorPaymentTypes();
        }
    }

    static class TotalProperty
    extends BaseNumericPropertyDescriptor {
        TotalProperty(EntityReference<UniversalProductDescription> descrRef, String idValue) {
            super(descrRef, idValue);
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.Properties_totalCost);
        }

        @Override
        protected String getInfoMessageKey() {
            return L10n.get((String)Messages.Properties_totalCost_info);
        }

        @Override
        protected double getNumericValue(UniversalProductPropertiesProvider ps) {
            return ps.getTotal();
        }
    }

    static class FareProperty
    extends BaseNumericPropertyDescriptor {
        FareProperty(EntityReference<UniversalProductDescription> descrRef, String idValue) {
            super(descrRef, idValue);
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_FARE);
        }

        @Override
        protected String getInfoMessageKey() {
            return L10n.get((String)Messages.RuleProperty_FARE_info);
        }

        @Override
        protected double getNumericValue(UniversalProductPropertiesProvider ps) {
            return ps.getFare();
        }
    }

    static class ETicketProperty
    extends BaseUniversalProductRulePropertyDescriptor {
        ETicketProperty(EntityReference<UniversalProductDescription> descrRef, String idValue) {
            super(descrRef, idValue);
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_E_TICKET);
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_E_TICKET_info, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            UniversalProductPropertiesProvider ps = (UniversalProductPropertiesProvider)propertySet;
            if (Conditions.EQUALS.equals(condition)) {
                return ps.isEticket() == (value != null && (Boolean)value != false);
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return ps.isEticket() != (value != null && (Boolean)value != false);
            }
            return true;
        }

        public String getRendererId() {
            return ValueTypes.YES_NO.name();
        }
    }

    static class PnrProperty
    extends BaseStringPropertyDescriptor {
        PnrProperty(EntityReference<UniversalProductDescription> descrRef, String idValue) {
            super(descrRef, idValue);
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_PNR);
        }

        @Override
        protected String getPropertyValue(UniversalProductPropertiesProvider ps) {
            return ps.getPnr();
        }

        @Override
        protected String getInfoMessage() {
            return L10n.get((String)Messages.RuleProperty_PNR_info);
        }
    }

    static class IssueDateProperty
    extends BaseDatePropertyDescriptor {
        IssueDateProperty(EntityReference<UniversalProductDescription> descrRef, String idValue) {
            super(descrRef, idValue);
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_ISSUED_short);
        }

        @Override
        protected Date getDateValue(UniversalProductPropertiesProvider ps) {
            return ps.getIssueDate();
        }

        @Override
        protected String getDateBeyondMessageKey() {
            return L10n.get((String)Messages.RuleProperty_ISSUED_info_beyond);
        }

        @Override
        protected String getDateWithinMessageKey() {
            return L10n.get((String)Messages.RuleProperty_ISSUED_info_within);
        }

        @Override
        protected String getDateAfterMessageKey() {
            return L10n.get((String)Messages.RuleProperty_ISSUED_info_after);
        }

        @Override
        protected String getDateBeforeMessageKey() {
            return L10n.get((String)Messages.RuleProperty_ISSUED_info_before);
        }
    }

    static class SalesPointProperty
    extends BaseUniversalProductRulePropertyDescriptor {
        SalesPointProperty(EntityReference<UniversalProductDescription> descrRef, String idValue) {
            super(descrRef, idValue);
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_HotelSalesPoint);
        }

        public String getRendererId() {
            return ValueTypes.SALES_POINTS.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(String.format(L10n.get((String)Messages.RuleProperty_HotelSalesPointArgs), cond.getDisplayName(), this.toString((List)value)));
        }

        private String toString(List<String> value) {
            if (value == null || value.isEmpty()) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (String uid : value) {
                String title = "???";
                try {
                    EntityContainer ctr = EntityStorage.get().resolve(new EntityReference(uid, SalesPoint.class, null));
                    if (ctr != null) {
                        title = ctr.toReference().toString();
                    }
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(this.getClass()).error("unable to resolve reference", (Throwable)e);
                }
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(title);
            }
            return sb.toString();
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            UniversalProductPropertiesProvider ps = (UniversalProductPropertiesProvider)propertySet;
            List uids = (List)value;
            if (Conditions.EQUALS.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getSalesPointUid(), (Object)uids, true);
            }
            return RulesHelper.matchesStringRestriction(ps.getSalesPointUid(), (Object)uids, false);
        }
    }

    static class GdsProperty
    extends BaseUniversalProductRulePropertyDescriptor {
        GdsProperty(EntityReference<UniversalProductDescription> descrRef, String idValue) {
            super(descrRef, idValue);
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return "\u0421\u0438\u0441\u0442\u0435\u043c\u0430 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f";
        }

        public String getRendererId() {
            return ValueTypes.GDS_NAME.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(String.format("\u0421\u0438\u0441\u0442\u0435\u043c\u0430 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f %s %s", cond.getDisplayName(), RulesHelper.values2text((List)value)));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            UniversalProductPropertiesProvider ps = (UniversalProductPropertiesProvider)propertySet;
            if (Conditions.EQUALS.equals(condition)) {
                return RulesHelper.matchesEnumRestriction(ps.getGdsName(), (List)value, true);
            }
            return ps.getGdsName() != null && RulesHelper.matchesEnumRestriction(ps.getGdsName(), (List)value, false);
        }
    }

    static class ReturnTypeProperty
    extends BaseUniversalProductRulePropertyDescriptor {
        ReturnTypeProperty(EntityReference<UniversalProductDescription> descrRef, String idValue) {
            super(descrRef, idValue);
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.RETURN_TYPE_FORCED.getId(), Conditions.RETURN_TYPE_UNFORCED.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_ReturnType);
        }

        public String getRendererId() {
            return ValueTypes.NULL.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(cond.getDisplayName());
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            UniversalProductPropertiesProvider ps = (UniversalProductPropertiesProvider)propertySet;
            if (Conditions.RETURN_TYPE_FORCED.equals(condition)) {
                return ps.isForcedRefund();
            }
            return !ps.isForcedRefund();
        }
    }

    static class SalesPointCountryCodesProperty
    extends BaseStingCollectionProperty {
        SalesPointCountryCodesProperty(EntityReference<UniversalProductDescription> descrRef, String idValue) {
            super(descrRef, idValue);
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_SalesPointCountryCodes);
        }

        @Override
        protected Set<String> getStringCollection(UniversalProductPropertiesProvider ps) {
            return ps.getSalesPointCountryCodes();
        }

        @Override
        protected String getInfoMessage() {
            return L10n.get((String)Messages.RuleProperty_SalesPointCountryCodes_info);
        }
    }
}

