/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.standard;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductDescription;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductDescriptionIndex;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.cache.EntityCacheListener;
import com.gridnine.xtrip.common.model.helpers.UniversalProductHelper;
import com.gridnine.xtrip.common.model.rules.standard.ContractActions;
import com.gridnine.xtrip.common.model.rules.standard.ContractsFilteringCategories;
import com.gridnine.xtrip.common.model.rules.standard.GeneralProductActions;
import com.gridnine.xtrip.common.model.rules.standard.UniversalProductPropertiesFactory;
import com.gridnine.xtrip.common.rules.RulesEnvironment;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.search.SearchQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class UniversalProductRuleEnvironment {
    private final List<EntityReference<UniversalProductDescription>> actualDescriptions = new ArrayList<EntityReference<UniversalProductDescription>>();

    public void initializeEnvironment(List<EntityReference<UniversalProductDescription>> descriptions) throws Exception {
        RulesEnvironment env = RulesEnvironment.get();
        for (EntityReference<UniversalProductDescription> descriptionRef : descriptions) {
            EntityContainer ctr = EntityStorage.get().resolve(descriptionRef);
            if (ctr == null || !((UniversalProductDescription)ctr.getEntity()).isRulesSupported() || env.findTarget(UniversalProductHelper.getRuleTargetId((EntityReference<UniversalProductDescription>)ctr.toReference())) != null) continue;
            this.registerTarget((EntityContainer<UniversalProductDescription>)ctr, env);
            this.actualDescriptions.add(descriptionRef);
        }
    }

    private void registerTarget(EntityContainer<UniversalProductDescription> ctr, RulesEnvironment env) {
        UniversalProductRuleTarget target = new UniversalProductRuleTarget(ctr);
        env.registerTargets(new RuleTarget[]{target});
        List<UniversalProductPropertiesFactory.UniversalProductRulePropertyDescriptor> properties = UniversalProductPropertiesFactory.createProperties(ctr);
        properties.forEach(property -> env.unregisterProperty(property.getId()));
        env.registerProperties(properties.toArray(new RuleProperty[properties.size()]));
        for (UniversalProductPropertiesFactory.UniversalProductRulePropertyDescriptor property2 : properties) {
            env.registerTarget2propertyAssociation(property2.getTargetId(), property2.getId());
            for (String string : property2.getConditionIds()) {
                env.registerProperty2conditionAssociation(property2.getId(), string);
            }
            for (ContractsFilteringCategories contractsFilteringCategories : ContractsFilteringCategories.values()) {
                env.registerFilteringCategory2propertyAssociation(contractsFilteringCategories.getId(), property2.getId());
            }
        }
        ArrayList<GeneralProductActions> actions = new ArrayList<GeneralProductActions>(Arrays.asList(GeneralProductActions.values()));
        actions.add((GeneralProductActions)((Object)ContractActions.CONTRACT));
        for (RuleAction ruleAction : actions) {
            env.registerTarget2actionAssociation(UniversalProductHelper.getRuleTargetId((EntityReference<UniversalProductDescription>)ctr.toReference()), ruleAction.getId());
            for (ContractsFilteringCategories category : ContractsFilteringCategories.values()) {
                env.registerFilteringCategory2actionAssociation(category.getId(), ruleAction.getId());
            }
        }
        for (ContractsFilteringCategories category : ContractsFilteringCategories.values()) {
            env.registerFilteringCategory2targetAssociation(category.getId(), UniversalProductHelper.getRuleTargetId((EntityReference<UniversalProductDescription>)ctr.toReference()));
        }
    }

    public void deleteInactualTargets(List<EntityReference<UniversalProductDescription>> descriptions) {
        RulesEnvironment env = RulesEnvironment.get();
        Iterator<EntityReference<UniversalProductDescription>> it = this.actualDescriptions.iterator();
        while (it.hasNext()) {
            EntityReference<UniversalProductDescription> descr = it.next();
            if (descriptions.contains(descr)) continue;
            env.unregisterTarget(UniversalProductHelper.getRuleTargetId(descr));
            it.remove();
        }
    }

    public void unregisterTarget(EntityReference<UniversalProductDescription> ref) {
        RulesEnvironment.get().unregisterTarget(UniversalProductHelper.getRuleTargetId(ref));
    }

    public void updateRuleEnvironment(EntityContainer<UniversalProductDescription> ctr) {
        EntityReference ref;
        RulesEnvironment env = RulesEnvironment.get();
        RuleTarget target = env.findTarget(UniversalProductHelper.getRuleTargetId((EntityReference<UniversalProductDescription>)(ref = ctr.toReference())));
        if (target == null) {
            this.registerTarget(ctr, env);
            this.actualDescriptions.add((EntityReference<UniversalProductDescription>)ref);
            return;
        }
        HashMap<String, UniversalProductPropertiesFactory.UniversalProductRulePropertyDescriptor> allProperties = new HashMap<String, UniversalProductPropertiesFactory.UniversalProductRulePropertyDescriptor>();
        for (UniversalProductPropertiesFactory.UniversalProductRulePropertyDescriptor universalProductRulePropertyDescriptor : UniversalProductPropertiesFactory.createProperties(ctr)) {
            allProperties.put(universalProductRulePropertyDescriptor.getId(), universalProductRulePropertyDescriptor);
        }
        for (RuleProperty ruleProperty : new HashSet(env.getProperties(target))) {
            if (allProperties.containsKey(ruleProperty.getId())) continue;
            env.unregisterProperty(ruleProperty.getId());
        }
        for (Map.Entry entry : allProperties.entrySet()) {
            RuleProperty existingProperty;
            String propertyId = (String)entry.getKey();
            UniversalProductPropertiesFactory.UniversalProductRulePropertyDescriptor newProperty = (UniversalProductPropertiesFactory.UniversalProductRulePropertyDescriptor)allProperties.get(propertyId);
            if (newProperty == null || (existingProperty = env.findProperty(propertyId)) != null && this.equals(existingProperty, newProperty)) continue;
            env.unregisterProperty(propertyId);
            env.registerProperties(new RuleProperty[]{newProperty});
            env.registerTarget2propertyAssociation(newProperty.getTargetId(), propertyId);
            for (String string : newProperty.getConditionIds()) {
                env.registerProperty2conditionAssociation(propertyId, string);
            }
            for (ContractsFilteringCategories contractsFilteringCategories : ContractsFilteringCategories.values()) {
                env.registerFilteringCategory2propertyAssociation(contractsFilteringCategories.getId(), propertyId);
            }
        }
    }

    private boolean equals(RuleProperty existingProperty, UniversalProductPropertiesFactory.UniversalProductRulePropertyDescriptor newProperty) {
        if (existingProperty.getDisplayName() == null) {
            return false;
        }
        if (!existingProperty.getClass().equals(newProperty.getClass())) {
            return false;
        }
        return existingProperty.getDisplayName().equals(newProperty.getDisplayName());
    }

    public static class UniversalProductDescriptionEntityCacheListener
    implements EntityCacheListener {
        UniversalProductRuleEnvironment env;

        public UniversalProductDescriptionEntityCacheListener(UniversalProductRuleEnvironment environment) {
            this.env = environment;
        }

        public void onReset() {
            ArrayList<EntityContainer> ctrs = new ArrayList<EntityContainer>();
            ArrayList<EntityReference<UniversalProductDescription>> refs = new ArrayList<EntityReference<UniversalProductDescription>>();
            for (UniversalProductDescriptionIndex idx : EntityStorage.get().search(UniversalProductDescriptionIndex.class, new SearchQuery()).getData()) {
                EntityContainer ctr = EntityStorage.get().resolve(idx.getSource());
                if (ctr != null && ((UniversalProductDescription)ctr.getEntity()).isRulesSupported()) {
                    ctrs.add(ctr);
                }
                refs.add((EntityReference<UniversalProductDescription>)idx.getSource());
            }
            this.env.deleteInactualTargets(refs);
            for (EntityContainer ctr : ctrs) {
                this.env.updateRuleEnvironment((EntityContainer<UniversalProductDescription>)ctr);
            }
        }

        public void onInvalidate(EntityReference<?> ref) {
            if (ref.getType().equals(UniversalProductDescription.class)) {
                EntityReference<?> descrRef = ref;
                EntityContainer ctr = EntityStorage.get().resolve(descrRef);
                if (ctr != null && ((UniversalProductDescription)ctr.getEntity()).isRulesSupported()) {
                    this.env.updateRuleEnvironment((EntityContainer<UniversalProductDescription>)ctr);
                    return;
                }
                this.env.unregisterTarget(descrRef);
            }
        }
    }

    public static class UniversalProductRuleTarget
    implements RuleTarget {
        private static final long serialVersionUID = -4504816475441698514L;
        private final EntityContainer<UniversalProductDescription> ctr;
        private final String uid;

        public UniversalProductRuleTarget(EntityContainer<UniversalProductDescription> ctr) {
            this.ctr = ctr;
            this.uid = String.format("UniversalPRoductRuleTarget-%s", ctr.getUid());
        }

        public String getPropertySetClassName() {
            return null;
        }

        public String getId() {
            return UniversalProductHelper.getRuleTargetId((EntityReference<UniversalProductDescription>)this.ctr.toReference());
        }

        public String getDisplayName() {
            return ((UniversalProductDescription)this.ctr.getEntity()).getName();
        }

        public boolean isAvailableToCreate() {
            return !((UniversalProductDescription)this.ctr.getEntity()).isDisabled();
        }

        public String getActionSetClassName() {
            return null;
        }

        public boolean equals(Object obj) {
            if (obj instanceof UniversalProductRuleTarget) {
                return ((UniversalProductRuleTarget)obj).uid.equals(this.uid);
            }
            return false;
        }

        public int hashCode() {
            return this.uid.hashCode();
        }
    }
}

