/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.standard.formOfPayment;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.MulticurrencyHelper;
import com.gridnine.xtrip.common.model.profile.ExchangeRateData;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.RulePropertyConditions;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.ValueTypes;
import com.gridnine.xtrip.common.model.rules.standard.formOfPayment.FOPPropertiesProvider;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.util.BooleanUtil;
import java.math.BigDecimal;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public enum FOPProperties implements RuleProperty,
RulePropertyConditions
{
    FOP{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)"RuleProperty_fop", (Object[])new Object[0]);
        }

        public String getRendererId() {
            return ValueTypes.PAYMENT_TYPE_SABRE.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)"RuleProperty_fopInfo", (Object[])new Object[]{cond.getDisplayName(), this.buildTypes((List)value)}));
        }

        private String buildTypes(List<PaymentType> types) {
            StringBuilder sb = new StringBuilder();
            for (PaymentType type : types) {
                if (type == null) continue;
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                if (type == PaymentType.INVOICE && "en".equals(LocaleManager.get().getCurrentLocale().getLanguage())) {
                    sb.append("Check");
                    continue;
                }
                sb.append(type);
            }
            return sb.toString();
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            FOPPropertiesProvider ps = (FOPPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesEnumRestriction(ps.getFopTypes(), (List)value, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesEnumRestriction(ps.getFopTypes(), (List)value, false);
            }
            return false;
        }
    }
    ,
    CARD_TYPE{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)"RuleProperty_fopCardType", (Object[])new Object[0]);
        }

        public String getRendererId() {
            return ValueTypes.CREDIT_CARD_WITH_CODE_TYPE.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)"RuleProperty_fopCardTypeInfo", (Object[])new Object[]{cond.getDisplayName(), this.buildValue((List)value)}));
        }

        private String buildValue(List<CardVendor> value) {
            if (value == null || value.isEmpty()) {
                return "";
            }
            return value.stream().map(c -> c + " (" + DictHelper.getSabreCardCode(c) + ")").collect(Collectors.joining(", "));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            FOPPropertiesProvider ps = (FOPPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesEnumRestriction(ps.getCardTypes(), (List)value, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesEnumRestriction(ps.getCardTypes(), (List)value, false);
            }
            return false;
        }
    }
    ,
    CARD_BELONGS_TO_AGENCY{

        @Override
        public String[] getConditionIds() {
            return new String[0];
        }

        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)"RuleProperty_fopCardBelongsToAgency", (Object[])new Object[0]);
        }

        public String getRendererId() {
            return ValueTypes.YES_NO.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append((Boolean)value != false ? L10nResourcesManager.getStr((String)"RuleProperty_fopCardBelongsToAgencyYes", (Object[])new Object[0]) : L10nResourcesManager.getStr((String)"RuleProperty_fopCardBelongsToAgencyNo", (Object[])new Object[0]));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            FOPPropertiesProvider ps = (FOPPropertiesProvider)propertySet;
            return (Boolean)value ^ !BooleanUtil.nullAsFalse((Boolean)ps.isAgencyCard());
        }
    }
    ,
    PQ_TOTAL{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.GREATER_THAN.getId(), Conditions.GREATER_THAN_OR_EQUALS.getId(), Conditions.LESS_THAN.getId(), Conditions.LESS_THAN_OR_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)"RuleProperty_fopPQTotal", (Object[])new Object[0]);
        }

        public String getRendererId() {
            return ValueTypes.MONEY.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)"RuleProperty_fopPQTotalInfo", (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            FOPPropertiesProvider ps = (FOPPropertiesProvider)propertySet;
            Money money = (Money)value;
            Set<Money> pqTotals = ps.getPQTotals();
            BigDecimal rulePrice = money.getValue();
            for (Money pqTotal : pqTotals) {
                if (pqTotal.getCurrency() == null) continue;
                ExchangeRateData rateData = MulticurrencyHelper.buildExchangeRateData(pqTotal.getCurrency(), money.getCurrency(), null, ps.getDate(), null, true);
                BigDecimal convertedPrice = MulticurrencyHelper.convert(pqTotal.getValue(), rateData);
                if (!(Conditions.EQUALS.equals(condition) ? convertedPrice.compareTo(rulePrice) == 0 : (Conditions.NOT_EQUALS.equals(condition) ? convertedPrice.compareTo(rulePrice) != 0 : (Conditions.GREATER_THAN.equals(condition) ? convertedPrice.compareTo(rulePrice) > 0 : (Conditions.GREATER_THAN_OR_EQUALS.equals(condition) ? convertedPrice.compareTo(rulePrice) >= 0 : (Conditions.LESS_THAN.equals(condition) ? convertedPrice.compareTo(rulePrice) < 0 : Conditions.LESS_THAN_OR_EQUALS.equals(condition) && convertedPrice.compareTo(rulePrice) <= 0)))))) continue;
                return true;
            }
            return false;
        }
    };


    public String getId() {
        return this.name();
    }
}

