/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.standard.nomenclatures;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductDescription;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductDescriptionIndex;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.cache.EntityCacheListener;
import com.gridnine.xtrip.common.model.rules.standard.CommonProductProperties;
import com.gridnine.xtrip.common.model.rules.standard.ProductTicketInfoProperties;
import com.gridnine.xtrip.common.model.rules.standard.RuleEnvironmentHelper;
import com.gridnine.xtrip.common.model.rules.standard.nomenclatures.NomeclatureFilteringCategories;
import com.gridnine.xtrip.common.model.rules.standard.nomenclatures.NomenclatureActions;
import com.gridnine.xtrip.common.rules.RulesEnvironment;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.search.SearchQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class UniversalProductNomenclatureRulesEnvironment {
    private final List<EntityReference<UniversalProductDescription>> actualDescriptions = new ArrayList<EntityReference<UniversalProductDescription>>();

    public void initializeEnvironment(List<EntityContainer<UniversalProductDescription>> descriptions) {
        RulesEnvironment env = RulesEnvironment.get();
        RuleAction[] actions = new RuleAction[]{NomenclatureActions.PRODUCT_NOMENCLATURE, NomenclatureActions.SERVICE_NOMENCLATURE, NomenclatureActions.FEE_NOMENCLATURE, NomenclatureActions.VENDOR_FEE_NOMENCLATURE, NomenclatureActions.HIDDEN_FEE_NOMENCLATURE, NomenclatureActions.CATEGORY_VENDOR_FEE_NOMENCLATURE, NomenclatureActions.CATEGORY_OWN_FEE_NOMENCLATURE, NomenclatureActions.PENALTY_NOMENCLATURE, NomenclatureActions.DISABLE_CREATE_COMPONENTS_FOR_ZERO_FOP};
        NomeclatureFilteringCategories filterCategory = NomeclatureFilteringCategories.NOMENCLATURE;
        for (EntityContainer<UniversalProductDescription> descriptionCtr : descriptions) {
            if (descriptionCtr == null || env.findTarget(UniversalProductNomenclatureRulesEnvironment.getRuleTargetId((EntityReference<UniversalProductDescription>)descriptionCtr.toReference())) != null) continue;
            this.actualDescriptions.add((EntityReference<UniversalProductDescription>)descriptionCtr.toReference());
            UniversalProductNomenclatureRuleTarget target = new UniversalProductNomenclatureRuleTarget(descriptionCtr);
            env.registerTargets(new RuleTarget[]{target});
            RuleEnvironmentHelper.registerFilteringCategory2targetAssociation(env, filterCategory, target);
            RuleEnvironmentHelper.registerPropertyAssociation(env, filterCategory, target, CommonProductProperties.PRODUCT_STATUS, ProductTicketInfoProperties.SUPPLIERS);
            RuleEnvironmentHelper.registerActionAssociation(env, filterCategory, target, actions);
        }
    }

    public void deleteInactualTargets(List<EntityReference<UniversalProductDescription>> descriptions) {
        RulesEnvironment env = RulesEnvironment.get();
        Iterator<EntityReference<UniversalProductDescription>> it = this.actualDescriptions.iterator();
        while (it.hasNext()) {
            EntityReference<UniversalProductDescription> description = it.next();
            if (descriptions.contains(description)) continue;
            env.unregisterTarget(UniversalProductNomenclatureRulesEnvironment.getRuleTargetId(description));
            it.remove();
        }
    }

    private void unregisterTarget(EntityReference<UniversalProductDescription> ref) {
        RulesEnvironment.get().unregisterTarget(UniversalProductNomenclatureRulesEnvironment.getRuleTargetId(ref));
    }

    public static String getRuleTargetId(EntityReference<UniversalProductDescription> description) {
        return String.format("UNIVERSAL_PRODUCT_NOMENCLATURE_%s", description != null ? description.getUid() : null);
    }

    public static class UniversalProductDescriptionNomenclatureEntityCacheListener
    implements EntityCacheListener {
        UniversalProductNomenclatureRulesEnvironment env;

        public UniversalProductDescriptionNomenclatureEntityCacheListener(UniversalProductNomenclatureRulesEnvironment environment) {
            this.env = environment;
        }

        public void onReset() {
            ArrayList<EntityContainer<UniversalProductDescription>> ctrs = new ArrayList<EntityContainer<UniversalProductDescription>>();
            ArrayList<EntityReference<UniversalProductDescription>> refs = new ArrayList<EntityReference<UniversalProductDescription>>();
            for (UniversalProductDescriptionIndex idx : EntityStorage.get().search(UniversalProductDescriptionIndex.class, new SearchQuery()).getData()) {
                EntityContainer ctr = EntityStorage.get().resolve(idx.getSource());
                if (ctr != null) {
                    ctrs.add((EntityContainer<UniversalProductDescription>)ctr);
                }
                refs.add((EntityReference<UniversalProductDescription>)idx.getSource());
            }
            this.env.deleteInactualTargets(refs);
            this.env.initializeEnvironment(ctrs);
        }

        public void onInvalidate(EntityReference<?> ref) {
            if (UniversalProductDescription.class.equals((Object)ref.getType())) {
                EntityReference<?> descrRef = ref;
                EntityContainer ctr = EntityStorage.get().resolve(descrRef);
                if (ctr != null) {
                    this.env.initializeEnvironment(Collections.singletonList(ctr));
                    return;
                }
                this.env.unregisterTarget((EntityReference<UniversalProductDescription>)descrRef);
            }
        }
    }

    public static class UniversalProductNomenclatureRuleTarget
    implements RuleTarget {
        private static final long serialVersionUID = -1126816475441698515L;
        private final EntityContainer<UniversalProductDescription> ctr;
        private final String uid;

        private UniversalProductNomenclatureRuleTarget(EntityContainer<UniversalProductDescription> description) {
            this.ctr = description;
            this.uid = String.format("UniversalProductNomenclatureRuleTarget-%s", this.ctr.getUid());
        }

        public String getId() {
            return UniversalProductNomenclatureRulesEnvironment.getRuleTargetId((EntityReference<UniversalProductDescription>)this.ctr.toReference());
        }

        public String getDisplayName() {
            return L10n.replace((String)L10n.get((String)"RuleTarget_Nomenclature_Universal_Product"), (Object[])new Object[]{((UniversalProductDescription)this.ctr.getEntity()).getName()});
        }

        public boolean isAvailableToCreate() {
            return !((UniversalProductDescription)this.ctr.getEntity()).isDisabled();
        }

        public String getPropertySetClassName() {
            return null;
        }

        public String getActionSetClassName() {
            return null;
        }

        public boolean equals(Object obj) {
            if (obj instanceof UniversalProductNomenclatureRuleTarget) {
                return this.uid.equals(((UniversalProductNomenclatureRuleTarget)obj).uid);
            }
            return false;
        }

        public int hashCode() {
            return this.uid.hashCode();
        }
    }
}

