/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.standard.tchexport;

import com.gridnine.xtrip.common.model.booking.ReservationType;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.PassengerStatus;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.Properties;
import com.gridnine.xtrip.common.model.rules.standard.TchRouteRestrictions;
import com.gridnine.xtrip.common.model.rules.standard.tchexport.TchCondition;
import com.gridnine.xtrip.common.model.rules.standard.tchexport.TchConditionParam;
import com.gridnine.xtrip.common.model.rules.standard.tchexport.TchSubType;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Element;

public enum TchType {
    TRANSPORTATION_TYPE("10", "\u0412\u0438\u0434 \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u043e\u043a"){

        @Override
        boolean formTchCondition(RuleRestriction rr, TchCondition condition) throws Exception {
            if (!Properties.TRANSPORTATION_TYPE.equals(rr.getProperty())) {
                return false;
            }
            TchConditionParam param = new TchConditionParam();
            param.setType(this);
            if (Conditions.TRANSPORTATION_OUTSIDE_CIS.equals(rr.getCondition())) {
                param.setSubType(TchSubType.TRANSPORTATION_OUTSIDE_CIS);
            } else if (Conditions.TRANSPORTATION_INSIDE_CIS.equals(rr.getCondition())) {
                param.setSubType(TchSubType.TRANSPORTATION_INSIDE_CIS);
            } else if (Conditions.TRANSPORTATION_INSIDE_COUNTRY.equals(rr.getCondition())) {
                param.setSubType(TchSubType.TRANSPORTATION_INSIDE_COUNTRY);
            } else if (Conditions.TRANSPORTATION_OUTSIDE_COUNTRY.equals(rr.getCondition())) {
                param.setSubType(TchSubType.TRANSPORTATION_OUTSIDE_COUNTRY);
            } else {
                throw new Exception("\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0435 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u043d\u0430 \u0442\u0438\u043f \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u043a\u0438: " + rr.getCondition());
            }
            if (rr.getValue() != null) {
                param.setCodeValue(rr.getValue().toString());
            }
            condition.getParams().add(param);
            return true;
        }
    }
    ,
    AGENCY("20", "\u0410\u0412\u0421"){

        @Override
        boolean formTchCondition(RuleRestriction rr, TchCondition condition) throws Exception {
            if (!Properties.TCH_AGENCY_CODE.equals(rr.getProperty())) {
                return false;
            }
            TchConditionParam param = new TchConditionParam();
            param.setType(this);
            if (Conditions.EQUALS.equals(rr.getCondition())) {
                param.setSubType(TchSubType.AGENCY_EQUALS);
            } else if (Conditions.NOT_EQUALS.equals(rr.getCondition())) {
                param.setSubType(TchSubType.AGENCY_NOT_EQUALS);
            } else {
                throw new Exception("\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0435 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u043d\u0430 \u043a\u043e\u0434 \u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u0430: " + rr.getCondition());
            }
            if (rr.getValue() != null) {
                param.setCodeValue(rr.getValue().toString());
            }
            condition.getParams().add(param);
            return true;
        }
    }
    ,
    VALIDATORS("21", "\u041f\u0443\u043d\u043a\u0442\u044b \u043f\u0440\u043e\u0434\u0430\u0436\u0438"){

        @Override
        boolean formTchCondition(RuleRestriction rr, TchCondition condition) throws Exception {
            if (!Properties.VALIDATOR.equals(rr.getProperty())) {
                return false;
            }
            TchConditionParam param = new TchConditionParam();
            param.setType(VALIDATORS);
            if (Conditions.EQUALS.equals(rr.getCondition())) {
                param.setSubType(TchSubType.VALIDATORS_EQUALS);
            } else if (Conditions.NOT_EQUALS.equals(rr.getCondition())) {
                param.setSubType(TchSubType.VALIDATORS_NOT_EQUALS);
            } else {
                throw new Exception("\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0435 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u043d\u0430 \u043f\u0443\u043d\u043a\u0442\u044b \u043f\u0440\u043e\u0434\u0430\u0436\u0438: " + rr.getCondition());
            }
            param.setCodeValue(this.getValueFromList(rr.getValue()));
            condition.getParams().add(param);
            return true;
        }
    }
    ,
    VAT("23", "\u041d\u0414\u0421"){

        @Override
        boolean formTchCondition(RuleRestriction rr, TchCondition condition) throws Exception {
            if (!Properties.VAT.equals(rr.getProperty())) {
                return false;
            }
            TchConditionParam param = new TchConditionParam();
            param.setType(VAT);
            if (Conditions.NOT_SIMPLE_TAXED.equals(rr.getCondition())) {
                param.setSubType(TchSubType.VAT_NOT_SIMPLE_TAXED);
            } else if (Conditions.SIMPLE_TAXED.equals(rr.getCondition())) {
                param.setSubType(TchSubType.VAT_SIMPLE_TAXED);
            } else {
                throw new Exception("\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0435 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u043d\u0430 \u041f\u043b\u0430\u0442\u0435\u043b\u044c\u0449\u0438\u043a\u0430 \u041d\u0414\u0421: " + rr.getCondition());
            }
            if (rr.getValue() != null) {
                param.setCodeValue(rr.getValue().toString());
            }
            condition.getParams().add(param);
            return true;
        }
    }
    ,
    SALES_POINT_COUNTRIES("26", "\u041f\u041f\u0440 \u0432 \u0441\u0442\u0440\u0430\u043d\u0430\u0445"){

        @Override
        boolean formTchCondition(RuleRestriction rr, TchCondition condition) throws Exception {
            if (!Properties.SALES_POINT_COUNTRY_CODES.equals(rr.getProperty())) {
                return false;
            }
            TchConditionParam param = new TchConditionParam();
            param.setType(this);
            if (Conditions.INCLUDE.equals(rr.getCondition())) {
                param.setSubType(TchSubType.SALES_POINT_COUNTRIES_INCLUDE);
            } else if (Conditions.EXCLUDE.equals(rr.getCondition())) {
                param.setSubType(TchSubType.SALES_POINT_COUNTRIES_EXCLUDE);
            } else {
                throw new Exception("\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0435 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u043d\u0430 \u0441\u0442\u0440\u0430\u043d\u0443 \u043f\u0443\u043d\u043a\u0442\u0430 \u043f\u0440\u043e\u0434\u0430\u0436\u0438: " + rr.getCondition());
            }
            param.setCodeValue(this.getValueFromList(rr.getValue()));
            condition.getParams().add(param);
            return true;
        }
    }
    ,
    AGENCY_COUNTRIES("27", "\u0410\u0412\u0421 \u0432 \u0441\u0442\u0440\u0430\u043d\u0430\u0445"){

        @Override
        boolean formTchCondition(RuleRestriction rr, TchCondition condition) throws Exception {
            if (!Properties.AGENCY_COUNTRY_CODES.equals(rr.getProperty())) {
                return false;
            }
            TchConditionParam param = new TchConditionParam();
            param.setType(this);
            if (Conditions.INCLUDE.equals(rr.getCondition())) {
                param.setSubType(TchSubType.AGENCY_COUNTRIES_INCLUDE);
            } else if (Conditions.EXCLUDE.equals(rr.getCondition())) {
                param.setSubType(TchSubType.AGENCY_COUNTRIES_EXCLUDE);
            } else {
                throw new Exception("\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0435 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u043d\u0430 \u0441\u0442\u0440\u0430\u043d\u0443 \u0440\u0430\u0441\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u0430: " + rr.getCondition());
            }
            if (rr.getValue() != null) {
                param.setCodeValue(rr.getValue().toString());
            }
            condition.getParams().add(param);
            return true;
        }
    }
    ,
    DIRECTION("29", "\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435"){

        @Override
        boolean formTchCondition(RuleRestriction rr, TchCondition condition) throws Exception {
            if (!Properties.ROUTE.equals(rr.getProperty())) {
                return false;
            }
            TchConditionParam param = new TchConditionParam();
            param.setType(this);
            if (Conditions.BEGINS_WITH.equals(rr.getCondition())) {
                param.setSubType(TchSubType.DIRECTION_BEGINS_WITH);
            } else if (Conditions.NOT_BEGINS_WITH.equals(rr.getCondition())) {
                param.setSubType(TchSubType.DIRECTION_NOT_BEGINS_WITH);
            } else {
                throw new Exception("\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0435 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u043d\u0430 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435: " + rr.getCondition());
            }
            param.setCodeValue(this.buildValueWithCountryPrefix(rr.getValue()));
            condition.getParams().add(param);
            return true;
        }
    }
    ,
    INTERLINE("30", "\u0418\u043d\u0442\u0435\u0440\u043b\u0430\u0439\u043d"){

        @Override
        boolean formTchCondition(RuleRestriction rr, TchCondition condition) throws Exception {
            if (!Properties.TCH_ROUTE.equals(rr.getProperty()) && !Properties.INTERLINE.equals(rr.getProperty())) {
                return false;
            }
            TchConditionParam param = new TchConditionParam();
            param.setType(this);
            if (rr.getProperty().equals(Properties.INTERLINE)) {
                param.setCodeValue(null);
                param.setSubType(TchSubType.INTERLINE_NOT_OWN_ALL);
            } else {
                TchRouteRestrictions trr = (TchRouteRestrictions)rr.getValue();
                TchRouteRestrictions.InterlineRestriction intRest = trr.getInterlineRestriction();
                if (TchRouteRestrictions.InterlineRestriction.NONE.equals((Object)intRest)) {
                    param.setSubType(TchSubType.INTERLINE_NONE);
                } else if (TchRouteRestrictions.InterlineRestriction.INCLUDING.equals((Object)intRest)) {
                    param.setSubType(TchSubType.INTERLINE_INCLUDING);
                } else if (TchRouteRestrictions.InterlineRestriction.ONLY.equals((Object)intRest)) {
                    param.setSubType(TchSubType.INTERLINE_ONLY);
                } else if (TchRouteRestrictions.InterlineRestriction.ALL.equals((Object)intRest)) {
                    param.setSubType(TchSubType.INTERLINE_ALL);
                } else if (TchRouteRestrictions.InterlineRestriction.EXCLUDING.equals((Object)intRest)) {
                    param.setSubType(TchSubType.INTERLINE_EXCLUDING);
                } else if (TchRouteRestrictions.InterlineRestriction.NOT_OWN_AND_ONLY.equals((Object)intRest)) {
                    param.setSubType(TchSubType.INTERLINE_NOT_OWN_AND_ONLY);
                } else {
                    throw new Exception("\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0435 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u043d\u0430 \u0438\u043d\u0442\u0435\u0440\u043b\u0430\u0439\u043d: " + rr.getCondition());
                }
                param.setCodeValue(trr.getInterlineValue());
            }
            condition.getParams().add(param);
            return true;
        }
    }
    ,
    ROUTES("31", "\u041c\u0430\u0440\u0448\u0440\u0443\u0442"){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        boolean formTchCondition(RuleRestriction rr, TchCondition condition) throws Exception {
            if (!Properties.TCH_ROUTE.equals(rr.getProperty())) {
                return false;
            }
            TchConditionParam param = new TchConditionParam();
            param.setType(this);
            TchRouteRestrictions trr = (TchRouteRestrictions)rr.getValue();
            TchRouteRestrictions.RouteRestriction routeRest = trr.getRouteRestriction();
            if (TchRouteRestrictions.RouteRestriction.ALL.equals((Object)routeRest)) {
                param.setSubType(TchSubType.ROUTES_ALL);
            } else if (TchRouteRestrictions.RouteRestriction.ONLY.equals((Object)routeRest)) {
                param.setSubType(TchSubType.ROUTES_ONLY);
            } else if (TchRouteRestrictions.RouteRestriction.EXCEPT.equals((Object)routeRest)) {
                param.setSubType(TchSubType.ROUTES_EXCEPT);
            } else if (TchRouteRestrictions.RouteRestriction.START.equals((Object)routeRest)) {
                String[] locations = trr.getRouteValue().split(",");
                if (locations[0].length() == 2) {
                    param.setSubType(TchSubType.ROUTES_START_COUNTRY);
                } else {
                    if (locations[0].length() != 3) throw new Exception("\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0442\u0438\u043f \u043a\u043e\u0434\u0430 \u0434\u043b\u044f \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u044f \u043d\u0430 \u043c\u0430\u0440\u0448\u0440\u0443\u0442: " + locations[0]);
                    param.setSubType(TchSubType.ROUTES_START_CITY);
                }
            } else if (TchRouteRestrictions.RouteRestriction.NOT_START_FROM.equals((Object)routeRest)) {
                param.setSubType(TchSubType.ROUTES_NOT_START_COUNTRY);
            } else {
                if (!TchRouteRestrictions.RouteRestriction.CONSIST_OF.equals((Object)routeRest)) throw new Exception("\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0435 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u043d\u0430 \u043c\u0430\u0440\u0448\u0440\u0443\u0442: " + (Object)((Object)routeRest));
                param.setSubType(TchSubType.ROUTES_CONSIST_OF);
            }
            param.setCodeValue(trr.getRouteValue());
            condition.getParams().add(param);
            return true;
        }
    }
    ,
    FLIGHTS("32", "\u0420\u0435\u0439\u0441"){

        @Override
        boolean formTchCondition(RuleRestriction rr, TchCondition condition) throws Exception {
            if (!Properties.TCH_ROUTE.equals(rr.getProperty())) {
                return false;
            }
            TchConditionParam param = new TchConditionParam();
            param.setType(this);
            TchRouteRestrictions trr = (TchRouteRestrictions)rr.getValue();
            TchRouteRestrictions.FlightNumbersRestriction flightRest = trr.getFlightNumbersRestriction();
            if (TchRouteRestrictions.FlightNumbersRestriction.ALL.equals((Object)flightRest)) {
                param.setSubType(TchSubType.FLIGHTS_ALL);
            } else if (TchRouteRestrictions.FlightNumbersRestriction.ONLY.equals((Object)flightRest)) {
                param.setSubType(TchSubType.FLIGHTS_ONLY);
            } else if (TchRouteRestrictions.FlightNumbersRestriction.EXCEPT.equals((Object)flightRest)) {
                param.setSubType(TchSubType.FLIGHTS_EXCEPT);
            } else {
                throw new Exception("\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0435 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u043d\u0430 \u0440\u0435\u0439\u0441\u044b: " + (Object)((Object)flightRest));
            }
            param.setCodeValue(trr.getFlightNumbersValue());
            condition.getParams().add(param);
            return true;
        }
    }
    ,
    DEPARTURE_DATE("33", "\u0414\u0430\u0442\u0430 \u0432\u044b\u043b\u0435\u0442\u0430"){

        @Override
        boolean formTchCondition(RuleRestriction rr, TchCondition condition) throws Exception {
            if (!Properties.TCH_ROUTE.equals(rr.getProperty())) {
                return false;
            }
            TchConditionParam param = new TchConditionParam();
            param.setType(this);
            TchRouteRestrictions trr = (TchRouteRestrictions)rr.getValue();
            TchRouteRestrictions.DepartureDatesRestriction depDatesRest = trr.getDepartureDatesRestriction();
            if (TchRouteRestrictions.DepartureDatesRestriction.ALL.equals((Object)depDatesRest)) {
                param.setSubType(TchSubType.DEPARTURE_DATE_ALL);
            } else if (TchRouteRestrictions.DepartureDatesRestriction.ONLY.equals((Object)depDatesRest) || TchRouteRestrictions.DepartureDatesRestriction.EXCEPT.equals((Object)depDatesRest) || TchRouteRestrictions.DepartureDatesRestriction.CONSIST_OF.equals((Object)depDatesRest)) {
                TchSubType subtype;
                SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
                Date dateFrom = MiscUtil.clearTime((Date)trr.getDepartureDatesFromValue());
                Date dateTo = MiscUtil.clearTime((Date)(trr.getDepartureDatesToValue() == null ? trr.getDepartureDatesFromValue() : trr.getDepartureDatesToValue()));
                String codeValue = dateFrom.equals(dateTo) ? sdf.format(dateFrom) : sdf.format(dateFrom) + "-" + sdf.format(dateTo);
                switch (depDatesRest) {
                    case ONLY: {
                        subtype = dateFrom.equals(dateTo) ? TchSubType.DEPARTURE_DATE_ONLY : TchSubType.DEPARTURE_DATE_INTERVAL;
                        break;
                    }
                    case EXCEPT: {
                        subtype = dateFrom.equals(dateTo) ? TchSubType.DEPARTURE_DATE_EXCEPT : TchSubType.DEPARTURE_DATE_EXCEPT_INTERVAL;
                        break;
                    }
                    default: {
                        subtype = TchSubType.DEPARTURE_DATE_CONSIST_OF;
                    }
                }
                param.setSubType(subtype);
                param.setCodeValue(codeValue);
            } else {
                throw new Exception("\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0435 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u043d\u0430 \u0434\u0430\u0442\u0443 \u0432\u044b\u043b\u0435\u0442\u0430: " + rr.getCondition());
            }
            condition.getParams().add(param);
            return true;
        }
    }
    ,
    BOOKING_CLASSES("34", "\u041a\u043b\u0430\u0441\u0441\u044b"){

        @Override
        boolean formTchCondition(RuleRestriction rr, TchCondition condition) throws Exception {
            if (!Properties.TCH_ROUTE.equals(rr.getProperty())) {
                return false;
            }
            TchConditionParam param = new TchConditionParam();
            param.setType(this);
            TchRouteRestrictions trr = (TchRouteRestrictions)rr.getValue();
            TchRouteRestrictions.ClassOfBookingRestriction rest = trr.getClassOfBookingRestriction();
            if (TchRouteRestrictions.ClassOfBookingRestriction.ALL.equals((Object)rest)) {
                param.setSubType(TchSubType.BOOKING_CLASSES_ALL);
            } else if (TchRouteRestrictions.ClassOfBookingRestriction.ONLY.equals((Object)rest)) {
                param.setSubType(TchSubType.BOOKING_CLASSES_ONLY);
            } else if (TchRouteRestrictions.ClassOfBookingRestriction.EXCEPT.equals((Object)rest)) {
                param.setSubType(TchSubType.BOOKING_CLASSES_EXCEPT);
            } else {
                throw new Exception("\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0435 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u043d\u0430 \u043a\u043b\u0430\u0441\u0441\u044b \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f: " + (Object)((Object)rest));
            }
            param.setCodeValue(trr.getClassOfBookingValue());
            condition.getParams().add(param);
            return true;
        }
    }
    ,
    TARIFF_CODE("35", "\u041a\u043e\u0434 \u0442\u0430\u0440\u0438\u0444\u0430"){

        @Override
        boolean formTchCondition(RuleRestriction rr, TchCondition condition) throws Exception {
            if (!Properties.TCH_ROUTE.equals(rr.getProperty())) {
                return false;
            }
            TchConditionParam param = new TchConditionParam();
            param.setType(this);
            TchRouteRestrictions trr = (TchRouteRestrictions)rr.getValue();
            TchRouteRestrictions.TariffCodeRestriction rest = trr.getTariffCodeRestriction();
            if (TchRouteRestrictions.TariffCodeRestriction.ALL.equals((Object)rest)) {
                param.setSubType(TchSubType.TARIFF_CODE_ALL);
            } else if (TchRouteRestrictions.TariffCodeRestriction.ONLY.equals((Object)rest)) {
                param.setSubType(TchSubType.TARIFF_CODE_ONLY);
            } else if (TchRouteRestrictions.TariffCodeRestriction.EXCEPT.equals((Object)rest)) {
                param.setSubType(TchSubType.TARIFF_CODE_EXCEPT);
            } else if (TchRouteRestrictions.TariffCodeRestriction.INCLUDE.equals((Object)rest)) {
                param.setSubType(TchSubType.TARIFF_CODE_INCLUDE);
            } else if (TchRouteRestrictions.TariffCodeRestriction.NOT_INCLUDE.equals((Object)rest)) {
                param.setSubType(TchSubType.TARIFF_CODE_EXCLUDE);
            } else {
                throw new Exception("\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0435 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u043d\u0430 \u043a\u043e\u0434 \u0442\u0430\u0440\u0438\u0444\u0430: " + (Object)((Object)rest));
            }
            param.setCodeValue(trr.getTariffCodeValue());
            condition.getParams().add(param);
            return true;
        }
    }
    ,
    DEPARTURE_DAY("36", "\u0414\u0435\u043d\u044c \u043d\u0435\u0434\u0435\u043b\u0438"){

        @Override
        boolean formTchCondition(RuleRestriction rr, TchCondition condition) throws Exception {
            if (!Properties.TCH_ROUTE.equals(rr.getProperty())) {
                return false;
            }
            TchConditionParam param = new TchConditionParam();
            param.setType(this);
            TchRouteRestrictions trr = (TchRouteRestrictions)rr.getValue();
            TchRouteRestrictions.DepartureDaysRestriction rest = trr.getDepartureDaysRestriction();
            if (TchRouteRestrictions.DepartureDaysRestriction.ALL.equals((Object)rest)) {
                param.setSubType(TchSubType.DEPARTURE_DAY_ALL);
            } else if (TchRouteRestrictions.DepartureDaysRestriction.ONLY.equals((Object)rest)) {
                param.setSubType(TchSubType.DEPARTURE_DAY_ONLY);
            } else if (TchRouteRestrictions.DepartureDaysRestriction.EXCEPT.equals((Object)rest)) {
                param.setSubType(TchSubType.DEPARTURE_DAY_EXCEPT);
            } else {
                throw new Exception("\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0435 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u043d\u0430 \u0434\u0435\u043d\u044c \u043d\u0435\u0434\u0435\u043b\u0438: " + rr.getCondition());
            }
            param.setCodeValue(trr.getDepartureDaysValue());
            condition.getParams().add(param);
            return true;
        }
    }
    ,
    AIRLINES("37", "\u041f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a\u0438"){

        @Override
        boolean formTchCondition(RuleRestriction rr, TchCondition condition) {
            if (!Properties.AIRLINES.equals(rr.getProperty())) {
                return false;
            }
            TchConditionParam param = new TchConditionParam();
            param.setType(this);
            if (!Conditions.INCLUDE.equals(rr.getCondition())) {
                return false;
            }
            param.setSubType(TchSubType.AIRLINES_INCLUDE);
            param.setCodeValue(this.getValueFromList(rr.getValue()));
            condition.getParams().add(param);
            return true;
        }
    }
    ,
    RESERVATION_TYPE("38", "\u0411\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435"){

        @Override
        boolean formTchCondition(RuleRestriction rr, TchCondition condition) throws Exception {
            if (!Properties.RESERVATION_TYPE.equals(rr.getProperty())) {
                return false;
            }
            TchConditionParam param = new TchConditionParam();
            param.setType(this);
            if (Conditions.EQUALS.equals(rr.getCondition())) {
                param.setSubType(TchSubType.RESERVATION_TYPE_EQUALS);
            } else if (Conditions.NOT_EQUALS.equals(rr.getCondition())) {
                param.setSubType(TchSubType.RESERVATION_TYPE_NOT_EQUALS);
            } else {
                throw new Exception("\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0435 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u043d\u0430 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435: " + rr.getCondition());
            }
            List types = (List)rr.getValue();
            param.setCodeValue(this.buildReservationTypesStr(types));
            condition.getParams().add(param);
            return true;
        }

        private String buildReservationTypesStr(List<ReservationType> resTypes) {
            if (resTypes == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            for (ReservationType type : resTypes) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                if (ReservationType.CALL_CENTER.equals((Object)type) || ReservationType.OFFLINE.equals((Object)type)) {
                    sb.append("clc");
                    continue;
                }
                if (!ReservationType.INTERNET.equals((Object)type) && !ReservationType.IBE.equals((Object)type)) continue;
                sb.append("int");
            }
            return sb.toString();
        }
    }
    ,
    ORGANIZATION("39", "\u041a\u043e\u0434 \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438"){

        @Override
        boolean formTchCondition(RuleRestriction rr, TchCondition condition) throws Exception {
            if (!Properties.PASSENGER_STATUS.equals(rr.getProperty())) {
                return false;
            }
            TchConditionParam param = new TchConditionParam();
            param.setType(this);
            List statuses = (List)rr.getValue();
            String value = this.buildOrgCodesStr(statuses);
            param.setCodeValue(value);
            if (Conditions.NOT_EQUALS.equals(rr.getCondition())) {
                if (this.isStandardValue(value)) {
                    param.setSubType(TchSubType.ORGANIZATION_STANDARD);
                    param.setCodeValue(null);
                } else {
                    param.setSubType(TchSubType.ORGANIZATION_NOT_EQUALS);
                }
            } else if (Conditions.EQUALS.equals(rr.getCondition())) {
                param.setSubType(TchSubType.ORGANIZATION_EQUALS);
            } else {
                throw new Exception("\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0435 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u043d\u0430 \u043a\u043e\u0434 \u043e\u0440\u0433\u0430\u0438\u043d\u0437\u0430\u0446\u0438\u0438: " + rr.getCondition());
            }
            condition.getParams().add(param);
            return true;
        }

        private boolean isStandardValue(String value) {
            return value.contains("\u0412\u041d") && value.contains("\u0412\u0412") && value.contains("\u0427\u0421") && value.contains("\u041f\u0424") && value.contains("\u0424\u0421") && value.split(",").length == 5;
        }

        private String buildOrgCodesStr(List<PassengerStatus> statuses) {
            if (statuses == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            for (PassengerStatus status : statuses) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                if (PassengerStatus.VS_MVD.equals((Object)status)) {
                    sb.append("\u0412\u0412");
                    continue;
                }
                if (PassengerStatus.VS_MO.equals((Object)status)) {
                    sb.append("\u0412\u041d");
                    continue;
                }
                if (PassengerStatus.MCHS.equals((Object)status)) {
                    sb.append("\u0427\u0421");
                    continue;
                }
                if (PassengerStatus.FOND_STRAX.equals((Object)status)) {
                    sb.append("\u0424\u0421");
                    continue;
                }
                if (PassengerStatus.PENS_FOND.equals((Object)status)) {
                    sb.append("\u041f\u0424");
                    continue;
                }
                if (PassengerStatus.DEP_GD.equals((Object)status)) {
                    sb.append("\u0413\u0414");
                    continue;
                }
                if (PassengerStatus.INV_1_GROUP.equals((Object)status)) {
                    sb.append("\u0414\u0415");
                    continue;
                }
                if (PassengerStatus.SUD.equals((Object)status)) {
                    sb.append("\u0414\u0421");
                    continue;
                }
                if (!PassengerStatus.SOV_FED.equals((Object)status)) continue;
                sb.append("\u0414\u0424");
            }
            return sb.toString();
        }
    }
    ,
    E_TICKET("60", "\u041f\u0435\u0440\u0435\u0432. \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442"){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        boolean formTchCondition(RuleRestriction rr, TchCondition condition) throws Exception {
            if (!Properties.E_TICKET.equals(rr.getProperty())) {
                return false;
            }
            TchConditionParam param = new TchConditionParam();
            param.setType(this);
            if (!Conditions.EQUALS.equals(rr.getCondition())) throw new Exception("\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0435 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u043d\u0430 \u0442\u0438\u043f \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u043e\u0447\u043d\u043e\u0433\u043e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430: " + rr.getCondition());
            if (Boolean.TRUE.equals(rr.getValue())) {
                param.setSubType(TchSubType.E_TICKET_TRUE);
            } else {
                if (!Boolean.FALSE.equals(rr.getValue())) throw new Exception("\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0432 \u0442\u0438\u043f\u0435 \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u043e\u0447\u043d\u043e\u0433\u043e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430: " + rr.getValue().toString());
                param.setSubType(TchSubType.E_TICKET_FALSE);
            }
            condition.getParams().add(param);
            return true;
        }
    }
    ,
    REPORT_CURRENCY("61", "\u0412\u0430\u043b\u044e\u0442\u0430 \u043e\u0442\u0447\u0435\u0442\u0430"){

        @Override
        boolean formTchCondition(RuleRestriction rr, TchCondition condition) {
            return false;
        }
    }
    ,
    AIRLINE_PARTICIPATION("62", "\u0423\u0447\u0430\u0441\u0442\u0438\u0435 \u0410\u041a"){

        @Override
        boolean formTchCondition(RuleRestriction rr, TchCondition condition) {
            if (!Properties.AIRLINES.equals(rr.getProperty())) {
                return false;
            }
            TchConditionParam param = new TchConditionParam();
            param.setType(this);
            if (!Conditions.EXCLUDE.equals(rr.getCondition())) {
                return false;
            }
            param.setSubType(TchSubType.AIRLINE_PARTICIPATION_EXCLUDE);
            param.setCodeValue(this.getValueFromList(rr.getValue()));
            condition.getParams().add(param);
            return true;
        }
    }
    ,
    AGS("63", "\u0410\u0413\u0421"){

        @Override
        boolean formTchCondition(RuleRestriction rr, TchCondition condition) throws Exception {
            if (!Properties.TAX_CODES.equals(rr.getProperty())) {
                return false;
            }
            TchConditionParam param = new TchConditionParam();
            param.setType(this);
            if (Conditions.EXCLUDE.equals(rr.getCondition())) {
                param.setSubType(TchSubType.AGS_EXCLUDE);
            } else if (Conditions.INCLUDE.equals(rr.getCondition())) {
                if (rr.getValue().toString().contains(",")) {
                    param.setSubType(TchSubType.AGS_INCLUDE_ANY);
                } else {
                    param.setSubType(TchSubType.AGS_INCLUDE_ALL);
                }
            } else {
                throw new Exception("\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0435 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u043d\u0430 \u0410\u0413\u0421: " + rr.getCondition());
            }
            param.setCodeValue(rr.getValue().toString());
            condition.getParams().add(param);
            return true;
        }
    }
    ,
    SERVICE_TYPE("5", "\u0422\u0438\u043f \u0443\u0441\u043b\u0443\u0433\u0438"){

        @Override
        boolean formTchCondition(RuleRestriction rr, TchCondition condition) throws Exception {
            if (!Properties.TCH_SERVICE_TYPE.equals(rr.getProperty())) {
                return false;
            }
            TchConditionParam param = new TchConditionParam();
            param.setType(this);
            if (Conditions.TCH_SERVICE_TYPE_AIR_TICKETS.equals(rr.getCondition()) || Conditions.TCH_SERVICE_TYPE_AIR_AND_EXCESS_BAGGAGE.equals(rr.getCondition())) {
                param.setSubType(TchSubType.SERVICE_TYPE_AIRTICKETS);
            } else if (Conditions.TCH_SERVICE_TYPE_ADDITIONAL_SERVICES.equals(rr.getCondition())) {
                param.setSubType(TchSubType.SERVICE_TYPE_ADDITIONAL_SERVICES);
            } else if (Conditions.TCH_SERVICE_TYPE_ADDITIONAL_SERVICES_AND_LUGGAGE.equals(rr.getCondition())) {
                param.setSubType(TchSubType.SERVICE_TYPE_ADDITIONAL_SERVICES_AND_LUGGAGE);
            } else {
                throw new Exception("\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0435 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u043d\u0430 \u0422\u0438\u043f \u0443\u0441\u043b\u0443\u0433\u0438: " + rr.getCondition());
            }
            condition.getParams().add(param);
            return true;
        }
    }
    ,
    ADDITIONAL_SERVICE_CODE("66", "\u041a\u043e\u0434 \u0434\u043e\u043f.\u0443\u0441\u043b\u0443\u0433\u0438"){

        @Override
        boolean formTchCondition(RuleRestriction rr, TchCondition condition) throws Exception {
            if (!Properties.TCH_ADDITIONAL_SERVICE_CODES.equals(rr.getProperty())) {
                return false;
            }
            TchConditionParam param = new TchConditionParam();
            param.setType(this);
            if (Conditions.INCLUDE.equals(rr.getCondition())) {
                param.setSubType(TchSubType.ADDITIONAL_SERVICE_CODE_EQUALS);
            } else if (Conditions.EXCLUDE.equals(rr.getCondition())) {
                param.setSubType(TchSubType.ADDITIONAL_SERVICE_CODE_NOT_EQUALS);
            } else {
                throw new Exception("\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0435 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u043d\u0430 \u0422\u0438\u043f \u0443\u0441\u043b\u0443\u0433\u0438: " + rr.getCondition());
            }
            param.setCodeValue(this.getValueFromList(rr.getValue()));
            condition.getParams().add(param);
            return true;
        }
    }
    ,
    GDS_CODE("64", "\u041a\u043e\u0434\u044b \u042d\u0410\u0421\u0411"){

        @Override
        boolean formTchCondition(RuleRestriction rr, TchCondition condition) throws Exception {
            if (!Properties.GDS_NAME.equals(rr.getProperty())) {
                return false;
            }
            TchConditionParam param = new TchConditionParam();
            param.setType(this);
            if (Conditions.EQUALS.equals(rr.getCondition())) {
                param.setSubType(TchSubType.GDS_CODE_EQUALS);
            } else if (Conditions.NOT_EQUALS.equals(rr.getCondition())) {
                param.setSubType(TchSubType.GDS_CODE_NOT_EQUALS);
            } else {
                throw new Exception("\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0435 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u043d\u0430 \u041a\u043e\u0434\u044b \u042d\u0410\u0421\u0411: " + rr.getCondition());
            }
            param.setCodeValue(this.buildValue(rr.getValue()));
            condition.getParams().add(param);
            return true;
        }

        private String buildValue(Object obj) {
            if (!(obj instanceof List)) {
                return null;
            }
            List values = (List)obj;
            StringBuilder res = new StringBuilder();
            for (GdsName gds : values) {
                if (res.length() > 0) {
                    res.append(",");
                }
                if (GdsName.SABRE.equals((Object)gds)) {
                    res.append("1S");
                    continue;
                }
                if (!GdsName.SIRENA.equals((Object)gds)) continue;
                res.append("\u0413\u0420\u0421");
            }
            return res.toString();
        }
    }
    ,
    CODE_SHARING("65", "\u041e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u043d\u0430 code-share"){

        @Override
        boolean formTchCondition(RuleRestriction rr, TchCondition condition) throws Exception {
            if (!Properties.CODE_SHARING.equals(rr.getProperty())) {
                return false;
            }
            TchConditionParam param = new TchConditionParam();
            param.setType(this);
            if (Conditions.NOT_SET.equals(rr.getCondition())) {
                param.setSubType(TchSubType.CODE_SHARING_NOT_SET);
            } else if (Conditions.NOT_SET_OR_INCLUDE.equals(rr.getCondition())) {
                param.setSubType(TchSubType.CODE_SHARING_NOT_SET_OR_INCLUDE);
            } else if (Conditions.INCLUDE.equals(rr.getCondition())) {
                param.setSubType(TchSubType.CODE_SHARING_INCLUDE);
            } else if (Conditions.NOT_SET_OR_EXCLUDE.equals(rr.getCondition())) {
                param.setSubType(TchSubType.CODE_SHARING_NOT_SET_OR_EXCLUDE);
            } else if (Conditions.EXCLUDE.equals(rr.getCondition())) {
                param.setSubType(TchSubType.CODE_SHARING_EXCLUDE);
            } else {
                throw new Exception("\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0435 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u043d\u0430 \u043a\u043e\u0434-\u0448\u0435\u0440\u0438\u043d\u0433: " + rr.getCondition());
            }
            param.setCodeValue(this.getValueFromList(rr.getValue()));
            condition.getParams().add(param);
            return true;
        }
    };

    private final String code;
    private final String caption;

    private TchType(String codeValue, String captionValue) {
        this.code = codeValue;
        this.caption = captionValue;
    }

    public String getCode() {
        return this.code;
    }

    public String getCaption() {
        return this.caption;
    }

    protected String getValueFromList(Object value) {
        if (value != null) {
            if (value instanceof String) {
                return value.toString();
            }
            if (value instanceof List) {
                StringBuilder sb = new StringBuilder();
                List values = (List)value;
                for (Object obj : values) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(obj.toString());
                }
                return sb.toString();
            }
        }
        return null;
    }

    protected String buildValueWithCountryPrefix(Object value) {
        if (!(value instanceof List)) {
            return null;
        }
        List values = (List)value;
        StringBuilder sb = new StringBuilder();
        for (Object obj : values) {
            String s;
            if (sb.length() > 0) {
                sb.append(";");
            }
            if ((s = obj.toString()).length() == 2) {
                sb.append("\u0421\u0442\u0440:");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public void toXml(Element elm, String namespace) {
        Element subElement = XmlUtil.addElement((Element)elm, (String)"type_param", (boolean)false, (String)namespace);
        XHelper.writeString((Element)subElement, (String)"type_id", (String)this.getCode(), (String)namespace);
        XHelper.writeString((Element)subElement, (String)"name", (String)this.getCaption(), (String)namespace);
    }

    abstract boolean formTchCondition(RuleRestriction var1, TchCondition var2) throws Exception;
}

