/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.travelPolicy;

import com.gridnine.xtrip.common.model.rules.standard.Actions;
import com.gridnine.xtrip.common.model.rules.standard.CarRentalProductProperties;
import com.gridnine.xtrip.common.model.rules.standard.HotelProperties;
import com.gridnine.xtrip.common.model.rules.standard.Properties;
import com.gridnine.xtrip.common.model.rules.standard.RuleEnvironmentHelper;
import com.gridnine.xtrip.common.model.rules.standard.RulePropertyConditions;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.rules.standard.TransferProperties;
import com.gridnine.xtrip.common.model.rules.standard.UDIDProperty;
import com.gridnine.xtrip.common.model.rules.travelPolicy.TravelPolicyActions;
import com.gridnine.xtrip.common.model.rules.travelPolicy.TravelPolicyFilteringCategories;
import com.gridnine.xtrip.common.model.rules.travelPolicy.TravelPolicyProperties;
import com.gridnine.xtrip.common.model.rules.travelPolicy.TravelPolicyTargets;
import com.gridnine.xtrip.common.rules.RuleFilteringCategory;
import com.gridnine.xtrip.common.rules.RulesEnvironment;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;

public class TravelPolicyRulesEnvironment
implements RulesEnvironment.Hook {
    public void environmentInitialized(RulesEnvironment env) {
        RuleTarget[] targets = new RuleTarget[]{TravelPolicyTargets.TRAVEL_POLICY_AVIA, TravelPolicyTargets.TRAVEL_POLICY_RAILWAY, TravelPolicyTargets.TRAVEL_POLICY_HOTELS, TravelPolicyTargets.TRAVEL_POLICY_TRANSFER, TravelPolicyTargets.TRAVEL_POLICY_CAR_RENTAL, TravelPolicyTargets.TRAVEL_POLICY_AUTHORIZATION};
        env.registerTargets(targets);
        env.registerProperties((RuleProperty[])TravelPolicyProperties.values());
        env.registerProperties(new RuleProperty[]{new UDIDProperty()});
        this.registerFilteringCategoriesTravelPolicyProperties(env, TravelPolicyFilteringCategories.TRAVEL_POLICY);
        RuleAction[] actions = TravelPolicyActions.values();
        String filteringCategoryId = TravelPolicyFilteringCategories.TRAVEL_POLICY.getId();
        env.registerActions(actions);
        for (RuleTarget target : targets) {
            String targetId = target.getId();
            env.registerFilteringCategory2targetAssociation(filteringCategoryId, targetId);
        }
        RuleTarget[] ruleTargetArray = actions;
        int n = ruleTargetArray.length;
        for (int i = 0; i < n; ++i) {
            RuleTarget action = ruleTargetArray[i];
            if (action == TravelPolicyActions.TRAVEL_POLICY_AUTHORIZATION_UNIT_REQUIRED) continue;
            String actionId = action.getId();
            env.registerFilteringCategory2actionAssociation(filteringCategoryId, actionId);
            for (String targetId : action.getTargets()) {
                env.registerTarget2actionAssociation(targetId, actionId);
            }
        }
        TravelPolicyFilteringCategories filteringCategory = TravelPolicyFilteringCategories.ORG_TRAVEL_POLICY;
        this.registerFilteringCategoriesTravelPolicyProperties(env, filteringCategory);
        for (RuleTarget target : targets) {
            if (target == TravelPolicyTargets.TRAVEL_POLICY_AUTHORIZATION) continue;
            env.registerFilteringCategory2targetAssociation(filteringCategory.getId(), target.getId());
            if (target != TravelPolicyTargets.TRAVEL_POLICY_CAR_RENTAL) {
                RuleEnvironmentHelper.registerActionAssociation(env, filteringCategory, target, TravelPolicyActions.TRAVEL_POLICY_MATCH_TYPE, TravelPolicyActions.TRAVEL_POLICY_RECOMMENDED, TravelPolicyActions.TRAVEL_POLICY_KEY_CONTACTS, TravelPolicyActions.TRAVEL_POLICY_REASON_CODE_REQUIRED, Actions.DISPLAY_MESSAGE);
            }
            if (target == TravelPolicyTargets.TRAVEL_POLICY_AVIA || target == TravelPolicyTargets.TRAVEL_POLICY_CAR_RENTAL) {
                RuleEnvironmentHelper.registerActionAssociation(env, filteringCategory, target, TravelPolicyActions.DISPLAY_WARNING_TRAVEL_POLICY_VIOLATION, TravelPolicyActions.TRAVEL_POLICY_VIOLATION_PROHIBIT_END_PNR);
            }
            if (target != TravelPolicyTargets.TRAVEL_POLICY_CAR_RENTAL) continue;
            env.registerTarget2actionAssociation(target.getId(), Actions.DISPLAY_MESSAGE.getId());
        }
        filteringCategory = TravelPolicyFilteringCategories.ORG_TRAVEL_POLICY_AUTHORIZATION;
        this.registerFilteringCategoriesTravelPolicyProperties(env, filteringCategory);
        for (RuleTarget target : targets) {
            env.registerFilteringCategory2targetAssociation(filteringCategory.getId(), target.getId());
            RuleEnvironmentHelper.registerActionAssociation(env, filteringCategory, target, TravelPolicyActions.TRAVEL_POLICY_AUTHORIZATION_UNIT_REQUIRED, Actions.DISPLAY_MESSAGE);
        }
    }

    private void registerFilteringCategoriesTravelPolicyProperties(RulesEnvironment env, RuleFilteringCategory filteringCategory) {
        TravelPolicyProperties[] props;
        env.registerFilteringCategories(new RuleFilteringCategory[]{filteringCategory});
        this.registerTravelPolicyProperties(env, Targets.PRODUCT_COMMISSION, TravelPolicyTargets.TRAVEL_POLICY_AVIA, filteringCategory);
        this.registerTravelPolicyProperties(env, Targets.HOTELS_COMMISSION, TravelPolicyTargets.TRAVEL_POLICY_HOTELS, filteringCategory);
        this.registerTravelPolicyProperties(env, Targets.TRANSFER, TravelPolicyTargets.TRAVEL_POLICY_TRANSFER, filteringCategory);
        for (TravelPolicyProperties property : props = TravelPolicyProperties.values()) {
            env.registerFilteringCategory2propertyAssociation(filteringCategory.getId(), property.getId());
            for (String targetId : property.getTargetIds()) {
                env.registerTarget2propertyAssociation(targetId, property.getId());
            }
            for (String conditionId : property.getConditionIds()) {
                env.registerProperty2conditionAssociation(property.getId(), conditionId);
            }
        }
        UDIDProperty udidProperty = new UDIDProperty();
        RuleEnvironmentHelper.registerPropertyAssociation(env, filteringCategory, TravelPolicyTargets.TRAVEL_POLICY_AVIA, Properties.DEPARTURE_WEEK_DAYS, udidProperty);
        RuleEnvironmentHelper.registerPropertyAssociation(env, filteringCategory, TravelPolicyTargets.TRAVEL_POLICY_HOTELS, HotelProperties.STAY_WEEK_DAYS, HotelProperties.HOTEL_MEAL_INCLUDED_IN_TARIFF, HotelProperties.HOTEL_TYPE, udidProperty);
        RuleEnvironmentHelper.registerPropertyAssociation(env, filteringCategory, TravelPolicyTargets.TRAVEL_POLICY_TRANSFER, TransferProperties.TRANSFER_DEPARTURE_WEEK_DAYS);
        this.registerTravelPolicyProperties(env, TravelPolicyTargets.TRAVEL_POLICY_RAILWAY, filteringCategory, Properties.EMPLOYEE_CATEGORIES, udidProperty);
        this.registerTravelPolicyProperties(env, TravelPolicyTargets.TRAVEL_POLICY_AUTHORIZATION, filteringCategory, Properties.EMPLOYEE_CATEGORIES, udidProperty);
        this.registerTravelPolicyProperties(env, TravelPolicyTargets.TRAVEL_POLICY_TRANSFER, filteringCategory, Properties.EMPLOYEE_CATEGORIES, udidProperty);
        RuleEnvironmentHelper.registerPropertyAssociation(env, filteringCategory, TravelPolicyTargets.TRAVEL_POLICY_CAR_RENTAL, CarRentalProductProperties.CAR_RENTAL_VENDOR, CarRentalProductProperties.CAR_RENT_DURATION);
        RuleEnvironmentHelper.registerPropertyAssociation(env, filteringCategory, TravelPolicyTargets.TRAVEL_POLICY_AVIA, Properties.NO_AUTH_APPROVED_REMARK);
    }

    private void registerTravelPolicyProperties(RulesEnvironment env, RuleTarget target, RuleTarget tpTarget, RuleFilteringCategory filteringCategory) {
        for (RuleProperty property : env.getProperties(target)) {
            env.registerFilteringCategory2propertyAssociation(filteringCategory.getId(), property.getId());
            env.registerTarget2propertyAssociation(tpTarget.getId(), property.getId());
        }
    }

    private void registerTravelPolicyProperties(RulesEnvironment env, Enum<? extends RuleTarget> target, RuleFilteringCategory filteringCategory, RuleProperty ... properties) {
        for (RuleProperty property : properties) {
            env.registerFilteringCategory2propertyAssociation(filteringCategory.getId(), property.getId());
            env.registerTarget2propertyAssociation(target.name(), property.getId());
            for (String conditionId : ((RulePropertyConditions)property).getConditionIds()) {
                env.registerProperty2conditionAssociation(property.getId(), conditionId);
            }
        }
    }
}

