/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.security.acl.helper;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Branch;
import com.gridnine.xtrip.common.model.profile.CashRegister;
import com.gridnine.xtrip.common.model.profile.CashRegisterWorkplace;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Holding;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.security.acl.helper.AclRulesHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AclModelRulesHelper {
    private static final Logger log = LoggerFactory.getLogger(AclModelRulesHelper.class);

    public static boolean isMyOrganizations(EntityReference<Organization> data, String userId) {
        ArrayList<EntityReference<Organization>> organizations = new ArrayList<EntityReference<Organization>>();
        try {
            EntityContainer person = EntityStorage.get().find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                organizations.addAll(ProfileHelper.getPersonOrganizations(Arrays.asList(person.toReference()), null, new Date()));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        return AclRulesHelper.isIncludes(data, organizations);
    }

    public static boolean isMyHolding(EntityReference<Holding> data, String userId) {
        ArrayList<EntityReference> holdings = new ArrayList<EntityReference>();
        try {
            EntityContainer person = EntityStorage.get().find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person == null) {
                return false;
            }
            List<EntityReference<Organization>> personOrganizations = ProfileHelper.getPersonOrganizations(Arrays.asList(person.toReference()), null, new Date());
            for (EntityReference<Organization> orgRef : personOrganizations) {
                EntityContainer orgCtr = EntityStorage.get().resolve(orgRef);
                if (orgCtr == null || ((Organization)orgCtr.getEntity()).getHolding() == null) continue;
                holdings.add(((Organization)orgCtr.getEntity()).getHolding());
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        return AclRulesHelper.isIncludes(data, holdings);
    }

    public static boolean isMyOrganizations(Collection<EntityReference<Organization>> data, String userId) {
        ArrayList<EntityReference<Organization>> organizations = new ArrayList<EntityReference<Organization>>();
        try {
            EntityContainer person = EntityStorage.get().find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                organizations.addAll(ProfileHelper.getPersonOrganizations(Arrays.asList(person.toReference()), null, new Date()));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        return AclRulesHelper.isIncludes(data, organizations);
    }

    public static boolean isMySalesPoints(EntityReference<SalesPoint> data, String userId) {
        ArrayList<EntityReference<SalesPoint>> salesPoints = new ArrayList<EntityReference<SalesPoint>>();
        try {
            EntityContainer person = EntityStorage.get().find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                salesPoints.addAll(ProfileHelper.getPersonSalesPoints(Arrays.asList(person.toReference()), new Date()));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        return AclRulesHelper.isIncludes(data, salesPoints);
    }

    public static boolean isMySalesPoints(Collection<EntityReference<SalesPoint>> data, String userId) {
        ArrayList<EntityReference<SalesPoint>> salesPoints = new ArrayList<EntityReference<SalesPoint>>();
        try {
            EntityContainer person = EntityStorage.get().find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                salesPoints.addAll(ProfileHelper.getPersonSalesPoints(Arrays.asList(person.toReference()), new Date()));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        return AclRulesHelper.isIncludes(data, salesPoints);
    }

    public static boolean isMyPersons(EntityReference<Person> data, String userId) {
        ArrayList<EntityReference> persons = new ArrayList<EntityReference>();
        try {
            EntityContainer person = EntityStorage.get().find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                persons.add(person.toReference());
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        return AclRulesHelper.isIncludes(data, persons);
    }

    public static boolean isMyPersons(Collection<EntityReference<Person>> data, String userId) {
        ArrayList<EntityReference> persons = new ArrayList<EntityReference>();
        try {
            EntityContainer person = EntityStorage.get().find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                persons.add(person.toReference());
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        return AclRulesHelper.isIncludes(data, persons);
    }

    public static boolean isMySalesPointsBranches(EntityReference<Branch> data, String userId) {
        ArrayList<EntityReference<Branch>> branches = new ArrayList<EntityReference<Branch>>();
        try {
            EntityContainer person = EntityStorage.get().find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                branches.addAll(ProfileHelper.getSalesPointBranches(ProfileHelper.getPersonSalesPoints(Arrays.asList(person.toReference()), new Date())));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        return AclRulesHelper.isIncludes(data, branches);
    }

    public static boolean isMySalesPointsBranches(Collection<EntityReference<Branch>> data, String userId) {
        ArrayList<EntityReference<Branch>> branches = new ArrayList<EntityReference<Branch>>();
        try {
            EntityContainer person = EntityStorage.get().find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                branches.addAll(ProfileHelper.getSalesPointBranches(ProfileHelper.getPersonSalesPoints(Arrays.asList(person.toReference()), new Date())));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        return AclRulesHelper.isIncludes(data, branches);
    }

    public static SearchCriterion createMyOrganizationsContractsCriterion(String propertyId, String userId, boolean collection) {
        ArrayList<EntityReference<Contract>> contracts = new ArrayList<EntityReference<Contract>>();
        try {
            EntityContainer person = EntityStorage.get().find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                contracts.addAll(ProfileHelper.getOrganizationContracts(ProfileHelper.getPersonOrganizations(Arrays.asList(person.toReference()), null, new Date()), null));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        return AclRulesHelper.createIncludesCriterion((String)propertyId, contracts, (boolean)collection);
    }

    public static SearchCriterion createMyOrganizationsHoldingsCriterion(String propertyId, String userId, boolean collection) {
        ArrayList<EntityReference<Holding>> holdings = new ArrayList<EntityReference<Holding>>();
        try {
            EntityContainer person = EntityStorage.get().find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                holdings.addAll(ProfileHelper.getOrganizationHoldings(ProfileHelper.getPersonOrganizations(Arrays.asList(person.toReference()), null, new Date())));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        return AclRulesHelper.createIncludesCriterion((String)propertyId, holdings, (boolean)collection);
    }

    public static SearchCriterion createMyChildrenOrganizationsHoldingsCriterion(String propertyId, String userId, boolean collection) {
        Collection<Object> holdingRefs;
        block2: {
            holdingRefs = Collections.emptyList();
            try {
                holdingRefs = Optional.ofNullable(ProfileHelper.getPersonCtr(userId)).map(Collections::singleton).map(personCtrs -> ProfileHelper.getPersonOrganizationByContainers(personCtrs, null, new Date())).map(ProfileHelper::getOrganizationChildren).map(ProfileHelper::getOrganizationHoldings).orElse(Collections.emptyList());
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block2;
                log.error("unable to collect entities", (Throwable)e);
            }
        }
        return AclRulesHelper.createIncludesCriterion((String)propertyId, holdingRefs, (boolean)collection);
    }

    public static SearchCriterion createMyOrganizationsHoldingsOrganizationsCriterion(String propertyId, String userId, boolean collection) {
        ArrayList<EntityReference<Organization>> organizations = new ArrayList<EntityReference<Organization>>();
        try {
            EntityContainer person = EntityStorage.get().find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                organizations.addAll(ProfileHelper.getHoldingOrganizations(ProfileHelper.getOrganizationHoldings(ProfileHelper.getPersonOrganizations(Arrays.asList(person.toReference()), null, new Date()))));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        return AclRulesHelper.createIncludesCriterion((String)propertyId, organizations, (boolean)collection);
    }

    public static SearchCriterion createMyOrganizationsChildrenOrganizationsCriterion(String propertyId, String userId, boolean collection) {
        ArrayList<EntityReference<Organization>> organizations = new ArrayList<EntityReference<Organization>>();
        try {
            EntityContainer person = EntityStorage.get().find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                organizations.addAll(ProfileHelper.getOrganizationChildren(ProfileHelper.getPersonOrganizations(Arrays.asList(person.toReference()), null, new Date())));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        return AclRulesHelper.createIncludesCriterion((String)propertyId, organizations, (boolean)collection);
    }

    public static SearchCriterion createMyOrganizationsCustomersCriterion(String propertyId, String userId, boolean collection) {
        ArrayList<EntityReference<Organization>> organizations = new ArrayList<EntityReference<Organization>>();
        try {
            EntityContainer person = EntityStorage.get().find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                organizations.addAll(ProfileHelper.getPersonsOrganizationsCustomers((EntityContainer<Person>)person));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        return AclRulesHelper.createIncludesCriterion((String)propertyId, organizations, (boolean)collection);
    }

    public static SearchCriterion createMyOrganizationsCustomersPersonsCriterion(String propertyId, String userId, boolean collection) {
        ArrayList<EntityReference<Person>> persons = new ArrayList<EntityReference<Person>>();
        try {
            EntityContainer person = EntityStorage.get().find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                persons.addAll(ProfileHelper.getPersonsOrganizationsCustomersPersons((EntityContainer<Person>)person));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        return AclRulesHelper.createIncludesCriterion((String)propertyId, persons, (boolean)collection);
    }

    public static SearchCriterion createMyOrgnizationsCriterion(String propertyId, String userId, boolean collection) {
        ArrayList<EntityReference<Organization>> organizations = new ArrayList<EntityReference<Organization>>();
        try {
            EntityContainer person = EntityStorage.get().find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                organizations.addAll(ProfileHelper.getPersonOrganizations(Arrays.asList(person.toReference()), null, new Date()));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        return AclRulesHelper.createIncludesCriterion((String)propertyId, organizations, (boolean)collection);
    }

    public static SearchCriterion createMyOrganizationsBranchesCriterion(String propertyId, String userId, boolean collection) {
        ArrayList<EntityReference<Branch>> branches = new ArrayList<EntityReference<Branch>>();
        try {
            EntityContainer person = EntityStorage.get().find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                branches.addAll(ProfileHelper.getOrganizationBranches(ProfileHelper.getPersonOrganizations(Arrays.asList(person.toReference()), null, new Date())));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        return AclRulesHelper.createIncludesCriterion((String)propertyId, branches, (boolean)collection);
    }

    public static SearchCriterion createMySalesPointsBranchesCriterion(String propertyId, String userId, boolean collection) {
        ArrayList<EntityReference<Branch>> branches = new ArrayList<EntityReference<Branch>>();
        try {
            EntityContainer person = EntityStorage.get().find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                branches.addAll(ProfileHelper.getSalesPointBranches(ProfileHelper.getPersonSalesPoints(Arrays.asList(person.toReference()), new Date())));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        return AclRulesHelper.createIncludesCriterion((String)propertyId, branches, (boolean)collection);
    }

    public static SearchCriterion createMyOrganizationsSalesPointsCriterion(String propertyId, String userId, boolean collection) {
        ArrayList<EntityReference<SalesPoint>> salesPoints = new ArrayList<EntityReference<SalesPoint>>();
        try {
            EntityContainer person = EntityStorage.get().find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                salesPoints.addAll(ProfileHelper.getOrganizationSalesPoints(ProfileHelper.getPersonOrganizations(Arrays.asList(person.toReference()), null, new Date())));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        return AclRulesHelper.createIncludesCriterion((String)propertyId, salesPoints, (boolean)collection);
    }

    public static SearchCriterion createMySalesPointsCriterion(String propertyId, String userId, boolean collection) {
        ArrayList<EntityReference<SalesPoint>> salesPoints = new ArrayList<EntityReference<SalesPoint>>();
        try {
            EntityContainer person = EntityStorage.get().find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                salesPoints.addAll(ProfileHelper.getPersonSalesPoints(Arrays.asList(person.toReference()), new Date()));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        return AclRulesHelper.createIncludesCriterion((String)propertyId, salesPoints, (boolean)collection);
    }

    public static SearchCriterion createMySalesPointsCashRegistersCriterion(String propertyId, String userId, boolean collection) {
        ArrayList<EntityReference<CashRegister>> cashRegisters = new ArrayList<EntityReference<CashRegister>>();
        try {
            EntityContainer person = EntityStorage.get().find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                cashRegisters.addAll(ProfileHelper.getSalesPointCashRegisters(ProfileHelper.getPersonSalesPoints(Arrays.asList(person.toReference()), new Date())));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        return AclRulesHelper.createIncludesCriterion((String)propertyId, cashRegisters, (boolean)collection);
    }

    public static SearchCriterion createMySalesPointsCashRegisterWorkplacesCriterion(String propertyId, String userId, boolean collection) {
        ArrayList<EntityReference<CashRegisterWorkplace>> cashRegisterWorkplaces = new ArrayList<EntityReference<CashRegisterWorkplace>>();
        try {
            EntityContainer person = EntityStorage.get().find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                cashRegisterWorkplaces.addAll(ProfileHelper.getSalesPointCashRegisterWorkplaces(ProfileHelper.getPersonSalesPoints(Arrays.asList(person.toReference()), new Date())));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        return AclRulesHelper.createIncludesCriterion((String)propertyId, cashRegisterWorkplaces, (boolean)collection);
    }

    public static SearchCriterion createMyPersonsCriterion(String propertyId, String userId, boolean collection) {
        ArrayList<EntityReference> persons = new ArrayList<EntityReference>();
        try {
            EntityContainer person = EntityStorage.get().find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                persons.add(person.toReference());
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        return AclRulesHelper.createIncludesCriterion((String)propertyId, persons, (boolean)collection);
    }
}

