/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.security.acl.resource;

import com.gridnine.xtrip.common.meta.IndexCollection;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.security.acl.helper.AclModelRulesHelper;
import com.gridnine.xtrip.common.model.security.acl.resource.ModelAclResourcePropertyConditions;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.security.acl.helper.AclRulesHelper;
import com.gridnine.xtrip.common.security.acl.resource.AclQueryable;
import com.gridnine.xtrip.common.security.acl.resource.AclResourceProperty;
import com.gridnine.xtrip.common.security.acl.resource.AclResourcePropertyCondition;
import com.gridnine.xtrip.common.security.acl.resource.AclResourcePropertyType;
import com.gridnine.xtrip.common.security.acl.resource.StandardAclResourcePropertyConditions;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelAclIndexResourceCollectionProperty
implements AclResourceProperty,
AclQueryable {
    private static final Logger log = LoggerFactory.getLogger(ModelAclIndexResourceCollectionProperty.class);
    private final IndexType index;
    private final IndexCollection collection;

    public ModelAclIndexResourceCollectionProperty(IndexType index, IndexCollection collection) {
        this.index = index;
        this.collection = collection;
    }

    public String getId() {
        return TextUtil.concat((String[])new String[]{this.index.getId(), ".", this.collection.getId()});
    }

    public String getName() {
        return this.collection.getDisplayName();
    }

    public Class<?> getType() {
        Class type = this.resolveStandardType();
        if (type == null) {
            try {
                String elementType = this.collection.getElementType();
                if (elementType.contains("||")) {
                    String[] classNames = elementType.split("\\|\\|");
                    type = XHelper.getClass((String)classNames[1]);
                } else {
                    type = XHelper.getClass((String)elementType);
                }
            }
            catch (ClassNotFoundException e) {
                log.error(String.format("failed loading property %s class of index %s", this.collection.getId(), this.index.getId()), (Throwable)e);
                throw new Error(String.format("failed loading property %s class of index %s", this.collection.getId(), this.index.getId()), e);
            }
        }
        return type;
    }

    public String getResourceId() {
        return this.index.getId();
    }

    public Set<String> getConditionIds() {
        Class<?> type = this.getType();
        if (String.class.isAssignableFrom(type)) {
            return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.INCLUDES.getId(), StandardAclResourcePropertyConditions.NOT_INCLUDES.getId(), StandardAclResourcePropertyConditions.NULL.getId(), StandardAclResourcePropertyConditions.NOT_NULL.getId()));
        }
        if (type.isEnum()) {
            return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.INCLUDES.getId(), StandardAclResourcePropertyConditions.NOT_INCLUDES.getId(), StandardAclResourcePropertyConditions.NULL.getId(), StandardAclResourcePropertyConditions.NOT_NULL.getId()));
        }
        if (BaseDictionary.class.isAssignableFrom(type)) {
            return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.INCLUDES.getId(), StandardAclResourcePropertyConditions.NOT_INCLUDES.getId(), StandardAclResourcePropertyConditions.NULL.getId(), StandardAclResourcePropertyConditions.NOT_NULL.getId()));
        }
        if (BaseEntity.class.isAssignableFrom(type)) {
            if (Person.class.isAssignableFrom(type)) {
                return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.INCLUDES.getId(), StandardAclResourcePropertyConditions.NOT_INCLUDES.getId(), StandardAclResourcePropertyConditions.NULL.getId(), StandardAclResourcePropertyConditions.NOT_NULL.getId(), ModelAclResourcePropertyConditions.MY_PERSONS.getId()));
            }
            return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.INCLUDES.getId(), StandardAclResourcePropertyConditions.NOT_INCLUDES.getId(), StandardAclResourcePropertyConditions.NULL.getId(), StandardAclResourcePropertyConditions.NOT_NULL.getId()));
        }
        return Collections.emptySet();
    }

    public String getRendererId(String conditionId) {
        Class<?> type = this.getType();
        if (String.class.isAssignableFrom(type)) {
            if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(conditionId)) {
                return AclResourcePropertyType.STRING_LIST.name();
            }
            return AclResourcePropertyType.NULL.name();
        }
        if (type.isEnum()) {
            if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENUM_LIST.name();
            }
            return AclResourcePropertyType.NULL.name();
        }
        if (BaseDictionary.class.isAssignableFrom(type)) {
            if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(conditionId)) {
                return AclResourcePropertyType.DICTIONARY_LIST.name();
            }
            return AclResourcePropertyType.NULL.name();
        }
        if (BaseEntity.class.isAssignableFrom(type)) {
            if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENTITY_LIST.name();
            }
            return AclResourcePropertyType.NULL.name();
        }
        return AclResourcePropertyType.STUB.name();
    }

    public String getInfo(AclResourcePropertyCondition condition, Object value) {
        return AclRulesHelper.getInfo((String)String.format("%s", this.getName()), (AclResourcePropertyCondition)condition, (Object)value);
    }

    public SearchCriterion getQuery(AclResourcePropertyCondition condition, Object value, String userId) {
        if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(condition.getId())) {
            return AclRulesHelper.createIncludesCriterion((String)this.collection.getId(), (Iterable)AclRulesHelper.toStringList((Iterable)((Iterable)value), this.getType()), (boolean)true);
        }
        if (StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(condition.getId())) {
            return AclRulesHelper.createNotIncludesCriterion((String)this.collection.getId(), (Iterable)AclRulesHelper.toStringList((Iterable)((Iterable)value), this.getType()), (boolean)true);
        }
        if (StandardAclResourcePropertyConditions.NULL.getId().equals(condition.getId())) {
            return AclRulesHelper.createIsNullCriterion((String)this.collection.getId(), (boolean)true);
        }
        if (StandardAclResourcePropertyConditions.NOT_NULL.getId().equals(condition.getId())) {
            return AclRulesHelper.createIsNotNullCriterion((String)this.collection.getId(), (boolean)true);
        }
        if (ModelAclResourcePropertyConditions.MY_PERSONS.getId().equals(condition.getId())) {
            return AclModelRulesHelper.createMyPersonsCriterion(this.collection.getId(), userId, true);
        }
        return null;
    }

    private Class<?> resolveStandardType() {
        String type = this.collection.getElementType();
        if ("text".equals(type) || "String".equals(type)) {
            return String.class;
        }
        return null;
    }
}

