/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.templates.jr;

import com.gridnine.xtrip.common.jr.JasperUtil;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableName;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.additionalservice.AdditionalServiceProduct;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.AddressType;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.PersonalLocalizableNameFormatter;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.Signature;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.model.system.FilledTemplateDocument;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.ImageUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;

public class CertificateOfCompletedFlightRender {
    private static final PersonalLocalizableNameFormatter nameFormatter = new PersonalLocalizableNameFormatter("L f m");
    private static final String AGENCY_NAME = "AGENCY_NAME";
    private static final String AGENCY_ADDRESS = "AGENCY_ADDRESS";
    private static final String AGENCY_INN = "AGENCY_INN";
    private static final String AGENCY_PHONE = "AGENCY_PHONE";
    private static final String AGENCY_SITE = "AGENCY_SITE";
    private static final String AGENCY_LOGO = "AGENCY_LOGO";
    private static final String STAMP = "STAMP";
    private static final String AGENT_NAME = "AGENT_NAME";
    private static final String CUSTOMER_NAME = "CUSTOMER_NAME";
    private static final String DATE = "DATE";
    private static final String TICKET_NUMBER = "TICKET_NUMBER";
    private static final String DEPARTURE_DATE = "DEPARTURE_DATE";
    private static final String DEPARTURE_CITY = "DEPARTURE_CITY";
    private static final String ARRIVE_CITY = "ARRIVE_CITY";
    private static final String MARKETING_CARRIER_CODE = "MARKETING_CARRIER_CODE";
    private static final String FLIGHT_NUMBER = "FLIGHT_NUMBER";
    private static final String ALL_SEGMENTS_USED = "ALL_SEGMENTS_USED";

    public FilledTemplateDocument renderReport(EntityContainer<BookingFile> bookingFile, AdditionalServiceProduct product, EntityContainer<TemplateDocument> template, Boolean useFacsimile, List<Signature> signatures) throws Exception {
        Locale locale;
        JasperReport jasperReport = JasperUtil.getReport((byte[])((TemplateDocument)template.getEntity()).getContent());
        byte[] content = JasperUtil.fillReport((JasperReport)jasperReport, this.getParameters(product, locale = this.getLocale((TemplateDocument)template.getEntity()), useFacsimile, signatures), (JRDataSource)this.getDataSource(product, locale), null);
        if (content == null) {
            return null;
        }
        Date date = new Date();
        FilledTemplateDocument file = new FilledTemplateDocument();
        file.setTitle(this.getReportTitle(product, (TemplateDocument)template.getEntity()));
        file.setContentType(ContentType.JASPERPRINT);
        file.setContent(content);
        file.setName(this.getFileName(product, (TemplateDocument)template.getEntity()));
        file.setType(DocumentType.RECEIPT);
        file.setCreated(date);
        file.setNavigationKey(product.getUid());
        file.setOwner(bookingFile.toReference());
        file.setCheckSum(MiscUtil.getCheckSum((byte[])file.getContent()));
        file.setTemplate(template.toReference());
        return file;
    }

    public Collection<FilledTemplateDocument> renderReports(EntityContainer<BookingFile> bookingFile, AdditionalServiceProduct product, Collection<EntityContainer<TemplateDocument>> templates, Boolean useFacsimile, List<Signature> signatures) throws Exception {
        return templates.stream().map(template -> {
            try {
                return this.renderReport(bookingFile, product, (EntityContainer<TemplateDocument>)template, useFacsimile, signatures);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Map<String, Object> getParameters(AdditionalServiceProduct product, Locale locale, Boolean useFacsimile, List<Signature> signatures) {
        Product ticket;
        Traveller traveller;
        Person signer;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        EntityReference<Organization> agencyRef = GeneralProductHelper.getAgency((BaseProduct)product);
        Organization agency = ProfileHelper.resolveReference(agencyRef);
        if (agency != null) {
            String agencyAddress = null;
            for (Address addr : ProfileHelper.getOrganizationAddresses(agency, product.getIssueDate())) {
                if (!AddressType.BUSINESS.equals((Object)addr.getAddressType()) && !AddressType.LEGAL.equals((Object)addr.getAddressType()) && !AddressType.FACTUAL.equals((Object)addr.getAddressType())) continue;
                agencyAddress = this.getFullAddress(addr, locale);
                break;
            }
            String agencyPhone = this.buildPhoneString(agency.getCommunications(), Collections.singletonList(CommunicationType.WORK_PHONE));
            String agencyName = agency.getFullName() != null && !agency.getFullName().getValues().isEmpty() ? (agency.getFullName().getValues().get(locale) != null ? (String)agency.getFullName().getValues().get(locale) : (String)agency.getFullName().getValues().values().stream().filter(Objects::nonNull).findFirst().orElse(null)) : null;
            parameters.put(AGENCY_ADDRESS, agencyAddress);
            parameters.put(AGENCY_PHONE, agencyPhone);
            parameters.put(AGENCY_NAME, agencyName);
            parameters.put(AGENCY_SITE, this.buildSite(agency.getCommunications()));
            parameters.put(AGENCY_INN, agency.getRegistrationId());
            parameters.put(AGENCY_LOGO, CertificateOfCompletedFlightRender.getLogoStream(agency));
            signatures.forEach(signature -> {
                if (signature.getPosition() != null && signature.getPosition().getCode() != null) {
                    Person signer = Optional.ofNullable(EntityStorageHelper.resolve((EntityReference)signature.getSigner())).map(EntityContainer::getEntity).orElse(null);
                    String name = nameFormatter.format((PersonalLocalizableName)signer, locale, false);
                    parameters.put(String.format("AGENCY_%s_NAME", signature.getPosition().getCode()), name);
                    parameters.put(String.format("AGENCY_%s_TITLE", signature.getPosition().getCode()), signature.getPosition().getCaption());
                    if (useFacsimile.booleanValue() && signer != null && signer.getSignatureImage() != null) {
                        ImageUtil.ImageData imageData = new ImageUtil.ImageData(signer.getSignatureImage());
                        parameters.put(String.format("AGENCY_%s_SIGNATURE", signature.getPosition().getCode()), new ByteArrayInputStream(signer.getSignatureImage()));
                        parameters.put(String.format("AGENCY_%s_SIGNATURE_WIDTH", signature.getPosition().getCode()), imageData.getWidth());
                        parameters.put(String.format("AGENCY_%s_SIGNATURE_HEIGHT", signature.getPosition().getCode()), imageData.getHeight());
                    }
                }
            });
            if (useFacsimile.booleanValue() && agency.getStamp() != null) {
                parameters.put(STAMP, new ByteArrayInputStream(agency.getStamp().getData()));
            }
            if (product.getRelatedProducts() == null || product.getRelatedProducts().isEmpty()) {
                parameters.put(ALL_SEGMENTS_USED, true);
            } else {
                int relatedProductSegmentsCount;
                Product relatedProduct = (Product)product.getRelatedProducts().get(0);
                int productSegmentsCount = AirProductHelper.getSegments(product.getSegments()).size();
                parameters.put(ALL_SEGMENTS_USED, productSegmentsCount == (relatedProductSegmentsCount = AirProductHelper.getSegments(relatedProduct.getSegmentTariffs()).size()));
            }
        }
        if ((signer = (Person)Optional.ofNullable(EntityStorageHelper.resolve((EntityReference)product.getAgent())).map(EntityContainer::getEntity).orElse(null)) != null) {
            String name = nameFormatter.format((PersonalLocalizableName)signer, locale, false);
            parameters.put(AGENT_NAME, name);
            if (useFacsimile.booleanValue() && signer.getSignatureImage() != null) {
                ImageUtil.ImageData imageData = new ImageUtil.ImageData(signer.getSignatureImage());
                parameters.put("AGENT_SIGNATURE", new ByteArrayInputStream(signer.getSignatureImage()));
                parameters.put("AGENT_SIGNATURE_WIDTH", imageData.getWidth());
                parameters.put("AGENT_SIGNATURE_HEIGHT", imageData.getHeight());
            }
        }
        if ((traveller = (Traveller)CollectionUtil.head((Iterable)product.getTravellers())) != null) {
            parameters.put(CUSTOMER_NAME, this.getFullName(traveller, locale));
        }
        if ((ticket = (Product)CollectionUtil.head((Iterable)product.getRelatedProducts())) != null) {
            parameters.put(TICKET_NUMBER, ticket.getCarrierNumber() + "-" + ticket.getSystemNumber());
        } else {
            parameters.put(TICKET_NUMBER, product.getMainProductCode() + product.getMainProductNumber());
        }
        parameters.put(DATE, product.getIssueDate());
        return parameters;
    }

    private String getFullName(Traveller traveller, Locale locale) {
        if (traveller == null) {
            return null;
        }
        String contactPerson = null;
        EntityReference passenger = traveller.getPassenger();
        EntityContainer resolve = EntityStorage.get().resolve(passenger);
        if (resolve != null && resolve.getEntity() != null) {
            Person person = (Person)resolve.getEntity();
            if (person == null) {
                return null;
            }
            contactPerson = this.getPersonName((String)person.getLastName().getValues().get(locale), (String)person.getFirstName().getValues().get(locale), (String)person.getMiddleName().getValues().get(locale));
            if (TextUtil.isBlank((String)contactPerson)) {
                contactPerson = this.getPersonName(person.getLastName().getValues().values().stream().findFirst().orElse(null), person.getFirstName().getValues().values().stream().findFirst().orElse(null), person.getMiddleName().getValues().values().stream().findFirst().orElse(null));
            }
        } else {
            Passport passport = traveller.getPassport();
            if (passport != null) {
                contactPerson = this.getPersonName(passport.getLastName(), passport.getFirstName(), passport.getMiddleName());
            }
            if (TextUtil.isBlank(contactPerson)) {
                contactPerson = traveller.getCyrillicName();
            }
            if (TextUtil.isBlank(contactPerson)) {
                contactPerson = traveller.getName();
            }
        }
        return contactPerson;
    }

    private String getPersonName(String lastName, String firstName, String middleName) {
        return TextUtil.nonEmptyStr((String)lastName) + (TextUtil.nonBlank((String)lastName) ? (TextUtil.nonBlank((String)firstName) ? " " + firstName : "") : (TextUtil.nonBlank((String)firstName) ? firstName : "")) + (TextUtil.isBlank((String)lastName) && TextUtil.isBlank((String)firstName) ? "" : (TextUtil.nonBlank((String)middleName) ? " " + middleName : ""));
    }

    private static InputStream getLogoStream(Organization agency) {
        if (agency.getLogo() == null || agency.getLogo().getData() == null || agency.getLogo().getData().length == 0) {
            return null;
        }
        return new ByteArrayInputStream(agency.getLogo().getData());
    }

    private String buildSite(List<Communication> communications) {
        Communication communication = communications.stream().filter(comm -> comm.getType() == CommunicationType.WEB).findFirst().orElse(null);
        return communication != null ? communication.getSense() : null;
    }

    private String buildPhoneString(List<Communication> communications, List<CommunicationType> communicationTypes) {
        for (CommunicationType communicationType : communicationTypes) {
            for (Communication communication : ProfileHelper.filterCommunications(communications, Collections.singleton(communicationType))) {
                String phoneString = ProfileHelper.buildFullPhoneNumber(communication);
                if (TextUtil.isBlank((String)phoneString)) continue;
                return phoneString.trim();
            }
        }
        return null;
    }

    private String getFullAddress(Address a, Locale locale) {
        String address;
        StringBuilder result = new StringBuilder();
        if (TextUtil.nonBlank((String)a.getZip())) {
            result.append(a.getZip());
        }
        if (a.getCity() != null) {
            String city = a.getCity().toString(locale);
            result.append(", ").append(city);
        }
        if (!a.getAddress().getValues().isEmpty() && TextUtil.nonBlank((String)(address = a.getAddress().toString(locale)))) {
            result.append(", ").append(address);
        }
        return result.toString();
    }

    private JRDataSource getDataSource(AdditionalServiceProduct product, Locale locale) {
        ArrayList data = new ArrayList();
        for (SegmentTariff segmentTariff : product.getSegments()) {
            for (Segment segment : segmentTariff.getSegments()) {
                DictionaryReference marketingCarrier;
                GeoLocation arriveLocation;
                HashMap<String, Object> record = new HashMap<String, Object>();
                record.put(DEPARTURE_DATE, segment.getStartDate());
                GeoLocation departureLocation = (GeoLocation)DictionaryCache.get().resolveReference(segment.getDepartureLocation());
                if (departureLocation != null) {
                    GeoLocation departureCity;
                    String departureCityString = departureLocation.toString(locale);
                    if (departureLocation.getType() == LocationType.AIRPORT && (departureCity = DictHelper.findCity(departureLocation)) != null) {
                        departureCityString = departureCity.toString(locale);
                    }
                    record.put(DEPARTURE_CITY, departureCityString);
                }
                if ((arriveLocation = (GeoLocation)DictionaryCache.get().resolveReference(segment.getArriveLocation())) != null) {
                    GeoLocation arriveCity;
                    String arriveCityString = arriveLocation.toString(locale);
                    if (arriveLocation.getType() == LocationType.AIRPORT && (arriveCity = DictHelper.findCity(arriveLocation)) != null) {
                        arriveCityString = arriveCity.toString(locale);
                    }
                    record.put(ARRIVE_CITY, arriveCityString);
                }
                if ((marketingCarrier = segment.getAirline()) != null) {
                    String marketingCarrierCode = null;
                    Airline marketingAirline = (Airline)DictionaryCache.get().resolveReference(marketingCarrier);
                    if (marketingAirline != null && (marketingCarrierCode = DictHelper.getCodeVariant((BaseDictionary)marketingAirline, Arrays.asList(CodeSystem.IATA, CodeSystem.CRT))) == null && marketingAirline.getCodeVariants().size() > 0) {
                        marketingCarrierCode = (String)marketingAirline.getCodeVariants().values().iterator().next();
                    }
                    if (marketingCarrierCode == null) {
                        marketingCarrierCode = marketingCarrier.getCode();
                    }
                    record.put(MARKETING_CARRIER_CODE, marketingCarrierCode);
                }
                record.put(FLIGHT_NUMBER, segment.getFlightNo());
                data.add(record);
            }
        }
        if (data.isEmpty()) {
            data.add(new HashMap());
        }
        return new JRMapCollectionDataSource(data);
    }

    private Locale getLocale(TemplateDocument templateDocument) {
        String language = SystemHelper.findMetadataAsString(templateDocument.getMetadata(), MetadataKey.KEY_LOCALE);
        if (!TextUtil.isBlank((String)language)) {
            return LocaleHelper.getLocale((String)language);
        }
        return LocaleHelper.getCurrentLocale();
    }

    private String getFileName(AdditionalServiceProduct product, TemplateDocument templateDocument) {
        return this.getReportTitle(product, templateDocument) + ".pdf";
    }

    private String getReportTitle(AdditionalServiceProduct product, TemplateDocument templateDocument) {
        return templateDocument.getTitle() + " " + product.getSystemNumber() + " " + (!product.getTravellers().isEmpty() ? ((Traveller)product.getTravellers().get(0)).getName() : "") + " (" + new SimpleDateFormat("yyyyMMdd_HHmm").format(new Date()) + ")";
    }
}

