/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.templates.jr;

import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.AeroexpressTicket;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BaseTicketProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.MCOFees;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccident;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristic;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.delivery.Delivery;
import com.gridnine.xtrip.common.model.delivery.DeliveryItem;
import com.gridnine.xtrip.common.model.delivery.DeliveryItemType;
import com.gridnine.xtrip.common.model.delivery.MetroStation;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.BaseProfile;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.model.system.FilledTemplateDocument;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.MoneyUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public final class DeliveryBlankRenderer {
    public static FilledTemplateDocument renderBlank(EntityContainer<BookingFile> bfCtr, String deliveryUid, EntityContainer<TemplateDocument> templateCtr) throws Exception {
        int n;
        EntityContainer clientCtr;
        FilledTemplateDocument result = new FilledTemplateDocument();
        if (((TemplateDocument)templateCtr.getEntity()).getContent() == null || ((TemplateDocument)templateCtr.getEntity()).getContent().length == 0) {
            result.getMessages().add(SystemHelper.createMessage(MessageType.ERROR, "\u0432 \u0448\u0430\u0431\u043b\u043e\u043d\u0435 {0} \u043d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445", templateCtr.toReference()));
            return result;
        }
        BaseProduct bp = BookingHelper.findProduct((BookingFile)bfCtr.getEntity(), deliveryUid);
        if (!(bp instanceof Delivery)) {
            result.getMessages().add(SystemHelper.createMessage(MessageType.ERROR, "\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u043f\u0440\u043e\u0434\u0443\u043a\u0442 \u0442\u0438\u043f\u0430 \u0414\u043e\u0441\u0442\u0430\u0432\u043a\u0430", new Object[0]));
            return result;
        }
        Delivery delivery = (Delivery)bp;
        POIFSFileSystem fs = new POIFSFileSystem((InputStream)new ByteArrayInputStream(((TemplateDocument)templateCtr.getEntity()).getContent()));
        HSSFWorkbook wb = new HSSFWorkbook(fs);
        HSSFSheet sheet = wb.getSheetAt(0);
        String clientName = delivery.getAddresseeName();
        if (TextUtil.isBlank((String)clientName) && (clientCtr = EntityStorage.get().resolve(delivery.getAddressee())) != null) {
            clientName = Organization.class.equals((Object)clientCtr.getEntityType()) ? ProfileHelper.getFullName((Organization)clientCtr.getEntity(), LocaleHelper.getCurrentLocale(), false) : ((BaseProfile)clientCtr.getEntity()).toString();
        }
        ExcelUtils.replace(sheet, "CLIENT_NAME", clientName);
        ExcelUtils.replace(sheet, "DELIVERY_ADDRESS", delivery.getAddress());
        Date deliveryDate = delivery.getStartDate();
        if (deliveryDate == null) {
            deliveryDate = new Date();
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");
        ExcelUtils.replace(sheet, "DELIVERY_DATE", dateFormat.format(deliveryDate));
        SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm");
        String startDateStr = "";
        if (delivery.getStartDate() != null) {
            startDateStr = timeFormat.format(delivery.getStartDate());
        }
        ExcelUtils.replace(sheet, "START_DATE", startDateStr);
        String endDateStr = "";
        if (delivery.getEndDate() != null) {
            endDateStr = timeFormat.format(delivery.getEndDate());
        }
        ExcelUtils.replace(sheet, "END_DATE", endDateStr);
        String contactPhoneStr = "";
        if (delivery.getContactPersonName() != null || delivery.getContactPerson() != null) {
            contactPhoneStr = delivery.getContactPhone();
        }
        ExcelUtils.replace(sheet, "CONTACT_PHONE", contactPhoneStr);
        String contactStr = "";
        if (delivery.getContactPersonName() != null || delivery.getContactPerson() != null) {
            contactStr = delivery.getContactPersonName() != null ? delivery.getContactPersonName() : delivery.getContactPerson().toString();
        }
        ExcelUtils.replace(sheet, "CONTACT", contactStr);
        BigDecimal total = BigDecimal.ZERO;
        HSSFCell cell = ExcelUtils.findCell(sheet, "FIRST_POSITION");
        int rowIndex = cell.getRowIndex();
        boolean aviacentre = templateCtr.getUid().equals("deliveryBlankAviaCentreTemplateContainer");
        if (aviacentre) {
            if (delivery.getDeliveryItems().size() > 1) {
                for (n = 1; n < delivery.getDeliveryItems().size(); ++n) {
                    ExcelUtils.copyRows(sheet, rowIndex + 1, rowIndex + 1);
                    ExcelUtils.copyRows(sheet, rowIndex + 1, rowIndex + 1);
                }
            }
        } else if (delivery.getDeliveryItems().size() > 3) {
            for (n = 3; n < delivery.getDeliveryItems().size(); ++n) {
                ExcelUtils.copyRows(sheet, rowIndex + 2, rowIndex + 2);
            }
        }
        for (n = 0; n < delivery.getDeliveryItems().size(); ++n) {
            DeliveryItem deliveryItem = (DeliveryItem)delivery.getDeliveryItems().get(n);
            int stringsPerItem = 1;
            if (aviacentre) {
                stringsPerItem = 2;
            }
            ExcelUtils.setCellValue(sheet, rowIndex + 1 + n * stringsPerItem, 2, 1, 1, deliveryItem.getObject() != null ? deliveryItem.getObject().toString() : null);
            if (aviacentre) {
                BaseProduct product;
                if (deliveryItem.getType() != DeliveryItemType.PRODUCT || (product = (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)((NestedEntityReference)deliveryItem.getObject()))) == null) continue;
                String agent = "";
                agent = DeliveryBlankRenderer.getProductAgent(product);
                ExcelUtils.setCellValue(sheet, rowIndex + 2 + n * stringsPerItem, 2, 1, 1, "      \u0410\u0433\u0435\u043d\u0442: " + agent);
            }
            if (deliveryItem.getCost() == null) continue;
            total = total.add(deliveryItem.getCost());
        }
        ExcelUtils.replace(sheet, "DELIVERY_SUM", MoneyUtil.money2str((Locale)new Locale("ru"), (String)"RUB", (double)total.doubleValue()));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        wb.write((OutputStream)baos);
        result.setContent(baos.toByteArray());
        result.setCheckSum(MiscUtil.getCheckSum((byte[])result.getContent()));
        result.setCreated(new Date());
        result.setContentType(ContentType.EXCEL);
        result.setDescription(String.format("\u0411\u043b\u0430\u043d\u043a \u0434\u043e\u0441\u0442\u0430\u0432\u043a\u0438 %s", delivery.getSystemNumber()));
        result.setName(String.format("delivery_blank_%s.xls", delivery.getSystemNumber()));
        result.setOwner(bfCtr.toReference());
        result.setNavigationKey(result.getUid());
        result.setTitle(result.getDescription());
        result.setType(DocumentType.OTHER);
        return result;
    }

    public static Document renderRouteBlank(List<Delivery> list, EntityContainer<TemplateDocument> templateCtr, List<Message> errorList) throws Exception {
        Document result = new Document();
        if (((TemplateDocument)templateCtr.getEntity()).getContent() == null || ((TemplateDocument)templateCtr.getEntity()).getContent().length == 0) {
            errorList.add(SystemHelper.createMessage(MessageType.ERROR, "\u0432 \u0448\u0430\u0431\u043b\u043e\u043d\u0435 {0} \u043d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445", templateCtr.toReference()));
            return result;
        }
        if (list == null || list.size() == 0) {
            return result;
        }
        POIFSFileSystem fs = new POIFSFileSystem((InputStream)new ByteArrayInputStream(((TemplateDocument)templateCtr.getEntity()).getContent()));
        HSSFWorkbook wb = new HSSFWorkbook(fs);
        HSSFSheet sheet = wb.getSheetAt(0);
        EntityReference courierRef = list.get(0).getCourier();
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(list.get(0).getStartDate());
        String courierName = courierRef.getCaption();
        String year = String.valueOf(cal.get(1) % 100);
        String month = String.valueOf(cal.get(2) + 1);
        String day = String.valueOf(cal.get(5));
        ExcelUtils.replace(sheet, "COURIER_NAME", courierName);
        ExcelUtils.replace(sheet, "DD", day);
        ExcelUtils.replace(sheet, "MM", month);
        ExcelUtils.replace(sheet, "YY", year);
        HSSFCell cell = ExcelUtils.findCell(sheet, "FIRST_ITEM");
        int rowIndex = cell.getRowIndex();
        int deliveryListSize = list.size();
        if (deliveryListSize > 3) {
            for (int n = 3; n < deliveryListSize; ++n) {
                ExcelUtils.copyRows(sheet, rowIndex + 2, rowIndex + 3);
            }
        }
        HashMap<String, Integer> zonesCount = new HashMap<String, Integer>();
        int deliveryNumber = 0;
        for (Delivery delivery : list) {
            String deliveryZone;
            EntityContainer clientCtr;
            ExcelUtils.setCellValue(sheet, rowIndex + deliveryNumber * 2 + 1, 1, 1, 1, "");
            String clientName = delivery.getAddresseeName();
            if (TextUtil.isBlank((String)clientName) && (clientCtr = EntityStorage.get().resolve(delivery.getAddressee())) != null) {
                clientName = Organization.class.equals((Object)clientCtr.getEntityType()) ? ProfileHelper.getFullName((Organization)clientCtr.getEntity(), LocaleHelper.getCurrentLocale(), false) : ((BaseProfile)clientCtr.getEntity()).toString();
            }
            ExcelUtils.setCellValue(sheet, rowIndex + deliveryNumber * 2 + 1, 2, 1, 1, clientName);
            String metroStation = "";
            if (delivery.getMetroStation() != null) {
                MetroStation station = (MetroStation)DictionaryCache.get().resolveReference(delivery.getMetroStation());
                Locale locale = LocaleHelper.getCurrentLocale();
                Locale newLocale = new Locale(locale.getLanguage(), "");
                metroStation = (String)station.getTranslations().get(newLocale);
            }
            if (!TextUtil.isBlank((String)metroStation)) {
                ExcelUtils.setCellValue(sheet, rowIndex + deliveryNumber * 2 + 2, 2, 1, 1, metroStation);
            }
            String string = deliveryZone = delivery.getDeliveryRegion() != null ? delivery.getDeliveryRegion().getCode() : "";
            if (!TextUtil.isBlank((String)deliveryZone)) {
                ExcelUtils.setCellValue(sheet, rowIndex + deliveryNumber * 2 + 1, 5, 1, 1, deliveryZone);
            }
            if (zonesCount.get(deliveryZone) == null) {
                zonesCount.put(deliveryZone, 1);
            } else {
                zonesCount.put(deliveryZone, (Integer)zonesCount.get(deliveryZone) + 1);
            }
            SimpleDateFormat f = new SimpleDateFormat("HH:mm");
            String startTime = Optional.ofNullable(delivery.getStartDate()).map(f::format).orElse(null);
            String endTime = Optional.ofNullable(delivery.getEndDate()).map(f::format).orElse(null);
            if (!TextUtil.isBlank((String)startTime)) {
                ExcelUtils.setCellValue(sheet, rowIndex + deliveryNumber * 2 + 1, 7, 1, 1, startTime);
            }
            if (!TextUtil.isBlank((String)endTime)) {
                ExcelUtils.setCellValue(sheet, rowIndex + deliveryNumber * 2 + 2, 7, 1, 1, endTime);
            }
            StringBuilder itemsList = new StringBuilder();
            BigDecimal cashCost = BigDecimal.ZERO;
            HashMap<ProductType, Integer> types = new HashMap<ProductType, Integer>();
            if (delivery.getDeliveryItems() == null || delivery.getDeliveryItems().size() == 0) continue;
            for (int i = 0; i < delivery.getDeliveryItems().size(); ++i) {
                BaseProduct product;
                DeliveryItem item = (DeliveryItem)delivery.getDeliveryItems().get(i);
                itemsList.append(item.getObject() != null ? item.getObject().toString() : null);
                if (i != delivery.getDeliveryItems().size() - 1) {
                    itemsList.append(", ");
                }
                if (item.getType() != DeliveryItemType.PRODUCT || (product = (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)((NestedEntityReference)item.getObject()))) == null) continue;
                ProductType type = ProductHandler.of(product).getProductType(product);
                if (types.get(type) == null) {
                    types.put(type, 1);
                } else {
                    types.put(type, (Integer)types.get(type) + 1);
                }
                if (!item.getPaymentType().equals((Object)PaymentType.CASH)) continue;
                cashCost = cashCost.add(item.getCost());
            }
            String items = itemsList.toString();
            if (!TextUtil.isBlank((String)items)) {
                ExcelUtils.setCellValue(sheet, rowIndex + deliveryNumber * 2 + 1, 11, 1, 1, items);
            }
            String ticketsNumber = "";
            for (Map.Entry entry : types.entrySet()) {
                ticketsNumber = ticketsNumber + entry.getValue() + " " + ((ProductType)entry.getKey()).toString().toLowerCase().replace("\u0432\u0438\u0430", "").replace("\u0438\u043b\u0435\u0442", "") + " ";
            }
            if (!TextUtil.isBlank((String)ticketsNumber)) {
                ExcelUtils.setCellValue(sheet, rowIndex + deliveryNumber * 2 + 1, 16, 1, 1, ticketsNumber);
            }
            if (!cashCost.equals(BigDecimal.ZERO)) {
                ExcelUtils.setCellValue(sheet, rowIndex + deliveryNumber * 2 + 1, 17, 1, 1, cashCost + " \u0440\u0443\u0431.");
            }
            ExcelUtils.setCellValue(sheet, rowIndex + deliveryNumber * 2 + 1, 24, 1, 1, delivery.getContactPersonName() != null ? delivery.getContactPersonName() : (delivery.getContactPerson() != null ? delivery.getContactPerson().toString() : null));
            ExcelUtils.setCellValue(sheet, rowIndex + deliveryNumber * 2 + 2, 24, 1, 1, delivery.getContactPhone());
            ++deliveryNumber;
        }
        if (zonesCount.size() != 0) {
            for (Map.Entry entry : zonesCount.entrySet()) {
                if (((String)entry.getKey()).equals("\u041a\u0417")) {
                    ExcelUtils.replace(sheet, "ZONE_KZ", String.valueOf(entry.getValue()));
                }
                if (((String)entry.getKey()).equals("\u0417\u0417")) {
                    ExcelUtils.replace(sheet, "ZONE_ZZ", String.valueOf(entry.getValue()));
                }
                if (((String)entry.getKey()).equals("\u041a")) {
                    ExcelUtils.replace(sheet, "ZONE_K", String.valueOf(entry.getValue()));
                }
                if (((String)entry.getKey()).equals("\u0417")) {
                    ExcelUtils.replace(sheet, "ZONE_Z", String.valueOf(entry.getValue()));
                }
                if (!((String)entry.getKey()).equals("\u041f")) continue;
                ExcelUtils.replace(sheet, "ZONE_P", String.valueOf(entry.getValue()));
            }
        }
        DeliveryBlankRenderer.clearEmptyFields(sheet);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        wb.write((OutputStream)baos);
        result.setContent(baos.toByteArray());
        result.setCheckSum(MiscUtil.getCheckSum((byte[])result.getContent()));
        result.setCreated(new Date());
        result.setContentType(ContentType.EXCEL);
        String string = courierName.replace(". ", "_").replace(".", "_").replace(" ", "_") + day + "_" + month + "_" + year;
        String descriptionSuffix = " " + courierName + " \u0437\u0430 " + day + "." + month + "." + year;
        result.setDescription(String.format("\u041c\u0430\u0440\u0448\u0440\u0443\u0442\u043d\u044b\u0439 \u043b\u0438\u0441\u0442 \u043a\u0443\u0440\u044c\u0435\u0440\u0430 %s", descriptionSuffix));
        result.setName(String.format("courier_route_list_%s.xls", string));
        result.setNavigationKey(result.getUid());
        result.setTitle(result.getDescription());
        result.setType(DocumentType.OTHER);
        return result;
    }

    private static void clearEmptyFields(HSSFSheet sheet) {
        ExcelUtils.replace(sheet, "ZONE_KZ", "");
        ExcelUtils.replace(sheet, "ZONE_ZZ", "");
        ExcelUtils.replace(sheet, "ZONE_K", "");
        ExcelUtils.replace(sheet, "ZONE_Z", "");
        ExcelUtils.replace(sheet, "ZONE_P", "");
    }

    private static String getProductAgent(BaseProduct prod) {
        String agent = "";
        try {
            if (prod instanceof BaseTicketProduct) {
                return ((BaseTicketProduct)prod).getCashier().getCaption();
            }
            if (prod instanceof AeroexpressTicket) {
                return ((AeroexpressTicket)prod).getAgent().getCaption();
            }
            if (prod instanceof HotelProduct) {
                return ((HotelProduct)prod).getCashier().getCaption();
            }
            if (prod instanceof InsuranceAccident) {
                return ((InsuranceAccident)prod).getAgent().getCaption();
            }
            if (prod instanceof InsuranceTouristic) {
                return ((InsuranceTouristic)prod).getAgent().getCaption();
            }
            if (prod instanceof MCOFees) {
                return ((MCOFees)prod).getAgent().getCaption();
            }
            if (prod instanceof UniversalProduct) {
                return ((UniversalProduct)prod).getAgent().getCaption();
            }
        }
        catch (NullPointerException e) {
            agent = "";
        }
        return agent;
    }

    private DeliveryBlankRenderer() {
    }
}

