/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.templates.jr;

import com.gridnine.xtrip.common.gds.model.FareDetails;
import com.gridnine.xtrip.common.jr.JasperUtil;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseCommission;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.FopType;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.VatComponent;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.air.OBFee;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.dict.AddressType;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.InformationNote;
import com.gridnine.xtrip.common.model.dict.LegalForm;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.CommunicationFormat;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ItineraryReceiptHelper;
import com.gridnine.xtrip.common.model.helpers.PersonalNameFormat;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.SalesPointIndex;
import com.gridnine.xtrip.common.model.profile.Validator;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.model.system.FilledTemplateDocument;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.PersonalName;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;

public class RefundReceiptRender {
    private static final String KEY_AGENCY_NAME = "AGENCY_NAME";
    private static final String KEY_AGENCY_TCH_CODE = "AGENCY_TCH_CODE";
    private static final String KEY_SALES_POINT_ADDRESS = "SALES_POINT_ADDRESS";
    private static final String KEY_SALES_POINT_PHONE = "SALES_POINT_PHONE";
    private static final String KEY_SALES_POINT_CITY = "SALES_POINT_CITY";
    private static final String KEY_SALES_POINT_COUNTRY = "SALES_POINT_COUNTRY";
    private static final String KEY_SALES_POINT_LOCATION = "SALES_POINT_LOCATION";
    private static final String KEY_PNR = "PNR";
    private static final String KEY_SYSTEM_NUMBER = "SYSTEM_NUMBER";
    private static final String KEY_ISSUE_DATE = "ISSUE_DATE";
    private static final String KEY_PREVIOUS_ISSUE_DATE = "PREVIOUS_ISSUE_DATE";
    private static final String KEY_VALIDATING_CARRIER_NAME = "VALIDATING_CARRIER_NAME";
    private static final String KEY_VALIDATING_CARRIER_OFFICIAL_NAME = "VALIDATING_CARRIER_OFFICIAL_NAME";
    private static final String KEY_VALIDATING_CARRIER_CODE = "VALIDATING_CARRIER_CODE";
    private static final String KEY_VALIDATING_CARRIER_REGISTRATION_ID = "VALIDATING_CARRIER_REGISTRATION_ID";
    private static final String KEY_VALIDATING_CARRIER_KPP = "VALIDATING_CARRIER_KPP";
    private static final String KEY_VALIDATOR_AGENCY_NAME = "VALIDATOR_AGENCY_NAME";
    private static final String KEY_VALIDATOR_SALES_POINT_CITY = "VALIDATOR_SALES_POINT_CITY";
    private static final String KEY_VALIDATOR_SALES_POINT_COUNTRY = "VALIDATOR_SALES_POINT_COUNTRY";
    private static final String KEY_VALIDATOR = "VALIDATOR";
    private static final String KEY_AGENT_CODE = "AGENT_CODE";
    private static final String KEY_TRAVELLER_NAME = "TRAVELLER_NAME";
    private static final String KEY_TRAVELLER_PASSPORT_NUMBER = "TRAVELLER_PASSPORT_NUMBER";
    private static final String KEY_TRAVELLER_PASSPORT_TYPE = "TRAVELLER_PASSPORT_TYPE";
    private static final String KEY_TRAVELLER_CHILD_BIRTHDAY_DATE = "TRAVELLER_CHILD_BIRTHDAY_DATE";
    private static final String KEY_USE_VAT = "USE_VAT";
    private static final String KEY_USE_FEES = "USE_FEES";
    private static final String KEY_USE_FEES_AS_TAXES = "USE_FEES_AS_TAXES";
    private static final String KEY_SHOW_TAXES_SUM = "SHOW_TAXES_SUM";
    private static final String KEY_TAXES_SUM = "TAXES_SUM";
    private static final String KEY_USE_VAT_DETALIZATION = "USE_VAT_DETALIZATION";
    private static final String KEY_PAYMENTS_PRODUCT_EQUIVALENT_AMOUNT = "PAYMENTS_PRODUCT_EQUIVALENT_AMOUNT";
    private static final String KEY_PAYMENTS_PRODUCT_INCLUDING_AGENCY_FEES_EQUIVALENT_AMOUNT = "PAYMENTS_PRODUCT_INCLUDING_AGENCY_FEES_EQUIVALENT_AMOUNT";
    private static final String KEY_PAYMENTS_PRODUCT_INCLUDING_AGENCY_FEES_TO_REFUND_EQUIVALENT_AMOUNT = "PAYMENTS_PRODUCT_INCLUDING_AGENCY_FEES_TO_REFUND_EQUIVALENT_AMOUNT";
    private static final String KEY_PAYMENTS_PRODUCT_INCLUDING_AGENCY_FEES_OF_REFUND_EQUIVALENT_AMOUNT = "PAYMENTS_PRODUCT_INCLUDING_AGENCY_FEES_OF_REFUND_EQUIVALENT_AMOUNT";
    private static final String KEY_PAYMENTS_FEES_EQUIVALENT_AMOUNT = "PAYMENTS_FEES_EQUIVALENT_AMOUNT";
    private static final String KEY_PAYMENTS_FEES_TO_REFUND_EQUIVALENT_AMOUNT = "PAYMENTS_FEES_TO_REFUND_EQUIVALENT_AMOUNT";
    private static final String KEY_PAYMENTS_FEES_OF_REFUND_EQUIVALENT_AMOUNT = "PAYMENTS_FEES_OF_REFUND_EQUIVALENT_AMOUNT";
    private static final String KEY_TARIFF_BASE_AMOUNT = "TARIFF_BASE_AMOUNT";
    private static final String KEY_TARIFF_EQUIVALENT_AMOUNT = "TARIFF_EQUIVALENT_AMOUNT";
    private static final String KEY_TARIFF_TOTAL_AMOUNT = "TARIFF_TOTAL_AMOUNT";
    private static final String KEY_TAXES_INCLUDING_AGENCY_FEES_EQUIVALENT_AMOUNT = "TAXES_INCLUDING_AGENCY_FEES_EQUIVALENT_AMOUNT";
    private static final String KEY_TAXES_INCLUDING_AGENCY_FEES_TO_REFUND_EQUIVALENT_AMOUNT = "TAXES_INCLUDING_AGENCY_FEES_TO_REFUND_EQUIVALENT_AMOUNT";
    private static final String KEY_TAXES_INCLUDING_AGENCY_FEES_OF_REFUND_EQUIVALENT_AMOUNT = "TAXES_INCLUDING_AGENCY_FEES_OF_REFUND_EQUIVALENT_AMOUNT";
    private static final String KEY_TAXES_EQUIVALENT_AMOUNT = "TAXES_EQUIVALENT_AMOUNT";
    private static final String KEY_PENALTY_EQUIVALENT_AMOUNT = "PENALTY_EQUIVALENT_AMOUNT";
    private static final String KEY_PENALTY_TOTAL_AMOUNT = "PENALTY_TOTAL_AMOUNT";
    private static final String KEY_SUPPLIER_FEES_EQUIVALENT_AMOUNT = "SUPPLIER_FEES_EQUIVALENT_AMOUNT";
    private static final String KEY_SUPPLIER_FEES_EQUIVALENT_VAT = "SUPPLIER_FEES_EQUIVALENT_VAT";
    private static final String KEY_AGENCY_FEES_EQUIVALENT_AMOUNT = "AGENCY_FEES_EQUIVALENT_AMOUNT";
    private static final String KEY_AGENCY_FEES_EQUIVALENT_VAT = "AGENCY_FEES_EQUIVALENT_VAT";
    private static final String KEY_AGENCY_FEES_TO_REFUND_EQUIVALENT_AMOUNT = "AGENCY_FEES_TO_REFUND_EQUIVALENT_AMOUNT";
    private static final String KEY_AGENCY_FEES_TO_REFUND_EQUIVALENT_VAT = "AGENCY_FEES_TO_REFUND_EQUIVALENT_VAT";
    private static final String KEY_AGENCY_FEES_OF_REFUND_EQUIVALENT_AMOUNT = "AGENCY_FEES_OF_REFUND_EQUIVALENT_AMOUNT";
    private static final String KEY_AGENCY_FEES_OF_REFUND_EQUIVALENT_VAT = "AGENCY_FEES_OF_REFUND_EQUIVALENT_VAT";
    private static final String KEY_TOTAL_EQUIVALENT_AMOUNT = "TOTAL_EQUIVALENT_AMOUNT";
    private static final String KEY_TOTAL_EQUIVALENT_VAT = "TOTAL_EQUIVALENT_VAT";
    private static final String KEY_TOTAL_INCLUDING_SUPPLIER_FEES_EQUIVALENT_AMOUNT = "TOTAL_INCLUDING_SUPPLIER_FEES_EQUIVALENT_AMOUNT";
    private static final String KEY_TOTAL_INCLUDING_SUPPLIER_FEES_EQUIVALENT_VAT = "TOTAL_INCLUDING_SUPPLIER_FEES_EQUIVALENT_VAT";
    private static final String KEY_TOTAL_INCLUDING_AGENCY_FEES_EQUIVALENT_AMOUNT = "TOTAL_INCLUDING_AGENCY_FEES_EQUIVALENT_AMOUNT";
    private static final String KEY_TOTAL_INCLUDING_AGENCY_FEES_EQUIVALENT_VAT = "TOTAL_INCLUDING_AGENCY_FEES_EQUIVALENT_VAT";
    private static final String KEY_TOTAL_INCLUDING_AGENCY_FEES_TO_REFUND_EQUIVALENT_AMOUNT = "TOTAL_INCLUDING_AGENCY_FEES_TO_REFUND_EQUIVALENT_AMOUNT";
    private static final String KEY_TOTAL_INCLUDING_AGENCY_FEES_TO_REFUND_EQUIVALENT_VAT = "TOTAL_INCLUDING_AGENCY_FEES_TO_REFUND_EQUIVALENT_VAT";
    private static final String KEY_TOTAL_INCLUDING_AGENCY_FEES_OF_REFUND_EQUIVALENT_AMOUNT = "TOTAL_INCLUDING_AGENCY_FEES_OF_REFUND_EQUIVALENT_AMOUNT";
    private static final String KEY_TOTAL_INCLUDING_AGENCY_FEES_OF_REFUND_EQUIVALENT_VAT = "TOTAL_INCLUDING_AGENCY_FEES_OF_REFUND_EQUIVALENT_VAT";
    private static final String KEY_TOTAL_INCLUDING_SUPPLIER_FEES_AND_AGENCY_FEES_EQUIVALENT_AMOUNT = "TOTAL_INCLUDING_SUPPLIER_FEES_AND_AGENCY_FEES_EQUIVALENT_AMOUNT";
    private static final String KEY_TOTAL_INCLUDING_SUPPLIER_FEES_AND_AGENCY_FEES_EQUIVALENT_VAT = "TOTAL_INCLUDING_SUPPLIER_FEES_AND_AGENCY_FEES_EQUIVALENT_VAT";
    private static final String KEY_TOTAL_INCLUDING_SUPPLIER_FEES_AND_AGENCY_FEES_TO_REFUND_EQUIVALENT_AMOUNT = "TOTAL_INCLUDING_SUPPLIER_FEES_AND_AGENCY_FEES_TO_REFUND_EQUIVALENT_AMOUNT";
    private static final String KEY_TOTAL_INCLUDING_SUPPLIER_FEES_AND_AGENCY_FEES_TO_REFUND_EQUIVALENT_VAT = "TOTAL_INCLUDING_SUPPLIER_FEES_AND_AGENCY_FEES_TO_REFUND_EQUIVALENT_VAT";
    private static final String KEY_TOTAL_INCLUDING_SUPPLIER_FEES_AND_AGENCY_FEES_OF_REFUND_EQUIVALENT_AMOUNT = "TOTAL_INCLUDING_SUPPLIER_FEES_AND_AGENCY_FEES_OF_REFUND_EQUIVALENT_AMOUNT";
    private static final String KEY_TOTAL_INCLUDING_SUPPLIER_FEES_AND_AGENCY_FEES_OF_REFUND_EQUIVALENT_VAT = "TOTAL_INCLUDING_SUPPLIER_FEES_AND_AGENCY_FEES_OF_REFUND_EQUIVALENT_VAT";
    private static final String KEY_VAT_SUM = "VAT_SUM";
    private static final String KEY_VAT_RATE = "VAT_RATE";
    private static final String KEY_VAT_BASIS = "VAT_BASIS";
    private static final String KEY_VAT_TCH_SUM = "VAT_TCH_SUM";
    private static final String KEY_VAT_TCH_RATE = "VAT_TCH_RATE";
    private static final String KEY_VAT_TCH_BASIS = "VAT_TCH_BASIS";
    private static final String KEY_TCH_NAME = "TCH_NAME";
    private static final String KEY_TCH_OFFICIAL_NAME = "TCH_OFFICIAL_NAME";
    private static final String KEY_TCH_REGISTRATION_ID = "TCH_REGISTRATION_ID";
    private static final String KEY_TCH_KPP = "TCH_KPP";
    private static final String KEY_INFORMATION_NOTES = "INFORMATION_NOTES";
    private static final String KEY_ITINERARY = "ITINERARY";
    private static final String KEY_AGENCY_SHORT_NAME = "AGENCY_SHORT_NAME";
    private static final String KEY_AGENCY = "AGENCY";
    private static final String FIELD_DEPARTURE_DATE = "DEPARTURE_DATE";
    private static final String FIELD_DEPARTURE_CITY = "DEPARTURE_CITY";
    private static final String FIELD_DEPARTURE_CITY_EN = "DEPARTURE_CITY_EN";
    private static final String FIELD_DEPARTURE_AIRPORT = "DEPARTURE_AIRPORT";
    private static final String FIELD_DEPARTURE_TERMINAL = "DEPARTURE_TERMINAL";
    private static final String FIELD_ARRIVE_DATE = "ARRIVE_DATE";
    private static final String FIELD_ARRIVE_CITY = "ARRIVE_CITY";
    private static final String FIELD_ARRIVE_CITY_EN = "ARRIVE_CITY_EN";
    private static final String FIELD_ARRIVE_AIRPORT = "ARRIVE_AIRPORT";
    private static final String FIELD_ARRIVE_TERMINAL = "ARRIVE_TERMINAL";
    private static final String FIELD_MARKETING_CARRIER_NAME = "MARKETING_CARRIER_NAME";
    private static final String FIELD_MARKETING_CARRIER_CODE = "MARKETING_CARRIER_CODE";
    private static final String FIELD_OPERATING_CARRIER_NAME = "OPERATING_CARRIER_NAME";
    private static final String FIELD_OPERATING_CARRIER_CODE = "OPERATING_CARRIER_CODE";
    private static final String FIELD_FLIGHT_NUMBER = "FLIGHT_NUMBER";
    private static final String FIELD_AIRLINE_LOCATOR = "AIRLINE_LOCATOR";
    private static final String FIELD_SERVICE_CLASS = "SERVICE_CLASS";
    private static final String FIELD_SERVICE_CLASS_CODE = "SERVICE_CLASS_CODE";
    private static final String FIELD_SEAT_NUMBER = "SEAT_NUMBER";
    private static final String FIELD_BAGGAGE_ALLOWANCE = "BAGGAGE_ALLOWANCE";
    private static final String FIELD_CABIN_LUGGAGE_INFO = "CABIN_LUGGAGE_INFO";
    private static final String FIELD_FARE_BASIS = "FARE_BASIS";
    private static final String FIELD_NOT_VALID_BEFORE_DATE = "NOT_VALID_BEFORE_DATE";
    private static final String FIELD_NOT_VALID_AFTER_DATE = "NOT_VALID_AFTER_DATE";
    private static final String FIELD_DEPARTURE_CITY_TUI = "DEPARTURE_CITY_TUI";
    private static final String FIELD_ARRIVE_CITY_TUI = "ARRIVE_CITY_TUI";
    private static final String KEY_TRAVELLER_NAME_PR = "TRAVELLER_NAME_PR";
    private static final String AGENCY_FULLNAME = "AGENCY_FULLNAME";
    private static final String TOUR_CODE = "TOUR_CODE";
    private static final String AGENCY_PHONE = "AGENCY_PHONE";
    private static final String AGENCY_ADDRESS = "AGENCY_ADDRESS";
    private static final String KEY_TAX_FEE = "TAX_FEE";
    private static final String KEY_PREVIOUS_TICKET_NUMBER = "PREVIOUS_TICKET_NUMBER";
    private static final String PAYMENT_TYPE = "PAYMENT_TYPE";
    private static final String PAYMENT_TYPE_LOCALIZED = "PAYMENT_TYPE_LOCALIZED";
    private static final String FIELD_DEPARTURE_AIRPORT_TUI = "DEPARTURE_AIRPORT_TUI";
    private static final String FIELD_ARRIVE_AIRPORT_TUI = "ARRIVE_AIRPORT_TUI";
    private static final String BOARD = "BOARD";
    private static final String MEAL = "MEAL";
    private static final String DEPARTURE_AIRPORT_CODE = "DEPARTURE_AIRPORT_CODE";
    private static final String ARRIVE_AIRPORT_CODE = "ARRIVE_AIRPORT_CODE";
    private static final Map<Locale, Map<PaymentType, String>> localizedPaymentTypeNames = new HashMap<Locale, Map<PaymentType, String>>();
    private static final Map<Locale, Map<String, String>> localizedCurrencyNames = new HashMap<Locale, Map<String, String>>();
    private static final Map<Locale, String> localizedTerminalEntries = new HashMap<Locale, String>();
    private static final List<String> terminalKeys = Arrays.asList("term", "\u0442\u0435\u0440\u043c");

    public FilledTemplateDocument renderReport(EntityContainer<BookingFile> bookingFile, Product product, EntityContainer<TemplateDocument> template, List<InformationNote> notes, boolean itTariff, boolean useCyrillicName, boolean usePayer, boolean useVat, boolean useAgencyFees, boolean includeAgencyFeesIntoTaxes, boolean useVendorFees, boolean includeVendorFeesIntoTaxes, boolean showTaxesSum, boolean useVatDetalization, boolean hidePassport) throws Exception {
        Locale locale;
        LinkedHashSet messages = new LinkedHashSet();
        JasperReport jasperReport = JasperUtil.getReport((byte[])((TemplateDocument)template.getEntity()).getContent());
        byte[] content = JasperUtil.fillReport((JasperReport)jasperReport, this.getParameters(product, locale = this.getLocale((TemplateDocument)template.getEntity()), notes, itTariff, useCyrillicName, usePayer, useVat, useAgencyFees, includeAgencyFeesIntoTaxes, useVendorFees, includeVendorFeesIntoTaxes, showTaxesSum, useVatDetalization, hidePassport), (JRDataSource)this.getDataSource(product, locale, notes, itTariff, useCyrillicName, usePayer, useVat, showTaxesSum, useVatDetalization, hidePassport), null);
        if (content == null) {
            return null;
        }
        Date date = new Date();
        FilledTemplateDocument file = new FilledTemplateDocument();
        file.setTitle(this.getReportTitle(product, (TemplateDocument)template.getEntity()));
        file.setContentType(ContentType.JASPERPRINT);
        file.setContent(content);
        file.setName(this.getFileName(product, (TemplateDocument)template.getEntity()));
        file.setType(DocumentType.RECEIPT);
        file.setCreated(date);
        file.setNavigationKey(product.getUid());
        file.setOwner(bookingFile.toReference());
        file.setCheckSum(MiscUtil.getCheckSum((byte[])file.getContent()));
        file.setTemplate(template.toReference());
        file.getMessages().clear();
        file.getMessages().addAll(messages);
        return file;
    }

    private Map<String, Object> getParameters(Product product, Locale locale, List<InformationNote> notes, boolean itTariff, boolean useCyrillicName, boolean usePayer, boolean useVat, boolean useAgencyFees, boolean includeAgencyFeesIntoTaxes, boolean useVendorFees, boolean includeVendorFeesIntoTaxes, boolean showTaxesSum, boolean useVatDetalization, boolean hidePassport) throws Exception {
        BigDecimal totalIncludingSupplierFeesAndAgencyFeesOfRefundEquivalentAmount;
        BigDecimal totalIncludingSupplierFeesAndAgencyFeesToRefundEquivalentAmount;
        BigDecimal totalIncludingSupplierFeesAndAgencyFeesEquivalentAmount;
        BigDecimal totalIncludingAgencyFeesOfRefundEquivalentAmount;
        BigDecimal totalIncludingAgencyFeesToRefundEquivalentAmount;
        BigDecimal totalIncludingAgencyFeesEquivalentAmount;
        BigDecimal totalIncludingSupplierFeesEquivalentAmount;
        BigDecimal supplierFeesEquivalentAmount;
        BigDecimal previousTariffTotalAmount;
        BigDecimal tariffEquivalentAmount;
        Map<String, String> currencyNames;
        String equivalentCurrency;
        DictionaryReference validatingCarrier;
        DictionaryReference country;
        Object city;
        Object address;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("REPORT_LOCALE", locale);
        EntityReference<Organization> agencyRef = AirProductHelper.getAgency(product);
        EntityReference<Organization> subagencyRef = AirProductHelper.getSubagency(product);
        Organization agency = ProfileHelper.resolveReference(subagencyRef);
        SalesPoint salesPoint = (SalesPoint)ProfileHelper.resolveReference(product.getSalesPoint());
        SalesPoint validatorSalesPoint = RefundReceiptRender.getSalesPointsByValidatorAndPcc(product.getValidatorCode(), product.getPcc()).stream().map(EntityContainer::getEntity).filter(sp -> sp.getAgency().equals((Object)agencyRef) || sp.getAgency().equals((Object)subagencyRef)).findFirst().orElse(EntityStorage.get().resolve(product.getSalesPoint()) != null ? (SalesPoint)EntityStorage.get().resolve(product.getSalesPoint()).getEntity() : null);
        if (agency != null) {
            String agencyName = L10nStringHelper.getValue((L10nString)agency.getFullName(), (Locale)locale, (boolean)true);
            parameters.put(KEY_AGENCY_NAME, agencyName);
            parameters.put(KEY_AGENCY, ProfileHelper.getFullName(agency.getCode(), agency.getShortName(), agency.getFullName(), (DictionaryReference<LegalForm>)agency.getLegalForm(), LocaleHelper.getCurrentLocale(), false));
            parameters.put(KEY_AGENCY_SHORT_NAME, L10nStringHelper.getValue((L10nString)agency.getShortName(), (Locale)locale, (boolean)false));
        }
        StringJoiner salesPointLocation = new StringJoiner(", ");
        if (salesPoint != null) {
            address = ProfileHelper.filterAddresses(salesPoint.getAddresses(), AddressType.FACTUAL);
            if (address != null) {
                parameters.put(KEY_SALES_POINT_ADDRESS, ProfileHelper.buildFullAddress(address, locale, true));
                city = address.getCity();
                country = address.getCountry();
                String cityString = city.toString(locale);
                String countryString = country.toString(locale);
                if (TextUtil.nonBlank((String)cityString)) {
                    parameters.put(KEY_SALES_POINT_CITY, cityString);
                    salesPointLocation.add(cityString);
                }
                if (TextUtil.nonBlank((String)countryString)) {
                    parameters.put(KEY_SALES_POINT_COUNTRY, countryString);
                    salesPointLocation.add(countryString);
                }
            }
            parameters.put(KEY_SALES_POINT_LOCATION, salesPointLocation.toString());
            Object communication = ProfileHelper.filterCommunications(salesPoint.getCommunications(), CommunicationType.WORK_PHONE);
            if (communication == null) {
                communication = ProfileHelper.filterCommunications(salesPoint.getCommunications(), CommunicationType.MOBILE);
            }
            CommunicationFormat format = new CommunicationFormat("+C (T) N #I");
            parameters.put(KEY_SALES_POINT_PHONE, communication != null ? format.format((Communication)communication) : null);
        }
        if (validatorSalesPoint != null) {
            address = ProfileHelper.filterAddresses(validatorSalesPoint.getAddresses(), AddressType.FACTUAL);
            if (address != null) {
                city = address.getCity();
                if (city != null) {
                    parameters.put(KEY_VALIDATOR_SALES_POINT_CITY, city.toString(locale));
                }
                if ((country = address.getCountry()) != null) {
                    parameters.put(KEY_VALIDATOR_SALES_POINT_COUNTRY, country.toString(locale));
                }
            }
            for (Validator validator : validatorSalesPoint.getValidators()) {
                if (!TextUtil.isSame((String)validator.getNumber(), (String)product.getValidatorCode()) || !MiscUtil.equals((Object)validator.getBlankOwner(), (Object)product.getBlankOwnerRef())) continue;
                EntityContainer validatorSupplierContainer = EntityStorage.get().resolve(validator.getSupplier());
                EntityContainer validatorAgencyContainer = EntityStorage.get().resolve(validator.getAgency());
                if (validatorSupplierContainer == null || validatorAgencyContainer == null) continue;
                Organization validatorSupplier = (Organization)validatorSupplierContainer.getEntity();
                Organization validatorAgency = (Organization)validatorAgencyContainer.getEntity();
                if (ProfileHelper.isOrganizationCode((EntityReference<Organization>)product.getBlankOwnerRef(), "\u04281")) {
                    String agencyTchCode = ProfileHelper.findMetadataStringByCode(validatorAgency.getMetadata(), MetadataKey.KEY_TCH_AGENCY_CODE.name());
                    parameters.put(KEY_AGENCY_TCH_CODE, agencyTchCode);
                }
                if (ProfileHelper.isOrganizationType(validatorSupplier, OrganizationType.BLANK_OWNER)) {
                    parameters.put(KEY_VALIDATOR_AGENCY_NAME, L10nStringHelper.getValue((L10nString)validatorAgency.getFullName(), (Locale)locale, (boolean)true));
                    break;
                }
                if (!ProfileHelper.isOrganizationType(validatorSupplier, OrganizationType.AGENCY)) continue;
                parameters.put(KEY_VALIDATOR_AGENCY_NAME, L10nStringHelper.getValue((L10nString)validatorSupplier.getFullName(), (Locale)locale, (boolean)true));
                break;
            }
        }
        parameters.put(KEY_PNR, CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator(product.getReservation()));
        parameters.put(KEY_SYSTEM_NUMBER, product.getSystemNumber());
        parameters.put(KEY_ISSUE_DATE, product.getIssueDate());
        if (product.getPreviousProduct() != null) {
            parameters.put(KEY_PREVIOUS_ISSUE_DATE, product.getPreviousProduct().getIssueDate());
        }
        if ((validatingCarrier = product.getCarrier()) != null) {
            parameters.put(KEY_VALIDATING_CARRIER_NAME, validatingCarrier.toString(locale));
            Airline validatingAirline = (Airline)DictionaryCache.get().resolveReference(validatingCarrier);
            if (validatingAirline != null) {
                String validatingAirlineName = (validatingAirline.getLegalForm() != null ? validatingAirline.getLegalForm().toString(locale) + " " : "") + "\"" + validatingAirline.toString(locale) + "\"";
                parameters.put(KEY_VALIDATING_CARRIER_OFFICIAL_NAME, validatingAirlineName);
                String validatingCarrierRegistrationId = TextUtil.isBlank((String)validatingAirline.getRegistrationId()) ? null : validatingAirline.getRegistrationId();
                parameters.put(KEY_VALIDATING_CARRIER_REGISTRATION_ID, validatingCarrierRegistrationId);
                String validatingCarrierKpp = TextUtil.isBlank((String)validatingAirline.getKpp()) ? null : validatingAirline.getKpp();
                parameters.put(KEY_VALIDATING_CARRIER_KPP, validatingCarrierKpp);
            }
        }
        parameters.put(KEY_VALIDATING_CARRIER_CODE, product.getCarrierNumber());
        parameters.put(KEY_VALIDATOR, product.getValidatorCode());
        parameters.put(KEY_AGENT_CODE, product.getCashierCode());
        Traveller traveller = product.getTraveller();
        if (traveller != null) {
            String birthdayString;
            String travellerName;
            String string = travellerName = useCyrillicName && !TextUtil.isBlank((String)traveller.getCyrillicName()) ? traveller.getCyrillicName() : traveller.getName();
            if (TextUtil.isBlank((String)travellerName) && traveller.getPassport() != null) {
                PersonalNameFormat format = new PersonalNameFormat("L F S M");
                travellerName = format.format((PersonalName)traveller.getPassport());
            }
            parameters.put(KEY_TRAVELLER_NAME, travellerName);
            parameters.put(KEY_TRAVELLER_NAME_PR, this.getTravellerName(traveller, locale, useCyrillicName));
            String addr = null;
            String phone = null;
            String afn = null;
            if (ProfileHelper.resolveReference(agencyRef) != null) {
                Organization agcy = ProfileHelper.resolveReference(agencyRef);
                for (Address a : ProfileHelper.getOrganizationAddresses(agcy, product.getIssueDate())) {
                    if (a == null || !AddressType.BUSINESS.equals((Object)a.getAddressType()) && !AddressType.LEGAL.equals((Object)a.getAddressType()) && !AddressType.FACTUAL.equals((Object)a.getAddressType())) continue;
                    addr = this.getFullAddress(a, locale);
                    break;
                }
                phone = this.buildPhoneString(agcy.getCommunications(), Arrays.asList(CommunicationType.WORK_PHONE), locale);
                afn = agcy.getFullName() != null && !agcy.getFullName().getValues().isEmpty() ? (agcy.getFullName().getValues().get(locale) != null ? (String)agcy.getFullName().getValues().get(locale) : (String)agcy.getFullName().getValues().values().stream().filter(Objects::nonNull).findFirst().orElse(null)) : null;
            }
            parameters.put(AGENCY_ADDRESS, addr);
            parameters.put(AGENCY_PHONE, phone);
            parameters.put(AGENCY_FULLNAME, afn);
            parameters.put(TOUR_CODE, product.getTourCode());
            parameters.put(KEY_TAX_FEE, this.getTaxAndFee(product));
            String prevCN = this.getPreviousCN(product);
            String prevsN = this.getPreviousSN(product);
            parameters.put(KEY_PREVIOUS_TICKET_NUMBER, (TextUtil.nonBlank((String)prevCN) ? prevCN + "-" : "") + (TextUtil.nonBlank((String)prevsN) ? prevsN : ""));
            PaymentType paymentType = this.getPaymentType(AirProductHelper.getClientContractRelation(product).getFops());
            if (paymentType != null) {
                parameters.put(PAYMENT_TYPE, paymentType.toString(locale));
                parameters.put(PAYMENT_TYPE_LOCALIZED, ItineraryReceiptHelper.getLocalizedPaymentType(paymentType, locale));
            }
            if (traveller.getPassport() != null) {
                if (traveller.getPassport().getType() != null) {
                    parameters.put(KEY_TRAVELLER_PASSPORT_TYPE, LocaleHelper.toString((Object)traveller.getPassport().getType(), (Locale)locale));
                }
                parameters.put(KEY_TRAVELLER_PASSPORT_NUMBER, hidePassport ? RefundReceiptRender.hidePassport(traveller.getPassport().getNumber()) : traveller.getPassport().getNumber());
            }
            SimpleDateFormat sdf = new SimpleDateFormat("dd MMM yyyy", locale);
            String string2 = birthdayString = traveller.getBirthday() != null ? sdf.format(traveller.getBirthday()) : "";
            if (DictHelper.isChildrenPassengerType((DictionaryReference<PassengerType>)product.getPassengerType())) {
                parameters.put(KEY_TRAVELLER_CHILD_BIRTHDAY_DATE, birthdayString + " / CHD");
            } else if (DictHelper.isInfantsPassengerType((DictionaryReference<PassengerType>)product.getPassengerType())) {
                parameters.put(KEY_TRAVELLER_CHILD_BIRTHDAY_DATE, birthdayString + " / INF");
            }
        }
        String equivalentCurrencyString = null;
        CurrencyInfo currencyInfo = (CurrencyInfo)DictionaryCache.get().resolveReference(AirProductHelper.getClientContractRelation(product).getGeneralData().getCurrency());
        String string = equivalentCurrency = currencyInfo != null ? currencyInfo.getCode() : DictHelper.getLocalCurrency2();
        if (equivalentCurrency != null && (currencyNames = localizedCurrencyNames.get(locale)) != null) {
            equivalentCurrencyString = currencyNames.get(equivalentCurrency);
        }
        parameters.put(KEY_USE_VAT, useVat);
        parameters.put(KEY_USE_FEES, useAgencyFees || useVendorFees);
        parameters.put(KEY_USE_FEES_AS_TAXES, includeAgencyFeesIntoTaxes || includeVendorFeesIntoTaxes);
        parameters.put(KEY_SHOW_TAXES_SUM, showTaxesSum);
        HashSet<FopType> fopTypes = new HashSet<FopType>();
        fopTypes.addAll(GeneralProductHelper.productFopTypes);
        fopTypes.addAll(GeneralProductHelper.feeFopTypes);
        Collection<ProductFop> productFops = AirProductHelper.filterFops(AirProductHelper.getClientContractRelation(product).getFops(), GeneralProductHelper.productFopTypes, null, null, null);
        Collection<ProductFop> feeFops = AirProductHelper.filterFops(AirProductHelper.getClientContractRelation(product).getFops(), GeneralProductHelper.feeFopTypes, null, null, null);
        parameters.put(KEY_PAYMENTS_PRODUCT_EQUIVALENT_AMOUNT, this.getPaymentsEquivalentAmountParamater(Arrays.asList(PaymentInfo.of(productFops, null, false)), itTariff, usePayer, locale));
        parameters.put(KEY_PAYMENTS_PRODUCT_INCLUDING_AGENCY_FEES_EQUIVALENT_AMOUNT, this.getPaymentsEquivalentAmountParamater(Arrays.asList(PaymentInfo.of(productFops, null, false), PaymentInfo.of(feeFops, null, false)), itTariff, usePayer, locale));
        parameters.put(KEY_PAYMENTS_PRODUCT_INCLUDING_AGENCY_FEES_TO_REFUND_EQUIVALENT_AMOUNT, this.getPaymentsEquivalentAmountParamater(Arrays.asList(PaymentInfo.of(productFops, null, false), PaymentInfo.of(feeFops, FeesType.FEES_TO_REFUND, false)), itTariff, usePayer, locale));
        parameters.put(KEY_PAYMENTS_PRODUCT_INCLUDING_AGENCY_FEES_OF_REFUND_EQUIVALENT_AMOUNT, this.getPaymentsEquivalentAmountParamater(Arrays.asList(PaymentInfo.of(productFops, null, false), PaymentInfo.of(feeFops, FeesType.FEES_OF_REFUND, false)), itTariff, usePayer, locale));
        parameters.put(KEY_PAYMENTS_FEES_EQUIVALENT_AMOUNT, this.getPaymentsEquivalentAmountParamater(Arrays.asList(PaymentInfo.of(feeFops, null, false)), itTariff, usePayer, locale));
        parameters.put(KEY_PAYMENTS_FEES_TO_REFUND_EQUIVALENT_AMOUNT, this.getPaymentsEquivalentAmountParamater(Arrays.asList(PaymentInfo.of(feeFops, FeesType.FEES_TO_REFUND, false)), itTariff, usePayer, locale));
        parameters.put(KEY_PAYMENTS_FEES_OF_REFUND_EQUIVALENT_AMOUNT, this.getPaymentsEquivalentAmountParamater(Arrays.asList(PaymentInfo.of(feeFops, FeesType.FEES_OF_REFUND, true)), itTariff, usePayer, locale));
        Money tariffBaseAmount = AirProductHelper.getBaseFare(product);
        if (tariffBaseAmount != null && tariffBaseAmount.getValue() != null) {
            Map<String, String> currencyNames2;
            String currencyString = null;
            if (tariffBaseAmount.getCurrency() != null && (currencyNames2 = localizedCurrencyNames.get(locale)) != null) {
                currencyString = currencyNames2.get(tariffBaseAmount.getCurrency());
            }
            parameters.put(KEY_TARIFF_BASE_AMOUNT, String.format("%s%s", itTariff ? "IT" : String.format(locale, "%.2f", tariffBaseAmount.getValue()), currencyString != null ? currencyString : ""));
        }
        if ((tariffEquivalentAmount = AirProductHelper.getEquivalentFare(product)) != null) {
            parameters.put(KEY_TARIFF_EQUIVALENT_AMOUNT, String.format("%s%s", itTariff ? "IT" : String.format(locale, "%.2f", tariffEquivalentAmount), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
        }
        if ((previousTariffTotalAmount = AirProductHelper.calculateTotalEquivalentFare(product.getPreviousProduct())) != null) {
            parameters.put(KEY_TARIFF_TOTAL_AMOUNT, String.format("%s%s", itTariff ? "IT" : String.format(locale, "%.2f", previousTariffTotalAmount), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
        }
        StringBuilder taxesIncludingAgencyFeesEquivalentAmount = new StringBuilder();
        StringBuilder taxesIncludingAgencyFeesToRefundEquivalentAmount = new StringBuilder();
        StringBuilder taxesIncludingAgencyFeesOfRefundEquivalentAmount = new StringBuilder();
        StringBuilder taxesEquivalentAmount = new StringBuilder();
        StringBuilder taxesSum = new StringBuilder();
        BigDecimal taxesSumAmount = BigDecimal.ZERO;
        HashMap<String, String> taxesMap = new HashMap<String, String>();
        for (Object tax : product.getTaxes()) {
            taxesMap.put(tax.getUid(), tax.getCode());
            if (tax.getEquivalentAmount() == null) continue;
            if (showTaxesSum) {
                taxesSumAmount = taxesSumAmount.add(tax.getEquivalentAmount());
            }
            String taxCodeString = null;
            if (!TextUtil.isBlank((String)tax.getCode())) {
                taxCodeString = tax.getCode().trim();
            }
            if (taxesIncludingAgencyFeesEquivalentAmount.length() > 0) {
                taxesIncludingAgencyFeesEquivalentAmount.append(" ");
            }
            taxesIncludingAgencyFeesEquivalentAmount.append(String.format("%s%s%s", taxCodeString != null ? taxCodeString : "", String.format(locale, "%.2f", tax.getEquivalentAmount()), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
            if (taxesIncludingAgencyFeesToRefundEquivalentAmount.length() > 0) {
                taxesIncludingAgencyFeesToRefundEquivalentAmount.append(" ");
            }
            taxesIncludingAgencyFeesToRefundEquivalentAmount.append(String.format("%s%s%s", taxCodeString != null ? taxCodeString : "", String.format(locale, "%.2f", tax.getEquivalentAmount()), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
            if (taxesIncludingAgencyFeesOfRefundEquivalentAmount.length() > 0) {
                taxesIncludingAgencyFeesOfRefundEquivalentAmount.append(" ");
            }
            taxesIncludingAgencyFeesOfRefundEquivalentAmount.append(String.format("%s%s%s", taxCodeString != null ? taxCodeString : "", String.format(locale, "%.2f", tax.getEquivalentAmount()), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
            if (taxesEquivalentAmount.length() > 0) {
                taxesEquivalentAmount.append(" ");
            }
            taxesEquivalentAmount.append(String.format("%s%s%s", taxCodeString != null ? taxCodeString : "", String.format(locale, "%.2f", tax.getEquivalentAmount()), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
        }
        Collection<Commission> hiddenFees = GeneralProductHelper.filterCommissions(AirProductHelper.getUnmodifiableCommissions(product, ContractType.CLIENT), GeneralProductHelper.feePropertyTypes, null, GeneralProductHelper.hiddenCommissionCategories);
        for (Commission hiddenFee : hiddenFees) {
            EntityContainer hiddenFeePropertyContainer;
            if (hiddenFee.getEquivalentAmount() == null) continue;
            if (showTaxesSum && (includeAgencyFeesIntoTaxes || includeVendorFeesIntoTaxes)) {
                taxesSumAmount = taxesSumAmount.add(hiddenFee.getEquivalentAmount());
            }
            if ((hiddenFeePropertyContainer = EntityStorage.get().resolve(hiddenFee.getCommissionProperties())) == null) continue;
            FeeProperties hiddenFeeProperty = (FeeProperties)hiddenFeePropertyContainer.getEntity();
            String taxCodeString = null;
            if (!TextUtil.isBlank((String)hiddenFeeProperty.getHiddenFeeTaxCode())) {
                taxCodeString = hiddenFeeProperty.getHiddenFeeTaxCode().trim();
            }
            if (taxesIncludingAgencyFeesEquivalentAmount.length() > 0) {
                taxesIncludingAgencyFeesEquivalentAmount.append(" ");
            }
            taxesIncludingAgencyFeesEquivalentAmount.append(String.format("%s%s%s", taxCodeString != null ? taxCodeString : "", String.format(locale, "%.2f", hiddenFee.getEquivalentAmount()), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
            if (taxesIncludingAgencyFeesToRefundEquivalentAmount.length() > 0) {
                taxesIncludingAgencyFeesToRefundEquivalentAmount.append(" ");
            }
            taxesIncludingAgencyFeesToRefundEquivalentAmount.append(String.format("%s%s%s", taxCodeString != null ? taxCodeString : "", String.format(locale, "%.2f", hiddenFee.getEquivalentAmount()), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
            if (taxesIncludingAgencyFeesOfRefundEquivalentAmount.length() > 0) {
                taxesIncludingAgencyFeesOfRefundEquivalentAmount.append(" ");
            }
            taxesIncludingAgencyFeesOfRefundEquivalentAmount.append(String.format("%s%s%s", taxCodeString != null ? taxCodeString : "", String.format(locale, "%.2f", hiddenFee.getEquivalentAmount()), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
            if (taxesEquivalentAmount.length() > 0) {
                taxesEquivalentAmount.append(" ");
            }
            taxesEquivalentAmount.append(String.format("%s%s%s", taxCodeString != null ? taxCodeString : "", String.format(locale, "%.2f", hiddenFee.getEquivalentAmount()), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
        }
        parameters.put(KEY_TAXES_EQUIVALENT_AMOUNT, taxesEquivalentAmount.length() > 0 ? taxesEquivalentAmount.toString() : null);
        BigDecimal penaltyEquivalentAmount = product.getPenalty();
        if (penaltyEquivalentAmount != null) {
            parameters.put(KEY_PENALTY_EQUIVALENT_AMOUNT, String.format("%s%s", String.format(locale, "%.2f", penaltyEquivalentAmount), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
        }
        if ((supplierFeesEquivalentAmount = AirProductHelper.calculateOBFeesEquivalentAmount(product)) != null) {
            parameters.put(KEY_SUPPLIER_FEES_EQUIVALENT_AMOUNT, String.format("%s%s", String.format(locale, "%.2f", supplierFeesEquivalentAmount), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
        }
        BigDecimal supplierFeesEquivalentVat = null;
        BigDecimal hiddenFeesEquivalentAmount = GeneralProductHelper.calculateCommissionsEquivalentValue(GeneralProductHelper.filterCommissions(AirProductHelper.getUnmodifiableCommissions(product, ContractType.CLIENT), GeneralProductHelper.feePropertyTypes, null, GeneralProductHelper.hiddenCommissionCategories));
        Object hiddenFeesEquivalentVat = null;
        BigDecimal agencyFeesEquivalentAmount = AirProductHelper.calculateCommissionsEquivalentValue(GeneralProductHelper.filterCommissions(AirProductHelper.getUnmodifiableCommissions(product, ContractType.CLIENT), GeneralProductHelper.feePropertyTypes, null, GeneralProductHelper.standardCommissionCategories));
        BigDecimal agencyFeesEquivalentVat = null;
        if (agencyFeesEquivalentAmount != null) {
            if (taxesIncludingAgencyFeesEquivalentAmount.length() > 0) {
                taxesIncludingAgencyFeesEquivalentAmount.append(" ");
            }
            taxesIncludingAgencyFeesEquivalentAmount.append(String.format("%s%s", String.format(locale, "%.2f", agencyFeesEquivalentAmount), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
            parameters.put(KEY_AGENCY_FEES_EQUIVALENT_AMOUNT, String.format("%s%s", String.format(locale, "%.2f", agencyFeesEquivalentAmount), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
            if (agency != null && !agency.isSimpleTaxed()) {
                BigDecimal defaulVat = DictHelper.getDefaultVat(product);
                VatAmount vatAmount = new VatAmount();
                vatAmount.setTotalVat(agencyFeesEquivalentAmount, defaulVat != null ? defaulVat.doubleValue() : 0.0);
                agencyFeesEquivalentVat = vatAmount.getVatAmount();
                if (agencyFeesEquivalentVat != null && agencyFeesEquivalentVat.compareTo(BigDecimal.ZERO) != 0) {
                    parameters.put(KEY_AGENCY_FEES_EQUIVALENT_VAT, String.format("%s%s", String.format(locale, "%.2f", agencyFeesEquivalentVat), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
                }
            }
        }
        parameters.put(KEY_TAXES_INCLUDING_AGENCY_FEES_EQUIVALENT_AMOUNT, taxesIncludingAgencyFeesEquivalentAmount.length() > 0 ? taxesIncludingAgencyFeesEquivalentAmount.toString() : null);
        List commissions = GeneralProductHelper.filterCommissions(AirProductHelper.getUnmodifiableCommissions(product, ContractType.CLIENT), GeneralProductHelper.feePropertyTypes, null, GeneralProductHelper.standardCommissionCategories).stream().filter(item -> MiscUtil.compare((Comparable)item.getEquivalentAmount(), (Comparable)BigDecimal.ZERO) >= 0).collect(Collectors.toList());
        Collection vendorContractRelationCommissions = GeneralProductHelper.filterCommissions(AirProductHelper.getUnmodifiableCommissions(product, ContractType.VENDOR), GeneralProductHelper.feePropertyTypes, null, GeneralProductHelper.standardCommissionCategories).stream().filter(item -> MiscUtil.compare((Comparable)item.getEquivalentAmount(), (Comparable)BigDecimal.ZERO) >= 0).collect(Collectors.toList());
        List vendorCommissionProperties = vendorContractRelationCommissions.stream().map(BaseCommission::getCommissionProperties).filter(Objects::nonNull).collect(Collectors.toList());
        List<Commission> agencyCommissions = commissions.stream().filter(c -> !vendorCommissionProperties.contains(c.getCommissionProperties())).collect(Collectors.toList());
        List<Commission> vendorCommissions = commissions.stream().filter(c -> vendorCommissionProperties.contains(c.getCommissionProperties())).collect(Collectors.toList());
        BigDecimal agencyFeesToRefundEquivalentAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{useAgencyFees ? AirProductHelper.calculateCommissionsEquivalentValue(agencyCommissions) : null, useVendorFees ? AirProductHelper.calculateCommissionsEquivalentValue(vendorCommissions) : null});
        BigDecimal agencyFeesToRefundEquivalentVat = null;
        if (agencyFeesToRefundEquivalentAmount != null) {
            if (showTaxesSum && (includeAgencyFeesIntoTaxes || includeVendorFeesIntoTaxes)) {
                taxesSumAmount = taxesSumAmount.add(agencyFeesToRefundEquivalentAmount);
            }
            if (taxesIncludingAgencyFeesToRefundEquivalentAmount.length() > 0) {
                taxesIncludingAgencyFeesToRefundEquivalentAmount.append(" ");
            }
            taxesIncludingAgencyFeesToRefundEquivalentAmount.append(String.format("%s%s", String.format(locale, "%.2f", agencyFeesToRefundEquivalentAmount), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
            parameters.put(KEY_AGENCY_FEES_TO_REFUND_EQUIVALENT_AMOUNT, String.format("%s%s", String.format(locale, "%.2f", agencyFeesToRefundEquivalentAmount), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
            if (agency != null && !agency.isSimpleTaxed()) {
                BigDecimal defaulVat = DictHelper.getDefaultVat(product);
                VatAmount vatAmount = new VatAmount();
                vatAmount.setTotalVat(agencyFeesToRefundEquivalentAmount, defaulVat != null ? defaulVat.doubleValue() : 0.0);
                agencyFeesToRefundEquivalentVat = vatAmount.getVatAmount();
                if (agencyFeesToRefundEquivalentVat != null && agencyFeesToRefundEquivalentVat.compareTo(BigDecimal.ZERO) != 0) {
                    parameters.put(KEY_AGENCY_FEES_TO_REFUND_EQUIVALENT_VAT, String.format("%s%s", String.format(locale, "%.2f", agencyFeesToRefundEquivalentVat), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
                }
            }
        }
        if (showTaxesSum && taxesSumAmount.compareTo(BigDecimal.ZERO) > 0) {
            taxesSum.append("XT").append(String.format(locale, "%.2f", taxesSumAmount)).append(equivalentCurrencyString != null ? equivalentCurrencyString : "");
        }
        parameters.put(KEY_TAXES_SUM, taxesSum.length() > 0 ? taxesSum.toString() : null);
        parameters.put(KEY_TAXES_INCLUDING_AGENCY_FEES_TO_REFUND_EQUIVALENT_AMOUNT, taxesIncludingAgencyFeesToRefundEquivalentAmount.length() > 0 ? taxesIncludingAgencyFeesToRefundEquivalentAmount.toString() : null);
        BigDecimal agencyFeesOfRefundEquivalentAmount = MiscUtil.negate((BigDecimal)AirProductHelper.calculateCommissionsEquivalentValue(GeneralProductHelper.filterCommissions(AirProductHelper.getUnmodifiableCommissions(product, ContractType.CLIENT), GeneralProductHelper.feePropertyTypes, null, GeneralProductHelper.standardCommissionCategories).stream().filter(item -> MiscUtil.compare((Comparable)item.getEquivalentAmount(), (Comparable)BigDecimal.ZERO) < 0).collect(Collectors.toList())));
        BigDecimal agencyFeesOfRefundEquivalentVat = null;
        if (agencyFeesOfRefundEquivalentAmount != null) {
            if (taxesIncludingAgencyFeesOfRefundEquivalentAmount.length() > 0) {
                taxesIncludingAgencyFeesOfRefundEquivalentAmount.append(" ");
            }
            taxesIncludingAgencyFeesOfRefundEquivalentAmount.append(String.format("%s%s", String.format(locale, "%.2f", agencyFeesOfRefundEquivalentAmount), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
            parameters.put(KEY_AGENCY_FEES_OF_REFUND_EQUIVALENT_AMOUNT, String.format("%s%s", String.format(locale, "%.2f", agencyFeesOfRefundEquivalentAmount), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
            if (agency != null && !agency.isSimpleTaxed()) {
                BigDecimal defaulVat = DictHelper.getDefaultVat(product);
                VatAmount vatAmount = new VatAmount();
                vatAmount.setTotalVat(agencyFeesOfRefundEquivalentAmount, defaulVat != null ? defaulVat.doubleValue() : 0.0);
                agencyFeesOfRefundEquivalentVat = vatAmount.getVatAmount();
                if (agencyFeesOfRefundEquivalentVat != null && agencyFeesOfRefundEquivalentVat.compareTo(BigDecimal.ZERO) != 0) {
                    parameters.put(KEY_AGENCY_FEES_OF_REFUND_EQUIVALENT_VAT, String.format("%s%s", String.format(locale, "%.2f", agencyFeesOfRefundEquivalentVat), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
                }
            }
        }
        parameters.put(KEY_TAXES_INCLUDING_AGENCY_FEES_OF_REFUND_EQUIVALENT_AMOUNT, taxesIncludingAgencyFeesOfRefundEquivalentAmount.length() > 0 ? taxesIncludingAgencyFeesOfRefundEquivalentAmount.toString() : null);
        BigDecimal totalEquivalentAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{AirProductHelper.getTotalEquivalentFare(product), MiscUtil.negate((BigDecimal)supplierFeesEquivalentAmount), hiddenFeesEquivalentAmount});
        if (totalEquivalentAmount != null) {
            parameters.put(KEY_TOTAL_EQUIVALENT_AMOUNT, String.format("%s%s", itTariff ? "IT" : String.format(locale, "%.2f", totalEquivalentAmount), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
        }
        BigDecimal totalEquivalentVat = MiscUtil.sum((BigDecimal[])new BigDecimal[]{product.getTotalVendorEquivalentVatAmount(), MiscUtil.negate(supplierFeesEquivalentVat), hiddenFeesEquivalentVat});
        if (!itTariff && totalEquivalentVat != null && totalEquivalentVat.compareTo(BigDecimal.ZERO) != 0) {
            parameters.put(KEY_TOTAL_EQUIVALENT_VAT, String.format("%s%s", String.format(locale, "%.2f", totalEquivalentVat), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
        }
        if ((totalIncludingSupplierFeesEquivalentAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalEquivalentAmount, supplierFeesEquivalentAmount})) != null) {
            parameters.put(KEY_TOTAL_INCLUDING_SUPPLIER_FEES_EQUIVALENT_AMOUNT, String.format("%s%s", itTariff ? "IT" : String.format(locale, "%.2f", totalIncludingSupplierFeesEquivalentAmount), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
        }
        BigDecimal totalIncludingSupplierFeesEquivalentVat = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalEquivalentVat, supplierFeesEquivalentVat});
        if (!itTariff && totalIncludingSupplierFeesEquivalentVat != null && totalIncludingSupplierFeesEquivalentVat.compareTo(BigDecimal.ZERO) != 0) {
            parameters.put(KEY_TOTAL_INCLUDING_SUPPLIER_FEES_EQUIVALENT_VAT, String.format("%s%s", String.format(locale, "%.2f", totalIncludingSupplierFeesEquivalentVat), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
        }
        if ((totalIncludingAgencyFeesEquivalentAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalEquivalentAmount, agencyFeesEquivalentAmount})) != null) {
            parameters.put(KEY_TOTAL_INCLUDING_AGENCY_FEES_EQUIVALENT_AMOUNT, String.format("%s%s", itTariff ? "IT" : String.format(locale, "%.2f", totalIncludingAgencyFeesEquivalentAmount), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
        }
        BigDecimal totalIncludingAgencyFeesEquivalentVat = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalEquivalentVat, agencyFeesEquivalentVat});
        if (!itTariff && totalIncludingAgencyFeesEquivalentVat != null && totalIncludingAgencyFeesEquivalentVat.compareTo(BigDecimal.ZERO) != 0) {
            parameters.put(KEY_TOTAL_INCLUDING_AGENCY_FEES_EQUIVALENT_VAT, String.format("%s%s", String.format(locale, "%.2f", totalIncludingAgencyFeesEquivalentVat), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
        }
        if ((totalIncludingAgencyFeesToRefundEquivalentAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalEquivalentAmount, agencyFeesToRefundEquivalentAmount})) != null) {
            parameters.put(KEY_TOTAL_INCLUDING_AGENCY_FEES_TO_REFUND_EQUIVALENT_AMOUNT, String.format("%s%s", itTariff ? "IT" : String.format(locale, "%.2f", totalIncludingAgencyFeesToRefundEquivalentAmount), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
        }
        BigDecimal totalIncludingAgencyFeesToRefundEquivalentVat = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalEquivalentVat, agencyFeesToRefundEquivalentVat});
        if (!itTariff && totalIncludingAgencyFeesToRefundEquivalentVat != null && totalIncludingAgencyFeesToRefundEquivalentVat.compareTo(BigDecimal.ZERO) != 0) {
            parameters.put(KEY_TOTAL_INCLUDING_AGENCY_FEES_TO_REFUND_EQUIVALENT_VAT, String.format("%s%s", String.format(locale, "%.2f", totalIncludingAgencyFeesToRefundEquivalentVat), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
        }
        if ((totalIncludingAgencyFeesOfRefundEquivalentAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalEquivalentAmount, MiscUtil.negate((BigDecimal)agencyFeesOfRefundEquivalentAmount)})) != null) {
            parameters.put(KEY_TOTAL_INCLUDING_AGENCY_FEES_OF_REFUND_EQUIVALENT_AMOUNT, String.format("%s%s", itTariff ? "IT" : String.format(locale, "%.2f", totalIncludingAgencyFeesOfRefundEquivalentAmount), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
        }
        BigDecimal totalIncludingAgencyFeesOfRefundEquivalentVat = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalEquivalentVat, MiscUtil.negate((BigDecimal)agencyFeesOfRefundEquivalentVat)});
        if (!itTariff && totalIncludingAgencyFeesOfRefundEquivalentVat != null && totalIncludingAgencyFeesOfRefundEquivalentVat.compareTo(BigDecimal.ZERO) != 0) {
            parameters.put(KEY_TOTAL_INCLUDING_AGENCY_FEES_OF_REFUND_EQUIVALENT_VAT, String.format("%s%s", String.format(locale, "%.2f", totalIncludingAgencyFeesOfRefundEquivalentVat), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
        }
        if ((totalIncludingSupplierFeesAndAgencyFeesEquivalentAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalEquivalentAmount, supplierFeesEquivalentAmount, agencyFeesEquivalentAmount})) != null) {
            parameters.put(KEY_TOTAL_INCLUDING_SUPPLIER_FEES_AND_AGENCY_FEES_EQUIVALENT_AMOUNT, String.format("%s%s", itTariff ? "IT" : String.format(locale, "%.2f", totalIncludingSupplierFeesAndAgencyFeesEquivalentAmount), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
        }
        BigDecimal totalIncludingSupplierFeesAndAgencyFeesEquivalentVat = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalEquivalentVat, supplierFeesEquivalentVat, agencyFeesEquivalentVat});
        if (!itTariff && totalIncludingSupplierFeesAndAgencyFeesEquivalentVat != null && totalIncludingSupplierFeesAndAgencyFeesEquivalentVat.compareTo(BigDecimal.ZERO) != 0) {
            parameters.put(KEY_TOTAL_INCLUDING_SUPPLIER_FEES_AND_AGENCY_FEES_EQUIVALENT_VAT, String.format("%s%s", String.format(locale, "%.2f", totalIncludingSupplierFeesAndAgencyFeesEquivalentVat), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
        }
        if ((totalIncludingSupplierFeesAndAgencyFeesToRefundEquivalentAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalEquivalentAmount, supplierFeesEquivalentAmount, agencyFeesToRefundEquivalentAmount})) != null) {
            parameters.put(KEY_TOTAL_INCLUDING_SUPPLIER_FEES_AND_AGENCY_FEES_TO_REFUND_EQUIVALENT_AMOUNT, String.format("%s%s", itTariff ? "IT" : String.format(locale, "%.2f", totalIncludingSupplierFeesAndAgencyFeesToRefundEquivalentAmount), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
            parameters.put(KEY_PENALTY_TOTAL_AMOUNT, String.format("%s%s", itTariff ? "IT" : String.format(locale, "%.2f", previousTariffTotalAmount.subtract(totalIncludingSupplierFeesAndAgencyFeesToRefundEquivalentAmount)), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
        }
        BigDecimal totalIncludingSupplierFeesAndAgencyFeesToRefundEquivalentVat = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalEquivalentVat, supplierFeesEquivalentVat, agencyFeesToRefundEquivalentVat});
        if (!itTariff && totalIncludingSupplierFeesAndAgencyFeesToRefundEquivalentVat != null && totalIncludingSupplierFeesAndAgencyFeesToRefundEquivalentVat.compareTo(BigDecimal.ZERO) != 0) {
            parameters.put(KEY_TOTAL_INCLUDING_SUPPLIER_FEES_AND_AGENCY_FEES_TO_REFUND_EQUIVALENT_VAT, String.format("%s%s", String.format(locale, "%.2f", totalIncludingSupplierFeesAndAgencyFeesToRefundEquivalentVat), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
        }
        if ((totalIncludingSupplierFeesAndAgencyFeesOfRefundEquivalentAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalEquivalentAmount, supplierFeesEquivalentAmount, MiscUtil.negate((BigDecimal)agencyFeesOfRefundEquivalentAmount)})) != null) {
            parameters.put(KEY_TOTAL_INCLUDING_SUPPLIER_FEES_AND_AGENCY_FEES_OF_REFUND_EQUIVALENT_AMOUNT, String.format("%s%s", itTariff ? "IT" : String.format(locale, "%.2f", totalIncludingSupplierFeesAndAgencyFeesOfRefundEquivalentAmount), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
        }
        BigDecimal totalIncludingSupplierFeesAndAgencyFeesOfRefundEquivalentVat = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalEquivalentVat, supplierFeesEquivalentVat, MiscUtil.negate((BigDecimal)agencyFeesOfRefundEquivalentVat)});
        if (!itTariff && totalIncludingSupplierFeesAndAgencyFeesOfRefundEquivalentVat != null && totalIncludingSupplierFeesAndAgencyFeesOfRefundEquivalentVat.compareTo(BigDecimal.ZERO) != 0) {
            parameters.put(KEY_TOTAL_INCLUDING_SUPPLIER_FEES_AND_AGENCY_FEES_OF_REFUND_EQUIVALENT_VAT, String.format("%s%s", String.format(locale, "%.2f", totalIncludingSupplierFeesAndAgencyFeesOfRefundEquivalentVat), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
        }
        if (product.getVendorVatDetalization() != null) {
            List<VatComponent> vatComponentsWithoutZZ = product.getVendorVatDetalization().getComponents().stream().filter(Objects::nonNull).filter(comp -> comp.getTaxesUids().stream().allMatch(uid -> uid == null || !"ZZ".equalsIgnoreCase((String)taxesMap.get(uid)))).collect(Collectors.toList());
            List vatComponentsWithZZ = product.getVendorVatDetalization().getComponents().stream().filter(Objects::nonNull).filter(comp -> !comp.getTaxesUids().stream().allMatch(uid -> uid == null || !"ZZ".equalsIgnoreCase((String)taxesMap.get(uid)))).collect(Collectors.toList());
            if (!vatComponentsWithoutZZ.isEmpty() || !vatComponentsWithZZ.isEmpty()) {
                parameters.put(KEY_USE_VAT_DETALIZATION, useVatDetalization);
            }
            if (!vatComponentsWithoutZZ.isEmpty()) {
                parameters.put(KEY_VAT_SUM, this.vatSumToString(vatComponentsWithoutZZ, "\n"));
                parameters.put(KEY_VAT_RATE, this.vatRateToString(vatComponentsWithoutZZ, "\n"));
                parameters.put(KEY_VAT_BASIS, this.vatBasisToString(vatComponentsWithoutZZ, "\n"));
            }
            if (!vatComponentsWithZZ.isEmpty()) {
                parameters.put(KEY_VAT_TCH_SUM, this.vatSumToString(vatComponentsWithZZ, "\n"));
                parameters.put(KEY_VAT_TCH_RATE, this.vatRateToString(vatComponentsWithZZ, "\n"));
                parameters.put(KEY_VAT_TCH_BASIS, this.vatBasisToString(vatComponentsWithZZ, "\n"));
                Airline tch = (Airline)DictionaryCache.get().findByCode(Airline.class, "\u04281");
                if (tch != null) {
                    String tchName = (tch.getLegalForm() != null ? tch.getLegalForm().toString(locale) + " " : "") + "\"" + tch.toString(locale) + "\"";
                    parameters.put(KEY_TCH_NAME, tch.toString(locale));
                    parameters.put(KEY_TCH_OFFICIAL_NAME, tchName);
                    parameters.put(KEY_TCH_REGISTRATION_ID, tch.getRegistrationId());
                    parameters.put(KEY_TCH_KPP, tch.getKpp());
                }
            }
        }
        StringBuilder informationNotesValue = new StringBuilder();
        for (InformationNote note : notes) {
            String informationNoteValue = RefundReceiptRender.getInformationNoteValue(note, locale, false);
            if (TextUtil.isBlank((String)informationNoteValue)) continue;
            if (informationNotesValue.length() > 0) {
                informationNotesValue.append("\n\n");
            }
            informationNotesValue.append(informationNoteValue.trim());
        }
        parameters.put(KEY_INFORMATION_NOTES, informationNotesValue.length() > 0 ? informationNotesValue.toString() : null);
        String route = AirProductHelper.getRouteLine(product);
        parameters.put(KEY_ITINERARY, route);
        return parameters;
    }

    private static String hidePassport(String passportNumber) {
        String safePassportNumber = null;
        if (TextUtil.nonBlank((String)passportNumber)) {
            StringBuilder str = new StringBuilder();
            if (passportNumber.length() > 4) {
                for (int i = 0; i < passportNumber.length() - 4; ++i) {
                    str.append("*");
                }
                str.append(passportNumber, passportNumber.length() - 4, passportNumber.length());
            }
            safePassportNumber = TextUtil.nonBlank((String)str.toString()) ? str.toString() : passportNumber;
        }
        return safePassportNumber;
    }

    private String getPreviousCN(Product product) {
        if (product.getPreviousProduct() == null) {
            return null;
        }
        Product previousProduct = product.getPreviousProduct();
        if (previousProduct.getPreviousProduct() == null) {
            return null;
        }
        return previousProduct.getPreviousProduct().getCarrierNumber();
    }

    private String getPreviousSN(Product product) {
        if (product.getPreviousProduct() == null) {
            return null;
        }
        Product previousProduct = product.getPreviousProduct();
        if (previousProduct.getPreviousProduct() == null) {
            return null;
        }
        return previousProduct.getPreviousProduct().getSystemNumber();
    }

    private String getPaymentsEquivalentAmountParamater(List<PaymentInfo> paymentInfos, boolean itTariff, boolean usePayer, Locale locale) {
        LinkedHashMap payers = new LinkedHashMap();
        for (PaymentInfo paymentInfo : paymentInfos) {
            for (ProductFop fop : paymentInfo.getFops()) {
                TreeMap<String, BigDecimal> currencyCodes;
                TreeMap paymentTypes;
                EntityContainer payerContainer;
                if (fop.getAmount() == null || fop.getAmount().getValue() == null) continue;
                Organization payer = null;
                if (usePayer && (payerContainer = EntityStorage.get().resolve(fop.getPayer())) != null && !TextUtil.isSame((String)((Organization)payerContainer.getEntity()).getCode(), (String)DictHelper.getPreferenceValue(PreferenceKey.RETAIL_PROFILE_CODE, null))) {
                    payer = (Organization)payerContainer.getEntity();
                }
                if ((paymentTypes = (TreeMap)payers.get(payer)) == null) {
                    paymentTypes = new TreeMap();
                    payers.put(payer, paymentTypes);
                }
                if ((currencyCodes = (TreeMap<String, BigDecimal>)paymentTypes.get(fop.getType())) == null) {
                    currencyCodes = new TreeMap<String, BigDecimal>();
                    paymentTypes.put(fop.getType(), currencyCodes);
                }
                BigDecimal amount = fop.getAmount().getValue();
                if (paymentInfo.getFeeType() != null) {
                    for (Commission commission : fop.getCommissions()) {
                        if (commission.getEquivalentAmount() == null) continue;
                        if (paymentInfo.getFeeType() == FeesType.FEES_TO_REFUND) {
                            if (commission.getEquivalentAmount().compareTo(BigDecimal.ZERO) >= 0) continue;
                            amount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{amount, MiscUtil.negate((BigDecimal)commission.getEquivalentAmount())});
                            continue;
                        }
                        if (paymentInfo.getFeeType() != FeesType.FEES_OF_REFUND || commission.getEquivalentAmount().compareTo(BigDecimal.ZERO) < 0) continue;
                        amount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{amount, MiscUtil.negate((BigDecimal)commission.getEquivalentAmount())});
                    }
                }
                String currencyCode = fop.getAmount().getCurrency() != null ? fop.getAmount().getCurrency() : null;
                currencyCodes.put(currencyCode, MiscUtil.sum((BigDecimal[])new BigDecimal[]{(BigDecimal)currencyCodes.get(currencyCode), paymentInfo.isNegate() ? MiscUtil.negate((BigDecimal)amount) : amount}));
            }
        }
        StringBuilder paymentsEquivalentAmount = new StringBuilder();
        for (Map.Entry payerEntry : payers.entrySet()) {
            Organization payer = (Organization)payerEntry.getKey();
            Map paymentTypes = (Map)payerEntry.getValue();
            for (Map.Entry paymentTypeEntry : paymentTypes.entrySet()) {
                PaymentType paymentType = (PaymentType)paymentTypeEntry.getKey();
                Map currencyCodes = (Map)paymentTypeEntry.getValue();
                for (Map.Entry currencyCodeEntry : currencyCodes.entrySet()) {
                    Map<String, String> currencyNames;
                    Map<PaymentType, String> paymentTypeNames;
                    String currencyCode = (String)currencyCodeEntry.getKey();
                    BigDecimal amount = (BigDecimal)currencyCodeEntry.getValue();
                    String paymentTypeString = null;
                    String currencyString = null;
                    String payerString = null;
                    if (paymentType != null && (paymentTypeNames = localizedPaymentTypeNames.get(locale)) != null) {
                        paymentTypeString = paymentTypeNames.get(paymentType);
                    }
                    if (currencyCode != null && (currencyNames = localizedCurrencyNames.get(locale)) != null) {
                        currencyString = currencyNames.get(currencyCode);
                    }
                    if (payer != null) {
                        LegalForm legalForm = (LegalForm)DictionaryCache.get().resolveReference(payer.getLegalForm());
                        String string = payerString = legalForm != null ? String.format("%s %s", DictHelper.getValueByLocale(legalForm.getAbbreviations(), locale), L10nStringHelper.getValue((L10nString)payer.getFullName(), (Locale)locale, (boolean)true)) : L10nStringHelper.getValue((L10nString)payer.getFullName(), (Locale)locale, (boolean)true);
                    }
                    if (paymentsEquivalentAmount.length() > 0) {
                        paymentsEquivalentAmount.append(" / ");
                    }
                    paymentsEquivalentAmount.append(String.format("%s - %s%s", paymentTypeString != null ? paymentTypeString : "", itTariff ? "IT" : String.format(locale, "%.2f", amount), currencyString != null ? currencyString : ""));
                    if (payerString == null) continue;
                    paymentsEquivalentAmount.append(String.format(" - %s", payerString));
                }
            }
        }
        return paymentsEquivalentAmount.length() > 0 ? paymentsEquivalentAmount.toString() : null;
    }

    private static String getInformationNoteValue(InformationNote note, Locale locale, boolean strict) {
        String value = (String)MiscUtil.findByLocale((Map)note.getNotes(), (Locale)locale);
        if (strict || value != null) {
            return value;
        }
        if (!MiscUtil.equals((Object)locale, (Object)LocaleHelper.EN_LOCALE)) {
            value = (String)MiscUtil.findByLocale((Map)note.getNotes(), (Locale)LocaleHelper.EN_LOCALE);
        }
        if (value != null) {
            return value;
        }
        return note.getNotes().size() > 0 ? (String)note.getNotes().values().iterator().next() : null;
    }

    private JRDataSource getDataSource(Product product, Locale locale, List<InformationNote> notes, boolean itTariff, boolean useCyrillicName, boolean usePayer, boolean useVat, boolean showTaxesSum, boolean useVatDetalization, boolean hidePassport) {
        ArrayList data = new ArrayList();
        for (SegmentTariff segmentTariff : product.getSegmentTariffs()) {
            for (Segment segment : segmentTariff.getSegments()) {
                DictionaryReference operatingCarrier;
                String departureTerminalString;
                HashMap<String, Object> record = new HashMap<String, Object>();
                record.put(FIELD_DEPARTURE_DATE, segment.getStartDate());
                GeoLocation departureLocation = (GeoLocation)DictionaryCache.get().resolveReference(segment.getDepartureLocation());
                if (departureLocation != null) {
                    GeoLocation departureCity;
                    String departureCityString = departureLocation.toString(locale);
                    String departureCityEnString = departureLocation.toString(LocaleHelper.getLocale((String)"EN"));
                    String departureAirportString = departureLocation.toString(locale);
                    if (departureLocation.getType() == LocationType.AIRPORT && (departureCity = DictHelper.findCity(departureLocation)) != null) {
                        departureCityString = departureCity.toString(locale);
                        departureCityEnString = departureCity.toString(LocaleHelper.getLocale((String)"EN"));
                    }
                    record.put(FIELD_DEPARTURE_CITY, departureCityString);
                    record.put(FIELD_DEPARTURE_CITY_EN, departureCityEnString);
                    if (!TextUtil.isSame((String)departureCityString, (String)departureAirportString)) {
                        record.put(FIELD_DEPARTURE_AIRPORT, departureAirportString);
                    }
                    record.put(FIELD_DEPARTURE_AIRPORT_TUI, departureAirportString);
                }
                if ((departureTerminalString = MiscUtil.translateTerminal((String)segment.getDepartTerminal(), (Locale)locale)) != null) {
                    boolean find = false;
                    for (String terminalKey : terminalKeys) {
                        if (!departureTerminalString.toLowerCase().contains(terminalKey.toLowerCase())) continue;
                        find = true;
                        break;
                    }
                    if (!find && localizedTerminalEntries.get(locale) != null) {
                        departureTerminalString = String.format("%s %s", localizedTerminalEntries.get(locale), departureTerminalString);
                    }
                }
                record.put(FIELD_DEPARTURE_TERMINAL, departureTerminalString);
                record.put(FIELD_ARRIVE_DATE, segment.getEndDate());
                GeoLocation arriveLocation = (GeoLocation)DictionaryCache.get().resolveReference(segment.getArriveLocation());
                if (arriveLocation != null) {
                    GeoLocation arriveCity;
                    String arriveCityString = arriveLocation.toString(locale);
                    String arriveCityEnString = arriveLocation.toString(LocaleHelper.getLocale((String)"EN"));
                    String arriveAirportString = arriveLocation.toString(locale);
                    if (arriveLocation.getType() == LocationType.AIRPORT && (arriveCity = DictHelper.findCity(arriveLocation)) != null) {
                        arriveCityString = arriveCity.toString(locale);
                        arriveCityEnString = arriveCity.toString(LocaleHelper.getLocale((String)"EN"));
                    }
                    record.put(FIELD_ARRIVE_CITY, arriveCityString);
                    record.put(FIELD_ARRIVE_CITY_EN, arriveCityEnString);
                    if (!TextUtil.isSame((String)arriveCityString, (String)arriveAirportString)) {
                        record.put(FIELD_ARRIVE_AIRPORT, arriveAirportString);
                    }
                    record.put(FIELD_ARRIVE_AIRPORT_TUI, arriveAirportString);
                }
                record.put(MEAL, segment.getMealServiceIndicator() != null ? segment.getMealServiceIndicator().getCaption() : null);
                record.put(BOARD, segment.getBoard() != null ? segment.getBoard().getCaption() : null);
                record.put(DEPARTURE_AIRPORT_CODE, departureLocation != null ? (Object)departureLocation.getCodeVariants().get(CodeSystem.IATA.name()) : null);
                record.put(ARRIVE_AIRPORT_CODE, arriveLocation != null ? (Object)arriveLocation.getCodeVariants().get(CodeSystem.IATA.name()) : null);
                String arriveTerminalString = MiscUtil.translateTerminal((String)segment.getArriveTerminal(), (Locale)locale);
                if (arriveTerminalString != null) {
                    boolean find = false;
                    for (String terminalKey : terminalKeys) {
                        if (!arriveTerminalString.toLowerCase().contains(terminalKey.toLowerCase())) continue;
                        find = true;
                        break;
                    }
                    if (!find && localizedTerminalEntries.get(locale) != null) {
                        arriveTerminalString = String.format("%s %s", localizedTerminalEntries.get(locale), arriveTerminalString);
                    }
                }
                record.put(FIELD_ARRIVE_TERMINAL, arriveTerminalString);
                DictionaryReference marketingCarrier = segment.getAirline();
                if (marketingCarrier != null) {
                    record.put(FIELD_MARKETING_CARRIER_NAME, marketingCarrier.toString(locale));
                    String marketingCarrierCode = null;
                    Airline marketingAirline = (Airline)DictionaryCache.get().resolveReference(marketingCarrier);
                    if (marketingAirline != null && (marketingCarrierCode = DictHelper.getCodeVariant((BaseDictionary)marketingAirline, Arrays.asList(CodeSystem.IATA, CodeSystem.CRT))) == null && marketingAirline.getCodeVariants().size() > 0) {
                        marketingCarrierCode = (String)marketingAirline.getCodeVariants().values().iterator().next();
                    }
                    if (marketingCarrierCode == null) {
                        marketingCarrierCode = marketingCarrier.getCode();
                    }
                    record.put(FIELD_MARKETING_CARRIER_CODE, marketingCarrierCode);
                }
                if ((operatingCarrier = segment.getCodeShareCarrier()) != null) {
                    record.put(FIELD_OPERATING_CARRIER_NAME, operatingCarrier.toString(locale));
                    String operatingCarrierCode = null;
                    Airline operatingAirline = (Airline)DictionaryCache.get().resolveReference(operatingCarrier);
                    if (operatingAirline != null && (operatingCarrierCode = DictHelper.getCodeVariant((BaseDictionary)operatingAirline, Arrays.asList(CodeSystem.IATA, CodeSystem.CRT))) == null && operatingAirline.getCodeVariants().size() > 0) {
                        operatingCarrierCode = (String)operatingAirline.getCodeVariants().values().iterator().next();
                    }
                    if (operatingCarrierCode == null) {
                        operatingCarrierCode = operatingCarrier.getCode();
                    }
                    record.put(FIELD_OPERATING_CARRIER_CODE, operatingCarrierCode);
                }
                record.put(FIELD_FLIGHT_NUMBER, segment.getFlightNo());
                record.put(FIELD_AIRLINE_LOCATOR, segment.getAirlineLocator());
                String serviceClassCode = segment.getClassOfSvcCode();
                if (!TextUtil.isBlank((String)serviceClassCode)) {
                    ClassOfService classOfService = DictHelper.findClassOfService(segment, product.getIssueDate());
                    record.put(FIELD_SERVICE_CLASS, String.format("%s (%s)", classOfService != null ? LocaleHelper.toString((Object)classOfService, (Locale)locale) : "", serviceClassCode.trim()));
                    record.put(FIELD_SERVICE_CLASS_CODE, serviceClassCode);
                }
                record.put(FIELD_SEAT_NUMBER, !TextUtil.isBlank((String)segment.getSeatNo()) ? segment.getSeatNo().trim() : null);
                record.put(FIELD_BAGGAGE_ALLOWANCE, ItineraryReceiptHelper.luggageInfoToString(segment, locale));
                Optional.ofNullable(segment.getFareDetails()).map(FareDetails::getCabinLuggageInfo).ifPresent(cabinLuggageInfo -> record.put(FIELD_CABIN_LUGGAGE_INFO, ItineraryReceiptHelper.extendedLuggageInfoToString(cabinLuggageInfo, locale)));
                record.put(FIELD_FARE_BASIS, segment.getFareBasis());
                record.put(FIELD_NOT_VALID_BEFORE_DATE, segment.getNotValidBefore());
                record.put(FIELD_NOT_VALID_AFTER_DATE, segment.getNotValidAfter());
                record.put(FIELD_DEPARTURE_CITY_TUI, this.getCityNameTui(departureLocation, locale));
                record.put(FIELD_ARRIVE_CITY_TUI, this.getCityNameTui(arriveLocation, locale));
                data.add(record);
            }
        }
        if (data.isEmpty()) {
            data.add(new HashMap());
        }
        return new JRMapCollectionDataSource(data);
    }

    private static List<EntityContainer<SalesPoint>> getSalesPointsByValidatorAndPcc(String validator, String pcc) throws Exception {
        SearchQuery query = RefundReceiptRender.createQueryPccValidator(pcc, validator, null);
        return EntityStorage.get().search(SalesPointIndex.class, query).getData().stream().map(spi -> EntityStorage.get().resolve(spi.getSource())).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static SearchQuery createQueryPccValidator(String pcc, String validator, String terminal) {
        SearchQuery query = new SearchQuery();
        if (!TextUtil.isBlank((String)pcc)) {
            query.getCriteria().getCriterions().add(SearchCriterion.icontains((String)SalesPointIndex.Property.pccs.name(), (String)pcc));
        }
        if (!TextUtil.isBlank((String)validator)) {
            query.getCriteria().getCriterions().add(SearchCriterion.contains((String)SalesPointIndex.Property.validators.name(), (Object)validator));
        }
        if (!TextUtil.isBlank((String)terminal)) {
            query.getCriteria().getCriterions().add(SearchCriterion.contains((String)SalesPointIndex.Property.terminals.name(), (Object)terminal));
        }
        return query;
    }

    private Locale getLocale(TemplateDocument templateDocument) {
        String language = SystemHelper.findMetadataAsString(templateDocument.getMetadata(), MetadataKey.KEY_LOCALE);
        if (!TextUtil.isBlank((String)language)) {
            return LocaleHelper.getLocale((String)language);
        }
        return LocaleHelper.getCurrentLocale();
    }

    private String getFileName(Product product, TemplateDocument templateDocument) {
        return this.getReportTitle(product, templateDocument) + ".pdf";
    }

    private String getReportTitle(Product product, TemplateDocument templateDocument) {
        StringBuilder reportTitle = new StringBuilder();
        reportTitle.append(templateDocument.getTitle()).append(" ").append(product.getSystemNumber()).append(" ").append(product.getTraveller().getName()).append(" (").append(new SimpleDateFormat("yyyyMMdd_HHmm").format(new Date())).append(")");
        return reportTitle.toString();
    }

    private String getCityNameTui(GeoLocation firstLocation, Locale locale) {
        StringBuilder result = new StringBuilder();
        if (firstLocation == null) {
            return null;
        }
        GeoLocation location = (GeoLocation)DictionaryCache.get().resolveReference(firstLocation.getParent());
        if (location == null) {
            location = firstLocation;
        }
        if (location.getTranslations().isEmpty()) {
            return null;
        }
        Map translations = location.getTranslations();
        result.append(translations.get(locale) != null ? (String)translations.get(locale) : translations.values().stream().findFirst().orElse(""));
        if (!firstLocation.getCodeVariants().isEmpty()) {
            Map codeVariants = firstLocation.getCodeVariants();
            result.append(", ").append(codeVariants.get(CodeSystem.IATA.name()) != null ? (String)codeVariants.get(CodeSystem.IATA.name()) : (codeVariants.get(CodeSystem.CRT.name()) != null ? (String)codeVariants.get(CodeSystem.CRT.name()) : codeVariants.values().stream().findFirst().orElse("")));
        }
        return TextUtil.nonBlank((String)result.toString()) ? result.toString() : null;
    }

    private String getTravellerName(Traveller traveller, Locale locale, boolean useCyrillicName) {
        Person entity;
        EntityContainer person = EntityStorage.get().resolve(traveller.getPassenger());
        if (person != null && (entity = (Person)person.getEntity()) != null) {
            String lastName = entity.getLastName() != null ? (String)entity.getLastName().getValues().get(locale) : null;
            String firstName = entity.getFirstName() != null ? (String)entity.getFirstName().getValues().get(locale) : null;
            String middleName = entity.getMiddleName() != null ? (String)entity.getMiddleName().getValues().get(locale) : null;
            return (lastName != null ? lastName : "") + (firstName != null ? (lastName != null ? " " + firstName : firstName) : "") + (middleName != null ? (lastName != null || firstName != null ? " " + middleName : middleName) : "");
        }
        String result = useCyrillicName ? (traveller.getCyrillicName() != null ? traveller.getCyrillicName() : traveller.getName()) : traveller.getName();
        return result;
    }

    private String buildPhoneString(List<Communication> communications, List<CommunicationType> communicationTypes, Locale locale) {
        for (CommunicationType communicationType : communicationTypes) {
            for (Communication communication : ProfileHelper.filterCommunications(communications, Collections.singleton(communicationType))) {
                String phoneString = ProfileHelper.buildFullPhoneNumber(communication);
                if (TextUtil.isBlank((String)phoneString)) continue;
                return phoneString.trim();
            }
        }
        return null;
    }

    private String getFullAddress(Address a, Locale locale) {
        StringBuilder result = new StringBuilder();
        if (TextUtil.nonBlank((String)a.getZip())) {
            result.append(a.getZip());
        }
        if (a.getCity() != null && TextUtil.nonBlank((String)a.getCity().getCaption())) {
            result.append(", ").append(a.getCity().getCaption());
        }
        if (a.getAddress() != null && !a.getAddress().getValues().isEmpty()) {
            String address = (String)a.getAddress().getValues().get(locale);
            if (TextUtil.isBlank((String)address)) {
                String string = a.getAddress().getValues().values().stream().filter(Objects::nonNull).findFirst().orElse(null);
            }
            if (TextUtil.nonBlank((String)address)) {
                result.append(", ").append(address);
            }
        }
        return result.toString();
    }

    private BigDecimal getTaxAndFee(Product product) {
        BigDecimal result = BigDecimal.ZERO;
        if (!product.getTaxes().isEmpty()) {
            for (Tax tax : product.getTaxes()) {
                result = MiscUtil.sum((BigDecimal[])new BigDecimal[]{result, tax.getEquivalentAmount()});
            }
        }
        if (!product.getObFees().isEmpty()) {
            for (OBFee fee : product.getObFees()) {
                result = MiscUtil.sum((BigDecimal[])new BigDecimal[]{result, fee.getAmount().getValue()});
            }
        }
        return result;
    }

    private PaymentType getPaymentType(Collection<ProductFop> fops) {
        for (ProductFop fop : fops) {
            if (fop.getAmount() == null || fop.getAmount().getValue() == null) continue;
            return fop.getType();
        }
        return null;
    }

    private String vatSumToString(List<VatComponent> vatComponents, String delimiter) {
        return TextUtil.nullOrNonBlankString((String)vatComponents.stream().filter(Objects::nonNull).filter(c -> c.getRate() != null).map(comp -> GeneralProductHelper.getNonNullString(comp.getSum())).collect(Collectors.joining(delimiter)));
    }

    private String vatRateToString(List<VatComponent> vatComponents, String delimiter) {
        return TextUtil.nullOrNonBlankString((String)vatComponents.stream().filter(Objects::nonNull).filter(c -> c.getRate() != null).map(comp -> comp.getRate() + "%").collect(Collectors.joining(delimiter)));
    }

    private String vatBasisToString(List<VatComponent> vatComponents, String delimiter) {
        return TextUtil.nullOrNonBlankString((String)vatComponents.stream().filter(Objects::nonNull).filter(c -> c.getRate() != null).map(comp -> GeneralProductHelper.getNonNullString(comp.getBasis())).collect(Collectors.joining(delimiter)));
    }

    static {
        Locale enLocale = LocaleHelper.getLocale((String)"EN");
        HashMap<PaymentType, String> enPaymentTypeNames = new HashMap<PaymentType, String>();
        enPaymentTypeNames.put(PaymentType.CASH, "cash");
        enPaymentTypeNames.put(PaymentType.INVOICE, "invoice");
        enPaymentTypeNames.put(PaymentType.CREDIT_CARD, "credit card");
        enPaymentTypeNames.put(PaymentType.CREDIT_CARD_AGENCY, "credit card");
        enPaymentTypeNames.put(PaymentType.CREDIT_CARD_TCH, "credit card");
        enPaymentTypeNames.put(PaymentType.CREDIT, "credit card");
        enPaymentTypeNames.put(PaymentType.MTD, "mtd");
        enPaymentTypeNames.put(PaymentType.TICKET, "ticket");
        localizedPaymentTypeNames.put(enLocale, enPaymentTypeNames);
        HashMap<String, String> enCurrencyNames = new HashMap<String, String>();
        enCurrencyNames.put("USD", "usd");
        enCurrencyNames.put("EUR", "eur");
        enCurrencyNames.put("RUB", "rub");
        enCurrencyNames.put("AZN", "man");
        enCurrencyNames.put("KZT", "KZT");
        localizedCurrencyNames.put(enLocale, enCurrencyNames);
        localizedTerminalEntries.put(enLocale, "Terminal");
        Locale ruLocale = LocaleHelper.getLocale((String)"RU");
        HashMap<PaymentType, String> ruPaymentTypeNames = new HashMap<PaymentType, String>();
        ruPaymentTypeNames.put(PaymentType.CASH, "\u043d\u0430\u043b\u0438\u0447\u043d\u044b\u0435");
        ruPaymentTypeNames.put(PaymentType.INVOICE, "\u043f\u043b\u0430\u0442\u0435\u0436\u043d\u043e\u0435 \u043f\u043e\u0440\u0443\u0447\u0435\u043d\u0438\u0435");
        ruPaymentTypeNames.put(PaymentType.CREDIT_CARD, "\u043f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u043a\u0430\u0440\u0442\u0430");
        ruPaymentTypeNames.put(PaymentType.CREDIT_CARD_AGENCY, "\u043f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u043a\u0430\u0440\u0442\u0430");
        ruPaymentTypeNames.put(PaymentType.CREDIT_CARD_TCH, "\u043f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u043a\u0430\u0440\u0442\u0430");
        ruPaymentTypeNames.put(PaymentType.CREDIT, "\u043a\u0440");
        ruPaymentTypeNames.put(PaymentType.MTD, "\u0432\u043f\u0434");
        ruPaymentTypeNames.put(PaymentType.TICKET, "\u0431\u0438\u043b\u0435\u0442");
        localizedPaymentTypeNames.put(ruLocale, ruPaymentTypeNames);
        HashMap<String, String> ruCurrencyNames = new HashMap<String, String>();
        ruCurrencyNames.put("USD", "\u0434\u043e\u043b");
        ruCurrencyNames.put("EUR", "\u0435\u0432\u0440");
        ruCurrencyNames.put("RUB", "\u0440\u0443\u0431");
        ruCurrencyNames.put("AZN", "\u043c\u0430\u043d");
        ruCurrencyNames.put("KZT", "KZT");
        localizedCurrencyNames.put(ruLocale, ruCurrencyNames);
        localizedTerminalEntries.put(ruLocale, "\u0422\u0435\u0440\u043c\u0438\u043d\u0430\u043b");
        Locale azLocale = LocaleHelper.getLocale((String)"AZ");
        HashMap<PaymentType, String> azPaymentTypeNames = new HashMap<PaymentType, String>();
        azPaymentTypeNames.put(PaymentType.CASH, "na\u011fd");
        azPaymentTypeNames.put(PaymentType.INVOICE, "i\u0307nvoi\u0307ce");
        azPaymentTypeNames.put(PaymentType.CREDIT_CARD, "kredit karti");
        azPaymentTypeNames.put(PaymentType.CREDIT_CARD_AGENCY, "kredit karti");
        azPaymentTypeNames.put(PaymentType.CREDIT_CARD_TCH, "kredit karti");
        azPaymentTypeNames.put(PaymentType.CREDIT, "kredit karti");
        azPaymentTypeNames.put(PaymentType.MTD, "mtd");
        azPaymentTypeNames.put(PaymentType.TICKET, "bilet");
        localizedPaymentTypeNames.put(azLocale, azPaymentTypeNames);
        HashMap<String, String> azCurrencyNames = new HashMap<String, String>();
        azCurrencyNames.put("USD", "dol");
        azCurrencyNames.put("EUR", "evr");
        azCurrencyNames.put("RUB", "rub");
        azCurrencyNames.put("AZN", "man");
        azCurrencyNames.put("KZT", "KZT");
        localizedCurrencyNames.put(azLocale, azCurrencyNames);
        localizedTerminalEntries.put(azLocale, "Terminal");
        Locale kaLocale = LocaleHelper.getLocale((String)"KA");
        HashMap<PaymentType, String> kaPaymentTypeNames = new HashMap<PaymentType, String>();
        kaPaymentTypeNames.put(PaymentType.CASH, "\u10dc\u10d0\u10e6\u10d3\u10d8");
        kaPaymentTypeNames.put(PaymentType.INVOICE, "\u10e1\u10d0\u10d2\u10d0\u10d3\u10d0\u10ee\u10d3\u10dd \u10d3\u10d0\u10d5\u10d0\u10da\u10d4\u10d1\u10d0");
        kaPaymentTypeNames.put(PaymentType.CREDIT_CARD, "\u10de\u10da\u10d0\u10e1\u10e2\u10d8\u10d9\u10e3\u10e0\u10d8 \u10d1\u10d0\u10e0\u10d0\u10d7\u10d8");
        kaPaymentTypeNames.put(PaymentType.CREDIT_CARD_AGENCY, "\u10de\u10da\u10d0\u10e1\u10e2\u10d8\u10d9\u10e3\u10e0\u10d8 \u10d1\u10d0\u10e0\u10d0\u10d7\u10d8");
        kaPaymentTypeNames.put(PaymentType.CREDIT_CARD_TCH, "\u10de\u10da\u10d0\u10e1\u10e2\u10d8\u10d9\u10e3\u10e0\u10d8 \u10d1\u10d0\u10e0\u10d0\u10d7\u10d8");
        kaPaymentTypeNames.put(PaymentType.CREDIT, "\u10de\u10da\u10d0\u10e1\u10e2\u10d8\u10d9\u10e3\u10e0\u10d8 \u10d1\u10d0\u10e0\u10d0\u10d7\u10d8");
        kaPaymentTypeNames.put(PaymentType.MTD, "mtd");
        kaPaymentTypeNames.put(PaymentType.TICKET, "\u10d1\u10d8\u10da\u10d4\u10d7\u10d8");
        localizedPaymentTypeNames.put(kaLocale, kaPaymentTypeNames);
        HashMap<String, String> kaCurrencyNames = new HashMap<String, String>();
        kaCurrencyNames.put("USD", "\u10d3\u10dd\u10da");
        kaCurrencyNames.put("EUR", "\u10d4\u10d5\u10e0");
        kaCurrencyNames.put("RUB", "\u10e0\u10e3\u10d1");
        kaCurrencyNames.put("GEL", "\u10da\u10d0\u10e0\u10d8");
        kaCurrencyNames.put("KZT", "KZT");
        localizedCurrencyNames.put(kaLocale, kaCurrencyNames);
        localizedTerminalEntries.put(kaLocale, "Terminal");
    }

    private static enum FeesType {
        FEES_TO_REFUND,
        FEES_OF_REFUND;

    }

    private static class PaymentInfo {
        private final Collection<ProductFop> fops = new ArrayList<ProductFop>();
        private final FeesType feeType;
        private final boolean negate;

        public static PaymentInfo of(Collection<ProductFop> fops, FeesType feeType, boolean negate) {
            return new PaymentInfo(fops, feeType, negate);
        }

        private PaymentInfo(Collection<ProductFop> fops, FeesType feeType, boolean negate) {
            this.getFops().clear();
            this.getFops().addAll(fops);
            this.feeType = feeType;
            this.negate = negate;
        }

        public Collection<ProductFop> getFops() {
            return this.fops;
        }

        public FeesType getFeeType() {
            return this.feeType;
        }

        public boolean isNegate() {
            return this.negate;
        }
    }
}

