/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.validation;

import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.ValidationMessageSeverity;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.validation.ValidationMessageType;
import java.util.HashMap;

public enum PassiveSegmentsValidationMessageType implements ValidationMessageType
{
    SPS_DEVELOPER_ERROR(ValidationMessageSeverity.MESSAGE, Messages.sabrePassiveSegmentsDeveloperError, 1, Messages.sabrePassiveSegmentsDeveloperErrorDetails),
    SPS_HOTEL_ROOM_TYPE_NOT_FOUND(ValidationMessageSeverity.ERROR, Messages.sabrePassiveSegmentsHotelRoomTypeNotFoundError, 2, Messages.sabrePassiveSegmentsHotelRoomTypeNotFoundErrorDetails),
    SPS_HOTEL_MEAL_NOT_FOUND(ValidationMessageSeverity.ERROR, Messages.sabrePassiveSegmentsHotelMealNotFoundError, 3, Messages.sabrePassiveSegmentsHotelMealNotFoundErrorDetails),
    SPS_SEGMENT_CREATION_COMMAND_LENGTH(ValidationMessageSeverity.ERROR, Messages.sabrePassiveSegmentsHotelSegmentCreationCommandLengthError, 4, Messages.sabrePassiveSegmentsHotelSegmentCreationCommandLengthErrorDetails),
    SPS_TRAVELLER_SURNAME_NOT_FOUND(ValidationMessageSeverity.ERROR, Messages.sabrePassiveSegmentsTravellerSurnameNotFoundError, 5, Messages.sabrePassiveSegmentsTravellerSurnameNotFoundErrorDetails),
    SPS_BROKEN_TRAVELLER_PROFILE_LINK(ValidationMessageSeverity.ERROR, Messages.sabrePassiveSegmentsBrokenTravellerProfileRefError, 6, Messages.sabrePassiveSegmentsBrokenTravellerProfileRefErrorDetails),
    SPS_AGENCY_PHONE_NOT_FOUND(ValidationMessageSeverity.ERROR, Messages.sabrePassiveSegmentsAgencyPhoneNotFoundError, 7),
    SPS_BROKEN_HOTEL_LOCATION_LINK(ValidationMessageSeverity.ERROR, Messages.sabrePassiveSegmentsBrokenHotelLocationRefError, 8, Messages.sabrePassiveSegmentsBrokenHotelLocationRefErrorDetails),
    SPS_EMPTY_PRODUCT(ValidationMessageSeverity.ERROR, Messages.sabrePassiveSegmentsValidationEmptyProduct, 9),
    SPS_INVALID_PRODUCT_STATUS(ValidationMessageSeverity.MESSAGE, Messages.sabrePassiveSegmentsValidationInvalidProductStatus, 10, Messages.sabrePassiveSegmentsValidationInvalidProductStatusDetails),
    SPS_EMPTY_RESERVATION(ValidationMessageSeverity.ERROR, Messages.sabrePassiveSegmentsValidationEmptyReservation, 11, Messages.sabrePassiveSegmentsValidationEmptyReservationDetails),
    SPS_SABRE_PRODUCT(ValidationMessageSeverity.MESSAGE, Messages.sabrePassiveSegmentsValidationSabreGds, 12, Messages.sabrePassiveSegmentsValidationSabreGdsDetails),
    SPS_EMPTY_HOTEL_LOCATION(ValidationMessageSeverity.ERROR, Messages.sabrePassiveSegmentsValidationEmptyHotelLocation, 13, Messages.sabrePassiveSegmentsValidationEmptyHotelLocationDetails),
    SPS_HAS_NEXT_PRODUCT(ValidationMessageSeverity.MESSAGE, Messages.sabrePassiveSegmentsValidationHasNextProduct, 14, Messages.sabrePassiveSegmentsValidationHasNextProductDetails),
    SPS_EMPTY_TRAVELLERS(ValidationMessageSeverity.ERROR, Messages.sabrePassiveSegmentsValidationEmptyTravellers, 15, Messages.sabrePassiveSegmentsValidationEmptyTravellersDetails),
    SPS_EMPTY_HOTEL_ROOMS(ValidationMessageSeverity.ERROR, Messages.sabrePassiveSegmentsValidationEmptyHotelRooms, 16, Messages.sabrePassiveSegmentsValidationEmptyHotelRoomsDetails),
    SPS_EMPTY_CHECK_IN_DATE(ValidationMessageSeverity.ERROR, Messages.sabrePassiveSegmentsValidationEmptyCheckInDate, 17, Messages.sabrePassiveSegmentsValidationEmptyCheckInDateDetails),
    SPS_EMPTY_CHECK_OUT_DATE(ValidationMessageSeverity.ERROR, Messages.sabrePassiveSegmentsValidationEmptyCheckOutDate, 18, Messages.sabrePassiveSegmentsValidationEmptyCheckOutDateDetails),
    SPS_CHECK_IN_DATE_BEFORE_CURRENT_DATE(ValidationMessageSeverity.MESSAGE, Messages.sabrePassiveSegmentsValidationCheckInDateIsBeforeCurrentDate, 19, Messages.sabrePassiveSegmentsValidationCheckInDateIsBeforeCurrentDateDetails),
    SPS_INVALID_PRODUCT_CATEGORY(ValidationMessageSeverity.MESSAGE, Messages.sabrePassiveSegmentsValidationInvalidProductCategory, 20, Messages.sabrePassiveSegmentsValidationInvalidProductCategoryDetails),
    SPS_EMPTY_SEGMENTS(ValidationMessageSeverity.ERROR, Messages.sabrePassiveSegmentsValidationEmptySegments, 21, Messages.sabrePassiveSegmentsValidationEmptySegmentsDetails),
    SPS_EMPTY_START_DATE(ValidationMessageSeverity.ERROR, Messages.sabrePassiveSegmentsValidationEmptyStartDate, 22, Messages.sabrePassiveSegmentsValidationEmptyStartDateDetails),
    SPS_START_DATE_BEFORE_CURRENT_DATE(ValidationMessageSeverity.MESSAGE, Messages.sabrePassiveSegmentsValidationStartDateIsBeforeCurrentDate, 23, Messages.sabrePassiveSegmentsValidationStartDateIsBeforeCurrentDateDetails),
    SPS_ZERO_PASSENGERS(ValidationMessageSeverity.ERROR, Messages.sabrePassiveSegmentsZeroPassengers, 24),
    SPS_EMPTY_FLIGHT_NO(ValidationMessageSeverity.ERROR, Messages.sabrePassiveSegmentsValidationEmptyFlightNo, 25, Messages.sabrePassiveSegmentsValidationEmptyFlightNoDetails),
    SPS_EMPTY_DEPARTURE_LOCATION(ValidationMessageSeverity.ERROR, Messages.sabrePassiveSegmentsValidationEmptyDepartureLocation, 26, Messages.sabrePassiveSegmentsValidationEmptyDepartureLocationDetails),
    SPS_EMPTY_DEPARTURE_LOCATION_IATA_CODE(ValidationMessageSeverity.ERROR, Messages.sabrePassiveSegmentsValidationEmptyDepartureLocationIATACode, 27, Messages.sabrePassiveSegmentsValidationEmptyDepartureLocationIATACodeDetails),
    SPS_EMPTY_ARRIVAL_LOCATION(ValidationMessageSeverity.ERROR, Messages.sabrePassiveSegmentsValidationEmptyArriveLocation, 28, Messages.sabrePassiveSegmentsValidationEmptyArriveLocationDetails),
    SPS_EMPTY_ARRIVAL_LOCATION_IATA_CODE(ValidationMessageSeverity.ERROR, Messages.sabrePassiveSegmentsValidationEmptyArriveLocationIATACode, 29, Messages.sabrePassiveSegmentsValidationEmptyArriveLocationIATACodeDetails),
    SPS_EMPTY_CLASS_OF_SVC_CODE(ValidationMessageSeverity.ERROR, Messages.sabrePassiveSegmentsValidationEmptyClassOfSvcCode, 30, Messages.sabrePassiveSegmentsValidationEmptyClassOfSvcCodeDetails),
    SPS_EMPTY_AIRLINE(ValidationMessageSeverity.ERROR, Messages.sabrePassiveSegmentsValidationEmptyAirline, 31, Messages.sabrePassiveSegmentsValidationEmptyAirlineDetails),
    SPS_NOT_SINGLE_TRAVELLER(ValidationMessageSeverity.MESSAGE, Messages.sabrePassiveSegmentsValidationNotSingleTraveller, 32, Messages.sabrePassiveSegmentsValidationNotSingleTravellerDetails),
    SPS_NOT_SINGLE_SEGMENT(ValidationMessageSeverity.ERROR, Messages.sabrePassiveSegmentsValidationNotSingleSegment, 33, Messages.sabrePassiveSegmentsValidationNotSingleSegmentDetails),
    SPS_HOTEL_CHECK_IN_DATE_AFTER_CHECK_OUT_DATE(ValidationMessageSeverity.ERROR, Messages.sabrePassiveSegmentsValidationCheckInDateIsAfterCheckOutDate, 34, Messages.sabrePassiveSegmentsValidationCheckInDateIsAfterCheckOutDateDetails),
    SPS_HOTEL_PRODUCT_ZERO_TOTAL_PRICE(ValidationMessageSeverity.ERROR, Messages.sabrePassiveSegmentHotelProductZeroTotalPrice, 35, Messages.sabrePassiveSegmentHotelProductZeroTotalPriceDetails),
    SPS_CONTACT_PHONE_NUMBER_IN_WRONG_FORMAT(ValidationMessageSeverity.ERROR, Messages.sabrePassiveSegmentsContactPhoneNumberInWrongFormat, 36, Messages.sabrePassiveSegmentsContactPhoneNumberInWrongFormatDetails),
    SPS_SABRE_HOTEL_PROVIDER(ValidationMessageSeverity.MESSAGE, Messages.sabrePassiveSegmentValidationSabreHotelProvider, 37, Messages.sabrePassiveSegmentValidationSabreHotelProviderDetails);

    private ValidationMessageSeverity defaultSeverity;
    private ValidationMessageCategory category;
    private String messageKey;
    private String details;
    private Integer number;
    private String errorCode;
    private static final String PREFIX = "SPS-";
    private static final HashMap<String, PassiveSegmentsValidationMessageType> data;

    private PassiveSegmentsValidationMessageType(ValidationMessageSeverity defaultSeverity, String messageKey, Integer number, String details) {
        this(defaultSeverity, ValidationMessageCategory.PASSIVE_SEGMENTS, messageKey, details, number, PREFIX + number);
    }

    private PassiveSegmentsValidationMessageType(ValidationMessageSeverity defaultSeverity, String messageKey, Integer number) {
        this(defaultSeverity, messageKey, number, null);
    }

    private PassiveSegmentsValidationMessageType(ValidationMessageSeverity defaultSeverity, ValidationMessageCategory category, String messageKey, String details, Integer number, String errorCode) {
        this.defaultSeverity = defaultSeverity;
        this.category = category;
        this.messageKey = messageKey;
        this.details = details;
        this.number = number;
        this.errorCode = errorCode;
    }

    @Override
    public String getId() {
        return this.name();
    }

    @Override
    public ValidationMessageCategory getCategory() {
        return this.category;
    }

    @Override
    public String getMessageKey() {
        return this.messageKey;
    }

    @Override
    public ValidationMessageSeverity getDefaultSeverity() {
        return this.defaultSeverity;
    }

    public String getDetails() {
        return this.details;
    }

    @Override
    public String getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    @Override
    public Integer getNumber() {
        return this.number;
    }

    public void setSeverity(ValidationMessageSeverity severity) {
        this.defaultSeverity = severity;
    }

    public static PassiveSegmentsValidationMessageType getValidationMessageTypeByKey(String key) {
        return data.get(key);
    }

    static {
        data = new HashMap(PassiveSegmentsValidationMessageType.values().length);
        for (PassiveSegmentsValidationMessageType value : PassiveSegmentsValidationMessageType.values()) {
            String key = value.getDetails() != null ? value.getDetails() : value.getMessageKey();
            data.put(key, value);
        }
    }
}

