/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.pg.helpers;

import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.FopType;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.pg.model.FopInfo;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;

public class CommonPgFopInfoUtil {
    private static final String ID_DELIMETER = "|";

    private CommonPgFopInfoUtil() {
        throw new RuntimeException("don't do this");
    }

    public static FopInfo toInfo(BaseProduct baseProduct, GeneralProductFop generalProductFop) {
        Objects.requireNonNull(baseProduct);
        Objects.requireNonNull(generalProductFop);
        FopType fopType = GeneralProductHelper.getFopType((GeneralProductFop)generalProductFop);
        FopInfo fopInfo = new FopInfo();
        fopInfo.setFopId(CommonPgFopInfoUtil.toId(baseProduct, generalProductFop));
        fopInfo.setFopType(fopType);
        fopInfo.setAmount(generalProductFop.getEquivalentAmount());
        if (FopType.SERVICE == fopType) {
            fopInfo.setFopSupplier(GeneralProductHelper.isSupplierFop((BaseProduct)baseProduct, (GeneralProductFop)generalProductFop));
        }
        return fopInfo;
    }

    public static String toId(BaseProduct baseProduct, GeneralProductFop generalProductFop) {
        Objects.requireNonNull(baseProduct);
        Objects.requireNonNull(generalProductFop);
        ProductHandler productHandler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
        StringJoiner id = new StringJoiner(ID_DELIMETER);
        if (productHandler.isChecked(baseProduct)) {
            id.add("fopUid=" + generalProductFop.getUid());
        } else {
            FopType fopType = GeneralProductHelper.getFopType((GeneralProductFop)generalProductFop);
            id.add("fopType=" + fopType.name());
            if (FopType.SERVICE == fopType) {
                id.add("supplierFop=" + GeneralProductHelper.isSupplierFop((BaseProduct)baseProduct, (GeneralProductFop)generalProductFop));
            }
        }
        return id.toString();
    }

    public static String relatedFopId(FopInfo fopInfo) {
        return Optional.ofNullable(fopInfo).map(FopInfo::getRelated).map(FopInfo::getFopId).orElse(null);
    }

    public static GeneralProductFop toFop(BaseProduct baseProduct, FopInfo fopInfo) {
        Objects.requireNonNull(baseProduct);
        Objects.requireNonNull(fopInfo);
        List clientFops = GeneralProductHelper.getClientFops((BaseProduct)baseProduct);
        return clientFops.stream().filter(fop -> TextUtil.isSame((String)fopInfo.getFopId(), (String)CommonPgFopInfoUtil.toId(baseProduct, fop))).findAny().orElse(null);
    }
}

