/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.railway.handlers;

import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.FinanceDocument;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.GeneralProductTax;
import com.gridnine.xtrip.common.model.booking.MCOFeesSource;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.ProductCancellationDetails;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.ServiceLocationType;
import com.gridnine.xtrip.common.model.booking.ServiceType;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.DiscountProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayCrimeaMco;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductFop;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.PassengerStatus;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.BillingItemIncludeMode;
import com.gridnine.xtrip.common.model.finance.UniversalDocumentStatus;
import com.gridnine.xtrip.common.model.finance.VatViewMode;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Branch;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentsProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.Validator;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayCrimeaMcoHelper;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.railway.model.rules.standart.Targets;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RailwayCrimeaMcoHandler
implements ProductHandler<RailwayCrimeaMco> {
    private static final String SEPARATOR = " ";
    private static final String GROUP_PLACE_HOLDER = "$group_string";
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public Class<RailwayCrimeaMco> getProductClass() {
        return RailwayCrimeaMco.class;
    }

    public VatAmount calculateProductPrice(GeneralProductContractRelationData relation, RailwayCrimeaMco product) {
        BigDecimal totalVat;
        VatAmount vatAmount = new VatAmount();
        vatAmount.setTotalVat(BigDecimal.ZERO, 0.0);
        ProductStatus status = product.getStatus();
        if (ProductStatusHandler.getAllVoidStatuses().contains(status)) {
            return vatAmount;
        }
        BigDecimal bigDecimal = totalVat = product.getTotalEquivalentVat() != null ? product.getTotalEquivalentVat() : RailwayCrimeaMcoHelper.calculateTotalEquivalentVat(product);
        if (relation != null && relation.getServiceData().getTotalPrice() != null) {
            BigDecimal totalPrice = relation.getServiceData().getTotalPrice();
            if (product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE) {
                totalPrice = totalPrice.negate();
            }
            vatAmount.setTotalVatAmount(totalPrice, product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE ? totalVat.negate() : totalVat);
            return vatAmount;
        }
        BigDecimal totalFare = RailwayCrimeaMcoHelper.calculateTotalEquivalentFare(product);
        if (status == ProductStatus.REFUND) {
            if (totalFare != null) {
                totalFare = totalFare.negate();
            }
            if (totalVat != null) {
                totalVat = totalVat.negate();
            }
        }
        vatAmount.setTotalVatAmount(totalFare, totalVat);
        return vatAmount;
    }

    public VatAmount calculateProductPrice(RailwayCrimeaMco product, ContractType ctype) {
        for (GeneralProductContractRelationData data : this.getUnmodifiableContractRelations(product)) {
            if (GeneralProductHelper.getContractType((EntityReference)data.getDescription()) != ctype) continue;
            return this.calculateProductPrice(data, product);
        }
        return this.calculateProductPrice(null, product);
    }

    public String generateShortProductName(RailwayCrimeaMco product) {
        return RailwayCrimeaMcoHelper.getShortNameString(product);
    }

    public String generateProductName(RailwayCrimeaMco product) {
        return RailwayCrimeaMcoHelper.getNameString(product);
    }

    public Date findFirstTravelDate(RailwayCrimeaMco product) {
        Date firstTravelDate = null;
        for (RailwaySegment segment : product.getSegments()) {
            Date departureDate = segment.getDepartureDate();
            if (MiscUtil.compare((Date)departureDate, firstTravelDate, (boolean)false) != -1) continue;
            firstTravelDate = departureDate;
        }
        return firstTravelDate;
    }

    public Date findLastTravelDate(RailwayCrimeaMco product) {
        Date lastTravelDate = null;
        for (RailwaySegment segment : product.getSegments()) {
            Date arriveDate = segment.getArriveDate();
            if (MiscUtil.compare((Date)arriveDate, lastTravelDate, (boolean)false) != 1) continue;
            lastTravelDate = arriveDate;
        }
        return lastTravelDate;
    }

    public List<String> getProductNumbers(RailwayCrimeaMco product) {
        ArrayList<String> productNumbers = new ArrayList<String>();
        String systemNumber = product.getSystemNumber();
        if (!TextUtil.isBlank((String)systemNumber)) {
            productNumbers.add(systemNumber);
        }
        return productNumbers;
    }

    public EntityReference<Person> findIssuingAgent(RailwayCrimeaMco product) {
        return product.getAgent();
    }

    public TravelSubject findTravelSubject(RailwayCrimeaMco product) {
        return TravelSubject.RAILWAY;
    }

    public Date findIssueDate(RailwayCrimeaMco product) {
        return product.getIssueDate();
    }

    public Date findLocalIssueDate(RailwayCrimeaMco product) {
        return product.getLocalIssueDate();
    }

    public void setIssueDate(RailwayCrimeaMco product, Date issueDate) {
        product.setIssueDate(issueDate);
    }

    public boolean includeInFinanceDocuments(RailwayCrimeaMco product) {
        return product.getStatus() != ProductStatus.VOID;
    }

    public Set<FinanceDocument> getAppropriateFinanceDocuments(Collection<BaseProduct> baseProducts, List<FinanceDocument> financeDocuments) throws Exception {
        HashSet<RailwayProduct> products = new HashSet<RailwayProduct>();
        for (BaseProduct baseProduct : baseProducts) {
            if (!(baseProduct instanceof RailwayProduct)) continue;
            products.add((RailwayProduct)baseProduct);
        }
        boolean hasFees = false;
        boolean hasRefundFees = false;
        PaymentType paymentType = null;
        boolean isRefund = false;
        boolean hasIssuedTickets = false;
        block1: for (RailwayProduct product : products) {
            if (product.getStatus() == ProductStatus.SELL || product.getStatus() == ProductStatus.REFUND) {
                hasIssuedTickets = true;
            }
            if (product.getStatus() == ProductStatus.REFUND) {
                isRefund = true;
            }
            if (paymentType == null) {
                List<RailwayProductFop> clientFops = RailwayProductHelper.getClientFops(product);
                if (!clientFops.isEmpty()) {
                    for (RailwayProductFop fop : clientFops) {
                        if (fop.getType() == null || !fop.getCommissions().isEmpty()) continue;
                        paymentType = fop.getType();
                        break;
                    }
                } else {
                    for (RailwayProductFop fop : RailwayProductHelper.getVendorFops(product)) {
                        if (fop.getType() == null) continue;
                        paymentType = fop.getType();
                        break;
                    }
                }
            }
            if (hasFees && hasRefundFees) continue;
            for (GeneralProductCommission commission : GeneralProductHelper.filterCommissions(RailwayProductHelper.getUnmodifiableCommissions(product, null), (Set)GeneralProductHelper.feePropertyTypes, null, (Set)GeneralProductHelper.standardCommissionCategories)) {
                hasFees = true;
                if (!BookingHelper.isFeeForRefund((EntityReference)commission.getCommissionProperties())) continue;
                hasRefundFees = true;
                continue block1;
            }
        }
        HashSet<FinanceDocument> documents = new HashSet<FinanceDocument>();
        for (FinanceDocument financeDocument : financeDocuments) {
            FinanceDocumentType financeDocumentType = financeDocument.getType();
            if (financeDocumentType == FinanceDocumentType.ACCEPTANCE_CERTIFICATE && (!hasFees || isRefund && !hasRefundFees) || financeDocumentType == FinanceDocumentType.CASH_ORDER && (!isRefund || paymentType != PaymentType.CASH)) continue;
            documents.add(financeDocument);
        }
        return documents;
    }

    public Collection<com.gridnine.xtrip.common.model.booking.BillingItem> getBillingItems(List<BaseProduct> baseProducts, FinanceDocumentsProperties fdp, boolean noVat) throws Exception {
        ArrayList<RailwayCrimeaMco> products = new ArrayList<RailwayCrimeaMco>();
        for (BaseProduct baseProduct : baseProducts) {
            if (!(baseProduct instanceof RailwayCrimeaMco)) continue;
            products.add((RailwayCrimeaMco)baseProduct);
        }
        HashMap tickets = new HashMap();
        HashMap penalties = new HashMap();
        HashMap fees = new HashMap();
        HashMap discounts = new HashMap();
        ArrayList<com.gridnine.xtrip.common.model.booking.BillingItem> billingItems = new ArrayList<com.gridnine.xtrip.common.model.booking.BillingItem>();
        for (RailwayCrimeaMco product : products) {
            String description = this.getDescription(product);
            FinanceDocumentsHelper.updateMap(tickets, (String)description, (Object)product);
            if (product.getPenalty() != null && product.getPenalty().compareTo(BigDecimal.ZERO) != 0) {
                FinanceDocumentsHelper.updateMap(penalties, (String)description, (Object)product);
            }
            ArrayList commissions = new ArrayList(GeneralProductHelper.filterCommissions(RailwayCrimeaMcoHelper.getUnmodifiableCommissions(product, null), null, null, (Set)GeneralProductHelper.standardCommissionCategories));
            for (GeneralProductCommission commission : commissions) {
                CommissionData cData;
                EntityContainer commissionContainer = EntityStorage.get().resolve(commission.getCommissionProperties());
                if (commissionContainer == null) continue;
                if (FeeProperties.class.equals((Object)commissionContainer.getEntityType()) || PaymentFeeProperties.class.equals((Object)commissionContainer.getEntityType())) {
                    cData = new CommissionData(commission, product);
                    FinanceDocumentsHelper.updateMap(fees, (String)this.getDescription((EntityContainer<? extends BaseCommissionProperties>)commissionContainer, cData, noVat), (Object)cData);
                    continue;
                }
                if (!DiscountProperties.class.getName().equals(commissionContainer.getEntityType().getName())) continue;
                cData = new CommissionData(commission, product);
                FinanceDocumentsHelper.updateMap(discounts, (String)this.getDescription((EntityContainer<? extends BaseCommissionProperties>)commissionContainer, cData, noVat), (Object)cData);
            }
        }
        this.updateProductItems(billingItems, tickets.values(), noVat);
        this.updatePenalties(billingItems, penalties.values(), noVat);
        this.updateCommissions(billingItems, fees.values(), false, noVat);
        this.updateCommissions(billingItems, discounts.values(), true, noVat);
        return billingItems;
    }

    public String getBillingItemName(RailwayCrimeaMco product, String relatedInvoiceNumber) {
        return this.getTitle(product).replace(GROUP_PLACE_HOLDER, this.getGroupString(Collections.singletonList(product)));
    }

    private String getTitle(RailwayCrimeaMco product) {
        StringBuilder stringBuilder = new StringBuilder();
        if (product.getStatus() == ProductStatus.SELL || product.getStatus() == ProductStatus.REFUND) {
            String departureDateString;
            String routeString;
            if (product.getStatus() == ProductStatus.SELL) {
                stringBuilder.append("\u0416/\u0414 \u041a\u0420\u0421 \u041a\u0440\u044b\u043c");
            } else if (product.getStatus() == ProductStatus.REFUND) {
                stringBuilder.append("\u0412\u043e\u0437\u0432\u0440\u0430\u0442 \u0416/\u0414 \u041a\u0420\u0421 \u041a\u0440\u044b\u043c");
            }
            if (product.isEticket()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(SEPARATOR);
                }
                stringBuilder.append("(\u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u044b\u0439 \u0431\u0438\u043b\u0435\u0442)");
            }
            if (TextUtil.isBlank((String)(routeString = RailwayCrimeaMcoHelper.getRouteString(product)))) {
                routeString = "?";
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append(SEPARATOR);
            }
            stringBuilder.append(String.format("\u043f\u043e \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0443 %s", routeString));
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            if (TextUtil.isBlank((String)(departureDateString = RailwayCrimeaMcoHelper.getDepartureDateString(product)))) {
                departureDateString = "?";
            }
            stringBuilder.append(departureDateString);
            stringBuilder.append(SEPARATOR);
            stringBuilder.append(String.format("(%s)", GROUP_PLACE_HOLDER));
        }
        return stringBuilder.toString();
    }

    private String getGroupString(List<RailwayCrimeaMco> products) {
        StringBuilder stringBuilder = new StringBuilder();
        for (RailwayCrimeaMco product : products) {
            String systemNumber = product.getSystemNumber();
            for (Traveller traveller : product.getPassengers()) {
                String travellerName;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                if (!TextUtil.isBlank((String)(travellerName = traveller.getName()))) {
                    stringBuilder.append(travellerName);
                } else {
                    stringBuilder.append("?");
                }
                if (!TextUtil.isBlank((String)systemNumber)) {
                    stringBuilder.append(String.format(": \u2116%s", systemNumber));
                    continue;
                }
                stringBuilder.append(": ?");
            }
        }
        return stringBuilder.toString();
    }

    private String getDescription(RailwayCrimeaMco product) {
        String title = this.getTitle(product);
        VatAmount money = this.calculateProductPrice(product, ContractType.CLIENT);
        return this.getDescription(title, money);
    }

    private String getDescription(EntityContainer<? extends BaseCommissionProperties> container, CommissionData data, boolean noVat) {
        VatAmount amount = new VatAmount();
        BigDecimal equivalentAmount = data.commission.getEquivalentAmount();
        amount.setTotalVat(equivalentAmount != null ? equivalentAmount : BigDecimal.ZERO, noVat ? 0.0 : MiscUtil.guarded((BigDecimal)DictHelper.getDefaultVat((Date)data.product.getIssueDate())).doubleValue());
        return this.getDescription(container.getUid(), amount);
    }

    private String getDescription(String title, VatAmount money) {
        DecimalFormat priceFormat = LocaleManager.get().getCurrentLocaleData().getPriceFormat();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(title);
        stringBuilder.append("_");
        stringBuilder.append(money.getTotal() != null ? priceFormat.format(money.getTotal().doubleValue()) : "?");
        stringBuilder.append("_");
        stringBuilder.append(money.getVatAmount() != null ? priceFormat.format(money.getVatAmount().doubleValue()) : "?");
        return stringBuilder.toString();
    }

    private void updateProductItems(List<com.gridnine.xtrip.common.model.booking.BillingItem> billingItems, Collection<List<RailwayCrimeaMco>> lists, boolean noVat) {
        for (List<RailwayCrimeaMco> list : lists) {
            if (list.isEmpty()) continue;
            com.gridnine.xtrip.common.model.booking.BillingItem item = new com.gridnine.xtrip.common.model.booking.BillingItem();
            for (RailwayCrimeaMco product : list) {
                item.getProductUids().add(product.getUid());
            }
            item.setServiceType(ServiceType.TICKET);
            item.setName(this.getTitle(list.get(0)).replace(GROUP_PLACE_HOLDER, this.getGroupString(list)));
            BigDecimal total = BigDecimal.ZERO;
            BigDecimal vat = BigDecimal.ZERO;
            for (RailwayCrimeaMco product : list) {
                VatAmount price = this.calculateProductFopPrice(product);
                total = total.add(price.getTotal());
                vat = vat.add(price.getVatAmount());
            }
            ProductStatus status = list.get(0).getStatus();
            if (status == ProductStatus.REFUND || status == ProductStatus.EXCHANGE) {
                total = total.negate();
                vat = vat.negate();
            }
            VatAmount amount = new VatAmount();
            amount.setTotalVatAmount(total, vat);
            item.setAmount(amount);
            billingItems.add(item);
        }
    }

    private VatAmount calculateProductFopPrice(RailwayCrimeaMco product) {
        BigDecimal value = BigDecimal.ZERO;
        if (product.getStatus() == ProductStatus.BOOKING) {
            return BookingHelper.calculateProductPrice((BaseProduct)product, (ContractType)ContractType.CLIENT);
        }
        if (!ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) {
            List<RailwayProductFop> clientFops = RailwayCrimeaMcoHelper.getClientFops(product);
            if (!clientFops.isEmpty()) {
                for (RailwayProductFop fop : clientFops) {
                    if (fop.getAmount() == null || fop.getAmount().getValue() == null || !RailwayProductHelper.isServiceFop(fop)) continue;
                    value = value.add(fop.getAmount().getValue());
                }
            } else {
                for (RailwayProductFop fop : RailwayCrimeaMcoHelper.getVendorFops(product)) {
                    if (fop.getAmount() == null || fop.getAmount().getValue() == null) continue;
                    value = value.add(fop.getAmount().getValue());
                }
            }
            if (product.getPenalty() != null) {
                value = product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE ? value.add(product.getPenalty()) : value.subtract(product.getPenalty());
            }
            VatAmount result = new VatAmount();
            result.setTotalVatAmount(value, product.getTotalEquivalentVat());
            return result;
        }
        VatAmount result = new VatAmount();
        result.setTotalVat(BigDecimal.ZERO, 0.0);
        return result;
    }

    private void updatePenalties(List<com.gridnine.xtrip.common.model.booking.BillingItem> billingItems, Collection<List<RailwayCrimeaMco>> lists, boolean noVat) {
        for (List<RailwayCrimeaMco> list : lists) {
            if (list.isEmpty()) continue;
            com.gridnine.xtrip.common.model.booking.BillingItem item = new com.gridnine.xtrip.common.model.booking.BillingItem();
            for (RailwayCrimeaMco product : list) {
                item.getProductUids().add(product.getUid());
            }
            item.setServiceType(ServiceType.PENALTY);
            item.setName("\u0428\u0442\u0440\u0430\u0444 \u0437\u0430 \u0432\u043e\u0437\u0432\u0440\u0430\u0442");
            BigDecimal total = BigDecimal.ZERO;
            BigDecimal vat = BigDecimal.ZERO;
            for (RailwayCrimeaMco product : list) {
                total = MiscUtil.sum((BigDecimal[])new BigDecimal[]{total, product.getPenalty()});
                vat = MiscUtil.sum((BigDecimal[])new BigDecimal[]{vat, product.getPenaltyVat()});
            }
            VatAmount amount = new VatAmount();
            amount.setTotalVatAmount(total, vat);
            item.setAmount(amount);
            billingItems.add(item);
        }
    }

    private void updateCommissions(List<com.gridnine.xtrip.common.model.booking.BillingItem> billingItems, Collection<List<CommissionData>> lists, boolean discount, boolean noVat) {
        for (List<CommissionData> list : lists) {
            if (list.isEmpty()) continue;
            com.gridnine.xtrip.common.model.booking.BillingItem item = new com.gridnine.xtrip.common.model.booking.BillingItem();
            for (CommissionData commissionData : list) {
                item.getProductUids().add(commissionData.product.getUid());
            }
            item.setServiceType(discount ? ServiceType.DISCOUNT : ServiceType.FEE);
            item.setCommissionType(list.get((int)0).commission.getCommissionProperties());
            EntityContainer container = EntityStorage.get().resolve(list.get((int)0).commission.getCommissionProperties());
            BigDecimal coefficient = BigDecimal.ONE;
            if (container.getEntityType().getName().equals(FeeProperties.class.getName())) {
                FeeProperties feeProperties = (FeeProperties)container.getEntity();
                item.setName(feeProperties.getFinanceName());
            } else if (container.getEntityType().equals(PaymentFeeProperties.class)) {
                PaymentFeeProperties prop = (PaymentFeeProperties)container.getEntity();
                item.setName(prop.getFinanceName());
            } else {
                DiscountProperties discountProperties = (DiscountProperties)container.getEntity();
                item.setName(discountProperties.getFinanceName());
            }
            if (list.get((int)0).product.getStatus() == ProductStatus.REFUND) {
                coefficient = coefficient.negate();
            }
            BigDecimal total = BigDecimal.ZERO;
            ArrayList<RailwayCrimeaMco> products = new ArrayList<RailwayCrimeaMco>();
            for (CommissionData commissionData : list) {
                BigDecimal equivalentAmount = commissionData.commission.getEquivalentAmount();
                if (equivalentAmount != null) {
                    BigDecimal bigDecimal = total = discount ? total.subtract(equivalentAmount) : total.add(equivalentAmount);
                }
                if (commissionData.product == null || products.contains(commissionData.product)) continue;
                products.add(commissionData.product);
            }
            if (!TextUtil.isBlank((String)item.getName())) {
                item.setName(item.getName().replace("${air_tickets_info}", this.getGroupString(products)));
            }
            VatAmount amount = new VatAmount();
            amount.setTotalVat(coefficient.multiply(total), noVat ? 0.0 : MiscUtil.guarded((BigDecimal)DictHelper.getDefaultVat()).doubleValue());
            item.setAmount(amount);
            billingItems.add(item);
        }
    }

    public Collection<Traveller> getTravellers(RailwayCrimeaMco product) {
        return product.getPassengers();
    }

    public void replaceTraveller(RailwayCrimeaMco product, Traveller oldTraveller, Traveller newTraveller) {
        Collections.replaceAll(product.getPassengers(), oldTraveller, newTraveller);
        product.getFopDetalizations().values().stream().flatMap(detalization -> detalization.getComponents().stream()).forEach(component -> {
            if (oldTraveller.equals((Object)component.getTraveller())) {
                component.setTraveller(newTraveller);
            }
        });
        if (product.getStatisticalData() != null) {
            product.getStatisticalData().getTravellerCostCodes().stream().filter(tcc -> oldTraveller.equals((Object)tcc.getTraveller())).forEach(tcc -> tcc.setTraveller(newTraveller));
        }
    }

    public void setOrReplaceTraveller(RailwayCrimeaMco product, Traveller oldTraveller, Traveller newTraveller) {
        if (oldTraveller == null) {
            product.getPassengers().add(newTraveller);
        } else {
            this.replaceTraveller(product, oldTraveller, newTraveller);
        }
    }

    public void updateBillingItems(Collection<com.gridnine.xtrip.common.model.booking.BillingItem> items, List<RailwayCrimeaMco> products) {
    }

    public EntityReference<SalesPoint> findSalesPoint(RailwayCrimeaMco product) {
        return product.getSalesPoint();
    }

    public ProductStatus getStatus(RailwayCrimeaMco product) {
        return product.getStatus();
    }

    public ProductStatus getBaseStatus(RailwayCrimeaMco product) {
        return product.getStatus();
    }

    public void setStatus(RailwayCrimeaMco product, ProductStatus productStatus) {
        product.setStatus(productStatus);
    }

    public ProductType getProductType(RailwayCrimeaMco product) {
        return ProductType.RAILWAY_CRIMEA_MCO;
    }

    public Set<ProductType> getAllProductTypes() {
        return Collections.unmodifiableSet(Stream.of(ProductType.RAILWAY_CRIMEA_MCO).collect(Collectors.toSet()));
    }

    public RuleTarget getCommissionRuleTarget() {
        return Targets.RAILWAY_PRODUCT_COMMISSION;
    }

    public EntityReference<Organization> getBlankOwner(RailwayCrimeaMco product) {
        return product.getBlankOwner();
    }

    public EntityReference<Branch> getBranch(RailwayCrimeaMco product) {
        return product.getBranch();
    }

    public List<MCOFeesSource> getMcoFeesSources(RailwayCrimeaMco product) {
        ArrayList<MCOFeesSource> res = new ArrayList<MCOFeesSource>();
        String equivCurrency = DictHelper.getCurrencyByAnyCode((String)DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, null));
        BigDecimal fareValue = RailwayCrimeaMcoHelper.calculateTotalEquivalentFare(product);
        if (fareValue != null && fareValue.compareTo(BigDecimal.ZERO) > 0) {
            MCOFeesSource source = new MCOFeesSource();
            source.setTicketNumber(product.getSystemNumber());
            Money fare = new Money();
            fare.setValue(product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE ? MiscUtil.negate((BigDecimal)fareValue) : fareValue);
            fare.setCurrency(equivCurrency);
            source.setFare(fare);
            source.setIsTotalSum(true);
            source.setProductUid(product.getUid());
            source.setDescription(this.generateShortProductName(product));
            res.add(source);
        }
        for (GeneralProductCommission comm : RailwayCrimeaMcoHelper.getUnmodifiableCommissions(product, ContractType.CLIENT)) {
            BaseCommissionProperties propBase = null;
            try {
                EntityContainer propCont = EntityStorage.get().resolve(comm.getCommissionProperties());
                if (propCont != null) {
                    propBase = (BaseCommissionProperties)propCont.getEntity();
                }
            }
            catch (Exception propCont) {
                // empty catch block
            }
            if (!(propBase instanceof FeeProperties) && !(propBase instanceof PaymentFeeProperties)) continue;
            MCOFeesSource sourceCommission = new MCOFeesSource();
            sourceCommission.setTicketNumber(product.getSystemNumber());
            Money fareComm = new Money();
            fareComm.setValue(product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE ? MiscUtil.negate((BigDecimal)comm.getEquivalentAmount()) : comm.getEquivalentAmount());
            fareComm.setCurrency(equivCurrency);
            sourceCommission.setFare(fareComm);
            sourceCommission.setIsTotalSum(false);
            sourceCommission.setProductUid(product.getUid());
            sourceCommission.setDescription(propBase.getDisplayName() + " - " + this.generateShortProductName(product));
            res.add(sourceCommission);
        }
        return res;
    }

    public boolean isCompleted(RailwayCrimeaMco product) {
        return product.isCompleted();
    }

    public void setCompleted(RailwayCrimeaMco product, boolean completed) {
        product.setCompleted(completed);
    }

    public boolean isChecked(RailwayCrimeaMco product) {
        return product.isChecked();
    }

    public void setChecked(RailwayCrimeaMco product, boolean checked) {
        product.setChecked(checked);
    }

    public TransportationType getTransportationType(RailwayCrimeaMco product) {
        return RailwayCrimeaMcoHelper.getTransportationType(product);
    }

    public ServiceLocationType getServiceLocationType(RailwayCrimeaMco product) {
        return RailwayCrimeaMcoHelper.getServiceLocationType(product);
    }

    public Date findNearestTravelDate(Date momentOfTime, RailwayCrimeaMco product) {
        for (RailwaySegment seg : product.getSegments()) {
            if (momentOfTime.compareTo(seg.getDepartureDate()) > 0) continue;
            return seg.getDepartureDate();
        }
        return null;
    }

    public RailwayCrimeaMco getPreviousProduct(RailwayCrimeaMco product) {
        return product.getPreviousProduct();
    }

    public void setPreviousProduct(RailwayCrimeaMco product, RailwayCrimeaMco previousProduct) {
        product.setPreviousProduct(previousProduct);
    }

    public void setNextProduct(RailwayCrimeaMco product, RailwayCrimeaMco nextProduct) {
        product.setNextProduct(nextProduct);
    }

    public RailwayCrimeaMco getNextProduct(RailwayCrimeaMco product) {
        return product.getNextProduct();
    }

    public void addRelatedProduct(RailwayCrimeaMco product, BaseProduct relatedProduct) {
        product.getRelatedProducts().add((RailwayProduct)relatedProduct);
    }

    public List<BaseProduct> getRelatedProducts(RailwayCrimeaMco product) {
        return new ArrayList<BaseProduct>(product.getRelatedProducts());
    }

    public ProductCancellationDetails getCancellationDetails(RailwayCrimeaMco product) {
        return null;
    }

    public ProductCategory getProductCategory(RailwayCrimeaMco product) {
        return null;
    }

    public MCOCategory getMCOCategory(RailwayCrimeaMco product) {
        return null;
    }

    public List<GeneralProductTax> getTaxes(RailwayCrimeaMco product) {
        return Collections.emptyList();
    }

    public DictionaryReference<BlankType> getBlankType(RailwayCrimeaMco product) {
        return product.getBlankType();
    }

    public BigDecimal getEquivalentFare(RailwayCrimeaMco product) {
        return product.getEquivalentFare();
    }

    public BigDecimal getServiceFare(RailwayCrimeaMco product) {
        return null;
    }

    public BigDecimal getPenalty(RailwayCrimeaMco product) {
        return product.getPenalty();
    }

    public int getConjunction(RailwayCrimeaMco product) {
        return 0;
    }

    public String getRouteLine(RailwayCrimeaMco product) {
        return RailwayCrimeaMcoHelper.getRouteString(product);
    }

    public String getLocalizedRouteLine(RailwayCrimeaMco product) {
        return RailwayCrimeaMcoHelper.getRouteString(product);
    }

    public String getCodeRouteLine(RailwayCrimeaMco product) {
        return RailwayProductHelper.getCodeRouteLine(product == null ? null : product.getSegments().stream());
    }

    public List<GeneralProductContractRelationData> getUnmodifiableContractRelations(RailwayCrimeaMco product) {
        ArrayList<GeneralProductContractRelationData> result = new ArrayList<GeneralProductContractRelationData>();
        for (RailwayProductContractRelationData item : RailwayCrimeaMcoHelper.getContractRelations(product)) {
            GeneralProductContractRelationData generalData = new GeneralProductContractRelationData();
            generalData.setUid(item.getUid());
            generalData.setDescription(item.getDescription());
            try {
                XCloneModelHelper.copy((BaseEntity)item.getServiceData(), (BaseEntity)generalData.getServiceData());
                XCloneModelHelper.copy((BaseEntity)item.getGeneralData(), (BaseEntity)generalData.getGeneralData());
            }
            catch (Exception e) {
                throw new IllegalStateException("unable to clone entity ", e);
            }
            generalData.getCommissions().addAll(item.getCommissions());
            for (RailwayProductFop fop : item.getFops()) {
                generalData.getFops().add(RailwayProductHelper.toGeneralProductFop(fop));
            }
            result.add(generalData);
        }
        return result;
    }

    public SalesChain getSalesChain(RailwayCrimeaMco product) {
        return RailwayCrimeaMcoHelper.getSalesChain(product);
    }

    public void updateContractRelations(RailwayCrimeaMco product, List<GeneralProductContractRelationData> relations) {
        ArrayList<RailwayProductContractRelationData> result = new ArrayList<RailwayProductContractRelationData>();
        List<RailwayProductContractRelationData> originalRelations = RailwayCrimeaMcoHelper.getContractRelations(product);
        boolean updateRelations = originalRelations.size() != relations.size();
        for (GeneralProductContractRelationData generalProductRelation : relations) {
            RailwayProductContractRelationData relation = (RailwayProductContractRelationData)CollectionUtil.find(originalRelations, (String)generalProductRelation.getUid());
            if (relation == null) {
                relation = new RailwayProductContractRelationData();
                relation.setUid(generalProductRelation.getUid());
                relation.setDescription(generalProductRelation.getDescription());
                updateRelations = true;
            }
            result.add(relation);
            try {
                XCloneModelHelper.copy((BaseEntity)generalProductRelation.getGeneralData(), (BaseEntity)relation.getGeneralData());
                XCloneModelHelper.copy((BaseEntity)generalProductRelation.getServiceData(), (BaseEntity)relation.getServiceData());
            }
            catch (Exception e) {
                throw Xeption.forDeveloper((String)"unable to xcopy object", (Throwable)e, (Object[])new Object[0]);
            }
            GeneralProductHelper.updateCommissions((List)generalProductRelation.getCommissions(), (List)relation.getCommissions());
            ArrayList<RailwayProductFop> fops = new ArrayList<RailwayProductFop>();
            boolean updateFops = generalProductRelation.getFops().size() != relation.getFops().size();
            for (GeneralProductFop generalProductFop : generalProductRelation.getFops()) {
                RailwayProductFop fop = (RailwayProductFop)CollectionUtil.find((Iterable)relation.getFops(), (String)generalProductFop.getUid());
                if (fop == null) {
                    fop = new RailwayProductFop();
                    fop.setUid(generalProductFop.getUid());
                    updateFops = true;
                }
                fops.add(fop);
                fop.setType(generalProductFop.getType());
                fop.setCard(generalProductFop.getCard());
                fop.setRelatedTicketNumber(generalProductFop.getRelatedTicketNumber());
                if (fop.getAmount() == null) {
                    Money money = new Money();
                    money.setValue(BigDecimal.ZERO);
                    money.setCurrency(DictHelper.getLocalCurrency2());
                    fop.setAmount(money);
                }
                fop.getAmount().setValue(generalProductFop.getEquivalentAmount());
                fop.setOperationDate(generalProductFop.getOperationDate());
                fop.setAgent(generalProductFop.getAgent());
                fop.setRefused(generalProductFop.isRefused());
                fop.setPayer(generalProductFop.getPayer());
                fop.getCommissions().clear();
                for (GeneralProductCommission generalProductCommission : generalProductFop.getCommissions()) {
                    GeneralProductCommission commission = (GeneralProductCommission)BookingHelper.findEntityByUid((Collection)relation.getCommissions(), (String)generalProductCommission.getUid());
                    if (commission == null) continue;
                    fop.getCommissions().add(commission);
                }
            }
            if (!updateFops) continue;
            relation.getFops().clear();
            relation.getFops().addAll(fops);
        }
        if (updateRelations) {
            originalRelations.clear();
            originalRelations.addAll(result);
        }
    }

    public TicketType getTicketType(RailwayCrimeaMco product) {
        return product.getTicketType();
    }

    public void setTicketType(RailwayCrimeaMco product, TicketType ticketType) {
        product.setTicketType(ticketType);
    }

    public String getPCC(RailwayCrimeaMco product) {
        return product.getPcc();
    }

    public void updateProductFops(RailwayCrimeaMco product) {
        RailwayCrimeaMcoHelper.updateProductFops(product);
    }

    public void setContractRulesApplied(RailwayCrimeaMco product, boolean value) {
        product.setContractRulesApplied(value);
    }

    public List<ValidationMessage> getValidationMessages(RailwayCrimeaMco product) {
        return product.getValidationMessages();
    }

    public EntityReference<Organization> getProvider(RailwayCrimeaMco product) {
        return product.getProvider();
    }

    public PassengerStatus getPassengerStatus(RailwayCrimeaMco product) {
        for (RailwayProductFop fop : RailwayCrimeaMcoHelper.getClientFops(product)) {
            if (fop.getType() != PaymentType.MTD || fop.getPassengerStatus() == null) continue;
            return fop.getPassengerStatus();
        }
        return null;
    }

    public boolean isHoldable(RailwayCrimeaMco product) {
        return false;
    }

    public Date getUnholdDate(RailwayCrimeaMco product) {
        return null;
    }

    public String getValidatorNumber(RailwayCrimeaMco product) {
        Validator validator = (Validator)EntityStorageHelper.resolve((NestedEntityReference)product.getValidator(), (EntityStorageContext)EntityStorageHelper.createContext());
        return validator != null ? validator.getNumber() : null;
    }

    public DictionaryReference<PassengerType> getPassengerType(RailwayCrimeaMco product) {
        return null;
    }

    public StatisticalData getStatisticalData(RailwayCrimeaMco product) {
        return product.getStatisticalData();
    }

    public boolean isStatisticalDataAvailable(RailwayCrimeaMco product) {
        return true;
    }

    public void newStatisticalData(RailwayCrimeaMco product) {
        product.setStatisticalData(new StatisticalData());
    }

    public BigDecimal getAddCollect(RailwayCrimeaMco product) {
        return null;
    }

    public TravelSubject getDefaultTravelSubject() {
        return null;
    }

    public RailwayCrimeaMco newInstance() {
        return new RailwayCrimeaMco();
    }

    public String getCarrierNumber(RailwayCrimeaMco product) {
        return product.getCarrierNumber();
    }

    public void setAgent(RailwayCrimeaMco product, EntityReference<Person> agent) {
        product.setAgent(agent);
    }

    public void setComments(RailwayCrimeaMco product, String comments) {
        product.setComments(comments);
    }

    public void setAgency(RailwayCrimeaMco product, EntityReference<Organization> agency) {
        RailwayCrimeaMcoHelper.setAgency(product, agency);
    }

    public void setBlankOwner(RailwayCrimeaMco product, EntityReference<Organization> blankOwner) {
        product.setBlankOwner(blankOwner);
    }

    public void setBranch(RailwayCrimeaMco product, EntityReference<Branch> branch) {
        product.setBranch(branch);
    }

    public void setSupplier(RailwayCrimeaMco product, EntityReference<Organization> supplier) {
        RailwayCrimeaMcoHelper.setSupplier(product, supplier);
    }

    public void setSubagency(RailwayCrimeaMco product, EntityReference<Organization> subagency) {
        RailwayCrimeaMcoHelper.setSubagency(product, subagency);
    }

    public void setSalesPoint(RailwayCrimeaMco product, EntityReference<SalesPoint> salesPoint) {
        product.setSalesPoint(salesPoint);
    }

    public void changeFopsPaymentTypes(RailwayCrimeaMco product, PaymentType paymentType, ContractType contractType, boolean updateOnlyFeeFops) {
        ArrayList<RailwayProductFop> fops = new ArrayList<RailwayProductFop>();
        switch (contractType) {
            case VENDOR: {
                fops.addAll(RailwayCrimeaMcoHelper.getVendorFops(product));
                break;
            }
            case SUBAGENCY: {
                fops.addAll(RailwayCrimeaMcoHelper.getSubagentFops(product, false));
                break;
            }
            case CLIENT: {
                fops.addAll(RailwayCrimeaMcoHelper.getClientFops(product));
            }
        }
        RailwayProductHelper.changeFopsPaymentTypes(fops, paymentType, updateOnlyFeeFops);
    }

    public void changeFopsAgent(RailwayCrimeaMco product, EntityReference<Person> agent, ContractType contractType) {
        List<RailwayProductFop> fops = this.getFops(product, contractType);
        fops.forEach(fop -> fop.setAgent(agent));
    }

    public List<String> getFopsUids(RailwayCrimeaMco product, ContractType contractType) {
        return this.getFops(product, contractType).stream().map(BaseIdentity::getUid).collect(Collectors.toList());
    }

    private List<RailwayProductFop> getFops(RailwayCrimeaMco product, ContractType contractType) {
        switch (contractType) {
            case VENDOR: {
                return RailwayCrimeaMcoHelper.getVendorFops(product);
            }
            case SUBAGENCY: {
                return RailwayCrimeaMcoHelper.getSubagentFops(product, false);
            }
            case CLIENT: {
                return RailwayCrimeaMcoHelper.getClientFops(product);
            }
        }
        return Collections.emptyList();
    }

    public void setBlankType(RailwayCrimeaMco product, DictionaryReference<BlankType> blankType) {
        product.setBlankType(blankType);
    }

    public Money getBspCommissionValue(RailwayCrimeaMco product) {
        return null;
    }

    public Double getBspCommissionRate(RailwayCrimeaMco product) {
        return null;
    }

    public boolean removeProduct(RailwayCrimeaMco product) {
        return RailwayCrimeaMcoHelper.removeProduct(product);
    }

    public boolean removeRelatedProduct(RailwayCrimeaMco product, BaseProduct relatedProduct) {
        return RailwayCrimeaMcoHelper.removeRelatedProduct(product, relatedProduct);
    }

    public boolean isAppropriateBillingItem(RailwayCrimeaMco product, FinanceDocumentType type, UniversalDocumentStatus universalDocumentStatus, BillingItemIncludeMode mode, BillingItem billingItem, List<BillingItem> billingItems, List<BillingItem> prepaymentBillingItems) {
        if (type == FinanceDocumentType.INVOICE_FACTURA || type == FinanceDocumentType.UNIVERSAL_DOCUMENT && universalDocumentStatus == UniversalDocumentStatus.ONE) {
            if (Optional.ofNullable(billingItem.getAmount()).map(VatAmount::getVat).orElse(null) == null) {
                return false;
            }
            if (billingItem.getServiceType() != ServiceType.FEE) {
                return false;
            }
        }
        if (type == FinanceDocumentType.STANDARD_BILL) {
            return billingItem.getServiceType() == ServiceType.TICKET || billingItem.getServiceType() == ServiceType.PENALTY;
        }
        if (type == FinanceDocumentType.ACCEPTANCE_CERTIFICATE && mode == BillingItemIncludeMode.ALL_EXCEPT_TICKET) {
            return billingItem.getServiceType() != ServiceType.TICKET && billingItem.getServiceType() != ServiceType.PENALTY;
        }
        if (type == FinanceDocumentType.INVOICE) {
            if (prepaymentBillingItems.isEmpty()) {
                return true;
            }
            ArrayList<BillingItem> remainingList = new ArrayList<BillingItem>(billingItems);
            remainingList.removeIf(item -> CollectionUtil.contains((Collection)prepaymentBillingItems, (Object)item, FinanceDocumentsHelper::isSameBillingItems));
            if (remainingList.isEmpty()) {
                return false;
            }
            if (!CollectionUtil.containsAll(billingItems, prepaymentBillingItems, FinanceDocumentsHelper::isSameBillingItems)) {
                return true;
            }
            return CollectionUtil.contains(remainingList, (Object)billingItem, FinanceDocumentsHelper::isSameBillingItems);
        }
        return true;
    }

    public boolean isVatIncludeBillingItem(RailwayCrimeaMco product, VatViewMode mode, BillingItem billingItem) {
        return mode == VatViewMode.ALWAYS || mode == VatViewMode.ALWAYS_EXCEPT_TICKET && billingItem.getServiceType() != ServiceType.TICKET && billingItem.getServiceType() != ServiceType.PENALTY;
    }

    public String getCities(RailwayCrimeaMco product, Locale locale) {
        return RailwayCrimeaMcoHelper.getCities(product, locale);
    }

    public String getCountries(RailwayCrimeaMco product, Locale locale) {
        return RailwayCrimeaMcoHelper.getCountries(product, locale);
    }

    public Date getFirstStartDate(RailwayCrimeaMco product) {
        List dates = product.getSegments().stream().map(RailwaySegment::getDepartureDate).collect(Collectors.toList());
        return dates.size() > 0 ? (Date)dates.get(0) : null;
    }

    public Date getLastStartDate(RailwayCrimeaMco product) {
        List dates = product.getSegments().stream().map(RailwaySegment::getDepartureDate).collect(Collectors.toList());
        return dates.size() > 0 ? (Date)dates.get(dates.size() - 1) : null;
    }

    public Date getFirstEndDate(RailwayCrimeaMco product) {
        List dates = product.getSegments().stream().map(RailwaySegment::getArriveDate).collect(Collectors.toList());
        return dates.size() > 0 ? (Date)dates.get(0) : null;
    }

    public Date getLastEndDate(RailwayCrimeaMco product) {
        List dates = product.getSegments().stream().map(RailwaySegment::getArriveDate).collect(Collectors.toList());
        return dates.size() > 0 ? (Date)dates.get(dates.size() - 1) : null;
    }

    public String getDescriptionLine(RailwayCrimeaMco product) {
        return null;
    }

    public DictionaryReference<Airline> getCarrier(RailwayCrimeaMco product) {
        return null;
    }

    public String getTrain(RailwayCrimeaMco product) {
        List trains = product.getSegments().stream().map(item -> {
            StringBuilder train = new StringBuilder();
            if (!TextUtil.isBlank((String)item.getSlot())) {
                train.append(item.getSlot());
            }
            if (!TextUtil.isBlank((String)item.getTrainNumber())) {
                train.append(item.getTrainNumber());
            }
            return train.length() > 0 ? train.toString() : "?";
        }).collect(Collectors.toList());
        return trains.size() > 0 ? (String)trains.get(0) : null;
    }

    public boolean isContractRulesApplied(RailwayCrimeaMco product) {
        return product.isContractRulesApplied();
    }

    public boolean isSystemNumberDuplicateAllowed(RailwayCrimeaMco product) {
        return false;
    }

    public String getRfic(RailwayCrimeaMco product) {
        return null;
    }

    public String getRfisc(RailwayCrimeaMco product) {
        return null;
    }

    public String getTourCode(RailwayCrimeaMco product) {
        return null;
    }

    public boolean isDuplicate(RailwayCrimeaMco product) {
        return false;
    }

    public Set<String> getServiceClasses(RailwayCrimeaMco product, Locale locale) {
        return product.getSegments().stream().map(RailwaySegment::getServiceClass).filter(Objects::nonNull).map(item -> item.toString(locale)).collect(Collectors.toSet());
    }

    private static final class CommissionData {
        public RailwayCrimeaMco product;
        public GeneralProductCommission commission;

        public CommissionData(GeneralProductCommission commission, RailwayCrimeaMco product) {
            this.commission = commission;
            this.product = product;
        }
    }
}

