/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.railway.handlers;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BillingItem;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.FinanceDocument;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.GeneralProductTax;
import com.gridnine.xtrip.common.model.booking.MCOFeesSource;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.ProductCancellationDetails;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.ServiceLocationType;
import com.gridnine.xtrip.common.model.booking.ServiceType;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayMcoProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.PassengerStatus;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.BillingItemIncludeMode;
import com.gridnine.xtrip.common.model.finance.UniversalDocumentStatus;
import com.gridnine.xtrip.common.model.finance.VatViewMode;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Branch;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentsProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayMcoProductHelper;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.railway.model.rules.standart.Targets;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RailwayMcoProductHandler
implements ProductHandler<RailwayMcoProduct> {
    public Class<RailwayMcoProduct> getProductClass() {
        return RailwayMcoProduct.class;
    }

    public VatAmount calculateProductPrice(GeneralProductContractRelationData relation, RailwayMcoProduct product) {
        return GeneralProductHelper.calculateProductPrice((GeneralProductContractRelationData)relation, (ProductHandler)this, (BaseProduct)product);
    }

    public VatAmount calculateProductPrice(RailwayMcoProduct product, ContractType ctype) {
        for (GeneralProductContractRelationData data : this.getUnmodifiableContractRelations(product)) {
            if (GeneralProductHelper.getContractType((EntityReference)data.getDescription()) != ctype) continue;
            return this.calculateProductPrice(data, product);
        }
        return this.calculateProductPrice(null, product);
    }

    public String generateShortProductName(RailwayMcoProduct product) {
        return L10nResourcesManager.getStr((String)"RAILWAY_MCO_PRODUCT_NAME", (Object[])new Object[]{product.getSystemNumber() != null ? product.getSystemNumber() : "", product.getStatus() != null ? product.getStatus() : ""});
    }

    public String generateProductName(RailwayMcoProduct product) {
        return this.generateShortProductName(product) + " " + RailwayProductHelper.getTravellersString(product.getPassengers(), ",");
    }

    public Date findFirstTravelDate(RailwayMcoProduct product) {
        List segments = product.getSegments();
        if (CollectionUtil.isEmpty((Collection)segments)) {
            return null;
        }
        return ((RailwaySegment)segments.get(0)).getDepartureDate();
    }

    public Date findLastTravelDate(RailwayMcoProduct product) {
        List segments = product.getSegments();
        if (CollectionUtil.isEmpty((Collection)segments)) {
            return null;
        }
        return ((RailwaySegment)segments.get(segments.size() - 1)).getArriveDate();
    }

    public List<String> getProductNumbers(RailwayMcoProduct product) {
        ArrayList<String> productNumbers = new ArrayList<String>();
        String systemNumber = product.getSystemNumber();
        if (!TextUtil.isBlank((String)systemNumber)) {
            productNumbers.add(systemNumber);
        }
        return productNumbers;
    }

    public EntityReference<Person> findIssuingAgent(RailwayMcoProduct product) {
        return product.getCashier();
    }

    public TravelSubject findTravelSubject(RailwayMcoProduct product) {
        return TravelSubject.RAILWAY;
    }

    public Date findIssueDate(RailwayMcoProduct product) {
        return product.getIssueDate();
    }

    public Date findLocalIssueDate(RailwayMcoProduct product) {
        return product.getLocalIssueDate();
    }

    public void setIssueDate(RailwayMcoProduct product, Date issueDate) {
        product.setIssueDate(issueDate);
    }

    public boolean includeInFinanceDocuments(RailwayMcoProduct product) {
        return product.getStatus() != ProductStatus.VOID;
    }

    public Set<FinanceDocument> getAppropriateFinanceDocuments(Collection<BaseProduct> products, List<FinanceDocument> availableDocuments) throws Exception {
        Set prods = products.stream().filter(bp -> bp instanceof RailwayMcoProduct).map(bp -> this.createFinanceCapableProduct((RailwayMcoProduct)bp)).collect(Collectors.toSet());
        return GeneralProductHelper.getAppropriateFinanceDocuments(prods, availableDocuments);
    }

    private GeneralProductHelper.FinanceCapableProduct createFinanceCapableProduct(final RailwayMcoProduct product) {
        return new GeneralProductHelper.FinanceCapableProduct(){

            public Date getIssueDate() {
                return RailwayMcoProductHandler.this.findIssueDate(product);
            }

            public List<GeneralProductFop> getVendorFops() {
                return RailwayMcoProductHelper.getVendorFops(product);
            }

            public List<GeneralProductFop> getSubagentFops() {
                return RailwayMcoProductHelper.getSubagentFops(product, false);
            }

            public List<GeneralProductFop> getClientFops() {
                return RailwayMcoProductHelper.getClientFops(product);
            }

            public ProductStatus getStatus() {
                return product.getStatus();
            }

            public List<GeneralProductCommission> getCommissions() {
                return RailwayMcoProductHelper.getUnmodifiableCommissions(product, ContractType.CLIENT);
            }

            public GeneralProductHelper.FinanceCapableProduct getPreviousProduct() {
                return product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.SELL ? RailwayMcoProductHandler.this.createFinanceCapableProduct(product.getPreviousProduct()) : null;
            }

            public VatAmount calculateProductPrice() {
                return RailwayMcoProductHandler.this.calculateProductPriceBasic(product, ContractType.CLIENT);
            }

            public boolean isHasVat() {
                return true;
            }

            public String getCommonPart() {
                if (product.getStatus() == ProductStatus.REFUND) {
                    return L10nResourcesManager.getStr((String)"RAILWAY_MCO_PRODUCT_REFUND", (Object[])new Object[0]);
                }
                return L10nResourcesManager.getStr((String)"RAILWAY_MCO_PRODUCT_INFO", (Object[])new Object[0]);
            }

            public BigDecimal getPenalty() {
                return null;
            }

            public String getProductUid() {
                return product.getUid();
            }

            public String getTicketNumber() {
                return product.getSystemNumber();
            }

            public Traveller getTraveller() {
                return (Traveller)product.getPassengers().get(0);
            }
        };
    }

    private VatAmount calculateProductPriceBasic(RailwayMcoProduct product, ContractType ctype) {
        for (GeneralProductContractRelationData data : this.getUnmodifiableContractRelations(product)) {
            if (GeneralProductHelper.getContractType((EntityReference)data.getDescription()) != ctype) continue;
            return this.calculateProductPrice(data, product);
        }
        return this.calculateProductPrice(null, product);
    }

    public Collection<BillingItem> getBillingItems(List<BaseProduct> products, FinanceDocumentsProperties fdp, boolean noVat) throws Exception {
        List prods = products.stream().filter(bp -> bp instanceof RailwayMcoProduct).map(bp -> this.createFinanceCapableProduct((RailwayMcoProduct)bp)).collect(Collectors.toCollection(ArrayList::new));
        return GeneralProductHelper.getBillingItems((List)prods, (FinanceDocumentsProperties)fdp, (boolean)noVat);
    }

    public String getBillingItemName(RailwayMcoProduct product, String relatedInvoiceNumber) {
        return this.createFinanceCapableProduct(product).getCommonPart();
    }

    public Collection<Traveller> getTravellers(RailwayMcoProduct product) {
        return product.getPassengers();
    }

    public void replaceTraveller(RailwayMcoProduct product, Traveller oldTraveller, Traveller newTraveller) {
        Collections.replaceAll(product.getPassengers(), oldTraveller, newTraveller);
        product.getFopDetalizations().values().stream().flatMap(detalization -> detalization.getComponents().stream()).forEach(component -> {
            if (oldTraveller.equals((Object)component.getTraveller())) {
                component.setTraveller(newTraveller);
            }
        });
        if (product.getStatisticalData() != null) {
            product.getStatisticalData().getTravellerCostCodes().stream().filter(tcc -> oldTraveller.equals((Object)tcc.getTraveller())).forEach(tcc -> tcc.setTraveller(newTraveller));
        }
    }

    public void setOrReplaceTraveller(RailwayMcoProduct product, Traveller oldTraveller, Traveller newTraveller) {
        if (oldTraveller == null) {
            product.getPassengers().add(newTraveller);
        } else {
            this.replaceTraveller(product, oldTraveller, newTraveller);
        }
    }

    public void updateBillingItems(Collection<BillingItem> items, List<RailwayMcoProduct> products) {
    }

    public EntityReference<SalesPoint> findSalesPoint(RailwayMcoProduct product) {
        return product.getSalesPoint();
    }

    public ProductStatus getStatus(RailwayMcoProduct product) {
        return product.getStatus();
    }

    public ProductStatus getBaseStatus(RailwayMcoProduct product) {
        return product.getStatus();
    }

    public void setStatus(RailwayMcoProduct product, ProductStatus productStatus) {
        product.setStatus(productStatus);
    }

    public ProductType getProductType(RailwayMcoProduct product) {
        return ProductType.RAILWAY_MCO;
    }

    public Set<ProductType> getAllProductTypes() {
        return Collections.unmodifiableSet(Stream.of(ProductType.RAILWAY_MCO).collect(Collectors.toSet()));
    }

    public RuleTarget getCommissionRuleTarget() {
        return Targets.RAILWAY_PRODUCT_COMMISSION;
    }

    public EntityReference<Organization> getBlankOwner(RailwayMcoProduct product) {
        return product.getBlankOwnerRef();
    }

    public EntityReference<Branch> getBranch(RailwayMcoProduct product) {
        return null;
    }

    public List<MCOFeesSource> getMcoFeesSources(RailwayMcoProduct product) {
        ArrayList<MCOFeesSource> res = new ArrayList<MCOFeesSource>();
        String equivCurrency = DictHelper.getCurrencyByAnyCode((String)DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, null));
        BigDecimal fareValue = RailwayMcoProductHelper.calculateTotalEquivalentFare(product);
        if (fareValue != null && fareValue.compareTo(BigDecimal.ZERO) > 0) {
            MCOFeesSource source = new MCOFeesSource();
            source.setTicketNumber(product.getSystemNumber());
            Money fare = new Money();
            fare.setValue(product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE ? MiscUtil.negate((BigDecimal)fareValue) : fareValue);
            fare.setCurrency(equivCurrency);
            source.setFare(fare);
            source.setIsTotalSum(true);
            source.setProductUid(product.getUid());
            source.setDescription(this.generateShortProductName(product));
            res.add(source);
        }
        for (GeneralProductCommission comm : RailwayMcoProductHelper.getUnmodifiableCommissions(product, ContractType.CLIENT)) {
            BaseCommissionProperties propBase = null;
            try {
                EntityContainer propCont = EntityStorage.get().resolve(comm.getCommissionProperties());
                if (propCont != null) {
                    propBase = (BaseCommissionProperties)propCont.getEntity();
                }
            }
            catch (Exception propCont) {
                // empty catch block
            }
            if (propBase == null || !(propBase instanceof FeeProperties) && !(propBase instanceof PaymentFeeProperties)) continue;
            MCOFeesSource sourceCommission = new MCOFeesSource();
            sourceCommission.setTicketNumber(product.getSystemNumber());
            Money fareComm = new Money();
            fareComm.setValue(product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE ? MiscUtil.negate((BigDecimal)comm.getEquivalentAmount()) : comm.getEquivalentAmount());
            fareComm.setCurrency(equivCurrency);
            sourceCommission.setFare(fareComm);
            sourceCommission.setIsTotalSum(false);
            sourceCommission.setProductUid(product.getUid());
            sourceCommission.setDescription(propBase.getDisplayName() + " - " + this.generateShortProductName(product));
            res.add(sourceCommission);
        }
        return res;
    }

    public boolean isCompleted(RailwayMcoProduct product) {
        return product.isCompleted();
    }

    public void setCompleted(RailwayMcoProduct product, boolean completed) {
        product.setCompleted(completed);
    }

    public boolean isChecked(RailwayMcoProduct product) {
        return product.isChecked();
    }

    public void setChecked(RailwayMcoProduct product, boolean checked) {
        product.setChecked(checked);
    }

    public TransportationType getTransportationType(RailwayMcoProduct product) {
        return RailwayMcoProductHelper.getTransportationType(product);
    }

    public ServiceLocationType getServiceLocationType(RailwayMcoProduct product) {
        return RailwayMcoProductHelper.getServiceLocationType(product);
    }

    public Date findNearestTravelDate(Date momentOfTime, RailwayMcoProduct product) {
        List segments = product.getSegments();
        if (segments == null) {
            return null;
        }
        for (RailwaySegment seg : segments) {
            if (momentOfTime.compareTo(seg.getDepartureDate()) > 0) continue;
            return seg.getDepartureDate();
        }
        return null;
    }

    public RailwayMcoProduct getPreviousProduct(RailwayMcoProduct product) {
        return product.getPreviousProduct();
    }

    public void setPreviousProduct(RailwayMcoProduct product, RailwayMcoProduct previousProduct) {
        product.setPreviousProduct(previousProduct);
    }

    public void setNextProduct(RailwayMcoProduct product, RailwayMcoProduct nextProduct) {
        product.setNextProduct(nextProduct);
    }

    public RailwayMcoProduct getNextProduct(RailwayMcoProduct product) {
        return product.getNextProduct();
    }

    public void addRelatedProduct(RailwayMcoProduct product, BaseProduct relatedProduct) {
        product.getRelatedProducts().add((RailwayProduct)relatedProduct);
    }

    public List<BaseProduct> getRelatedProducts(RailwayMcoProduct product) {
        return new ArrayList<BaseProduct>(product.getRelatedProducts());
    }

    public ProductCancellationDetails getCancellationDetails(RailwayMcoProduct product) {
        return null;
    }

    public ProductCategory getProductCategory(RailwayMcoProduct product) {
        return null;
    }

    public MCOCategory getMCOCategory(RailwayMcoProduct product) {
        return null;
    }

    public List<GeneralProductTax> getTaxes(RailwayMcoProduct product) {
        return Collections.emptyList();
    }

    public DictionaryReference<BlankType> getBlankType(RailwayMcoProduct product) {
        return product.getBlankType();
    }

    public BigDecimal getEquivalentFare(RailwayMcoProduct product) {
        return product.getEquivalentFare();
    }

    public BigDecimal getServiceFare(RailwayMcoProduct product) {
        return null;
    }

    public BigDecimal getPenalty(RailwayMcoProduct product) {
        return product.getPenaltyFare();
    }

    public int getConjunction(RailwayMcoProduct product) {
        return 0;
    }

    public String getRouteLine(RailwayMcoProduct product) {
        return RailwayMcoProductHelper.getRouteString(product);
    }

    public String getLocalizedRouteLine(RailwayMcoProduct product) {
        return RailwayMcoProductHelper.getRouteString(product);
    }

    public String getCodeRouteLine(RailwayMcoProduct product) {
        return RailwayProductHelper.getCodeRouteLine(product == null ? null : product.getSegments().stream());
    }

    public List<GeneralProductContractRelationData> getUnmodifiableContractRelations(RailwayMcoProduct product) {
        return RailwayMcoProductHelper.getContractRelations(product).stream().map(this::cloneRelationData).collect(Collectors.toCollection(ArrayList::new));
    }

    private GeneralProductContractRelationData cloneRelationData(GeneralProductContractRelationData source) {
        GeneralProductContractRelationData dest = new GeneralProductContractRelationData();
        dest.setUid(source.getUid());
        dest.setDescription(source.getDescription());
        try {
            XCloneModelHelper.copy((BaseEntity)source.getServiceData(), (BaseEntity)dest.getServiceData());
            XCloneModelHelper.copy((BaseEntity)source.getGeneralData(), (BaseEntity)dest.getGeneralData());
            dest.getCommissions().addAll(source.getCommissions());
            this.cloneFops(source, dest);
        }
        catch (Exception e) {
            throw new IllegalStateException("unable to clone entity ", e);
        }
        return dest;
    }

    private void cloneFops(GeneralProductContractRelationData item, GeneralProductContractRelationData generalData) throws Exception {
        for (GeneralProductFop fop : item.getFops()) {
            GeneralProductFop clonedFop = new GeneralProductFop();
            XCloneModelHelper.copy((BaseEntity)fop, (BaseEntity)clonedFop);
            generalData.getFops().add(clonedFop);
        }
    }

    public SalesChain getSalesChain(RailwayMcoProduct product) {
        return RailwayMcoProductHelper.getSalesChain(product);
    }

    public void updateContractRelations(RailwayMcoProduct product, List<GeneralProductContractRelationData> relations) {
        GeneralProductHelper.updateContractRelationsByReflection((BaseProduct)product, relations);
    }

    public TicketType getTicketType(RailwayMcoProduct product) {
        return product.getTicketType();
    }

    public void setTicketType(RailwayMcoProduct product, TicketType ticketType) {
        product.setTicketType(ticketType);
    }

    public String getPCC(RailwayMcoProduct product) {
        return product.getPcc();
    }

    public void updateProductFops(RailwayMcoProduct product) {
        GeneralProductHelper.updateProductFops((BaseProduct)product);
    }

    public void setContractRulesApplied(RailwayMcoProduct product, boolean value) {
        product.setContractRulesApplied(value);
    }

    public List<ValidationMessage> getValidationMessages(RailwayMcoProduct product) {
        return product.getValidationMessages();
    }

    public EntityReference<Organization> getProvider(RailwayMcoProduct product) {
        return product.getProvider();
    }

    public PassengerStatus getPassengerStatus(RailwayMcoProduct product) {
        for (GeneralProductFop fop : RailwayMcoProductHelper.getClientFops(product)) {
            if (fop.getType() != PaymentType.MTD || fop.getPassengerStatus() == null) continue;
            return fop.getPassengerStatus();
        }
        return null;
    }

    public boolean isHoldable(RailwayMcoProduct product) {
        return false;
    }

    public Date getUnholdDate(RailwayMcoProduct product) {
        return null;
    }

    public String getValidatorNumber(RailwayMcoProduct product) {
        return null;
    }

    @Deprecated
    public DictionaryReference<PassengerType> getPassengerType(RailwayMcoProduct product) {
        return RailwayMcoProductHelper.getMainPassengerType(product);
    }

    public DictionaryReference<PassengerType> getPassengerType(RailwayMcoProduct product, Traveller traveller) {
        return RailwayMcoProductHelper.getPassengerType(product, traveller);
    }

    public StatisticalData getStatisticalData(RailwayMcoProduct product) {
        return product.getStatisticalData();
    }

    public boolean isStatisticalDataAvailable(RailwayMcoProduct product) {
        return true;
    }

    public void newStatisticalData(RailwayMcoProduct product) {
        product.setStatisticalData(new StatisticalData());
    }

    public BigDecimal getAddCollect(RailwayMcoProduct product) {
        return null;
    }

    public TravelSubject getDefaultTravelSubject() {
        return null;
    }

    public RailwayMcoProduct newInstance() {
        return new RailwayMcoProduct();
    }

    public boolean isMultiTraveller() {
        return true;
    }

    public String getGdsCurrency(RailwayMcoProduct product) {
        return product.getGdsCurrency();
    }

    public String getCarrierNumber(RailwayMcoProduct product) {
        return product.getCarrierNumber();
    }

    public void setAgent(RailwayMcoProduct product, EntityReference<Person> agent) {
        product.setCashier(agent);
    }

    public void setComments(RailwayMcoProduct product, String comments) {
    }

    public void setAgency(RailwayMcoProduct product, EntityReference<Organization> agency) {
        RailwayMcoProductHelper.setAgency(product, agency);
    }

    public void setBlankOwner(RailwayMcoProduct product, EntityReference<Organization> blankOwner) {
        product.setBlankOwnerRef(blankOwner);
    }

    public void setBranch(RailwayMcoProduct product, EntityReference<Branch> branch) {
    }

    public void setSupplier(RailwayMcoProduct product, EntityReference<Organization> supplier) {
        RailwayMcoProductHelper.setSupplier(product, supplier);
    }

    public void setSubagency(RailwayMcoProduct product, EntityReference<Organization> subagency) {
        RailwayMcoProductHelper.setSubagency(product, subagency);
    }

    public void setSalesPoint(RailwayMcoProduct product, EntityReference<SalesPoint> salesPoint) {
        product.setSalesPoint(salesPoint);
    }

    public void changeFopsPaymentTypes(RailwayMcoProduct product, PaymentType paymentType, ContractType contractType, boolean updateOnlyFeeFops) {
        ArrayList<GeneralProductFop> fops = new ArrayList<GeneralProductFop>();
        switch (contractType) {
            case VENDOR: {
                fops.addAll(RailwayMcoProductHelper.getVendorFops(product));
                break;
            }
            case SUBAGENCY: {
                fops.addAll(RailwayMcoProductHelper.getSubagentFops(product, false));
                break;
            }
            case CLIENT: {
                fops.addAll(RailwayMcoProductHelper.getClientFops(product));
            }
        }
        GeneralProductHelper.changeFopsPaymentTypes(fops, (PaymentType)paymentType, (boolean)updateOnlyFeeFops);
    }

    public void changeFopsAgent(RailwayMcoProduct product, EntityReference<Person> agent, ContractType contractType) {
        List<GeneralProductFop> fops = this.getFops(product, contractType);
        fops.forEach(fop -> fop.setAgent(agent));
    }

    public List<String> getFopsUids(RailwayMcoProduct product, ContractType contractType) {
        return this.getFops(product, contractType).stream().map(BaseIdentity::getUid).collect(Collectors.toList());
    }

    private List<GeneralProductFop> getFops(RailwayMcoProduct product, ContractType contractType) {
        switch (contractType) {
            case VENDOR: {
                return RailwayMcoProductHelper.getVendorFops(product);
            }
            case SUBAGENCY: {
                return RailwayMcoProductHelper.getSubagentFops(product, false);
            }
            case CLIENT: {
                return RailwayMcoProductHelper.getClientFops(product);
            }
        }
        return Collections.emptyList();
    }

    public void setBlankType(RailwayMcoProduct product, DictionaryReference<BlankType> blankType) {
        product.setBlankType(blankType);
    }

    public Money getBspCommissionValue(RailwayMcoProduct product) {
        return null;
    }

    public Double getBspCommissionRate(RailwayMcoProduct product) {
        return null;
    }

    public boolean removeProduct(RailwayMcoProduct product) {
        return RailwayMcoProductHelper.removeProduct(product);
    }

    public boolean removeRelatedProduct(RailwayMcoProduct product, BaseProduct relatedProduct) {
        return RailwayMcoProductHelper.removeRelatedProduct(product, relatedProduct);
    }

    public boolean isAppropriateBillingItem(RailwayMcoProduct product, FinanceDocumentType type, UniversalDocumentStatus universalDocumentStatus, BillingItemIncludeMode mode, com.gridnine.xtrip.common.model.finance.BillingItem billingItem, List<com.gridnine.xtrip.common.model.finance.BillingItem> billingItems, List<com.gridnine.xtrip.common.model.finance.BillingItem> prepaymentBillingItems) {
        if (type == FinanceDocumentType.INVOICE_FACTURA || type == FinanceDocumentType.UNIVERSAL_DOCUMENT && universalDocumentStatus == UniversalDocumentStatus.ONE) {
            if (Optional.ofNullable(billingItem.getAmount()).map(VatAmount::getVat).orElse(null) == null) {
                return false;
            }
            if (billingItem.getServiceType() != ServiceType.FEE) {
                return false;
            }
        }
        if (type == FinanceDocumentType.STANDARD_BILL) {
            return billingItem.getServiceType() == ServiceType.TICKET || billingItem.getServiceType() == ServiceType.PENALTY;
        }
        if (type == FinanceDocumentType.ACCEPTANCE_CERTIFICATE && mode == BillingItemIncludeMode.ALL_EXCEPT_TICKET) {
            return billingItem.getServiceType() != ServiceType.TICKET && billingItem.getServiceType() != ServiceType.PENALTY;
        }
        if (type == FinanceDocumentType.INVOICE) {
            if (prepaymentBillingItems.isEmpty()) {
                return true;
            }
            ArrayList<com.gridnine.xtrip.common.model.finance.BillingItem> remainingList = new ArrayList<com.gridnine.xtrip.common.model.finance.BillingItem>(billingItems);
            remainingList.removeIf(item -> CollectionUtil.contains((Collection)prepaymentBillingItems, (Object)item, FinanceDocumentsHelper::isSameBillingItems));
            if (remainingList.isEmpty()) {
                return false;
            }
            if (!CollectionUtil.containsAll(billingItems, prepaymentBillingItems, FinanceDocumentsHelper::isSameBillingItems)) {
                return true;
            }
            return CollectionUtil.contains(remainingList, (Object)billingItem, FinanceDocumentsHelper::isSameBillingItems);
        }
        return true;
    }

    public boolean isVatIncludeBillingItem(RailwayMcoProduct product, VatViewMode mode, com.gridnine.xtrip.common.model.finance.BillingItem billingItem) {
        return mode == VatViewMode.ALWAYS || mode == VatViewMode.ALWAYS_EXCEPT_TICKET && billingItem.getServiceType() != ServiceType.TICKET && billingItem.getServiceType() != ServiceType.PENALTY;
    }

    public String getCities(RailwayMcoProduct product, Locale locale) {
        return RailwayMcoProductHelper.getCities(product, locale);
    }

    public String getCountries(RailwayMcoProduct product, Locale locale) {
        return RailwayMcoProductHelper.getCountries(product, locale);
    }

    public Date getFirstStartDate(RailwayMcoProduct product) {
        if (CollectionUtil.isEmpty((Collection)product.getSegments())) {
            return null;
        }
        List dates = product.getSegments().stream().map(RailwaySegment::getDepartureDate).collect(Collectors.toList());
        return dates.size() > 0 ? (Date)dates.get(0) : null;
    }

    public Date getLastStartDate(RailwayMcoProduct product) {
        if (CollectionUtil.isEmpty((Collection)product.getSegments())) {
            return null;
        }
        List dates = product.getSegments().stream().map(RailwaySegment::getDepartureDate).collect(Collectors.toList());
        return dates.size() > 0 ? (Date)dates.get(dates.size() - 1) : null;
    }

    public Date getFirstEndDate(RailwayMcoProduct product) {
        if (CollectionUtil.isEmpty((Collection)product.getSegments())) {
            return null;
        }
        List dates = product.getSegments().stream().map(RailwaySegment::getArriveDate).collect(Collectors.toList());
        return dates.size() > 0 ? (Date)dates.get(0) : null;
    }

    public Date getLastEndDate(RailwayMcoProduct product) {
        if (CollectionUtil.isEmpty((Collection)product.getSegments())) {
            return null;
        }
        List dates = product.getSegments().stream().map(RailwaySegment::getArriveDate).collect(Collectors.toList());
        return dates.size() > 0 ? (Date)dates.get(dates.size() - 1) : null;
    }

    public String getDescriptionLine(RailwayMcoProduct product) {
        return null;
    }

    public DictionaryReference<Airline> getCarrier(RailwayMcoProduct product) {
        return null;
    }

    public String getTrain(RailwayMcoProduct product) {
        if (CollectionUtil.isEmpty((Collection)product.getSegments())) {
            return null;
        }
        List trains = product.getSegments().stream().map(item -> {
            StringBuilder train = new StringBuilder();
            if (!TextUtil.isBlank((String)item.getSlot())) {
                train.append(item.getSlot());
            }
            if (!TextUtil.isBlank((String)item.getTrainNumber())) {
                train.append(item.getTrainNumber());
            }
            return train.length() > 0 ? train.toString() : "?";
        }).collect(Collectors.toList());
        return trains.size() > 0 ? (String)trains.get(0) : null;
    }

    public boolean isContractRulesApplied(RailwayMcoProduct product) {
        return product.isContractRulesApplied();
    }

    public boolean isSystemNumberDuplicateAllowed(RailwayMcoProduct product) {
        return false;
    }

    public String getRfic(RailwayMcoProduct product) {
        return null;
    }

    public String getRfisc(RailwayMcoProduct product) {
        return null;
    }

    public String getTourCode(RailwayMcoProduct product) {
        return null;
    }

    public boolean isDuplicate(RailwayMcoProduct product) {
        return false;
    }

    public Set<String> getServiceClasses(RailwayMcoProduct product, Locale locale) {
        return product.getSegments().stream().map(RailwaySegment::getServiceClass).filter(Objects::nonNull).map(item -> item.toString(locale)).collect(Collectors.toSet());
    }
}

