/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.railway.handlers;

import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BaseTicketProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.FinanceDocument;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.GeneralProductTax;
import com.gridnine.xtrip.common.model.booking.MCOFeesSource;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.ProductCancellationDetails;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.ServiceLocationType;
import com.gridnine.xtrip.common.model.booking.ServiceType;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.VatDetalization;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.DiscountProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductFop;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.booking.railway.RailwayTax;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.PassengerStatus;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.dict.Principal;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.BillingItemIncludeMode;
import com.gridnine.xtrip.common.model.finance.UniversalDocumentStatus;
import com.gridnine.xtrip.common.model.finance.VatViewMode;
import com.gridnine.xtrip.common.model.fiscal.Supplier;
import com.gridnine.xtrip.common.model.handlers.PreferenceHelper;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Branch;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentsProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.railway.model.rules.standart.Targets;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.UUIDGenerator;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RailwayProductHandler
implements ProductHandler<RailwayProduct> {
    private static final String SEPARATOR = " ";
    private static final String GROUP_PLACE_HOLDER = "$group_string";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final List<ProductStatus> NEGATE_PRODUCT_STATUSES = Arrays.asList(ProductStatus.REFUND, ProductStatus.EXCHANGE);

    public Class<RailwayProduct> getProductClass() {
        return RailwayProduct.class;
    }

    public VatAmount calculateProductPrice(GeneralProductContractRelationData relation, RailwayProduct product) {
        BigDecimal totalVat;
        VatAmount vatAmount = new VatAmount();
        vatAmount.setTotalVat(BigDecimal.ZERO, 0.0);
        ProductStatus status = product.getStatus();
        if (ProductStatusHandler.getAllVoidStatuses().contains(status)) {
            return vatAmount;
        }
        boolean needNegate = NEGATE_PRODUCT_STATUSES.contains(status);
        BigDecimal bigDecimal = totalVat = product.getTotalEquivalentVAT() != null ? product.getTotalEquivalentVAT() : RailwayProductHelper.calculateTotalEquivalentVat(product);
        if (relation != null && relation.getServiceData().getTotalPrice() != null) {
            BigDecimal totalPrice = relation.getServiceData().getTotalPrice();
            if (needNegate) {
                totalPrice = totalPrice.negate();
            }
            vatAmount.setTotalVatAmount(totalPrice, totalVat != null && needNegate ? totalVat.negate() : totalVat);
            return vatAmount;
        }
        BigDecimal totalFare = RailwayProductHelper.calculateTotalEquivalentFare(product);
        if (needNegate) {
            if (totalFare != null) {
                totalFare = totalFare.negate();
            }
            if (totalVat != null) {
                totalVat = totalVat.negate();
            }
        }
        vatAmount.setTotalVatAmount(totalFare, totalVat);
        return vatAmount;
    }

    public VatAmount calculateProductPrice(RailwayProduct product, ContractType ctype) {
        for (GeneralProductContractRelationData data : this.getUnmodifiableContractRelations(product)) {
            if (GeneralProductHelper.getContractType((EntityReference)data.getDescription()) != ctype) continue;
            return this.calculateProductPrice(data, product);
        }
        return this.calculateProductPrice(null, product);
    }

    public String generateShortProductName(RailwayProduct product) {
        return RailwayProductHelper.getShortNameString(product);
    }

    public String generateProductName(RailwayProduct product) {
        return RailwayProductHelper.getNameString(product);
    }

    public Date findFirstTravelDate(RailwayProduct product) {
        Date firstTravelDate = null;
        for (RailwaySegment segment : product.getSegments()) {
            Date departureDate = segment.getDepartureDate();
            if (MiscUtil.compare((Date)departureDate, firstTravelDate, (boolean)false) != -1) continue;
            firstTravelDate = departureDate;
        }
        return firstTravelDate;
    }

    public Date findLastTravelDate(RailwayProduct product) {
        Date lastTravelDate = null;
        for (RailwaySegment segment : product.getSegments()) {
            Date arriveDate = segment.getArriveDate();
            if (MiscUtil.compare((Date)arriveDate, lastTravelDate, (boolean)true) != 1) continue;
            lastTravelDate = arriveDate;
        }
        return lastTravelDate;
    }

    public List<String> getProductNumbers(RailwayProduct product) {
        ArrayList<String> productNumbers = new ArrayList<String>();
        String systemNumber = product.getSystemNumber();
        if (!TextUtil.isBlank((String)systemNumber)) {
            productNumbers.add(systemNumber);
        }
        return productNumbers;
    }

    public EntityReference<Person> findIssuingAgent(RailwayProduct product) {
        return product.getCashier();
    }

    public TravelSubject findTravelSubject(RailwayProduct product) {
        return TravelSubject.RAILWAY;
    }

    public Date findIssueDate(RailwayProduct product) {
        return product.getIssueDate();
    }

    public Date findLocalIssueDate(RailwayProduct product) {
        return product.getLocalIssueDate();
    }

    public void setIssueDate(RailwayProduct product, Date issueDate) {
        product.setIssueDate(issueDate);
    }

    public boolean includeInFinanceDocuments(RailwayProduct product) {
        return product.getStatus() != ProductStatus.VOID;
    }

    public Set<FinanceDocument> getAppropriateFinanceDocuments(Collection<BaseProduct> baseProducts, List<FinanceDocument> financeDocuments) throws Exception {
        HashSet<RailwayProduct> products = new HashSet<RailwayProduct>();
        for (BaseProduct baseProduct : baseProducts) {
            if (!(baseProduct instanceof RailwayProduct)) continue;
            products.add((RailwayProduct)baseProduct);
        }
        boolean hasFees = false;
        boolean hasRefundFees = false;
        PaymentType paymentType = null;
        boolean isRefund = false;
        boolean hasIssuedTickets = false;
        block1: for (RailwayProduct product : products) {
            if (product.getStatus() == ProductStatus.SELL || product.getStatus() == ProductStatus.REFUND) {
                hasIssuedTickets = true;
            }
            if (product.getStatus() == ProductStatus.REFUND) {
                isRefund = true;
            }
            if (paymentType == null) {
                List<RailwayProductFop> clientFops = RailwayProductHelper.getClientFops(product);
                if (!clientFops.isEmpty()) {
                    for (RailwayProductFop fop : clientFops) {
                        if (fop.getType() == null || !fop.getCommissions().isEmpty()) continue;
                        paymentType = fop.getType();
                        break;
                    }
                } else {
                    for (RailwayProductFop fop : RailwayProductHelper.getVendorFops(product)) {
                        if (fop.getType() == null) continue;
                        paymentType = fop.getType();
                        break;
                    }
                }
            }
            if (hasFees && hasRefundFees) continue;
            for (GeneralProductCommission commission : GeneralProductHelper.filterCommissions(RailwayProductHelper.getUnmodifiableCommissions(product, null), (Set)GeneralProductHelper.feePropertyTypes, null, (Set)GeneralProductHelper.standardCommissionCategories)) {
                hasFees = true;
                if (!BookingHelper.isFeeForRefund((EntityReference)commission.getCommissionProperties())) continue;
                hasRefundFees = true;
                continue block1;
            }
        }
        HashSet<FinanceDocument> documents = new HashSet<FinanceDocument>();
        for (FinanceDocument financeDocument : financeDocuments) {
            FinanceDocumentType financeDocumentType = financeDocument.getType();
            if (financeDocumentType == FinanceDocumentType.ACCEPTANCE_CERTIFICATE && (!hasFees || isRefund && !hasRefundFees) || financeDocumentType == FinanceDocumentType.CASH_ORDER && (!isRefund || paymentType != PaymentType.CASH)) continue;
            documents.add(financeDocument);
        }
        return documents;
    }

    public Collection<com.gridnine.xtrip.common.model.booking.BillingItem> getBillingItems(List<BaseProduct> baseProducts, FinanceDocumentsProperties fdp, boolean noVat) throws Exception {
        ArrayList<RailwayProduct> products = new ArrayList<RailwayProduct>();
        for (BaseProduct baseProduct : baseProducts) {
            if (!(baseProduct instanceof RailwayProduct)) continue;
            products.add((RailwayProduct)baseProduct);
        }
        HashMap tickets = new HashMap();
        HashMap penalties = new HashMap();
        HashMap fees = new HashMap();
        HashMap discounts = new HashMap();
        ArrayList<com.gridnine.xtrip.common.model.booking.BillingItem> billingItems = new ArrayList<com.gridnine.xtrip.common.model.booking.BillingItem>();
        for (RailwayProduct product : products) {
            String description = this.getDescription(product);
            FinanceDocumentsHelper.updateMap(tickets, (String)description, (Object)product);
            if (product.getPenalty() != null && product.getPenalty().compareTo(BigDecimal.ZERO) != 0) {
                FinanceDocumentsHelper.updateMap(penalties, (String)description, (Object)product);
            }
            ArrayList commissions = new ArrayList(GeneralProductHelper.filterCommissions(RailwayProductHelper.getUnmodifiableCommissions(product, ContractType.CLIENT), null, null, (Set)GeneralProductHelper.standardCommissionCategories));
            for (GeneralProductCommission commission : commissions) {
                CommissionData cData;
                EntityContainer commissionContainer;
                if (commission.getEquivalentAmount() == null || commission.getEquivalentAmount().compareTo(BigDecimal.ZERO) == 0 || (commissionContainer = EntityStorage.get().resolve(commission.getCommissionProperties())) == null) continue;
                if (FeeProperties.class.equals((Object)commissionContainer.getEntityType()) || PaymentFeeProperties.class.equals((Object)commissionContainer.getEntityType())) {
                    cData = new CommissionData(commission, product);
                    FinanceDocumentsHelper.updateMap(fees, (String)this.getDescription((EntityContainer<? extends BaseCommissionProperties>)commissionContainer, cData, noVat), (Object)cData);
                    continue;
                }
                if (!DiscountProperties.class.getName().equals(commissionContainer.getEntityType().getName())) continue;
                cData = new CommissionData(commission, product);
                FinanceDocumentsHelper.updateMap(discounts, (String)this.getDescription((EntityContainer<? extends BaseCommissionProperties>)commissionContainer, cData, noVat), (Object)cData);
            }
        }
        this.updateProductItems(billingItems, tickets.values(), noVat);
        this.updatePenalties(billingItems, penalties.values(), noVat);
        this.updateCommissions(billingItems, fees.values(), false, noVat);
        this.updateCommissions(billingItems, discounts.values(), true, noVat);
        return billingItems;
    }

    public String getBillingItemName(RailwayProduct product, String relatedInvoiceNumber) {
        return this.getTitle(product).replace(GROUP_PLACE_HOLDER, this.getGroupString(Collections.singletonList(product)));
    }

    private String getTitle(RailwayProduct product) {
        StringBuilder stringBuilder = new StringBuilder();
        if (product.getStatus() == ProductStatus.SELL || product.getStatus() == ProductStatus.REFUND) {
            String routeString;
            if (product.getStatus() == ProductStatus.SELL) {
                stringBuilder.append("\u0416/\u0414 \u0431\u0438\u043b\u0435\u0442");
            } else if (product.getStatus() == ProductStatus.REFUND) {
                stringBuilder.append("\u0412\u043e\u0437\u0432\u0440\u0430\u0442 \u0416/\u0414 \u0431\u0438\u043b\u0435\u0442\u0430");
            }
            if (product.isEticket()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(SEPARATOR);
                }
                stringBuilder.append("(\u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u044b\u0439 \u0431\u0438\u043b\u0435\u0442)");
            }
            if (TextUtil.isBlank((String)(routeString = RailwayProductHelper.getRouteString(product)))) {
                routeString = "?";
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append(SEPARATOR);
            }
            stringBuilder.append(String.format("\u043f\u043e \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0443 %s", routeString));
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            Date departureDate = RailwayProductHelper.getFirstDepartureDate(product);
            Date arriveDate = RailwayProductHelper.getLastArrivalDate(product);
            String datesString = departureDate != null && arriveDate != null && MiscUtil.equals((Object)MiscUtil.clearTime((Date)departureDate), (Object)MiscUtil.clearTime((Date)arriveDate)) ? LocaleManager.get().getCurrentLocaleData().getDateFormat().format(departureDate) : String.format("%s - %s", departureDate != null ? LocaleManager.get().getCurrentLocaleData().getDateFormat().format(departureDate) : "?", arriveDate != null ? LocaleManager.get().getCurrentLocaleData().getDateFormat().format(arriveDate) : "?");
            stringBuilder.append(datesString);
            stringBuilder.append(SEPARATOR);
            stringBuilder.append(String.format("(%s)", GROUP_PLACE_HOLDER));
        }
        return stringBuilder.toString();
    }

    private String getGroupString(List<RailwayProduct> products) {
        StringBuilder stringBuilder = new StringBuilder();
        for (RailwayProduct product : products) {
            String systemNumber = product.getSystemNumber();
            for (Traveller traveller : product.getPassengers()) {
                String travellerName;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                if (!TextUtil.isBlank((String)(travellerName = traveller.getName()))) {
                    stringBuilder.append(travellerName);
                } else {
                    stringBuilder.append("?");
                }
                if (!TextUtil.isBlank((String)systemNumber)) {
                    stringBuilder.append(String.format(": \u2116%s", systemNumber));
                    continue;
                }
                stringBuilder.append(": ?");
            }
        }
        return stringBuilder.toString();
    }

    private String getDescription(RailwayProduct product) {
        String title = this.getTitle(product);
        title = title + product.getUid();
        VatAmount money = this.calculateProductPrice(product, ContractType.CLIENT);
        return this.getDescription(title, money);
    }

    private String getDescription(EntityContainer<? extends BaseCommissionProperties> container, CommissionData data, boolean noVat) {
        VatAmount amount = new VatAmount();
        BigDecimal equivalentAmount = data.commission.getEquivalentAmount();
        amount.setTotalVat(equivalentAmount != null ? equivalentAmount : BigDecimal.ZERO, noVat ? 0.0 : MiscUtil.guarded((BigDecimal)DictHelper.getDefaultVat()).doubleValue());
        return this.getDescription(UUIDGenerator.generate((boolean)false).toString(), amount);
    }

    private String getDescription(String title, VatAmount money) {
        DecimalFormat priceFormat = LocaleManager.get().getCurrentLocaleData().getPriceFormat();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(title);
        stringBuilder.append("_");
        stringBuilder.append(money.getTotal() != null ? priceFormat.format(money.getTotal().doubleValue()) : "?");
        stringBuilder.append("_");
        stringBuilder.append(money.getVatAmount() != null ? priceFormat.format(money.getVatAmount().doubleValue()) : "?");
        return stringBuilder.toString();
    }

    private void updateProductItems(List<com.gridnine.xtrip.common.model.booking.BillingItem> billingItems, Collection<List<RailwayProduct>> lists, boolean noVat) {
        for (List<RailwayProduct> list : lists) {
            if (list.isEmpty()) continue;
            com.gridnine.xtrip.common.model.booking.BillingItem item = new com.gridnine.xtrip.common.model.booking.BillingItem();
            for (RailwayProduct product : list) {
                item.getProductUids().add(product.getUid());
            }
            item.setServiceType(ServiceType.TICKET);
            item.setName(this.getTitle(list.get(0)).replace(GROUP_PLACE_HOLDER, this.getGroupString(list)));
            BigDecimal total = BigDecimal.ZERO;
            BigDecimal vat = BigDecimal.ZERO;
            for (RailwayProduct product : list) {
                VatAmount price = this.calculateProductFopPrice(product);
                total = total.add(price.getTotal());
                vat = vat.add(price.getVatAmount());
            }
            ProductStatus status = list.get(0).getStatus();
            if (status == ProductStatus.REFUND || status == ProductStatus.EXCHANGE) {
                total = total.negate();
                vat = vat.negate();
            }
            VatAmount amount = new VatAmount();
            amount.setTotalVatAmount(total, vat);
            item.setAmount(amount);
            billingItems.add(item);
        }
    }

    private VatAmount calculateProductFopPrice(RailwayProduct product) {
        BigDecimal value = BigDecimal.ZERO;
        if (product.getStatus() == ProductStatus.BOOKING) {
            return BookingHelper.calculateProductPrice((BaseProduct)product, (ContractType)ContractType.CLIENT);
        }
        if (!ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) {
            List<RailwayProductFop> clientFops = RailwayProductHelper.getClientFops(product);
            if (!clientFops.isEmpty()) {
                for (RailwayProductFop fop : clientFops) {
                    if (fop.getAmount() == null || fop.getAmount().getValue() == null || !RailwayProductHelper.isServiceFop(fop)) continue;
                    value = value.add(fop.getAmount().getValue());
                }
            } else {
                for (RailwayProductFop fop : RailwayProductHelper.getVendorFops(product)) {
                    if (fop.getAmount() == null || fop.getAmount().getValue() == null) continue;
                    value = value.add(fop.getAmount().getValue());
                }
            }
            if (product.getPenalty() != null) {
                value = product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE ? value.add(product.getPenalty()) : value.subtract(product.getPenalty());
            }
            VatAmount result = new VatAmount();
            result.setTotalVatAmount(value, product.getTotalEquivalentVAT());
            return result;
        }
        VatAmount result = new VatAmount();
        result.setTotalVat(BigDecimal.ZERO, 0.0);
        return result;
    }

    private void updatePenalties(List<com.gridnine.xtrip.common.model.booking.BillingItem> billingItems, Collection<List<RailwayProduct>> lists, boolean noVat) {
        for (List<RailwayProduct> list : lists) {
            if (list.isEmpty()) continue;
            com.gridnine.xtrip.common.model.booking.BillingItem item = new com.gridnine.xtrip.common.model.booking.BillingItem();
            for (RailwayProduct product : list) {
                item.getProductUids().add(product.getUid());
            }
            item.setServiceType(ServiceType.PENALTY);
            item.setName("\u0428\u0442\u0440\u0430\u0444 \u0437\u0430 \u0432\u043e\u0437\u0432\u0440\u0430\u0442");
            BigDecimal total = BigDecimal.ZERO;
            BigDecimal vat = BigDecimal.ZERO;
            for (RailwayProduct product : list) {
                total = MiscUtil.sum((BigDecimal[])new BigDecimal[]{total, product.getPenalty()});
                vat = MiscUtil.sum((BigDecimal[])new BigDecimal[]{vat, product.getPenaltyVAT()});
            }
            VatAmount amount = new VatAmount();
            amount.setTotalVatAmount(total, vat);
            item.setAmount(amount);
            billingItems.add(item);
        }
    }

    private void updateCommissions(List<com.gridnine.xtrip.common.model.booking.BillingItem> billingItems, Collection<List<CommissionData>> lists, boolean discount, boolean noVat) {
        for (List<CommissionData> list : lists) {
            if (list.isEmpty()) continue;
            com.gridnine.xtrip.common.model.booking.BillingItem item = new com.gridnine.xtrip.common.model.booking.BillingItem();
            for (CommissionData commissionData : list) {
                item.getProductUids().add(commissionData.product.getUid());
            }
            item.setServiceType(discount ? ServiceType.DISCOUNT : ServiceType.FEE);
            item.setCommissionType(list.get((int)0).commission.getCommissionProperties());
            EntityContainer container = EntityStorage.get().resolve(list.get((int)0).commission.getCommissionProperties());
            BigDecimal coefficient = BigDecimal.ONE;
            if (container.getEntityType().getName().equals(FeeProperties.class.getName())) {
                FeeProperties feeProperties = (FeeProperties)container.getEntity();
                item.setName(feeProperties.getFinanceName());
            } else if (container.getEntityType().equals(PaymentFeeProperties.class)) {
                PaymentFeeProperties prop = (PaymentFeeProperties)container.getEntity();
                item.setName(prop.getFinanceName());
            } else {
                DiscountProperties discountProperties = (DiscountProperties)container.getEntity();
                item.setName(discountProperties.getFinanceName());
            }
            if (list.get((int)0).product.getStatus() == ProductStatus.REFUND) {
                coefficient = coefficient.negate();
            }
            BigDecimal total = BigDecimal.ZERO;
            ArrayList<RailwayProduct> products = new ArrayList<RailwayProduct>();
            for (CommissionData commissionData : list) {
                BigDecimal equivalentAmount = commissionData.commission.getEquivalentAmount();
                if (equivalentAmount != null) {
                    BigDecimal bigDecimal = total = discount ? total.subtract(equivalentAmount) : total.add(equivalentAmount);
                }
                if (commissionData.product == null || products.contains(commissionData.product)) continue;
                products.add(commissionData.product);
            }
            if (!TextUtil.isBlank((String)item.getName())) {
                item.setName(item.getName().replace("${air_tickets_info}", this.getGroupString(products)));
            }
            VatAmount amount = new VatAmount();
            amount.setTotalVat(coefficient.multiply(total), noVat ? 0.0 : MiscUtil.guarded((BigDecimal)DictHelper.getDefaultVat((Date)list.get((int)0).product.getIssueDate())).doubleValue());
            item.setAmount(amount);
            billingItems.add(item);
        }
    }

    public Collection<Traveller> getTravellers(RailwayProduct product) {
        return product.getPassengers();
    }

    public void replaceTraveller(RailwayProduct product, Traveller oldTraveller, Traveller newTraveller) {
        Collections.replaceAll(product.getPassengers(), oldTraveller, newTraveller);
        product.getPassengerTypes().forEach(type -> {
            if (oldTraveller.equals((Object)type.getTraveller())) {
                type.setTraveller(newTraveller);
            }
        });
        product.getFopDetalizations().values().stream().flatMap(detalization -> detalization.getComponents().stream()).forEach(component -> {
            if (oldTraveller.equals((Object)component.getTraveller())) {
                component.setTraveller(newTraveller);
            }
        });
        if (product.getStatisticalData() != null) {
            product.getStatisticalData().getTravellerCostCodes().stream().filter(tcc -> oldTraveller.equals((Object)tcc.getTraveller())).forEach(tcc -> tcc.setTraveller(newTraveller));
        }
    }

    public void setOrReplaceTraveller(RailwayProduct product, Traveller oldTraveller, Traveller newTraveller) {
        if (oldTraveller == null) {
            product.getPassengers().add(newTraveller);
        } else {
            this.replaceTraveller(product, oldTraveller, newTraveller);
        }
    }

    public void updateBillingItems(Collection<com.gridnine.xtrip.common.model.booking.BillingItem> items, List<RailwayProduct> products) {
    }

    public EntityReference<SalesPoint> findSalesPoint(RailwayProduct product) {
        return product.getSalesPoint();
    }

    public ProductStatus getStatus(RailwayProduct product) {
        return product.getStatus();
    }

    public ProductStatus getBaseStatus(RailwayProduct product) {
        return product.getStatus();
    }

    public void setStatus(RailwayProduct product, ProductStatus productStatus) {
        product.setStatus(productStatus);
    }

    public ProductType getProductType(RailwayProduct product) {
        return ProductType.RAILWAY_PRODUCT;
    }

    public Set<ProductType> getAllProductTypes() {
        return Collections.unmodifiableSet(Stream.of(ProductType.RAILWAY_PRODUCT).collect(Collectors.toSet()));
    }

    public RuleTarget getCommissionRuleTarget() {
        return Targets.RAILWAY_PRODUCT_COMMISSION;
    }

    public EntityReference<Organization> getBlankOwner(RailwayProduct product) {
        return product.getBlankOwnerRef();
    }

    public EntityReference<Branch> getBranch(RailwayProduct product) {
        return product.getBranch();
    }

    public List<MCOFeesSource> getMcoFeesSources(RailwayProduct product) {
        ArrayList<MCOFeesSource> res = new ArrayList<MCOFeesSource>();
        String equivCurrency = DictHelper.getCurrencyByAnyCode((String)DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, null));
        BigDecimal fareValue = RailwayProductHelper.calculateTotalEquivalentFare(product);
        if (fareValue != null && fareValue.compareTo(BigDecimal.ZERO) > 0) {
            MCOFeesSource source = new MCOFeesSource();
            source.setTicketNumber(product.getSystemNumber());
            Money fare = new Money();
            fare.setValue(product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE ? MiscUtil.negate((BigDecimal)fareValue) : fareValue);
            fare.setCurrency(equivCurrency);
            source.setFare(fare);
            source.setIsTotalSum(true);
            source.setProductUid(product.getUid());
            source.setDescription(this.generateShortProductName(product));
            res.add(source);
        }
        for (GeneralProductCommission comm : RailwayProductHelper.getUnmodifiableCommissions(product, ContractType.CLIENT)) {
            BaseCommissionProperties propBase = null;
            try {
                EntityContainer propCont = EntityStorage.get().resolve(comm.getCommissionProperties());
                if (propCont != null) {
                    propBase = (BaseCommissionProperties)propCont.getEntity();
                }
            }
            catch (Exception propCont) {
                // empty catch block
            }
            if (!(propBase instanceof FeeProperties) && !(propBase instanceof PaymentFeeProperties)) continue;
            MCOFeesSource sourceCommission = new MCOFeesSource();
            sourceCommission.setTicketNumber(product.getSystemNumber());
            Money fareComm = new Money();
            fareComm.setValue(product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE ? MiscUtil.negate((BigDecimal)comm.getEquivalentAmount()) : comm.getEquivalentAmount());
            fareComm.setCurrency(equivCurrency);
            sourceCommission.setFare(fareComm);
            sourceCommission.setIsTotalSum(false);
            sourceCommission.setProductUid(product.getUid());
            sourceCommission.setDescription(propBase.getDisplayName() + " - " + this.generateShortProductName(product));
            res.add(sourceCommission);
        }
        return res;
    }

    public boolean isCompleted(RailwayProduct product) {
        return product.isCompleted();
    }

    public void setCompleted(RailwayProduct product, boolean completed) {
        product.setCompleted(completed);
    }

    public boolean isChecked(RailwayProduct product) {
        return product.isChecked();
    }

    public void setChecked(RailwayProduct product, boolean checked) {
        product.setChecked(checked);
    }

    public TransportationType getTransportationType(RailwayProduct product) {
        return RailwayProductHelper.getTransportationType(product);
    }

    public ServiceLocationType getServiceLocationType(RailwayProduct product) {
        return RailwayProductHelper.getServiceLocationType(product);
    }

    public Date findNearestTravelDate(Date momentOfTime, RailwayProduct product) {
        for (RailwaySegment seg : product.getSegments()) {
            if (momentOfTime.compareTo(seg.getDepartureDate()) > 0) continue;
            return seg.getDepartureDate();
        }
        return null;
    }

    public RailwayProduct getPreviousProduct(RailwayProduct product) {
        return product.getPreviousProduct();
    }

    public void setPreviousProduct(RailwayProduct product, RailwayProduct previousProduct) {
        product.setPreviousProduct(previousProduct);
    }

    public void setNextProduct(RailwayProduct product, RailwayProduct nextProduct) {
        product.setNextProduct(nextProduct);
    }

    public RailwayProduct getNextProduct(RailwayProduct product) {
        return product.getNextProduct();
    }

    public void addRelatedProduct(RailwayProduct product, BaseProduct relatedProduct) {
        product.getRelatedProducts().add((RailwayProduct)relatedProduct);
    }

    public List<BaseProduct> getRelatedProducts(RailwayProduct product) {
        return new ArrayList<BaseProduct>(product.getRelatedProducts());
    }

    public ProductCancellationDetails getCancellationDetails(RailwayProduct product) {
        return product.getCancellationDetails();
    }

    public ProductCategory getProductCategory(RailwayProduct product) {
        return null;
    }

    public MCOCategory getMCOCategory(RailwayProduct product) {
        return null;
    }

    public List<GeneralProductTax> getTaxes(RailwayProduct product) {
        ArrayList<GeneralProductTax> taxes = new ArrayList<GeneralProductTax>();
        for (RailwayTax tax : product.getTaxes()) {
            taxes.add(RailwayProductHelper.toGeneralProductTax(tax));
        }
        return taxes;
    }

    public DictionaryReference<BlankType> getBlankType(RailwayProduct product) {
        return product.getBlankType();
    }

    public BigDecimal getEquivalentFare(RailwayProduct product) {
        return MiscUtil.sum((BigDecimal[])new BigDecimal[]{product.getEquivalentFare(), product.getServiceFare()});
    }

    public BigDecimal getOnlyEquivalentFare(RailwayProduct product) {
        return MiscUtil.guarded((BigDecimal)product.getEquivalentFare());
    }

    public BigDecimal getServiceFare(RailwayProduct product) {
        return MiscUtil.guarded((BigDecimal)product.getServiceFare());
    }

    public BigDecimal getPenalty(RailwayProduct product) {
        return product.getPenalty();
    }

    public BigDecimal getDeduction(RailwayProduct product) {
        return RailwayProductHelper.getDeduction(product);
    }

    public BigDecimal getDeductionVat(RailwayProduct product) {
        return RailwayProductHelper.getDeductionVat(product);
    }

    public int getConjunction(RailwayProduct product) {
        return 0;
    }

    public String getRouteLine(RailwayProduct product) {
        return RailwayProductHelper.getRouteString(product);
    }

    public String getLocalizedRouteLine(RailwayProduct product) {
        return RailwayProductHelper.getRouteString(product);
    }

    public String getCodeRouteLine(RailwayProduct product) {
        return RailwayProductHelper.getCodeRouteLine(product == null ? null : product.getSegments().stream());
    }

    public List<GeneralProductContractRelationData> getUnmodifiableContractRelations(RailwayProduct product) {
        ArrayList<GeneralProductContractRelationData> result = new ArrayList<GeneralProductContractRelationData>();
        for (RailwayProductContractRelationData item : RailwayProductHelper.getContractRelations(product)) {
            GeneralProductContractRelationData generalData = new GeneralProductContractRelationData();
            generalData.setUid(item.getUid());
            generalData.setDescription(item.getDescription());
            try {
                XCloneModelHelper.copy((BaseEntity)item.getServiceData(), (BaseEntity)generalData.getServiceData());
                XCloneModelHelper.copy((BaseEntity)item.getGeneralData(), (BaseEntity)generalData.getGeneralData());
            }
            catch (Exception e) {
                throw new IllegalStateException("unable to clone entity ", e);
            }
            generalData.getCommissions().addAll(item.getCommissions());
            for (RailwayProductFop fop : item.getFops()) {
                generalData.getFops().add(RailwayProductHelper.toGeneralProductFop(fop));
            }
            result.add(generalData);
        }
        return result;
    }

    public SalesChain getSalesChain(RailwayProduct product) {
        return RailwayProductHelper.getSalesChain((BaseProduct)product);
    }

    public void updateContractRelations(RailwayProduct product, List<GeneralProductContractRelationData> relations) {
        ArrayList<RailwayProductContractRelationData> result = new ArrayList<RailwayProductContractRelationData>();
        List<RailwayProductContractRelationData> originalRelations = RailwayProductHelper.getContractRelations(product);
        boolean updateRelations = originalRelations.size() != relations.size();
        for (GeneralProductContractRelationData generalProductRelation : relations) {
            RailwayProductContractRelationData relation = (RailwayProductContractRelationData)CollectionUtil.find(originalRelations, (String)generalProductRelation.getUid());
            if (relation == null) {
                relation = new RailwayProductContractRelationData();
                relation.setUid(generalProductRelation.getUid());
                relation.setDescription(generalProductRelation.getDescription());
                updateRelations = true;
            }
            result.add(relation);
            try {
                XCloneModelHelper.copy((BaseEntity)generalProductRelation.getGeneralData(), (BaseEntity)relation.getGeneralData());
                XCloneModelHelper.copy((BaseEntity)generalProductRelation.getServiceData(), (BaseEntity)relation.getServiceData());
            }
            catch (Exception e) {
                throw Xeption.forDeveloper((String)"unable to xcopy object", (Throwable)e, (Object[])new Object[0]);
            }
            GeneralProductHelper.updateCommissions((List)generalProductRelation.getCommissions(), (List)relation.getCommissions());
            ArrayList<RailwayProductFop> fops = new ArrayList<RailwayProductFop>();
            boolean updateFops = generalProductRelation.getFops().size() != relation.getFops().size();
            for (GeneralProductFop generalProductFop : generalProductRelation.getFops()) {
                RailwayProductFop fop = (RailwayProductFop)CollectionUtil.find((Iterable)relation.getFops(), (String)generalProductFop.getUid());
                if (fop == null) {
                    fop = new RailwayProductFop();
                    fop.setUid(generalProductFop.getUid());
                    updateFops = true;
                }
                fops.add(fop);
                fop.setType(generalProductFop.getType());
                fop.setCard(generalProductFop.getCard());
                fop.setRelatedTicketNumber(generalProductFop.getRelatedTicketNumber());
                if (fop.getAmount() == null) {
                    Money money = new Money();
                    money.setValue(BigDecimal.ZERO);
                    money.setCurrency(DictHelper.getLocalCurrency());
                    fop.setAmount(money);
                }
                fop.getAmount().setValue(generalProductFop.getEquivalentAmount());
                fop.getAmount().setCurrency(generalProductRelation.getGeneralData().getCurrency() != null ? generalProductRelation.getGeneralData().getCurrency().getCode() : DictHelper.getLocalCurrency());
                fop.setOperationDate(generalProductFop.getOperationDate());
                fop.setAgent(generalProductFop.getAgent());
                fop.setRefused(generalProductFop.isRefused());
                fop.setPayer(generalProductFop.getPayer());
                fop.getCommissions().clear();
                for (GeneralProductCommission generalProductCommission : generalProductFop.getCommissions()) {
                    GeneralProductCommission commission = (GeneralProductCommission)BookingHelper.findEntityByUid((Collection)relation.getCommissions(), (String)generalProductCommission.getUid());
                    if (commission == null) continue;
                    fop.getCommissions().add(commission);
                }
            }
            if (!updateFops) continue;
            relation.getFops().clear();
            relation.getFops().addAll(fops);
        }
        if (updateRelations) {
            originalRelations.clear();
            originalRelations.addAll(result);
        }
    }

    public TicketType getTicketType(RailwayProduct product) {
        return product.getTicketType();
    }

    public void setTicketType(RailwayProduct product, TicketType ticketType) {
        product.setTicketType(ticketType);
    }

    public String getPCC(RailwayProduct product) {
        return product.getPcc();
    }

    public void updateProductFops(RailwayProduct product) {
        RailwayProductHelper.updateProductFops(product);
    }

    public void setContractRulesApplied(RailwayProduct product, boolean value) {
        product.setContractRulesApplied(value);
    }

    public List<ValidationMessage> getValidationMessages(RailwayProduct product) {
        return product.getValidationMessages();
    }

    public EntityReference<Organization> getProvider(RailwayProduct product) {
        return product.getProvider();
    }

    public PassengerStatus getPassengerStatus(RailwayProduct product) {
        for (RailwayProductFop fop : RailwayProductHelper.getClientFops(product)) {
            if (fop.getType() != PaymentType.MTD || fop.getPassengerStatus() == null) continue;
            return fop.getPassengerStatus();
        }
        return null;
    }

    public boolean isHoldable(RailwayProduct product) {
        return false;
    }

    public Date getUnholdDate(RailwayProduct product) {
        return null;
    }

    public String getValidatorNumber(RailwayProduct product) {
        return product.getValidatorCode();
    }

    @Deprecated
    public DictionaryReference<PassengerType> getPassengerType(RailwayProduct product) {
        return RailwayProductHelper.getMainPassengerType(product);
    }

    public DictionaryReference<PassengerType> getPassengerType(RailwayProduct product, Traveller traveller) {
        return RailwayProductHelper.getPassengerType(product, traveller);
    }

    public StatisticalData getStatisticalData(RailwayProduct product) {
        return product.getStatisticalData();
    }

    public boolean isStatisticalDataAvailable(RailwayProduct product) {
        return true;
    }

    public void newStatisticalData(RailwayProduct product) {
        product.setStatisticalData(new StatisticalData());
    }

    public BigDecimal getAddCollect(RailwayProduct product) {
        return null;
    }

    public VatDetalization getVendorVatDetalization(RailwayProduct product) {
        return product.getVendorVatDetalization();
    }

    public TravelSubject getDefaultTravelSubject() {
        return TravelSubject.RAILWAY;
    }

    public RailwayProduct newInstance() {
        return new RailwayProduct();
    }

    public boolean isMultiTraveller() {
        return true;
    }

    public String getGdsCurrency(RailwayProduct product) {
        return product.getGdsCurrency();
    }

    public String getCarrierNumber(RailwayProduct product) {
        return product.getCarrierNumber();
    }

    public Supplier getFiscalSupplier(RailwayProduct product) {
        Principal principal = (Principal)DictHelper.resolve((DictionaryReference)product.getCarrier());
        if (principal != null) {
            String principalName = principal.getTranslations().entrySet().stream().filter(entry -> LocaleHelper.RU_LOCALE.getLanguage().equals(((Locale)entry.getKey()).getLanguage())).map(Map.Entry::getValue).findFirst().orElse((String)principal.getTranslations().get(LocaleHelper.EN_LOCALE));
            Supplier supplier = new Supplier();
            supplier.setName(principalName);
            supplier.setPhoneNum(principal.getPhone());
            supplier.setINN(principal.getRegistrationId());
            return supplier;
        }
        return null;
    }

    public void setAgent(RailwayProduct product, EntityReference<Person> agent) {
        product.setCashier(agent);
    }

    public void setComments(RailwayProduct product, String comments) {
        product.setComments(comments);
    }

    public void setAgency(RailwayProduct product, EntityReference<Organization> agency) {
        RailwayProductHelper.setAgency((BaseTicketProduct)product, agency);
    }

    public void setBlankOwner(RailwayProduct product, EntityReference<Organization> blankOwner) {
        product.setBlankOwnerRef(blankOwner);
    }

    public void setBranch(RailwayProduct product, EntityReference<Branch> branch) {
        product.setBranch(branch);
    }

    public void setSupplier(RailwayProduct product, EntityReference<Organization> supplier) {
        RailwayProductHelper.setSupplier((BaseTicketProduct)product, supplier);
    }

    public void setSubagency(RailwayProduct product, EntityReference<Organization> subagency) {
        RailwayProductHelper.setSubagency((BaseTicketProduct)product, subagency);
    }

    public void setSalesPoint(RailwayProduct product, EntityReference<SalesPoint> salesPoint) {
        product.setSalesPoint(salesPoint);
    }

    public void setValidatorCode(RailwayProduct product, String code) {
        product.setValidatorCode(code);
    }

    public void changeFopsPaymentTypes(RailwayProduct product, PaymentType paymentType, ContractType contractType, boolean updateOnlyFeeFops) {
        ArrayList<RailwayProductFop> fops = new ArrayList<RailwayProductFop>();
        switch (contractType) {
            case VENDOR: {
                fops.addAll(RailwayProductHelper.getVendorFops(product));
                break;
            }
            case SUBAGENCY: {
                fops.addAll(RailwayProductHelper.getSubagentFops(product, false));
                break;
            }
            case CLIENT: {
                fops.addAll(RailwayProductHelper.getClientFops(product));
            }
        }
        RailwayProductHelper.changeFopsPaymentTypes(fops, paymentType, updateOnlyFeeFops);
    }

    public void changeFopsAgent(RailwayProduct product, EntityReference<Person> agent, ContractType contractType) {
        List<RailwayProductFop> fops = this.getFops(product, contractType);
        fops.forEach(fop -> fop.setAgent(agent));
    }

    public List<String> getFopsUids(RailwayProduct product, ContractType contractType) {
        return this.getFops(product, contractType).stream().map(BaseIdentity::getUid).collect(Collectors.toList());
    }

    private List<RailwayProductFop> getFops(RailwayProduct product, ContractType contractType) {
        switch (contractType) {
            case VENDOR: {
                return RailwayProductHelper.getVendorFops(product);
            }
            case SUBAGENCY: {
                return RailwayProductHelper.getSubagentFops(product, false);
            }
            case CLIENT: {
                return RailwayProductHelper.getClientFops(product);
            }
        }
        return Collections.emptyList();
    }

    public void setBlankType(RailwayProduct product, DictionaryReference<BlankType> blankType) {
        product.setBlankType(blankType);
    }

    public Money getBspCommissionValue(RailwayProduct product) {
        return null;
    }

    public Double getBspCommissionRate(RailwayProduct product) {
        return null;
    }

    public boolean removeProduct(RailwayProduct product) {
        return RailwayProductHelper.removeProduct(product);
    }

    public boolean removeRelatedProduct(RailwayProduct product, BaseProduct relatedProduct) {
        return RailwayProductHelper.removeRelatedProduct(product, relatedProduct);
    }

    public Money getProductEquivalentFare(RailwayProduct product) {
        BigDecimal equivalentFare = this.getOnlyEquivalentFare(product);
        if (null == equivalentFare) {
            return null;
        }
        Money fare = new Money();
        fare.setValue(equivalentFare);
        fare.setCurrency((String)MiscUtil.guarded((Object)this.getGdsCurrency(product), (Object)PreferenceHelper.getLocalCurrency()));
        return fare;
    }

    public BigDecimal getAdditionalFeeEquivalentAmount(RailwayProduct product) {
        return MiscUtil.guarded((BigDecimal)product.getServiceFare());
    }

    public Money getAdditionalFee(RailwayProduct product) {
        BigDecimal additionalFee = this.getServiceFare(product);
        if (null == additionalFee) {
            return null;
        }
        Money fare = new Money();
        fare.setValue(additionalFee);
        fare.setCurrency((String)MiscUtil.guarded((Object)this.getGdsCurrency(product), (Object)PreferenceHelper.getLocalCurrency()));
        return fare;
    }

    public boolean isAppropriateBillingItem(RailwayProduct product, FinanceDocumentType type, UniversalDocumentStatus universalDocumentStatus, BillingItemIncludeMode mode, BillingItem billingItem, List<BillingItem> billingItems, List<BillingItem> prepaymentBillingItems) {
        if (type == FinanceDocumentType.INVOICE_FACTURA || type == FinanceDocumentType.UNIVERSAL_DOCUMENT && universalDocumentStatus == UniversalDocumentStatus.ONE) {
            if (Optional.ofNullable(billingItem.getAmount()).map(VatAmount::getVat).orElse(null) == null) {
                return false;
            }
            if (billingItem.getServiceType() != ServiceType.FEE) {
                return false;
            }
        }
        if (type == FinanceDocumentType.STANDARD_BILL) {
            return billingItem.getServiceType() == ServiceType.TICKET || billingItem.getServiceType() == ServiceType.PENALTY;
        }
        if (type == FinanceDocumentType.ACCEPTANCE_CERTIFICATE && mode == BillingItemIncludeMode.ALL_EXCEPT_TICKET) {
            return billingItem.getServiceType() != ServiceType.TICKET && billingItem.getServiceType() != ServiceType.PENALTY;
        }
        return true;
    }

    public boolean isVatIncludeBillingItem(RailwayProduct product, VatViewMode mode, BillingItem billingItem) {
        return mode == VatViewMode.ALWAYS || mode == VatViewMode.ALWAYS_EXCEPT_TICKET && billingItem.getServiceType() != ServiceType.TICKET && billingItem.getServiceType() != ServiceType.PENALTY;
    }

    public String getCities(RailwayProduct product, Locale locale) {
        return RailwayProductHelper.getCities(product, locale);
    }

    public String getCountries(RailwayProduct product, Locale locale) {
        return RailwayProductHelper.getCountries(product, locale);
    }

    public Date getFirstStartDate(RailwayProduct product) {
        List dates = product.getSegments().stream().map(RailwaySegment::getDepartureDate).collect(Collectors.toList());
        return dates.size() > 0 ? (Date)dates.get(0) : null;
    }

    public Date getLastStartDate(RailwayProduct product) {
        List dates = product.getSegments().stream().map(RailwaySegment::getDepartureDate).collect(Collectors.toList());
        return dates.size() > 0 ? (Date)dates.get(dates.size() - 1) : null;
    }

    public Date getFirstEndDate(RailwayProduct product) {
        List dates = product.getSegments().stream().map(RailwaySegment::getArriveDate).collect(Collectors.toList());
        return dates.size() > 0 ? (Date)dates.get(0) : null;
    }

    public Date getLastEndDate(RailwayProduct product) {
        List dates = product.getSegments().stream().map(RailwaySegment::getArriveDate).collect(Collectors.toList());
        return dates.size() > 0 ? (Date)dates.get(dates.size() - 1) : null;
    }

    public String getDescriptionLine(RailwayProduct product) {
        return null;
    }

    public DictionaryReference<Airline> getCarrier(RailwayProduct product) {
        return null;
    }

    public String getTrain(RailwayProduct product) {
        List trains = product.getSegments().stream().map(item -> {
            StringBuilder train = new StringBuilder();
            if (!TextUtil.isBlank((String)item.getSlot())) {
                train.append(item.getSlot());
            }
            if (!TextUtil.isBlank((String)item.getTrainNumber())) {
                train.append(item.getTrainNumber());
            }
            return train.length() > 0 ? train.toString() : "?";
        }).collect(Collectors.toList());
        return trains.size() > 0 ? (String)trains.get(0) : null;
    }

    public boolean isContractRulesApplied(RailwayProduct product) {
        return product.isContractRulesApplied();
    }

    public boolean isSystemNumberDuplicateAllowed(RailwayProduct product) {
        return false;
    }

    public String getRfic(RailwayProduct product) {
        return null;
    }

    public String getRfisc(RailwayProduct product) {
        return null;
    }

    public String getTourCode(RailwayProduct product) {
        return null;
    }

    public boolean isDuplicate(RailwayProduct product) {
        return false;
    }

    public DictionaryReference<Principal> getPrincipal(RailwayProduct product) {
        return product.getCarrier();
    }

    public Set<String> getServiceClasses(RailwayProduct product, Locale locale) {
        return product.getSegments().stream().map(RailwaySegment::getServiceClass).filter(Objects::nonNull).map(item -> item.toString(locale)).collect(Collectors.toSet());
    }

    private static final class CommissionData {
        public RailwayProduct product;
        public GeneralProductCommission commission;

        public CommissionData(GeneralProductCommission commission, RailwayProduct product) {
            this.commission = commission;
            this.product = product;
        }
    }
}

