/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.railway.handlers;

import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveAccountingLineData;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveAccountingLineType;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassivePassengerData;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveProductData;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveRemarkData;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveSegmentData;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveSegmentType;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveSegmentsClientMode;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveSegmentsResult;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveSegmentsSubagencyMode;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveSegmentsXIData;
import com.gridnine.xtrip.common.model.booking.railway.CarriageType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.booking.railway.ServiceClass;
import com.gridnine.xtrip.common.model.dict.BlankCategory;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.railway.RailwayCarrier;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.gds.sabre.passivesegments.SabrePassiveSegmentsUtil;
import com.gridnine.xtrip.common.model.handlers.ProductPassiveSegmentsHandler;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.TranslitUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.joda.time.Months;
import org.joda.time.ReadableInstant;
import org.joda.time.Years;

public class RailwayProductPassiveSegmentsHandler
implements ProductPassiveSegmentsHandler<RailwayProduct> {
    private static Map<ServiceClass, String> serviceClass2String = new HashMap<ServiceClass, String>(){
        {
            this.put(ServiceClass.A1, "1A");
            this.put(ServiceClass.B1, "1B");
            this.put(ServiceClass.V1, "1V");
            this.put(ServiceClass.G1, "1G");
            this.put(ServiceClass.D1, "1D");
            this.put(ServiceClass.E1, "1E");
            this.put(ServiceClass.I1, "1I");
            this.put(ServiceClass.L1, "1L");
            this.put(ServiceClass.M1, "1M");
            this.put(ServiceClass.N1, "1N");
            this.put(ServiceClass.R1, "1R");
            this.put(ServiceClass.S1, "1S");
            this.put(ServiceClass.U1, "1U");
            this.put(ServiceClass.EE1, "1Y");
            this.put(ServiceClass.A2, "2A");
            this.put(ServiceClass.B2, "2B");
            this.put(ServiceClass.V2, "2V");
            this.put(ServiceClass.D2, "2D");
            this.put(ServiceClass.E2, "2E");
            this.put(ServiceClass.I2, "2I");
            this.put(ServiceClass.K2, "2K");
            this.put(ServiceClass.L2, "2L");
            this.put(ServiceClass.M2, "2M");
            this.put(ServiceClass.R2, "2R");
            this.put(ServiceClass.S2, "2S");
            this.put(ServiceClass.T2, "2T");
            this.put(ServiceClass.U2, "2U");
            this.put(ServiceClass.EE2, "2Y");
            this.put(ServiceClass.V3, "3V");
            this.put(ServiceClass.D3, "3D");
            this.put(ServiceClass.J3, "3Z");
            this.put(ServiceClass.L3, "3L");
            this.put(ServiceClass.O3, "3O");
            this.put(ServiceClass.P3, "3P");
            this.put(ServiceClass.R3, "3R");
            this.put(ServiceClass.S3, "3S");
            this.put(ServiceClass.T3, "3T");
            this.put(ServiceClass.U3, "3U");
            this.put(ServiceClass.EE3, "3Y");
        }
    };
    private static Map<ServiceClass, String> serviceClass2GeneralClass = new HashMap<ServiceClass, String>(){
        {
            this.put(ServiceClass.A1, "FIRST");
            this.put(ServiceClass.B1, "FIRST");
            this.put(ServiceClass.V1, "FIRST");
            this.put(ServiceClass.G1, "FIRST");
            this.put(ServiceClass.D1, "FIRST");
            this.put(ServiceClass.E1, "FIRST");
            this.put(ServiceClass.I1, "FIRST");
            this.put(ServiceClass.L1, "FIRST");
            this.put(ServiceClass.M1, "FIRST");
            this.put(ServiceClass.N1, "FIRST");
            this.put(ServiceClass.R1, "FIRST");
            this.put(ServiceClass.S1, "FIRST");
            this.put(ServiceClass.U1, "FIRST");
            this.put(ServiceClass.EE1, "FIRST");
            this.put(ServiceClass.B2, "SECOND");
            this.put(ServiceClass.V2, "SECOND");
            this.put(ServiceClass.D2, "THIRD");
            this.put(ServiceClass.E2, "SECOND");
            this.put(ServiceClass.I2, "SECOND");
            this.put(ServiceClass.K2, "SECOND");
            this.put(ServiceClass.L2, "SECOND");
            this.put(ServiceClass.M2, "SECOND");
            this.put(ServiceClass.R2, "SECOND");
            this.put(ServiceClass.S2, "SECOND");
            this.put(ServiceClass.T2, "SECOND");
            this.put(ServiceClass.U2, "SECOND");
            this.put(ServiceClass.V3, "THIRD");
            this.put(ServiceClass.D3, "THIRD");
            this.put(ServiceClass.J3, "THIRD");
            this.put(ServiceClass.L3, "THIRD");
            this.put(ServiceClass.O3, "THIRD");
            this.put(ServiceClass.P3, "THIRD");
            this.put(ServiceClass.R3, "THIRD");
            this.put(ServiceClass.S3, "THIRD");
            this.put(ServiceClass.T3, "THIRD");
            this.put(ServiceClass.U3, "THIRD");
            this.put(ServiceClass.EE3, "THIRD");
        }
    };
    private static Map<CarriageType, String> carriageType2String = new HashMap<CarriageType, String>(){
        {
            this.put(CarriageType.K, "K");
            this.put(CarriageType.L, "L");
            this.put(CarriageType.M, "M");
            this.put(CarriageType.O, "O");
            this.put(CarriageType.P, "P");
            this.put(CarriageType.S, "S");
        }
    };
    private static Map<GdsName, String> gdsName2String = new HashMap<GdsName, String>(){
        {
            this.put(GdsName.SIRENA, "SIRENA TRAVEL");
            this.put(GdsName.SPGD, "SPGD");
            this.put(GdsName.EXPRESS, "EXPRESS");
            this.put(GdsName.UFS, "UFS");
            this.put(GdsName.TELETRAIN, "TELETRAIN");
            this.put(GdsName.INMOB, "INMOB");
            this.put(GdsName.WEB_SITE, "WEB");
        }
    };

    public Class<RailwayProduct> getProductClass() {
        return RailwayProduct.class;
    }

    public boolean isAcceptableForPassiveSegmentsCreation(RailwayProduct product, List<Message> messages) {
        if (product == null) {
            messages.add(MessageHelper.createErrorMessage((String)Messages.sabrePassiveSegmentsValidationEmptyProduct, (Object[])new Object[0]));
            return false;
        }
        if (product.getStatus() != ProductStatus.SELL) {
            messages.add(MessageHelper.createErrorMessage((String)Messages.sabrePassiveSegmentsValidationInvalidProductStatusDetails, (Object[])new Object[]{product.getStatus().toString()}));
            return false;
        }
        if (product.getReservation() == null) {
            messages.add(MessageHelper.createErrorMessage((String)Messages.sabrePassiveSegmentsValidationEmptyReservationDetails, (Object[])new Object[]{product.getSystemNumber()}));
            return false;
        }
        if (CommonReservationGdsNameInfoHelper.getDisplayedGdsName((Reservation)product.getReservation()) == GdsName.SABRE) {
            messages.add(MessageHelper.createErrorMessage((String)Messages.sabrePassiveSegmentsValidationSabreGdsDetails, (Object[])new Object[]{product.getSystemNumber()}));
            return false;
        }
        if (product.getNextProduct() != null) {
            messages.add(MessageHelper.createErrorMessage((String)Messages.sabrePassiveSegmentsValidationHasNextProductDetails, (Object[])new Object[]{product.getSystemNumber()}));
            return false;
        }
        if (product.getPassengers().size() != 1) {
            messages.add(MessageHelper.createErrorMessage((String)Messages.sabrePassiveSegmentsValidationNotSingleTravellerDetails, (Object[])new Object[]{product.getSystemNumber()}));
            return false;
        }
        if (product.getSegments().size() != 1) {
            messages.add(MessageHelper.createErrorMessage((String)Messages.sabrePassiveSegmentsValidationNotSingleSegmentDetails, (Object[])new Object[]{product.getSystemNumber()}));
            return false;
        }
        for (RailwaySegment segment : product.getSegments()) {
            if (segment.getDepartureDate() == null) {
                messages.add(MessageHelper.createErrorMessage((String)Messages.sabrePassiveSegmentsValidationEmptyStartDateDetails, (Object[])new Object[]{product.getSystemNumber(), segment.getNumber()}));
                return false;
            }
            if (!segment.getDepartureDate().before(new Date())) continue;
            messages.add(MessageHelper.createErrorMessage((String)Messages.sabrePassiveSegmentsValidationStartDateIsBeforeCurrentDateDetails, (Object[])new Object[]{product.getSystemNumber(), segment.getNumber()}));
            return false;
        }
        return true;
    }

    public boolean validateProducts(List<RailwayProduct> products, List<Message> incomingMessages) {
        if (this.getSeatsAmount(products) < 1L) {
            incomingMessages.add(MessageHelper.createErrorMessage((String)Messages.sabrePassiveSegmentsZeroPassengers, (Object[])new Object[0]));
            return false;
        }
        ArrayList<Message> messages = new ArrayList<Message>();
        for (RailwayProduct p : products) {
            for (RailwaySegment seg : p.getSegments()) {
                if (seg.getDepartureDate() == null) {
                    messages.add(MessageHelper.createErrorMessage((String)Messages.sabrePassiveSegmentsValidationEmptyStartDateDetails, (Object[])new Object[]{p.getSystemNumber(), seg.getNumber()}));
                }
                if (seg.getDepartureStation() == null) {
                    messages.add(MessageHelper.createErrorMessage((String)Messages.sabrePassiveSegmentsValidationEmptyDepartureLocationDetails, (Object[])new Object[]{p.getSystemNumber(), seg.getNumber()}));
                }
                if (seg.getArriveStation() != null) continue;
                messages.add(MessageHelper.createErrorMessage((String)Messages.sabrePassiveSegmentsValidationEmptyArriveLocationDetails, (Object[])new Object[]{p.getSystemNumber(), seg.getNumber()}));
            }
        }
        if (!messages.isEmpty()) {
            incomingMessages.addAll(messages);
            return false;
        }
        return true;
    }

    public SabrePassiveProductData getSabrePassiveData(List<RailwayProduct> originalProducts, SabrePassiveSegmentsClientMode clientMode, SabrePassiveSegmentsSubagencyMode subagencyMode, List<Message> messages, boolean throwException) {
        SabrePassiveProductData data = new SabrePassiveProductData();
        List<SegmentWrapper> segmentWrappers = this.groupProductsBySegments(originalProducts);
        Map<String, String> product2Num = this.assignProductNumbers(originalProducts);
        HashSet<String> usedProductsUids = new HashSet<String>();
        for (SegmentWrapper sw : segmentWrappers) {
            RailwaySegment s = sw.getSegment();
            List<RailwayProduct> products = sw.getProducts();
            TranslitUtil.TranslitRules rules = TranslitUtil.TranslitRules.GOST_52535_1_2006;
            TranslitUtil.TranslitRules rulesRecloc = sw.getGdsName() == GdsName.SIRENA ? TranslitUtil.TranslitRules.SIRENA_REDAPP_RULES : TranslitUtil.TranslitRules.GOST_52535_1_2006;
            String originalLocator = sw.getGdsRecloc();
            String locator = SabrePassiveSegmentsUtil.getTranslation((String)originalLocator, (TranslitUtil.TranslitRules)rulesRecloc);
            SabrePassiveSegmentData seg = new SabrePassiveSegmentData();
            seg.setSegmentType(SabrePassiveSegmentType.RAIL);
            seg.setArrivalCode(this.getStationNameAndCode((DictionaryReference<RailwayStation>)s.getArriveStation()));
            seg.setDepartureCode(this.getStationNameAndCode((DictionaryReference<RailwayStation>)s.getDepartureStation()));
            seg.setStartDate(s.getDepartureDate());
            String seatsAmount = String.valueOf(this.getSeatsAmount(products));
            seg.setSeatsAmount(seatsAmount);
            seg.setId(s.getUid());
            if (s.getServiceClass() != null) {
                seg.setClassOfService(s.getServiceClass().name());
            }
            RailwayCarrier carrier = Optional.ofNullable(s.getCarrier()).map(arg_0 -> ((DictionaryCache)DictionaryCache.get()).resolveReference(arg_0)).orElseGet(this::getDefaultRailwayCarrier);
            seg.setCommandToCreate(this.getCreationCommand(s, seatsAmount, locator, carrier));
            data.getSegments().add(seg);
            data.getRemarks().addAll(this.createCrossSRemarks(products, s, sw.getSeats(), sw.getCarriages(), clientMode, locator, carrier));
            if (sw.getGdsName() != null) {
                StringBuilder text = new StringBuilder("SRC-");
                if (gdsName2String.containsKey(sw.getGdsName())) {
                    text.append(gdsName2String.get(sw.getGdsName()));
                } else {
                    text.append(SabrePassiveSegmentsUtil.getTranslation((String)sw.getGdsName().name()));
                }
                data.getRemarks().addAll(SabrePassiveSegmentsUtil.prepareDotSRemark((String)s.getUid(), (String)text.toString()));
            }
            for (RailwayProduct product : products) {
                if (TextUtil.isBlank((String)this.getTicketNumber(product))) continue;
                data.getRemarks().addAll(this.createDotSRemarks(product, s, sw.getCarriage(product.getUid()), sw.getSeat(product.getUid())));
                data.getRemarks().addAll(this.createCrossRemarks(product, sw.getCarriage(product.getUid()), sw.getSeat(product.getUid())));
                if (!usedProductsUids.contains(product.getUid())) {
                    data.getRemarks().addAll(this.createDotXStarProductRemarks(product, product2Num.get(product.getUid()), s, clientMode, subagencyMode));
                    data.getRemarks().addAll(this.createDotProductRemarks(product, product2Num.get(product.getUid()), s, clientMode, subagencyMode));
                    usedProductsUids.add(product.getUid());
                }
                data.getAccountingLines().add(this.createAccountingLine(product, s.getUid(), carrier));
            }
        }
        RailwayProduct veryFirstProduct = originalProducts.get(0);
        if (veryFirstProduct.getReservation() != null && veryFirstProduct.getReservation().getBookingFile() != null && !TextUtil.isBlank((String)veryFirstProduct.getReservation().getBookingFile().getNumber())) {
            StringBuilder text = new StringBuilder("X*BR" + SabrePassiveSegmentsUtil.getTranslation((String)veryFirstProduct.getReservation().getBookingFile().getNumber()));
            data.getRemarks().add(SabrePassiveSegmentsUtil.prepareDotXStarProductRemark((String)text.toString()));
        }
        return data;
    }

    private RailwayCarrier getDefaultRailwayCarrier() {
        RailwayCarrier defaultCarrier = new RailwayCarrier();
        defaultCarrier.getCodeVariants().put(CodeSystem.IATA.name(), "RR");
        defaultCarrier.getTranslations().put(Locale.ENGLISH, "Russian Railways");
        return defaultCarrier;
    }

    private SabrePassiveAccountingLineData createAccountingLine(RailwayProduct product, String segmentUid, RailwayCarrier carrier) {
        SabrePassiveAccountingLineData result = new SabrePassiveAccountingLineData();
        result.setTicketNumber(SabrePassiveSegmentsUtil.getTranslation((String)product.getSystemNumber()));
        result.setType(SabrePassiveAccountingLineType.RAILWAY);
        result.setRelatedSegmentUid(segmentUid);
        product.getPassengers().stream().findFirst().ifPresent(traveller -> {
            String firstName = SabrePassiveSegmentsUtil.buildGivenName((Traveller)traveller, RailwayProductHelper.getPassengerType(product, traveller), (SabrePassiveSegmentsUtil.SabreAviaParametersProvider)RailwayProductPassiveSegmentsHandler.getRailProvider(product, traveller));
            String lastName = SabrePassiveSegmentsUtil.buildSurname((Traveller)traveller);
            String command = this.createAccountingLineCommand(product, firstName, lastName, carrier);
            result.setCreationCommand(command);
        });
        return result;
    }

    private String createAccountingLineCommand(RailwayProduct product, String firstName, String lastName, RailwayCarrier carrier) {
        String vendor = "UNKNWN";
        String code = (String)carrier.getCodeVariants().get(CodeSystem.IATA.name());
        if ("RR".equalsIgnoreCase(code)) {
            vendor = "RZDRUS";
        } else if ("UZ".equalsIgnoreCase(code)) {
            vendor = "UZDUKR";
        }
        return "ACRAL" + "%s/" + vendor + "/RAL/0/0/0/C0/PER/CA/1-" + SabrePassiveSegmentsUtil.getTranslation((String)product.getSystemNumber()) + " " + lastName + " " + firstName;
    }

    public SabrePassiveSegmentsClientMode getClientMode(RailwayProduct product) {
        return SabrePassiveSegmentsUtil.getClientModeByProductData(RailwayProductHelper.getSubagency(product), RailwayProductHelper.getAgency(product));
    }

    public void setActualPassiveSegmentsXIDataToCurrentProduct(RailwayProduct oldProd, RailwayProduct prod) {
        SabrePassiveSegmentsResult res;
        if (oldProd == null || prod == null) {
            return;
        }
        RailwayProduct oldProduct = oldProd;
        while (oldProduct.getPreviousProduct() != null) {
            oldProduct = oldProduct.getPreviousProduct();
        }
        SabrePassiveSegmentsResult result = oldProduct.getPassiveSegmentsCreationResult();
        String pnr = null;
        Date responseDate = null;
        if (result != null && result.getPassiveSegmentsXIData() != null && !TextUtil.isBlank((String)result.getPassiveSegmentsXIData().getPnr())) {
            pnr = result.getPassiveSegmentsXIData().getPnr();
            responseDate = result.getPassiveSegmentsXIData().getResponseDate();
        }
        while (oldProduct.getNextProduct() != null) {
            res = (oldProduct = oldProduct.getNextProduct()).getPassiveSegmentsCreationResult();
            if (res == null || res.getPassiveSegmentsXIData() == null || TextUtil.isBlank((String)res.getPassiveSegmentsXIData().getPnr())) continue;
            SabrePassiveSegmentsXIData data = res.getPassiveSegmentsXIData();
            if (!TextUtil.isBlank((String)pnr) && !data.getResponseDate().after(responseDate)) continue;
            pnr = data.getPnr();
            responseDate = data.getResponseDate();
        }
        if (!TextUtil.isBlank(pnr)) {
            SabrePassiveSegmentsXIData data;
            if (prod.getPassiveSegmentsCreationResult() == null) {
                res = new SabrePassiveSegmentsResult();
                prod.setPassiveSegmentsCreationResult(res);
            }
            if (prod.getPassiveSegmentsCreationResult().getPassiveSegmentsXIData() == null) {
                data = new SabrePassiveSegmentsXIData();
                prod.getPassiveSegmentsCreationResult().setPassiveSegmentsXIData(data);
            }
            if (TextUtil.isBlank((String)prod.getPassiveSegmentsCreationResult().getPassiveSegmentsXIData().getPnr()) || responseDate.after(prod.getPassiveSegmentsCreationResult().getPassiveSegmentsXIData().getResponseDate())) {
                data = prod.getPassiveSegmentsCreationResult().getPassiveSegmentsXIData();
                data.setPnr(pnr);
                data.setResponseDate(responseDate);
            }
        }
    }

    public boolean isRestoreFromRefundOrExchange(RailwayProduct oldProd) {
        RailwayProduct oldProduct = oldProd;
        while (oldProduct.getPreviousProduct() != null) {
            if ((oldProduct = oldProduct.getPreviousProduct()).getStatus() != ProductStatus.EXCHANGE && oldProduct.getStatus() != ProductStatus.REFUND) continue;
            return true;
        }
        while (oldProduct.getNextProduct() != null) {
            if ((oldProduct = oldProduct.getNextProduct()).getStatus() != ProductStatus.EXCHANGE && oldProduct.getStatus() != ProductStatus.REFUND) continue;
            return true;
        }
        return false;
    }

    public boolean isAcceptableForPassiveSegmentsSynchronization() {
        return true;
    }

    private String getCreationCommand(RailwaySegment s, String seatsAmount, String locator, RailwayCarrier carrier) {
        StringBuilder res = new StringBuilder("0RAL");
        res.append((String)carrier.getCodeVariants().get(CodeSystem.IATA.name()));
        res.append("GK");
        res.append(seatsAmount);
        if (s.getDepartureStation() != null) {
            res.append("/");
            res.append(this.prepareDeparture(SabrePassiveSegmentsUtil.getTranslation((DictionaryReference)s.getDepartureStation())));
        }
        if (s.getArriveStation() != null) {
            res.append("/");
            res.append(this.prepareArrival(SabrePassiveSegmentsUtil.getTranslation((DictionaryReference)s.getArriveStation())));
        }
        if (s.getDepartureDate() != null) {
            res.append(SabrePassiveSegmentsUtil.formatDate((Date)s.getDepartureDate()));
            res.append("-LV-");
            res.append(SabrePassiveSegmentsUtil.formatTime((Date)s.getDepartureDate()));
        }
        if (s.getDepartureStation() != null) {
            res.append("/FR-");
            res.append(this.getStationNameAndCode((DictionaryReference<RailwayStation>)s.getDepartureStation()));
        }
        if (s.getArriveDate() != null) {
            res.append("/DT-");
            res.append(SabrePassiveSegmentsUtil.formatDate((Date)s.getArriveDate()));
            res.append("/AR-");
            res.append(SabrePassiveSegmentsUtil.formatTime((Date)s.getArriveDate()));
        }
        if (s.getArriveStation() != null) {
            res.append("/AT-");
            res.append(this.getStationNameAndCode((DictionaryReference<RailwayStation>)s.getArriveStation()));
        }
        if (s.getTrainNumber() != null) {
            res.append("/NA-");
            res.append(SabrePassiveSegmentsUtil.getTranslation((String)s.getTrainNumber()));
            if (s.getSlot() != null) {
                res.append(SabrePassiveSegmentsUtil.getTranslation((String)s.getSlot()));
            }
        }
        res.append("/SP-");
        res.append("/SI-");
        if (locator != null) {
            res.append("/CF-");
            res.append(locator);
        }
        return res.toString();
    }

    private String prepareDeparture(String translation) {
        String res = this.removeIllegalSymbols(translation);
        return res.length() < 4 ? res + "CITY" : res;
    }

    private String prepareArrival(String translation) {
        String res = this.removeIllegalSymbols(translation);
        return res.length() < 3 ? res + "CITY" : res;
    }

    private String removeIllegalSymbols(String translation) {
        return translation.replaceAll("[^A-Za-z ]", "").trim().toUpperCase();
    }

    private String getStationNameAndCode(DictionaryReference<RailwayStation> sRef) {
        if (sRef == null) {
            return "";
        }
        StringBuilder res = new StringBuilder();
        res.append(SabrePassiveSegmentsUtil.getTranslation(sRef));
        res.append("-");
        res.append(this.getStationCode(sRef));
        return res.toString();
    }

    private String getStationCode(DictionaryReference<RailwayStation> sRef) {
        RailwayStation s = (RailwayStation)DictionaryCache.get().resolveReference(sRef);
        String res = "";
        if (s != null) {
            res = s.getCode();
        }
        return res.replaceAll("_", "");
    }

    private List<SabrePassiveRemarkData> createCrossSRemarks(List<RailwayProduct> products, RailwaySegment s, Collection<String> seats, Collection<String> carriages, SabrePassiveSegmentsClientMode clientMode, String locator, RailwayCarrier carrier) {
        StringBuilder text;
        Object prefix;
        ArrayList<SabrePassiveRemarkData> res = new ArrayList<SabrePassiveRemarkData>();
        Object text2 = new StringBuilder();
        ((StringBuilder)text2).append("CARRIER-");
        ((StringBuilder)text2).append((String)carrier.getTranslations().get(Locale.ENGLISH));
        res.addAll(SabrePassiveSegmentsUtil.prepareCrossSRemark((String)s.getUid(), (String)((StringBuilder)text2).toString()));
        if (s.getServiceClass() != null) {
            text2 = new StringBuilder("CABIN-");
            ((StringBuilder)text2).append(RailwayProductPassiveSegmentsHandler.getServiceClassGeneralClass(s.getServiceClass()));
            ((StringBuilder)text2).append(" CLASS");
            ((StringBuilder)text2).append("/");
            ((StringBuilder)text2).append(RailwayProductPassiveSegmentsHandler.getServiceClassString(s.getServiceClass()));
            res.addAll(SabrePassiveSegmentsUtil.prepareCrossSRemark((String)s.getUid(), (String)((StringBuilder)text2).toString()));
        }
        if (!TextUtil.isBlank((String)s.getAddInfo())) {
            prefix = "NOTES-";
            text = new StringBuilder();
            text.append(SabrePassiveSegmentsUtil.getTranslation((String)s.getAddInfo()));
            res.addAll(SabrePassiveSegmentsUtil.prepareCrossSRemark((String)s.getUid(), (String)prefix, (String)text.toString()));
        }
        if (clientMode == SabrePassiveSegmentsClientMode.CWT) {
            StringBuilder text3;
            for (RailwayProduct p : products) {
                if (!TextUtil.isBlank((String)p.getSystemNumber())) {
                    text3 = new StringBuilder("TK-");
                    text3.append(SabrePassiveSegmentsUtil.getTranslation((String)p.getSystemNumber()));
                    res.addAll(SabrePassiveSegmentsUtil.prepareCrossSRemark((String)s.getUid(), (String)text3.toString()));
                }
                text3 = new StringBuilder("TTL-");
                BigDecimal total = p.getTotalEquivalentFare();
                String curr = DictHelper.getEquivCurrency();
                if (total != null) {
                    if (curr != null && "RUB".equals(curr)) {
                        text3.append(SabrePassiveSegmentsUtil.formatDecimal((BigDecimal)total, (boolean)false));
                    } else {
                        text3.append(SabrePassiveSegmentsUtil.formatDecimal((BigDecimal)total, (boolean)true));
                    }
                }
                if (curr != null) {
                    text3.append(curr);
                }
                res.addAll(SabrePassiveSegmentsUtil.prepareCrossSRemark((String)s.getUid(), (String)text3.toString()));
                String dm = this.getDeliveryMethod(p, s);
                if (TextUtil.isBlank((String)dm)) continue;
                StringBuilder text4 = new StringBuilder("DM-");
                text4.append(dm);
                res.addAll(SabrePassiveSegmentsUtil.prepareCrossSRemark((String)s.getUid(), (String)text4.toString()));
            }
            if (!TextUtil.isBlank((String)locator)) {
                text2 = new StringBuilder("CF-");
                ((StringBuilder)text2).append(locator);
                res.addAll(SabrePassiveSegmentsUtil.prepareCrossSRemark((String)s.getUid(), (String)((StringBuilder)text2).toString()));
            }
            text2 = new StringBuilder("SUN-");
            ((StringBuilder)text2).append("RZD RUSSIAN RAILWAYS");
            res.addAll(SabrePassiveSegmentsUtil.prepareCrossSRemark((String)s.getUid(), (String)((StringBuilder)text2).toString()));
            for (String carriage : carriages) {
                text3 = new StringBuilder("CN-");
                text3.append(carriage);
                res.addAll(SabrePassiveSegmentsUtil.prepareCrossSRemark((String)s.getUid(), (String)text3.toString()));
            }
            for (String seat : seats) {
                text3 = new StringBuilder("SEN-");
                text3.append(seat);
                res.addAll(SabrePassiveSegmentsUtil.prepareCrossSRemark((String)s.getUid(), (String)text3.toString()));
            }
            if (s.getServiceClass() != null) {
                text2 = new StringBuilder("CL-");
                ((StringBuilder)text2).append(RailwayProductPassiveSegmentsHandler.getServiceClassGeneralClass(s.getServiceClass()));
                res.addAll(SabrePassiveSegmentsUtil.prepareCrossSRemark((String)s.getUid(), (String)((StringBuilder)text2).toString()));
            }
            if (!TextUtil.isBlank((String)s.getTrainNumber())) {
                text2 = new StringBuilder("SF-");
                ((StringBuilder)text2).append(SabrePassiveSegmentsUtil.getTranslation((String)s.getTrainNumber()));
                if (!TextUtil.isBlank((String)s.getSlot())) {
                    ((StringBuilder)text2).append(SabrePassiveSegmentsUtil.getTranslation((String)s.getSlot()));
                }
                res.addAll(SabrePassiveSegmentsUtil.prepareCrossSRemark((String)s.getUid(), (String)((StringBuilder)text2).toString()));
            }
            text2 = new StringBuilder("STS-GK");
            res.addAll(SabrePassiveSegmentsUtil.prepareCrossSRemark((String)s.getUid(), (String)((StringBuilder)text2).toString()));
            if (s.getDepartureStation() != null) {
                prefix = "STP-";
                text = new StringBuilder();
                text.append(SabrePassiveSegmentsUtil.getTranslation((DictionaryReference)s.getDepartureStation()));
                res.addAll(SabrePassiveSegmentsUtil.prepareCrossSRemark((String)s.getUid(), (String)prefix, (String)text.toString()));
            }
            if (s.getArriveStation() != null) {
                prefix = "EP-";
                text = new StringBuilder();
                text.append(SabrePassiveSegmentsUtil.getTranslation((DictionaryReference)s.getArriveStation()));
                res.addAll(SabrePassiveSegmentsUtil.prepareCrossSRemark((String)s.getUid(), (String)prefix, (String)text.toString()));
            }
            if (!TextUtil.isBlank((String)s.getAddInfo())) {
                prefix = "SI-";
                text = new StringBuilder();
                text.append(SabrePassiveSegmentsUtil.getTranslation((String)s.getAddInfo()));
                res.addAll(SabrePassiveSegmentsUtil.prepareCrossSRemark((String)s.getUid(), (String)prefix, (String)text.toString()));
            }
        }
        return res;
    }

    private List<SabrePassiveRemarkData> createDotSRemarks(RailwayProduct product, RailwaySegment s, String carriage, String seat) {
        ArrayList<SabrePassiveRemarkData> res = new ArrayList<SabrePassiveRemarkData>();
        StringBuilder text = new StringBuilder("TICKET-");
        text.append(this.getTicketNumber(product));
        text.append("/" + this.getPassengerName(product));
        res.addAll(SabrePassiveSegmentsUtil.prepareDotSRemark((String)s.getUid(), (String)text.toString()));
        if (!TextUtil.isBlank((String)carriage) || !TextUtil.isBlank((String)seat)) {
            text = new StringBuilder("TICKET-");
            text.append(this.getTicketNumber(product));
            if (!TextUtil.isBlank((String)carriage)) {
                text.append("/COACH-");
                text.append(carriage);
            }
            if (!TextUtil.isBlank((String)seat)) {
                text.append("/SEAT-");
                text.append(seat);
            } else {
                text.append("/SEAT-NO");
            }
            res.addAll(SabrePassiveSegmentsUtil.prepareDotSRemark((String)s.getUid(), (String)text.toString()));
        }
        text = new StringBuilder("TICKET-");
        text.append(this.getTicketNumber(product));
        text.append("/DELIVERY-");
        text.append(this.getDeliveryMethod(product, s));
        res.addAll(SabrePassiveSegmentsUtil.prepareDotSRemark((String)s.getUid(), (String)text.toString()));
        return res;
    }

    private List<SabrePassiveRemarkData> createCrossRemarks(RailwayProduct product, String carriage, String seat) {
        ArrayList<SabrePassiveRemarkData> res = new ArrayList<SabrePassiveRemarkData>();
        StringBuilder text = new StringBuilder("TICKET-");
        text.append(this.getTicketNumber(product));
        text.append("/" + this.getPassengerName(product));
        res.add(SabrePassiveSegmentsUtil.prepareCrossRemark((String)text.toString()));
        text = new StringBuilder("TICKET-");
        text.append(this.getTicketNumber(product));
        if (!TextUtil.isBlank((String)carriage)) {
            text.append("/COACH-");
            text.append(carriage);
        }
        if (!TextUtil.isBlank((String)seat)) {
            text.append("/SEAT-");
            text.append(SabrePassiveSegmentsUtil.getTranslation((String)seat));
        } else {
            text.append("/SEAT-NO");
        }
        res.add(SabrePassiveSegmentsUtil.prepareCrossRemark((String)text.toString()));
        return res;
    }

    private List<SabrePassiveRemarkData> createDotXStarProductRemarks(RailwayProduct product, String productNum, RailwaySegment seg, SabrePassiveSegmentsClientMode clientMode, SabrePassiveSegmentsSubagencyMode subagencyMode) {
        BigDecimal vat;
        ArrayList<SabrePassiveRemarkData> res = new ArrayList<SabrePassiveRemarkData>();
        StringBuilder text = new StringBuilder("X*PR" + productNum + "*");
        text.append(this.getTicketNumber(product));
        text.append("*PAX*");
        text.append(this.getPassengerName(product));
        res.add(SabrePassiveSegmentsUtil.prepareDotXStarProductRemark((String)text.toString()));
        text = new StringBuilder("X*PR" + productNum + "*");
        text.append(this.getTicketNumber(product));
        if (seg != null && seg.getCarriageType() != null) {
            text.append("*CABIN ");
            text.append(RailwayProductPassiveSegmentsHandler.getCarriageTypeString(seg.getCarriageType()));
        }
        if (seg != null && seg.getServiceClass() != null) {
            text.append("*FARECODE ");
            text.append(RailwayProductPassiveSegmentsHandler.getServiceClassString(seg.getServiceClass()));
        }
        res.add(SabrePassiveSegmentsUtil.prepareDotXStarProductRemark((String)text.toString()));
        text = new StringBuilder("X*PR" + productNum + "*");
        text.append(this.getTicketNumber(product));
        text.append("*FARE ");
        BigDecimal total = product.getTotalEquivalentFare();
        String curr = DictHelper.getEquivCurrency();
        if (curr != null) {
            text.append(curr);
        }
        if (total != null) {
            text.append(SabrePassiveSegmentsUtil.formatDecimal((BigDecimal)total, (boolean)true));
        }
        if ((vat = product.getTotalEquivalentVAT()) != null) {
            text.append("*VAT ");
            if (curr != null) {
                text.append(curr);
            }
            text.append(SabrePassiveSegmentsUtil.formatDecimal((BigDecimal)vat, (boolean)true));
        }
        res.add(SabrePassiveSegmentsUtil.prepareDotXStarProductRemark((String)text.toString()));
        if (clientMode == SabrePassiveSegmentsClientMode.CWT) {
            res.add(SabrePassiveSegmentsUtil.prepareDotXStarProductRemark((String)"X*CWTCLIENT"));
        }
        if (subagencyMode == SabrePassiveSegmentsSubagencyMode.CWT) {
            List costCodes = SabrePassiveSegmentsUtil.getCostCodes((StatisticalData)product.getStatisticalData());
            costCodes.forEach(cc -> res.add(SabrePassiveSegmentsUtil.prepareDotXStarProductRemark((String)SabrePassiveSegmentsUtil.getDotXStarRemarkUDIDText((CostCode)cc))));
        }
        return res;
    }

    private List<SabrePassiveRemarkData> createDotProductRemarks(RailwayProduct product, String productNum, RailwaySegment seg, SabrePassiveSegmentsClientMode clientMode, SabrePassiveSegmentsSubagencyMode subagencyMode) {
        ArrayList<SabrePassiveRemarkData> res = new ArrayList<SabrePassiveRemarkData>();
        if (subagencyMode == SabrePassiveSegmentsSubagencyMode.CWT) {
            List costCodes = SabrePassiveSegmentsUtil.getCostCodes((StatisticalData)product.getStatisticalData());
            costCodes.forEach(cc -> res.add(SabrePassiveSegmentsUtil.prepareDotProductRemark((String)SabrePassiveSegmentsUtil.getDotRemarkUDIDText((CostCode)cc))));
        }
        return res;
    }

    private String getDeliveryMethod(RailwayProduct product, RailwaySegment seg) {
        String res = "";
        boolean isEticket = false;
        if (product.getBlankType() != null) {
            BlankType blankType = (BlankType)DictionaryCache.get().resolveReference(product.getBlankType());
            boolean bl = isEticket = blankType != null && blankType.getBlankCategory() == BlankCategory.ETICKET;
        }
        res = !isEticket ? "PAPER TKT" : (!seg.isERegEnabled() ? "ETKT CKIN UNAVAIL" : (seg.isHasEReg() ? "ETKT CKIN PASSED" : "ETKT CKIN NOT PASSED"));
        return res;
    }

    private String getFareType(RailwayProduct product) {
        String res = "POLNYI";
        List<DictionaryReference<PassengerType>> passengerTypes = RailwayProductHelper.getPassengerTypes(product);
        if (!passengerTypes.contains(DictHelper.getAdultPassengerType())) {
            if (passengerTypes.stream().anyMatch(DictHelper::isInfantPassengerTypeCategory)) {
                res = "BEZDENEZHNYI";
            } else if (passengerTypes.stream().anyMatch(DictHelper::isChildPassengerTypeCategory)) {
                res = "DET";
            }
        }
        return res;
    }

    private String getTicketNumber(RailwayProduct p) {
        StringBuilder sb = new StringBuilder();
        if (!TextUtil.isBlank((String)p.getCarrierNumber())) {
            sb.append(p.getCarrierNumber());
        }
        sb.append(p.getSystemNumber());
        return SabrePassiveSegmentsUtil.getTranslation((String)sb.toString());
    }

    private String getPassengerName(RailwayProduct p) {
        String res = "";
        if (p.getPassengers().isEmpty()) {
            return res;
        }
        res = String.join((CharSequence)"/", p.getPassengers().stream().map(t -> SabrePassiveSegmentsUtil.getTravelerName((Traveller)t)).collect(Collectors.toList()));
        return res;
    }

    private long getSeatsAmount(List<RailwayProduct> products) {
        return products.stream().filter(p -> {
            List<DictionaryReference<PassengerType>> passengerTypes = RailwayProductHelper.getPassengerTypes(p);
            return passengerTypes.isEmpty() || passengerTypes.stream().anyMatch(type -> !DictHelper.isInfantPassengerType((DictionaryReference)type));
        }).count();
    }

    private static String getServiceClassString(ServiceClass cl) {
        if (cl == null) {
            return "";
        }
        if (!serviceClass2String.containsKey(cl)) {
            return SabrePassiveSegmentsUtil.getTranslation((String)cl.toString());
        }
        return serviceClass2String.get(cl);
    }

    private static String getServiceClassGeneralClass(ServiceClass cl) {
        if (cl == null) {
            return "";
        }
        if (!serviceClass2GeneralClass.containsKey(cl)) {
            return "SECOND";
        }
        return serviceClass2GeneralClass.get(cl);
    }

    private static String getCarriageTypeString(CarriageType ct) {
        if (ct == null) {
            return "";
        }
        if (!carriageType2String.containsKey(ct)) {
            return SabrePassiveSegmentsUtil.getTranslation((String)ct.toString());
        }
        return carriageType2String.get(ct);
    }

    private static boolean segmentsEqual(List<RailwaySegment> list1, List<RailwaySegment> list2) {
        if (list1 == null || list2 == null) {
            return false;
        }
        if (list1.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list1.size(); ++i) {
            if (RailwayProductPassiveSegmentsHandler.segmentsEqual(list1.get(i), list2.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean segmentsEqual(RailwaySegment s1, RailwaySegment s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        if (!DictHelper.equals((DictionaryReference)s1.getDepartureStation(), (DictionaryReference)s2.getDepartureStation())) {
            return false;
        }
        if (!DictHelper.equals((DictionaryReference)s1.getArriveStation(), (DictionaryReference)s2.getArriveStation())) {
            return false;
        }
        if (!TextUtil.isSame((String)s1.getTrainNumber(), (String)s2.getTrainNumber())) {
            return false;
        }
        return MiscUtil.equals((Object)s1.getDepartureDate(), (Object)s2.getDepartureDate());
    }

    private static int getSegmentHashCode(RailwaySegment seg, int result) {
        if (seg.getDepartureStation() != null && seg.getDepartureStation().getCode() != null) {
            result = 31 * result + seg.getDepartureStation().getCode().hashCode();
        }
        if (seg.getArriveStation() != null && seg.getArriveStation().getCode() != null) {
            result = 31 * result + seg.getArriveStation().getCode().hashCode();
        }
        if (seg.getDepartureDate() != null) {
            result = 31 * result + seg.getDepartureDate().hashCode();
        }
        if (seg.getTrainNumber() != null) {
            result = 31 * result + seg.getTrainNumber().hashCode();
        }
        return result;
    }

    public List<SabrePassivePassengerData> getTravellers(List<RailwayProduct> products) {
        ArrayList<SabrePassivePassengerData> res = new ArrayList<SabrePassivePassengerData>();
        products.stream().forEach(p -> p.getPassengers().stream().forEach(t -> {
            DictionaryReference<PassengerType> passengerType = RailwayProductHelper.getPassengerType(p, t);
            SabrePassivePassengerData trv = new SabrePassivePassengerData();
            trv.setUid(t.getUid());
            trv.setFirstName(SabrePassiveSegmentsUtil.buildGivenName((Traveller)t, passengerType, (SabrePassiveSegmentsUtil.SabreAviaParametersProvider)RailwayProductPassiveSegmentsHandler.getRailProvider(p, t)));
            trv.setLastName(SabrePassiveSegmentsUtil.buildSurname((Traveller)t));
            trv.setInfant(Boolean.valueOf(DictHelper.isInfantPassengerType(passengerType)).booleanValue());
            if (passengerType != null) {
                trv.setPassengerType(DictHelper.getCodeVariant(passengerType, (CodeSystem[])new CodeSystem[]{CodeSystem.IATA}));
            }
            res.add(trv);
        }));
        return res;
    }

    public static SabrePassiveSegmentsUtil.SabreAviaParametersProvider getRailProvider(RailwayProduct p, final Traveller t) {
        final Date lastArriveDate = p.getSegments().size() > 0 ? ((RailwaySegment)p.getSegments().get(p.getSegments().size() - 1)).getArriveDate() : new Date();
        return new SabrePassiveSegmentsUtil.SabreAviaParametersProvider(){

            public boolean isNoInfGenderSuffix() {
                return false;
            }

            public boolean isTchBlankOwner() {
                return false;
            }

            public int getAgeInYears() {
                return Years.yearsBetween((ReadableInstant)new DateTime((Object)t.getPassport().getBirthday()), (ReadableInstant)new DateTime((Object)lastArriveDate)).getYears();
            }

            public int getAgeInMonths() {
                return Months.monthsBetween((ReadableInstant)new DateTime((Object)t.getPassport().getBirthday()), (ReadableInstant)new DateTime((Object)lastArriveDate)).getMonths();
            }

            public boolean isSubsidizedTariff() {
                return false;
            }

            public boolean isSuCarrier() {
                return false;
            }
        };
    }

    private Map<String, String> assignProductNumbers(List<RailwayProduct> originalProducts) {
        HashMap<String, String> res = new HashMap<String, String>();
        int i = 1;
        for (RailwayProduct p : originalProducts) {
            res.put(p.getUid(), String.valueOf(i));
            ++i;
        }
        return res;
    }

    private List<SegmentWrapper> groupProductsBySegments(List<RailwayProduct> products) {
        ArrayList<SegmentWrapper> res = new ArrayList<SegmentWrapper>();
        for (RailwayProduct product : products) {
            GdsName gdsName = null;
            String gdsRecloc = null;
            if (product.getReservation() != null) {
                gdsName = CommonReservationGdsNameInfoHelper.getDisplayedGdsName((Reservation)product.getReservation());
                gdsRecloc = CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)product.getReservation());
            }
            for (RailwaySegment segment : product.getSegments()) {
                SegmentWrapper segWrapper = new SegmentWrapper(segment, gdsName, gdsRecloc);
                if (!res.contains(segWrapper)) {
                    res.add(segWrapper);
                } else {
                    segWrapper = (SegmentWrapper)res.get(res.indexOf(segWrapper));
                }
                segWrapper.addProduct(product, String.valueOf(segment.getNumber()), segment.getCarriageNumber(), String.join((CharSequence)",", segment.getPlaces()));
            }
        }
        return res;
    }

    private static class SegmentWrapper {
        private RailwaySegment segment;
        private GdsName gdsName;
        private String gdsRecloc;
        private List<RailwayProduct> products = new ArrayList<RailwayProduct>();
        private Map<String, String> product2seat = new HashMap<String, String>();
        private Map<String, String> product2carriage = new HashMap<String, String>();
        private Map<String, String> product2segmentRecordNumber = new HashMap<String, String>();

        SegmentWrapper(RailwaySegment seg, GdsName gdsName, String gdsRecloc) {
            this.segment = seg;
            this.gdsRecloc = gdsRecloc;
            this.gdsName = gdsName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SegmentWrapper) || o == null) {
                return false;
            }
            SegmentWrapper seg = (SegmentWrapper)o;
            if (this.gdsName != seg.getGdsName()) {
                return false;
            }
            if (!TextUtil.isSame((String)this.gdsRecloc, (String)seg.getGdsRecloc())) {
                return false;
            }
            return RailwayProductPassiveSegmentsHandler.segmentsEqual(this.segment, seg.getSegment());
        }

        public int hashCode() {
            int result = 17;
            if (this.gdsName != null) {
                result = 31 * result + this.gdsName.hashCode();
            }
            if (this.gdsRecloc != null) {
                result = 31 * result + this.gdsRecloc.hashCode();
            }
            return RailwayProductPassiveSegmentsHandler.getSegmentHashCode(this.segment, result);
        }

        public RailwaySegment getSegment() {
            return this.segment;
        }

        public GdsName getGdsName() {
            return this.gdsName;
        }

        public String getGdsRecloc() {
            return this.gdsRecloc;
        }

        public List<RailwayProduct> getProducts() {
            return Collections.unmodifiableList(this.products);
        }

        public void addProduct(RailwayProduct product, String recordNumber, String carriageNo, String seatNo) {
            this.products.add(product);
            this.product2segmentRecordNumber.put(product.getUid(), recordNumber);
            if (!TextUtil.isBlank((String)carriageNo)) {
                this.product2carriage.put(product.getUid(), SabrePassiveSegmentsUtil.getTranslation((String)carriageNo));
            }
            if (!TextUtil.isBlank((String)seatNo)) {
                this.product2seat.put(product.getUid(), SabrePassiveSegmentsUtil.getTranslation((String)seatNo));
            }
        }

        public String getSeat(String productUid) {
            return this.product2seat.get(productUid);
        }

        public Collection<String> getSeats() {
            return this.product2seat.values();
        }

        public String getCarriage(String productUid) {
            return this.product2carriage.get(productUid);
        }

        public Collection<String> getCarriages() {
            return this.product2carriage.values();
        }

        public String getRecordNumber(String productUid) {
            return this.product2segmentRecordNumber.get(productUid);
        }
    }
}

