/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.railway.handlers;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.railway.RailwayRoute;
import com.gridnine.xtrip.common.model.handlers.DictSyncHelper;
import com.gridnine.xtrip.common.model.handlers.DictionaryHandler;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Collection;
import java.util.Collections;

public class RailwayRouteHandler
extends DictionaryHandler<RailwayRoute> {
    protected void registerProperties() {
        this.registerProperty((DictionaryHandler.Property)new DictionaryHandler.Property<RailwayRoute>(){

            public boolean match(RailwayRoute dictTo, RailwayRoute dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
                if (dictFrom.getCountry() == null || dictFrom.getCountry().equals((Object)dictTo.getCountry())) {
                    return true;
                }
                if (dictTo.getCountry() == null) {
                    return false;
                }
                Country foundCountry = (Country)DictSyncHelper.search((DictionaryReference)dictFrom.getCountry(), relatedDictionaries, Country.class);
                return foundCountry == null || TextUtil.isSame((String)foundCountry.getCode(), (String)dictTo.getCountry().getCode());
            }

            public void merge(RailwayRoute dictTo, RailwayRoute dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
                Country foundCountry = (Country)DictSyncHelper.search((DictionaryReference)dictFrom.getCountry(), relatedDictionaries, Country.class);
                dictTo.setCountry((DictionaryReference)(foundCountry != null ? foundCountry.toReference() : dictFrom.getCountry()));
            }

            public String getLocalizedName() {
                return L10nResourcesManager.getStr((String)"COUNTRY", (Object[])new Object[0]);
            }

            public Enum getKey() {
                return RailwayRoute.Property.country;
            }
        });
    }

    public RailwayRoute search(RailwayRoute dict) {
        RailwayRoute foundRoute = (RailwayRoute)super.search((BaseDictionary)dict);
        if (foundRoute == null) {
            for (RailwayRoute route : DictionaryCache.get().getAll(this.getDictionaryClass()).values()) {
                if (!DictSyncHelper.compareByNames((BaseDictionary)route, (BaseDictionary)dict)) continue;
                foundRoute = route;
                break;
            }
        }
        return foundRoute;
    }

    public Class<RailwayRoute> getDictionaryClass() {
        return RailwayRoute.class;
    }

    public Collection<DictionaryReference<? extends BaseDictionary>> getRelatedDictionaries(RailwayRoute dict) {
        return Collections.singleton(dict.getCountry());
    }

    public Collection<Class<? extends BaseDictionary>> getRelatedDictionaryClasses() {
        return Collections.singleton(Country.class);
    }
}

