/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.railway.handlers;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.railway.RailwayRoute;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStationVendorCard;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStationVendorCardType;
import com.gridnine.xtrip.common.model.handlers.DictSyncHelper;
import com.gridnine.xtrip.common.model.handlers.DictionaryHandler;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayStationDictionaryHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class RailwayStationHandler
extends DictionaryHandler<RailwayStation> {
    protected void registerProperties() {
        this.registerCodeVariants();
        this.registerProperty((DictionaryHandler.Property)new DictionaryHandler.Property<RailwayStation>(){

            public boolean match(RailwayStation dictTo, RailwayStation dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
                for (RailwayStationVendorCardType cardType : RailwayStationHandler.collectCardTypes(new RailwayStation[]{dictTo, dictFrom})) {
                    RailwayStationVendorCard cardTo = RailwayStationDictionaryHelper.getVendorCard(dictTo, cardType);
                    RailwayStationVendorCard cardFrom = RailwayStationDictionaryHelper.getVendorCard(dictFrom, cardType);
                    if (cardTo == null) {
                        cardTo = new RailwayStationVendorCard();
                    }
                    if (cardFrom == null) {
                        cardFrom = new RailwayStationVendorCard();
                    }
                    if (RailwayStationHandler.matchCards(cardTo, cardFrom, relatedDictionaries)) continue;
                    return false;
                }
                return true;
            }

            public void merge(RailwayStation dictTo, RailwayStation dictFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
                for (RailwayStationVendorCardType cardType : RailwayStationHandler.collectCardTypes(new RailwayStation[]{dictTo, dictFrom})) {
                    RailwayStationVendorCard cardTo = RailwayStationDictionaryHelper.getVendorCard(dictTo, cardType);
                    RailwayStationVendorCard cardFrom = RailwayStationDictionaryHelper.getVendorCard(dictFrom, cardType);
                    if (cardTo == null) {
                        cardTo = new RailwayStationVendorCard();
                    }
                    if (cardFrom == null) {
                        cardFrom = new RailwayStationVendorCard();
                    }
                    if (RailwayStationHandler.matchCards(cardTo, cardFrom, relatedDictionaries)) continue;
                    RailwayStationHandler.this.mergeCards(cardTo, cardFrom, relatedDictionaries);
                }
            }

            public String getLocalizedName() {
                return L10nResourcesManager.getStr((String)"VENDOR_CARDS", (Object[])new Object[0]);
            }

            public void fillDiffs(RailwayStation dictTo, RailwayStation dictFrom, Collection<? extends BaseDictionary> relatedDictionaries, Map<String, MiscUtil.Pair<String, String>> diffs) {
                for (RailwayStationVendorCardType cardType : RailwayStationHandler.collectCardTypes(new RailwayStation[]{dictTo, dictFrom})) {
                    RailwayStationVendorCard cardTo = RailwayStationDictionaryHelper.getVendorCard(dictTo, cardType);
                    RailwayStationVendorCard cardFrom = RailwayStationDictionaryHelper.getVendorCard(dictFrom, cardType);
                    if (cardTo == null) {
                        cardTo = new RailwayStationVendorCard();
                    }
                    if (cardFrom == null) {
                        cardFrom = new RailwayStationVendorCard();
                    }
                    if (RailwayStationHandler.matchCards(cardTo, cardFrom, relatedDictionaries)) continue;
                    RailwayStationHandler.this.fillCardDiffs(cardTo, cardFrom, relatedDictionaries, diffs);
                }
            }

            public Enum getKey() {
                return RailwayStation.Property.vendorCards;
            }

            public String toString(RailwayStation dict) {
                StringBuilder sb = new StringBuilder();
                List sortedCards = dict.getVendorCards();
                for (RailwayStationVendorCard card : sortedCards) {
                    sb.append(System.lineSeparator());
                    sb.append("Type: ").append(card.getType());
                    sb.append("; ");
                    sb.append("Translations: ").append(card.getTranslations().getValues().entrySet().stream().filter(Objects::nonNull).map(entry -> entry.getKey() + ": " + (String)entry.getValue()).collect(Collectors.joining(", ")));
                    sb.append("; ");
                    sb.append("Short names: ").append(card.getShortNames().getValues().entrySet().stream().filter(Objects::nonNull).map(entry -> entry.getKey() + ": " + (String)entry.getValue()).collect(Collectors.joining(", ")));
                    sb.append("; ");
                    sb.append("Route: ").append(card.getRoute());
                    sb.append("; ");
                    sb.append("Country: ").append(card.getCountry());
                    sb.append("; ");
                    sb.append("Spell variants: ").append(card.getSpellVariants().stream().filter(Objects::nonNull).collect(Collectors.joining(", ")));
                }
                return sb.toString();
            }
        });
    }

    public Class<RailwayStation> getDictionaryClass() {
        return RailwayStation.class;
    }

    public Collection<DictionaryReference<? extends BaseDictionary>> getRelatedDictionaries(RailwayStation dict) {
        HashSet<DictionaryReference<? extends BaseDictionary>> res = new HashSet<DictionaryReference<? extends BaseDictionary>>();
        for (RailwayStationVendorCard vendorCard : dict.getVendorCards()) {
            res.add((DictionaryReference<? extends BaseDictionary>)vendorCard.getCountry());
            res.add((DictionaryReference<? extends BaseDictionary>)vendorCard.getRoute());
        }
        return res;
    }

    public Collection<Class<? extends BaseDictionary>> getRelatedDictionaryClasses() {
        return Arrays.asList(Country.class, RailwayRoute.class);
    }

    private static Collection<RailwayStationVendorCardType> collectCardTypes(RailwayStation ... stations) {
        return Arrays.stream(stations).filter(Objects::nonNull).map(RailwayStation::getVendorCards).flatMap(Collection::stream).map(RailwayStationVendorCard::getType).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private static boolean matchCards(RailwayStationVendorCard cardTo, RailwayStationVendorCard cardFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
        DictSyncHelper.replaceDuplicateLocales((Map)cardTo.getTranslations().getValues());
        DictSyncHelper.replaceDuplicateLocales((Map)cardFrom.getTranslations().getValues());
        if (!cardTo.getTranslations().getValues().keySet().containsAll(cardFrom.getTranslations().getValues().keySet())) {
            return false;
        }
        for (Map.Entry entry : cardFrom.getTranslations().getValues().entrySet()) {
            if (TextUtil.isSame((String)((String)entry.getValue()), (String)((String)cardTo.getTranslations().getValues().get(entry.getKey())))) continue;
            return false;
        }
        DictSyncHelper.replaceDuplicateLocales((Map)cardTo.getShortNames().getValues());
        DictSyncHelper.replaceDuplicateLocales((Map)cardFrom.getShortNames().getValues());
        if (!cardTo.getShortNames().getValues().keySet().containsAll(cardFrom.getShortNames().getValues().keySet())) {
            return false;
        }
        for (Map.Entry entry : cardFrom.getShortNames().getValues().entrySet()) {
            if (TextUtil.isSame((String)((String)entry.getValue()), (String)((String)cardTo.getShortNames().getValues().get(entry.getKey())))) continue;
            return false;
        }
        if (cardFrom.getRoute() != null && !cardFrom.getRoute().equals((Object)cardTo.getRoute())) {
            boolean match;
            if (cardTo.getRoute() == null) {
                return false;
            }
            RailwayRoute foundRoute = (RailwayRoute)DictSyncHelper.search((DictionaryReference)cardFrom.getRoute(), relatedDictionaries, RailwayRoute.class);
            boolean bl = match = foundRoute == null || TextUtil.isSame((String)foundRoute.getCode(), (String)cardTo.getRoute().getCode());
            if (!match) {
                return false;
            }
        }
        if (cardFrom.getCountry() != null && !cardFrom.getCountry().equals((Object)cardTo.getCountry())) {
            boolean match;
            if (cardTo.getCountry() == null) {
                return false;
            }
            Country foundCountry = (Country)DictSyncHelper.search((DictionaryReference)cardFrom.getCountry(), relatedDictionaries, Country.class);
            boolean bl = match = foundCountry == null || TextUtil.isSame((String)foundCountry.getCode(), (String)cardTo.getCountry().getCode());
            if (!match) {
                return false;
            }
        }
        if (!cardTo.getSpellVariants().containsAll(cardFrom.getSpellVariants())) {
            return false;
        }
        for (String newSpellVariant : cardFrom.getSpellVariants()) {
            if (CollectionUtil.contains((Collection)cardTo.getSpellVariants(), (Object)newSpellVariant, TextUtil::isSame)) continue;
            return false;
        }
        return true;
    }

    private void mergeCards(RailwayStationVendorCard cardTo, RailwayStationVendorCard cardFrom, Collection<? extends BaseDictionary> relatedDictionaries) {
        DictSyncHelper.replaceDuplicateLocales((Map)cardTo.getTranslations().getValues());
        DictSyncHelper.replaceDuplicateLocales((Map)cardFrom.getTranslations().getValues());
        cardTo.getTranslations().getValues().putAll(cardFrom.getTranslations().getValues());
        DictSyncHelper.replaceDuplicateLocales((Map)cardTo.getShortNames().getValues());
        DictSyncHelper.replaceDuplicateLocales((Map)cardFrom.getShortNames().getValues());
        cardTo.getShortNames().getValues().putAll(cardFrom.getShortNames().getValues());
        RailwayRoute foundRoute = (RailwayRoute)DictSyncHelper.search((DictionaryReference)cardFrom.getRoute(), relatedDictionaries, RailwayRoute.class);
        cardTo.setRoute((DictionaryReference)(foundRoute != null ? foundRoute.toReference() : cardFrom.getRoute()));
        Country foundCountry = (Country)DictSyncHelper.search((DictionaryReference)cardFrom.getCountry(), relatedDictionaries, Country.class);
        cardTo.setCountry((DictionaryReference)(foundCountry != null ? foundCountry.toReference() : cardFrom.getCountry()));
        CollectionUtil.merge((Collection)cardTo.getSpellVariants(), (Collection)cardFrom.getSpellVariants(), TextUtil::isSame);
    }

    public void fillCardDiffs(RailwayStationVendorCard cardTo, RailwayStationVendorCard cardFrom, Collection<? extends BaseDictionary> relatedDictionaries, Map<String, MiscUtil.Pair<String, String>> diffs) {
        MiscUtil.Pair oldAndNewValues;
        DictSyncHelper.replaceDuplicateLocales((Map)cardTo.getTranslations().getValues());
        DictSyncHelper.replaceDuplicateLocales((Map)cardFrom.getTranslations().getValues());
        Collection keys = CollectionUtil.union(cardTo.getTranslations().getValues().keySet(), cardFrom.getTranslations().getValues().keySet());
        for (Locale key : keys) {
            String newTranslation;
            String oldTranslation = (String)cardTo.getTranslations().getValues().get(key);
            if (TextUtil.isSame((String)oldTranslation, (String)(newTranslation = (String)cardFrom.getTranslations().getValues().get(key)))) continue;
            diffs.put(String.format("%s, %s: %s", cardTo.getType(), L10nResourcesManager.getStr((String)"NAME", (Object[])new Object[0]), key == null ? "" : key.getDisplayName(LocaleHelper.getCurrentLocale())), (MiscUtil.Pair<String, String>)new MiscUtil.Pair((Object)oldTranslation, (Object)newTranslation));
        }
        DictSyncHelper.replaceDuplicateLocales((Map)cardTo.getShortNames().getValues());
        DictSyncHelper.replaceDuplicateLocales((Map)cardFrom.getShortNames().getValues());
        keys = CollectionUtil.union(cardTo.getShortNames().getValues().keySet(), cardFrom.getShortNames().getValues().keySet());
        for (Locale key : keys) {
            String newShortName;
            String oldShortName = (String)cardTo.getShortNames().getValues().get(key);
            if (TextUtil.isSame((String)oldShortName, (String)(newShortName = (String)cardFrom.getShortNames().getValues().get(key)))) continue;
            diffs.put(String.format("%s, %s: %s", cardTo.getType(), L10nResourcesManager.getStr((String)"SHORT_NAMES", (Object[])new Object[0]), key == null ? "" : key.getDisplayName(LocaleHelper.getCurrentLocale())), (MiscUtil.Pair<String, String>)new MiscUtil.Pair((Object)oldShortName, (Object)newShortName));
        }
        if (cardFrom.getRoute() != null && !cardFrom.getRoute().equals((Object)cardTo.getRoute())) {
            oldAndNewValues = new MiscUtil.Pair((Object)Objects.toString(cardTo.getRoute()), (Object)Objects.toString(cardFrom.getRoute()));
            diffs.put(String.format("%s, %s", cardTo.getType(), L10nResourcesManager.getStr((String)"RAILWAY_ROUTE", (Object[])new Object[0])), (MiscUtil.Pair<String, String>)oldAndNewValues);
        }
        if (cardFrom.getCountry() != null && !cardFrom.getCountry().equals((Object)cardTo.getCountry())) {
            oldAndNewValues = new MiscUtil.Pair((Object)Objects.toString(cardTo.getCountry()), (Object)Objects.toString(cardFrom.getCountry()));
            diffs.put(String.format("%s, %s", cardTo.getType(), L10nResourcesManager.getStr((String)"COUNTRY", (Object[])new Object[0])), (MiscUtil.Pair<String, String>)oldAndNewValues);
        }
        if (!cardTo.getSpellVariants().containsAll(cardFrom.getSpellVariants())) {
            oldAndNewValues = new MiscUtil.Pair((Object)String.join((CharSequence)", ", cardTo.getSpellVariants()), (Object)String.join((CharSequence)", ", cardFrom.getSpellVariants()));
            diffs.put(String.format("%s, %s", cardTo.getType(), L10nResourcesManager.getStr((String)"SPELL_VARIANTS", (Object[])new Object[0])), (MiscUtil.Pair<String, String>)oldAndNewValues);
        }
    }
}

